/*BEGIN_LEGAL 
Intel Open Source License 

Copyright (c) 2002-2015 Intel Corporation. All rights reserved.
 
Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.  Redistributions
in binary form must reproduce the above copyright notice, this list of
conditions and the following disclaimer in the documentation and/or
other materials provided with the distribution.  Neither the name of
the Intel Corporation nor the names of its contributors may be used to
endorse or promote products derived from this software without
specific prior written permission.
 
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE INTEL OR
ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
END_LEGAL */

#include <iostream>
#include <fstream>
#include <string.h>
#include "pin.H"
#include <list>

using namespace std;

ofstream OutFile;

bool main_flag;

// The running count of instructions is kept here
// make it static to help the compiler optimize icount
static UINT64 icount = 0;

list<char*> call_stack;

list<UINT64> ins_stack;


///////////////////////////////////////////////////////////////////////////////////////////////////////////
//--------------------------------------- RUN Time Functions --------------------------------------------//
///////////////////////////////////////////////////////////////////////////////////////////////////////////

VOID docount() 
{ 

if(main_flag == true)
{ 
	icount++;
}

}



//----------------------------------------------------------------------------------------------------------

VOID set_flag( UINT32 flag)
{
	main_flag = flag;
}

//----------------------------------------------------------------------------------------------------------

VOID fun_prof_before(VOID* name) 
{ 
if(main_flag == true)
{
	call_stack.push_back((char*)name);
	ins_stack.push_back(icount);
}
}

VOID fun_prof_after( )
{
// RTN rtn1 = *fun0;

if(main_flag == true)
{
 PIN_LockClient();
 //OutFile << RTN_Name(rtn1) << " # " << RTN_NumIns(rtn1) << endl;
 for (list<char*>::iterator it=call_stack.begin(); it!=call_stack.end() ; ++it)
   { 
    OutFile << "-> " << *it;
   }
   OutFile << " = " << icount-ins_stack.back() << endl;

call_stack.pop_back(); 
ins_stack.pop_back(); 

PIN_UnlockClient();
}

}
    
///////////////////////////////////////////////////////////////////////////////////////////////////////////
//--------------------------------------- Analysis Functions --------------------------------------------//
///////////////////////////////////////////////////////////////////////////////////////////////////////////


// Pin calls this function every time a new instruction is encountered
VOID Instruction(INS ins, VOID *v)
{
 // Insert a call to docount before every conditional Branch instruction, no arguments are passed
 INS_InsertCall(ins, IPOINT_BEFORE, (AFUNPTR)docount, IARG_END);
 
}


//----------------------------------------------------------------------------------------------------------
// Pin calls this function every time a new routine is encountered
VOID Check_Main(RTN rtn, VOID *v)
{
    RTN_Open(rtn);
    // Insert a call to docount before every instruction, no arguments are passed
    if( strcmp(RTN_Name(rtn).c_str(),"main") == 0)
	{  
		RTN_InsertCall(rtn,IPOINT_BEFORE,(AFUNPTR)set_flag,IARG_UINT32,1,IARG_END); 
 		RTN_InsertCall(rtn,IPOINT_AFTER,(AFUNPTR)set_flag,IARG_UINT32,0,IARG_END);
	
	}
	else
	{
	//RTN * x = new RTN(rtn);
	RTN_InsertCall(rtn,IPOINT_BEFORE,(AFUNPTR)fun_prof_before,IARG_PTR, RTN_Name(rtn).c_str(), IARG_END);

    	RTN_InsertCall(rtn,IPOINT_AFTER,(AFUNPTR)fun_prof_after, IARG_END);
	}
	
    RTN_Close(rtn);
}

//----------------------------------------------------------------------------------------------------------

/*
// Pin calls this function every time a new routine is encountered
VOID function_Profiler(RTN rtn, VOID *v)
{
 
    RTN_Open(rtn);

    RTN * x = new RTN(rtn);

    RTN_InsertCall(rtn,IPOINT_AFTER,(AFUNPTR)funtion_prof,IARG_PTR, x, IARG_END);	

    //OutFile << RTN_Name(rtn) << " # " << RTN_NumIns(rtn) << endl;
	
    RTN_Close(rtn);

}
*/

//////////////////////////////////////////////////////////////////////////////////////////////////////////


KNOB<string> KnobOutputFile(KNOB_MODE_WRITEONCE, "pintool",
    "o", "profile.out", "specify output file name");

// This function is called when the application exits
VOID Fini(INT32 code, VOID *v)
{
    // Write to a file since cout and cerr maybe closed by the application
    OutFile.setf(ios::showbase);
    OutFile << "Instruction Count " << icount << endl;
    OutFile.close();
}

/* ===================================================================== */
/* Print Help Message                                                    */
/* ===================================================================== */

INT32 Usage()
{
    cerr << "This tool counts the number of dynamic instructions executed" << endl;
    cerr << endl << KNOB_BASE::StringKnobSummary() << endl;
    return -1;
}

/* ===================================================================== */
/* Main                                                                  */
/* ===================================================================== */
/*   argc, argv are the entire command line: pin -t <toolname> -- ...    */
/* ===================================================================== */

int main(int argc, char * argv[])
{
    PIN_InitSymbols();

    // Initialize pin
    if (PIN_Init(argc, argv)) return Usage();

    OutFile.open(KnobOutputFile.Value().c_str());
    
    // Register Instruction to be called to instrument routines
    RTN_AddInstrumentFunction(Check_Main,0);  

    // Register Instruction to be called to instrument routines
    //RTN_AddInstrumentFunction(function_Profiler,0); 	

    // Register Instruction to be called to instrument instructions
    INS_AddInstrumentFunction(Instruction, 0);

    // Register Fini to be called when the application exits
    PIN_AddFiniFunction(Fini, 0);
    
    // Start the program, never returns
    PIN_StartProgram();
    
    return 0;
}
