#!/bin/bash

COLOR_CLEAR='\e[0m'
COLOR_RED='\e[31m'
COLOR_GREEN='\e[32m'
COLOR_BLUE='\e[34m'
COLOR_YELLOW='\e[33m'
COLOR_PURPLE='\e[35m'
COLOR_CYAN='\e[36m'


if [ $# -lt 2 ]
then
	echo "Seems like you forgot some arguments..."
	echo "Usage: $0 <Simulation Directory> <Configuration file (withour .cfg)>"
	exit

fi

chmod +x apps/dijkstra/dijkstra_small
chmod +x apps/gsm-untoast/untoast
chmod +x apps/qsort/qsort_small
chmod +x apps/jpeg-cjpeg/cjpeg
chmod +x apps/stringsearch/search_small


OVERALL_STARTTIME=`date +%s.%N`

tempfilename=.${OVERALL_STARTTIME}.txt


############################################################ dijkstra
echo -e "running app dijkstra"
error=1
while [ $error -gt 0 ]
do
  rm -f $tempfilename
  STARTTIME=`date +%s.%N`
  ./scripts/runsim_dijkstra.sh $1 $2 &> $tempfilename
  ENDTIME=`date +%s.%N`
  RUNTIME=$(echo "$ENDTIME - $STARTTIME" | bc)
  
  error=$(cat $tempfilename | fgrep abnormally | wc -w)
  if [ $error -gt 1 ]
  then
    echo -e "${COLOR_RED}jpeg simulation failed... Running again${COLOR_CLEAR}"
    sleep 1
  else
    echo -e "${COLOR_GREEN}dijkstra Simulation finished. Runtime: ${RUNTIME} seconds${COLOR_CLEAR}"
  fi
done


OVERALL_ENDTIME=`date +%s.%N`
OVERALL_RUNTIME=$(echo "$OVERALL_ENDTIME - $OVERALL_STARTTIME" | bc)
echo -e "${COLOR_GREEN}All Simulations finished. Runtime: ${OVERALL_RUNTIME} seconds${COLOR_CLEAR}"



#### Uncomment these lines to get a summary of the results in csv format (you can paste easily into excel or libreoffice calc)

 echo -e "${COLOR_YELLOW}Parsing Results:"
 echo -e "----------------------$1 $1 RESULTS ------------------------"
 ./scripts/parse_results.sh Results/$1 $2
 echo -e "${COLOR_CLEAR}"
