Library ieee;
USE ieee.std_logic_1164.ALL;
USE ieee.numeric_std.ALL; 

entity demux_16 is
       generic(n:integer := 16);
       port(
	     clk: in std_logic;
             input_data: in std_logic_vector(n-1 downto 0);
	     output_data0: out std_logic_vector(n-1 downto 0);   
             output_data1: out std_logic_vector(n-1 downto 0);
             output_data2: out std_logic_vector(n-1 downto 0);
             output_data3: out std_logic_vector(n-1 downto 0);
	     finish:out std_logic);
end entity demux_16;

architecture arch of demux_16 is

signal a: natural range 0 to 3 :=0;
signal finish_temp1:std_logic:='0';


begin
p0: process(clk)  
       begin
 	    if(rising_edge(clk)) then
	     
	         if a =3 then
                    a <=0;
                 else
                    a <=a + 1;
                 end if;
	        
	    end if;
	 		      
end process p0;

p1: process(a)
        begin
             case a is
	       when 0 => output_data0 <= input_data;  
                           finish_temp1 <='0'; 
                                      
               when 1 => output_data1 <= input_data;
                           finish_temp1 <='0'; 
               when 2 => output_data2 <= input_data;
                           finish_temp1 <='0'; 
               when 3 => output_data3 <= input_data;
                           finish_temp1 <='1'; 
               when others=> output_data0 <=input_data;
             end case;

end process p1;
       finish <= finish_temp1;  
end arch;

