library ieee;
USE ieee.std_logic_1164.ALL;
USE ieee.numeric_std.ALL; 
  

entity demux_tb is
end entity demux_tb;

architecture arch of demux_tb is
	
        signal clk_tb:std_logic:='0';
        signal input_data_tb:std_logic:='0';
        signal output_data_tb:std_logic_vector(3 downto 0);
       

        component demux_sync is 
	port( 
      
	      clk: in std_logic;
	      input_data: in std_logic;  
	      output_data: out std_logic_vector(3 downto 0));
                    
	end component demux_sync;

begin 
        demuxl_component:
	component demux_sync
	port map( 
	         
                  clk=>clk_tb,
                  input_data=>input_data_tb,
                  output_data=>output_data_tb);
                       
		

  	clkproc:
		process
			begin
			Wait for 50 ns;
			clk_tb<=not(clk_tb);
                        
		end process; 


                        input_data_tb<='0' ,
				       '1' after 500 ns,
                                       '0' after 550 ns,  --550ns 
                                       '1' after 850 ns, --850
                                       '0' after 950 ns, --950
				       '1' after 1000 ns,  --1000
				       '0' after 1050 ns,  --1050
                                       '1' after 1350 ns, --1350
                                       '0' after 1450 ns, --1450
                                       '1' after 1750 ns; --1750
				       

    test_proc:
		process
			begin
			wait for 50 ns;
			assert( output_data_tb= "0000")
			report "incorrect result"
			severity error;
			
		        wait for 450 ns; --500 ns
			assert( output_data_tb= "0000")
			report "incorrect result"
			severity error;

			wait for 500 ns; -- 1000 ns
			assert( output_data_tb= "0000")
			report "incorrect result"
			severity error;
                        
                        wait for 500 ns; -- 1000 ns
			assert( output_data_tb= "0000")
			report "incorrect result"
			severity error;

 
		end process;
end architecture arch;
			
			
			
			


