Library ieee;
USE ieee.std_logic_1164.ALL;
USE ieee.numeric_std.ALL; 

entity demux16_sync is
        generic(n:integer := 16);       
        port(
             clk: in std_logic;
	     output_data0: out std_logic_vector(n-1 downto 0);   
             output_data1: out std_logic_vector(n-1 downto 0);
             output_data2: out std_logic_vector(n-1 downto 0);
             output_data3: out std_logic_vector(n-1 downto 0);
             input_data: in std_logic_vector(n-1 downto 0));
end entity demux16_sync;

architecture arch_demux16 of demux16_sync is
      component demux_16 is 
        generic(n:integer := 16); 
	port( 
             clk: in std_logic;
	     output_data0: out std_logic_vector(n-1 downto 0);   
             output_data1: out std_logic_vector(n-1 downto 0);
             output_data2: out std_logic_vector(n-1 downto 0);
             output_data3: out std_logic_vector(n-1 downto 0);
             input_data: in std_logic_vector(n-1 downto 0));
                    
	end component demux_16;


signal demux16_data0:std_logic_vector(n-1 downto 0):="0000000000000000";

signal demux16_data1:std_logic_vector(n-1 downto 0):="0000000000000000";

signal demux16_data2:std_logic_vector(n-1 downto 0):="0000000000000000";

signal demux16_data3:std_logic_vector(n-1 downto 0):="0000000000000000";

signal a: natural range 0 to 3 :=0;

begin

        demux16_sync_component:
	component demux_16
	port map( 
	         
                  clk=>clk,
                  output_data0=>demux16_data0,
                  output_data1=>demux16_data1,
                  output_data2=>demux16_data2,
                  output_data3=>demux16_data3,
                  input_data=>input_data);





p0: process(clk)  
       begin
 	    if(falling_edge(clk)) then
	     
	         if a =3 then
                    a <=0;
                 else
                    a <=a+ 1;
                 end if;
	      
	    end if;
	 		      
end process p0;





p3: process(a , clk)
begin
 	if(rising_edge(clk)) then
            if a = 0 then
		output_data0 <= demux16_data0; 
                output_data1 <= demux16_data1;
                output_data2 <= demux16_data2;
                output_data3 <= demux16_data3;
            end if;
end if;
		
          
end process p3;
end arch_demux16;

