LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;

ENTITY clk_enable IS
	GENERIC (n : INTEGER := 1);
	PORT(reset : IN STD_LOGIC;
	     clk : IN STD_LOGIC;
	     clk_generic : OUT STD_LOGIC;	
	     clk_6M : OUT STD_LOGIC;
	     clk_250K : OUT STD_LOGIC);
END clk_enable;

ARCHITECTURE arch_clk_enable OF clk_enable IS

	SIGNAL counter_generic : INTEGER := n;	-- assigned initial value to reduce memory occupation
	SIGNAL counter_6M : INTEGER := 17;
	SIGNAL counter_250K : INTEGER := 408;	

BEGIN
	-- Sampling clk GENERIC
	clk_generic_process : PROCESS(reset, clk)
	BEGIN
		IF (reset='1') THEN
			clk_generic <= '0';
			counter_generic <= n;
		ELSIF (rising_edge(clk)) THEN
			IF (counter_generic = 1) THEN
				clk_generic <= '1';
				counter_generic <= n;
			ELSE
				clk_generic <='0';
				counter_generic <= counter_generic - 1;
			END IF;
		END IF;
	END PROCESS clk_generic_process;

	-- Sampling clk 6 MHz (167->170 ns)
	clk_6M_process : PROCESS(reset, clk)
	BEGIN
		IF (reset='1') THEN
			clk_6M <= '0';
			counter_6M <= 17;
		ELSIF (rising_edge(clk)) THEN
			IF (counter_6M = 1) THEN
				clk_6M <= '1';
				counter_6M <= 17;
			ELSE
				clk_6M <='0';
				counter_6M <= counter_6M - 1;
			END IF;
		END IF;
	END PROCESS clk_6M_process;

	clk_250K_process : PROCESS(reset, clk)
	BEGIN
		IF (reset='1') THEN
			clk_250K <= '0';
			counter_250K <= 408;
		ELSIF (rising_edge(clk)) THEN
			IF (counter_250K = 1) THEN
				clk_250K <= '1';
				counter_250K <= 408;
			ELSE
				clk_250K <='0';
				counter_250K <= counter_250K - 1;
			END IF;
		END IF;
	END PROCESS clk_250K_process;
	
END arch_clk_enable;