-------------------------------------------------------------------------------
-- $Id:$
-------------------------------------------------------------------------------
-- coregen_comp_defs - entity/architecture pair
-------------------------------------------------------------------------------
--
-- *************************************************************************
-- **                                                                     **
-- ** DISCLAIMER OF LIABILITY                                             **
-- **                                                                     **
-- ** This text/file contains proprietary, confidential                   **
-- ** information of Xilinx, Inc., is distributed under                   **
-- ** license from Xilinx, Inc., and may be used, copied                  **
-- ** and/or disclosed only pursuant to the terms of a valid              **
-- ** license agreement with Xilinx, Inc. Xilinx hereby                   **
-- ** grants you a license to use this text/file solely for               **
-- ** design, simulation, implementation and creation of                  **
-- ** design files limited to Xilinx devices or technologies.             **
-- ** Use with non-Xilinx devices or technologies is expressly            **
-- ** prohibited and immediately terminates your license unless           **
-- ** covered by a separate agreement.                                    **
-- **                                                                     **
-- ** Xilinx is providing this design, code, or information               **
-- ** "as-is" solely for use in developing programs and                   **
-- ** solutions for Xilinx devices, with no obligation on the             **
-- ** part of Xilinx to provide support. By providing this design,        **
-- ** code, or information as one possible implementation of              **
-- ** this feature, application or standard, Xilinx is making no          **
-- ** representation that this implementation is free from any            **
-- ** claims of infringement. You are responsible for obtaining           **
-- ** any rights you may require for your implementation.                 **
-- ** Xilinx expressly disclaims any warranty whatsoever with             **
-- ** respect to the adequacy of the implementation, including            **
-- ** but not limited to any warranties or representations that this      **
-- ** implementation is free from claims of infringement, implied         **
-- ** warranties of merchantability or fitness for a particular           **
-- ** purpose.                                                            **
-- **                                                                     **
-- ** Xilinx products are not intended for use in life support            **
-- ** appliances, devices, or systems. Use in such applications is        **
-- ** expressly prohibited.                                               **
-- **                                                                     **
-- ** Any modifications that are made to the Source Code are              **
-- ** done at the users sole risk and will be unsupported.               **
-- ** The Xilinx Support Hotline does not have access to source           **
-- ** code and therefore cannot answer specific questions related         **
-- ** to source HDL. The Xilinx Hotline support of original source        **
-- ** code IP shall only address issues and questions related             **
-- ** to the standard Netlist version of the core (and thus               **
-- ** indirectly, the original core source).                              **
-- **                                                                     **
-- ** Copyright (c) 2008-2010 Xilinx, Inc. All rights reserved.           **
-- **                                                                     **
-- ** This copyright and support notice must be retained as part          **
-- ** of this text at all times.                                          **
-- **                                                                     **
-- *************************************************************************
--
-------------------------------------------------------------------------------
-- Filename:        coregen_comp_defs.vhd
-- Version:         initial
-- Description:     
--   Component declarations for all black box netlists generated by
--   running COREGEN and FIFO Generator when XST elaborated the client core
--
--
--
-- VHDL-Standard:   VHDL'93
-------------------------------------------------------------------------------
-- Structure:   
--                      -- coregen_comp_defs.vhd
--                          |
--                          |--- XilinxCoreLib.fifo_generator_v4_2 
--                          |
--                          |--- XilinxCoreLib.fifo_generator_v4_3 
--                          |
--                          |--- XilinxCoreLib.blk_mem_gen_v2_7 
--                          |
--                          |--- XilinxCoreLib.fifo_generator_v5_1
--                          |--- XilinxCoreLib.fifo_generator_v5_2
--                          |--- XilinxCoreLib.fifo_generator_v5_3
--                          |--- XilinxCoreLib.fifo_generator_v6_1
--                          |--- XilinxCoreLib.fifo_generator_v8_1
--                          |--- XilinxCoreLib.fifo_generator_v8_2
--                          |--- XilinxCoreLib.fifo_generator_v8_3
--                          |
--                          |--- XilinxCoreLib.blk_mem_gen_v3_1
--                          |--- XilinxCoreLib.blk_mem_gen_v3_2
--                          |--- XilinxCoreLib.blk_mem_gen_v3_3
--                          |--- XilinxCoreLib.blk_mem_gen_v4_1
--                          |--- XilinxCoreLib.blk_mem_gen_v5_2
--                          |--- XilinxCoreLib.blk_mem_gen_v6_2
--
-------------------------------------------------------------------------------
-- Author:          DET
-- History:
--   DET           02/01/2008    Initial Version
--
--     DET     2/01/2008     for axi_xadc_v1_00_a_proc_common_v3_00_a
-- ~~~~~~
--     - Adapted coregen_comp_defs.vhd from proc_common_v2_00_a to create 
--       this file.
--     - Changed instance of sync fifo to use new wrapper file that will adapt
--       to FIFO Generator primitive.
--     - Replaced "edk_generatecore" with "generatecore" utility call
--     - Removed the CAM component
-- ^^^^^^
--
--     DET     7/30/2008     for EDK 11.1
-- ~~~~~~
--     - Added component for Fifo Generator version 4.3
--     - Added Block Memory Generator Component Version 2.7
-- ^^^^^^
--
--     MSH     2/26/2009     for EDK 11.1
-- ~~~~~~
--     - Added component for Fifo Generator version 5.1
--     - Added Block Memory Generator Component Version 3.1
-- ^^^^^^
--
--     DET     3/2/2009     for EDK 11.1
-- ~~~~~~
--     - Added new Parameters and ports for Fifo Generatore 5.1.
-- ^^^^^^
--
--     DET     3/30/2009     EDK 11.2
-- ~~~~~~
--     - Had to reorder parameter list of FIFO Generator 4.3 component to match
--       the corresponding Verilog model due to NCSIM positional order
--       dependancy of parameters in vhdl/verilog use case.
-- ^^^^^^
--
--     DET     4/8/2009     EDK 11.2
-- ~~~~~~
--     - Added blk_mem_gen_v3_2
-- ^^^^^^
--
--     DET     4/9/2009     EDK 11.2
-- ~~~~~~
--     - Added fifo_generator_v5_2
-- ^^^^^^
--
--     DET     2/9/2010     For EDK 12.1
-- ~~~~~~
--     - Added fifo_generator_v5_3
--     - Added blk_mem_gen_v3_3
-- ^^^^^^
--
--     DET     3/10/2010     For EDK 12.x
-- ~~~~~~
--   -- Per CR553307
--     - Added fifo_generator_v6_1
--     - Added blk_mem_gen_v4_1
-- ^^^^^^
--
--     DET     3/17/2010     Initial
-- ~~~~~~
--    -- Per CR554253
--     - Incorporated changes to comment out FLOP_DELAY parameter from the 
--       blk_mem_gen_v4_1 component. This parameter is on the XilinxCoreLib
--       model for blk_mem_gen_v4_1 but is declared as a TIME type for the
--       vhdl version and an integer for the verilog. 
-- ^^^^^^
--
--     DET     10/04/2010     EDK 13.1
-- ~~~~~~
--     - Added fifo_generator_v7_3
--     - Added blk_mem_gen_v5_2
-- ^^^^^^
--
--     DET     12/8/2010     EDK 13.1
-- ~~~~~~
--    -- Per CR586109
--     - Replaced fifo_generator v7.3 with v8.1
--     - Added blk_mem_gen_v6_1
-- ^^^^^^
--
--     DET     12/17/2010     EDK 13.1
-- ~~~~~~
--    -- Per CR587494
--     - Removed blk_mem_gen v6_1
-- ^^^^^^
--
--     DET     3/2/2011     EDK 13.2
-- ~~~~~~
--    -- Per CR595473
--     - Update to use fifo_generator_v8_2
--     - Update to use blk_mem_gen_v6_2
--     - Remove out of date components.
-- ^^^^^^
--
--     DET     3/3/2011     EDK 13.2
-- ~~~~~~
--     - Removed C_ELABORATION_DIR parameter from the component decalarion
-- ^^^^^^
--
--     DET     3/7/2011     EDK 13.2
-- ~~~~~~
--    -- Per CR596052
--     - Added removed fifo generator and Blk Mem Gen components back into
--       coregen_comp_defs.  
-- ^^^^^^
--
--     RBODDU  08/18/2011     EDK 13.3
-- ~~~~~~
--     - Update to use fifo_generator_v8_3
-- ^^^^^^
--
-------------------------------------------------------------------------------
LIBRARY ieee;
USE ieee.std_logic_1164.ALL;

PACKAGE coregen_comp_defs IS

 
 
 
--------------------------------------------------------  
-- Declare general attributes used in this file
-- for defining each component being used with 
-- the generatecore utility

attribute box_type: string;
attribute GENERATOR_DEFAULT: string;

-------------------------------------------------------



 
-------------------------------------------------------------------------------------
-- Start FIFO Generator Component for V4_2
-- Component declaration for V4_2 pulled from the K.30\rtf\vhdl\src\XilinxCoreLib
-- file: fifo_generator_v4_2_comp.vhd
-- This component is used for both dual clock (async) and synchronous fifos 
-- implemented with BRAM or distributed RAM. Hard FIFO simulation support is not
-- provided in FIFO Generator V4.2 so don't use this for Hard Block FIFOs.
-------------------------------------------------------------------------------------
 COMPONENT fifo_generator_v4_2
  GENERIC (
    --------------------------------------------------------------------------------
    -- Generic Declarations (alphabetical)
    --------------------------------------------------------------------------------
    C_COMMON_CLOCK                : integer := 0;
    C_COUNT_TYPE                  : integer := 0;
    C_DATA_COUNT_WIDTH            : integer := 2;
    C_DEFAULT_VALUE               : string  := "";
    C_DIN_WIDTH                   : integer := 8;
    C_DOUT_RST_VAL                : string  := "";
    C_DOUT_WIDTH                  : integer := 8;
    C_ENABLE_RLOCS                : integer := 0;
    C_FAMILY                      : string  := "";
    C_HAS_ALMOST_EMPTY            : integer := 0;
    C_HAS_ALMOST_FULL             : integer := 0;
    C_HAS_BACKUP                  : integer := 0;
    C_HAS_DATA_COUNT              : integer := 0;
    C_HAS_MEMINIT_FILE            : integer := 0;
    C_HAS_OVERFLOW                : integer := 0;
    C_HAS_RD_DATA_COUNT           : integer := 0;
    C_HAS_RD_RST                  : integer := 0;
    C_HAS_RST                     : integer := 1;
    C_HAS_SRST                    : integer := 0;
    C_HAS_UNDERFLOW               : integer := 0;
    C_HAS_VALID                   : integer := 0;
    C_HAS_WR_ACK                  : integer := 0;
    C_HAS_WR_DATA_COUNT           : integer := 0;
    C_HAS_WR_RST                  : integer := 0;
    C_IMPLEMENTATION_TYPE         : integer := 0;
    C_INIT_WR_PNTR_VAL            : integer := 0;
    C_MEMORY_TYPE                 : integer := 1;
    C_MIF_FILE_NAME               : string  := "";
    C_OPTIMIZATION_MODE           : integer := 0;
    C_OVERFLOW_LOW                : integer := 0;
    C_PRELOAD_REGS                : integer := 0;
    C_PRELOAD_LATENCY             : integer := 1;
    C_PRIM_FIFO_TYPE              : string  := "4kx4";
    C_PROG_EMPTY_THRESH_ASSERT_VAL: integer := 0;
    C_PROG_EMPTY_THRESH_NEGATE_VAL: integer := 0;
    C_PROG_EMPTY_TYPE             : integer := 0;
    C_PROG_FULL_THRESH_ASSERT_VAL : integer := 0;
    C_PROG_FULL_THRESH_NEGATE_VAL : integer := 0;
    C_PROG_FULL_TYPE              : integer := 0;
    C_RD_DATA_COUNT_WIDTH         : integer := 2;
    C_RD_DEPTH                    : integer := 256;
    C_RD_FREQ                     : integer := 1;
    C_RD_PNTR_WIDTH               : integer := 8;
    C_UNDERFLOW_LOW               : integer := 0;
    C_USE_DOUT_RST                : integer := 0;
    C_USE_EMBEDDED_REG            : integer := 0;
    C_USE_FIFO16_FLAGS            : integer := 0;
    C_USE_FWFT_DATA_COUNT         : integer := 0;
    C_VALID_LOW                   : integer := 0;
    C_WR_ACK_LOW                  : integer := 0;
    C_WR_DATA_COUNT_WIDTH         : integer := 2;
    C_WR_DEPTH                    : integer := 256;
    C_WR_FREQ                     : integer := 1;
    C_WR_PNTR_WIDTH               : integer := 8;
    C_WR_RESPONSE_LATENCY         : integer := 1;
    C_USE_ECC                     : integer := 0;
    C_FULL_FLAGS_RST_VAL          : integer := 1;
    C_HAS_INT_CLK                 : integer := 0
    );


  PORT(
--------------------------------------------------------------------------------
-- Input and Output Declarations
--------------------------------------------------------------------------------
    CLK                       : IN  std_logic := '0';
    BACKUP                    : IN  std_logic := '0';
    BACKUP_MARKER             : IN  std_logic := '0';
    DIN                       : IN  std_logic_vector(C_DIN_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    PROG_EMPTY_THRESH         : IN  std_logic_vector(C_RD_PNTR_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    PROG_EMPTY_THRESH_ASSERT  : IN  std_logic_vector(C_RD_PNTR_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    PROG_EMPTY_THRESH_NEGATE  : IN  std_logic_vector(C_RD_PNTR_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    PROG_FULL_THRESH          : IN  std_logic_vector(C_WR_PNTR_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    PROG_FULL_THRESH_ASSERT   : IN  std_logic_vector(C_WR_PNTR_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    PROG_FULL_THRESH_NEGATE   : IN  std_logic_vector(C_WR_PNTR_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    RD_CLK                    : IN  std_logic := '0';
    RD_EN                     : IN  std_logic := '0';
    RD_RST                    : IN  std_logic := '0';
    RST                       : IN  std_logic := '0';
    SRST                      : IN  std_logic := '0';
    WR_CLK                    : IN  std_logic := '0';
    WR_EN                     : IN  std_logic := '0';
    WR_RST                    : IN  std_logic := '0';
    INT_CLK                   : IN  std_logic := '0';

    ALMOST_EMPTY              : OUT std_logic;
    ALMOST_FULL               : OUT std_logic;
    DATA_COUNT                : OUT std_logic_vector(C_DATA_COUNT_WIDTH-1 DOWNTO 0);
    DOUT                      : OUT std_logic_vector(C_DOUT_WIDTH-1 DOWNTO 0);
    EMPTY                     : OUT std_logic;
    FULL                      : OUT std_logic;
    OVERFLOW                  : OUT std_logic;
    PROG_EMPTY                : OUT std_logic;
    PROG_FULL                 : OUT std_logic;
    VALID                     : OUT std_logic;
    RD_DATA_COUNT             : OUT std_logic_vector(C_RD_DATA_COUNT_WIDTH-1 DOWNTO 0);
    UNDERFLOW                 : OUT std_logic;
    WR_ACK                    : OUT std_logic;
    WR_DATA_COUNT             : OUT std_logic_vector(C_WR_DATA_COUNT_WIDTH-1 DOWNTO 0);
    SBITERR                   : OUT std_logic;
    DBITERR                   : OUT std_logic
    );
 END COMPONENT;


-- The following attributes tells XST that the fifo_generator_v4_2 is a black box
-- which should be generated using the command given by the value of this attribute
attribute box_type of fifo_generator_v4_2: component is "black_box";
attribute GENERATOR_DEFAULT of fifo_generator_v4_2: component is 
     "generatecore com.xilinx.ip.fifo_generator_v4_2.fifo_generator_v4_2 -a map_qvirtex_to=virtex map_qrvirtex_to=virtex map_virtexe_to=virtex map_qvirtex2_to=virtex2 map_qrvirtex2_to=virtex2 map_spartan2_to=virtex map_spartan2e_to=virtex map_virtex5_to=virtex4 map_spartan3a_to=spartan3e spartan3an_to=spartan3e spartan3adsp_to=spartan3e ";

-- End FIFO Generator 4.2 Component ---------------------------------------



-------------------------------------------------------------------------------------
-- Start FIFO Generator Component for V4_3
-- Component declaration for V4_3 pulled from the L.16\rtf\vhdl\src\XilinxCoreLib
-- file: fifo_generator_v4_3_comp.vhd
-- This component is used for both dual clock (async) and synchronous fifos 
-- implemented with BRAM or distributed RAM. Hard FIFO simulation support is not
-- provided in FIFO Generator V4.3 so don't use this for Hard Block FIFOs.
-------------------------------------------------------------------------------------
 COMPONENT fifo_generator_v4_3
  GENERIC (
    --------------------------------------------------------------------------------
    -- Generic Declarations (alphabetical)
    --------------------------------------------------------------------------------
    C_COMMON_CLOCK                : integer := 0;
    C_COUNT_TYPE                  : integer := 0;
    C_DATA_COUNT_WIDTH            : integer := 2;
    C_DEFAULT_VALUE               : string  := "";
    C_DIN_WIDTH                   : integer := 8;
    C_DOUT_RST_VAL                : string  := "";
    C_DOUT_WIDTH                  : integer := 8;
    C_ENABLE_RLOCS                : integer := 0;
    C_FAMILY                      : string  := "";
    C_FULL_FLAGS_RST_VAL          : integer := 1;
    C_HAS_ALMOST_EMPTY            : integer := 0;
    C_HAS_ALMOST_FULL             : integer := 0;
    C_HAS_BACKUP                  : integer := 0;
    C_HAS_DATA_COUNT              : integer := 0;
    C_HAS_INT_CLK                 : integer := 0;
    C_HAS_MEMINIT_FILE            : integer := 0;
    C_HAS_OVERFLOW                : integer := 0;
    C_HAS_RD_DATA_COUNT           : integer := 0;
    C_HAS_RD_RST                  : integer := 0;
    C_HAS_RST                     : integer := 1;
    C_HAS_SRST                    : integer := 0;
    C_HAS_UNDERFLOW               : integer := 0;
    C_HAS_VALID                   : integer := 0;
    C_HAS_WR_ACK                  : integer := 0;
    C_HAS_WR_DATA_COUNT           : integer := 0;
    C_HAS_WR_RST                  : integer := 0;
    C_IMPLEMENTATION_TYPE         : integer := 0;
    C_INIT_WR_PNTR_VAL            : integer := 0;
    C_MEMORY_TYPE                 : integer := 1;
    C_MIF_FILE_NAME               : string  := "";
    C_OPTIMIZATION_MODE           : integer := 0;
    C_OVERFLOW_LOW                : integer := 0;
    C_PRELOAD_LATENCY             : integer := 1;
    C_PRELOAD_REGS                : integer := 0;
    C_PRIM_FIFO_TYPE              : string  := "4kx4";
    C_PROG_EMPTY_THRESH_ASSERT_VAL: integer := 0;
    C_PROG_EMPTY_THRESH_NEGATE_VAL: integer := 0;
    C_PROG_EMPTY_TYPE             : integer := 0;
    C_PROG_FULL_THRESH_ASSERT_VAL : integer := 0;
    C_PROG_FULL_THRESH_NEGATE_VAL : integer := 0;
    C_PROG_FULL_TYPE              : integer := 0;
    C_RD_DATA_COUNT_WIDTH         : integer := 2;
    C_RD_DEPTH                    : integer := 256;
    C_RD_FREQ                     : integer := 1;
    C_RD_PNTR_WIDTH               : integer := 8;
    C_UNDERFLOW_LOW               : integer := 0;
    C_USE_DOUT_RST                : integer := 0;
    C_USE_ECC                     : integer := 0;
    C_USE_EMBEDDED_REG            : integer := 0;
    C_USE_FIFO16_FLAGS            : integer := 0;
    C_USE_FWFT_DATA_COUNT         : integer := 0;
    C_VALID_LOW                   : integer := 0;
    C_WR_ACK_LOW                  : integer := 0;
    C_WR_DATA_COUNT_WIDTH         : integer := 2;
    C_WR_DEPTH                    : integer := 256;
    C_WR_FREQ                     : integer := 1;
    C_WR_PNTR_WIDTH               : integer := 8;
    C_WR_RESPONSE_LATENCY         : integer := 1;
    C_MSGON_VAL                   : integer := 1
    );
  PORT(
--------------------------------------------------------------------------------
-- Input and Output Declarations
--------------------------------------------------------------------------------
    CLK                       : IN  std_logic := '0';
    BACKUP                    : IN  std_logic := '0';
    BACKUP_MARKER             : IN  std_logic := '0';
    DIN                       : IN  std_logic_vector(C_DIN_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    PROG_EMPTY_THRESH         : IN  std_logic_vector(C_RD_PNTR_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    PROG_EMPTY_THRESH_ASSERT  : IN  std_logic_vector(C_RD_PNTR_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    PROG_EMPTY_THRESH_NEGATE  : IN  std_logic_vector(C_RD_PNTR_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    PROG_FULL_THRESH          : IN  std_logic_vector(C_WR_PNTR_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    PROG_FULL_THRESH_ASSERT   : IN  std_logic_vector(C_WR_PNTR_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    PROG_FULL_THRESH_NEGATE   : IN  std_logic_vector(C_WR_PNTR_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    RD_CLK                    : IN  std_logic := '0';
    RD_EN                     : IN  std_logic := '0';
    RD_RST                    : IN  std_logic := '0';
    RST                       : IN  std_logic := '0';
    SRST                      : IN  std_logic := '0';
    WR_CLK                    : IN  std_logic := '0';
    WR_EN                     : IN  std_logic := '0';
    WR_RST                    : IN  std_logic := '0';
    INT_CLK                   : IN  std_logic := '0';

    ALMOST_EMPTY              : OUT std_logic;
    ALMOST_FULL               : OUT std_logic;
    DATA_COUNT                : OUT std_logic_vector(C_DATA_COUNT_WIDTH-1 DOWNTO 0);
    DOUT                      : OUT std_logic_vector(C_DOUT_WIDTH-1 DOWNTO 0);
    EMPTY                     : OUT std_logic;
    FULL                      : OUT std_logic;
    OVERFLOW                  : OUT std_logic;
    PROG_EMPTY                : OUT std_logic;
    PROG_FULL                 : OUT std_logic;
    VALID                     : OUT std_logic;
    RD_DATA_COUNT             : OUT std_logic_vector(C_RD_DATA_COUNT_WIDTH-1 DOWNTO 0);
    UNDERFLOW                 : OUT std_logic;
    WR_ACK                    : OUT std_logic;
    WR_DATA_COUNT             : OUT std_logic_vector(C_WR_DATA_COUNT_WIDTH-1 DOWNTO 0);
    SBITERR                   : OUT std_logic;
    DBITERR                   : OUT std_logic
    );
 END COMPONENT;


-- The following attributes tells XST that the fifo_generator_v4_3 is a black box
-- which should be generated using the command given by the value
-- of this attribute
attribute box_type of fifo_generator_v4_3: component is "black_box";
attribute GENERATOR_DEFAULT of fifo_generator_v4_3: component is 
     "generatecore com.xilinx.ip.fifo_generator_v4_3.fifo_generator_v4_3 -a map_qvirtex_to=virtex map_qrvirtex_to=virtex map_virtexe_to=virtex map_qvirtex2_to=virtex2 map_qrvirtex2_to=virtex2 map_spartan2_to=virtex map_spartan2e_to=virtex map_virtex5_to=virtex4 map_spartan3a_to=spartan3e spartan3an_to=spartan3e spartan3adsp_to=spartan3e ";

-- End FIFO Generator 4.3 Component ---------------------------------------

-------------------------------------------------------------------------------------
-- Start FIFO Generator Component for V5_1
-- Component declaration for V5_1 pulled from the L.16\rtf\vhdl\src\XilinxCoreLib
-- file: fifo_generator_v5_1_comp.vhd
-- This component is used for both dual clock (async) and synchronous fifos 
-- implemented with BRAM or distributed RAM. Hard FIFO simulation support is not
-- provided in FIFO Generator V4.3 so don't use this for Hard Block FIFOs.
-------------------------------------------------------------------------------------
 COMPONENT fifo_generator_v5_1
  GENERIC (
    --------------------------------------------------------------------------------
    -- Generic Declarations (alphabetical)
    --------------------------------------------------------------------------------
    C_COMMON_CLOCK                : integer := 0;
    C_COUNT_TYPE                  : integer := 0;
    C_DATA_COUNT_WIDTH            : integer := 2;
    C_DEFAULT_VALUE               : string  := "";
    C_DIN_WIDTH                   : integer := 8;
    C_DOUT_RST_VAL                : string  := "";
    C_DOUT_WIDTH                  : integer := 8;
    C_ENABLE_RLOCS                : integer := 0;
    C_FAMILY                      : string  := "";
    C_HAS_ALMOST_EMPTY            : integer := 0;
    C_HAS_ALMOST_FULL             : integer := 0;
    C_HAS_BACKUP                  : integer := 0;
    C_HAS_DATA_COUNT              : integer := 0;
    C_HAS_MEMINIT_FILE            : integer := 0;
    C_HAS_OVERFLOW                : integer := 0;
    C_HAS_RD_DATA_COUNT           : integer := 0;
    C_HAS_RD_RST                  : integer := 0;
    C_HAS_RST                     : integer := 1;
    C_HAS_SRST                    : integer := 0;
    C_HAS_UNDERFLOW               : integer := 0;
    C_HAS_VALID                   : integer := 0;
    C_HAS_WR_ACK                  : integer := 0;
    C_HAS_WR_DATA_COUNT           : integer := 0;
    C_HAS_WR_RST                  : integer := 0;
    C_IMPLEMENTATION_TYPE         : integer := 0;
    C_INIT_WR_PNTR_VAL            : integer := 0;
    C_MEMORY_TYPE                 : integer := 1;
    C_MIF_FILE_NAME               : string  := "";
    C_OPTIMIZATION_MODE           : integer := 0;
    C_OVERFLOW_LOW                : integer := 0;
    C_PRELOAD_REGS                : integer := 0;
    C_PRELOAD_LATENCY             : integer := 1;
    C_PRIM_FIFO_TYPE              : string  := "4kx4";
    C_PROG_EMPTY_THRESH_ASSERT_VAL: integer := 0;
    C_PROG_EMPTY_THRESH_NEGATE_VAL: integer := 0;
    C_PROG_EMPTY_TYPE             : integer := 0;
    C_PROG_FULL_THRESH_ASSERT_VAL : integer := 0;
    C_PROG_FULL_THRESH_NEGATE_VAL : integer := 0;
    C_PROG_FULL_TYPE              : integer := 0;
    C_RD_DATA_COUNT_WIDTH         : integer := 2;
    C_RD_DEPTH                    : integer := 256;
    C_RD_FREQ                     : integer := 1;
    C_RD_PNTR_WIDTH               : integer := 8;
    C_UNDERFLOW_LOW               : integer := 0;
    C_USE_DOUT_RST                : integer := 0;
    C_USE_EMBEDDED_REG            : integer := 0;
    C_USE_FIFO16_FLAGS            : integer := 0;
    C_USE_FWFT_DATA_COUNT         : integer := 0;
    C_VALID_LOW                   : integer := 0;
    C_WR_ACK_LOW                  : integer := 0;
    C_WR_DATA_COUNT_WIDTH         : integer := 2;
    C_WR_DEPTH                    : integer := 256;
    C_WR_FREQ                     : integer := 1;
    C_WR_PNTR_WIDTH               : integer := 8;
    C_WR_RESPONSE_LATENCY         : integer := 1;
    C_USE_ECC                     : integer := 0;
    C_FULL_FLAGS_RST_VAL          : integer := 1;
    C_HAS_INT_CLK                 : integer := 0;
    C_MSGON_VAL                   : integer := 1;
    C_ENABLE_RST_SYNC             : integer := 1;  -- New FG 5.1
    C_ERROR_INJECTION_TYPE        : integer := 0   -- New FG 5.1
    );
  PORT(
--------------------------------------------------------------------------------
-- Input and Output Declarations
--------------------------------------------------------------------------------
    CLK                       : IN  std_logic := '0';
    BACKUP                    : IN  std_logic := '0';
    BACKUP_MARKER             : IN  std_logic := '0';
    DIN                       : IN  std_logic_vector(C_DIN_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    PROG_EMPTY_THRESH         : IN  std_logic_vector(C_RD_PNTR_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    PROG_EMPTY_THRESH_ASSERT  : IN  std_logic_vector(C_RD_PNTR_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    PROG_EMPTY_THRESH_NEGATE  : IN  std_logic_vector(C_RD_PNTR_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    PROG_FULL_THRESH          : IN  std_logic_vector(C_WR_PNTR_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    PROG_FULL_THRESH_ASSERT   : IN  std_logic_vector(C_WR_PNTR_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    PROG_FULL_THRESH_NEGATE   : IN  std_logic_vector(C_WR_PNTR_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    RD_CLK                    : IN  std_logic := '0';
    RD_EN                     : IN  std_logic := '0';
    RD_RST                    : IN  std_logic := '0';
    RST                       : IN  std_logic := '0';
    SRST                      : IN  std_logic := '0';
    WR_CLK                    : IN  std_logic := '0';
    WR_EN                     : IN  std_logic := '0';
    WR_RST                    : IN  std_logic := '0';
    INT_CLK                   : IN  std_logic := '0';
    INJECTDBITERR             : IN  std_logic := '0'; -- New FG 5.1 
    INJECTSBITERR             : IN  std_logic := '0'; -- New FG 5.1 

    ALMOST_EMPTY              : OUT std_logic;
    ALMOST_FULL               : OUT std_logic;
    DATA_COUNT                : OUT std_logic_vector(C_DATA_COUNT_WIDTH-1 DOWNTO 0);
    DOUT                      : OUT std_logic_vector(C_DOUT_WIDTH-1 DOWNTO 0);
    EMPTY                     : OUT std_logic;
    FULL                      : OUT std_logic;
    OVERFLOW                  : OUT std_logic;
    PROG_EMPTY                : OUT std_logic;
    PROG_FULL                 : OUT std_logic;
    VALID                     : OUT std_logic;
    RD_DATA_COUNT             : OUT std_logic_vector(C_RD_DATA_COUNT_WIDTH-1 DOWNTO 0);
    UNDERFLOW                 : OUT std_logic;
    WR_ACK                    : OUT std_logic;
    WR_DATA_COUNT             : OUT std_logic_vector(C_WR_DATA_COUNT_WIDTH-1 DOWNTO 0);
    SBITERR                   : OUT std_logic;
    DBITERR                   : OUT std_logic
    );
 END COMPONENT;


-- The following attributes tells XST that the fifo_generator_v5_1 is a black box
-- which should be generated using the command given by the value
-- of this attribute
attribute box_type of fifo_generator_v5_1: component is "black_box";
attribute GENERATOR_DEFAULT of fifo_generator_v5_1: component is 
     "generatecore com.xilinx.ip.fifo_generator_v5_1.fifo_generator_v5_1 -a map_qvirtex_to=virtex map_qrvirtex_to=virtex map_virtexe_to=virtex map_qvirtex2_to=virtex2 map_qrvirtex2_to=virtex2 map_spartan2_to=virtex map_spartan2e_to=virtex map_virtex5_to=virtex4 map_spartan3a_to=spartan3e spartan3an_to=spartan3e spartan3adsp_to=spartan3e ";

-- End FIFO Generator Component ---------------------------------------





-------------------------------------------------------------------------------------
-- Start FIFO Generator Component for V5_2
-- The Component declaration for V5_2 pulled from the L.38\rtf\vhdl\src\XilinxCoreLib
-- file: fifo_generator_v5_1_comp.vhd. 
-- However, to support NCSIM, Params and Ports are ordered to match the verilog 
-- definition in L.38\rtf\verilog\src\XilinxCoreLib\fifo_generator_v5_2.v .
--
-- This component is used for both dual clock (async) and synchronous fifos 
-- implemented with BRAM or distributed RAM. Hard FIFO simulation support may not
-- be provided in FIFO Generator V5.2 so not supported here.
-------------------------------------------------------------------------------------
 COMPONENT fifo_generator_v5_2
  GENERIC (
    --------------------------------------------------------------------------------
    -- Generic Declarations (verilog model ordering)
    --------------------------------------------------------------------------------
    C_COMMON_CLOCK                : integer := 0;
    C_COUNT_TYPE                  : integer := 0;
    C_DATA_COUNT_WIDTH            : integer := 2;
    C_DEFAULT_VALUE               : string  := "";
    C_DIN_WIDTH                   : integer := 8;
    C_DOUT_RST_VAL                : string  := "";
    C_DOUT_WIDTH                  : integer := 8;
    C_ENABLE_RLOCS                : integer := 0;
    C_FAMILY                      : string  := "";
    C_HAS_ALMOST_EMPTY            : integer := 0;
    C_HAS_ALMOST_FULL             : integer := 0;
    C_HAS_BACKUP                  : integer := 0;
    C_HAS_DATA_COUNT              : integer := 0;
    C_HAS_MEMINIT_FILE            : integer := 0;
    C_HAS_OVERFLOW                : integer := 0;
    C_HAS_RD_DATA_COUNT           : integer := 0;
    C_HAS_RD_RST                  : integer := 0;
    C_HAS_RST                     : integer := 1;
    C_HAS_SRST                    : integer := 0;
    C_HAS_UNDERFLOW               : integer := 0;
    C_HAS_VALID                   : integer := 0;
    C_HAS_WR_ACK                  : integer := 0;
    C_HAS_WR_DATA_COUNT           : integer := 0;
    C_HAS_WR_RST                  : integer := 0;
    C_IMPLEMENTATION_TYPE         : integer := 0;
    C_INIT_WR_PNTR_VAL            : integer := 0;
    C_MEMORY_TYPE                 : integer := 1;
    C_MIF_FILE_NAME               : string  := "";
    C_OPTIMIZATION_MODE           : integer := 0;
    C_OVERFLOW_LOW                : integer := 0;
    C_PRELOAD_REGS                : integer := 0;
    C_PRELOAD_LATENCY             : integer := 1;
    C_PRIM_FIFO_TYPE              : string  := "4kx4";
    C_PROG_EMPTY_THRESH_ASSERT_VAL: integer := 0;
    C_PROG_EMPTY_THRESH_NEGATE_VAL: integer := 0;
    C_PROG_EMPTY_TYPE             : integer := 0;
    C_PROG_FULL_THRESH_ASSERT_VAL : integer := 0;
    C_PROG_FULL_THRESH_NEGATE_VAL : integer := 0;
    C_PROG_FULL_TYPE              : integer := 0;
    C_RD_DATA_COUNT_WIDTH         : integer := 2;
    C_RD_DEPTH                    : integer := 256;
    C_RD_FREQ                     : integer := 1;
    C_RD_PNTR_WIDTH               : integer := 8;
    C_UNDERFLOW_LOW               : integer := 0;
    C_USE_DOUT_RST                : integer := 0;
    C_USE_EMBEDDED_REG            : integer := 0;
    C_USE_FIFO16_FLAGS            : integer := 0;
    C_USE_FWFT_DATA_COUNT         : integer := 0;
    C_VALID_LOW                   : integer := 0;
    C_WR_ACK_LOW                  : integer := 0;
    C_WR_DATA_COUNT_WIDTH         : integer := 2;
    C_WR_DEPTH                    : integer := 256;
    C_WR_FREQ                     : integer := 1;
    C_WR_PNTR_WIDTH               : integer := 8;
    C_WR_RESPONSE_LATENCY         : integer := 1;
    C_USE_ECC                     : integer := 0;
    C_FULL_FLAGS_RST_VAL          : integer := 1;
    C_HAS_INT_CLK                 : integer := 0;
    C_MSGON_VAL                   : integer := 1;
    C_ENABLE_RST_SYNC             : integer := 1;  -- New FG 5.1/5.2
    C_ERROR_INJECTION_TYPE        : integer := 0   -- New FG 5.1/5.2
    );
  PORT(
--------------------------------------------------------------------------------
-- Input and Output Declarations
--------------------------------------------------------------------------------
    CLK                       : IN  std_logic := '0';
    BACKUP                    : IN  std_logic := '0';
    BACKUP_MARKER             : IN  std_logic := '0';
    DIN                       : IN  std_logic_vector(C_DIN_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    PROG_EMPTY_THRESH         : IN  std_logic_vector(C_RD_PNTR_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    PROG_EMPTY_THRESH_ASSERT  : IN  std_logic_vector(C_RD_PNTR_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    PROG_EMPTY_THRESH_NEGATE  : IN  std_logic_vector(C_RD_PNTR_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    PROG_FULL_THRESH          : IN  std_logic_vector(C_WR_PNTR_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    PROG_FULL_THRESH_ASSERT   : IN  std_logic_vector(C_WR_PNTR_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    PROG_FULL_THRESH_NEGATE   : IN  std_logic_vector(C_WR_PNTR_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    RD_CLK                    : IN  std_logic := '0';
    RD_EN                     : IN  std_logic := '0';
    RD_RST                    : IN  std_logic := '0';
    RST                       : IN  std_logic := '0';
    SRST                      : IN  std_logic := '0';
    WR_CLK                    : IN  std_logic := '0';
    WR_EN                     : IN  std_logic := '0';
    WR_RST                    : IN  std_logic := '0';
    INT_CLK                   : IN  std_logic := '0';
    INJECTDBITERR             : IN  std_logic := '0'; -- New FG 5.1/5.2 
    INJECTSBITERR             : IN  std_logic := '0'; -- New FG 5.1/5.2 

    ALMOST_EMPTY              : OUT std_logic;
    ALMOST_FULL               : OUT std_logic;
    DATA_COUNT                : OUT std_logic_vector(C_DATA_COUNT_WIDTH-1 DOWNTO 0);
    DOUT                      : OUT std_logic_vector(C_DOUT_WIDTH-1 DOWNTO 0);
    EMPTY                     : OUT std_logic;
    FULL                      : OUT std_logic;
    OVERFLOW                  : OUT std_logic;
    PROG_EMPTY                : OUT std_logic;
    PROG_FULL                 : OUT std_logic;
    VALID                     : OUT std_logic;
    RD_DATA_COUNT             : OUT std_logic_vector(C_RD_DATA_COUNT_WIDTH-1 DOWNTO 0);
    UNDERFLOW                 : OUT std_logic;
    WR_ACK                    : OUT std_logic;
    WR_DATA_COUNT             : OUT std_logic_vector(C_WR_DATA_COUNT_WIDTH-1 DOWNTO 0);
    SBITERR                   : OUT std_logic;
    DBITERR                   : OUT std_logic
    );
 END COMPONENT;


-- The following attributes tells XST that the fifo_generator_v5_2 is a black box
-- which should be generated using the command given by the value
-- of this attribute
attribute box_type of fifo_generator_v5_2: component is "black_box";
attribute GENERATOR_DEFAULT of fifo_generator_v5_2: component is 
     "generatecore com.xilinx.ip.fifo_generator_v5_2.fifo_generator_v5_2 -a map_qvirtex_to=virtex map_qrvirtex_to=virtex map_virtexe_to=virtex map_qvirtex2_to=virtex2 map_qrvirtex2_to=virtex2 map_spartan2_to=virtex map_spartan2e_to=virtex map_virtex5_to=virtex4 map_spartan3a_to=spartan3e spartan3an_to=spartan3e spartan3adsp_to=spartan3e ";

-- End FIFO Generator Component ---------------------------------------






-------------------------------------------------------------------------------------
-- Start FIFO Generator Component for V5_3
-- The Component declaration for V5_2 pulled from the L.69\rtf\vhdl\src\XilinxCoreLib
-- file: fifo_generator_v5_3_comp.vhd. 
-- However, to support NCSIM, Params and Ports are ordered to match the verilog 
-- definition in L.38\rtf\verilog\src\XilinxCoreLib\fifo_generator_v5_3.v .
--
-- This component is used for both dual clock (async) and synchronous fifos 
-- implemented with BRAM or distributed RAM. Hard FIFO simulation support may not
-- be provided in FIFO Generator V5.3 so not supported here.
-------------------------------------------------------------------------------------
 COMPONENT fifo_generator_v5_3
  GENERIC (
    --------------------------------------------------------------------------------
    -- Generic Declarations (verilog model ordering)
    --------------------------------------------------------------------------------
    C_COMMON_CLOCK                : integer := 0;
    C_COUNT_TYPE                  : integer := 0;
    C_DATA_COUNT_WIDTH            : integer := 2;
    C_DEFAULT_VALUE               : string  := "";
    C_DIN_WIDTH                   : integer := 8;
    C_DOUT_RST_VAL                : string  := "";
    C_DOUT_WIDTH                  : integer := 8;
    C_ENABLE_RLOCS                : integer := 0;
    C_FAMILY                      : string  := "";
    C_HAS_ALMOST_EMPTY            : integer := 0;
    C_HAS_ALMOST_FULL             : integer := 0;
    C_HAS_BACKUP                  : integer := 0;
    C_HAS_DATA_COUNT              : integer := 0;
    C_HAS_MEMINIT_FILE            : integer := 0;
    C_HAS_OVERFLOW                : integer := 0;
    C_HAS_RD_DATA_COUNT           : integer := 0;
    C_HAS_RD_RST                  : integer := 0;
    C_HAS_RST                     : integer := 1;
    C_HAS_SRST                    : integer := 0;
    C_HAS_UNDERFLOW               : integer := 0;
    C_HAS_VALID                   : integer := 0;
    C_HAS_WR_ACK                  : integer := 0;
    C_HAS_WR_DATA_COUNT           : integer := 0;
    C_HAS_WR_RST                  : integer := 0;
    C_IMPLEMENTATION_TYPE         : integer := 0;
    C_INIT_WR_PNTR_VAL            : integer := 0;
    C_MEMORY_TYPE                 : integer := 1;
    C_MIF_FILE_NAME               : string  := "";
    C_OPTIMIZATION_MODE           : integer := 0;
    C_OVERFLOW_LOW                : integer := 0;
    C_PRELOAD_REGS                : integer := 0;
    C_PRELOAD_LATENCY             : integer := 1;
    C_PRIM_FIFO_TYPE              : string  := "4kx4";
    C_PROG_EMPTY_THRESH_ASSERT_VAL: integer := 0;
    C_PROG_EMPTY_THRESH_NEGATE_VAL: integer := 0;
    C_PROG_EMPTY_TYPE             : integer := 0;
    C_PROG_FULL_THRESH_ASSERT_VAL : integer := 0;
    C_PROG_FULL_THRESH_NEGATE_VAL : integer := 0;
    C_PROG_FULL_TYPE              : integer := 0;
    C_RD_DATA_COUNT_WIDTH         : integer := 2;
    C_RD_DEPTH                    : integer := 256;
    C_RD_FREQ                     : integer := 1;
    C_RD_PNTR_WIDTH               : integer := 8;
    C_UNDERFLOW_LOW               : integer := 0;
    C_USE_DOUT_RST                : integer := 0;
    C_USE_EMBEDDED_REG            : integer := 0;
    C_USE_FIFO16_FLAGS            : integer := 0;
    C_USE_FWFT_DATA_COUNT         : integer := 0;
    C_VALID_LOW                   : integer := 0;
    C_WR_ACK_LOW                  : integer := 0;
    C_WR_DATA_COUNT_WIDTH         : integer := 2;
    C_WR_DEPTH                    : integer := 256;
    C_WR_FREQ                     : integer := 1;
    C_WR_PNTR_WIDTH               : integer := 8;
    C_WR_RESPONSE_LATENCY         : integer := 1;
    C_USE_ECC                     : integer := 0;
    C_FULL_FLAGS_RST_VAL          : integer := 1;
    C_HAS_INT_CLK                 : integer := 0;
    C_MSGON_VAL                   : integer := 1;
    C_ENABLE_RST_SYNC             : integer := 1;  -- New FG 5.1/5.2
    C_ERROR_INJECTION_TYPE        : integer := 0   -- New FG 5.1/5.2
    );
  PORT(
--------------------------------------------------------------------------------
-- Input and Output Declarations
--------------------------------------------------------------------------------
    CLK                       : IN  std_logic := '0';
    BACKUP                    : IN  std_logic := '0';
    BACKUP_MARKER             : IN  std_logic := '0';
    DIN                       : IN  std_logic_vector(C_DIN_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    PROG_EMPTY_THRESH         : IN  std_logic_vector(C_RD_PNTR_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    PROG_EMPTY_THRESH_ASSERT  : IN  std_logic_vector(C_RD_PNTR_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    PROG_EMPTY_THRESH_NEGATE  : IN  std_logic_vector(C_RD_PNTR_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    PROG_FULL_THRESH          : IN  std_logic_vector(C_WR_PNTR_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    PROG_FULL_THRESH_ASSERT   : IN  std_logic_vector(C_WR_PNTR_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    PROG_FULL_THRESH_NEGATE   : IN  std_logic_vector(C_WR_PNTR_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    RD_CLK                    : IN  std_logic := '0';
    RD_EN                     : IN  std_logic := '0';
    RD_RST                    : IN  std_logic := '0';
    RST                       : IN  std_logic := '0';
    SRST                      : IN  std_logic := '0';
    WR_CLK                    : IN  std_logic := '0';
    WR_EN                     : IN  std_logic := '0';
    WR_RST                    : IN  std_logic := '0';
    INT_CLK                   : IN  std_logic := '0';
    INJECTDBITERR             : IN  std_logic := '0'; -- New FG 5.1/5.2 
    INJECTSBITERR             : IN  std_logic := '0'; -- New FG 5.1/5.2 

    ALMOST_EMPTY              : OUT std_logic;
    ALMOST_FULL               : OUT std_logic;
    DATA_COUNT                : OUT std_logic_vector(C_DATA_COUNT_WIDTH-1 DOWNTO 0);
    DOUT                      : OUT std_logic_vector(C_DOUT_WIDTH-1 DOWNTO 0);
    EMPTY                     : OUT std_logic;
    FULL                      : OUT std_logic;
    OVERFLOW                  : OUT std_logic;
    PROG_EMPTY                : OUT std_logic;
    PROG_FULL                 : OUT std_logic;
    VALID                     : OUT std_logic;
    RD_DATA_COUNT             : OUT std_logic_vector(C_RD_DATA_COUNT_WIDTH-1 DOWNTO 0);
    UNDERFLOW                 : OUT std_logic;
    WR_ACK                    : OUT std_logic;
    WR_DATA_COUNT             : OUT std_logic_vector(C_WR_DATA_COUNT_WIDTH-1 DOWNTO 0);
    SBITERR                   : OUT std_logic;
    DBITERR                   : OUT std_logic
    );
 END COMPONENT;


-- The following attributes tells XST that the fifo_generator_v5_3 is a black box
-- which should be generated using the command given by the value
-- of this attribute
attribute box_type of fifo_generator_v5_3: component is "black_box";
attribute GENERATOR_DEFAULT of fifo_generator_v5_3: component is 
     "generatecore com.xilinx.ip.fifo_generator_v5_3.fifo_generator_v5_3 -a map_qvirtex_to=virtex map_qrvirtex_to=virtex map_virtexe_to=virtex map_qvirtex2_to=virtex2 map_qrvirtex2_to=virtex2 map_spartan2_to=virtex map_spartan2e_to=virtex map_virtex5_to=virtex4 map_spartan3a_to=spartan3e spartan3an_to=spartan3e spartan3adsp_to=spartan3e ";

-- End FIFO Generator Component ---------------------------------------








-------------------------------------------------------------------------------------
-- Start FIFO Generator Component for V6_1
-- The Component declaration for V5_2 pulled from the M.50\rtf\vhdl\src\XilinxCoreLib
-- file: fifo_generator_v6_1_comp.vhd. 
-- However, to support NCSIM, Params and Ports are ordered to match the verilog 
-- definition in M.50\rtf\verilog\src\XilinxCoreLib\fifo_generator_v6_1.v .
--
-- This component is used for both dual clock (async) and synchronous fifos 
-- implemented with BRAM or distributed RAM. Hard FIFO simulation support may not
-- be provided in FIFO Generator V6.1 so not supported here.
-------------------------------------------------------------------------------------
 COMPONENT fifo_generator_v6_1
  GENERIC (
    --------------------------------------------------------------------------------
    -- Generic Declarations (verilog model ordering)
    --------------------------------------------------------------------------------
    C_COMMON_CLOCK                : integer := 0;
    C_COUNT_TYPE                  : integer := 0;
    C_DATA_COUNT_WIDTH            : integer := 2;
    C_DEFAULT_VALUE               : string  := "";
    C_DIN_WIDTH                   : integer := 8;
    C_DOUT_RST_VAL                : string  := "";
    C_DOUT_WIDTH                  : integer := 8;
    C_ENABLE_RLOCS                : integer := 0;
    C_FAMILY                      : string  := "";
    C_FULL_FLAGS_RST_VAL          : integer := 1;
    C_HAS_ALMOST_EMPTY            : integer := 0;  
    C_HAS_ALMOST_FULL             : integer := 0;
    C_HAS_BACKUP                  : integer := 0;
    C_HAS_DATA_COUNT              : integer := 0;
    C_HAS_INT_CLK                 : integer := 0;  
    C_HAS_MEMINIT_FILE            : integer := 0;
    C_HAS_OVERFLOW                : integer := 0;
    C_HAS_RD_DATA_COUNT           : integer := 0;
    C_HAS_RD_RST                  : integer := 0;
    C_HAS_RST                     : integer := 1;
    C_HAS_SRST                    : integer := 0;
    C_HAS_UNDERFLOW               : integer := 0;
    C_HAS_VALID                   : integer := 0;
    C_HAS_WR_ACK                  : integer := 0;
    C_HAS_WR_DATA_COUNT           : integer := 0;
    C_HAS_WR_RST                  : integer := 0;
    C_IMPLEMENTATION_TYPE         : integer := 0;
    C_INIT_WR_PNTR_VAL            : integer := 0;
    C_MEMORY_TYPE                 : integer := 1;
    C_MIF_FILE_NAME               : string  := "";
    C_OPTIMIZATION_MODE           : integer := 0;
    C_OVERFLOW_LOW                : integer := 0;
    C_PRELOAD_LATENCY             : integer := 1;
    C_PRELOAD_REGS                : integer := 0;
    C_PRIM_FIFO_TYPE              : string  := "4kx4";
    C_PROG_EMPTY_THRESH_ASSERT_VAL: integer := 0;
    C_PROG_EMPTY_THRESH_NEGATE_VAL: integer := 0;
    C_PROG_EMPTY_TYPE             : integer := 0;
    C_PROG_FULL_THRESH_ASSERT_VAL : integer := 0;
    C_PROG_FULL_THRESH_NEGATE_VAL : integer := 0;
    C_PROG_FULL_TYPE              : integer := 0;
    C_RD_DATA_COUNT_WIDTH         : integer := 2;
    C_RD_DEPTH                    : integer := 256;
    C_RD_FREQ                     : integer := 1;
    C_RD_PNTR_WIDTH               : integer := 8;
    C_UNDERFLOW_LOW               : integer := 0;
    C_USE_DOUT_RST                : integer := 0;
    C_USE_ECC                     : integer := 0;
    C_USE_EMBEDDED_REG            : integer := 0;
    C_USE_FIFO16_FLAGS            : integer := 0;
    C_USE_FWFT_DATA_COUNT         : integer := 0;
    C_VALID_LOW                   : integer := 0;
    C_WR_ACK_LOW                  : integer := 0;
    C_WR_DATA_COUNT_WIDTH         : integer := 2;
    C_WR_DEPTH                    : integer := 256;
    C_WR_FREQ                     : integer := 1;
    C_WR_PNTR_WIDTH               : integer := 8;
    C_WR_RESPONSE_LATENCY         : integer := 1;
    C_MSGON_VAL                   : integer := 1;
    C_ENABLE_RST_SYNC             : integer := 1;  
    C_ERROR_INJECTION_TYPE        : integer := 0   
    );
  PORT(
--------------------------------------------------------------------------------
-- Input and Output Declarations
--------------------------------------------------------------------------------
    BACKUP                    : IN  std_logic := '0';
    BACKUP_MARKER             : IN  std_logic := '0';
    CLK                       : IN  std_logic := '0';
    RST                       : IN  std_logic := '0';
    SRST                      : IN  std_logic := '0';
    WR_CLK                    : IN  std_logic := '0';
    WR_RST                    : IN  std_logic := '0';
    RD_CLK                    : IN  std_logic := '0';
    RD_RST                    : IN  std_logic := '0';
    DIN                       : IN  std_logic_vector(C_DIN_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    WR_EN                     : IN  std_logic := '0';  --Mandatory input
    RD_EN                     : IN  std_logic := '0';  --Mandatory input
    PROG_EMPTY_THRESH         : IN  std_logic_vector(C_RD_PNTR_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    PROG_EMPTY_THRESH_ASSERT  : IN  std_logic_vector(C_RD_PNTR_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    PROG_EMPTY_THRESH_NEGATE  : IN  std_logic_vector(C_RD_PNTR_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    PROG_FULL_THRESH          : IN  std_logic_vector(C_WR_PNTR_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    PROG_FULL_THRESH_ASSERT   : IN  std_logic_vector(C_WR_PNTR_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    PROG_FULL_THRESH_NEGATE   : IN  std_logic_vector(C_WR_PNTR_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    INT_CLK                   : IN  std_logic := '0';
    INJECTDBITERR             : IN  std_logic := '0'; -- New FG 5.1/5.2 
    INJECTSBITERR             : IN  std_logic := '0'; -- New FG 5.1/5.2 

    DOUT                      : OUT std_logic_vector(C_DOUT_WIDTH-1 DOWNTO 0);
    FULL                      : OUT std_logic;
    ALMOST_FULL               : OUT std_logic;
    WR_ACK                    : OUT std_logic;
    OVERFLOW                  : OUT std_logic;
    EMPTY                     : OUT std_logic;
    ALMOST_EMPTY              : OUT std_logic;
    VALID                     : OUT std_logic;
    UNDERFLOW                 : OUT std_logic;
    DATA_COUNT                : OUT std_logic_vector(C_DATA_COUNT_WIDTH-1 DOWNTO 0);
    RD_DATA_COUNT             : OUT std_logic_vector(C_RD_DATA_COUNT_WIDTH-1 DOWNTO 0);
    WR_DATA_COUNT             : OUT std_logic_vector(C_WR_DATA_COUNT_WIDTH-1 DOWNTO 0);
    PROG_FULL                 : OUT std_logic;
    PROG_EMPTY                : OUT std_logic;
    SBITERR                   : OUT std_logic;
    DBITERR                   : OUT std_logic
    );
 END COMPONENT;


-- The following attributes tells XST that the fifo_generator_v6_1 is a black box
-- which should be generated using the command given by the value
-- of this attribute
attribute box_type of fifo_generator_v6_1: component is "black_box";
attribute GENERATOR_DEFAULT of fifo_generator_v6_1: component is 
     "generatecore com.xilinx.ip.fifo_generator_v6_1.fifo_generator_v6_1 -a map_qvirtex_to=virtex map_qrvirtex_to=virtex map_virtexe_to=virtex map_qvirtex2_to=virtex2 map_qrvirtex2_to=virtex2 map_spartan2_to=virtex map_spartan2e_to=virtex map_virtex5_to=virtex4 map_spartan3a_to=spartan3e spartan3an_to=spartan3e spartan3adsp_to=spartan3e ";

-- End FIFO Generator Component ---------------------------------------








   
-------------------------------------------------------------------------------------
-- Start FIFO Generator Component for V8.1
-- The Component declaration for V8.1 pulled from the O.36\rtf\vhdl\src\XilinxCoreLib
-- file: fifo_generator_v8_1_comp.vhd. 
-- However, to support NCSIM, Params and Ports are ordered to match the verilog 
-- definition in O.36\rtf\verilog\src\XilinxCoreLib\fifo_generator_v8_1.v .
--
-- This component is used for both dual clock (async) and synchronous fifos 
-- implemented with BRAM or distributed RAM. Hard FIFO simulation support may not
-- be provided in FIFO Generator V8.1 so not supported here.
--
-- Note: AXI ports and parameters added for this version of FIFO Generator.
--
-------------------------------------------------------------------------------------
 COMPONENT fifo_generator_v8_1
  GENERIC (
    --------------------------------------------------------------------------------
    -- Generic Declarations (verilog model ordering)
    --------------------------------------------------------------------------------
    C_COMMON_CLOCK                : integer := 0;
    C_COUNT_TYPE                  : integer := 0;
    C_DATA_COUNT_WIDTH            : integer := 2;
    C_DEFAULT_VALUE               : string  := "";
    C_DIN_WIDTH                   : integer := 8;
    C_DOUT_RST_VAL                : string  := "";
    C_DOUT_WIDTH                  : integer := 8;
    C_ENABLE_RLOCS                : integer := 0;
    C_FAMILY                      : string  := "";
    C_FULL_FLAGS_RST_VAL          : integer := 1;
    C_HAS_ALMOST_EMPTY            : integer := 0;  
    C_HAS_ALMOST_FULL             : integer := 0;
    C_HAS_BACKUP                  : integer := 0;
    C_HAS_DATA_COUNT              : integer := 0;
    C_HAS_INT_CLK                 : integer := 0;  
    C_HAS_MEMINIT_FILE            : integer := 0;
    C_HAS_OVERFLOW                : integer := 0;
    C_HAS_RD_DATA_COUNT           : integer := 0;
    C_HAS_RD_RST                  : integer := 0;
    C_HAS_RST                     : integer := 1;
    C_HAS_SRST                    : integer := 0;
    C_HAS_UNDERFLOW               : integer := 0;
    C_HAS_VALID                   : integer := 0;
    C_HAS_WR_ACK                  : integer := 0;
    C_HAS_WR_DATA_COUNT           : integer := 0;
    C_HAS_WR_RST                  : integer := 0;
    C_IMPLEMENTATION_TYPE         : integer := 0;
    C_INIT_WR_PNTR_VAL            : integer := 0;
    C_MEMORY_TYPE                 : integer := 1;
    C_MIF_FILE_NAME               : string  := "";
    C_OPTIMIZATION_MODE           : integer := 0;
    C_OVERFLOW_LOW                : integer := 0;
    C_PRELOAD_LATENCY             : integer := 1;
    C_PRELOAD_REGS                : integer := 0;
    C_PRIM_FIFO_TYPE              : string  := "4kx4";
    C_PROG_EMPTY_THRESH_ASSERT_VAL: integer := 0;
    C_PROG_EMPTY_THRESH_NEGATE_VAL: integer := 0;
    C_PROG_EMPTY_TYPE             : integer := 0;
    C_PROG_FULL_THRESH_ASSERT_VAL : integer := 0;
    C_PROG_FULL_THRESH_NEGATE_VAL : integer := 0;
    C_PROG_FULL_TYPE              : integer := 0;
    C_RD_DATA_COUNT_WIDTH         : integer := 2;
    C_RD_DEPTH                    : integer := 256;
    C_RD_FREQ                     : integer := 1;
    C_RD_PNTR_WIDTH               : integer := 8;
    C_UNDERFLOW_LOW               : integer := 0;
    C_USE_DOUT_RST                : integer := 0;
    C_USE_ECC                     : integer := 0;
    C_USE_EMBEDDED_REG            : integer := 0;
    C_USE_FIFO16_FLAGS            : integer := 0;
    C_USE_FWFT_DATA_COUNT         : integer := 0;
    C_VALID_LOW                   : integer := 0;
    C_WR_ACK_LOW                  : integer := 0;
    C_WR_DATA_COUNT_WIDTH         : integer := 2;
    C_WR_DEPTH                    : integer := 256;
    C_WR_FREQ                     : integer := 1;
    C_WR_PNTR_WIDTH               : integer := 8;
    C_WR_RESPONSE_LATENCY         : integer := 1;
    C_MSGON_VAL                   : integer := 1;
    C_ENABLE_RST_SYNC             : integer := 1;  
    C_ERROR_INJECTION_TYPE        : integer := 0;   

    -- AXI Interface related parameters start here
    C_INTERFACE_TYPE                        : integer := 0; -- 0: Native Interface; 1: AXI Interface
    C_AXI_TYPE                              : integer := 0; -- 0: AXI Stream; 1: AXI Full; 2: AXI Lite
    C_HAS_AXI_WR_CHANNEL                    : integer := 0;
    C_HAS_AXI_RD_CHANNEL                    : integer := 0;
    C_HAS_SLAVE_CE                          : integer := 0;
    C_HAS_MASTER_CE                         : integer := 0;
    C_ADD_NGC_CONSTRAINT                    : integer := 0;
    C_USE_COMMON_OVERFLOW                   : integer := 0;
    C_USE_COMMON_UNDERFLOW                  : integer := 0;
    C_USE_DEFAULT_SETTINGS                  : integer := 0;

    -- AXI Full/Lite
    C_AXI_ID_WIDTH                          : integer := 4 ;
    C_AXI_ADDR_WIDTH                        : integer := 32;
    C_AXI_DATA_WIDTH                        : integer := 64;
    C_HAS_AXI_AWUSER                        : integer := 0 ;
    C_HAS_AXI_WUSER                         : integer := 0 ;
    C_HAS_AXI_BUSER                         : integer := 0 ;
    C_HAS_AXI_ARUSER                        : integer := 0 ;
    C_HAS_AXI_RUSER                         : integer := 0 ;
    C_AXI_ARUSER_WIDTH                      : integer := 1 ;
    C_AXI_AWUSER_WIDTH                      : integer := 1 ;
    C_AXI_WUSER_WIDTH                       : integer := 1 ;
    C_AXI_BUSER_WIDTH                       : integer := 1 ;
    C_AXI_RUSER_WIDTH                       : integer := 1 ;
                                       
    -- AXI Streaming
    C_HAS_AXIS_TDATA                        : integer := 0 ;
    C_HAS_AXIS_TID                          : integer := 0 ;
    C_HAS_AXIS_TDEST                        : integer := 0 ;
    C_HAS_AXIS_TUSER                        : integer := 0 ;
    C_HAS_AXIS_TREADY                       : integer := 1 ;
    C_HAS_AXIS_TLAST                        : integer := 0 ;
    C_HAS_AXIS_TSTRB                        : integer := 0 ;
    C_HAS_AXIS_TKEEP                        : integer := 0 ;
    C_AXIS_TDATA_WIDTH                      : integer := 64;
    C_AXIS_TID_WIDTH                        : integer := 8 ;
    C_AXIS_TDEST_WIDTH                      : integer := 4 ;
    C_AXIS_TUSER_WIDTH                      : integer := 4 ;
    C_AXIS_TSTRB_WIDTH                      : integer := 4 ;
    C_AXIS_TKEEP_WIDTH                      : integer := 4 ;

    -- AXI Channel Type
    -- WACH --> Write Address Channel
    -- WDCH --> Write Data Channel
    -- WRCH --> Write Response Channel
    -- RACH --> Read Address Channel
    -- RDCH --> Read Data Channel
    -- AXIS --> AXI Streaming
    C_WACH_TYPE                             : integer := 0; -- 0 = FIFO; 1 = Register Slice; 2 = Pass Through Logic
    C_WDCH_TYPE                             : integer := 0; -- 0 = FIFO; 1 = Register Slice; 2 = Pass Through Logie
    C_WRCH_TYPE                             : integer := 0; -- 0 = FIFO; 1 = Register Slice; 2 = Pass Through Logie
    C_RACH_TYPE                             : integer := 0; -- 0 = FIFO; 1 = Register Slice; 2 = Pass Through Logie
    C_RDCH_TYPE                             : integer := 0; -- 0 = FIFO; 1 = Register Slice; 2 = Pass Through Logie
    C_AXIS_TYPE                             : integer := 0; -- 0 = FIFO; 1 = Register Slice; 2 = Pass Through Logie

    -- AXI Implementation Type
    -- 1 = Common Clock Block RAM FIFO
    -- 2 = Common Clock Distributed RAM FIFO
    -- 11 = Independent Clock Block RAM FIFO
    -- 12 = Independent Clock Distributed RAM FIFO
    C_IMPLEMENTATION_TYPE_WACH              : integer := 1;
    C_IMPLEMENTATION_TYPE_WDCH              : integer := 1;
    C_IMPLEMENTATION_TYPE_WRCH              : integer := 1;
    C_IMPLEMENTATION_TYPE_RACH              : integer := 1;
    C_IMPLEMENTATION_TYPE_RDCH              : integer := 1;
    C_IMPLEMENTATION_TYPE_AXIS              : integer := 1;

    -- AXI FIFO Type
    -- 0 = Data FIFO
    -- 1 = Packet FIFO
    -- 2 = Low Latency Data FIFO
    C_APPLICATION_TYPE_WACH                 : integer := 0;
    C_APPLICATION_TYPE_WDCH                 : integer := 0;
    C_APPLICATION_TYPE_WRCH                 : integer := 0;
    C_APPLICATION_TYPE_RACH                 : integer := 0;
    C_APPLICATION_TYPE_RDCH                 : integer := 0;
    C_APPLICATION_TYPE_AXIS                 : integer := 0;

    -- Enable ECC
    -- 0 = ECC disabled
    -- 1 = ECC enabled
    C_USE_ECC_WACH                          : integer := 0;
    C_USE_ECC_WDCH                          : integer := 0;
    C_USE_ECC_WRCH                          : integer := 0;
    C_USE_ECC_RACH                          : integer := 0;
    C_USE_ECC_RDCH                          : integer := 0;
    C_USE_ECC_AXIS                          : integer := 0;

    -- ECC Error Injection Type
    -- 0 = No Error Injection
    -- 1 = Single Bit Error Injection
    -- 2 = Double Bit Error Injection
    -- 3 = Single Bit and Double Bit Error Injection
    C_ERROR_INJECTION_TYPE_WACH             : integer := 0;
    C_ERROR_INJECTION_TYPE_WDCH             : integer := 0;
    C_ERROR_INJECTION_TYPE_WRCH             : integer := 0;
    C_ERROR_INJECTION_TYPE_RACH             : integer := 0;
    C_ERROR_INJECTION_TYPE_RDCH             : integer := 0;
    C_ERROR_INJECTION_TYPE_AXIS             : integer := 0;

    -- Input Data Width
    -- Accumulation of all AXI input signal's width
    C_DIN_WIDTH_WACH                        : integer := 32;
    C_DIN_WIDTH_WDCH                        : integer := 64;
    C_DIN_WIDTH_WRCH                        : integer := 2 ;
    C_DIN_WIDTH_RACH                        : integer := 32;
    C_DIN_WIDTH_RDCH                        : integer := 64;
    C_DIN_WIDTH_AXIS                        : integer := 1 ;

    C_WR_DEPTH_WACH                         : integer := 16  ;
    C_WR_DEPTH_WDCH                         : integer := 1024;
    C_WR_DEPTH_WRCH                         : integer := 16  ;
    C_WR_DEPTH_RACH                         : integer := 16  ;
    C_WR_DEPTH_RDCH                         : integer := 1024;
    C_WR_DEPTH_AXIS                         : integer := 1024;

    C_WR_PNTR_WIDTH_WACH                    : integer := 4 ;
    C_WR_PNTR_WIDTH_WDCH                    : integer := 10;
    C_WR_PNTR_WIDTH_WRCH                    : integer := 4 ;
    C_WR_PNTR_WIDTH_RACH                    : integer := 4 ;
    C_WR_PNTR_WIDTH_RDCH                    : integer := 10;
    C_WR_PNTR_WIDTH_AXIS                    : integer := 10;

    C_HAS_DATA_COUNTS_WACH                  : integer := 0;
    C_HAS_DATA_COUNTS_WDCH                  : integer := 0;
    C_HAS_DATA_COUNTS_WRCH                  : integer := 0;
    C_HAS_DATA_COUNTS_RACH                  : integer := 0;
    C_HAS_DATA_COUNTS_RDCH                  : integer := 0;
    C_HAS_DATA_COUNTS_AXIS                  : integer := 0;

    C_HAS_PROG_FLAGS_WACH                   : integer := 0;
    C_HAS_PROG_FLAGS_WDCH                   : integer := 0;
    C_HAS_PROG_FLAGS_WRCH                   : integer := 0;
    C_HAS_PROG_FLAGS_RACH                   : integer := 0;
    C_HAS_PROG_FLAGS_RDCH                   : integer := 0;
    C_HAS_PROG_FLAGS_AXIS                   : integer := 0;

    C_PROG_FULL_TYPE_WACH                   : integer := 5   ;
    C_PROG_FULL_TYPE_WDCH                   : integer := 5   ;
    C_PROG_FULL_TYPE_WRCH                   : integer := 5   ;
    C_PROG_FULL_TYPE_RACH                   : integer := 5   ;
    C_PROG_FULL_TYPE_RDCH                   : integer := 5   ;
    C_PROG_FULL_TYPE_AXIS                   : integer := 5   ;
    C_PROG_FULL_THRESH_ASSERT_VAL_WACH      : integer := 1023;
    C_PROG_FULL_THRESH_ASSERT_VAL_WDCH      : integer := 1023;
    C_PROG_FULL_THRESH_ASSERT_VAL_WRCH      : integer := 1023;
    C_PROG_FULL_THRESH_ASSERT_VAL_RACH      : integer := 1023;
    C_PROG_FULL_THRESH_ASSERT_VAL_RDCH      : integer := 1023;
    C_PROG_FULL_THRESH_ASSERT_VAL_AXIS      : integer := 1023;

    C_PROG_EMPTY_TYPE_WACH                  : integer := 5   ;
    C_PROG_EMPTY_TYPE_WDCH                  : integer := 5   ;
    C_PROG_EMPTY_TYPE_WRCH                  : integer := 5   ;
    C_PROG_EMPTY_TYPE_RACH                  : integer := 5   ;
    C_PROG_EMPTY_TYPE_RDCH                  : integer := 5   ;
    C_PROG_EMPTY_TYPE_AXIS                  : integer := 5   ;
    C_PROG_EMPTY_THRESH_ASSERT_VAL_WACH     : integer := 1022;
    C_PROG_EMPTY_THRESH_ASSERT_VAL_WDCH     : integer := 1022;
    C_PROG_EMPTY_THRESH_ASSERT_VAL_WRCH     : integer := 1022;
    C_PROG_EMPTY_THRESH_ASSERT_VAL_RACH     : integer := 1022;
    C_PROG_EMPTY_THRESH_ASSERT_VAL_RDCH     : integer := 1022;
    C_PROG_EMPTY_THRESH_ASSERT_VAL_AXIS     : integer := 1022;

    C_REG_SLICE_MODE_WACH                   : integer := 0;
    C_REG_SLICE_MODE_WDCH                   : integer := 0;
    C_REG_SLICE_MODE_WRCH                   : integer := 0;
    C_REG_SLICE_MODE_RACH                   : integer := 0;
    C_REG_SLICE_MODE_RDCH                   : integer := 0;
    C_REG_SLICE_MODE_AXIS                   : integer := 0

    );
  PORT(
--------------------------------------------------------------------------------
-- Input and Output Declarations
--------------------------------------------------------------------------------
    BACKUP                         : IN  std_logic := '0';
    BACKUP_MARKER                  : IN  std_logic := '0';
    CLK                            : IN  std_logic := '0';
    RST                            : IN  std_logic := '0';
    SRST                           : IN  std_logic := '0';
    WR_CLK                         : IN  std_logic := '0';
    WR_RST                         : IN  std_logic := '0';
    RD_CLK                         : IN  std_logic := '0';
    RD_RST                         : IN  std_logic := '0';
    DIN                            : IN  std_logic_vector(C_DIN_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    WR_EN                          : IN  std_logic := '0';  --Mandatory input
    RD_EN                          : IN  std_logic := '0';  --Mandatory input
    PROG_EMPTY_THRESH              : IN  std_logic_vector(C_RD_PNTR_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    PROG_EMPTY_THRESH_ASSERT       : IN  std_logic_vector(C_RD_PNTR_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    PROG_EMPTY_THRESH_NEGATE       : IN  std_logic_vector(C_RD_PNTR_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    PROG_FULL_THRESH               : IN  std_logic_vector(C_WR_PNTR_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    PROG_FULL_THRESH_ASSERT        : IN  std_logic_vector(C_WR_PNTR_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    PROG_FULL_THRESH_NEGATE        : IN  std_logic_vector(C_WR_PNTR_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    INT_CLK                        : IN  std_logic := '0';
    INJECTDBITERR                  : IN  std_logic := '0';  
    INJECTSBITERR                  : IN  std_logic := '0';  

    DOUT                           : OUT std_logic_vector(C_DOUT_WIDTH-1 DOWNTO 0);
    FULL                           : OUT std_logic;
    ALMOST_FULL                    : OUT std_logic;
    WR_ACK                         : OUT std_logic;
    OVERFLOW                       : OUT std_logic;
    EMPTY                          : OUT std_logic;
    ALMOST_EMPTY                   : OUT std_logic;
    VALID                          : OUT std_logic;
    UNDERFLOW                      : OUT std_logic;
    DATA_COUNT                     : OUT std_logic_vector(C_DATA_COUNT_WIDTH-1 DOWNTO 0);
    RD_DATA_COUNT                  : OUT std_logic_vector(C_RD_DATA_COUNT_WIDTH-1 DOWNTO 0);
    WR_DATA_COUNT                  : OUT std_logic_vector(C_WR_DATA_COUNT_WIDTH-1 DOWNTO 0);
    PROG_FULL                      : OUT std_logic;
    PROG_EMPTY                     : OUT std_logic;
    SBITERR                        : OUT std_logic;
    DBITERR                        : OUT std_logic;
    
    -- AXI Global Signal
    M_ACLK                         : IN  std_logic := '0';
    S_ACLK                         : IN  std_logic := '0';
    S_ARESETN                      : IN  std_logic := '0';
    M_ACLK_EN                      : IN  std_logic := '0';
    S_ACLK_EN                      : IN  std_logic := '0';

    -- AXI Full/Lite Slave Write Channel (write side)
    S_AXI_AWID                     : IN  std_logic_vector(C_AXI_ID_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_AWADDR                   : IN  std_logic_vector(C_AXI_ADDR_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_AWLEN                    : IN  std_logic_vector(8-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_AWSIZE                   : IN  std_logic_vector(3-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_AWBURST                  : IN  std_logic_vector(2-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_AWLOCK                   : IN  std_logic_vector(2-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_AWCACHE                  : IN  std_logic_vector(4-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_AWPROT                   : IN  std_logic_vector(3-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_AWQOS                    : IN  std_logic_vector(4-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_AWREGION                 : IN  std_logic_vector(4-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_AWUSER                   : IN  std_logic_vector(C_AXI_AWUSER_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_AWVALID                  : IN  std_logic := '0';
    S_AXI_AWREADY                  : OUT std_logic;
    S_AXI_WID                      : IN  std_logic_vector(C_AXI_ID_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_WDATA                    : IN  std_logic_vector(C_AXI_DATA_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_WSTRB                    : IN  std_logic_vector(C_AXI_DATA_WIDTH/8-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_WLAST                    : IN  std_logic := '0';
    S_AXI_WUSER                    : IN  std_logic_vector(C_AXI_WUSER_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_WVALID                   : IN  std_logic := '0';
    S_AXI_WREADY                   : OUT std_logic;
    S_AXI_BID                      : OUT std_logic_vector(C_AXI_ID_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_BRESP                    : OUT std_logic_vector(2-1 DOWNTO 0);
    S_AXI_BUSER                    : OUT std_logic_vector(C_AXI_BUSER_WIDTH-1 DOWNTO 0);
    S_AXI_BVALID                   : OUT std_logic;
    S_AXI_BREADY                   : IN  std_logic := '0';

    -- AXI Full/Lite Master Write Channel (Read side)
    M_AXI_AWID                     : OUT std_logic_vector(C_AXI_ID_WIDTH-1 DOWNTO 0);
    M_AXI_AWADDR                   : OUT std_logic_vector(C_AXI_ADDR_WIDTH-1 DOWNTO 0);
    M_AXI_AWLEN                    : OUT std_logic_vector(8-1 DOWNTO 0);
    M_AXI_AWSIZE                   : OUT std_logic_vector(3-1 DOWNTO 0);
    M_AXI_AWBURST                  : OUT std_logic_vector(2-1 DOWNTO 0);
    M_AXI_AWLOCK                   : OUT std_logic_vector(2-1 DOWNTO 0);
    M_AXI_AWCACHE                  : OUT std_logic_vector(4-1 DOWNTO 0);
    M_AXI_AWPROT                   : OUT std_logic_vector(3-1 DOWNTO 0);
    M_AXI_AWQOS                    : OUT std_logic_vector(4-1 DOWNTO 0);
    M_AXI_AWREGION                 : OUT std_logic_vector(4-1 DOWNTO 0);
    M_AXI_AWUSER                   : OUT std_logic_vector(C_AXI_AWUSER_WIDTH-1 DOWNTO 0);
    M_AXI_AWVALID                  : OUT std_logic;
    M_AXI_AWREADY                  : IN  std_logic := '0';
    M_AXI_WID                      : OUT std_logic_vector(C_AXI_ID_WIDTH-1 DOWNTO 0);
    M_AXI_WDATA                    : OUT std_logic_vector(C_AXI_DATA_WIDTH-1 DOWNTO 0);
    M_AXI_WSTRB                    : OUT std_logic_vector(C_AXI_DATA_WIDTH/8-1 DOWNTO 0);
    M_AXI_WLAST                    : OUT std_logic;
    M_AXI_WUSER                    : OUT std_logic_vector(C_AXI_WUSER_WIDTH-1 DOWNTO 0);
    M_AXI_WVALID                   : OUT std_logic;
    M_AXI_WREADY                   : IN  std_logic := '0';
    M_AXI_BID                      : IN  std_logic_vector(C_AXI_ID_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    M_AXI_BRESP                    : IN  std_logic_vector(2-1 DOWNTO 0) := (OTHERS => '0');
    M_AXI_BUSER                    : IN  std_logic_vector(C_AXI_BUSER_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    M_AXI_BVALID                   : IN  std_logic := '0';
    M_AXI_BREADY                   : OUT std_logic;

    -- AXI Full/Lite Slave Read Channel (Write side)
    S_AXI_ARID                     : IN  std_logic_vector(C_AXI_ID_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_ARADDR                   : IN  std_logic_vector(C_AXI_ADDR_WIDTH-1 DOWNTO 0) := (OTHERS => '0'); 
    S_AXI_ARLEN                    : IN  std_logic_vector(8-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_ARSIZE                   : IN  std_logic_vector(3-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_ARBURST                  : IN  std_logic_vector(2-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_ARLOCK                   : IN  std_logic_vector(2-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_ARCACHE                  : IN  std_logic_vector(4-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_ARPROT                   : IN  std_logic_vector(3-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_ARQOS                    : IN  std_logic_vector(4-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_ARREGION                 : IN  std_logic_vector(4-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_ARUSER                   : IN  std_logic_vector(C_AXI_ARUSER_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_ARVALID                  : IN  std_logic := '0';
    S_AXI_ARREADY                  : OUT std_logic;
    S_AXI_RID                      : OUT std_logic_vector(C_AXI_ID_WIDTH-1 DOWNTO 0);       
    S_AXI_RDATA                    : OUT std_logic_vector(C_AXI_DATA_WIDTH-1 DOWNTO 0); 
    S_AXI_RRESP                    : OUT std_logic_vector(2-1 DOWNTO 0);
    S_AXI_RLAST                    : OUT std_logic;
    S_AXI_RUSER                    : OUT std_logic_vector(C_AXI_RUSER_WIDTH-1 DOWNTO 0);
    S_AXI_RVALID                   : OUT std_logic;
    S_AXI_RREADY                   : IN  std_logic := '0';

    -- AXI Full/Lite Master Read Channel (Read side)
    M_AXI_ARID                     : OUT std_logic_vector(C_AXI_ID_WIDTH-1 DOWNTO 0);        
    M_AXI_ARADDR                   : OUT std_logic_vector(C_AXI_ADDR_WIDTH-1 DOWNTO 0);  
    M_AXI_ARLEN                    : OUT std_logic_vector(8-1 DOWNTO 0);
    M_AXI_ARSIZE                   : OUT std_logic_vector(3-1 DOWNTO 0);
    M_AXI_ARBURST                  : OUT std_logic_vector(2-1 DOWNTO 0);
    M_AXI_ARLOCK                   : OUT std_logic_vector(2-1 DOWNTO 0);
    M_AXI_ARCACHE                  : OUT std_logic_vector(4-1 DOWNTO 0);
    M_AXI_ARPROT                   : OUT std_logic_vector(3-1 DOWNTO 0);
    M_AXI_ARQOS                    : OUT std_logic_vector(4-1 DOWNTO 0);
    M_AXI_ARREGION                 : OUT std_logic_vector(4-1 DOWNTO 0);
    M_AXI_ARUSER                   : OUT std_logic_vector(C_AXI_ARUSER_WIDTH-1 DOWNTO 0);
    M_AXI_ARVALID                  : OUT std_logic;
    M_AXI_ARREADY                  : IN  std_logic := '0';
    M_AXI_RID                      : IN  std_logic_vector(C_AXI_ID_WIDTH-1 DOWNTO 0) := (OTHERS => '0');        
    M_AXI_RDATA                    : IN  std_logic_vector(C_AXI_DATA_WIDTH-1 DOWNTO 0) := (OTHERS => '0');  
    M_AXI_RRESP                    : IN  std_logic_vector(2-1 DOWNTO 0) := (OTHERS => '0');
    M_AXI_RLAST                    : IN  std_logic := '0';
    M_AXI_RUSER                    : IN  std_logic_vector(C_AXI_RUSER_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    M_AXI_RVALID                   : IN  std_logic := '0';
    M_AXI_RREADY                   : OUT std_logic;

    -- AXI Streaming Slave Signals (Write side)
    S_AXIS_TVALID                  : IN  std_logic := '0';
    S_AXIS_TREADY                  : OUT std_logic;
    S_AXIS_TDATA                   : IN  std_logic_vector(C_AXIS_TDATA_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    S_AXIS_TSTRB                   : IN  std_logic_vector(C_AXIS_TSTRB_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    S_AXIS_TKEEP                   : IN  std_logic_vector(C_AXIS_TKEEP_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    S_AXIS_TLAST                   : IN  std_logic := '0';
    S_AXIS_TID                     : IN  std_logic_vector(C_AXIS_TID_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    S_AXIS_TDEST                   : IN  std_logic_vector(C_AXIS_TDEST_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    S_AXIS_TUSER                   : IN  std_logic_vector(C_AXIS_TUSER_WIDTH-1 DOWNTO 0) := (OTHERS => '0');

    -- AXI Streaming Master Signals (Read side)
    M_AXIS_TVALID                  : OUT std_logic;
    M_AXIS_TREADY                  : IN  std_logic := '0';
    M_AXIS_TDATA                   : OUT std_logic_vector(C_AXIS_TDATA_WIDTH-1 DOWNTO 0);
    M_AXIS_TSTRB                   : OUT std_logic_vector(C_AXIS_TSTRB_WIDTH-1 DOWNTO 0);
    M_AXIS_TKEEP                   : OUT std_logic_vector(C_AXIS_TKEEP_WIDTH-1 DOWNTO 0);
    M_AXIS_TLAST                   : OUT std_logic;
    M_AXIS_TID                     : OUT std_logic_vector(C_AXIS_TID_WIDTH-1 DOWNTO 0);
    M_AXIS_TDEST                   : OUT std_logic_vector(C_AXIS_TDEST_WIDTH-1 DOWNTO 0);
    M_AXIS_TUSER                   : OUT std_logic_vector(C_AXIS_TUSER_WIDTH-1 DOWNTO 0);

    -- AXI Full/Lite Write Address Channel Signals
    AXI_AW_INJECTSBITERR           : IN  std_logic := '0';
    AXI_AW_INJECTDBITERR           : IN  std_logic := '0';
    AXI_AW_PROG_FULL_THRESH        : IN  std_logic_vector(C_WR_PNTR_WIDTH_WACH-1 DOWNTO 0) := (OTHERS => '0');
    AXI_AW_PROG_EMPTY_THRESH       : IN  std_logic_vector(C_WR_PNTR_WIDTH_WACH-1 DOWNTO 0) := (OTHERS => '0');
    AXI_AW_DATA_COUNT              : OUT std_logic_vector(C_WR_PNTR_WIDTH_WACH DOWNTO 0);
    AXI_AW_WR_DATA_COUNT           : OUT std_logic_vector(C_WR_PNTR_WIDTH_WACH DOWNTO 0);
    AXI_AW_RD_DATA_COUNT           : OUT std_logic_vector(C_WR_PNTR_WIDTH_WACH DOWNTO 0);
    AXI_AW_SBITERR                 : OUT std_logic;
    AXI_AW_DBITERR                 : OUT std_logic;
    AXI_AW_OVERFLOW                : OUT std_logic;
    AXI_AW_UNDERFLOW               : OUT std_logic;

    -- AXI Full/Lite Write Data Channel Signals
    AXI_W_INJECTSBITERR            : IN  std_logic := '0';
    AXI_W_INJECTDBITERR            : IN  std_logic := '0';
    AXI_W_PROG_FULL_THRESH         : IN  std_logic_vector(C_WR_PNTR_WIDTH_WDCH-1 DOWNTO 0) := (OTHERS => '0');
    AXI_W_PROG_EMPTY_THRESH        : IN  std_logic_vector(C_WR_PNTR_WIDTH_WDCH-1 DOWNTO 0) := (OTHERS => '0');
    AXI_W_DATA_COUNT               : OUT std_logic_vector(C_WR_PNTR_WIDTH_WDCH DOWNTO 0);
    AXI_W_WR_DATA_COUNT            : OUT std_logic_vector(C_WR_PNTR_WIDTH_WDCH DOWNTO 0);
    AXI_W_RD_DATA_COUNT            : OUT std_logic_vector(C_WR_PNTR_WIDTH_WDCH DOWNTO 0);
    AXI_W_SBITERR                  : OUT std_logic;
    AXI_W_DBITERR                  : OUT std_logic;
    AXI_W_OVERFLOW                 : OUT std_logic;
    AXI_W_UNDERFLOW                : OUT std_logic;

    -- AXI Full/Lite Write Response Channel Signals
    AXI_B_INJECTSBITERR            : IN  std_logic := '0';
    AXI_B_INJECTDBITERR            : IN  std_logic := '0';
    AXI_B_PROG_FULL_THRESH         : IN  std_logic_vector(C_WR_PNTR_WIDTH_WRCH-1 DOWNTO 0) := (OTHERS => '0');
    AXI_B_PROG_EMPTY_THRESH        : IN  std_logic_vector(C_WR_PNTR_WIDTH_WRCH-1 DOWNTO 0) := (OTHERS => '0');
    AXI_B_DATA_COUNT               : OUT std_logic_vector(C_WR_PNTR_WIDTH_WRCH DOWNTO 0);
    AXI_B_WR_DATA_COUNT            : OUT std_logic_vector(C_WR_PNTR_WIDTH_WRCH DOWNTO 0);
    AXI_B_RD_DATA_COUNT            : OUT std_logic_vector(C_WR_PNTR_WIDTH_WRCH DOWNTO 0);
    AXI_B_SBITERR                  : OUT std_logic;
    AXI_B_DBITERR                  : OUT std_logic;
    AXI_B_OVERFLOW                 : OUT std_logic;
    AXI_B_UNDERFLOW                : OUT std_logic;

    -- AXI Full/Lite Read Address Channel Signals
    AXI_AR_INJECTSBITERR           : IN  std_logic := '0';
    AXI_AR_INJECTDBITERR           : IN  std_logic := '0';
    AXI_AR_PROG_FULL_THRESH        : IN  std_logic_vector(C_WR_PNTR_WIDTH_RACH-1 DOWNTO 0) := (OTHERS => '0');
    AXI_AR_PROG_EMPTY_THRESH       : IN  std_logic_vector(C_WR_PNTR_WIDTH_RACH-1 DOWNTO 0) := (OTHERS => '0');
    AXI_AR_DATA_COUNT              : OUT std_logic_vector(C_WR_PNTR_WIDTH_RACH DOWNTO 0);
    AXI_AR_WR_DATA_COUNT           : OUT std_logic_vector(C_WR_PNTR_WIDTH_RACH DOWNTO 0);
    AXI_AR_RD_DATA_COUNT           : OUT std_logic_vector(C_WR_PNTR_WIDTH_RACH DOWNTO 0);
    AXI_AR_SBITERR                 : OUT std_logic;
    AXI_AR_DBITERR                 : OUT std_logic;
    AXI_AR_OVERFLOW                : OUT std_logic;
    AXI_AR_UNDERFLOW               : OUT std_logic;

    -- AXI Full/Lite Read Data Channel Signals
    AXI_R_INJECTSBITERR            : IN  std_logic := '0';
    AXI_R_INJECTDBITERR            : IN  std_logic := '0';
    AXI_R_PROG_FULL_THRESH         : IN  std_logic_vector(C_WR_PNTR_WIDTH_RDCH-1 DOWNTO 0) := (OTHERS => '0');
    AXI_R_PROG_EMPTY_THRESH        : IN  std_logic_vector(C_WR_PNTR_WIDTH_RDCH-1 DOWNTO 0) := (OTHERS => '0');
    AXI_R_DATA_COUNT               : OUT std_logic_vector(C_WR_PNTR_WIDTH_RDCH DOWNTO 0);
    AXI_R_WR_DATA_COUNT            : OUT std_logic_vector(C_WR_PNTR_WIDTH_RDCH DOWNTO 0);
    AXI_R_RD_DATA_COUNT            : OUT std_logic_vector(C_WR_PNTR_WIDTH_RDCH DOWNTO 0);
    AXI_R_SBITERR                  : OUT std_logic;
    AXI_R_DBITERR                  : OUT std_logic;
    AXI_R_OVERFLOW                 : OUT std_logic;
    AXI_R_UNDERFLOW                : OUT std_logic;

    -- AXI Streaming FIFO Related Signals
    AXIS_INJECTSBITERR             : IN  std_logic := '0';
    AXIS_INJECTDBITERR             : IN  std_logic := '0';
    AXIS_PROG_FULL_THRESH          : IN  std_logic_vector(C_WR_PNTR_WIDTH_AXIS-1 DOWNTO 0) := (OTHERS => '0');
    AXIS_PROG_EMPTY_THRESH         : IN  std_logic_vector(C_WR_PNTR_WIDTH_AXIS-1 DOWNTO 0) := (OTHERS => '0');
    AXIS_DATA_COUNT                : OUT std_logic_vector(C_WR_PNTR_WIDTH_AXIS DOWNTO 0);
    AXIS_WR_DATA_COUNT             : OUT std_logic_vector(C_WR_PNTR_WIDTH_AXIS DOWNTO 0);
    AXIS_RD_DATA_COUNT             : OUT std_logic_vector(C_WR_PNTR_WIDTH_AXIS DOWNTO 0);
    AXIS_SBITERR                   : OUT std_logic;
    AXIS_DBITERR                   : OUT std_logic;
    AXIS_OVERFLOW                  : OUT std_logic;
    AXIS_UNDERFLOW                 : OUT std_logic

    );
 END COMPONENT;


-- The following attributes tells XST that the fifo_generator_v8_1 is a black box
-- which should be generated using the command given by the value
-- of this attribute
attribute box_type of fifo_generator_v8_1: component is "black_box";
attribute GENERATOR_DEFAULT of fifo_generator_v8_1: component is 
     "generatecore com.xilinx.ip.fifo_generator_v8_1.fifo_generator_v8_1 -a map_qvirtex_to=virtex map_qrvirtex_to=virtex map_virtexe_to=virtex map_qvirtex2_to=virtex2 map_qrvirtex2_to=virtex2 map_spartan2_to=virtex map_spartan2e_to=virtex map_virtex5_to=virtex4 map_spartan3a_to=spartan3e spartan3an_to=spartan3e spartan3adsp_to=spartan3e ";

-- End FIFO Generator Component ---------------------------------------











-------------------------------------------------------------------------------------
-- Start FIFO Generator Component for fifo_generator_v8_2
-- The Component declaration for fifo_generator_v8_2 pulled from the 
-- O.48\rtf\vhdl\src\XilinxCoreLib
-- file: fifo_generator_v8_2_comp.vhd. 
-- However, to support NCSIM, Params and Ports are ordered to match the verilog 
-- definition in O.48\rtf\verilog\src\XilinxCoreLib\fifo_generator_v8_2.v .
--
-- This component is used for both dual clock (async) and synchronous fifos 
-- implemented with BRAM or distributed RAM. Hard FIFO simulation support may not
-- be provided in FIFO Generator V8.2 so not supported here.
--
-- Note: AXI ports and parameters added for this version of FIFO Generator.
--
-------------------------------------------------------------------------------------
 COMPONENT fifo_generator_v8_2
  GENERIC (
    --------------------------------------------------------------------------------
    -- Generic Declarations (verilog model ordering)
    --------------------------------------------------------------------------------
    C_COMMON_CLOCK                : integer := 0;
    C_COUNT_TYPE                  : integer := 0;
    C_DATA_COUNT_WIDTH            : integer := 2;
    C_DEFAULT_VALUE               : string  := "";
    C_DIN_WIDTH                   : integer := 8;
    C_DOUT_RST_VAL                : string  := "";
    C_DOUT_WIDTH                  : integer := 8;
    C_ENABLE_RLOCS                : integer := 0;
    C_FAMILY                      : string  := "";
    C_FULL_FLAGS_RST_VAL          : integer := 1;
    C_HAS_ALMOST_EMPTY            : integer := 0;  
    C_HAS_ALMOST_FULL             : integer := 0;
    C_HAS_BACKUP                  : integer := 0;
    C_HAS_DATA_COUNT              : integer := 0;
    C_HAS_INT_CLK                 : integer := 0;  
    C_HAS_MEMINIT_FILE            : integer := 0;
    C_HAS_OVERFLOW                : integer := 0;
    C_HAS_RD_DATA_COUNT           : integer := 0;
    C_HAS_RD_RST                  : integer := 0;
    C_HAS_RST                     : integer := 1;
    C_HAS_SRST                    : integer := 0;
    C_HAS_UNDERFLOW               : integer := 0;
    C_HAS_VALID                   : integer := 0;
    C_HAS_WR_ACK                  : integer := 0;
    C_HAS_WR_DATA_COUNT           : integer := 0;
    C_HAS_WR_RST                  : integer := 0;
    C_IMPLEMENTATION_TYPE         : integer := 0;
    C_INIT_WR_PNTR_VAL            : integer := 0;
    C_MEMORY_TYPE                 : integer := 1;
    C_MIF_FILE_NAME               : string  := "";
    C_OPTIMIZATION_MODE           : integer := 0;
    C_OVERFLOW_LOW                : integer := 0;
    C_PRELOAD_LATENCY             : integer := 1;
    C_PRELOAD_REGS                : integer := 0;
    C_PRIM_FIFO_TYPE              : string  := "4kx4";
    C_PROG_EMPTY_THRESH_ASSERT_VAL: integer := 0;
    C_PROG_EMPTY_THRESH_NEGATE_VAL: integer := 0;
    C_PROG_EMPTY_TYPE             : integer := 0;
    C_PROG_FULL_THRESH_ASSERT_VAL : integer := 0;
    C_PROG_FULL_THRESH_NEGATE_VAL : integer := 0;
    C_PROG_FULL_TYPE              : integer := 0;
    C_RD_DATA_COUNT_WIDTH         : integer := 2;
    C_RD_DEPTH                    : integer := 256;
    C_RD_FREQ                     : integer := 1;
    C_RD_PNTR_WIDTH               : integer := 8;
    C_UNDERFLOW_LOW               : integer := 0;
    C_USE_DOUT_RST                : integer := 0;
    C_USE_ECC                     : integer := 0;
    C_USE_EMBEDDED_REG            : integer := 0;
    C_USE_FIFO16_FLAGS            : integer := 0;
    C_USE_FWFT_DATA_COUNT         : integer := 0;
    C_VALID_LOW                   : integer := 0;
    C_WR_ACK_LOW                  : integer := 0;
    C_WR_DATA_COUNT_WIDTH         : integer := 2;
    C_WR_DEPTH                    : integer := 256;
    C_WR_FREQ                     : integer := 1;
    C_WR_PNTR_WIDTH               : integer := 8;
    C_WR_RESPONSE_LATENCY         : integer := 1;
    C_MSGON_VAL                   : integer := 1;
    C_ENABLE_RST_SYNC             : integer := 1;  
    C_ERROR_INJECTION_TYPE        : integer := 0;   

    -- AXI Interface related parameters start here
    C_INTERFACE_TYPE                        : integer := 0; -- 0: Native Interface; 1: AXI Interface
    C_AXI_TYPE                              : integer := 0; -- 0: AXI Stream; 1: AXI Full; 2: AXI Lite
    C_HAS_AXI_WR_CHANNEL                    : integer := 0;
    C_HAS_AXI_RD_CHANNEL                    : integer := 0;
    C_HAS_SLAVE_CE                          : integer := 0;
    C_HAS_MASTER_CE                         : integer := 0;
    C_ADD_NGC_CONSTRAINT                    : integer := 0;
    C_USE_COMMON_OVERFLOW                   : integer := 0;
    C_USE_COMMON_UNDERFLOW                  : integer := 0;
    C_USE_DEFAULT_SETTINGS                  : integer := 0;

    -- AXI Full/Lite
    C_AXI_ID_WIDTH                          : integer := 4 ;
    C_AXI_ADDR_WIDTH                        : integer := 32;
    C_AXI_DATA_WIDTH                        : integer := 64;
    C_HAS_AXI_AWUSER                        : integer := 0 ;
    C_HAS_AXI_WUSER                         : integer := 0 ;
    C_HAS_AXI_BUSER                         : integer := 0 ;
    C_HAS_AXI_ARUSER                        : integer := 0 ;
    C_HAS_AXI_RUSER                         : integer := 0 ;
    C_AXI_ARUSER_WIDTH                      : integer := 1 ;
    C_AXI_AWUSER_WIDTH                      : integer := 1 ;
    C_AXI_WUSER_WIDTH                       : integer := 1 ;
    C_AXI_BUSER_WIDTH                       : integer := 1 ;
    C_AXI_RUSER_WIDTH                       : integer := 1 ;
                                       
    -- AXI Streaming
    C_HAS_AXIS_TDATA                        : integer := 0 ;
    C_HAS_AXIS_TID                          : integer := 0 ;
    C_HAS_AXIS_TDEST                        : integer := 0 ;
    C_HAS_AXIS_TUSER                        : integer := 0 ;
    C_HAS_AXIS_TREADY                       : integer := 1 ;
    C_HAS_AXIS_TLAST                        : integer := 0 ;
    C_HAS_AXIS_TSTRB                        : integer := 0 ;
    C_HAS_AXIS_TKEEP                        : integer := 0 ;
    C_AXIS_TDATA_WIDTH                      : integer := 64;
    C_AXIS_TID_WIDTH                        : integer := 8 ;
    C_AXIS_TDEST_WIDTH                      : integer := 4 ;
    C_AXIS_TUSER_WIDTH                      : integer := 4 ;
    C_AXIS_TSTRB_WIDTH                      : integer := 4 ;
    C_AXIS_TKEEP_WIDTH                      : integer := 4 ;

    -- AXI Channel Type
    -- WACH --> Write Address Channel
    -- WDCH --> Write Data Channel
    -- WRCH --> Write Response Channel
    -- RACH --> Read Address Channel
    -- RDCH --> Read Data Channel
    -- AXIS --> AXI Streaming
    C_WACH_TYPE                             : integer := 0; -- 0 = FIFO; 1 = Register Slice; 2 = Pass Through Logic
    C_WDCH_TYPE                             : integer := 0; -- 0 = FIFO; 1 = Register Slice; 2 = Pass Through Logie
    C_WRCH_TYPE                             : integer := 0; -- 0 = FIFO; 1 = Register Slice; 2 = Pass Through Logie
    C_RACH_TYPE                             : integer := 0; -- 0 = FIFO; 1 = Register Slice; 2 = Pass Through Logie
    C_RDCH_TYPE                             : integer := 0; -- 0 = FIFO; 1 = Register Slice; 2 = Pass Through Logie
    C_AXIS_TYPE                             : integer := 0; -- 0 = FIFO; 1 = Register Slice; 2 = Pass Through Logie

    -- AXI Implementation Type
    -- 1 = Common Clock Block RAM FIFO
    -- 2 = Common Clock Distributed RAM FIFO
    -- 11 = Independent Clock Block RAM FIFO
    -- 12 = Independent Clock Distributed RAM FIFO
    C_IMPLEMENTATION_TYPE_WACH              : integer := 1;
    C_IMPLEMENTATION_TYPE_WDCH              : integer := 1;
    C_IMPLEMENTATION_TYPE_WRCH              : integer := 1;
    C_IMPLEMENTATION_TYPE_RACH              : integer := 1;
    C_IMPLEMENTATION_TYPE_RDCH              : integer := 1;
    C_IMPLEMENTATION_TYPE_AXIS              : integer := 1;

    -- AXI FIFO Type
    -- 0 = Data FIFO
    -- 1 = Packet FIFO
    -- 2 = Low Latency Data FIFO
    C_APPLICATION_TYPE_WACH                 : integer := 0;
    C_APPLICATION_TYPE_WDCH                 : integer := 0;
    C_APPLICATION_TYPE_WRCH                 : integer := 0;
    C_APPLICATION_TYPE_RACH                 : integer := 0;
    C_APPLICATION_TYPE_RDCH                 : integer := 0;
    C_APPLICATION_TYPE_AXIS                 : integer := 0;

    -- Enable ECC
    -- 0 = ECC disabled
    -- 1 = ECC enabled
    C_USE_ECC_WACH                          : integer := 0;
    C_USE_ECC_WDCH                          : integer := 0;
    C_USE_ECC_WRCH                          : integer := 0;
    C_USE_ECC_RACH                          : integer := 0;
    C_USE_ECC_RDCH                          : integer := 0;
    C_USE_ECC_AXIS                          : integer := 0;

    -- ECC Error Injection Type
    -- 0 = No Error Injection
    -- 1 = Single Bit Error Injection
    -- 2 = Double Bit Error Injection
    -- 3 = Single Bit and Double Bit Error Injection
    C_ERROR_INJECTION_TYPE_WACH             : integer := 0;
    C_ERROR_INJECTION_TYPE_WDCH             : integer := 0;
    C_ERROR_INJECTION_TYPE_WRCH             : integer := 0;
    C_ERROR_INJECTION_TYPE_RACH             : integer := 0;
    C_ERROR_INJECTION_TYPE_RDCH             : integer := 0;
    C_ERROR_INJECTION_TYPE_AXIS             : integer := 0;

    -- Input Data Width
    -- Accumulation of all AXI input signal's width
    C_DIN_WIDTH_WACH                        : integer := 32;
    C_DIN_WIDTH_WDCH                        : integer := 64;
    C_DIN_WIDTH_WRCH                        : integer := 2 ;
    C_DIN_WIDTH_RACH                        : integer := 32;
    C_DIN_WIDTH_RDCH                        : integer := 64;
    C_DIN_WIDTH_AXIS                        : integer := 1 ;

    C_WR_DEPTH_WACH                         : integer := 16  ;
    C_WR_DEPTH_WDCH                         : integer := 1024;
    C_WR_DEPTH_WRCH                         : integer := 16  ;
    C_WR_DEPTH_RACH                         : integer := 16  ;
    C_WR_DEPTH_RDCH                         : integer := 1024;
    C_WR_DEPTH_AXIS                         : integer := 1024;

    C_WR_PNTR_WIDTH_WACH                    : integer := 4 ;
    C_WR_PNTR_WIDTH_WDCH                    : integer := 10;
    C_WR_PNTR_WIDTH_WRCH                    : integer := 4 ;
    C_WR_PNTR_WIDTH_RACH                    : integer := 4 ;
    C_WR_PNTR_WIDTH_RDCH                    : integer := 10;
    C_WR_PNTR_WIDTH_AXIS                    : integer := 10;

    C_HAS_DATA_COUNTS_WACH                  : integer := 0;
    C_HAS_DATA_COUNTS_WDCH                  : integer := 0;
    C_HAS_DATA_COUNTS_WRCH                  : integer := 0;
    C_HAS_DATA_COUNTS_RACH                  : integer := 0;
    C_HAS_DATA_COUNTS_RDCH                  : integer := 0;
    C_HAS_DATA_COUNTS_AXIS                  : integer := 0;

    C_HAS_PROG_FLAGS_WACH                   : integer := 0;
    C_HAS_PROG_FLAGS_WDCH                   : integer := 0;
    C_HAS_PROG_FLAGS_WRCH                   : integer := 0;
    C_HAS_PROG_FLAGS_RACH                   : integer := 0;
    C_HAS_PROG_FLAGS_RDCH                   : integer := 0;
    C_HAS_PROG_FLAGS_AXIS                   : integer := 0;

    C_PROG_FULL_TYPE_WACH                   : integer := 5   ;
    C_PROG_FULL_TYPE_WDCH                   : integer := 5   ;
    C_PROG_FULL_TYPE_WRCH                   : integer := 5   ;
    C_PROG_FULL_TYPE_RACH                   : integer := 5   ;
    C_PROG_FULL_TYPE_RDCH                   : integer := 5   ;
    C_PROG_FULL_TYPE_AXIS                   : integer := 5   ;
    C_PROG_FULL_THRESH_ASSERT_VAL_WACH      : integer := 1023;
    C_PROG_FULL_THRESH_ASSERT_VAL_WDCH      : integer := 1023;
    C_PROG_FULL_THRESH_ASSERT_VAL_WRCH      : integer := 1023;
    C_PROG_FULL_THRESH_ASSERT_VAL_RACH      : integer := 1023;
    C_PROG_FULL_THRESH_ASSERT_VAL_RDCH      : integer := 1023;
    C_PROG_FULL_THRESH_ASSERT_VAL_AXIS      : integer := 1023;

    C_PROG_EMPTY_TYPE_WACH                  : integer := 5   ;
    C_PROG_EMPTY_TYPE_WDCH                  : integer := 5   ;
    C_PROG_EMPTY_TYPE_WRCH                  : integer := 5   ;
    C_PROG_EMPTY_TYPE_RACH                  : integer := 5   ;
    C_PROG_EMPTY_TYPE_RDCH                  : integer := 5   ;
    C_PROG_EMPTY_TYPE_AXIS                  : integer := 5   ;
    C_PROG_EMPTY_THRESH_ASSERT_VAL_WACH     : integer := 1022;
    C_PROG_EMPTY_THRESH_ASSERT_VAL_WDCH     : integer := 1022;
    C_PROG_EMPTY_THRESH_ASSERT_VAL_WRCH     : integer := 1022;
    C_PROG_EMPTY_THRESH_ASSERT_VAL_RACH     : integer := 1022;
    C_PROG_EMPTY_THRESH_ASSERT_VAL_RDCH     : integer := 1022;
    C_PROG_EMPTY_THRESH_ASSERT_VAL_AXIS     : integer := 1022;

    C_REG_SLICE_MODE_WACH                   : integer := 0;
    C_REG_SLICE_MODE_WDCH                   : integer := 0;
    C_REG_SLICE_MODE_WRCH                   : integer := 0;
    C_REG_SLICE_MODE_RACH                   : integer := 0;
    C_REG_SLICE_MODE_RDCH                   : integer := 0;
    C_REG_SLICE_MODE_AXIS                   : integer := 0

    );
  PORT(
--------------------------------------------------------------------------------
-- Input and Output Declarations
--------------------------------------------------------------------------------
    BACKUP                         : IN  std_logic := '0';
    BACKUP_MARKER                  : IN  std_logic := '0';
    CLK                            : IN  std_logic := '0';
    RST                            : IN  std_logic := '0';
    SRST                           : IN  std_logic := '0';
    WR_CLK                         : IN  std_logic := '0';
    WR_RST                         : IN  std_logic := '0';
    RD_CLK                         : IN  std_logic := '0';
    RD_RST                         : IN  std_logic := '0';
    DIN                            : IN  std_logic_vector(C_DIN_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    WR_EN                          : IN  std_logic := '0';  --Mandatory input
    RD_EN                          : IN  std_logic := '0';  --Mandatory input
    PROG_EMPTY_THRESH              : IN  std_logic_vector(C_RD_PNTR_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    PROG_EMPTY_THRESH_ASSERT       : IN  std_logic_vector(C_RD_PNTR_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    PROG_EMPTY_THRESH_NEGATE       : IN  std_logic_vector(C_RD_PNTR_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    PROG_FULL_THRESH               : IN  std_logic_vector(C_WR_PNTR_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    PROG_FULL_THRESH_ASSERT        : IN  std_logic_vector(C_WR_PNTR_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    PROG_FULL_THRESH_NEGATE        : IN  std_logic_vector(C_WR_PNTR_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    INT_CLK                        : IN  std_logic := '0';
    INJECTDBITERR                  : IN  std_logic := '0';  
    INJECTSBITERR                  : IN  std_logic := '0';  

    DOUT                           : OUT std_logic_vector(C_DOUT_WIDTH-1 DOWNTO 0);
    FULL                           : OUT std_logic;
    ALMOST_FULL                    : OUT std_logic;
    WR_ACK                         : OUT std_logic;
    OVERFLOW                       : OUT std_logic;
    EMPTY                          : OUT std_logic;
    ALMOST_EMPTY                   : OUT std_logic;
    VALID                          : OUT std_logic;
    UNDERFLOW                      : OUT std_logic;
    DATA_COUNT                     : OUT std_logic_vector(C_DATA_COUNT_WIDTH-1 DOWNTO 0);
    RD_DATA_COUNT                  : OUT std_logic_vector(C_RD_DATA_COUNT_WIDTH-1 DOWNTO 0);
    WR_DATA_COUNT                  : OUT std_logic_vector(C_WR_DATA_COUNT_WIDTH-1 DOWNTO 0);
    PROG_FULL                      : OUT std_logic;
    PROG_EMPTY                     : OUT std_logic;
    SBITERR                        : OUT std_logic;
    DBITERR                        : OUT std_logic;
    
    -- AXI Global Signal
    M_ACLK                         : IN  std_logic := '0';
    S_ACLK                         : IN  std_logic := '0';
    S_ARESETN                      : IN  std_logic := '0';
    M_ACLK_EN                      : IN  std_logic := '0';
    S_ACLK_EN                      : IN  std_logic := '0';

    -- AXI Full/Lite Slave Write Channel (write side)
    S_AXI_AWID                     : IN  std_logic_vector(C_AXI_ID_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_AWADDR                   : IN  std_logic_vector(C_AXI_ADDR_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_AWLEN                    : IN  std_logic_vector(8-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_AWSIZE                   : IN  std_logic_vector(3-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_AWBURST                  : IN  std_logic_vector(2-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_AWLOCK                   : IN  std_logic_vector(2-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_AWCACHE                  : IN  std_logic_vector(4-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_AWPROT                   : IN  std_logic_vector(3-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_AWQOS                    : IN  std_logic_vector(4-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_AWREGION                 : IN  std_logic_vector(4-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_AWUSER                   : IN  std_logic_vector(C_AXI_AWUSER_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_AWVALID                  : IN  std_logic := '0';
    S_AXI_AWREADY                  : OUT std_logic;
    S_AXI_WID                      : IN  std_logic_vector(C_AXI_ID_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_WDATA                    : IN  std_logic_vector(C_AXI_DATA_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_WSTRB                    : IN  std_logic_vector(C_AXI_DATA_WIDTH/8-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_WLAST                    : IN  std_logic := '0';
    S_AXI_WUSER                    : IN  std_logic_vector(C_AXI_WUSER_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_WVALID                   : IN  std_logic := '0';
    S_AXI_WREADY                   : OUT std_logic;
    S_AXI_BID                      : OUT std_logic_vector(C_AXI_ID_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_BRESP                    : OUT std_logic_vector(2-1 DOWNTO 0);
    S_AXI_BUSER                    : OUT std_logic_vector(C_AXI_BUSER_WIDTH-1 DOWNTO 0);
    S_AXI_BVALID                   : OUT std_logic;
    S_AXI_BREADY                   : IN  std_logic := '0';

    -- AXI Full/Lite Master Write Channel (Read side)
    M_AXI_AWID                     : OUT std_logic_vector(C_AXI_ID_WIDTH-1 DOWNTO 0);
    M_AXI_AWADDR                   : OUT std_logic_vector(C_AXI_ADDR_WIDTH-1 DOWNTO 0);
    M_AXI_AWLEN                    : OUT std_logic_vector(8-1 DOWNTO 0);
    M_AXI_AWSIZE                   : OUT std_logic_vector(3-1 DOWNTO 0);
    M_AXI_AWBURST                  : OUT std_logic_vector(2-1 DOWNTO 0);
    M_AXI_AWLOCK                   : OUT std_logic_vector(2-1 DOWNTO 0);
    M_AXI_AWCACHE                  : OUT std_logic_vector(4-1 DOWNTO 0);
    M_AXI_AWPROT                   : OUT std_logic_vector(3-1 DOWNTO 0);
    M_AXI_AWQOS                    : OUT std_logic_vector(4-1 DOWNTO 0);
    M_AXI_AWREGION                 : OUT std_logic_vector(4-1 DOWNTO 0);
    M_AXI_AWUSER                   : OUT std_logic_vector(C_AXI_AWUSER_WIDTH-1 DOWNTO 0);
    M_AXI_AWVALID                  : OUT std_logic;
    M_AXI_AWREADY                  : IN  std_logic := '0';
    M_AXI_WID                      : OUT std_logic_vector(C_AXI_ID_WIDTH-1 DOWNTO 0);
    M_AXI_WDATA                    : OUT std_logic_vector(C_AXI_DATA_WIDTH-1 DOWNTO 0);
    M_AXI_WSTRB                    : OUT std_logic_vector(C_AXI_DATA_WIDTH/8-1 DOWNTO 0);
    M_AXI_WLAST                    : OUT std_logic;
    M_AXI_WUSER                    : OUT std_logic_vector(C_AXI_WUSER_WIDTH-1 DOWNTO 0);
    M_AXI_WVALID                   : OUT std_logic;
    M_AXI_WREADY                   : IN  std_logic := '0';
    M_AXI_BID                      : IN  std_logic_vector(C_AXI_ID_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    M_AXI_BRESP                    : IN  std_logic_vector(2-1 DOWNTO 0) := (OTHERS => '0');
    M_AXI_BUSER                    : IN  std_logic_vector(C_AXI_BUSER_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    M_AXI_BVALID                   : IN  std_logic := '0';
    M_AXI_BREADY                   : OUT std_logic;

    -- AXI Full/Lite Slave Read Channel (Write side)
    S_AXI_ARID                     : IN  std_logic_vector(C_AXI_ID_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_ARADDR                   : IN  std_logic_vector(C_AXI_ADDR_WIDTH-1 DOWNTO 0) := (OTHERS => '0'); 
    S_AXI_ARLEN                    : IN  std_logic_vector(8-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_ARSIZE                   : IN  std_logic_vector(3-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_ARBURST                  : IN  std_logic_vector(2-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_ARLOCK                   : IN  std_logic_vector(2-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_ARCACHE                  : IN  std_logic_vector(4-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_ARPROT                   : IN  std_logic_vector(3-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_ARQOS                    : IN  std_logic_vector(4-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_ARREGION                 : IN  std_logic_vector(4-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_ARUSER                   : IN  std_logic_vector(C_AXI_ARUSER_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_ARVALID                  : IN  std_logic := '0';
    S_AXI_ARREADY                  : OUT std_logic;
    S_AXI_RID                      : OUT std_logic_vector(C_AXI_ID_WIDTH-1 DOWNTO 0);       
    S_AXI_RDATA                    : OUT std_logic_vector(C_AXI_DATA_WIDTH-1 DOWNTO 0); 
    S_AXI_RRESP                    : OUT std_logic_vector(2-1 DOWNTO 0);
    S_AXI_RLAST                    : OUT std_logic;
    S_AXI_RUSER                    : OUT std_logic_vector(C_AXI_RUSER_WIDTH-1 DOWNTO 0);
    S_AXI_RVALID                   : OUT std_logic;
    S_AXI_RREADY                   : IN  std_logic := '0';

    -- AXI Full/Lite Master Read Channel (Read side)
    M_AXI_ARID                     : OUT std_logic_vector(C_AXI_ID_WIDTH-1 DOWNTO 0);        
    M_AXI_ARADDR                   : OUT std_logic_vector(C_AXI_ADDR_WIDTH-1 DOWNTO 0);  
    M_AXI_ARLEN                    : OUT std_logic_vector(8-1 DOWNTO 0);
    M_AXI_ARSIZE                   : OUT std_logic_vector(3-1 DOWNTO 0);
    M_AXI_ARBURST                  : OUT std_logic_vector(2-1 DOWNTO 0);
    M_AXI_ARLOCK                   : OUT std_logic_vector(2-1 DOWNTO 0);
    M_AXI_ARCACHE                  : OUT std_logic_vector(4-1 DOWNTO 0);
    M_AXI_ARPROT                   : OUT std_logic_vector(3-1 DOWNTO 0);
    M_AXI_ARQOS                    : OUT std_logic_vector(4-1 DOWNTO 0);
    M_AXI_ARREGION                 : OUT std_logic_vector(4-1 DOWNTO 0);
    M_AXI_ARUSER                   : OUT std_logic_vector(C_AXI_ARUSER_WIDTH-1 DOWNTO 0);
    M_AXI_ARVALID                  : OUT std_logic;
    M_AXI_ARREADY                  : IN  std_logic := '0';
    M_AXI_RID                      : IN  std_logic_vector(C_AXI_ID_WIDTH-1 DOWNTO 0) := (OTHERS => '0');        
    M_AXI_RDATA                    : IN  std_logic_vector(C_AXI_DATA_WIDTH-1 DOWNTO 0) := (OTHERS => '0');  
    M_AXI_RRESP                    : IN  std_logic_vector(2-1 DOWNTO 0) := (OTHERS => '0');
    M_AXI_RLAST                    : IN  std_logic := '0';
    M_AXI_RUSER                    : IN  std_logic_vector(C_AXI_RUSER_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    M_AXI_RVALID                   : IN  std_logic := '0';
    M_AXI_RREADY                   : OUT std_logic;

    -- AXI Streaming Slave Signals (Write side)
    S_AXIS_TVALID                  : IN  std_logic := '0';
    S_AXIS_TREADY                  : OUT std_logic;
    S_AXIS_TDATA                   : IN  std_logic_vector(C_AXIS_TDATA_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    S_AXIS_TSTRB                   : IN  std_logic_vector(C_AXIS_TSTRB_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    S_AXIS_TKEEP                   : IN  std_logic_vector(C_AXIS_TKEEP_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    S_AXIS_TLAST                   : IN  std_logic := '0';
    S_AXIS_TID                     : IN  std_logic_vector(C_AXIS_TID_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    S_AXIS_TDEST                   : IN  std_logic_vector(C_AXIS_TDEST_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    S_AXIS_TUSER                   : IN  std_logic_vector(C_AXIS_TUSER_WIDTH-1 DOWNTO 0) := (OTHERS => '0');

    -- AXI Streaming Master Signals (Read side)
    M_AXIS_TVALID                  : OUT std_logic;
    M_AXIS_TREADY                  : IN  std_logic := '0';
    M_AXIS_TDATA                   : OUT std_logic_vector(C_AXIS_TDATA_WIDTH-1 DOWNTO 0);
    M_AXIS_TSTRB                   : OUT std_logic_vector(C_AXIS_TSTRB_WIDTH-1 DOWNTO 0);
    M_AXIS_TKEEP                   : OUT std_logic_vector(C_AXIS_TKEEP_WIDTH-1 DOWNTO 0);
    M_AXIS_TLAST                   : OUT std_logic;
    M_AXIS_TID                     : OUT std_logic_vector(C_AXIS_TID_WIDTH-1 DOWNTO 0);
    M_AXIS_TDEST                   : OUT std_logic_vector(C_AXIS_TDEST_WIDTH-1 DOWNTO 0);
    M_AXIS_TUSER                   : OUT std_logic_vector(C_AXIS_TUSER_WIDTH-1 DOWNTO 0);

    -- AXI Full/Lite Write Address Channel Signals
    AXI_AW_INJECTSBITERR           : IN  std_logic := '0';
    AXI_AW_INJECTDBITERR           : IN  std_logic := '0';
    AXI_AW_PROG_FULL_THRESH        : IN  std_logic_vector(C_WR_PNTR_WIDTH_WACH-1 DOWNTO 0) := (OTHERS => '0');
    AXI_AW_PROG_EMPTY_THRESH       : IN  std_logic_vector(C_WR_PNTR_WIDTH_WACH-1 DOWNTO 0) := (OTHERS => '0');
    AXI_AW_DATA_COUNT              : OUT std_logic_vector(C_WR_PNTR_WIDTH_WACH DOWNTO 0);
    AXI_AW_WR_DATA_COUNT           : OUT std_logic_vector(C_WR_PNTR_WIDTH_WACH DOWNTO 0);
    AXI_AW_RD_DATA_COUNT           : OUT std_logic_vector(C_WR_PNTR_WIDTH_WACH DOWNTO 0);
    AXI_AW_SBITERR                 : OUT std_logic;
    AXI_AW_DBITERR                 : OUT std_logic;
    AXI_AW_OVERFLOW                : OUT std_logic;
    AXI_AW_UNDERFLOW               : OUT std_logic;

    -- AXI Full/Lite Write Data Channel Signals
    AXI_W_INJECTSBITERR            : IN  std_logic := '0';
    AXI_W_INJECTDBITERR            : IN  std_logic := '0';
    AXI_W_PROG_FULL_THRESH         : IN  std_logic_vector(C_WR_PNTR_WIDTH_WDCH-1 DOWNTO 0) := (OTHERS => '0');
    AXI_W_PROG_EMPTY_THRESH        : IN  std_logic_vector(C_WR_PNTR_WIDTH_WDCH-1 DOWNTO 0) := (OTHERS => '0');
    AXI_W_DATA_COUNT               : OUT std_logic_vector(C_WR_PNTR_WIDTH_WDCH DOWNTO 0);
    AXI_W_WR_DATA_COUNT            : OUT std_logic_vector(C_WR_PNTR_WIDTH_WDCH DOWNTO 0);
    AXI_W_RD_DATA_COUNT            : OUT std_logic_vector(C_WR_PNTR_WIDTH_WDCH DOWNTO 0);
    AXI_W_SBITERR                  : OUT std_logic;
    AXI_W_DBITERR                  : OUT std_logic;
    AXI_W_OVERFLOW                 : OUT std_logic;
    AXI_W_UNDERFLOW                : OUT std_logic;

    -- AXI Full/Lite Write Response Channel Signals
    AXI_B_INJECTSBITERR            : IN  std_logic := '0';
    AXI_B_INJECTDBITERR            : IN  std_logic := '0';
    AXI_B_PROG_FULL_THRESH         : IN  std_logic_vector(C_WR_PNTR_WIDTH_WRCH-1 DOWNTO 0) := (OTHERS => '0');
    AXI_B_PROG_EMPTY_THRESH        : IN  std_logic_vector(C_WR_PNTR_WIDTH_WRCH-1 DOWNTO 0) := (OTHERS => '0');
    AXI_B_DATA_COUNT               : OUT std_logic_vector(C_WR_PNTR_WIDTH_WRCH DOWNTO 0);
    AXI_B_WR_DATA_COUNT            : OUT std_logic_vector(C_WR_PNTR_WIDTH_WRCH DOWNTO 0);
    AXI_B_RD_DATA_COUNT            : OUT std_logic_vector(C_WR_PNTR_WIDTH_WRCH DOWNTO 0);
    AXI_B_SBITERR                  : OUT std_logic;
    AXI_B_DBITERR                  : OUT std_logic;
    AXI_B_OVERFLOW                 : OUT std_logic;
    AXI_B_UNDERFLOW                : OUT std_logic;

    -- AXI Full/Lite Read Address Channel Signals
    AXI_AR_INJECTSBITERR           : IN  std_logic := '0';
    AXI_AR_INJECTDBITERR           : IN  std_logic := '0';
    AXI_AR_PROG_FULL_THRESH        : IN  std_logic_vector(C_WR_PNTR_WIDTH_RACH-1 DOWNTO 0) := (OTHERS => '0');
    AXI_AR_PROG_EMPTY_THRESH       : IN  std_logic_vector(C_WR_PNTR_WIDTH_RACH-1 DOWNTO 0) := (OTHERS => '0');
    AXI_AR_DATA_COUNT              : OUT std_logic_vector(C_WR_PNTR_WIDTH_RACH DOWNTO 0);
    AXI_AR_WR_DATA_COUNT           : OUT std_logic_vector(C_WR_PNTR_WIDTH_RACH DOWNTO 0);
    AXI_AR_RD_DATA_COUNT           : OUT std_logic_vector(C_WR_PNTR_WIDTH_RACH DOWNTO 0);
    AXI_AR_SBITERR                 : OUT std_logic;
    AXI_AR_DBITERR                 : OUT std_logic;
    AXI_AR_OVERFLOW                : OUT std_logic;
    AXI_AR_UNDERFLOW               : OUT std_logic;

    -- AXI Full/Lite Read Data Channel Signals
    AXI_R_INJECTSBITERR            : IN  std_logic := '0';
    AXI_R_INJECTDBITERR            : IN  std_logic := '0';
    AXI_R_PROG_FULL_THRESH         : IN  std_logic_vector(C_WR_PNTR_WIDTH_RDCH-1 DOWNTO 0) := (OTHERS => '0');
    AXI_R_PROG_EMPTY_THRESH        : IN  std_logic_vector(C_WR_PNTR_WIDTH_RDCH-1 DOWNTO 0) := (OTHERS => '0');
    AXI_R_DATA_COUNT               : OUT std_logic_vector(C_WR_PNTR_WIDTH_RDCH DOWNTO 0);
    AXI_R_WR_DATA_COUNT            : OUT std_logic_vector(C_WR_PNTR_WIDTH_RDCH DOWNTO 0);
    AXI_R_RD_DATA_COUNT            : OUT std_logic_vector(C_WR_PNTR_WIDTH_RDCH DOWNTO 0);
    AXI_R_SBITERR                  : OUT std_logic;
    AXI_R_DBITERR                  : OUT std_logic;
    AXI_R_OVERFLOW                 : OUT std_logic;
    AXI_R_UNDERFLOW                : OUT std_logic;

    -- AXI Streaming FIFO Related Signals
    AXIS_INJECTSBITERR             : IN  std_logic := '0';
    AXIS_INJECTDBITERR             : IN  std_logic := '0';
    AXIS_PROG_FULL_THRESH          : IN  std_logic_vector(C_WR_PNTR_WIDTH_AXIS-1 DOWNTO 0) := (OTHERS => '0');
    AXIS_PROG_EMPTY_THRESH         : IN  std_logic_vector(C_WR_PNTR_WIDTH_AXIS-1 DOWNTO 0) := (OTHERS => '0');
    AXIS_DATA_COUNT                : OUT std_logic_vector(C_WR_PNTR_WIDTH_AXIS DOWNTO 0);
    AXIS_WR_DATA_COUNT             : OUT std_logic_vector(C_WR_PNTR_WIDTH_AXIS DOWNTO 0);
    AXIS_RD_DATA_COUNT             : OUT std_logic_vector(C_WR_PNTR_WIDTH_AXIS DOWNTO 0);
    AXIS_SBITERR                   : OUT std_logic;
    AXIS_DBITERR                   : OUT std_logic;
    AXIS_OVERFLOW                  : OUT std_logic;
    AXIS_UNDERFLOW                 : OUT std_logic

    );
 END COMPONENT;


-- The following attributes tells XST that the fifo_generator_v8_2 is a black box
-- which should be generated using the command given by the value
-- of this attribute
attribute box_type of fifo_generator_v8_2: component is "black_box";
attribute GENERATOR_DEFAULT of fifo_generator_v8_2: component is 
     "generatecore com.xilinx.ip.fifo_generator_v8_2.fifo_generator_v8_2 -a map_qvirtex_to=virtex map_qrvirtex_to=virtex map_virtexe_to=virtex map_qvirtex2_to=virtex2 map_qrvirtex2_to=virtex2 map_spartan2_to=virtex map_spartan2e_to=virtex map_virtex5_to=virtex4 map_spartan3a_to=spartan3e spartan3an_to=spartan3e spartan3adsp_to=spartan3e ";

-- End FIFO Generator Component ---------------------------------------






-------------------------------------------------------------------------------------
-- Start FIFO Generator Component for fifo_generator_v8_3
-- The Component declaration for fifo_generator_v8_3 pulled from the 
-- O.48\rtf\vhdl\src\XilinxCoreLib
-- file: fifo_generator_v8_3_comp.vhd. 
-- However, to support NCSIM, Params and Ports are ordered to match the verilog 
-- definition in O.48\rtf\verilog\src\XilinxCoreLib\fifo_generator_v8_3.v .
--
-- This component is used for both dual clock (async) and synchronous fifos 
-- implemented with BRAM or distributed RAM. Hard FIFO simulation support may not
-- be provided in FIFO Generator V8.2 so not supported here.
--
-- Note: AXI ports and parameters added for this version of FIFO Generator.
--
-------------------------------------------------------------------------------------
 COMPONENT fifo_generator_v8_3
  GENERIC (
    --------------------------------------------------------------------------------
    -- Generic Declarations (verilog model ordering)
    --------------------------------------------------------------------------------
    C_COMMON_CLOCK                : integer := 0;
    C_COUNT_TYPE                  : integer := 0;
    C_DATA_COUNT_WIDTH            : integer := 2;
    C_DEFAULT_VALUE               : string  := "";
    C_DIN_WIDTH                   : integer := 8;
    C_DOUT_RST_VAL                : string  := "";
    C_DOUT_WIDTH                  : integer := 8;
    C_ENABLE_RLOCS                : integer := 0;
    C_FAMILY                      : string  := "";
    C_FULL_FLAGS_RST_VAL          : integer := 1;
    C_HAS_ALMOST_EMPTY            : integer := 0;  
    C_HAS_ALMOST_FULL             : integer := 0;
    C_HAS_BACKUP                  : integer := 0;
    C_HAS_DATA_COUNT              : integer := 0;
    C_HAS_INT_CLK                 : integer := 0;  
    C_HAS_MEMINIT_FILE            : integer := 0;
    C_HAS_OVERFLOW                : integer := 0;
    C_HAS_RD_DATA_COUNT           : integer := 0;
    C_HAS_RD_RST                  : integer := 0;
    C_HAS_RST                     : integer := 1;
    C_HAS_SRST                    : integer := 0;
    C_HAS_UNDERFLOW               : integer := 0;
    C_HAS_VALID                   : integer := 0;
    C_HAS_WR_ACK                  : integer := 0;
    C_HAS_WR_DATA_COUNT           : integer := 0;
    C_HAS_WR_RST                  : integer := 0;
    C_IMPLEMENTATION_TYPE         : integer := 0;
    C_INIT_WR_PNTR_VAL            : integer := 0;
    C_MEMORY_TYPE                 : integer := 1;
    C_MIF_FILE_NAME               : string  := "";
    C_OPTIMIZATION_MODE           : integer := 0;
    C_OVERFLOW_LOW                : integer := 0;
    C_PRELOAD_LATENCY             : integer := 1;
    C_PRELOAD_REGS                : integer := 0;
    C_PRIM_FIFO_TYPE              : string  := "4kx4";
    C_PROG_EMPTY_THRESH_ASSERT_VAL: integer := 0;
    C_PROG_EMPTY_THRESH_NEGATE_VAL: integer := 0;
    C_PROG_EMPTY_TYPE             : integer := 0;
    C_PROG_FULL_THRESH_ASSERT_VAL : integer := 0;
    C_PROG_FULL_THRESH_NEGATE_VAL : integer := 0;
    C_PROG_FULL_TYPE              : integer := 0;
    C_RD_DATA_COUNT_WIDTH         : integer := 2;
    C_RD_DEPTH                    : integer := 256;
    C_RD_FREQ                     : integer := 1;
    C_RD_PNTR_WIDTH               : integer := 8;
    C_UNDERFLOW_LOW               : integer := 0;
    C_USE_DOUT_RST                : integer := 0;
    C_USE_ECC                     : integer := 0;
    C_USE_EMBEDDED_REG            : integer := 0;
    C_USE_FIFO16_FLAGS            : integer := 0;
    C_USE_FWFT_DATA_COUNT         : integer := 0;
    C_VALID_LOW                   : integer := 0;
    C_WR_ACK_LOW                  : integer := 0;
    C_WR_DATA_COUNT_WIDTH         : integer := 2;
    C_WR_DEPTH                    : integer := 256;
    C_WR_FREQ                     : integer := 1;
    C_WR_PNTR_WIDTH               : integer := 8;
    C_WR_RESPONSE_LATENCY         : integer := 1;
    C_MSGON_VAL                   : integer := 1;
    C_ENABLE_RST_SYNC             : integer := 1;  
    C_ERROR_INJECTION_TYPE        : integer := 0;   

    -- AXI Interface related parameters start here
    C_INTERFACE_TYPE                        : integer := 0; -- 0: Native Interface; 1: AXI Interface
    C_AXI_TYPE                              : integer := 0; -- 0: AXI Stream; 1: AXI Full; 2: AXI Lite
    C_HAS_AXI_WR_CHANNEL                    : integer := 0;
    C_HAS_AXI_RD_CHANNEL                    : integer := 0;
    C_HAS_SLAVE_CE                          : integer := 0;
    C_HAS_MASTER_CE                         : integer := 0;
    C_ADD_NGC_CONSTRAINT                    : integer := 0;
    C_USE_COMMON_OVERFLOW                   : integer := 0;
    C_USE_COMMON_UNDERFLOW                  : integer := 0;
    C_USE_DEFAULT_SETTINGS                  : integer := 0;

    -- AXI Full/Lite
    C_AXI_ID_WIDTH                          : integer := 4 ;
    C_AXI_ADDR_WIDTH                        : integer := 32;
    C_AXI_DATA_WIDTH                        : integer := 64;
    C_HAS_AXI_AWUSER                        : integer := 0 ;
    C_HAS_AXI_WUSER                         : integer := 0 ;
    C_HAS_AXI_BUSER                         : integer := 0 ;
    C_HAS_AXI_ARUSER                        : integer := 0 ;
    C_HAS_AXI_RUSER                         : integer := 0 ;
    C_AXI_ARUSER_WIDTH                      : integer := 1 ;
    C_AXI_AWUSER_WIDTH                      : integer := 1 ;
    C_AXI_WUSER_WIDTH                       : integer := 1 ;
    C_AXI_BUSER_WIDTH                       : integer := 1 ;
    C_AXI_RUSER_WIDTH                       : integer := 1 ;
                                       
    -- AXI Streaming
    C_HAS_AXIS_TDATA                        : integer := 0 ;
    C_HAS_AXIS_TID                          : integer := 0 ;
    C_HAS_AXIS_TDEST                        : integer := 0 ;
    C_HAS_AXIS_TUSER                        : integer := 0 ;
    C_HAS_AXIS_TREADY                       : integer := 1 ;
    C_HAS_AXIS_TLAST                        : integer := 0 ;
    C_HAS_AXIS_TSTRB                        : integer := 0 ;
    C_HAS_AXIS_TKEEP                        : integer := 0 ;
    C_AXIS_TDATA_WIDTH                      : integer := 64;
    C_AXIS_TID_WIDTH                        : integer := 8 ;
    C_AXIS_TDEST_WIDTH                      : integer := 4 ;
    C_AXIS_TUSER_WIDTH                      : integer := 4 ;
    C_AXIS_TSTRB_WIDTH                      : integer := 4 ;
    C_AXIS_TKEEP_WIDTH                      : integer := 4 ;

    -- AXI Channel Type
    -- WACH --> Write Address Channel
    -- WDCH --> Write Data Channel
    -- WRCH --> Write Response Channel
    -- RACH --> Read Address Channel
    -- RDCH --> Read Data Channel
    -- AXIS --> AXI Streaming
    C_WACH_TYPE                             : integer := 0; -- 0 = FIFO; 1 = Register Slice; 2 = Pass Through Logic
    C_WDCH_TYPE                             : integer := 0; -- 0 = FIFO; 1 = Register Slice; 2 = Pass Through Logie
    C_WRCH_TYPE                             : integer := 0; -- 0 = FIFO; 1 = Register Slice; 2 = Pass Through Logie
    C_RACH_TYPE                             : integer := 0; -- 0 = FIFO; 1 = Register Slice; 2 = Pass Through Logie
    C_RDCH_TYPE                             : integer := 0; -- 0 = FIFO; 1 = Register Slice; 2 = Pass Through Logie
    C_AXIS_TYPE                             : integer := 0; -- 0 = FIFO; 1 = Register Slice; 2 = Pass Through Logie

    -- AXI Implementation Type
    -- 1 = Common Clock Block RAM FIFO
    -- 2 = Common Clock Distributed RAM FIFO
    -- 11 = Independent Clock Block RAM FIFO
    -- 12 = Independent Clock Distributed RAM FIFO
    C_IMPLEMENTATION_TYPE_WACH              : integer := 1;
    C_IMPLEMENTATION_TYPE_WDCH              : integer := 1;
    C_IMPLEMENTATION_TYPE_WRCH              : integer := 1;
    C_IMPLEMENTATION_TYPE_RACH              : integer := 1;
    C_IMPLEMENTATION_TYPE_RDCH              : integer := 1;
    C_IMPLEMENTATION_TYPE_AXIS              : integer := 1;

    -- AXI FIFO Type
    -- 0 = Data FIFO
    -- 1 = Packet FIFO
    -- 2 = Low Latency Data FIFO
    C_APPLICATION_TYPE_WACH                 : integer := 0;
    C_APPLICATION_TYPE_WDCH                 : integer := 0;
    C_APPLICATION_TYPE_WRCH                 : integer := 0;
    C_APPLICATION_TYPE_RACH                 : integer := 0;
    C_APPLICATION_TYPE_RDCH                 : integer := 0;
    C_APPLICATION_TYPE_AXIS                 : integer := 0;

    -- Enable ECC
    -- 0 = ECC disabled
    -- 1 = ECC enabled
    C_USE_ECC_WACH                          : integer := 0;
    C_USE_ECC_WDCH                          : integer := 0;
    C_USE_ECC_WRCH                          : integer := 0;
    C_USE_ECC_RACH                          : integer := 0;
    C_USE_ECC_RDCH                          : integer := 0;
    C_USE_ECC_AXIS                          : integer := 0;

    -- ECC Error Injection Type
    -- 0 = No Error Injection
    -- 1 = Single Bit Error Injection
    -- 2 = Double Bit Error Injection
    -- 3 = Single Bit and Double Bit Error Injection
    C_ERROR_INJECTION_TYPE_WACH             : integer := 0;
    C_ERROR_INJECTION_TYPE_WDCH             : integer := 0;
    C_ERROR_INJECTION_TYPE_WRCH             : integer := 0;
    C_ERROR_INJECTION_TYPE_RACH             : integer := 0;
    C_ERROR_INJECTION_TYPE_RDCH             : integer := 0;
    C_ERROR_INJECTION_TYPE_AXIS             : integer := 0;

    -- Input Data Width
    -- Accumulation of all AXI input signal's width
    C_DIN_WIDTH_WACH                        : integer := 32;
    C_DIN_WIDTH_WDCH                        : integer := 64;
    C_DIN_WIDTH_WRCH                        : integer := 2 ;
    C_DIN_WIDTH_RACH                        : integer := 32;
    C_DIN_WIDTH_RDCH                        : integer := 64;
    C_DIN_WIDTH_AXIS                        : integer := 1 ;

    C_WR_DEPTH_WACH                         : integer := 16  ;
    C_WR_DEPTH_WDCH                         : integer := 1024;
    C_WR_DEPTH_WRCH                         : integer := 16  ;
    C_WR_DEPTH_RACH                         : integer := 16  ;
    C_WR_DEPTH_RDCH                         : integer := 1024;
    C_WR_DEPTH_AXIS                         : integer := 1024;

    C_WR_PNTR_WIDTH_WACH                    : integer := 4 ;
    C_WR_PNTR_WIDTH_WDCH                    : integer := 10;
    C_WR_PNTR_WIDTH_WRCH                    : integer := 4 ;
    C_WR_PNTR_WIDTH_RACH                    : integer := 4 ;
    C_WR_PNTR_WIDTH_RDCH                    : integer := 10;
    C_WR_PNTR_WIDTH_AXIS                    : integer := 10;

    C_HAS_DATA_COUNTS_WACH                  : integer := 0;
    C_HAS_DATA_COUNTS_WDCH                  : integer := 0;
    C_HAS_DATA_COUNTS_WRCH                  : integer := 0;
    C_HAS_DATA_COUNTS_RACH                  : integer := 0;
    C_HAS_DATA_COUNTS_RDCH                  : integer := 0;
    C_HAS_DATA_COUNTS_AXIS                  : integer := 0;

    C_HAS_PROG_FLAGS_WACH                   : integer := 0;
    C_HAS_PROG_FLAGS_WDCH                   : integer := 0;
    C_HAS_PROG_FLAGS_WRCH                   : integer := 0;
    C_HAS_PROG_FLAGS_RACH                   : integer := 0;
    C_HAS_PROG_FLAGS_RDCH                   : integer := 0;
    C_HAS_PROG_FLAGS_AXIS                   : integer := 0;

    C_PROG_FULL_TYPE_WACH                   : integer := 5   ;
    C_PROG_FULL_TYPE_WDCH                   : integer := 5   ;
    C_PROG_FULL_TYPE_WRCH                   : integer := 5   ;
    C_PROG_FULL_TYPE_RACH                   : integer := 5   ;
    C_PROG_FULL_TYPE_RDCH                   : integer := 5   ;
    C_PROG_FULL_TYPE_AXIS                   : integer := 5   ;
    C_PROG_FULL_THRESH_ASSERT_VAL_WACH      : integer := 1023;
    C_PROG_FULL_THRESH_ASSERT_VAL_WDCH      : integer := 1023;
    C_PROG_FULL_THRESH_ASSERT_VAL_WRCH      : integer := 1023;
    C_PROG_FULL_THRESH_ASSERT_VAL_RACH      : integer := 1023;
    C_PROG_FULL_THRESH_ASSERT_VAL_RDCH      : integer := 1023;
    C_PROG_FULL_THRESH_ASSERT_VAL_AXIS      : integer := 1023;

    C_PROG_EMPTY_TYPE_WACH                  : integer := 5   ;
    C_PROG_EMPTY_TYPE_WDCH                  : integer := 5   ;
    C_PROG_EMPTY_TYPE_WRCH                  : integer := 5   ;
    C_PROG_EMPTY_TYPE_RACH                  : integer := 5   ;
    C_PROG_EMPTY_TYPE_RDCH                  : integer := 5   ;
    C_PROG_EMPTY_TYPE_AXIS                  : integer := 5   ;
    C_PROG_EMPTY_THRESH_ASSERT_VAL_WACH     : integer := 1022;
    C_PROG_EMPTY_THRESH_ASSERT_VAL_WDCH     : integer := 1022;
    C_PROG_EMPTY_THRESH_ASSERT_VAL_WRCH     : integer := 1022;
    C_PROG_EMPTY_THRESH_ASSERT_VAL_RACH     : integer := 1022;
    C_PROG_EMPTY_THRESH_ASSERT_VAL_RDCH     : integer := 1022;
    C_PROG_EMPTY_THRESH_ASSERT_VAL_AXIS     : integer := 1022;

    C_REG_SLICE_MODE_WACH                   : integer := 0;
    C_REG_SLICE_MODE_WDCH                   : integer := 0;
    C_REG_SLICE_MODE_WRCH                   : integer := 0;
    C_REG_SLICE_MODE_RACH                   : integer := 0;
    C_REG_SLICE_MODE_RDCH                   : integer := 0;
    C_REG_SLICE_MODE_AXIS                   : integer := 0

    );
  PORT(
--------------------------------------------------------------------------------
-- Input and Output Declarations
--------------------------------------------------------------------------------
    BACKUP                         : IN  std_logic := '0';
    BACKUP_MARKER                  : IN  std_logic := '0';
    CLK                            : IN  std_logic := '0';
    RST                            : IN  std_logic := '0';
    SRST                           : IN  std_logic := '0';
    WR_CLK                         : IN  std_logic := '0';
    WR_RST                         : IN  std_logic := '0';
    RD_CLK                         : IN  std_logic := '0';
    RD_RST                         : IN  std_logic := '0';
    DIN                            : IN  std_logic_vector(C_DIN_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    WR_EN                          : IN  std_logic := '0';  --Mandatory input
    RD_EN                          : IN  std_logic := '0';  --Mandatory input
    PROG_EMPTY_THRESH              : IN  std_logic_vector(C_RD_PNTR_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    PROG_EMPTY_THRESH_ASSERT       : IN  std_logic_vector(C_RD_PNTR_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    PROG_EMPTY_THRESH_NEGATE       : IN  std_logic_vector(C_RD_PNTR_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    PROG_FULL_THRESH               : IN  std_logic_vector(C_WR_PNTR_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    PROG_FULL_THRESH_ASSERT        : IN  std_logic_vector(C_WR_PNTR_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    PROG_FULL_THRESH_NEGATE        : IN  std_logic_vector(C_WR_PNTR_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    INT_CLK                        : IN  std_logic := '0';
    INJECTDBITERR                  : IN  std_logic := '0';  
    INJECTSBITERR                  : IN  std_logic := '0';  

    DOUT                           : OUT std_logic_vector(C_DOUT_WIDTH-1 DOWNTO 0);
    FULL                           : OUT std_logic;
    ALMOST_FULL                    : OUT std_logic;
    WR_ACK                         : OUT std_logic;
    OVERFLOW                       : OUT std_logic;
    EMPTY                          : OUT std_logic;
    ALMOST_EMPTY                   : OUT std_logic;
    VALID                          : OUT std_logic;
    UNDERFLOW                      : OUT std_logic;
    DATA_COUNT                     : OUT std_logic_vector(C_DATA_COUNT_WIDTH-1 DOWNTO 0);
    RD_DATA_COUNT                  : OUT std_logic_vector(C_RD_DATA_COUNT_WIDTH-1 DOWNTO 0);
    WR_DATA_COUNT                  : OUT std_logic_vector(C_WR_DATA_COUNT_WIDTH-1 DOWNTO 0);
    PROG_FULL                      : OUT std_logic;
    PROG_EMPTY                     : OUT std_logic;
    SBITERR                        : OUT std_logic;
    DBITERR                        : OUT std_logic;
    
    -- AXI Global Signal
    M_ACLK                         : IN  std_logic := '0';
    S_ACLK                         : IN  std_logic := '0';
    S_ARESETN                      : IN  std_logic := '0';
    M_ACLK_EN                      : IN  std_logic := '0';
    S_ACLK_EN                      : IN  std_logic := '0';

    -- AXI Full/Lite Slave Write Channel (write side)
    S_AXI_AWID                     : IN  std_logic_vector(C_AXI_ID_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_AWADDR                   : IN  std_logic_vector(C_AXI_ADDR_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_AWLEN                    : IN  std_logic_vector(8-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_AWSIZE                   : IN  std_logic_vector(3-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_AWBURST                  : IN  std_logic_vector(2-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_AWLOCK                   : IN  std_logic_vector(2-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_AWCACHE                  : IN  std_logic_vector(4-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_AWPROT                   : IN  std_logic_vector(3-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_AWQOS                    : IN  std_logic_vector(4-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_AWREGION                 : IN  std_logic_vector(4-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_AWUSER                   : IN  std_logic_vector(C_AXI_AWUSER_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_AWVALID                  : IN  std_logic := '0';
    S_AXI_AWREADY                  : OUT std_logic;
    S_AXI_WID                      : IN  std_logic_vector(C_AXI_ID_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_WDATA                    : IN  std_logic_vector(C_AXI_DATA_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_WSTRB                    : IN  std_logic_vector(C_AXI_DATA_WIDTH/8-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_WLAST                    : IN  std_logic := '0';
    S_AXI_WUSER                    : IN  std_logic_vector(C_AXI_WUSER_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_WVALID                   : IN  std_logic := '0';
    S_AXI_WREADY                   : OUT std_logic;
    S_AXI_BID                      : OUT std_logic_vector(C_AXI_ID_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_BRESP                    : OUT std_logic_vector(2-1 DOWNTO 0);
    S_AXI_BUSER                    : OUT std_logic_vector(C_AXI_BUSER_WIDTH-1 DOWNTO 0);
    S_AXI_BVALID                   : OUT std_logic;
    S_AXI_BREADY                   : IN  std_logic := '0';

    -- AXI Full/Lite Master Write Channel (Read side)
    M_AXI_AWID                     : OUT std_logic_vector(C_AXI_ID_WIDTH-1 DOWNTO 0);
    M_AXI_AWADDR                   : OUT std_logic_vector(C_AXI_ADDR_WIDTH-1 DOWNTO 0);
    M_AXI_AWLEN                    : OUT std_logic_vector(8-1 DOWNTO 0);
    M_AXI_AWSIZE                   : OUT std_logic_vector(3-1 DOWNTO 0);
    M_AXI_AWBURST                  : OUT std_logic_vector(2-1 DOWNTO 0);
    M_AXI_AWLOCK                   : OUT std_logic_vector(2-1 DOWNTO 0);
    M_AXI_AWCACHE                  : OUT std_logic_vector(4-1 DOWNTO 0);
    M_AXI_AWPROT                   : OUT std_logic_vector(3-1 DOWNTO 0);
    M_AXI_AWQOS                    : OUT std_logic_vector(4-1 DOWNTO 0);
    M_AXI_AWREGION                 : OUT std_logic_vector(4-1 DOWNTO 0);
    M_AXI_AWUSER                   : OUT std_logic_vector(C_AXI_AWUSER_WIDTH-1 DOWNTO 0);
    M_AXI_AWVALID                  : OUT std_logic;
    M_AXI_AWREADY                  : IN  std_logic := '0';
    M_AXI_WID                      : OUT std_logic_vector(C_AXI_ID_WIDTH-1 DOWNTO 0);
    M_AXI_WDATA                    : OUT std_logic_vector(C_AXI_DATA_WIDTH-1 DOWNTO 0);
    M_AXI_WSTRB                    : OUT std_logic_vector(C_AXI_DATA_WIDTH/8-1 DOWNTO 0);
    M_AXI_WLAST                    : OUT std_logic;
    M_AXI_WUSER                    : OUT std_logic_vector(C_AXI_WUSER_WIDTH-1 DOWNTO 0);
    M_AXI_WVALID                   : OUT std_logic;
    M_AXI_WREADY                   : IN  std_logic := '0';
    M_AXI_BID                      : IN  std_logic_vector(C_AXI_ID_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    M_AXI_BRESP                    : IN  std_logic_vector(2-1 DOWNTO 0) := (OTHERS => '0');
    M_AXI_BUSER                    : IN  std_logic_vector(C_AXI_BUSER_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    M_AXI_BVALID                   : IN  std_logic := '0';
    M_AXI_BREADY                   : OUT std_logic;

    -- AXI Full/Lite Slave Read Channel (Write side)
    S_AXI_ARID                     : IN  std_logic_vector(C_AXI_ID_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_ARADDR                   : IN  std_logic_vector(C_AXI_ADDR_WIDTH-1 DOWNTO 0) := (OTHERS => '0'); 
    S_AXI_ARLEN                    : IN  std_logic_vector(8-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_ARSIZE                   : IN  std_logic_vector(3-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_ARBURST                  : IN  std_logic_vector(2-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_ARLOCK                   : IN  std_logic_vector(2-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_ARCACHE                  : IN  std_logic_vector(4-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_ARPROT                   : IN  std_logic_vector(3-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_ARQOS                    : IN  std_logic_vector(4-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_ARREGION                 : IN  std_logic_vector(4-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_ARUSER                   : IN  std_logic_vector(C_AXI_ARUSER_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    S_AXI_ARVALID                  : IN  std_logic := '0';
    S_AXI_ARREADY                  : OUT std_logic;
    S_AXI_RID                      : OUT std_logic_vector(C_AXI_ID_WIDTH-1 DOWNTO 0);       
    S_AXI_RDATA                    : OUT std_logic_vector(C_AXI_DATA_WIDTH-1 DOWNTO 0); 
    S_AXI_RRESP                    : OUT std_logic_vector(2-1 DOWNTO 0);
    S_AXI_RLAST                    : OUT std_logic;
    S_AXI_RUSER                    : OUT std_logic_vector(C_AXI_RUSER_WIDTH-1 DOWNTO 0);
    S_AXI_RVALID                   : OUT std_logic;
    S_AXI_RREADY                   : IN  std_logic := '0';

    -- AXI Full/Lite Master Read Channel (Read side)
    M_AXI_ARID                     : OUT std_logic_vector(C_AXI_ID_WIDTH-1 DOWNTO 0);        
    M_AXI_ARADDR                   : OUT std_logic_vector(C_AXI_ADDR_WIDTH-1 DOWNTO 0);  
    M_AXI_ARLEN                    : OUT std_logic_vector(8-1 DOWNTO 0);
    M_AXI_ARSIZE                   : OUT std_logic_vector(3-1 DOWNTO 0);
    M_AXI_ARBURST                  : OUT std_logic_vector(2-1 DOWNTO 0);
    M_AXI_ARLOCK                   : OUT std_logic_vector(2-1 DOWNTO 0);
    M_AXI_ARCACHE                  : OUT std_logic_vector(4-1 DOWNTO 0);
    M_AXI_ARPROT                   : OUT std_logic_vector(3-1 DOWNTO 0);
    M_AXI_ARQOS                    : OUT std_logic_vector(4-1 DOWNTO 0);
    M_AXI_ARREGION                 : OUT std_logic_vector(4-1 DOWNTO 0);
    M_AXI_ARUSER                   : OUT std_logic_vector(C_AXI_ARUSER_WIDTH-1 DOWNTO 0);
    M_AXI_ARVALID                  : OUT std_logic;
    M_AXI_ARREADY                  : IN  std_logic := '0';
    M_AXI_RID                      : IN  std_logic_vector(C_AXI_ID_WIDTH-1 DOWNTO 0) := (OTHERS => '0');        
    M_AXI_RDATA                    : IN  std_logic_vector(C_AXI_DATA_WIDTH-1 DOWNTO 0) := (OTHERS => '0');  
    M_AXI_RRESP                    : IN  std_logic_vector(2-1 DOWNTO 0) := (OTHERS => '0');
    M_AXI_RLAST                    : IN  std_logic := '0';
    M_AXI_RUSER                    : IN  std_logic_vector(C_AXI_RUSER_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    M_AXI_RVALID                   : IN  std_logic := '0';
    M_AXI_RREADY                   : OUT std_logic;

    -- AXI Streaming Slave Signals (Write side)
    S_AXIS_TVALID                  : IN  std_logic := '0';
    S_AXIS_TREADY                  : OUT std_logic;
    S_AXIS_TDATA                   : IN  std_logic_vector(C_AXIS_TDATA_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    S_AXIS_TSTRB                   : IN  std_logic_vector(C_AXIS_TSTRB_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    S_AXIS_TKEEP                   : IN  std_logic_vector(C_AXIS_TKEEP_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    S_AXIS_TLAST                   : IN  std_logic := '0';
    S_AXIS_TID                     : IN  std_logic_vector(C_AXIS_TID_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    S_AXIS_TDEST                   : IN  std_logic_vector(C_AXIS_TDEST_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
    S_AXIS_TUSER                   : IN  std_logic_vector(C_AXIS_TUSER_WIDTH-1 DOWNTO 0) := (OTHERS => '0');

    -- AXI Streaming Master Signals (Read side)
    M_AXIS_TVALID                  : OUT std_logic;
    M_AXIS_TREADY                  : IN  std_logic := '0';
    M_AXIS_TDATA                   : OUT std_logic_vector(C_AXIS_TDATA_WIDTH-1 DOWNTO 0);
    M_AXIS_TSTRB                   : OUT std_logic_vector(C_AXIS_TSTRB_WIDTH-1 DOWNTO 0);
    M_AXIS_TKEEP                   : OUT std_logic_vector(C_AXIS_TKEEP_WIDTH-1 DOWNTO 0);
    M_AXIS_TLAST                   : OUT std_logic;
    M_AXIS_TID                     : OUT std_logic_vector(C_AXIS_TID_WIDTH-1 DOWNTO 0);
    M_AXIS_TDEST                   : OUT std_logic_vector(C_AXIS_TDEST_WIDTH-1 DOWNTO 0);
    M_AXIS_TUSER                   : OUT std_logic_vector(C_AXIS_TUSER_WIDTH-1 DOWNTO 0);

    -- AXI Full/Lite Write Address Channel Signals
    AXI_AW_INJECTSBITERR           : IN  std_logic := '0';
    AXI_AW_INJECTDBITERR           : IN  std_logic := '0';
    AXI_AW_PROG_FULL_THRESH        : IN  std_logic_vector(C_WR_PNTR_WIDTH_WACH-1 DOWNTO 0) := (OTHERS => '0');
    AXI_AW_PROG_EMPTY_THRESH       : IN  std_logic_vector(C_WR_PNTR_WIDTH_WACH-1 DOWNTO 0) := (OTHERS => '0');
    AXI_AW_DATA_COUNT              : OUT std_logic_vector(C_WR_PNTR_WIDTH_WACH DOWNTO 0);
    AXI_AW_WR_DATA_COUNT           : OUT std_logic_vector(C_WR_PNTR_WIDTH_WACH DOWNTO 0);
    AXI_AW_RD_DATA_COUNT           : OUT std_logic_vector(C_WR_PNTR_WIDTH_WACH DOWNTO 0);
    AXI_AW_SBITERR                 : OUT std_logic;
    AXI_AW_DBITERR                 : OUT std_logic;
    AXI_AW_OVERFLOW                : OUT std_logic;
    AXI_AW_UNDERFLOW               : OUT std_logic;

    -- AXI Full/Lite Write Data Channel Signals
    AXI_W_INJECTSBITERR            : IN  std_logic := '0';
    AXI_W_INJECTDBITERR            : IN  std_logic := '0';
    AXI_W_PROG_FULL_THRESH         : IN  std_logic_vector(C_WR_PNTR_WIDTH_WDCH-1 DOWNTO 0) := (OTHERS => '0');
    AXI_W_PROG_EMPTY_THRESH        : IN  std_logic_vector(C_WR_PNTR_WIDTH_WDCH-1 DOWNTO 0) := (OTHERS => '0');
    AXI_W_DATA_COUNT               : OUT std_logic_vector(C_WR_PNTR_WIDTH_WDCH DOWNTO 0);
    AXI_W_WR_DATA_COUNT            : OUT std_logic_vector(C_WR_PNTR_WIDTH_WDCH DOWNTO 0);
    AXI_W_RD_DATA_COUNT            : OUT std_logic_vector(C_WR_PNTR_WIDTH_WDCH DOWNTO 0);
    AXI_W_SBITERR                  : OUT std_logic;
    AXI_W_DBITERR                  : OUT std_logic;
    AXI_W_OVERFLOW                 : OUT std_logic;
    AXI_W_UNDERFLOW                : OUT std_logic;

    -- AXI Full/Lite Write Response Channel Signals
    AXI_B_INJECTSBITERR            : IN  std_logic := '0';
    AXI_B_INJECTDBITERR            : IN  std_logic := '0';
    AXI_B_PROG_FULL_THRESH         : IN  std_logic_vector(C_WR_PNTR_WIDTH_WRCH-1 DOWNTO 0) := (OTHERS => '0');
    AXI_B_PROG_EMPTY_THRESH        : IN  std_logic_vector(C_WR_PNTR_WIDTH_WRCH-1 DOWNTO 0) := (OTHERS => '0');
    AXI_B_DATA_COUNT               : OUT std_logic_vector(C_WR_PNTR_WIDTH_WRCH DOWNTO 0);
    AXI_B_WR_DATA_COUNT            : OUT std_logic_vector(C_WR_PNTR_WIDTH_WRCH DOWNTO 0);
    AXI_B_RD_DATA_COUNT            : OUT std_logic_vector(C_WR_PNTR_WIDTH_WRCH DOWNTO 0);
    AXI_B_SBITERR                  : OUT std_logic;
    AXI_B_DBITERR                  : OUT std_logic;
    AXI_B_OVERFLOW                 : OUT std_logic;
    AXI_B_UNDERFLOW                : OUT std_logic;

    -- AXI Full/Lite Read Address Channel Signals
    AXI_AR_INJECTSBITERR           : IN  std_logic := '0';
    AXI_AR_INJECTDBITERR           : IN  std_logic := '0';
    AXI_AR_PROG_FULL_THRESH        : IN  std_logic_vector(C_WR_PNTR_WIDTH_RACH-1 DOWNTO 0) := (OTHERS => '0');
    AXI_AR_PROG_EMPTY_THRESH       : IN  std_logic_vector(C_WR_PNTR_WIDTH_RACH-1 DOWNTO 0) := (OTHERS => '0');
    AXI_AR_DATA_COUNT              : OUT std_logic_vector(C_WR_PNTR_WIDTH_RACH DOWNTO 0);
    AXI_AR_WR_DATA_COUNT           : OUT std_logic_vector(C_WR_PNTR_WIDTH_RACH DOWNTO 0);
    AXI_AR_RD_DATA_COUNT           : OUT std_logic_vector(C_WR_PNTR_WIDTH_RACH DOWNTO 0);
    AXI_AR_SBITERR                 : OUT std_logic;
    AXI_AR_DBITERR                 : OUT std_logic;
    AXI_AR_OVERFLOW                : OUT std_logic;
    AXI_AR_UNDERFLOW               : OUT std_logic;

    -- AXI Full/Lite Read Data Channel Signals
    AXI_R_INJECTSBITERR            : IN  std_logic := '0';
    AXI_R_INJECTDBITERR            : IN  std_logic := '0';
    AXI_R_PROG_FULL_THRESH         : IN  std_logic_vector(C_WR_PNTR_WIDTH_RDCH-1 DOWNTO 0) := (OTHERS => '0');
    AXI_R_PROG_EMPTY_THRESH        : IN  std_logic_vector(C_WR_PNTR_WIDTH_RDCH-1 DOWNTO 0) := (OTHERS => '0');
    AXI_R_DATA_COUNT               : OUT std_logic_vector(C_WR_PNTR_WIDTH_RDCH DOWNTO 0);
    AXI_R_WR_DATA_COUNT            : OUT std_logic_vector(C_WR_PNTR_WIDTH_RDCH DOWNTO 0);
    AXI_R_RD_DATA_COUNT            : OUT std_logic_vector(C_WR_PNTR_WIDTH_RDCH DOWNTO 0);
    AXI_R_SBITERR                  : OUT std_logic;
    AXI_R_DBITERR                  : OUT std_logic;
    AXI_R_OVERFLOW                 : OUT std_logic;
    AXI_R_UNDERFLOW                : OUT std_logic;

    -- AXI Streaming FIFO Related Signals
    AXIS_INJECTSBITERR             : IN  std_logic := '0';
    AXIS_INJECTDBITERR             : IN  std_logic := '0';
    AXIS_PROG_FULL_THRESH          : IN  std_logic_vector(C_WR_PNTR_WIDTH_AXIS-1 DOWNTO 0) := (OTHERS => '0');
    AXIS_PROG_EMPTY_THRESH         : IN  std_logic_vector(C_WR_PNTR_WIDTH_AXIS-1 DOWNTO 0) := (OTHERS => '0');
    AXIS_DATA_COUNT                : OUT std_logic_vector(C_WR_PNTR_WIDTH_AXIS DOWNTO 0);
    AXIS_WR_DATA_COUNT             : OUT std_logic_vector(C_WR_PNTR_WIDTH_AXIS DOWNTO 0);
    AXIS_RD_DATA_COUNT             : OUT std_logic_vector(C_WR_PNTR_WIDTH_AXIS DOWNTO 0);
    AXIS_SBITERR                   : OUT std_logic;
    AXIS_DBITERR                   : OUT std_logic;
    AXIS_OVERFLOW                  : OUT std_logic;
    AXIS_UNDERFLOW                 : OUT std_logic

    );
 END COMPONENT;


-- The following attributes tells XST that the fifo_generator_v8_3 is a black box
-- which should be generated using the command given by the value
-- of this attribute
attribute box_type of fifo_generator_v8_3: component is "black_box";
attribute GENERATOR_DEFAULT of fifo_generator_v8_3: component is 
     "generatecore com.xilinx.ip.fifo_generator_v8_3.fifo_generator_v8_3 -a map_qvirtex_to=virtex map_qrvirtex_to=virtex map_virtexe_to=virtex map_qvirtex2_to=virtex2 map_qrvirtex2_to=virtex2 map_spartan2_to=virtex map_spartan2e_to=virtex map_virtex5_to=virtex4 map_spartan3a_to=spartan3e spartan3an_to=spartan3e spartan3adsp_to=spartan3e ";

-- End FIFO Generator Component ---------------------------------------



   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
-------------------------------------------------------------------------------------
-- Start Block Memory Generator Component for V2_7
-- Component declaration for V2_7 pulled from the L.16\rtf\vhdl\src\XilinxCoreLib
-- file: blk_mem_gen_v2_7_comp.vhd
-------------------------------------------------------------------------------------
component blk_mem_gen_v2_7
  generic (
    C_ADDRA_WIDTH             : integer := 6;
    C_ADDRB_WIDTH             : integer := 6;
    C_ALGORITHM               : integer := 2;
    C_BYTE_SIZE               : integer := 8;
    C_COMMON_CLK              : integer := 1;
    C_DEFAULT_DATA            : string  := "";
    C_DISABLE_WARN_BHV_COLL   : integer := 0;
    C_DISABLE_WARN_BHV_RANGE  : integer := 0;
    C_FAMILY                  : string  := "virtex4";
    C_XDEVICEFAMILY           : string  := "virtex4";
    C_HAS_ENA                 : integer := 1;
    C_HAS_ENB                 : integer := 1;
    C_HAS_MEM_OUTPUT_REGS_A   : integer := 0;
    C_HAS_MEM_OUTPUT_REGS_B   : integer := 0;
    C_HAS_MUX_OUTPUT_REGS_A   : integer := 0;
    C_HAS_MUX_OUTPUT_REGS_B   : integer := 0;
    C_MUX_PIPELINE_STAGES     : integer := 0;
    C_HAS_REGCEA              : integer := 0;
    C_HAS_REGCEB              : integer := 0;
    C_HAS_SSRA                : integer := 0;
    C_HAS_SSRB                : integer := 0;
    C_INIT_FILE_NAME          : string  := "";
    C_LOAD_INIT_FILE          : integer := 0;
    C_MEM_TYPE                : integer := 2;
    C_PRIM_TYPE               : integer := 3;
    C_READ_DEPTH_A            : integer := 64;
    C_READ_DEPTH_B            : integer := 64;
    C_READ_WIDTH_A            : integer := 32;
    C_READ_WIDTH_B            : integer := 32;
    C_SIM_COLLISION_CHECK     : string  := "NONE";
    C_SINITA_VAL              : string  := "";
    C_SINITB_VAL              : string  := "";
    C_USE_BYTE_WEA            : integer := 0;
    C_USE_BYTE_WEB            : integer := 0;
    C_USE_DEFAULT_DATA        : integer := 0;
    C_USE_ECC                 : integer := 0;
    C_WEA_WIDTH               : integer := 1;
    C_WEB_WIDTH               : integer := 1;
    C_WRITE_DEPTH_A           : integer := 64;
    C_WRITE_DEPTH_B           : integer := 64;
    C_WRITE_MODE_A            : string  := "WRITE_FIRST";
    C_WRITE_MODE_B            : string  := "WRITE_FIRST";
    C_WRITE_WIDTH_A           : integer := 32;
    C_WRITE_WIDTH_B           : integer := 32;
--    C_CORENAME                : string  := "blk_mem_gen_v2_7";
      --Uncommenting the above parameter (C_CORENAME) will cause
      --the a failure in NGCBuild!!!
    C_USE_RAMB16BWER_RST_BHV  : INTEGER := 0);
  port (
    CLKA   : in  std_logic;
    DINA   : in  std_logic_vector(C_WRITE_WIDTH_A-1 downto 0):= (OTHERS => '0');
    ADDRA  : in  std_logic_vector(C_ADDRA_WIDTH-1 downto 0);
    ENA    : in  std_logic := '1';
    REGCEA : in  std_logic := '1';
    WEA    : in  std_logic_vector(C_WEA_WIDTH-1 downto 0):= (OTHERS => '0');
    SSRA   : in  std_logic := '0';
    DOUTA  : out std_logic_vector(C_READ_WIDTH_A-1 downto 0);
    CLKB   : in  std_logic := '0';
    DINB   : in  std_logic_vector(C_WRITE_WIDTH_B-1 downto 0):= (OTHERS => '0');
    ADDRB  : in  std_logic_vector(C_ADDRB_WIDTH-1 downto 0):= (OTHERS => '0');
    ENB    : in  std_logic := '1';
    REGCEB : in  std_logic := '1';
    WEB    : in  std_logic_vector(C_WEB_WIDTH-1 downto 0):= (OTHERS => '0');
    SSRB   : in  std_logic := '0';
    DOUTB  : out std_logic_vector(C_READ_WIDTH_B-1 downto 0);
    DBITERR : out std_logic;
    SBITERR : out std_logic
    );
end component; --blk_mem_gen_v2_7

-- The following tells XST that blk_mem_gen_v2_7 is a black box which  
  -- should be generated command given by the value of this attribute 
  -- Note the fully qualified SIM (JAVA class) name that forms the 
  -- basis of the core

  ATTRIBUTE box_type OF blk_mem_gen_v2_7 : COMPONENT IS "black_box";
  ATTRIBUTE generator_default OF blk_mem_gen_v2_7 : COMPONENT IS
    "generatecore com.xilinx.ip.blk_mem_gen_v2_7.blk_mem_gen_v2_7 -a map_qvirtex_to=virtex map_qrvirtex_to=virtex map_virtexe_to=virtex map_qvirtex2_to=virtex2 map_qrvirtex2_to=virtex2 map_spartan2_to=virtex map_spartan2e_to=virtex map_virtex5_to=virtex4 map_spartan3a_to=spartan3e spartan3an_to=spartan3e spartan3adsp_to=spartan3e ";
-- End Block Memory Generator Component for V2_7-------------------------------


-------------------------------------------------------------------------------------
-- Start Block Memory Generator Component for V3_1
-- Component declaration for V3_1 pulled from the L.16\rtf\vhdl\src\XilinxCoreLib
-- file: blk_mem_gen_v3_1_comp.vhd
-------------------------------------------------------------------------------------
component blk_mem_gen_v3_1
  generic (
    C_RSTRAM_B                : integer := 0;
    C_RSTRAM_A                : integer := 0;
    C_HAS_INJECTERR           : integer := 0;
    C_RST_TYPE                : string  := "SYNC";
    C_ADDRA_WIDTH             : integer := 6;
    C_ADDRB_WIDTH             : integer := 6;
    C_ALGORITHM               : integer := 2;
    C_BYTE_SIZE               : integer := 8;
    C_COMMON_CLK              : integer := 1;
    C_DEFAULT_DATA            : string  := "";
    C_DISABLE_WARN_BHV_COLL   : integer := 0;
    C_DISABLE_WARN_BHV_RANGE  : integer := 0;
    C_FAMILY                  : string  := "virtex4";
    C_XDEVICEFAMILY           : string  := "virtex4";
    C_HAS_ENA                 : integer := 1;
    C_HAS_ENB                 : integer := 1;
    C_HAS_MEM_OUTPUT_REGS_A   : integer := 0;
    C_HAS_MEM_OUTPUT_REGS_B   : integer := 0;
    C_HAS_MUX_OUTPUT_REGS_A   : integer := 0;
    C_HAS_MUX_OUTPUT_REGS_B   : integer := 0;
    C_MUX_PIPELINE_STAGES     : integer := 0;
    C_HAS_REGCEA              : integer := 0;
    C_HAS_REGCEB              : integer := 0;
    C_HAS_RSTA                : integer := 0;
    C_HAS_RSTB                : integer := 0;
    C_INIT_FILE_NAME          : string  := "";
    C_LOAD_INIT_FILE          : integer := 0;
    C_MEM_TYPE                : integer := 2;
    C_PRIM_TYPE               : integer := 3;
    C_READ_DEPTH_A            : integer := 64;
    C_READ_DEPTH_B            : integer := 64;
    C_READ_WIDTH_A            : integer := 32;
    C_READ_WIDTH_B            : integer := 32;
    C_SIM_COLLISION_CHECK     : string  := "NONE";
    C_INITA_VAL               : string  := "";
    C_INITB_VAL               : string  := "";
    C_USE_BYTE_WEA            : integer := 0;
    C_USE_BYTE_WEB            : integer := 0;
    C_USE_DEFAULT_DATA        : integer := 0;
    C_USE_ECC                 : integer := 0;
    C_WEA_WIDTH               : integer := 1;
    C_WEB_WIDTH               : integer := 1;
    C_WRITE_DEPTH_A           : integer := 64;
    C_WRITE_DEPTH_B           : integer := 64;
    C_WRITE_MODE_A            : string  := "WRITE_FIRST";
    C_WRITE_MODE_B            : string  := "WRITE_FIRST";
    C_WRITE_WIDTH_A           : integer := 32;
    C_WRITE_WIDTH_B           : integer := 32;
--    C_CORENAME                : string  := "blk_mem_gen_v3_1";
      --Uncommenting the above parameter (C_CORENAME) will cause
      --the a failure in NGCBuild!!!
    C_RST_PRIORITY_B          : string  := "CE";
    C_RST_PRIORITY_A          : string  := "CE"

    );
  port (
    CLKA   : in  std_logic;
    DINA   : in  std_logic_vector(C_WRITE_WIDTH_A-1 downto 0):= (OTHERS => '0');
    ADDRA  : in  std_logic_vector(C_ADDRA_WIDTH-1 downto 0);
    ENA    : in  std_logic := '1';
    REGCEA : in  std_logic := '1';
    WEA    : in  std_logic_vector(C_WEA_WIDTH-1 downto 0):= (OTHERS => '0');
    RSTA   : in  std_logic := '0';
    DOUTA  : out std_logic_vector(C_READ_WIDTH_A-1 downto 0);
    CLKB   : in  std_logic := '0';
    DINB   : in  std_logic_vector(C_WRITE_WIDTH_B-1 downto 0):= (OTHERS => '0');
    ADDRB  : in  std_logic_vector(C_ADDRB_WIDTH-1 downto 0):= (OTHERS => '0');
    ENB    : in  std_logic := '1';
    REGCEB : in  std_logic := '1';
    WEB    : in  std_logic_vector(C_WEB_WIDTH-1 downto 0):= (OTHERS => '0');
    RSTB   : in  std_logic := '0';
    DOUTB  : out std_logic_vector(C_READ_WIDTH_B-1 downto 0);
    DBITERR : out std_logic;
    SBITERR : out std_logic
    );
end component; --blk_mem_gen_v3_1

-- The following tells XST that blk_mem_gen_v3_1 is a black box which  
  -- should be generated command given by the value of this attribute 
  -- Note the fully qualified SIM (JAVA class) name that forms the 
  -- basis of the core

  ATTRIBUTE box_type OF blk_mem_gen_v3_1 : COMPONENT IS "black_box";
  ATTRIBUTE generator_default OF blk_mem_gen_v3_1 : COMPONENT IS
    "generatecore com.xilinx.ip.blk_mem_gen_v3_1.blk_mem_gen_v3_1 -a map_qvirtex_to=virtex map_qrvirtex_to=virtex map_virtexe_to=virtex map_qvirtex2_to=virtex2 map_qrvirtex2_to=virtex2 map_spartan2_to=virtex map_spartan2e_to=virtex map_virtex5_to=virtex4 map_spartan3a_to=spartan3e spartan3an_to=spartan3e spartan3adsp_to=spartan3e ";
-- End Block Memory Generator Component for V3_1-------------------------------



-------------------------------------------------------------------------------------
-- Start Block Memory Generator Component for V3_2
-- Component declaration for V3_2 pulled from the L.38\rtf\verilog\src\XilinxCoreLib
-- file: blk_mem_gen_v3_2.v
-- Verilog file used to match paramter order for NCSIM compatibility
-------------------------------------------------------------------------------------
component blk_mem_gen_v3_2
  generic (
  -- synthesis translate_off
    C_CORENAME                : string  := "blk_mem_gen_v3_2";
  -- synthesis translate_on
    C_FAMILY                  : string  := "virtex6";
    C_XDEVICEFAMILY           : string  := "virtex6";
    C_MEM_TYPE                : integer := 2;
    C_BYTE_SIZE               : integer := 8;
    C_ALGORITHM               : integer := 2;
    C_PRIM_TYPE               : integer := 3;
    C_LOAD_INIT_FILE          : integer := 0;
    C_INIT_FILE_NAME          : string  := "";
    C_USE_DEFAULT_DATA        : integer := 0;
    C_DEFAULT_DATA            : string  := "";
    C_RST_TYPE                : string  := "SYNC";
    C_HAS_RSTA                : integer := 0;
    C_RST_PRIORITY_A          : string  := "CE";
    C_RSTRAM_A                : integer := 0;
    C_INITA_VAL               : string  := "";
    C_HAS_ENA                 : integer := 1;
    C_HAS_REGCEA              : integer := 0;
    C_USE_BYTE_WEA            : integer := 0;
    C_WEA_WIDTH               : integer := 1;
    C_WRITE_MODE_A            : string  := "WRITE_FIRST";
    C_WRITE_WIDTH_A           : integer := 32;
    C_READ_WIDTH_A            : integer := 32;
    C_WRITE_DEPTH_A           : integer := 64;
    C_READ_DEPTH_A            : integer := 64;
    C_ADDRA_WIDTH             : integer := 6;
    C_HAS_RSTB                : integer := 0;
    C_RST_PRIORITY_B          : string  := "CE";
    C_RSTRAM_B                : integer := 0;
    C_INITB_VAL               : string  := "";
    C_HAS_ENB                 : integer := 1;
    C_HAS_REGCEB              : integer := 0;
    C_USE_BYTE_WEB            : integer := 0;
    C_WEB_WIDTH               : integer := 1;
    C_WRITE_MODE_B            : string  := "WRITE_FIRST";
    C_WRITE_WIDTH_B           : integer := 32;
    C_READ_WIDTH_B            : integer := 32;
    C_WRITE_DEPTH_B           : integer := 64;
    C_READ_DEPTH_B            : integer := 64;
    C_ADDRB_WIDTH             : integer := 6;
    C_HAS_MEM_OUTPUT_REGS_A   : integer := 0;
    C_HAS_MEM_OUTPUT_REGS_B   : integer := 0;
    C_HAS_MUX_OUTPUT_REGS_A   : integer := 0;
    C_HAS_MUX_OUTPUT_REGS_B   : integer := 0;
    C_MUX_PIPELINE_STAGES     : integer := 0;
    C_USE_ECC                 : integer := 0;
    C_HAS_INJECTERR           : integer := 0;
    C_SIM_COLLISION_CHECK     : string  := "NONE";
    C_COMMON_CLK              : integer := 1;
    C_DISABLE_WARN_BHV_COLL   : integer := 0;
    C_DISABLE_WARN_BHV_RANGE  : integer := 0
    );
  port (
    CLKA          : in  std_logic;
    RSTA          : in  std_logic := '0';
    ENA           : in  std_logic := '1';
    REGCEA        : in  std_logic := '1';
    WEA           : in  std_logic_vector(C_WEA_WIDTH-1 downto 0):= (OTHERS => '0');
    ADDRA         : in  std_logic_vector(C_ADDRA_WIDTH-1 downto 0);
    DINA          : in  std_logic_vector(C_WRITE_WIDTH_A-1 downto 0):= (OTHERS => '0');
    DOUTA         : out std_logic_vector(C_READ_WIDTH_A-1 downto 0);
    CLKB          : in  std_logic := '0';
    RSTB          : in  std_logic := '0';
    ENB           : in  std_logic := '1';
    REGCEB        : in  std_logic := '1';
    WEB           : in  std_logic_vector(C_WEB_WIDTH-1 downto 0):= (OTHERS => '0');
    ADDRB         : in  std_logic_vector(C_ADDRB_WIDTH-1 downto 0):= (OTHERS => '0');
    DINB          : in  std_logic_vector(C_WRITE_WIDTH_B-1 downto 0):= (OTHERS => '0');
    DOUTB         : out std_logic_vector(C_READ_WIDTH_B-1 downto 0);
    INJECTSBITERR : in  std_logic;
    INJECTDBITERR : in  std_logic;
    SBITERR       : out std_logic;
    DBITERR       : out std_logic;
    RDADDRECC     : out std_logic_vector(C_ADDRB_WIDTH-1 downto 0):= (OTHERS => '0')
    );
end component; --blk_mem_gen_v3_2

-- The following tells XST that blk_mem_gen_v3_2 is a black box which  
  -- should be generated command given by the value of this attribute 
  -- Note the fully qualified SIM (JAVA class) name that forms the 
  -- basis of the core

  ATTRIBUTE box_type OF blk_mem_gen_v3_2 : COMPONENT IS "black_box";
  ATTRIBUTE generator_default OF blk_mem_gen_v3_2 : COMPONENT IS
    "generatecore com.xilinx.ip.blk_mem_gen_v3_2.blk_mem_gen_v3_2 -a map_qvirtex_to=virtex map_qrvirtex_to=virtex map_virtexe_to=virtex map_qvirtex2_to=virtex2 map_qrvirtex2_to=virtex2 map_spartan2_to=virtex map_spartan2e_to=virtex map_virtex5_to=virtex4 map_spartan3a_to=spartan3e spartan3an_to=spartan3e spartan3adsp_to=spartan3e ";
-- End Block Memory Generator Component for V3_2 -------------------------------




-------------------------------------------------------------------------------------
-- Start Block Memory Generator Component for V3_3
-- Component declaration for V3_3 pulled from the L.69\rtf\verilog\src\XilinxCoreLib
-- file: blk_mem_gen_v3_3.v
-- Verilog file used to match paramter order for NCSIM compatibility
-------------------------------------------------------------------------------------
component blk_mem_gen_v3_3
  generic (
  -- synthesis translate_off
    C_CORENAME                : string  := "blk_mem_gen_v3_3";
  -- synthesis translate_on
    C_FAMILY                  : string  := "virtex6";
    C_XDEVICEFAMILY           : string  := "virtex6";
    C_MEM_TYPE                : integer := 2;
    C_BYTE_SIZE               : integer := 8;
    C_ALGORITHM               : integer := 2;
    C_PRIM_TYPE               : integer := 3;
    C_LOAD_INIT_FILE          : integer := 0;
    C_INIT_FILE_NAME          : string  := "";
    C_USE_DEFAULT_DATA        : integer := 0;
    C_DEFAULT_DATA            : string  := "";
    C_RST_TYPE                : string  := "SYNC";
    C_HAS_RSTA                : integer := 0;
    C_RST_PRIORITY_A          : string  := "CE";
    C_RSTRAM_A                : integer := 0;
    C_INITA_VAL               : string  := "";
    C_HAS_ENA                 : integer := 1;
    C_HAS_REGCEA              : integer := 0;
    C_USE_BYTE_WEA            : integer := 0;
    C_WEA_WIDTH               : integer := 1;
    C_WRITE_MODE_A            : string  := "WRITE_FIRST";
    C_WRITE_WIDTH_A           : integer := 32;
    C_READ_WIDTH_A            : integer := 32;
    C_WRITE_DEPTH_A           : integer := 64;
    C_READ_DEPTH_A            : integer := 64;
    C_ADDRA_WIDTH             : integer := 6;
    C_HAS_RSTB                : integer := 0;
    C_RST_PRIORITY_B          : string  := "CE";
    C_RSTRAM_B                : integer := 0;
    C_INITB_VAL               : string  := "";
    C_HAS_ENB                 : integer := 1;
    C_HAS_REGCEB              : integer := 0;
    C_USE_BYTE_WEB            : integer := 0;
    C_WEB_WIDTH               : integer := 1;
    C_WRITE_MODE_B            : string  := "WRITE_FIRST";
    C_WRITE_WIDTH_B           : integer := 32;
    C_READ_WIDTH_B            : integer := 32;
    C_WRITE_DEPTH_B           : integer := 64;
    C_READ_DEPTH_B            : integer := 64;
    C_ADDRB_WIDTH             : integer := 6;
    C_HAS_MEM_OUTPUT_REGS_A   : integer := 0;
    C_HAS_MEM_OUTPUT_REGS_B   : integer := 0;
    C_HAS_MUX_OUTPUT_REGS_A   : integer := 0;
    C_HAS_MUX_OUTPUT_REGS_B   : integer := 0;
    C_MUX_PIPELINE_STAGES     : integer := 0;
    C_USE_ECC                 : integer := 0;
    C_HAS_INJECTERR           : integer := 0;
    C_SIM_COLLISION_CHECK     : string  := "NONE";
    C_COMMON_CLK              : integer := 1;
    C_DISABLE_WARN_BHV_COLL   : integer := 0;
    C_DISABLE_WARN_BHV_RANGE  : integer := 0
    );
  port (
    CLKA          : in  std_logic;
    RSTA          : in  std_logic := '0';
    ENA           : in  std_logic := '1';
    REGCEA        : in  std_logic := '1';
    WEA           : in  std_logic_vector(C_WEA_WIDTH-1 downto 0):= (OTHERS => '0');
    ADDRA         : in  std_logic_vector(C_ADDRA_WIDTH-1 downto 0);
    DINA          : in  std_logic_vector(C_WRITE_WIDTH_A-1 downto 0):= (OTHERS => '0');
    DOUTA         : out std_logic_vector(C_READ_WIDTH_A-1 downto 0);
    CLKB          : in  std_logic := '0';
    RSTB          : in  std_logic := '0';
    ENB           : in  std_logic := '1';
    REGCEB        : in  std_logic := '1';
    WEB           : in  std_logic_vector(C_WEB_WIDTH-1 downto 0):= (OTHERS => '0');
    ADDRB         : in  std_logic_vector(C_ADDRB_WIDTH-1 downto 0):= (OTHERS => '0');
    DINB          : in  std_logic_vector(C_WRITE_WIDTH_B-1 downto 0):= (OTHERS => '0');
    DOUTB         : out std_logic_vector(C_READ_WIDTH_B-1 downto 0);
    INJECTSBITERR : in  std_logic;
    INJECTDBITERR : in  std_logic;
    SBITERR       : out std_logic;
    DBITERR       : out std_logic;
    RDADDRECC     : out std_logic_vector(C_ADDRB_WIDTH-1 downto 0):= (OTHERS => '0')
    );
end component; --blk_mem_gen_v3_3

-- The following tells XST that blk_mem_gen_v3_3 is a black box which  
  -- should be generated command given by the value of this attribute 
  -- Note the fully qualified SIM (JAVA class) name that forms the 
  -- basis of the core

  ATTRIBUTE box_type OF blk_mem_gen_v3_3 : COMPONENT IS "black_box";
  ATTRIBUTE generator_default OF blk_mem_gen_v3_3 : COMPONENT IS
    "generatecore com.xilinx.ip.blk_mem_gen_v3_3.blk_mem_gen_v3_3 -a map_qvirtex_to=virtex map_qrvirtex_to=virtex map_virtexe_to=virtex map_qvirtex2_to=virtex2 map_qrvirtex2_to=virtex2 map_spartan2_to=virtex map_spartan2e_to=virtex map_virtex5_to=virtex4 map_spartan3a_to=spartan3e spartan3an_to=spartan3e spartan3adsp_to=spartan3e ";
-- End Block Memory Generator Component for V3_3 -------------------------------








-------------------------------------------------------------------------------------
-- Start Block Memory Generator Component for V4_1
-- Component declaration for V3_3 pulled from the M.50\rtf\verilog\src\XilinxCoreLib
-- file: blk_mem_gen_v4_1.v
-- Verilog file used to match paramter order for NCSIM compatibility
-------------------------------------------------------------------------------------
component blk_mem_gen_v4_1
  generic (
  -- synthesis translate_off
    C_CORENAME                : string  := "blk_mem_gen_v4_1";
  -- synthesis translate_on
    C_FAMILY                  : string  := "virtex6";
    C_XDEVICEFAMILY           : string  := "virtex6";
    C_MEM_TYPE                : integer := 2;
    C_BYTE_SIZE               : integer := 8;
    C_ALGORITHM               : integer := 2;
    C_PRIM_TYPE               : integer := 3;
    C_LOAD_INIT_FILE          : integer := 0;
    C_INIT_FILE_NAME          : string  := "";
    C_USE_DEFAULT_DATA        : integer := 0;
    C_DEFAULT_DATA            : string  := "";
    C_RST_TYPE                : string  := "SYNC";
    C_HAS_RSTA                : integer := 0;
    C_RST_PRIORITY_A          : string  := "CE";
    C_RSTRAM_A                : integer := 0;
    C_INITA_VAL               : string  := "";
    C_HAS_ENA                 : integer := 1;
    C_HAS_REGCEA              : integer := 0;
    C_USE_BYTE_WEA            : integer := 0;
    C_WEA_WIDTH               : integer := 1;
    C_WRITE_MODE_A            : string  := "WRITE_FIRST";
    C_WRITE_WIDTH_A           : integer := 32;
    C_READ_WIDTH_A            : integer := 32;
    C_WRITE_DEPTH_A           : integer := 64;
    C_READ_DEPTH_A            : integer := 64;
    C_ADDRA_WIDTH             : integer := 6;
    C_HAS_RSTB                : integer := 0;
    C_RST_PRIORITY_B          : string  := "CE";
    C_RSTRAM_B                : integer := 0;
    C_INITB_VAL               : string  := "";
    C_HAS_ENB                 : integer := 1;
    C_HAS_REGCEB              : integer := 0;
    C_USE_BYTE_WEB            : integer := 0;
    C_WEB_WIDTH               : integer := 1;
    C_WRITE_MODE_B            : string  := "WRITE_FIRST";
    C_WRITE_WIDTH_B           : integer := 32;
    C_READ_WIDTH_B            : integer := 32;
    C_WRITE_DEPTH_B           : integer := 64;
    C_READ_DEPTH_B            : integer := 64;
    C_ADDRB_WIDTH             : integer := 6;
    C_HAS_MEM_OUTPUT_REGS_A   : integer := 0;
    C_HAS_MEM_OUTPUT_REGS_B   : integer := 0;
    C_HAS_MUX_OUTPUT_REGS_A   : integer := 0;
    C_HAS_MUX_OUTPUT_REGS_B   : integer := 0;
    C_HAS_SOFTECC_INPUT_REGS_A  : INTEGER := 0;   -- new BMG_v4_1
    C_HAS_SOFTECC_INPUT_REGS_B  : INTEGER := 0;   -- new BMG_v4_1
    C_HAS_SOFTECC_OUTPUT_REGS_A : INTEGER := 0;   -- new BMG_v4_1
    C_HAS_SOFTECC_OUTPUT_REGS_B : INTEGER := 0;   -- new BMG_v4_1
    C_MUX_PIPELINE_STAGES     : integer := 0;
    C_USE_SOFTECC             : INTEGER := 0;     -- new BMG_v4_1
    C_USE_ECC                 : integer := 0;
    C_HAS_INJECTERR           : integer := 0;
    C_SIM_COLLISION_CHECK     : string  := "NONE";
    C_COMMON_CLK              : integer := 1;
    --FLOP_DELAY                : integer := 100;  -- new BMG_v4_1
    C_DISABLE_WARN_BHV_COLL   : integer := 0;
    C_DISABLE_WARN_BHV_RANGE  : integer := 0
    );
  port (
    CLKA          : in  std_logic;
    RSTA          : in  std_logic := '0';
    ENA           : in  std_logic := '1';
    REGCEA        : in  std_logic := '1';
    WEA           : in  std_logic_vector(C_WEA_WIDTH-1 downto 0):= (OTHERS => '0');
    ADDRA         : in  std_logic_vector(C_ADDRA_WIDTH-1 downto 0);
    DINA          : in  std_logic_vector(C_WRITE_WIDTH_A-1 downto 0):= (OTHERS => '0');
    DOUTA         : out std_logic_vector(C_READ_WIDTH_A-1 downto 0);
    CLKB          : in  std_logic := '0';
    RSTB          : in  std_logic := '0';
    ENB           : in  std_logic := '1';
    REGCEB        : in  std_logic := '1';
    WEB           : in  std_logic_vector(C_WEB_WIDTH-1 downto 0):= (OTHERS => '0');
    ADDRB         : in  std_logic_vector(C_ADDRB_WIDTH-1 downto 0):= (OTHERS => '0');
    DINB          : in  std_logic_vector(C_WRITE_WIDTH_B-1 downto 0):= (OTHERS => '0');
    DOUTB         : out std_logic_vector(C_READ_WIDTH_B-1 downto 0);
    INJECTSBITERR : in  std_logic;
    INJECTDBITERR : in  std_logic;
    SBITERR       : out std_logic;
    DBITERR       : out std_logic;
    RDADDRECC     : out std_logic_vector(C_ADDRB_WIDTH-1 downto 0):= (OTHERS => '0')
    );
end component; --blk_mem_gen_v4_1

-- The following tells XST that blk_mem_gen_v4_1 is a black box which  
  -- should be generated command given by the value of this attribute 
  -- Note the fully qualified SIM (JAVA class) name that forms the 
  -- basis of the core

  ATTRIBUTE box_type OF blk_mem_gen_v4_1 : COMPONENT IS "black_box";
  ATTRIBUTE generator_default OF blk_mem_gen_v4_1 : COMPONENT IS
    "generatecore com.xilinx.ip.blk_mem_gen_v4_1.blk_mem_gen_v4_1 -a map_qvirtex_to=virtex map_qrvirtex_to=virtex map_virtexe_to=virtex map_qvirtex2_to=virtex2 map_qrvirtex2_to=virtex2 map_spartan2_to=virtex map_spartan2e_to=virtex map_virtex5_to=virtex4 map_spartan3a_to=spartan3e spartan3an_to=spartan3e spartan3adsp_to=spartan3e ";
-- End Block Memory Generator Component for V4_1 -------------------------------





-------------------------------------------------------------------------------------
-- Start Block Memory Generator Component for V5_2
-- Component declaration for V3_3 pulled from the O.26\rtf\verilog\src\XilinxCoreLib
-- file: blk_mem_gen_v5_2.v
-- Verilog file used to match paramter order for NCSIM compatibility
-------------------------------------------------------------------------------------
component blk_mem_gen_v5_2
  generic (
  -- synthesis translate_off
    C_CORENAME                  : string  := "blk_mem_gen_v5_2";
  -- synthesis translate_on
    C_FAMILY                    : string  := "virtex6";
    C_XDEVICEFAMILY             : string  := "virtex6";
    C_MEM_TYPE                  : integer := 2;
    C_BYTE_SIZE                 : integer := 8;
    C_ALGORITHM                 : integer := 2;
    C_PRIM_TYPE                 : integer := 3;
    C_LOAD_INIT_FILE            : integer := 0;
    C_INIT_FILE_NAME            : string  := "";
    C_USE_DEFAULT_DATA          : integer := 0;
    C_DEFAULT_DATA              : string  := "";
    C_RST_TYPE                  : string  := "SYNC";
    C_HAS_RSTA                  : integer := 0;
    C_RST_PRIORITY_A            : string  := "CE";
    C_RSTRAM_A                  : integer := 0;
    C_INITA_VAL                 : string  := "";
    C_HAS_ENA                   : integer := 1;
    C_HAS_REGCEA                : integer := 0;
    C_USE_BYTE_WEA              : integer := 0;
    C_WEA_WIDTH                 : integer := 1;
    C_WRITE_MODE_A              : string  := "WRITE_FIRST";
    C_WRITE_WIDTH_A             : integer := 32;
    C_READ_WIDTH_A              : integer := 32;
    C_WRITE_DEPTH_A             : integer := 64;
    C_READ_DEPTH_A              : integer := 64;
    C_ADDRA_WIDTH               : integer := 6;
    C_HAS_RSTB                  : integer := 0;
    C_RST_PRIORITY_B            : string  := "CE";
    C_RSTRAM_B                  : integer := 0;
    C_INITB_VAL                 : string  := "";
    C_HAS_ENB                   : integer := 1;
    C_HAS_REGCEB                : integer := 0;
    C_USE_BYTE_WEB              : integer := 0;
    C_WEB_WIDTH                 : integer := 1;
    C_WRITE_MODE_B              : string  := "WRITE_FIRST";
    C_WRITE_WIDTH_B             : integer := 32;
    C_READ_WIDTH_B              : integer := 32;
    C_WRITE_DEPTH_B             : integer := 64;
    C_READ_DEPTH_B              : integer := 64;
    C_ADDRB_WIDTH               : integer := 6;
    C_HAS_MEM_OUTPUT_REGS_A     : integer := 0;
    C_HAS_MEM_OUTPUT_REGS_B     : integer := 0;
    C_HAS_MUX_OUTPUT_REGS_A     : integer := 0;
    C_HAS_MUX_OUTPUT_REGS_B     : integer := 0;
    C_HAS_SOFTECC_INPUT_REGS_A  : INTEGER := 0;     
    --C_HAS_SOFTECC_INPUT_REGS_B  : INTEGER := 0;   -- Rmoved BMG_v4_3
    --C_HAS_SOFTECC_OUTPUT_REGS_A : INTEGER := 0;   -- Rmoved BMG_v4_3
    C_HAS_SOFTECC_OUTPUT_REGS_B : INTEGER := 0;     
    C_MUX_PIPELINE_STAGES       : integer := 0;
    C_USE_SOFTECC               : INTEGER := 0;     
    C_USE_ECC                   : integer := 0;
    C_HAS_INJECTERR             : integer := 0;
    C_SIM_COLLISION_CHECK       : string  := "NONE";
    C_COMMON_CLK                : integer := 1;
    C_DISABLE_WARN_BHV_COLL     : integer := 0;
    C_DISABLE_WARN_BHV_RANGE    : integer := 0
    );
  port (
    CLKA          : in  std_logic;
    RSTA          : in  std_logic := '0';
    ENA           : in  std_logic := '1';
    REGCEA        : in  std_logic := '1';
    WEA           : in  std_logic_vector(C_WEA_WIDTH-1 downto 0):= (OTHERS => '0');
    ADDRA         : in  std_logic_vector(C_ADDRA_WIDTH-1 downto 0);
    DINA          : in  std_logic_vector(C_WRITE_WIDTH_A-1 downto 0):= (OTHERS => '0');
    DOUTA         : out std_logic_vector(C_READ_WIDTH_A-1 downto 0);
    CLKB          : in  std_logic := '0';
    RSTB          : in  std_logic := '0';
    ENB           : in  std_logic := '1';
    REGCEB        : in  std_logic := '1';
    WEB           : in  std_logic_vector(C_WEB_WIDTH-1 downto 0):= (OTHERS => '0');
    ADDRB         : in  std_logic_vector(C_ADDRB_WIDTH-1 downto 0):= (OTHERS => '0');
    DINB          : in  std_logic_vector(C_WRITE_WIDTH_B-1 downto 0):= (OTHERS => '0');
    DOUTB         : out std_logic_vector(C_READ_WIDTH_B-1 downto 0);
    INJECTSBITERR : in  std_logic;
    INJECTDBITERR : in  std_logic;
    SBITERR       : out std_logic;
    DBITERR       : out std_logic;
    RDADDRECC     : out std_logic_vector(C_ADDRB_WIDTH-1 downto 0):= (OTHERS => '0')
    );
end component; --blk_mem_gen_v5_2

-- The following tells XST that blk_mem_gen_v5_2 is a black box which  
  -- should be generated command given by the value of this attribute 
  -- Note the fully qualified SIM (JAVA class) name that forms the 
  -- basis of the core

  ATTRIBUTE box_type OF blk_mem_gen_v5_2 : COMPONENT IS "black_box";
  ATTRIBUTE generator_default OF blk_mem_gen_v5_2 : COMPONENT IS
    "generatecore com.xilinx.ip.blk_mem_gen_v5_2.blk_mem_gen_v5_2 -a map_qvirtex_to=virtex map_qrvirtex_to=virtex map_virtexe_to=virtex map_qvirtex2_to=virtex2 map_qrvirtex2_to=virtex2 map_spartan2_to=virtex map_spartan2e_to=virtex map_virtex5_to=virtex4 map_spartan3a_to=spartan3e spartan3an_to=spartan3e spartan3adsp_to=spartan3e ";
-- End Block Memory Generator Component for v5_2 -------------------------------


 
 
 
 
 
 
-------------------------------------------------------------------------------------
-- Start Block Memory Generator Component for blk_mem_gen_v6_2
-- Component declaration for blk_mem_gen_v6_2 pulled from the 
-- O.48\rtf\verilog\src\XilinxCoreLib
-- file: blk_mem_gen_v6_2.v
-- Verilog file used to match paramter order for NCSIM compatibility
-------------------------------------------------------------------------------------
component blk_mem_gen_v6_2
  generic (
  -- synthesis translate_off
    C_CORENAME                  : string  := "blk_mem_gen_v6_2";
  -- synthesis translate_on
    C_FAMILY                    : string  := "virtex6";
    C_XDEVICEFAMILY             : string  := "virtex6";
  --     
    C_INTERFACE_TYPE            : INTEGER := 0;   -- new for v6.2
    C_AXI_TYPE                  : INTEGER := 0;   -- new for v6.2
    C_AXI_SLAVE_TYPE            : INTEGER := 0;   -- new for v6.2
    C_HAS_AXI_ID                : INTEGER := 0;   -- new for v6.2
    C_AXI_ID_WIDTH              : INTEGER := 4;   -- new for v6.2
  -- 
    C_MEM_TYPE                  : integer := 2;
    C_BYTE_SIZE                 : integer := 8;
    C_ALGORITHM                 : integer := 2;
    C_PRIM_TYPE                 : integer := 3;
    C_LOAD_INIT_FILE            : integer := 0;
    C_INIT_FILE_NAME            : string  := "";
    C_USE_DEFAULT_DATA          : integer := 0;
    C_DEFAULT_DATA              : string  := "";
    C_RST_TYPE                  : string  := "SYNC";
    C_HAS_RSTA                  : integer := 0;
    C_RST_PRIORITY_A            : string  := "CE";
    C_RSTRAM_A                  : integer := 0;
    C_INITA_VAL                 : string  := "";
    C_HAS_ENA                   : integer := 1;
    C_HAS_REGCEA                : integer := 0;
    C_USE_BYTE_WEA              : integer := 0;
    C_WEA_WIDTH                 : integer := 1;
    C_WRITE_MODE_A              : string  := "WRITE_FIRST";
    C_WRITE_WIDTH_A             : integer := 32;
    C_READ_WIDTH_A              : integer := 32;
    C_WRITE_DEPTH_A             : integer := 64;
    C_READ_DEPTH_A              : integer := 64;
    C_ADDRA_WIDTH               : integer := 6;
    C_HAS_RSTB                  : integer := 0;
    C_RST_PRIORITY_B            : string  := "CE";
    C_RSTRAM_B                  : integer := 0;
    C_INITB_VAL                 : string  := "";
    C_HAS_ENB                   : integer := 1;
    C_HAS_REGCEB                : integer := 0;
    C_USE_BYTE_WEB              : integer := 0;
    C_WEB_WIDTH                 : integer := 1;
    C_WRITE_MODE_B              : string  := "WRITE_FIRST";
    C_WRITE_WIDTH_B             : integer := 32;
    C_READ_WIDTH_B              : integer := 32;
    C_WRITE_DEPTH_B             : integer := 64;
    C_READ_DEPTH_B              : integer := 64;
    C_ADDRB_WIDTH               : integer := 6;
    C_HAS_MEM_OUTPUT_REGS_A     : integer := 0;
    C_HAS_MEM_OUTPUT_REGS_B     : integer := 0;
    C_HAS_MUX_OUTPUT_REGS_A     : integer := 0;
    C_HAS_MUX_OUTPUT_REGS_B     : integer := 0;
    C_HAS_SOFTECC_INPUT_REGS_A  : INTEGER := 0;     
    C_HAS_SOFTECC_OUTPUT_REGS_B : INTEGER := 0;     
    C_MUX_PIPELINE_STAGES       : integer := 0;
    C_USE_SOFTECC               : INTEGER := 0;     
    C_USE_ECC                   : integer := 0;
    C_HAS_INJECTERR             : integer := 0;
    C_SIM_COLLISION_CHECK       : string  := "NONE";
    C_COMMON_CLK                : integer := 1;
    C_DISABLE_WARN_BHV_COLL     : integer := 0;
    C_DISABLE_WARN_BHV_RANGE    : integer := 0
    );
  port (
    CLKA                           : in  std_logic;
    RSTA                           : in  std_logic := '0';
    ENA                            : in  std_logic := '1';
    REGCEA                         : in  std_logic := '1';
    WEA                            : in  std_logic_vector(C_WEA_WIDTH-1 downto 0):= (OTHERS => '0');
    ADDRA                          : in  std_logic_vector(C_ADDRA_WIDTH-1 downto 0);
    DINA                           : in  std_logic_vector(C_WRITE_WIDTH_A-1 downto 0):= (OTHERS => '0');
    DOUTA                          : out std_logic_vector(C_READ_WIDTH_A-1 downto 0);
    CLKB                           : in  std_logic := '0';
    RSTB                           : in  std_logic := '0';
    ENB                            : in  std_logic := '1';
    REGCEB                         : in  std_logic := '1';
    WEB                            : in  std_logic_vector(C_WEB_WIDTH-1 downto 0):= (OTHERS => '0');
    ADDRB                          : in  std_logic_vector(C_ADDRB_WIDTH-1 downto 0):= (OTHERS => '0');
    DINB                           : in  std_logic_vector(C_WRITE_WIDTH_B-1 downto 0):= (OTHERS => '0');
    DOUTB                          : out std_logic_vector(C_READ_WIDTH_B-1 downto 0);
    INJECTSBITERR                  : in  std_logic;
    INJECTDBITERR                  : in  std_logic;
    SBITERR                        : out std_logic;
    DBITERR                        : out std_logic;
    RDADDRECC                      : out std_logic_vector(C_ADDRB_WIDTH-1 downto 0):= (OTHERS => '0') ;
      
    -- AXI BMG Input and Output Port Declarations                                                             -- new for v6.2
                                                                                                              -- new for v6.2
    -- AXI Global Signals                                                                                     -- new for v6.2
    S_AClk                         : IN  STD_LOGIC := '0';                                                    -- new for v6.2
    S_ARESETN                      : IN  STD_LOGIC := '0';                                                    -- new for v6.2
                                                                                                              -- new for v6.2
    -- AXI Full/Lite Slave Write (write side)                                                                 -- new for v6.2
    S_AXI_AWID                     : IN  STD_LOGIC_VECTOR(C_AXI_ID_WIDTH-1 DOWNTO 0) := (OTHERS => '0');      -- new for v6.2
    S_AXI_AWADDR                   : IN  STD_LOGIC_VECTOR(31 DOWNTO 0) := (OTHERS => '0');                    -- new for v6.2
    S_AXI_AWLEN                    : IN  STD_LOGIC_VECTOR(7 DOWNTO 0) := (OTHERS => '0');                     -- new for v6.2
    S_AXI_AWSIZE                   : IN  STD_LOGIC_VECTOR(2 DOWNTO 0) := (OTHERS => '0');                     -- new for v6.2
    S_AXI_AWBURST                  : IN  STD_LOGIC_VECTOR(1 DOWNTO 0) := (OTHERS => '0');                     -- new for v6.2
    S_AXI_AWVALID                  : IN  STD_LOGIC := '0';                                                    -- new for v6.2
    S_AXI_AWREADY                  : OUT STD_LOGIC;                                                           -- new for v6.2
    S_AXI_WDATA                    : IN  STD_LOGIC_VECTOR(C_WRITE_WIDTH_A-1 DOWNTO 0) := (OTHERS => '0');     -- new for v6.2
    S_AXI_WSTRB                    : IN  STD_LOGIC_VECTOR(C_WEA_WIDTH-1 DOWNTO 0) := (OTHERS => '0');         -- new for v6.2
    S_AXI_WLAST                    : IN  STD_LOGIC := '0';                                                    -- new for v6.2
    S_AXI_WVALID                   : IN  STD_LOGIC := '0';                                                    -- new for v6.2
    S_AXI_WREADY                   : OUT STD_LOGIC;                                                           -- new for v6.2
    S_AXI_BID                      : OUT STD_LOGIC_VECTOR(C_AXI_ID_WIDTH-1 DOWNTO 0) := (OTHERS => '0');      -- new for v6.2
    S_AXI_BRESP                    : OUT STD_LOGIC_VECTOR(1 DOWNTO 0);                                        -- new for v6.2
    S_AXI_BVALID                   : OUT STD_LOGIC;                                                           -- new for v6.2
    S_AXI_BREADY                   : IN  STD_LOGIC := '0';                                                    -- new for v6.2
                                                                                                              -- new for v6.2
    -- AXI Full/Lite Slave Read (Write side)                                                                  -- new for v6.2
    S_AXI_ARID                     : IN  STD_LOGIC_VECTOR(C_AXI_ID_WIDTH-1 DOWNTO 0) := (OTHERS => '0');      -- new for v6.2
    S_AXI_ARADDR                   : IN  STD_LOGIC_VECTOR(31 DOWNTO 0) := (OTHERS => '0');                    -- new for v6.2
    S_AXI_ARLEN                    : IN  STD_LOGIC_VECTOR(8-1 DOWNTO 0) := (OTHERS => '0');                   -- new for v6.2
    S_AXI_ARSIZE                   : IN  STD_LOGIC_VECTOR(2 DOWNTO 0) := (OTHERS => '0');                     -- new for v6.2
    S_AXI_ARBURST                  : IN  STD_LOGIC_VECTOR(1 DOWNTO 0) := (OTHERS => '0');                     -- new for v6.2
    S_AXI_ARVALID                  : IN  STD_LOGIC := '0';                                                    -- new for v6.2
    S_AXI_ARREADY                  : OUT STD_LOGIC;                                                           -- new for v6.2
    S_AXI_RID                      : OUT STD_LOGIC_VECTOR(C_AXI_ID_WIDTH-1 DOWNTO 0) := (OTHERS => '0');      -- new for v6.2
    S_AXI_RDATA                    : OUT STD_LOGIC_VECTOR(C_WRITE_WIDTH_B-1 DOWNTO 0);                        -- new for v6.2
    S_AXI_RRESP                    : OUT STD_LOGIC_VECTOR(2-1 DOWNTO 0);                                      -- new for v6.2
    S_AXI_RLAST                    : OUT STD_LOGIC;                                                           -- new for v6.2
    S_AXI_RVALID                   : OUT STD_LOGIC;                                                           -- new for v6.2
    S_AXI_RREADY                   : IN  STD_LOGIC := '0';                                                    -- new for v6.2
                                                                                                              -- new for v6.2
    -- AXI Full/Lite Sideband Signals                                                                         -- new for v6.2
    S_AXI_INJECTSBITERR            : IN  STD_LOGIC := '0';                                                    -- new for v6.2
    S_AXI_INJECTDBITERR            : IN  STD_LOGIC := '0';                                                    -- new for v6.2
    S_AXI_SBITERR                  : OUT STD_LOGIC;                                                           -- new for v6.2
    S_AXI_DBITERR                  : OUT STD_LOGIC;                                                           -- new for v6.2
    S_AXI_RDADDRECC                : OUT STD_LOGIC_VECTOR(C_ADDRB_WIDTH-1 DOWNTO 0)                           -- new for v6.2


    );
end component; --blk_mem_gen_v6_2

-- The following tells XST that blk_mem_gen_v6_2 is a black box which  
  -- should be generated command given by the value of this attribute 
  -- Note the fully qualified SIM (JAVA class) name that forms the 
  -- basis of the core

  ATTRIBUTE box_type OF blk_mem_gen_v6_2 : COMPONENT IS "black_box";
  ATTRIBUTE generator_default OF blk_mem_gen_v6_2 : COMPONENT IS
    "generatecore com.xilinx.ip.blk_mem_gen_v6_2.blk_mem_gen_v6_2 -a map_qvirtex_to=virtex map_qrvirtex_to=virtex map_virtexe_to=virtex map_qvirtex2_to=virtex2 map_qrvirtex2_to=virtex2 map_spartan2_to=virtex map_spartan2e_to=virtex map_virtex5_to=virtex4 map_spartan3a_to=spartan3e spartan3an_to=spartan3e spartan3adsp_to=spartan3e ";
-- End Block Memory Generator Component for v5_2 -------------------------------






END coregen_comp_defs;
