--****************************************************************************************************************--
--! @file
--! @brief File Description
--! @authors John William Croft 
--! 
--****************************************************************************************************************--

----------------------------------------------------- Libraries ----------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
use ieee.math_real.all;
----------------------------------------------------- Entity -------------------------------------------------------


package pkg_alu is

   component ALU_SKL is
generic (width : natural := 32);
port(
	clk 	: in std_logic;
	Reset_n : in std_logic;
	A 		: in std_logic_vector(31 downto 0);
	B 		: in std_logic_vector(31 downto 0);
	Op 		: in std_logic_vector(3 downto 0);
	Outs 	: out std_logic_vector(31 downto 0));
end component ALU_SKL;
	
   component mux21 IS 
   generic(width : natural := 32);
      PORT (
         mux21_in_0, mux21_in_1 : in STD_LOGIC_VECTOR (width-1 downto 0);
         mux21_sel : in STD_LOGIC;
         mux21_out : OUT STD_LOGIC_VECTOR (width-1 downto 0)
      );
   end component mux21;
   
   component mux41 is 
      generic(width : natural := 32);
      port (
         mux41_in_0  : in std_logic_vector (width-1 downto 0);
         mux41_in_1  : in std_logic_vector (width-1 downto 0);
         mux41_in_2  : in std_logic_vector (width-1 downto 0);
         mux41_in_3  : in std_logic_vector (width-1 downto 0);
         mux41_sel   : in std_logic_vector(1 downto 0);
         mux41_out   : out std_logic_vector (width-1 downto 0)
      );
   end component mux41;

	
	component vDFF is
      generic(WIDTH : natural := 32);
      port (
         clk   : in std_logic; 
         D     : in std_logic_vector(WIDTH-1 downto 0);
         Q     : out std_logic_vector(WIDTH-1 downto 0)
      );
   end component vDFF;
   
   component shift_module is
      generic( width : natural := 32);     
      port (
         clk:in std_logic;
         reset_n : std_logic;
         A : in std_logic_vector(width-1 downto 0);
         B : in std_logic_vector(integer(floor(log2(real(width))))-1 downto 0); 
         OP: in std_logic_vector(1 downto 0);
         S : out std_logic_vector(width-1 downto 0)
      );
   end component shift_module;
   
   component logic_module is
   generic(width : natural := 32);
      port (   
         A : in std_logic_vector(width-1 downto 0); 
         B : in std_logic_vector(width-1 downto 0);
         OP: in std_logic_vector(1 downto 0);  
         S : out std_logic_vector(width-1 downto 0)
      );
   end component logic_module;
   
   component add_sub_module is
   generic(width : natural := 32);
      port (
         A : in std_logic_vector(width-1 downto 0); 
         B : in std_logic_vector(width-1 downto 0);
         OP: in std_logic_vector(1 downto 0);  
         S : out std_logic_vector(width-1 downto 0);
         V_flag : out std_logic;
         Co : out std_logic
      );
   end component add_sub_module;
   
end package pkg_alu; 

--! Description of package body (if needed)
package body pkg_alu is

end package body pkg_alu;


