
--************************************************************************************************************--
--! @file file_name.vhd
--************************************************************************************************************--
--========================================== Libraries ==========================================
--! Standard library
library ieee;       
--! Standard packages              
use ieee.std_logic_1164.all;      
use work.pkg_ALU.all;

-- unit name: full name (shortname / entity name)
--
--! @brief <file content, behavior, purpose, special usage notes>
--! <further description>
--
--! @author <John William Croft (croft@student.chalmers.se)>
--
--! @date <--\--\---->
--
--! @version <v.>
--
--! @details

--========================================== Entity ==========================================
entity ALU_SKL is
generic (width : natural := 32);
port(
	clk 	: in std_logic;
	Reset_n : in std_logic;
	A 		: in std_logic_vector(31 downto 0);
	B 		: in std_logic_vector(31 downto 0);
	Op 		: in std_logic_vector(3 downto 0);
	Outs 	: out std_logic_vector(31 downto 0));
end entity ALU_SKL;

--========================================== Architecture Head ==========================================
architecture struct of ALU_SKL is

   signal c_out_s : std_logic;

   --==== FLAGS ====--
   signal SLT 		: std_logic;
   signal SLTU 	   : std_logic;
   signal V		   : std_logic;
   -- flag vectors
   signal vSLT : std_logic_vector(31 downto 0);
   signal vSLTU: std_logic_vector(31 downto 0);
   
   -- Connections to input/output registers
   signal A_in, A_out   : std_logic_vector(31 downto 0);
   signal B_in, B_out   : std_logic_vector(31 downto 0);
   signal OP_in, OP_out : std_logic_vector(3 downto 0);
   signal Outs_in       : std_logic_vector(31 downto 0);

   signal add_sub_out, logic_out, shift_out, SLTx_out, ALU_SKL_output_mux_out: std_logic_vector(31 downto 0);
--========================================== Architecture Body ==========================================
begin

   -- Comparator flags A<B
   SLTU 	<= not(c_out_s);
   
   
  
               
   SLT 	<= (V xor add_sub_out(width-1));

   vSLT <= (width-1 downto 1 => '0') & SLT;
   vSLTU <= (width-1 downto 1 => '0') & SLTU;
   

-- (width-1 downto 1 => '0') & 


   ALU_SKL_output_mux : mux41
   generic map (width => width)
   port map (mux41_in_0 => add_sub_out,
             mux41_in_1 => logic_out,
             mux41_in_2 => shift_out,
             mux41_in_3 => SLTx_out,
             mux41_sel  => OP_out(3 downto 2), 
             mux41_out  => ALU_SKL_output_mux_out);

   comp_add_sub_module : add_sub_module
   generic map (width => width)
   port map (A  => A_out,
             B  => B_out,
             OP => OP_out(1 downto 0),
             S  => add_sub_out,
             V_flag => V,
             Co => c_out_s);


   comp_logic_module : logic_module
   generic map (width => width)
   port map (A  => A_out,
             B  => B_out,
             OP => OP_out(1 downto 0),
             S  => logic_out);
   
   comp_shift_module : shift_module
   generic map (width => width)
   port map (clk     => clk,
             reset_n => reset_n,
             A       => A_out,
             B       => B_out(4 downto 0),
             OP      => OP_out(1 downto 0),
             S       => shift_out);
   
   SLTx_mux : mux41 
   generic map (width => width)
   port map (mux41_in_0 => (others => '1'),
             mux41_in_1 => (others => '1'),
             mux41_in_2 => vSLT,
             mux41_in_3 => vSLTU,
             mux41_sel  => OP_out(1 downto 0),
             mux41_out  => SLTx_out);










   -- Reset mux
   A_in     <= (others => '0') when Reset_n='0' else A;
   B_in     <= (others => '0') when Reset_n='0' else B;
   OP_in    <= (others => '0') when Reset_n='0' else OP;
   Outs_in  <= (others => '0') when Reset_n='0' else ALU_SKL_output_mux_out;

   A_DFF : vDFF
   generic map (WIDTH => WIDTH)
   port map (clk => clk,
             D   => A_in,
             Q   => A_out);
             
   B_DFF : vDFF
   generic map (WIDTH => WIDTH)
   port map (clk => clk,
             D   => B_in,
             Q   => B_out);
             
   OP_DFF : vDFF
   generic map (WIDTH => 4)
   port map (clk => clk,
             D   => OP_in,
             Q   => OP_out);
             
   Outs_DFF : vDFF
   generic map (WIDTH => WIDTH)
   port map (clk => clk,
             D   => Outs_in,
             Q   => Outs);

end architecture struct;