--************************************************************************************************************--
--! @file file_name.vhd
--************************************************************************************************************--
--========================================== Libraries ==========================================
--! Standard library
library ieee;       
--! Standard packages              
use ieee.std_logic_1164.all;  
use ieee.math_real.all;    

-- unit name: full name (shortname / entity name)
--
--! @brief <file content, behavior, purpose, special usage notes>
--! <further description>
--
--! @author <John William Croft (croft@student.chalmers.se)>
--
--! @date <--\--\---->
--
--! @version <v.>
--
--! @details

--========================================== Entity ==========================================
entity tb_shift_module is
   generic(width : natural := 32);
end entity tb_shift_module;

architecture tb of tb_shift_module is

-- Signal declarations
signal   clk     : std_logic:='0';
signal   reset_n : std_logic:='0';
signal   A       : std_logic_vector(width-1 downto 0);
signal   B       : std_logic_vector(integer(floor(log2(real(width))))-1 downto 0);
signal   OP      : std_logic_vector(1 downto 0);
signal   S       : std_logic_vector(width-1 downto 0);

signal time_step : natural :=0;

--! Component declaration for shift_module
component shift_module is
   generic( width : natural);     
   port (
      clk:in std_logic;
      reset_n : std_logic;
      A : in std_logic_vector(width-1 downto 0);
      B : in std_logic_vector(integer(floor(log2(real(width))))-1 downto 0); 
      OP: in std_logic_vector(1 downto 0);
      S : out std_logic_vector(width-1 downto 0)
   );
end component shift_module;
begin

   --! Port map declaration for shift_module
   comp_shift_module : shift_module
      generic map (
                   width => width
   )
      port map (
                clk     => clk,
                reset_n => reset_n,
                A       => A,
                B       => B,
                OP      => OP,
                S       => S
   );
   
   
   
   
   clk <= not clk after 5 ns;
   
   reset_n <= '1' after 44 ns;
   
   A <= X"FFFFFFFA";
   
   B <= "00001";
   
   OP <= "00",
         "10" after 100 ns,
         "11" after 200 ns;


end architecture tb;