---------------------------------
-- ripple_adder_tb3_8_bit.vhdl --
-- test bench type 3 for       --
-- 8-bit version of            --
-- generic ripple carry adder  --
---------------------------------

LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
USE ieee.numeric_std.ALL;

ENTITY ripple_adder_tb3_8_bit IS
   GENERIC(WIDTH:NATURAL:=8);
END ripple_adder_tb3_8_bit;

ARCHITECTURE arch_ripple_adder_tb3_8_bit OF
                        ripple_adder_tb3_8_bit IS

   COMPONENT ripple_adder IS
      GENERIC(WIDTH:NATURAL:=8);
      PORT(a:IN STD_LOGIC_VECTOR(WIDTH-1 DOWNTO 0);
           b:IN STD_LOGIC_VECTOR(WIDTH-1 DOWNTO 0);
           y:OUT STD_LOGIC_VECTOR(WIDTH-1 DOWNTO 0));
   END COMPONENT ripple_adder;

   SIGNAL a_tb_signal:STD_LOGIC_VECTOR(WIDTH-1 DOWNTO 0);
   SIGNAL b_tb_signal:STD_LOGIC_VECTOR(WIDTH-1 DOWNTO 0);
   SIGNAL y_tb_signal:STD_LOGIC_VECTOR(WIDTH-1 DOWNTO 0);
BEGIN
   ripple_adder_comp:
   COMPONENT ripple_adder
      GENERIC MAP(WIDTH=>WIDTH)
      PORT MAP(a=>a_tb_signal,
               b=>b_tb_signal,
               y=>y_tb_signal);

   a_tb_signal<="00000000",  -- 0
                "01010101" AFTER 100 ns, -- 85
                "11100101" AFTER 300 ns; -- -27
   b_tb_signal<="00000000",  -- 0
                "00011101" AFTER 100 ns, -- 29
                "00111000" AFTER 200 ns, -- 56
                "00000110" AFTER 400 ns, -- 6
                "11001000" AFTER 500 ns, -- -56
                "10010111" AFTER 600 ns; -- --105

   test_proc:
   PROCESS
   BEGIN
      WAIT FOR 50 ns; -- 50 ns 0+0=0 (00000000)
      ASSERT (y_tb_signal="00000000")
      REPORT "Error for 0+0"
      SEVERITY ERROR;
      WAIT FOR 100 ns; -- 150 ns 85+29=114 (01110010)
      ASSERT (y_tb_signal="01110010")
      REPORT "Error for 85+29=114"
      SEVERITY ERROR;
      WAIT FOR 100 ns; -- 250 ns 85+56=141->-115 (10001101)
      ASSERT (y_tb_signal="10001101")
      REPORT "Error for 85+56=-115"
      SEVERITY ERROR;
      WAIT FOR 100 ns; -- 350 ns -27+56=29 (00011101)
      ASSERT (y_tb_signal="00011101")
      REPORT "Error for -27+56=29"
      SEVERITY ERROR;
      WAIT FOR 100 ns; -- 450 ns -27+6=-21 (11101011)
      ASSERT (y_tb_signal="11101011")
      REPORT "Error for -27+6=-21"
      SEVERITY ERROR;
      WAIT FOR 100 ns; -- 550 ns -27-56=-83 (10101101)
      ASSERT (y_tb_signal="10101101")
      REPORT "Error for -27-83"
      SEVERITY ERROR;
      WAIT FOR 100 ns; -- 650 ns -27-105=-132->124 (11011000)
      ASSERT (y_tb_signal="01111100")
      REPORT "Error for -27-105=124"
      SEVERITY ERROR;
   END PROCESS test_proc;
END arch_ripple_adder_tb3_8_bit;