---------------------------------
-- ripple_adder_tb3_4_bit.vhdl --
-- test bench type 3 for       --
-- 4-bit version of            --
-- generic ripple carry adder  --
---------------------------------

LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
USE ieee.numeric_std.ALL;


ENTITY ripple_adder_tb3_4_bit IS
GENERIC(WIDTH:NATURAL:=4);
END ripple_adder_tb3_4_bit;

ARCHITECTURE arch_ripple_adder_tb3_4_bit OF
                               ripple_adder_tb3_4_bit IS

   component rca_generic is
   generic(width:integer:=4);
   port ( 
         a, b  :  in std_logic_vector(width-1 downto 0);
         c_in  :  in std_logic; 
         c_out :  out std_logic;
         y     :  out std_logic_vector(width-1 downto 0));
end component rca_generic;

   SIGNAL a_tb_signal:STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL b_tb_signal:STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL y_tb_signal:STD_LOGIC_VECTOR(3 DOWNTO 0);
   signal cin, cout : std_logic;
BEGIN
   ripple_adder_comp:
   COMPONENT rca_generic
   GENERIC MAP(WIDTH=>WIDTH)
      PORT MAP(a=>a_tb_signal,
               b=>b_tb_signal,
               y=>y_tb_signal,
               c_in => '0',
               c_out => OPEN);

   a_tb_signal<="0000",  -- 0
                "0101" AFTER 100 ns, -- 5
                "1110" AFTER 300 ns; -- -2
   b_tb_signal<="0000",  -- 0
                "0010" AFTER 100 ns, -- 2
                "0110" AFTER 200 ns, -- 6
                "0010" AFTER 400 ns, -- 2
                "1011" AFTER 500 ns, -- -5
                "1000" AFTER 600 ns; -- -8

   test_proc:
   PROCESS
   BEGIN
      WAIT FOR 50 ns; -- 50 ns 0+0=0 (0000)
      ASSERT (y_tb_signal="0000")
      REPORT "Error for 0+0"
      SEVERITY ERROR;

      WAIT FOR 100 ns; -- 150 ns 5+2= (0111)
      ASSERT (y_tb_signal="0111")
      REPORT "Error for 5+2=7"
      SEVERITY ERROR;

      WAIT FOR 100 ns; -- 250 ns 5+6=11->-5 (1011)
      ASSERT (y_tb_signal="1011")
      REPORT "Error for 5+6=-5"
      SEVERITY ERROR;

      WAIT FOR 100 ns; -- 350 ns -2+6=4 (0100)
      ASSERT (y_tb_signal="0100")
      REPORT "Error for -27+6=4"
      SEVERITY ERROR;

      WAIT FOR 100 ns; -- 450 ns -2+=0 (0000)
      ASSERT (y_tb_signal="0000")
      REPORT "Error for -2+2=0"
      SEVERITY ERROR;

      WAIT FOR 100 ns; -- 550 ns -2-5==-7->9 (1001)
      ASSERT (y_tb_signal="1001")
      REPORT "Error for -2-5=7"
      SEVERITY ERROR;

      WAIT FOR 100 ns; -- 650 ns -2-8=-10->6 (0110)
      ASSERT (y_tb_signal="0110")
      REPORT "Error for -2-8=6"
      SEVERITY ERROR;
   END PROCESS test_proc;
   
END arch_ripple_adder_tb3_4_bit;