--************************************************************************************************************--
--! @file file_name.vhd
--************************************************************************************************************--
--========================================== Libraries ==========================================
--! Standard library
library ieee;       
--! Standard packages              
use ieee.std_logic_1164.all;      

-- unit name: full name (shortname / entity name)
--
--! @brief <file content, behavior, purpose, special usage notes>
--! <further description>
--
--! @author <John William Croft (croft@student.chalmers.se)>
--
--! @date <--\--\---->
--
--! @version <v.>
--
--! @details

--========================================== Entity ==========================================
library ieee ;
use ieee.std_logic_1164.all ;

entity mux41 is 
   generic(width : natural := 32);
   port (
      mux41_in_0  : in std_logic_vector (width-1 downto 0);
      mux41_in_1  : in std_logic_vector (width-1 downto 0);
      mux41_in_2  : in std_logic_vector (width-1 downto 0);
      mux41_in_3  : in std_logic_vector (width-1 downto 0);
      mux41_sel   : in std_logic_vector(1 downto 0);
      mux41_out   : out std_logic_vector (width-1 downto 0)
   );
end mux41;
--========================================== architecture head ==========================================
architecture dataflow of mux41 is
begin

   with mux41_sel(1 downto 0) select
	mux41_out <=   mux41_in_0  when "00",
                  mux41_in_1  when "01",
                  mux41_in_2  when "10",
                  mux41_in_3  when "11",
                  (others => 'X') when others; -- force unknown if unexpected input.

end dataflow;
