--************************************************************************************************************--
--! @file file_name.vhd
--************************************************************************************************************--
--========================================== Libraries ==========================================
--! Standard library
library ieee;       
--! Standard packages              
use ieee.std_logic_1164.all;      

-- unit name: full name (shortname / entity name)
--
--! @brief <file content, behavior, purpose, special usage notes>
--! <further description>
--
--! @author <John William Croft (croft@student.chalmers.se)>
--
--! @date <--\--\---->
--
--! @version <v.>
--
--! @details

--========================================== Entity ==========================================
entity logic_module is
   generic(width : natural := 32);
   port (   
      A : in std_logic_vector(width-1 downto 0); -- Consider defining a subtype and packaging.
      B : in std_logic_vector(width-1 downto 0);
      OP: in std_logic_vector(1 downto 0);  -- mux select using opcode. At the moment only chooses subtraction via cin, but may be used to set various arithmetic flags in future.
      S : out std_logic_vector(width-1 downto 0)
   );
end entity logic_module;
--========================================== Architecture Head ==========================================
architecture rtl of logic_module is
   --==== Component Declaration ====--
      --== MUX41 ==--
      component mux41 is 
      generic(width : natural);
         port (
            mux41_in_0  : in std_logic_vector (width-1 downto 0);
            mux41_in_1  : in std_logic_vector (width-1 downto 0);
            mux41_in_2  : in std_logic_vector (width-1 downto 0);
            mux41_in_3  : in std_logic_vector (width-1 downto 0);
            mux41_sel   : in std_logic_vector(1 downto 0);
            mux41_out   : out std_logic_vector (width-1 downto 0)
         );
      end component mux41;
      
      
      
   --==== Signals ====--
   signal ored    : std_logic_vector (width-1 downto 0);
   signal anded   : std_logic_vector (width-1 downto 0);
   signal xored   : std_logic_vector (width-1 downto 0);
   signal nored   : std_logic_vector (width-1 downto 0);
--========================================== Architecture Body ==========================================
begin
   --==== Static Assignments ====--
   ored  <= A or B;
   anded <= A and B;
   xored <= A xor B;
   nored <= A nor B;

   --==== Component Instantiation ====--
      --== MUX41 ==--
   comp_mux41 : mux41
      generic map (width => width)
      port map (mux41_in_0 => ored,
                mux41_in_1 => anded,
                mux41_in_2 => xored,
                mux41_in_3 => nored,
                mux41_sel  => OP,
                mux41_out  => S);

end architecture rtl;
