--************************************************************************************************************--
--! @file file_name.vhd
--************************************************************************************************************--
--========================================== Libraries ==========================================
--! Standard library
library ieee;       
--! Standard packages              
use ieee.std_logic_1164.all;      

-- unit name: full name (shortname / entity name)
--
--! @brief <file content, behavior, purpose, special usage notes>
--! <further description>
--
--! @author <John William Croft (croft@student.chalmers.se)>
--
--! @date <--\--\---->
--
--! @version <v.>
--
--! @details

--========================================== Entity ==========================================
entity vDFF is
   generic(WIDTH : natural := 32);
   port (
      clk   : in std_logic; -- no "reset" signal. For async reset, simply input reset value on D.
      D     : in std_logic_vector(WIDTH-1 downto 0);
      Q     : out std_logic_vector(WIDTH-1 downto 0)
   );
end entity vDFF;

architecture behv of vDFF is
begin

   process(clk)
   begin
      if rising_edge(clk) then 
         Q <= D;
      end if;
   end process;
   
end architecture behv;
