--************************************************************************************************************--
--! @file file_name.vhd
--************************************************************************************************************--
------------------------------------------------- Libraries ----------------------------------------------------
--! Standard library
library ieee;       
--! Standard packages              
use ieee.std_logic_1164.all;              
----------------------------------------------------------------------------------------------------------------
-- --
-- DAT110 
-- --
----------------------------------------------------------------------------------------------------------------
--
-- unit name: full name (shortname / entity name)
--
--! @brief 
--
--! @author John William Croft (croft@student.chalmers.se)
--
--! @date --\--\----
--
--! @version v.
--
--! @details Uses the following instruction opcodes (aliases):
--! @details * 0000: add A+B (signed)
--! @details * 0001: add A+B (unsigned)
--! @details * 0010: sub A-B (signed)
--! @details * 0011: sub A-B (unsigned)
--! @details * 0100: bitwise OR
--! @details * 0101: bitwise AND
--! @details * 0110: bitwise XOR
--! @details * 0111: bitwise NOR
--! @details * 1000: shift left
--! @details * 1010: shift right (logical)
--! @details * 1011: shift right (arithmetical, signed)
--! @details * 1110: SLT (Set on Less Than)
--! @details * 1111: SLTU (Set on Less Than Unsigned)
--!
--! <b>Dependencies:</b>\n
--! Entity Name,...
--!
--! <b>References:</b>\n
--! reference one \n
--! reference two
--!
--! <b>Modified by:</b>\n
--! Author: John William Croft
-------------------------------------------------------------------------------
--! \n\n<b>Last changes:</b>\n
--! date initials log\n
--! extended description
-------------------------------------------------------------------------------
--                    
------------------------------------------------- Entity -------------------------------------------------------
entity ALU is
   port(
      Clk      :  in std_logic;                       --! System clock
      Reset_n  :  in std_logic;                       --! Active low synchronous(?) reset.
      A        :  in std_logic_vector(31 downto 0);   --! Input A.
      B        :  in std_logic_vector(31 downto 0);   --! Input B.
      Op       :  in std_logic_vector(3  downto 0);   --! Operation select signal.
      Outs     : out std_logic_vector(31 downto 0)    --! Output.
   );  
end ALU;

architecture rtl of ALU is

begin


end architecture rtl;
