/*
 * Decompiled with CFR 0.152.
 */
package grafica;

import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PFont;

public class GTitle
implements PConstants {
    protected final PApplet parent;
    protected float[] dim;
    protected float relativePos;
    protected float plotPos;
    protected float offset;
    protected String text;
    protected int textAlignment;
    protected String fontName;
    protected int fontColor;
    protected int fontSize;
    protected PFont font;

    public GTitle(PApplet pApplet, float[] fArray) {
        this.parent = pApplet;
        this.dim = (float[])fArray.clone();
        this.relativePos = 0.5f;
        this.plotPos = this.relativePos * this.dim[0];
        this.offset = 10.0f;
        this.text = "";
        this.textAlignment = 3;
        this.fontName = "SansSerif.bold";
        this.fontColor = this.parent.color(100);
        this.fontSize = 13;
        this.font = this.parent.createFont(this.fontName, (float)this.fontSize);
    }

    public void draw() {
        this.parent.pushStyle();
        this.parent.textMode(4);
        this.parent.textFont(this.font);
        this.parent.textSize((float)this.fontSize);
        this.parent.fill(this.fontColor);
        this.parent.noStroke();
        this.parent.textAlign(this.textAlignment, 102);
        this.parent.text(this.text, this.plotPos, -this.offset - this.dim[1]);
        this.parent.popStyle();
    }

    public void setDim(float f, float f2) {
        if (f > 0.0f && f2 > 0.0f) {
            this.dim[0] = f;
            this.dim[1] = f2;
            this.plotPos = this.relativePos * this.dim[0];
        }
    }

    public void setDim(float[] fArray) {
        this.setDim(fArray[0], fArray[1]);
    }

    public void setRelativePos(float f) {
        this.relativePos = f;
        this.plotPos = this.relativePos * this.dim[0];
    }

    public void setOffset(float f) {
        this.offset = f;
    }

    public void setText(String string) {
        this.text = string;
    }

    public void setTextAlignment(int n) {
        if (n == 3 || n == 37 || n == 39) {
            this.textAlignment = n;
        }
    }

    public void setFontName(String string) {
        this.fontName = string;
        this.font = this.parent.createFont(this.fontName, (float)this.fontSize);
    }

    public void setFontColor(int n) {
        this.fontColor = n;
    }

    public void setFontSize(int n) {
        if (n > 0) {
            this.fontSize = n;
            this.font = this.parent.createFont(this.fontName, (float)this.fontSize);
        }
    }

    public void setFontProperties(String string, int n, int n2) {
        if (n2 > 0) {
            this.fontName = string;
            this.fontColor = n;
            this.fontSize = n2;
            this.font = this.parent.createFont(this.fontName, (float)this.fontSize);
        }
    }
}

