/*
 * Decompiled with CFR 0.152.
 */
package grafica;

import processing.core.PVector;

public class GPoint {
    protected float x;
    protected float y;
    protected String label;
    protected boolean valid;

    public GPoint(float f, float f2, String string) {
        this.x = f;
        this.y = f2;
        this.label = string;
        this.valid = this.isValidNumber(this.x) && this.isValidNumber(this.y);
    }

    public GPoint(float f, float f2) {
        this(f, f2, "");
    }

    public GPoint(PVector pVector, String string) {
        this(pVector.x, pVector.y, string);
    }

    public GPoint(PVector pVector) {
        this(pVector.x, pVector.y, "");
    }

    public GPoint(GPoint gPoint) {
        this(gPoint.getX(), gPoint.getY(), gPoint.getLabel());
    }

    protected boolean isValidNumber(float f) {
        return !Float.isNaN(f) && !Float.isInfinite(f);
    }

    public void set(float f, float f2, String string) {
        this.x = f;
        this.y = f2;
        this.label = string;
        this.valid = this.isValidNumber(this.x) && this.isValidNumber(this.y);
    }

    public void set(GPoint gPoint) {
        this.set(gPoint.getX(), gPoint.getY(), gPoint.getLabel());
    }

    public void set(PVector pVector, String string) {
        this.set(pVector.x, pVector.y, string);
    }

    public void setX(float f) {
        this.x = f;
        this.valid = this.isValidNumber(this.x) && this.isValidNumber(this.y);
    }

    public void setY(float f) {
        this.y = f;
        this.valid = this.isValidNumber(this.x) && this.isValidNumber(this.y);
    }

    public void setXY(float f, float f2) {
        this.x = f;
        this.y = f2;
        this.valid = this.isValidNumber(this.x) && this.isValidNumber(this.y);
    }

    public void setXY(PVector pVector) {
        this.setXY(pVector.x, pVector.y);
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean getValid() {
        return this.valid;
    }

    public boolean isValid() {
        return this.valid;
    }
}

