/*
 * Decompiled with CFR 0.152.
 */
package grafica;

import grafica.GHistogram;
import grafica.GPlot;
import grafica.GPoint;
import grafica.GPointsArray;
import java.util.ArrayList;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PFont;
import processing.core.PImage;
import processing.core.PShape;

public class GLayer
implements PConstants {
    protected final PApplet parent;
    protected final String id;
    protected float[] dim;
    protected float[] xLim;
    protected float[] yLim;
    protected boolean xLog;
    protected boolean yLog;
    protected GPointsArray points;
    protected GPointsArray plotPoints;
    protected ArrayList<Boolean> inside;
    protected int[] pointColors;
    protected float[] pointSizes;
    protected int lineColor;
    protected float lineWidth;
    protected GHistogram hist;
    protected GPoint histBasePoint;
    protected int labelBgColor;
    protected float[] labelSeparation;
    protected String fontName;
    protected int fontColor;
    protected int fontSize;
    protected PFont font;
    protected float[][] cuts = new float[4][2];

    public GLayer(PApplet pApplet, String string, float[] fArray, float[] fArray2, float[] fArray3, boolean bl, boolean bl2) {
        this.parent = pApplet;
        this.id = string;
        this.dim = (float[])fArray.clone();
        this.xLim = (float[])fArray2.clone();
        this.yLim = (float[])fArray3.clone();
        this.xLog = bl;
        this.yLog = bl2;
        if (this.xLog && (this.xLim[0] <= 0.0f || this.xLim[1] <= 0.0f)) {
            PApplet.println((String)"One of the limits is negative. This is not allowed in logarithmic scale.");
            PApplet.println((String)"Will set horizontal limits to (0.1, 10)");
            this.xLim[0] = 0.1f;
            this.xLim[1] = 10.0f;
        }
        if (this.yLog && (this.yLim[0] <= 0.0f || this.yLim[1] <= 0.0f)) {
            PApplet.println((String)"One of the limits is negative. This is not allowed in logarithmic scale.");
            PApplet.println((String)"Will set vertical limits to (0.1, 10)");
            this.yLim[0] = 0.1f;
            this.yLim[1] = 10.0f;
        }
        this.points = new GPointsArray();
        this.plotPoints = new GPointsArray();
        this.inside = new ArrayList();
        this.pointColors = new int[]{this.parent.color(255, 0, 0, 150)};
        this.pointSizes = new float[]{7.0f};
        this.lineColor = this.parent.color(0, 150);
        this.lineWidth = 1.0f;
        this.hist = null;
        this.histBasePoint = new GPoint(0.0f, 0.0f);
        this.labelBgColor = this.parent.color(255, 200);
        this.labelSeparation = new float[]{7.0f, 7.0f};
        this.fontName = "SansSerif.plain";
        this.fontColor = this.parent.color(0);
        this.fontSize = 11;
        this.font = this.parent.createFont(this.fontName, (float)this.fontSize);
    }

    protected boolean isValidNumber(float f) {
        return !Float.isNaN(f) && !Float.isInfinite(f);
    }

    public boolean isId(String string) {
        return this.id.equals(string);
    }

    public float valueToXPlot(float f) {
        if (this.xLog) {
            return this.dim[0] * PApplet.log((float)(f / this.xLim[0])) / PApplet.log((float)(this.xLim[1] / this.xLim[0]));
        }
        return this.dim[0] * (f - this.xLim[0]) / (this.xLim[1] - this.xLim[0]);
    }

    public float valueToYPlot(float f) {
        if (this.yLog) {
            return -this.dim[1] * PApplet.log((float)(f / this.yLim[0])) / PApplet.log((float)(this.yLim[1] / this.yLim[0]));
        }
        return -this.dim[1] * (f - this.yLim[0]) / (this.yLim[1] - this.yLim[0]);
    }

    public float[] valueToPlot(float f, float f2) {
        return new float[]{this.valueToXPlot(f), this.valueToYPlot(f2)};
    }

    public GPoint valueToPlot(GPoint gPoint) {
        return new GPoint(this.valueToXPlot(gPoint.getX()), this.valueToYPlot(gPoint.getY()), gPoint.getLabel());
    }

    public GPointsArray valueToPlot(GPointsArray gPointsArray) {
        int n = gPointsArray.getNPoints();
        GPointsArray gPointsArray2 = new GPointsArray(n);
        if (this.xLog && this.yLog) {
            float f = this.dim[0] / PApplet.log((float)(this.xLim[1] / this.xLim[0]));
            float f2 = -this.dim[1] / PApplet.log((float)(this.yLim[1] / this.yLim[0]));
            for (int i = 0; i < n; ++i) {
                float f3 = PApplet.log((float)(gPointsArray.getX(i) / this.xLim[0])) * f;
                float f4 = PApplet.log((float)(gPointsArray.getY(i) / this.yLim[0])) * f2;
                gPointsArray2.add(f3, f4, gPointsArray.getLabel(i));
            }
        } else if (this.xLog) {
            float f = this.dim[0] / PApplet.log((float)(this.xLim[1] / this.xLim[0]));
            float f5 = -this.dim[1] / (this.yLim[1] - this.yLim[0]);
            for (int i = 0; i < n; ++i) {
                float f6 = PApplet.log((float)(gPointsArray.getX(i) / this.xLim[0])) * f;
                float f7 = (gPointsArray.getY(i) - this.yLim[0]) * f5;
                gPointsArray2.add(f6, f7, gPointsArray.getLabel(i));
            }
        } else if (this.yLog) {
            float f = this.dim[0] / (this.xLim[1] - this.xLim[0]);
            float f8 = -this.dim[1] / PApplet.log((float)(this.yLim[1] / this.yLim[0]));
            for (int i = 0; i < n; ++i) {
                float f9 = (gPointsArray.getX(i) - this.xLim[0]) * f;
                float f10 = PApplet.log((float)(gPointsArray.getY(i) / this.yLim[0])) * f8;
                gPointsArray2.add(f9, f10, gPointsArray.getLabel(i));
            }
        } else {
            float f = this.dim[0] / (this.xLim[1] - this.xLim[0]);
            float f11 = -this.dim[1] / (this.yLim[1] - this.yLim[0]);
            for (int i = 0; i < n; ++i) {
                float f12 = (gPointsArray.getX(i) - this.xLim[0]) * f;
                float f13 = (gPointsArray.getY(i) - this.yLim[0]) * f11;
                gPointsArray2.add(f12, f13, gPointsArray.getLabel(i));
            }
        }
        return gPointsArray2;
    }

    protected void updatePlotPoints() {
        int n = this.points.getNPoints();
        if (this.xLog && this.yLog) {
            float f = this.dim[0] / PApplet.log((float)(this.xLim[1] / this.xLim[0]));
            float f2 = -this.dim[1] / PApplet.log((float)(this.yLim[1] / this.yLim[0]));
            for (int i = 0; i < n; ++i) {
                float f3 = PApplet.log((float)(this.points.getX(i) / this.xLim[0])) * f;
                float f4 = PApplet.log((float)(this.points.getY(i) / this.yLim[0])) * f2;
                this.plotPoints.set(i, f3, f4, this.points.getLabel(i));
            }
        } else if (this.xLog) {
            float f = this.dim[0] / PApplet.log((float)(this.xLim[1] / this.xLim[0]));
            float f5 = -this.dim[1] / (this.yLim[1] - this.yLim[0]);
            for (int i = 0; i < n; ++i) {
                float f6 = PApplet.log((float)(this.points.getX(i) / this.xLim[0])) * f;
                float f7 = (this.points.getY(i) - this.yLim[0]) * f5;
                this.plotPoints.set(i, f6, f7, this.points.getLabel(i));
            }
        } else if (this.yLog) {
            float f = this.dim[0] / (this.xLim[1] - this.xLim[0]);
            float f8 = -this.dim[1] / PApplet.log((float)(this.yLim[1] / this.yLim[0]));
            for (int i = 0; i < n; ++i) {
                float f9 = (this.points.getX(i) - this.xLim[0]) * f;
                float f10 = PApplet.log((float)(this.points.getY(i) / this.yLim[0])) * f8;
                this.plotPoints.set(i, f9, f10, this.points.getLabel(i));
            }
        } else {
            float f = this.dim[0] / (this.xLim[1] - this.xLim[0]);
            float f11 = -this.dim[1] / (this.yLim[1] - this.yLim[0]);
            for (int i = 0; i < n; ++i) {
                float f12 = (this.points.getX(i) - this.xLim[0]) * f;
                float f13 = (this.points.getY(i) - this.yLim[0]) * f11;
                this.plotPoints.set(i, f12, f13, this.points.getLabel(i));
            }
        }
        if (this.plotPoints.getNPoints() > n) {
            this.plotPoints.setNPoints(n);
        }
    }

    protected float xPlotToValue(float f) {
        if (this.xLog) {
            return PApplet.exp((float)(PApplet.log((float)this.xLim[0]) + PApplet.log((float)(this.xLim[1] / this.xLim[0])) * f / this.dim[0]));
        }
        return this.xLim[0] + (this.xLim[1] - this.xLim[0]) * f / this.dim[0];
    }

    protected float yPlotToValue(float f) {
        if (this.yLog) {
            return PApplet.exp((float)(PApplet.log((float)this.yLim[0]) - PApplet.log((float)(this.yLim[1] / this.yLim[0])) * f / this.dim[1]));
        }
        return this.yLim[0] - (this.yLim[1] - this.yLim[0]) * f / this.dim[1];
    }

    public float[] plotToValue(float f, float f2) {
        return new float[]{this.xPlotToValue(f), this.yPlotToValue(f2)};
    }

    public boolean isInside(float f, float f2) {
        return f >= 0.0f && f <= this.dim[0] && -f2 >= 0.0f && -f2 <= this.dim[1];
    }

    public boolean isInside(GPoint gPoint) {
        return gPoint.isValid() ? this.isInside(gPoint.getX(), gPoint.getY()) : false;
    }

    public boolean[] isInside(GPointsArray gPointsArray) {
        boolean[] blArray = new boolean[gPointsArray.getNPoints()];
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = this.isInside(gPointsArray.get(i));
        }
        return blArray;
    }

    protected void updateInsideList() {
        this.inside.clear();
        int n = this.plotPoints.getNPoints();
        for (int i = 0; i < n; ++i) {
            this.inside.add(this.isInside(this.plotPoints.get(i)));
        }
    }

    public int getPointIndexAtPlotPos(float f, float f2) {
        int n = -1;
        if (this.isInside(f, f2)) {
            int n2 = this.plotPoints.getNPoints();
            float f3 = 25.0f;
            for (int i = 0; i < n2; ++i) {
                float f4;
                if (!this.inside.get(i).booleanValue() || !((f4 = PApplet.sq((float)(this.plotPoints.getX(i) - f)) + PApplet.sq((float)(this.plotPoints.getY(i) - f2))) < f3)) continue;
                f3 = f4;
                n = i;
            }
        }
        return n;
    }

    public GPoint getPointAtPlotPos(float f, float f2) {
        int n = this.getPointIndexAtPlotPos(f, f2);
        return n >= 0 ? this.points.get(n) : null;
    }

    protected int obtainBoxIntersections(GPoint gPoint, GPoint gPoint2) {
        int n = 0;
        if (gPoint.isValid() && gPoint2.isValid()) {
            boolean bl;
            float f = gPoint.getX();
            float f2 = gPoint.getY();
            float f3 = gPoint2.getX();
            float f4 = gPoint2.getY();
            boolean bl2 = this.isInside(f, f2);
            boolean bl3 = this.isInside(f3, f4);
            boolean bl4 = bl = bl2 && bl3 || f < 0.0f && f3 < 0.0f || f > this.dim[0] && f3 > this.dim[0] || -f2 < 0.0f && -f4 < 0.0f || -f2 > this.dim[1] && -f4 > this.dim[1];
            if (!bl) {
                float f5 = f3 - f;
                float f6 = f4 - f2;
                if (f5 == 0.0f) {
                    n = 2;
                    this.cuts[0][0] = f;
                    this.cuts[0][1] = 0.0f;
                    this.cuts[1][0] = f;
                    this.cuts[1][1] = -this.dim[1];
                } else if (f6 == 0.0f) {
                    n = 2;
                    this.cuts[0][0] = 0.0f;
                    this.cuts[0][1] = f2;
                    this.cuts[1][0] = this.dim[0];
                    this.cuts[1][1] = f2;
                } else {
                    float f7 = f6 / f5;
                    float f8 = f2 - f7 * f;
                    n = 4;
                    this.cuts[0][0] = -f8 / f7;
                    this.cuts[0][1] = 0.0f;
                    this.cuts[1][0] = (-this.dim[1] - f8) / f7;
                    this.cuts[1][1] = -this.dim[1];
                    this.cuts[2][0] = 0.0f;
                    this.cuts[2][1] = f8;
                    this.cuts[3][0] = this.dim[0];
                    this.cuts[3][1] = f8 + f7 * this.dim[0];
                }
                n = this.getValidCuts(this.cuts, n, gPoint, gPoint2);
                if (bl2 || bl3) {
                    if (n != 1) {
                        GPoint gPoint3;
                        GPoint gPoint4 = gPoint3 = bl2 ? gPoint : gPoint2;
                        if (n > 1 && (n = this.removeDuplicatedCuts(this.cuts, n, 0.0f)) > 1 && (n = this.removePointFromCuts(this.cuts, n, gPoint3, 0.0f)) > 1 && (n = this.removeDuplicatedCuts(this.cuts, n, 0.001f)) > 1) {
                            n = this.removePointFromCuts(this.cuts, n, gPoint3, 0.001f);
                        }
                        if (n == 0) {
                            n = 1;
                            this.cuts[0][0] = gPoint3.getX();
                            this.cuts[1][0] = gPoint3.getY();
                        }
                    }
                } else {
                    if (n > 2 && (n = this.removeDuplicatedCuts(this.cuts, n, 0.0f)) > 2) {
                        n = this.removeDuplicatedCuts(this.cuts, n, 0.001f);
                    }
                    if (n == 2 && PApplet.sq((float)(this.cuts[0][0] - f)) + PApplet.sq((float)(this.cuts[0][1] - f2)) > PApplet.sq((float)(this.cuts[1][0] - f)) + PApplet.sq((float)(this.cuts[1][1] - f2))) {
                        this.cuts[2][0] = this.cuts[0][0];
                        this.cuts[2][1] = this.cuts[0][1];
                        this.cuts[0][0] = this.cuts[1][0];
                        this.cuts[0][1] = this.cuts[1][1];
                        this.cuts[1][0] = this.cuts[2][0];
                        this.cuts[1][1] = this.cuts[2][1];
                    }
                    if (n == 1) {
                        n = 2;
                        this.cuts[1][0] = this.cuts[0][0];
                        this.cuts[1][1] = this.cuts[0][1];
                    }
                }
                if ((bl2 || bl3) && n != 1) {
                    PApplet.println((String)"There should be one cut!!!");
                } else if (!bl2 && !bl3 && n != 0 && n != 2) {
                    PApplet.println((String)("There should be either 0 or 2 cuts!!! " + n + " were found"));
                }
            }
        }
        return n;
    }

    protected int getValidCuts(float[][] fArray, int n, GPoint gPoint, GPoint gPoint2) {
        float f = gPoint.getX();
        float f2 = gPoint.getY();
        float f3 = gPoint2.getX();
        float f4 = gPoint2.getY();
        float f5 = Math.abs(f3 - f);
        float f6 = Math.abs(f4 - f2);
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (!this.isInside(fArray[i][0], fArray[i][1]) || !(Math.abs(fArray[i][0] - f) <= f5) || !(Math.abs(fArray[i][1] - f2) <= f6) || !(Math.abs(fArray[i][0] - f3) <= f5) || !(Math.abs(fArray[i][1] - f4) <= f6)) continue;
            fArray[n2][0] = fArray[i][0];
            fArray[n2][1] = fArray[i][1];
            ++n2;
        }
        return n2;
    }

    protected int removeDuplicatedCuts(float[][] fArray, int n, float f) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            boolean bl = false;
            for (int j = 0; j < n2; ++j) {
                if (!(Math.abs(fArray[j][0] - fArray[i][0]) <= f) || !(Math.abs(fArray[j][1] - fArray[i][1]) <= f)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            fArray[n2][0] = fArray[i][0];
            fArray[n2][1] = fArray[i][1];
            ++n2;
        }
        return n2;
    }

    protected int removePointFromCuts(float[][] fArray, int n, GPoint gPoint, float f) {
        float f2 = gPoint.getX();
        float f3 = gPoint.getY();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (!(Math.abs(fArray[i][0] - f2) > f) && !(Math.abs(fArray[i][1] - f3) > f)) continue;
            fArray[n2][0] = fArray[i][0];
            fArray[n2][1] = fArray[i][1];
            ++n2;
        }
        return n2;
    }

    public void startHistogram(int n) {
        this.hist = new GHistogram(this.parent, n, this.dim, this.plotPoints);
    }

    public void drawPoints() {
        int n = this.plotPoints.getNPoints();
        int n2 = this.pointColors.length;
        int n3 = this.pointSizes.length;
        this.parent.pushStyle();
        this.parent.ellipseMode(3);
        this.parent.noStroke();
        if (n2 == 1 && n3 == 1) {
            this.parent.fill(this.pointColors[0]);
            for (int i = 0; i < n; ++i) {
                if (!this.inside.get(i).booleanValue()) continue;
                this.parent.ellipse(this.plotPoints.getX(i), this.plotPoints.getY(i), this.pointSizes[0], this.pointSizes[0]);
            }
        } else if (n2 == 1) {
            this.parent.fill(this.pointColors[0]);
            for (int i = 0; i < n; ++i) {
                if (!this.inside.get(i).booleanValue()) continue;
                this.parent.ellipse(this.plotPoints.getX(i), this.plotPoints.getY(i), this.pointSizes[i % n3], this.pointSizes[i % n3]);
            }
        } else if (n3 == 1) {
            for (int i = 0; i < n; ++i) {
                if (!this.inside.get(i).booleanValue()) continue;
                this.parent.fill(this.pointColors[i % n2]);
                this.parent.ellipse(this.plotPoints.getX(i), this.plotPoints.getY(i), this.pointSizes[0], this.pointSizes[0]);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                if (!this.inside.get(i).booleanValue()) continue;
                this.parent.fill(this.pointColors[i % n2]);
                this.parent.ellipse(this.plotPoints.getX(i), this.plotPoints.getY(i), this.pointSizes[i % n3], this.pointSizes[i % n3]);
            }
        }
        this.parent.popStyle();
    }

    public void drawPoints(PShape pShape) {
        int n = this.plotPoints.getNPoints();
        int n2 = this.pointColors.length;
        this.parent.pushStyle();
        this.parent.shapeMode(3);
        if (n2 == 1) {
            this.parent.fill(this.pointColors[0]);
            this.parent.stroke(this.pointColors[0]);
            for (int i = 0; i < n; ++i) {
                if (!this.inside.get(i).booleanValue()) continue;
                this.parent.shape(pShape, this.plotPoints.getX(i), this.plotPoints.getY(i));
            }
        } else {
            for (int i = 0; i < n; ++i) {
                if (!this.inside.get(i).booleanValue()) continue;
                this.parent.fill(this.pointColors[i % n2]);
                this.parent.stroke(this.pointColors[i % n2]);
                this.parent.shape(pShape, this.plotPoints.getX(i), this.plotPoints.getY(i));
            }
        }
        this.parent.popStyle();
    }

    public void drawPoints(PImage pImage) {
        int n = this.plotPoints.getNPoints();
        this.parent.pushStyle();
        this.parent.imageMode(3);
        for (int i = 0; i < n; ++i) {
            if (!this.inside.get(i).booleanValue()) continue;
            this.parent.image(pImage, this.plotPoints.getX(i), this.plotPoints.getY(i));
        }
        this.parent.popStyle();
    }

    public void drawPoint(GPoint gPoint, int n, float f) {
        float f2;
        float f3 = this.valueToXPlot(gPoint.getX());
        if (this.isInside(f3, f2 = this.valueToYPlot(gPoint.getY()))) {
            this.parent.pushStyle();
            this.parent.ellipseMode(3);
            this.parent.fill(n);
            this.parent.noStroke();
            this.parent.ellipse(f3, f2, f, f);
            this.parent.popStyle();
        }
    }

    public void drawPoint(GPoint gPoint) {
        this.drawPoint(gPoint, this.pointColors[0], this.pointSizes[0]);
    }

    public void drawPoint(GPoint gPoint, PShape pShape) {
        float f = this.valueToXPlot(gPoint.getX());
        float f2 = this.valueToYPlot(gPoint.getY());
        this.parent.pushStyle();
        this.parent.shapeMode(3);
        if (this.isInside(f, f2)) {
            this.parent.shape(pShape, f, f2);
        }
        this.parent.popStyle();
    }

    public void drawPoint(GPoint gPoint, PShape pShape, int n) {
        float f;
        float f2 = this.valueToXPlot(gPoint.getX());
        if (this.isInside(f2, f = this.valueToYPlot(gPoint.getY()))) {
            this.parent.pushStyle();
            this.parent.shapeMode(3);
            this.parent.fill(n);
            this.parent.stroke(n);
            this.parent.strokeCap(1);
            this.parent.shape(pShape, f2, f);
            this.parent.popStyle();
        }
    }

    public void drawPoint(GPoint gPoint, PImage pImage) {
        float f = this.valueToXPlot(gPoint.getX());
        float f2 = this.valueToYPlot(gPoint.getY());
        this.parent.pushStyle();
        this.parent.imageMode(3);
        if (this.isInside(f, f2)) {
            this.parent.image(pImage, f, f2);
        }
        this.parent.popStyle();
    }

    public void drawLines() {
        this.parent.pushStyle();
        this.parent.noFill();
        this.parent.stroke(this.lineColor);
        this.parent.strokeWeight(this.lineWidth);
        this.parent.strokeCap(1);
        for (int i = 0; i < this.plotPoints.getNPoints() - 1; ++i) {
            if (this.inside.get(i).booleanValue() && this.inside.get(i + 1).booleanValue()) {
                this.parent.line(this.plotPoints.getX(i), this.plotPoints.getY(i), this.plotPoints.getX(i + 1), this.plotPoints.getY(i + 1));
                continue;
            }
            if (!this.plotPoints.isValid(i) || !this.plotPoints.isValid(i + 1)) continue;
            int n = this.obtainBoxIntersections(this.plotPoints.get(i), this.plotPoints.get(i + 1));
            if (this.inside.get(i).booleanValue()) {
                this.parent.line(this.plotPoints.getX(i), this.plotPoints.getY(i), this.cuts[0][0], this.cuts[0][1]);
                continue;
            }
            if (this.inside.get(i + 1).booleanValue()) {
                this.parent.line(this.cuts[0][0], this.cuts[0][1], this.plotPoints.getX(i + 1), this.plotPoints.getY(i + 1));
                continue;
            }
            if (n < 2) continue;
            this.parent.line(this.cuts[0][0], this.cuts[0][1], this.cuts[1][0], this.cuts[1][1]);
        }
        this.parent.popStyle();
    }

    public void drawLine(GPoint gPoint, GPoint gPoint2, int n, float f) {
        GPoint gPoint3 = this.valueToPlot(gPoint);
        GPoint gPoint4 = this.valueToPlot(gPoint2);
        if (gPoint3.isValid() && gPoint4.isValid()) {
            boolean bl = this.isInside(gPoint3);
            boolean bl2 = this.isInside(gPoint4);
            this.parent.pushStyle();
            this.parent.noFill();
            this.parent.stroke(n);
            this.parent.strokeWeight(f);
            this.parent.strokeCap(1);
            if (bl && bl2) {
                this.parent.line(gPoint3.getX(), gPoint3.getY(), gPoint4.getX(), gPoint4.getY());
            } else {
                int n2 = this.obtainBoxIntersections(gPoint3, gPoint4);
                if (bl) {
                    this.parent.line(gPoint3.getX(), gPoint3.getY(), this.cuts[0][0], this.cuts[0][1]);
                } else if (bl2) {
                    this.parent.line(this.cuts[0][0], this.cuts[0][1], gPoint4.getX(), gPoint4.getY());
                } else if (n2 >= 2) {
                    this.parent.line(this.cuts[0][0], this.cuts[0][1], this.cuts[1][0], this.cuts[1][1]);
                }
            }
            this.parent.popStyle();
        }
    }

    public void drawLine(GPoint gPoint, GPoint gPoint2) {
        this.drawLine(gPoint, gPoint2, this.lineColor, this.lineWidth);
    }

    public void drawLine(float f, float f2, int n, float f3) {
        GPoint gPoint;
        GPoint gPoint2;
        if (this.xLog && this.yLog) {
            gPoint2 = new GPoint(this.xLim[0], PApplet.pow((float)10.0f, (float)(f * PApplet.log((float)this.xLim[0]) / GPlot.LOG10 + f2)));
            gPoint = new GPoint(this.xLim[1], PApplet.pow((float)10.0f, (float)(f * PApplet.log((float)this.xLim[1]) / GPlot.LOG10 + f2)));
        } else if (this.xLog) {
            gPoint2 = new GPoint(this.xLim[0], f * PApplet.log((float)this.xLim[0]) / GPlot.LOG10 + f2);
            gPoint = new GPoint(this.xLim[1], f * PApplet.log((float)this.xLim[1]) / GPlot.LOG10 + f2);
        } else if (this.yLog) {
            gPoint2 = new GPoint(this.xLim[0], PApplet.pow((float)10.0f, (float)(f * this.xLim[0] + f2)));
            gPoint = new GPoint(this.xLim[1], PApplet.pow((float)10.0f, (float)(f * this.xLim[1] + f2)));
        } else {
            gPoint2 = new GPoint(this.xLim[0], f * this.xLim[0] + f2);
            gPoint = new GPoint(this.xLim[1], f * this.xLim[1] + f2);
        }
        this.drawLine(gPoint2, gPoint, n, f3);
    }

    public void drawLine(float f, float f2) {
        this.drawLine(f, f2, this.lineColor, this.lineWidth);
    }

    public void drawHorizontalLine(float f, int n, float f2) {
        float f3 = this.valueToYPlot(f);
        if (this.isValidNumber(f3) && -f3 >= 0.0f && -f3 <= this.dim[1]) {
            this.parent.pushStyle();
            this.parent.noFill();
            this.parent.stroke(n);
            this.parent.strokeWeight(f2);
            this.parent.strokeCap(1);
            this.parent.line(0.0f, f3, this.dim[0], f3);
            this.parent.popStyle();
        }
    }

    public void drawHorizontalLine(float f) {
        this.drawHorizontalLine(f, this.lineColor, this.lineWidth);
    }

    public void drawVerticalLine(float f, int n, float f2) {
        float f3 = this.valueToXPlot(f);
        if (this.isValidNumber(f3) && f3 >= 0.0f && f3 <= this.dim[0]) {
            this.parent.pushStyle();
            this.parent.noFill();
            this.parent.stroke(n);
            this.parent.strokeWeight(f2);
            this.parent.strokeCap(1);
            this.parent.line(f3, 0.0f, f3, -this.dim[1]);
            this.parent.popStyle();
        }
    }

    public void drawVerticalLine(float f) {
        this.drawVerticalLine(f, this.lineColor, this.lineWidth);
    }

    public void drawFilledContour(int n, float f) {
        GPointsArray gPointsArray = null;
        if (n == 1) {
            gPointsArray = this.getHorizontalShape(f);
        } else if (n == 0) {
            gPointsArray = this.getVerticalShape(f);
        }
        if (gPointsArray != null && gPointsArray.getNPoints() > 0) {
            this.parent.pushStyle();
            this.parent.fill(this.lineColor);
            this.parent.noStroke();
            this.parent.beginShape();
            for (int i = 0; i < gPointsArray.getNPoints(); ++i) {
                if (!gPointsArray.isValid(i)) continue;
                this.parent.vertex(gPointsArray.getX(i), gPointsArray.getY(i));
            }
            this.parent.endShape(2);
            this.parent.popStyle();
        }
    }

    protected GPointsArray getHorizontalShape(float f) {
        int n;
        int n2;
        int n3 = this.plotPoints.getNPoints();
        GPointsArray gPointsArray = new GPointsArray(2 * n3);
        int n4 = -1;
        int n5 = -1;
        for (int i = 0; i < n3; ++i) {
            if (!this.plotPoints.isValid(i)) continue;
            n2 = 0;
            if (this.inside.get(i).booleanValue()) {
                gPointsArray.add(this.plotPoints.getX(i), this.plotPoints.getY(i), "normal point");
                n2 = 1;
            } else if (this.plotPoints.getX(i) >= 0.0f && this.plotPoints.getX(i) <= this.dim[0]) {
                if (-this.plotPoints.getY(i) < 0.0f) {
                    gPointsArray.add(this.plotPoints.getX(i), 0.0f, "projection");
                    n2 = 1;
                } else {
                    gPointsArray.add(this.plotPoints.getX(i), -this.dim[1], "projection");
                    n2 = 1;
                }
            }
            for (n = i + 1; n < n3 - 1 && !this.plotPoints.isValid(n); ++n) {
            }
            if (n < n3 && this.plotPoints.isValid(n)) {
                int n6 = this.obtainBoxIntersections(this.plotPoints.get(i), this.plotPoints.get(n));
                for (int j = 0; j < n6; ++j) {
                    gPointsArray.add(this.cuts[j][0], this.cuts[j][1], "cut");
                    n2 = 1;
                }
            }
            if (n2 == 0) continue;
            if (n4 < 0) {
                n4 = i;
            }
            n5 = i;
        }
        if (gPointsArray.getNPoints() > 0) {
            float[] fArray;
            GPoint gPoint;
            GPoint gPoint2 = new GPoint(gPointsArray.get(0));
            if (gPoint2.getX() != 0.0f && gPoint2.getX() != this.dim[0]) {
                if (gPoint2.getLabel().equals("cut")) {
                    if (this.plotPoints.getX(n4) < 0.0f) {
                        gPoint2.setX(0.0f);
                        gPoint2.setLabel("extreme");
                    } else {
                        gPoint2.setX(this.dim[0]);
                        gPoint2.setLabel("extreme");
                    }
                } else if (n4 != 0) {
                    for (n2 = n4 - 1; n2 > 0 && !this.plotPoints.isValid(n2); --n2) {
                    }
                    if (this.plotPoints.isValid(n2)) {
                        if (this.plotPoints.getX(n2) < 0.0f) {
                            gPoint2.setX(0.0f);
                            gPoint2.setLabel("extreme");
                        } else {
                            gPoint2.setX(this.dim[0]);
                            gPoint2.setLabel("extreme");
                        }
                    }
                }
            }
            if ((gPoint = new GPoint(gPointsArray.getLastPoint())).getX() != 0.0f && gPoint.getX() != this.dim[0] && n5 != n3 - 1) {
                for (n = n5 + 1; n < n3 - 1 && !this.plotPoints.isValid(n); ++n) {
                }
                if (this.plotPoints.isValid(n)) {
                    if (this.plotPoints.getX(n) < 0.0f) {
                        gPoint.setX(0.0f);
                        gPoint.setLabel("extreme");
                    } else {
                        gPoint.setX(this.dim[0]);
                        gPoint.setLabel("extreme");
                    }
                }
            }
            if (gPoint.getLabel().equals("extreme")) {
                gPointsArray.add(gPoint);
            }
            if (this.yLog && f <= 0.0f) {
                f = Math.min(this.yLim[0], this.yLim[1]);
            }
            if (-(fArray = this.valueToPlot(1.0f, f))[1] < 0.0f) {
                gPointsArray.add(gPoint.getX(), 0.0f);
                gPointsArray.add(gPoint2.getX(), 0.0f);
            } else if (-fArray[1] > this.dim[1]) {
                gPointsArray.add(gPoint.getX(), -this.dim[1]);
                gPointsArray.add(gPoint2.getX(), -this.dim[1]);
            } else {
                gPointsArray.add(gPoint.getX(), fArray[1]);
                gPointsArray.add(gPoint2.getX(), fArray[1]);
            }
            if (gPoint2.getLabel().equals("extreme")) {
                gPointsArray.add(gPoint2);
            }
        }
        return gPointsArray;
    }

    protected GPointsArray getVerticalShape(float f) {
        int n;
        int n2;
        int n3 = this.plotPoints.getNPoints();
        GPointsArray gPointsArray = new GPointsArray(2 * n3);
        int n4 = -1;
        int n5 = -1;
        for (int i = 0; i < n3; ++i) {
            if (!this.plotPoints.isValid(i)) continue;
            n2 = 0;
            if (this.inside.get(i).booleanValue()) {
                gPointsArray.add(this.plotPoints.getX(i), this.plotPoints.getY(i), "normal point");
                n2 = 1;
            } else if (-this.plotPoints.getY(i) >= 0.0f && -this.plotPoints.getY(i) <= this.dim[1]) {
                if (this.plotPoints.getX(i) < 0.0f) {
                    gPointsArray.add(0.0f, this.plotPoints.getY(i), "projection");
                    n2 = 1;
                } else {
                    gPointsArray.add(this.dim[0], this.plotPoints.getY(i), "projection");
                    n2 = 1;
                }
            }
            for (n = i + 1; n < n3 - 1 && !this.plotPoints.isValid(n); ++n) {
            }
            if (n < n3 && this.plotPoints.isValid(n)) {
                int n6 = this.obtainBoxIntersections(this.plotPoints.get(i), this.plotPoints.get(n));
                for (int j = 0; j < n6; ++j) {
                    gPointsArray.add(this.cuts[j][0], this.cuts[j][1], "cut");
                    n2 = 1;
                }
            }
            if (n2 == 0) continue;
            if (n4 < 0) {
                n4 = i;
            }
            n5 = i;
        }
        if (gPointsArray.getNPoints() > 0) {
            float[] fArray;
            GPoint gPoint;
            GPoint gPoint2 = new GPoint(gPointsArray.get(0));
            if (gPoint2.getY() != 0.0f && gPoint2.getY() != -this.dim[1]) {
                if (gPoint2.getLabel().equals("cut")) {
                    if (-this.plotPoints.getY(n4) < 0.0f) {
                        gPoint2.setY(0.0f);
                        gPoint2.setLabel("extreme");
                    } else {
                        gPoint2.setY(-this.dim[1]);
                        gPoint2.setLabel("extreme");
                    }
                } else if (n4 != 0) {
                    for (n2 = n4 - 1; n2 > 0 && !this.plotPoints.isValid(n2); --n2) {
                    }
                    if (this.plotPoints.isValid(n2)) {
                        if (-this.plotPoints.getY(n2) < 0.0f) {
                            gPoint2.setY(0.0f);
                            gPoint2.setLabel("extreme");
                        } else {
                            gPoint2.setY(-this.dim[1]);
                            gPoint2.setLabel("extreme");
                        }
                    }
                }
            }
            if ((gPoint = new GPoint(gPointsArray.getLastPoint())).getY() != 0.0f && gPoint.getY() != -this.dim[1] && n5 != n3 - 1) {
                for (n = n5 + 1; n < n3 - 1 && !this.plotPoints.isValid(n); ++n) {
                }
                if (this.plotPoints.isValid(n)) {
                    if (-this.plotPoints.getY(n) < 0.0f) {
                        gPoint.setY(0.0f);
                        gPoint.setLabel("extreme");
                    } else {
                        gPoint.setY(-this.dim[1]);
                        gPoint.setLabel("extreme");
                    }
                }
            }
            if (gPoint.getLabel().equals("extreme")) {
                gPointsArray.add(gPoint);
            }
            if (this.xLog && f <= 0.0f) {
                f = Math.min(this.xLim[0], this.xLim[1]);
            }
            if ((fArray = this.valueToPlot(f, 1.0f))[0] < 0.0f) {
                gPointsArray.add(0.0f, gPoint.getY());
                gPointsArray.add(0.0f, gPoint2.getY());
            } else if (fArray[0] > this.dim[0]) {
                gPointsArray.add(this.dim[0], gPoint.getY());
                gPointsArray.add(this.dim[0], gPoint2.getY());
            } else {
                gPointsArray.add(fArray[0], gPoint.getY());
                gPointsArray.add(fArray[0], gPoint2.getY());
            }
            if (gPoint2.getLabel().equals("extreme")) {
                gPointsArray.add(gPoint2);
            }
        }
        return gPointsArray;
    }

    public void drawLabel(GPoint gPoint) {
        float f = this.valueToXPlot(gPoint.getX());
        float f2 = this.valueToYPlot(gPoint.getY());
        if (this.isValidNumber(f) && this.isValidNumber(f2)) {
            float f3 = f + this.labelSeparation[0];
            float f4 = f2 - this.labelSeparation[1];
            float f5 = this.fontSize / 4;
            this.parent.pushStyle();
            this.parent.rectMode(0);
            this.parent.textMode(4);
            this.parent.noStroke();
            this.parent.textFont(this.font);
            this.parent.textSize((float)this.fontSize);
            this.parent.textAlign(37, 102);
            this.parent.fill(this.labelBgColor);
            this.parent.rect(f3 - f5, f4 - (float)this.fontSize - f5, this.parent.textWidth(gPoint.getLabel()) + 2.0f * f5, (float)this.fontSize + 2.0f * f5);
            this.parent.fill(this.fontColor);
            this.parent.text(gPoint.getLabel(), f3, f4);
            this.parent.popStyle();
        }
    }

    public void drawLabelAtPlotPos(float f, float f2) {
        GPoint gPoint = this.getPointAtPlotPos(f, f2);
        if (gPoint != null) {
            this.drawLabel(gPoint);
        }
    }

    public void drawHistogram() {
        if (this.hist != null) {
            this.hist.draw(this.valueToPlot(this.histBasePoint));
        }
    }

    public void drawPolygon(GPointsArray gPointsArray, int n) {
        if (gPointsArray.getNPoints() > 2) {
            int n2;
            int n3;
            GPointsArray gPointsArray2 = this.valueToPlot(gPointsArray);
            gPointsArray2.removeInvalidPoints();
            int n4 = gPointsArray2.getNPoints();
            GPointsArray gPointsArray3 = new GPointsArray(2 * n4);
            for (int i = 0; i < n4; ++i) {
                if (this.isInside(gPointsArray2.get(i))) {
                    gPointsArray3.add(gPointsArray2.getX(i), gPointsArray2.getY(i), "normal point");
                }
                n3 = i + 1 < n4 ? i + 1 : 0;
                n2 = this.obtainBoxIntersections(gPointsArray2.get(i), gPointsArray2.get(n3));
                if (n2 == 1) {
                    gPointsArray3.add(this.cuts[0][0], this.cuts[0][1], "single cut");
                    continue;
                }
                if (n2 <= 1) continue;
                gPointsArray3.add(this.cuts[0][0], this.cuts[0][1], "double cut");
                gPointsArray3.add(this.cuts[1][0], this.cuts[1][1], "double cut");
            }
            n4 = gPointsArray3.getNPoints();
            GPointsArray gPointsArray4 = new GPointsArray(2 * n4);
            for (n3 = 0; n3 < n4; ++n3) {
                boolean bl;
                gPointsArray4.add(gPointsArray3.get(n3));
                n2 = n3 + 1 < n4 ? n3 + 1 : 0;
                String string = gPointsArray3.getLabel(n3);
                String string2 = gPointsArray3.getLabel(n2);
                boolean bl2 = bl = string.equals("single cut") && string2.equals("single cut") || string.equals("single cut") && string2.equals("double cut") || string.equals("double cut") && string2.equals("single cut");
                if (!bl) continue;
                float f = gPointsArray3.getX(n3);
                float f2 = gPointsArray3.getY(n3);
                float f3 = gPointsArray3.getX(n2);
                float f4 = gPointsArray3.getY(n2);
                float f5 = Math.abs(f3 - f);
                float f6 = Math.abs(f4 - f2);
                if (!(f5 > 0.0f) || !(f6 > 0.0f) || f5 == this.dim[0] || f6 == this.dim[1]) continue;
                float f7 = f == 0.0f || f == this.dim[0] ? f : f3;
                float f8 = f2 == 0.0f || f2 == -this.dim[1] ? f2 : f4;
                gPointsArray4.add(f7, f8, "special cut");
            }
            if (gPointsArray4.getNPoints() > 2) {
                this.parent.pushStyle();
                this.parent.fill(n);
                this.parent.noStroke();
                this.parent.beginShape();
                for (n3 = 0; n3 < gPointsArray4.getNPoints(); ++n3) {
                    this.parent.vertex(gPointsArray4.getX(n3), gPointsArray4.getY(n3));
                }
                this.parent.endShape(2);
                this.parent.popStyle();
            }
        }
    }

    public void drawAnnotation(String string, float f, float f2, int n, int n2) {
        float f3 = this.valueToXPlot(f);
        float f4 = this.valueToYPlot(f2);
        if (this.isValidNumber(f3) && this.isValidNumber(f4) && this.isInside(f3, f4)) {
            if (n != 3 && n != 39 && n != 37) {
                n = 37;
            }
            if (n2 != 3 && n2 != 101 && n2 != 102) {
                n2 = 3;
            }
            this.parent.pushStyle();
            this.parent.textMode(4);
            this.parent.textFont(this.font);
            this.parent.textSize((float)this.fontSize);
            this.parent.fill(this.fontColor);
            this.parent.textAlign(n, n2);
            this.parent.text(string, f3, f4);
            this.parent.popStyle();
        }
    }

    public void setDim(float f, float f2) {
        if (f > 0.0f && f2 > 0.0f) {
            this.dim[0] = f;
            this.dim[1] = f2;
            this.updatePlotPoints();
            if (this.hist != null) {
                this.hist.setDim(f, f2);
                this.hist.setPlotPoints(this.plotPoints);
            }
        }
    }

    public void setDim(float[] fArray) {
        this.setDim(fArray[0], fArray[1]);
    }

    public void setXLim(float f, float f2) {
        if (f != f2 && this.isValidNumber(f) && this.isValidNumber(f2)) {
            if (this.xLog && (f <= 0.0f || f2 <= 0.0f)) {
                PApplet.println((String)"One of the limits is negative. This is not allowed in logarithmic scale.");
            } else {
                this.xLim[0] = f;
                this.xLim[1] = f2;
                this.updatePlotPoints();
                this.updateInsideList();
                if (this.hist != null) {
                    this.hist.setPlotPoints(this.plotPoints);
                }
            }
        }
    }

    public void setXLim(float[] fArray) {
        this.setXLim(fArray[0], fArray[1]);
    }

    public void setYLim(float f, float f2) {
        if (f != f2 && this.isValidNumber(f) && this.isValidNumber(f2)) {
            if (this.yLog && (f <= 0.0f || f2 <= 0.0f)) {
                PApplet.println((String)"One of the limits is negative. This is not allowed in logarithmic scale.");
            } else {
                this.yLim[0] = f;
                this.yLim[1] = f2;
                this.updatePlotPoints();
                this.updateInsideList();
                if (this.hist != null) {
                    this.hist.setPlotPoints(this.plotPoints);
                }
            }
        }
    }

    public void setYLim(float[] fArray) {
        this.setYLim(fArray[0], fArray[1]);
    }

    public void setXYLim(float f, float f2, float f3, float f4) {
        if (f != f2 && f3 != f4 && this.isValidNumber(f) && this.isValidNumber(f2) && this.isValidNumber(f3) && this.isValidNumber(f4)) {
            if (this.xLog && (f <= 0.0f || f2 <= 0.0f)) {
                PApplet.println((String)"One of the limits is negative. This is not allowed in logarithmic scale.");
            } else {
                this.xLim[0] = f;
                this.xLim[1] = f2;
            }
            if (this.yLog && (f3 <= 0.0f || f4 <= 0.0f)) {
                PApplet.println((String)"One of the limits is negative. This is not allowed in logarithmic scale.");
            } else {
                this.yLim[0] = f3;
                this.yLim[1] = f4;
            }
            this.updatePlotPoints();
            this.updateInsideList();
            if (this.hist != null) {
                this.hist.setPlotPoints(this.plotPoints);
            }
        }
    }

    public void setXYLim(float[] fArray, float[] fArray2) {
        this.setXYLim(fArray[0], fArray[1], fArray2[0], fArray2[1]);
    }

    public void setLimAndLog(float f, float f2, float f3, float f4, boolean bl, boolean bl2) {
        if (f != f2 && f3 != f4 && this.isValidNumber(f) && this.isValidNumber(f2) && this.isValidNumber(f3) && this.isValidNumber(f4)) {
            if (bl && (f <= 0.0f || f2 <= 0.0f)) {
                PApplet.println((String)"One of the limits is negative. This is not allowed in logarithmic scale.");
            } else {
                this.xLim[0] = f;
                this.yLim[1] = f2;
                this.xLog = bl;
            }
            if (bl2 && (f3 <= 0.0f || f4 <= 0.0f)) {
                PApplet.println((String)"One of the limits is negative. This is not allowed in logarithmic scale.");
            } else {
                this.yLim[0] = f3;
                this.yLim[1] = f4;
                this.yLog = bl2;
            }
            this.updatePlotPoints();
            this.updateInsideList();
            if (this.hist != null) {
                this.hist.setPlotPoints(this.plotPoints);
            }
        }
    }

    public void setLimAndLog(float[] fArray, float[] fArray2, boolean bl, boolean bl2) {
        this.setLimAndLog(fArray[0], fArray[1], fArray2[0], fArray2[1], bl, bl2);
    }

    public void setXLog(boolean bl) {
        if (bl != this.xLog) {
            if (bl && (this.xLim[0] <= 0.0f || this.xLim[1] <= 0.0f)) {
                PApplet.println((String)"One of the limits is negative. This is not allowed in logarithmic scale.");
                PApplet.println((String)"Will set horizontal limits to (0.1, 10)");
                this.xLim[0] = 0.1f;
                this.xLim[1] = 10.0f;
            }
            this.xLog = bl;
            this.updatePlotPoints();
            this.updateInsideList();
            if (this.hist != null) {
                this.hist.setPlotPoints(this.plotPoints);
            }
        }
    }

    public void setYLog(boolean bl) {
        if (bl != this.yLog) {
            if (bl && (this.yLim[0] <= 0.0f || this.yLim[1] <= 0.0f)) {
                PApplet.println((String)"One of the limits is negative. This is not allowed in logarithmic scale.");
                PApplet.println((String)"Will set vertical limits to (0.1, 10)");
                this.yLim[0] = 0.1f;
                this.yLim[1] = 10.0f;
            }
            this.yLog = bl;
            this.updatePlotPoints();
            this.updateInsideList();
            if (this.hist != null) {
                this.hist.setPlotPoints(this.plotPoints);
            }
        }
    }

    public void setPoints(GPointsArray gPointsArray) {
        this.points.set(gPointsArray);
        this.updatePlotPoints();
        this.updateInsideList();
        if (this.hist != null) {
            this.hist.setPlotPoints(this.plotPoints);
        }
    }

    public void setPoint(int n, float f, float f2, String string) {
        this.points.set(n, f, f2, string);
        this.plotPoints.set(n, this.valueToXPlot(f), this.valueToYPlot(f2), string);
        this.inside.set(n, this.isInside(this.plotPoints.get(n)));
        if (this.hist != null) {
            this.hist.setPlotPoint(n, this.plotPoints.get(n));
        }
    }

    public void setPoint(int n, float f, float f2) {
        this.setPoint(n, f, f2, this.points.getLabel(n));
    }

    public void setPoint(int n, GPoint gPoint) {
        this.setPoint(n, gPoint.getX(), gPoint.getY(), gPoint.getLabel());
    }

    public void addPoint(float f, float f2, String string) {
        this.points.add(f, f2, string);
        this.plotPoints.add(this.valueToXPlot(f), this.valueToYPlot(f2), string);
        this.inside.add(this.isInside(this.plotPoints.getLastPoint()));
        if (this.hist != null) {
            this.hist.addPlotPoint(this.plotPoints.getLastPoint());
        }
    }

    public void addPoint(float f, float f2) {
        this.addPoint(f, f2, "");
    }

    public void addPoint(GPoint gPoint) {
        this.addPoint(gPoint.getX(), gPoint.getY(), gPoint.getLabel());
    }

    public void addPoint(int n, float f, float f2, String string) {
        this.points.add(n, f, f2, string);
        this.plotPoints.add(n, this.valueToXPlot(f), this.valueToYPlot(f2), string);
        this.inside.add(n, this.isInside(this.plotPoints.getLastPoint()));
        if (this.hist != null) {
            this.hist.addPlotPoint(n, this.plotPoints.getLastPoint());
        }
    }

    public void addPoint(int n, float f, float f2) {
        this.addPoint(n, f, f2, "");
    }

    public void addPoint(int n, GPoint gPoint) {
        this.addPoint(n, gPoint.getX(), gPoint.getY(), gPoint.getLabel());
    }

    public void addPoints(GPointsArray gPointsArray) {
        for (int i = 0; i < gPointsArray.getNPoints(); ++i) {
            this.points.add(gPointsArray.get(i));
            this.plotPoints.add(this.valueToXPlot(gPointsArray.getX(i)), this.valueToYPlot(gPointsArray.getY(i)), gPointsArray.getLabel(i));
            this.inside.add(this.isInside(this.plotPoints.getLastPoint()));
        }
        if (this.hist != null) {
            this.hist.setPlotPoints(this.plotPoints);
        }
    }

    public void removePoint(int n) {
        this.points.remove(n);
        this.plotPoints.remove(n);
        this.inside.remove(n);
        if (this.hist != null) {
            this.hist.removePlotPoint(n);
        }
    }

    public void setInside(boolean[] blArray) {
        if (blArray.length == this.inside.size()) {
            for (int i = 0; i < this.inside.size(); ++i) {
                this.inside.set(i, blArray[i]);
            }
        }
    }

    public void setPointColors(int[] nArray) {
        if (nArray.length > 0) {
            this.pointColors = (int[])nArray.clone();
        }
    }

    public void setPointColor(int n) {
        this.pointColors = new int[]{n};
    }

    public void setPointSizes(float[] fArray) {
        if (fArray.length > 0) {
            this.pointSizes = (float[])fArray.clone();
        }
    }

    public void setPointSize(float f) {
        this.pointSizes = new float[]{f};
    }

    public void setLineColor(int n) {
        this.lineColor = n;
    }

    public void setLineWidth(float f) {
        if (f > 0.0f) {
            this.lineWidth = f;
        }
    }

    public void setHistBasePoint(GPoint gPoint) {
        this.histBasePoint.set(gPoint);
    }

    public void setHistType(int n) {
        if (this.hist != null) {
            this.hist.setType(n);
        }
    }

    public void setHistVisible(boolean bl) {
        if (this.hist != null) {
            this.hist.setVisible(bl);
        }
    }

    public void setDrawHistLabels(boolean bl) {
        if (this.hist != null) {
            this.hist.setDrawLabels(bl);
        }
    }

    public void setLabelBgColor(int n) {
        this.labelBgColor = n;
    }

    public void setLabelSeparation(float[] fArray) {
        this.labelSeparation[0] = fArray[0];
        this.labelSeparation[1] = fArray[1];
    }

    public void setFontName(String string) {
        this.fontName = string;
        this.font = this.parent.createFont(this.fontName, (float)this.fontSize);
    }

    public void setFontColor(int n) {
        this.fontColor = n;
    }

    public void setFontSize(int n) {
        if (n > 0) {
            this.fontSize = n;
            this.font = this.parent.createFont(this.fontName, (float)this.fontSize);
        }
    }

    public void setFontProperties(String string, int n, int n2) {
        if (n2 > 0) {
            this.fontName = string;
            this.fontColor = n;
            this.fontSize = n2;
            this.font = this.parent.createFont(this.fontName, (float)this.fontSize);
        }
    }

    public void setAllFontProperties(String string, int n, int n2) {
        this.setFontProperties(string, n, n2);
        if (this.hist != null) {
            this.hist.setFontProperties(string, n, n2);
        }
    }

    public String getId() {
        return this.id;
    }

    public float[] getDim() {
        return (float[])this.dim.clone();
    }

    public float[] getXLim() {
        return (float[])this.xLim.clone();
    }

    public float[] getYLim() {
        return (float[])this.yLim.clone();
    }

    public boolean getXLog() {
        return this.xLog;
    }

    public boolean getYLog() {
        return this.yLog;
    }

    public GPointsArray getPoints() {
        return new GPointsArray(this.points);
    }

    public GPointsArray getPointsRef() {
        return this.points;
    }

    public int[] getPointColors() {
        return (int[])this.pointColors.clone();
    }

    public float[] getPointSizes() {
        return (float[])this.pointSizes.clone();
    }

    public int getLineColor() {
        return this.lineColor;
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public GHistogram getHistogram() {
        return this.hist;
    }
}

