/*
 * Decompiled with CFR 0.152.
 */
package grafica;

import grafica.GAxisLabel;
import grafica.GPlot;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PFont;

public class GAxis
implements PConstants {
    protected final PApplet parent;
    protected final int type;
    protected float[] dim;
    protected float[] lim;
    protected boolean log;
    protected float offset;
    protected int lineColor;
    protected float lineWidth;
    protected int nTicks;
    protected float ticksSeparation;
    protected ArrayList<Float> ticks;
    protected ArrayList<Float> plotTicks;
    protected ArrayList<Boolean> ticksInside;
    protected ArrayList<String> tickLabels;
    protected boolean fixedTicks;
    protected float tickLength;
    protected float smallTickLength;
    protected boolean expTickLabels;
    protected boolean rotateTickLabels;
    protected boolean drawTickLabels;
    protected float tickLabelOffset;
    protected final GAxisLabel lab;
    protected boolean drawAxisLabel;
    protected String fontName;
    protected int fontColor;
    protected int fontSize;
    protected PFont font;

    public GAxis(PApplet pApplet, int n, float[] fArray, float[] fArray2, boolean bl) {
        this.parent = pApplet;
        this.type = n == 0 || n == 1 || n == 101 || n == 39 ? n : 0;
        this.dim = (float[])fArray.clone();
        this.lim = (float[])fArray2.clone();
        this.log = bl;
        if (this.log && (this.lim[0] <= 0.0f || this.lim[1] <= 0.0f)) {
            PApplet.println((String)"The limits are negative. This is not allowed in logarithmic scale.");
            PApplet.println((String)"Will set them to (0.1, 10)");
            if (this.lim[1] > this.lim[0]) {
                this.lim[0] = 0.1f;
                this.lim[1] = 10.0f;
            } else {
                this.lim[0] = 10.0f;
                this.lim[1] = 0.1f;
            }
        }
        this.offset = 5.0f;
        this.lineColor = this.parent.color(0);
        this.lineWidth = 1.0f;
        this.nTicks = 5;
        this.ticksSeparation = -1.0f;
        this.ticks = new ArrayList(this.nTicks);
        this.plotTicks = new ArrayList(this.nTicks);
        this.ticksInside = new ArrayList(this.nTicks);
        this.tickLabels = new ArrayList(this.nTicks);
        this.fixedTicks = false;
        this.tickLength = 3.0f;
        this.smallTickLength = 2.0f;
        this.expTickLabels = false;
        this.rotateTickLabels = this.type != 0 && this.type != 101;
        this.drawTickLabels = this.type == 0 || this.type == 1;
        this.tickLabelOffset = 7.0f;
        this.lab = new GAxisLabel(this.parent, this.type, this.dim);
        this.drawAxisLabel = true;
        this.fontName = "SansSerif.plain";
        this.fontColor = this.parent.color(0);
        this.fontSize = 11;
        this.font = this.parent.createFont(this.fontName, (float)this.fontSize);
        this.updateTicks();
        this.updatePlotTicks();
        this.updateTicksInside();
        this.updateTickLabels();
    }

    protected int obtainSigDigits(float f) {
        return Math.round(-PApplet.log((float)(0.5f * Math.abs(f))) / GPlot.LOG10);
    }

    protected float roundPlus(float f, int n) {
        return BigDecimal.valueOf(f).setScale(n, 4).floatValue();
    }

    protected void adaptSize(ArrayList<?> arrayList, int n) {
        if (n > arrayList.size()) {
            for (int i = arrayList.size(); i < n; ++i) {
                arrayList.add(null);
            }
        } else if (n < arrayList.size()) {
            arrayList.subList(n, arrayList.size()).clear();
        }
    }

    protected void updateTicks() {
        if (this.log) {
            this.obtainLogarithmicTicks();
        } else {
            this.obtainLinearTicks();
        }
    }

    protected void obtainLogarithmicTicks() {
        int n;
        int n2;
        if (this.lim[1] > this.lim[0]) {
            n2 = PApplet.floor((float)(PApplet.log((float)this.lim[0]) / GPlot.LOG10));
            n = PApplet.ceil((float)(PApplet.log((float)this.lim[1]) / GPlot.LOG10));
        } else {
            n2 = PApplet.floor((float)(PApplet.log((float)this.lim[1]) / GPlot.LOG10));
            n = PApplet.ceil((float)(PApplet.log((float)this.lim[0]) / GPlot.LOG10));
        }
        int n3 = (n - n2) * 9 + 1;
        this.adaptSize(this.ticks, n3);
        for (int i = n2; i < n; ++i) {
            float f = this.roundPlus(PApplet.exp((float)((float)i * GPlot.LOG10)), -i);
            for (int j = 0; j < 9; ++j) {
                this.ticks.set((i - n2) * 9 + j, Float.valueOf((float)(j + 1) * f));
            }
        }
        this.ticks.set(this.ticks.size() - 1, Float.valueOf(this.roundPlus(PApplet.exp((float)((float)n * GPlot.LOG10)), -n)));
    }

    protected void obtainLinearTicks() {
        float f = 0.0f;
        int n = 0;
        int n2 = 0;
        if (this.ticksSeparation > 0.0f) {
            f = this.lim[1] > this.lim[0] ? this.ticksSeparation : -this.ticksSeparation;
            n = this.obtainSigDigits(f);
            while (this.roundPlus(f, n) - f != 0.0f) {
                ++n;
            }
            n2 = PApplet.floor((float)((this.lim[1] - this.lim[0]) / f));
        } else if (this.nTicks > 0) {
            f = (this.lim[1] - this.lim[0]) / (float)this.nTicks;
            n = this.obtainSigDigits(f);
            if ((f = this.roundPlus(f, n)) == 0.0f || Math.abs(f) > Math.abs(this.lim[1] - this.lim[0])) {
                f = this.roundPlus((this.lim[1] - this.lim[0]) / (float)this.nTicks, ++n);
            }
            n2 = PApplet.floor((float)((this.lim[1] - this.lim[0]) / f));
        }
        if (n2 > 0) {
            float f2 = this.lim[0] + (this.lim[1] - this.lim[0] - (float)n2 * f) / 2.0f;
            f2 = this.roundPlus(f2 - 2.0f * f, n);
            while ((this.lim[1] - f2) * (this.lim[0] - f2) > 0.0f) {
                f2 = this.roundPlus(f2 + f, n);
            }
            int n3 = PApplet.floor((float)Math.abs((this.lim[1] - f2) / f)) + 1;
            this.adaptSize(this.ticks, n3);
            this.ticks.set(0, Float.valueOf(f2));
            for (int i = 1; i < n3; ++i) {
                this.ticks.set(i, Float.valueOf(this.roundPlus(this.ticks.get(i - 1).floatValue() + f, n)));
            }
        } else {
            this.ticks.clear();
        }
    }

    protected void updatePlotTicks() {
        int n = this.ticks.size();
        this.adaptSize(this.plotTicks, n);
        if (this.log) {
            float f = this.type == 0 || this.type == 101 ? this.dim[0] / PApplet.log((float)(this.lim[1] / this.lim[0])) : -this.dim[1] / PApplet.log((float)(this.lim[1] / this.lim[0]));
            for (int i = 0; i < n; ++i) {
                this.plotTicks.set(i, Float.valueOf(PApplet.log((float)(this.ticks.get(i).floatValue() / this.lim[0])) * f));
            }
        } else {
            float f = this.type == 0 || this.type == 101 ? this.dim[0] / (this.lim[1] - this.lim[0]) : -this.dim[1] / (this.lim[1] - this.lim[0]);
            for (int i = 0; i < n; ++i) {
                this.plotTicks.set(i, Float.valueOf((this.ticks.get(i).floatValue() - this.lim[0]) * f));
            }
        }
    }

    protected void updateTicksInside() {
        int n = this.ticks.size();
        this.adaptSize(this.ticksInside, n);
        if (this.type == 0 || this.type == 101) {
            for (int i = 0; i < n; ++i) {
                this.ticksInside.set(i, this.plotTicks.get(i).floatValue() >= 0.0f && this.plotTicks.get(i).floatValue() <= this.dim[0]);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                this.ticksInside.set(i, -this.plotTicks.get(i).floatValue() >= 0.0f && -this.plotTicks.get(i).floatValue() <= this.dim[1]);
            }
        }
    }

    protected void updateTickLabels() {
        int n = this.ticks.size();
        this.adaptSize(this.tickLabels, n);
        if (this.log) {
            for (int i = 0; i < n; ++i) {
                float f = this.ticks.get(i).floatValue();
                if (f > 0.0f) {
                    boolean bl;
                    float f2 = PApplet.log((float)f) / GPlot.LOG10;
                    boolean bl2 = bl = (double)Math.abs(f2 - (float)Math.round(f2)) < 1.0E-4;
                    if (bl) {
                        f2 = Math.round(f2);
                        if (this.expTickLabels) {
                            this.tickLabels.set(i, "1e" + (int)f2);
                            continue;
                        }
                        if ((double)f2 > -3.1 && (double)f2 < 3.1) {
                            this.tickLabels.set(i, f2 >= 0.0f ? PApplet.str((int)((int)f)) : PApplet.str((float)f));
                            continue;
                        }
                        this.tickLabels.set(i, "1e" + (int)f2);
                        continue;
                    }
                    this.tickLabels.set(i, "");
                    continue;
                }
                this.tickLabels.set(i, "");
            }
        } else {
            for (int i = 0; i < n; ++i) {
                float f = this.ticks.get(i).floatValue();
                this.tickLabels.set(i, f % 1.0f == 0.0f && (double)Math.abs(f) < 1.0E9 ? PApplet.str((int)((int)f)) : PApplet.str((float)f));
            }
        }
    }

    protected float[] removeOutsideTicks() {
        float[] fArray = new float[this.ticksInside.size()];
        int n = 0;
        for (int i = 0; i < this.ticksInside.size(); ++i) {
            if (!this.ticksInside.get(i).booleanValue()) continue;
            fArray[n] = this.ticks.get(i).floatValue();
            ++n;
        }
        return Arrays.copyOf(fArray, n);
    }

    protected float[] removeOutsidePlotTicks() {
        float[] fArray = new float[this.ticksInside.size()];
        int n = 0;
        for (int i = 0; i < this.ticksInside.size(); ++i) {
            if (!this.ticksInside.get(i).booleanValue()) continue;
            fArray[n] = this.plotTicks.get(i).floatValue();
            ++n;
        }
        return Arrays.copyOf(fArray, n);
    }

    public void moveLim(float[] fArray) {
        if (fArray[1] != fArray[0]) {
            if (this.log && (fArray[0] <= 0.0f || fArray[1] <= 0.0f)) {
                PApplet.println((String)"The limits are negative. This is not allowed in logarithmic scale.");
            } else {
                this.lim[0] = fArray[0];
                this.lim[1] = fArray[1];
                if (!this.fixedTicks) {
                    int n = this.ticks.size();
                    if (this.log) {
                        this.obtainLogarithmicTicks();
                    } else if (n > 0) {
                        float f = 0.0f;
                        int n2 = 0;
                        if (this.ticksSeparation > 0.0f) {
                            f = this.lim[1] > this.lim[0] ? this.ticksSeparation : -this.ticksSeparation;
                            n2 = this.obtainSigDigits(f);
                            while (this.roundPlus(f, n2) - f != 0.0f) {
                                ++n2;
                            }
                        } else {
                            f = n == 1 ? this.lim[1] - this.lim[0] : this.ticks.get(1).floatValue() - this.ticks.get(0).floatValue();
                            n2 = this.obtainSigDigits(f);
                            if ((f = this.roundPlus(f, n2)) == 0.0f || Math.abs(f) > Math.abs(this.lim[1] - this.lim[0])) {
                                f = n == 1 ? this.lim[1] - this.lim[0] : this.ticks.get(1).floatValue() - this.ticks.get(0).floatValue();
                                f = this.roundPlus(f, ++n2);
                            }
                            f = this.lim[1] > this.lim[0] ? Math.abs(f) : -Math.abs(f);
                        }
                        float f2 = this.ticks.get(0).floatValue() + f * (float)PApplet.ceil((float)((this.lim[0] - this.ticks.get(0).floatValue()) / f));
                        if ((this.lim[1] - (f2 = this.roundPlus(f2, n2))) * (this.lim[0] - f2) > 0.0f) {
                            f2 = this.ticks.get(0).floatValue() + f * (float)PApplet.floor((float)((this.lim[0] - this.ticks.get(0).floatValue()) / f));
                            f2 = this.roundPlus(f2, n2);
                        }
                        n = PApplet.floor((float)Math.abs((this.lim[1] - f2) / f)) + 1;
                        this.adaptSize(this.ticks, n);
                        this.ticks.set(0, Float.valueOf(f2));
                        for (int i = 1; i < n; ++i) {
                            this.ticks.set(i, Float.valueOf(this.roundPlus(this.ticks.get(i - 1).floatValue() + f, n2)));
                        }
                    }
                    this.updateTickLabels();
                }
                this.updatePlotTicks();
                this.updateTicksInside();
            }
        }
    }

    public void draw() {
        switch (this.type) {
            case 0: {
                this.drawAsXAxis();
                break;
            }
            case 1: {
                this.drawAsYAxis();
                break;
            }
            case 101: {
                this.drawAsTopAxis();
                break;
            }
            case 39: {
                this.drawAsRightAxis();
            }
        }
        if (this.drawAxisLabel) {
            this.lab.draw();
        }
    }

    protected void drawAsXAxis() {
        int n;
        this.parent.pushStyle();
        this.parent.textMode(4);
        this.parent.textFont(this.font);
        this.parent.textSize((float)this.fontSize);
        this.parent.fill(this.fontColor);
        this.parent.stroke(this.lineColor);
        this.parent.strokeWeight(this.lineWidth);
        this.parent.strokeCap(1);
        this.parent.line(0.0f, this.offset, this.dim[0], this.offset);
        for (n = 0; n < this.plotTicks.size(); ++n) {
            if (!this.ticksInside.get(n).booleanValue()) continue;
            if (this.log && this.tickLabels.get(n).equals("")) {
                this.parent.line(this.plotTicks.get(n).floatValue(), this.offset, this.plotTicks.get(n).floatValue(), this.offset + this.smallTickLength);
                continue;
            }
            this.parent.line(this.plotTicks.get(n).floatValue(), this.offset, this.plotTicks.get(n).floatValue(), this.offset + this.tickLength);
        }
        if (this.drawTickLabels) {
            if (this.rotateTickLabels) {
                this.parent.textAlign(39, 3);
                for (n = 0; n < this.plotTicks.size(); ++n) {
                    if (!this.ticksInside.get(n).booleanValue() || this.tickLabels.get(n).equals("")) continue;
                    this.parent.pushMatrix();
                    this.parent.translate(this.plotTicks.get(n).floatValue(), this.offset + this.tickLabelOffset);
                    this.parent.rotate(-1.5707964f);
                    this.parent.text(this.tickLabels.get(n), 0.0f, 0.0f);
                    this.parent.popMatrix();
                }
            } else {
                this.parent.textAlign(3, 101);
                for (n = 0; n < this.plotTicks.size(); ++n) {
                    if (!this.ticksInside.get(n).booleanValue() || this.tickLabels.get(n).equals("")) continue;
                    this.parent.text(this.tickLabels.get(n), this.plotTicks.get(n).floatValue(), this.offset + this.tickLabelOffset);
                }
            }
        }
        this.parent.popStyle();
    }

    protected void drawAsYAxis() {
        int n;
        this.parent.pushStyle();
        this.parent.textMode(4);
        this.parent.textFont(this.font);
        this.parent.textSize((float)this.fontSize);
        this.parent.fill(this.fontColor);
        this.parent.stroke(this.lineColor);
        this.parent.strokeWeight(this.lineWidth);
        this.parent.strokeCap(1);
        this.parent.line(-this.offset, 0.0f, -this.offset, -this.dim[1]);
        for (n = 0; n < this.plotTicks.size(); ++n) {
            if (!this.ticksInside.get(n).booleanValue()) continue;
            if (this.log && this.tickLabels.get(n).equals("")) {
                this.parent.line(-this.offset, this.plotTicks.get(n).floatValue(), -this.offset - this.smallTickLength, this.plotTicks.get(n).floatValue());
                continue;
            }
            this.parent.line(-this.offset, this.plotTicks.get(n).floatValue(), -this.offset - this.tickLength, this.plotTicks.get(n).floatValue());
        }
        if (this.drawTickLabels) {
            if (this.rotateTickLabels) {
                this.parent.textAlign(3, 102);
                for (n = 0; n < this.plotTicks.size(); ++n) {
                    if (!this.ticksInside.get(n).booleanValue() || this.tickLabels.get(n).equals("")) continue;
                    this.parent.pushMatrix();
                    this.parent.translate(-this.offset - this.tickLabelOffset, this.plotTicks.get(n).floatValue());
                    this.parent.rotate(-1.5707964f);
                    this.parent.text(this.tickLabels.get(n), 0.0f, 0.0f);
                    this.parent.popMatrix();
                }
            } else {
                this.parent.textAlign(39, 3);
                for (n = 0; n < this.plotTicks.size(); ++n) {
                    if (!this.ticksInside.get(n).booleanValue() || this.tickLabels.get(n).equals("")) continue;
                    this.parent.text(this.tickLabels.get(n), -this.offset - this.tickLabelOffset, this.plotTicks.get(n).floatValue());
                }
            }
        }
        this.parent.popStyle();
    }

    protected void drawAsTopAxis() {
        int n;
        this.parent.pushStyle();
        this.parent.textMode(4);
        this.parent.textFont(this.font);
        this.parent.textSize((float)this.fontSize);
        this.parent.fill(this.fontColor);
        this.parent.stroke(this.lineColor);
        this.parent.strokeWeight(this.lineWidth);
        this.parent.strokeCap(1);
        this.parent.pushMatrix();
        this.parent.translate(0.0f, -this.dim[1]);
        this.parent.line(0.0f, -this.offset, this.dim[0], -this.offset);
        for (n = 0; n < this.plotTicks.size(); ++n) {
            if (!this.ticksInside.get(n).booleanValue()) continue;
            if (this.log && this.tickLabels.get(n).equals("")) {
                this.parent.line(this.plotTicks.get(n).floatValue(), -this.offset, this.plotTicks.get(n).floatValue(), -this.offset - this.smallTickLength);
                continue;
            }
            this.parent.line(this.plotTicks.get(n).floatValue(), -this.offset, this.plotTicks.get(n).floatValue(), -this.offset - this.tickLength);
        }
        if (this.drawTickLabels) {
            if (this.rotateTickLabels) {
                this.parent.textAlign(37, 3);
                for (n = 0; n < this.plotTicks.size(); ++n) {
                    if (!this.ticksInside.get(n).booleanValue() || this.tickLabels.get(n).equals("")) continue;
                    this.parent.pushMatrix();
                    this.parent.translate(this.plotTicks.get(n).floatValue(), -this.offset - this.tickLabelOffset);
                    this.parent.rotate(-1.5707964f);
                    this.parent.text(this.tickLabels.get(n), 0.0f, 0.0f);
                    this.parent.popMatrix();
                }
            } else {
                this.parent.textAlign(3, 102);
                for (n = 0; n < this.plotTicks.size(); ++n) {
                    if (!this.ticksInside.get(n).booleanValue() || this.tickLabels.get(n).equals("")) continue;
                    this.parent.text(this.tickLabels.get(n), this.plotTicks.get(n).floatValue(), -this.offset - this.tickLabelOffset);
                }
            }
        }
        this.parent.popMatrix();
        this.parent.popStyle();
    }

    protected void drawAsRightAxis() {
        int n;
        this.parent.pushStyle();
        this.parent.textMode(4);
        this.parent.textFont(this.font);
        this.parent.textSize((float)this.fontSize);
        this.parent.fill(this.fontColor);
        this.parent.stroke(this.lineColor);
        this.parent.strokeWeight(this.lineWidth);
        this.parent.strokeCap(1);
        this.parent.pushMatrix();
        this.parent.translate(this.dim[0], 0.0f);
        this.parent.line(this.offset, 0.0f, this.offset, -this.dim[1]);
        for (n = 0; n < this.plotTicks.size(); ++n) {
            if (!this.ticksInside.get(n).booleanValue()) continue;
            if (this.log && this.tickLabels.get(n).equals("")) {
                this.parent.line(this.offset, this.plotTicks.get(n).floatValue(), this.offset + this.smallTickLength, this.plotTicks.get(n).floatValue());
                continue;
            }
            this.parent.line(this.offset, this.plotTicks.get(n).floatValue(), this.offset + this.tickLength, this.plotTicks.get(n).floatValue());
        }
        if (this.drawTickLabels) {
            if (this.rotateTickLabels) {
                this.parent.textAlign(3, 101);
                for (n = 0; n < this.plotTicks.size(); ++n) {
                    if (!this.ticksInside.get(n).booleanValue() || this.tickLabels.get(n).equals("")) continue;
                    this.parent.pushMatrix();
                    this.parent.translate(this.offset + this.tickLabelOffset, this.plotTicks.get(n).floatValue());
                    this.parent.rotate(-1.5707964f);
                    this.parent.text(this.tickLabels.get(n), 0.0f, 0.0f);
                    this.parent.popMatrix();
                }
            } else {
                this.parent.textAlign(37, 3);
                for (n = 0; n < this.plotTicks.size(); ++n) {
                    if (!this.ticksInside.get(n).booleanValue() || this.tickLabels.get(n).equals("")) continue;
                    this.parent.text(this.tickLabels.get(n), this.offset + this.tickLabelOffset, this.plotTicks.get(n).floatValue());
                }
            }
        }
        this.parent.popMatrix();
        this.parent.popStyle();
    }

    public void setDim(float f, float f2) {
        if (f > 0.0f && f2 > 0.0f) {
            this.dim[0] = f;
            this.dim[1] = f2;
            this.updatePlotTicks();
            this.lab.setDim(this.dim);
        }
    }

    public void setDim(float[] fArray) {
        this.setDim(fArray[0], fArray[1]);
    }

    public void setLim(float[] fArray) {
        if (fArray[1] != fArray[0]) {
            if (this.log && (fArray[0] <= 0.0f || fArray[1] <= 0.0f)) {
                PApplet.println((String)"One of the limits is negative. This is not allowed in logarithmic scale.");
            } else {
                this.lim[0] = fArray[0];
                this.lim[1] = fArray[1];
                if (!this.fixedTicks) {
                    this.updateTicks();
                    this.updateTickLabels();
                }
                this.updatePlotTicks();
                this.updateTicksInside();
            }
        }
    }

    public void setLimAndLog(float[] fArray, boolean bl) {
        if (fArray[1] != fArray[0]) {
            if (bl && (fArray[0] <= 0.0f || fArray[1] <= 0.0f)) {
                PApplet.println((String)"One of the limits is negative. This is not allowed in logarithmic scale.");
            } else {
                this.lim[0] = fArray[0];
                this.lim[1] = fArray[1];
                this.log = bl;
                if (!this.fixedTicks) {
                    this.updateTicks();
                    this.updateTickLabels();
                }
                this.updatePlotTicks();
                this.updateTicksInside();
            }
        }
    }

    public void setLog(boolean bl) {
        if (bl != this.log) {
            this.log = bl;
            if (this.log && (this.lim[0] <= 0.0f || this.lim[1] <= 0.0f)) {
                PApplet.println((String)"The limits are negative. This is not allowed in logarithmic scale.");
                PApplet.println((String)"Will set them to (0.1, 10)");
                if (this.lim[1] > this.lim[0]) {
                    this.lim[0] = 0.1f;
                    this.lim[1] = 10.0f;
                } else {
                    this.lim[0] = 10.0f;
                    this.lim[1] = 0.1f;
                }
            }
            if (!this.fixedTicks) {
                this.updateTicks();
                this.updateTickLabels();
            }
            this.updatePlotTicks();
            this.updateTicksInside();
        }
    }

    public void setOffset(float f) {
        this.offset = f;
    }

    public void setLineColor(int n) {
        this.lineColor = n;
    }

    public void setLineWidth(float f) {
        if (f > 0.0f) {
            this.lineWidth = f;
        }
    }

    public void setNTicks(int n) {
        if (n >= 0) {
            this.nTicks = n;
            this.ticksSeparation = -1.0f;
            if (!this.log) {
                this.fixedTicks = false;
                this.updateTicks();
                this.updatePlotTicks();
                this.updateTicksInside();
                this.updateTickLabels();
            }
        }
    }

    public void setTicksSeparation(float f) {
        this.ticksSeparation = f;
        if (!this.log) {
            this.fixedTicks = false;
            this.updateTicks();
            this.updatePlotTicks();
            this.updateTicksInside();
            this.updateTickLabels();
        }
    }

    public void setTicks(float[] fArray) {
        this.fixedTicks = true;
        int n = fArray.length;
        this.adaptSize(this.ticks, n);
        for (int i = 0; i < n; ++i) {
            this.ticks.set(i, Float.valueOf(fArray[i]));
        }
        this.updatePlotTicks();
        this.updateTicksInside();
        this.updateTickLabels();
    }

    public void setTickLabels(String[] stringArray) {
        if (stringArray.length == this.tickLabels.size()) {
            this.fixedTicks = true;
            for (int i = 0; i < this.tickLabels.size(); ++i) {
                this.tickLabels.set(i, stringArray[i]);
            }
        }
    }

    public void setFixedTicks(boolean bl) {
        if (bl != this.fixedTicks) {
            this.fixedTicks = bl;
            if (!this.fixedTicks) {
                this.updateTicks();
                this.updatePlotTicks();
                this.updateTicksInside();
                this.updateTickLabels();
            }
        }
    }

    public void setTickLength(float f) {
        this.tickLength = f;
    }

    public void setSmallTickLength(float f) {
        this.smallTickLength = f;
    }

    public void setExpTickLabels(boolean bl) {
        if (bl != this.expTickLabels) {
            this.expTickLabels = bl;
            this.updateTickLabels();
        }
    }

    public void setRotateTickLabels(boolean bl) {
        this.rotateTickLabels = bl;
    }

    public void setDrawTickLabels(boolean bl) {
        this.drawTickLabels = bl;
    }

    public void setTickLabelOffset(float f) {
        this.tickLabelOffset = f;
    }

    public void setDrawAxisLabel(boolean bl) {
        this.drawAxisLabel = bl;
    }

    public void setAxisLabelText(String string) {
        this.lab.setText(string);
    }

    public void setFontName(String string) {
        this.fontName = string;
        this.font = this.parent.createFont(this.fontName, (float)this.fontSize);
    }

    public void setFontColor(int n) {
        this.fontColor = n;
    }

    public void setFontSize(int n) {
        if (n > 0) {
            this.fontSize = n;
            this.font = this.parent.createFont(this.fontName, (float)this.fontSize);
        }
    }

    public void setFontProperties(String string, int n, int n2) {
        if (n2 > 0) {
            this.fontName = string;
            this.fontColor = n;
            this.fontSize = n2;
            this.font = this.parent.createFont(this.fontName, (float)this.fontSize);
        }
    }

    public void setAllFontProperties(String string, int n, int n2) {
        this.setFontProperties(string, n, n2);
        this.lab.setFontProperties(string, n, n2);
    }

    public float[] getTicks() {
        if (this.fixedTicks) {
            float[] fArray = new float[this.ticks.size()];
            for (int i = 0; i < this.ticks.size(); ++i) {
                fArray[i] = this.ticks.get(i).floatValue();
            }
            return fArray;
        }
        return this.removeOutsideTicks();
    }

    public ArrayList<Float> getTicksRef() {
        return this.ticks;
    }

    public float[] getPlotTicks() {
        if (this.fixedTicks) {
            float[] fArray = new float[this.plotTicks.size()];
            for (int i = 0; i < this.plotTicks.size(); ++i) {
                fArray[i] = this.plotTicks.get(i).floatValue();
            }
            return fArray;
        }
        return this.removeOutsidePlotTicks();
    }

    public ArrayList<Float> getPlotTicksRef() {
        return this.plotTicks;
    }

    public GAxisLabel getAxisLabel() {
        return this.lab;
    }
}

