/*
 * Decompiled with CFR 0.152.
 */
import com.jogamp.nativewindow.util.Point;
import com.jogamp.newt.opengl.GLWindow;
import controlP5.CColor;
import controlP5.CallbackEvent;
import controlP5.CallbackListener;
import controlP5.CheckBox;
import controlP5.ControlEvent;
import controlP5.ControlP5;
import controlP5.Controller;
import controlP5.ControllerInterface;
import controlP5.ControllerView;
import controlP5.RadioButton;
import controlP5.ScrollableList;
import controlP5.Textfield;
import ddf.minim.analysis.FFT;
import edu.ucsd.sccn.LSL;
import gifAnimation.Gif;
import grafica.GPlot;
import grafica.GPoint;
import grafica.GPointsArray;
import hypermedia.net.UDP;
import java.awt.AWTException;
import java.awt.Desktop;
import java.awt.Frame;
import java.awt.MouseInfo;
import java.awt.Robot;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.nio.ByteBuffer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import netP5.NetAddress;
import oscP5.OscMessage;
import oscP5.OscP5;
import oscP5.OscPacket;
import processing.awt.PSurfaceAWT;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PVector;
import processing.data.Table;
import processing.data.TableRow;
import processing.net.Client;
import processing.serial.Serial;

public class OpenBCI_GUI
extends PApplet {
    final int SYSTEMMODE_INTROANIMATION = -10;
    final int SYSTEMMODE_PREINIT = 0;
    final int SYSTEMMODE_MIDINIT = 5;
    final int SYSTEMMODE_POSTINIT = 10;
    int systemMode = -10;
    boolean midInit = false;
    boolean abandonInit = false;
    final int NCHAN_CYTON = 8;
    final int NCHAN_CYTON_DAISY = 16;
    final int NCHAN_GANGLION = 4;
    boolean hasIntroAnimation = true;
    PImage cog;
    Gif loadingGIF;
    Gif loadingGIF_blue;
    boolean initSystemThreadLock = false;
    UDP udpRX;
    final int DATASOURCE_CYTON = 0;
    final int DATASOURCE_GANGLION = 1;
    final int DATASOURCE_PLAYBACKFILE = 2;
    final int DATASOURCE_SYNTHETIC = 3;
    public int eegDataSource = -1;
    final int INTERFACE_NONE = -1;
    final int INTERFACE_SERIAL = 0;
    final int INTERFACE_HUB_BLE = 1;
    final int INTERFACE_HUB_WIFI = 2;
    final int INTERFACE_HUB_BLED112 = 3;
    String playbackData_fname = "N/A";
    float playback_speed_fac = 1.0f;
    int currentTableRowIndex = 0;
    Table_CSV playbackData_table;
    int nextPlayback_millis = -100;
    Cyton cyton = new Cyton();
    Ganglion ganglion = new Ganglion();
    InterfaceSerial iSerial = new InterfaceSerial();
    Hub hub = new Hub();
    String openBCI_portName = "N/A";
    int openBCI_baud = 115200;
    String ganglion_portName = "N/A";
    String wifi_portName = "N/A";
    String wifi_ipAddress = "192.168.4.1";
    static final String PROTOCOL_BLE = "ble";
    static final String PROTOCOL_BLED112 = "bled112";
    static final String PROTOCOL_SERIAL = "serial";
    static final String PROTOCOL_WIFI = "wifi";
    int nchan = 8;
    int n_aux_ifEnabled = 3;
    DataStatus[] is_railed;
    final int threshold_railed = PApplet.parseInt((float)(OpenBCI_GUI.pow((float)2.0f, (float)23.0f) - 1000.0f));
    final int threshold_railed_warn = PApplet.parseInt((float)(OpenBCI_GUI.pow((float)2.0f, (float)23.0f) * 0.9f));
    int sdSetting = 0;
    String sdSettingString = "Do not write to SD";
    int nDataBackBuff;
    DataPacket_ADS1299[] dataPacketBuff;
    int curDataPacketInd = -1;
    int curBDFDataPacketInd = -1;
    int lastReadDataPacketInd = -1;
    boolean currentlySyncing = false;
    long timeOfLastCommand = 0L;
    long timeOfLastFrame = 0L;
    int newPacketCounter = 0;
    long timeOfInit;
    long timeSinceStopRunning = 1000L;
    int prev_time_millis = 0;
    final int update_millis = 40;
    int nPointsPerUpdate;
    float[] dataBuffX;
    float[][] dataBuffY_uV;
    float[][] dataBuffY_filtY_uV;
    float[] yLittleBuff;
    float[][] yLittleBuff_uV;
    float[][] accelerometerBuff;
    float[][] auxBuff;
    float[] data_elec_imp_ohm;
    float displayTime_sec = 5.0f;
    float dataBuff_len_sec = this.displayTime_sec + 3.0f;
    OutputFile_rawtxt fileoutput_odf;
    OutputFile_BDF fileoutput_bdf;
    String output_fname;
    String fileName = "N/A";
    final int OUTPUT_SOURCE_NONE = 0;
    final int OUTPUT_SOURCE_ODF = 1;
    final int OUTPUT_SOURCE_BDF = 2;
    public int outputDataSource = 1;
    String serial_output_portName = "/dev/tty.usbmodem1421";
    Serial serial_output;
    int serial_output_baud = 9600;
    PlotFontInfo fontInfo;
    boolean isRunning = false;
    boolean redrawScreenNow = true;
    int openBCI_byteCount = 0;
    byte inByte = (byte)-1;
    StringBuilder board_message;
    StringBuilder scanning_message;
    int dollaBillz;
    boolean isGettingPoll = false;
    boolean spaceFound = false;
    boolean scanningChannels = false;
    int hexToInt = 0;
    boolean dev = false;
    boolean screenHasBeenResized = false;
    float timeOfLastScreenResize = 0.0f;
    float timeOfGUIreinitialize = 0.0f;
    int reinitializeGUIdelay = 125;
    int widthOfLastScreen = 0;
    int heightOfLastScreen = 0;
    int win_x = 1024;
    int win_y = 768;
    PImage logo_blue;
    PImage logo_white;
    PFont f1;
    PFont f2;
    PFont f3;
    PFont f4;
    PFont h1;
    PFont h2;
    PFont h3;
    PFont h4;
    PFont h5;
    PFont p1;
    PFont p2;
    PFont p3;
    PFont p15;
    PFont p4;
    PFont p13;
    PFont p5;
    PFont p6;
    ButtonHelpText buttonHelpText;
    boolean no_start_connection = false;
    boolean has_processed = false;
    boolean isOldData = false;
    int indices = 0;
    boolean synthesizeData = false;
    int timeOfSetup = 0;
    boolean isHubInitialized = false;
    boolean isHubObjectInitialized = false;
    int bgColor = this.color(1, 18, 41);
    int openbciBlue = this.color(31, 69, 110);
    int COLOR_SCHEME_DEFAULT = 1;
    int COLOR_SCHEME_ALTERNATIVE_A;
    int colorScheme = this.COLOR_SCHEME_ALTERNATIVE_A = 2;
    Process nodeHubby;
    int hubPid = 0;
    String nodeHubName = "OpenBCIHub";
    Robot rob3115;
    PApplet ourApplet;
    int frameRateCounter = 1;
    String udpReceiveString = null;
    int pointCounter = 0;
    int prevBytes = 0;
    int prevMillis = this.millis();
    int byteRate_perSec = 0;
    int drawLoop_counter = 0;
    boolean mouseInFrame = false;
    boolean windowOriginSet = false;
    int appletOriginX = 0;
    int appletOriginY = 0;
    PVector loc;
    final char command_stop = (char)115;
    final char command_startBinary = (char)98;
    final char command_startBinary_wAux = (char)110;
    final char command_startBinary_4chan = (char)118;
    final char command_activateFilters = (char)102;
    final char command_deactivateFilters = (char)103;
    final String command_setMode = "/";
    final char[] command_deactivate_channel = new char[]{'1', '2', '3', '4', '5', '6', '7', '8', 'q', 'w', 'e', 'r', 't', 'y', 'u', 'i'};
    final char[] command_activate_channel = new char[]{'!', '@', '#', '$', '%', '^', '&', '*', 'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I'};
    int channelDeactivateCounter = 0;
    final int BOARD_MODE_DEFAULT = 0;
    final int BOARD_MODE_DEBUG = 1;
    final int BOARD_MODE_ANALOG = 2;
    final int BOARD_MODE_DIGITAL = 3;
    final int BOARD_MODE_MARKER = 4;
    boolean drawContainers = false;
    Container[] container = new Container[19];
    int widthOfLastScreen_C = 0;
    int heightOfLastScreen_C = 0;
    int topNav_h = 64;
    int bottomNav_h = 28;
    int leftNav_w = 0;
    int rightNav_w = 0;
    ControlPanel controlPanel;
    ControlP5 cp5;
    ControlP5 cp5Popup;
    CallbackListener cb = new CallbackListener(){

        public void controlEvent(CallbackEvent theEvent) {
            if (OpenBCI_GUI.this.cp5.isMouseOver((ControllerInterface)OpenBCI_GUI.this.cp5.get(Textfield.class, "fileName"))) {
                OpenBCI_GUI.println((String)"CallbackListener: controlEvent: clearing cyton");
                ((Textfield)OpenBCI_GUI.this.cp5.get(Textfield.class, "fileName")).clear();
            } else if (OpenBCI_GUI.this.cp5.isMouseOver((ControllerInterface)OpenBCI_GUI.this.cp5.get(Textfield.class, "fileNameGanglion"))) {
                OpenBCI_GUI.println((String)"CallbackListener: controlEvent: clearing ganglion");
                ((Textfield)OpenBCI_GUI.this.cp5.get(Textfield.class, "fileNameGanglion")).clear();
            } else if (OpenBCI_GUI.this.cp5.isMouseOver((ControllerInterface)OpenBCI_GUI.this.cp5.get(Textfield.class, "staticIPAddress"))) {
                OpenBCI_GUI.println((String)"CallbackListener: controlEvent: clearing static IP Address");
                ((Textfield)OpenBCI_GUI.this.cp5.get(Textfield.class, "staticIPAddress")).clear();
            }
        }
    };
    MenuList sourceList;
    MenuList serialList;
    String[] serialPorts = new String[Serial.list().length];
    MenuList bleList;
    MenuList wifiList;
    MenuList sdTimes;
    MenuList channelList;
    MenuList pollList;
    int boxColor = this.color(200);
    int boxStrokeColor = this.color(this.bgColor);
    int isSelected_color = this.color(184, 220, 105);
    boolean calledForBLEList = false;
    boolean calledForWifiList = false;
    Button refreshPort;
    Button refreshBLE;
    Button refreshWifi;
    Button protocolSerialCyton;
    Button protocolWifiCyton;
    Button protocolWifiGanglion;
    Button protocolBLED112Ganglion;
    Button protocolBLEGanglion;
    Button initSystemButton;
    Button autoFileName;
    Button outputBDF;
    Button outputODF;
    Button autoFileNameGanglion;
    Button outputODFGanglion;
    Button outputBDFGanglion;
    Button chanButton8;
    Button chanButton16;
    Button selectPlaybackFile;
    Button selectSDFile;
    Button popOutRadioConfigButton;
    Button popOutWifiConfigButton;
    Button getChannel;
    Button setChannel;
    Button ovrChannel;
    Button autoscan;
    Button systemStatus;
    Button eraseCredentials;
    Button getIpAddress;
    Button getFirmwareVersion;
    Button getMacAddress;
    Button getTypeOfAttachedBoard;
    Button sampleRate200;
    Button sampleRate250;
    Button sampleRate500;
    Button sampleRate1000;
    Button sampleRate1600;
    Button latencyCyton5ms;
    Button latencyCyton10ms;
    Button latencyCyton20ms;
    Button latencyGanglion5ms;
    Button latencyGanglion10ms;
    Button latencyGanglion20ms;
    Button wifiInternetProtocolCytonTCP;
    Button wifiInternetProtocolCytonUDP;
    Button wifiInternetProtocolCytonUDPBurst;
    Button wifiInternetProtocolGanglionTCP;
    Button wifiInternetProtocolGanglionUDP;
    Button wifiInternetProtocolGanglionUDPBurst;
    Button wifiIPAddressDyanmic;
    Button wifiIPAddressStatic;
    Button synthChanButton4;
    Button synthChanButton8;
    Button synthChanButton16;
    Button playbackChanButton4;
    Button playbackChanButton8;
    Button playbackChanButton16;
    Serial board;
    ChannelPopup channelPopup;
    PollPopup pollPopup;
    RadioConfigBox rcBox;
    WifiConfigBox wcBox;
    DateFormat dateFormat = new SimpleDateFormat("HH:mm:ss.SSS");
    BufferedReader dataReader;
    String dataLine;
    PrintWriter dataWriter;
    String convertedLine;
    String thisLine;
    String h;
    float[] floatData = new float[20];
    float[] intData = new float[20];
    String logFileName;
    String[] hexNums;
    long thisTime;
    long thatTime;
    boolean printNextLine = false;
    DataProcessing dataProcessing;
    String curTimestamp;
    boolean hasRepeated = false;
    HashMap<String, float[][]> processed_file;
    HashMap<Integer, String> index_of_times;
    HashMap<String, Integer> index_of_times_rev;
    final int DELTA = 0;
    final int THETA = 1;
    final int ALPHA = 2;
    final int BETA = 3;
    final int GAMMA = 4;
    RunningMean avgBitRate = new RunningMean(10);
    final float sine_freq_Hz = 10.0f;
    float[] sine_phase_rad = new float[this.nchan];
    DataProcessing_User dataProcessing_user;
    boolean drawEMG = false;
    boolean drawAccel = false;
    boolean drawPulse = false;
    boolean drawFFT = true;
    boolean drawBionics = false;
    boolean drawHead = true;
    String oldCommand = "";
    boolean hasGestured = false;
    boolean isVerbose = true;
    HelpWidget helpWidget;
    boolean printSignPosts = true;
    float millisOfLastSignPost = 0.0f;
    float millisSinceLastSignPost = 0.0f;
    static final int OUTPUT_LEVEL_DEFAULT = 0;
    static final int OUTPUT_LEVEL_INFO = 1;
    static final int OUTPUT_LEVEL_SUCCESS = 2;
    static final int OUTPUT_LEVEL_WARN = 3;
    static final int OUTPUT_LEVEL_ERROR = 4;
    int numSettingsPerChannel = 6;
    char[][] channelSettingValues = new char[this.nchan][this.numSettingsPerChannel];
    char[][] impedanceCheckValues = new char[this.nchan][2];
    boolean highDPI = false;
    boolean werePacketsDroppedHub = false;
    int numPacketsDroppedHub = 0;
    static final String BLE_HARDWARE_NOBLE = "noble";
    static final String BLE_HARDWARE_BLED112 = "bled112";
    static final String TCP_CMD_ACCEL = "a";
    static final String TCP_CMD_BOARD_TYPE = "b";
    static final String TCP_CMD_CONNECT = "c";
    static final String TCP_CMD_COMMAND = "k";
    static final String TCP_CMD_DISCONNECT = "d";
    static final String TCP_CMD_DATA = "t";
    static final String TCP_CMD_ERROR = "e";
    static final String TCP_CMD_EXAMINE = "x";
    static final String TCP_CMD_IMPEDANCE = "i";
    static final String TCP_CMD_LOG = "l";
    static final String TCP_CMD_PROTOCOL = "p";
    static final String TCP_CMD_SCAN = "s";
    static final String TCP_CMD_SD = "m";
    static final String TCP_CMD_STATUS = "q";
    static final String TCP_CMD_WIFI = "w";
    static final String TCP_STOP = ",;\n";
    static final String TCP_ACTION_START = "start";
    static final String TCP_ACTION_STATUS = "status";
    static final String TCP_ACTION_STOP = "stop";
    static final String TCP_WIFI_ERASE_CREDENTIALS = "eraseCredentials";
    static final String TCP_WIFI_GET_FIRMWARE_VERSION = "getFirmwareVersion";
    static final String TCP_WIFI_GET_IP_ADDRESS = "getIpAddress";
    static final String TCP_WIFI_GET_MAC_ADDRESS = "getMacAddress";
    static final String TCP_WIFI_GET_TYPE_OF_ATTACHED_BOARD = "getTypeOfAttachedBoard";
    static final byte BYTE_START = -96;
    static final byte BYTE_END = -64;
    static final int STATE_NOCOM = 0;
    static final int STATE_COMINIT = 1;
    static final int STATE_SYNCWITHHARDWARE = 2;
    static final int STATE_NORMAL = 3;
    static final int STATE_STOPPED = 4;
    static final int COM_INIT_MSEC = 3000;
    static final int NUM_ACCEL_DIMS = 3;
    static final int RESP_ERROR_UNKNOWN = 499;
    static final int RESP_ERROR_ALREADY_CONNECTED = 408;
    static final int RESP_ERROR_BAD_PACKET = 500;
    static final int RESP_ERROR_BAD_NOBLE_START = 501;
    static final int RESP_ERROR_CHANNEL_SETTINGS = 423;
    static final int RESP_ERROR_CHANNEL_SETTINGS_SYNC_IN_PROGRESS = 422;
    static final int RESP_ERROR_CHANNEL_SETTINGS_FAILED_TO_SET_CHANNEL = 424;
    static final int RESP_ERROR_CHANNEL_SETTINGS_FAILED_TO_PARSE = 425;
    static final int RESP_ERROR_COMMAND_NOT_ABLE_TO_BE_SENT = 406;
    static final int RESP_ERROR_COMMAND_NOT_RECOGNIZED = 434;
    static final int RESP_ERROR_DEVICE_NOT_FOUND = 405;
    static final int RESP_ERROR_IMPEDANCE_COULD_NOT_START = 414;
    static final int RESP_ERROR_IMPEDANCE_COULD_NOT_STOP = 415;
    static final int RESP_ERROR_IMPEDANCE_FAILED_TO_SET_IMPEDANCE = 430;
    static final int RESP_ERROR_IMPEDANCE_FAILED_TO_PARSE = 431;
    static final int RESP_ERROR_NO_OPEN_BLE_DEVICE = 400;
    static final int RESP_ERROR_UNABLE_TO_CONNECT = 402;
    static final int RESP_ERROR_UNABLE_TO_DISCONNECT = 401;
    static final int RESP_ERROR_PROTOCOL_UNKNOWN = 418;
    static final int RESP_ERROR_PROTOCOL_BLE_START = 419;
    static final int RESP_ERROR_PROTOCOL_NOT_STARTED = 420;
    static final int RESP_ERROR_UNABLE_TO_SET_BOARD_TYPE = 421;
    static final int RESP_ERROR_SCAN_ALREADY_SCANNING = 409;
    static final int RESP_ERROR_SCAN_NONE_FOUND = 407;
    static final int RESP_ERROR_SCAN_NO_SCAN_TO_STOP = 410;
    static final int RESP_ERROR_SCAN_COULD_NOT_START = 412;
    static final int RESP_ERROR_SCAN_COULD_NOT_STOP = 411;
    static final int RESP_ERROR_TIMEOUT_SCAN_STOPPED = 432;
    static final int RESP_ERROR_WIFI_ACTION_NOT_RECOGNIZED = 427;
    static final int RESP_ERROR_WIFI_COULD_NOT_ERASE_CREDENTIALS = 428;
    static final int RESP_ERROR_WIFI_COULD_NOT_SET_LATENCY = 429;
    static final int RESP_ERROR_WIFI_NEEDS_UPDATE = 435;
    static final int RESP_ERROR_WIFI_NOT_CONNECTED = 426;
    static final int RESP_GANGLION_FOUND = 201;
    static final int RESP_SUCCESS = 200;
    static final int RESP_SUCCESS_DATA_ACCEL = 202;
    static final int RESP_SUCCESS_DATA_IMPEDANCE = 203;
    static final int RESP_SUCCESS_DATA_SAMPLE = 204;
    static final int RESP_WIFI_FOUND = 205;
    static final int RESP_SUCCESS_CHANNEL_SETTING = 207;
    static final int RESP_STATUS_CONNECTED = 300;
    static final int RESP_STATUS_DISCONNECTED = 301;
    static final int RESP_STATUS_SCANNING = 302;
    static final int RESP_STATUS_NOT_SCANNING = 303;
    static final int LATENCY_5_MS = 5000;
    static final int LATENCY_10_MS = 10000;
    static final int LATENCY_20_MS = 20000;
    static final String TCP = "tcp";
    static final String UDP = "udp";
    static final String UDP_BURST = "udpBurst";
    static final String WIFI_DYNAMIC = "dynamic";
    static final String WIFI_STATIC = "static";
    boolean werePacketsDroppedSerial = false;
    int numPacketsDroppedSerial = 0;
    Playground playground;
    Presentation myPresentation;
    boolean drawPresentation = false;
    boolean isOpenBCI;
    int baudSwitch = 0;
    int navBarHeight = 32;
    TopNav topNav;
    FFT[] fftBuff = new FFT[this.nchan];
    boolean isFFTFiltered = true;
    float[] smoothFac = new float[]{0.0f, 0.5f, 0.75f, 0.9f, 0.95f, 0.98f};
    int smoothFac_ind = 3;
    int intensityFac_ind = 2;
    float default_vertScale_uV = 200.0f;
    float[] vertScaleFactor = new float[]{0.25f, 0.5f, 1.0f, 2.0f, 5.0f, 50.0f};
    int vertScaleFactor_ind = 2;
    float vertScale_uV = this.default_vertScale_uV;
    int navHeight = 22;
    W_timeSeries w_timeSeries;
    W_fft w_fft;
    W_networking w_networking;
    W_BandPower w_bandPower;
    W_accelerometer w_accelerometer;
    W_ganglionImpedance w_ganglionImpedance;
    W_headPlot w_headPlot;
    W_template w_template1;
    W_emg w_emg;
    W_openBionics w_openbionics;
    W_Focus w_focus;
    W_PulseSensor w_pulsesensor;
    W_AnalogRead w_analogRead;
    W_DigitalRead w_digitalRead;
    W_MarkerMode w_markermode;
    WidgetManager wm;
    boolean wmVisible = true;
    CColor cp5_colors;
    int[] channelColors = new int[]{this.color(129, 129, 129), this.color(124, 75, 141), this.color(54, 87, 158), this.color(49, 113, 89), this.color(221, 178, 13), this.color(253, 94, 52), this.color(224, 56, 45), this.color(162, 82, 49)};

    public void setup() {
        if (!this.isWindows()) {
            this.hubStop();
        }
        this.hubInit();
        OpenBCI_GUI.println((String)"Welcome to the Processing-based OpenBCI GUI!");
        OpenBCI_GUI.println((String)"Last update: 9/5/2016");
        OpenBCI_GUI.println((String)"For more information about how to work with this code base, please visit: http://docs.openbci.com/OpenBCI%20Software/");
        this.ourApplet = this;
        if (this.frameRateCounter == 0) {
            this.frameRate(24.0f);
        }
        if (this.frameRateCounter == 1) {
            this.frameRate(30.0f);
        }
        if (this.frameRateCounter == 2) {
            this.frameRate(45.0f);
        }
        if (this.frameRateCounter == 3) {
            this.frameRate(60.0f);
        }
        this.surface.setResizable(true);
        this.widthOfLastScreen = this.width;
        this.heightOfLastScreen = this.height;
        this.setupContainers();
        this.f1 = this.createFont("fonts/Raleway-SemiBold.otf", 16.0f);
        this.f2 = this.createFont("fonts/Raleway-Regular.otf", 15.0f);
        this.f3 = this.createFont("fonts/Raleway-SemiBold.otf", 15.0f);
        this.f4 = this.createFont("fonts/Raleway-SemiBold.otf", 64.0f);
        this.h1 = this.createFont("fonts/Montserrat-Regular.otf", 20.0f);
        this.h2 = this.createFont("fonts/Montserrat-Regular.otf", 18.0f);
        this.h3 = this.createFont("fonts/Montserrat-Regular.otf", 16.0f);
        this.h4 = this.createFont("fonts/Montserrat-Regular.otf", 14.0f);
        this.h5 = this.createFont("fonts/Montserrat-Regular.otf", 12.0f);
        this.p1 = this.createFont("fonts/OpenSans-Regular.ttf", 20.0f);
        this.p2 = this.createFont("fonts/OpenSans-Regular.ttf", 18.0f);
        this.p3 = this.createFont("fonts/OpenSans-Regular.ttf", 16.0f);
        this.p15 = this.createFont("fonts/OpenSans-Regular.ttf", 15.0f);
        this.p4 = this.createFont("fonts/OpenSans-Regular.ttf", 14.0f);
        this.p13 = this.createFont("fonts/OpenSans-Regular.ttf", 13.0f);
        this.p5 = this.createFont("fonts/OpenSans-Regular.ttf", 12.0f);
        this.p6 = this.createFont("fonts/OpenSans-Regular.ttf", 10.0f);
        this.frame.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (e.getSource() == OpenBCI_GUI.this.frame) {
                    OpenBCI_GUI.println((String)"OpenBCI_GUI: setup: RESIZED");
                    OpenBCI_GUI.this.screenHasBeenResized = true;
                    OpenBCI_GUI.this.timeOfLastScreenResize = OpenBCI_GUI.this.millis();
                }
            }
        });
        this.fontInfo = new PlotFontInfo();
        this.helpWidget = new HelpWidget(0.0f, this.win_y - 30, this.win_x, 30.0f);
        this.topNav = new TopNav();
        OpenBCI_GUI.print((String)"Graphics & GUI Library: ");
        this.controlPanel = new ControlPanel(this);
        this.logo_blue = this.loadImage("logo_blue.png");
        this.logo_white = this.loadImage("logo_white.png");
        this.cog = this.loadImage("cog_1024x1024.png");
        this.loadingGIF = new Gif((PApplet)this, "OpenBCI-LoadingGIF-2.gif");
        this.loadingGIF.loop();
        this.loadingGIF_blue = new Gif((PApplet)this, "OpenBCI-LoadingGIF-blue-256.gif");
        this.loadingGIF_blue.loop();
        this.playground = new Playground(this.navBarHeight);
        this.buttonHelpText = new ButtonHelpText();
        this.myPresentation = new Presentation();
        int portRX = 51000;
        String ip = "127.0.0.1";
        this.udpRX = new UDP((Object)this, portRX, ip);
        this.udpRX.setReceiveHandler("udpReceiveHandler");
        this.udpRX.log(true);
        this.udpRX.listen(true);
        OpenBCI_GUI.println((String)("OpenBCI_GUI::Setup: Is RX mulitcast: " + this.udpRX.isMulticast()));
        OpenBCI_GUI.println((String)("OpenBCI_GUI::Setup: Has RX joined multicast: " + this.udpRX.isJoined()));
        this.timeOfSetup = this.millis();
    }

    public void udpReceiveHandler(byte[] data, String ip, int portRX) {
        String udpString = new String(data);
        OpenBCI_GUI.println((String)(String.valueOf(udpString) + " from: " + ip + " and port: " + portRX));
        if (udpString.length() >= 5 && udpString.indexOf("MARK") >= 0) {
            int intValue = Integer.parseInt(udpString.substring(4));
            if (intValue > 0 && intValue < 96) {
                String sendString = "`" + PApplet.parseChar((int)(intValue + 31));
                OpenBCI_GUI.println((String)("Marker value: " + udpString + " with numeric value of char(" + intValue + ") as : " + sendString));
                this.hub.sendCommand(sendString);
            } else {
                OpenBCI_GUI.println((String)("udpReceiveHandler::Warning:invalid UDP STIM of value: " + intValue + " Received String: " + udpString));
            }
        } else {
            OpenBCI_GUI.println((String)("udpReceiveHandler::Warning:invalid UDP marker packet: " + udpString));
        }
    }

    public void draw() {
        ++this.drawLoop_counter;
        this.systemUpdate();
        this.systemDraw();
    }

    private void prepareExitHandler() {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                System.out.println("SHUTDOWN HOOK");
                try {
                    if (OpenBCI_GUI.this.hubStop()) {
                        System.out.println("SHUTDOWN HUB");
                    } else {
                        System.out.println("FAILED TO SHUTDOWN HUB");
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }));
    }

    public void hubInit() {
        this.isHubInitialized = true;
        if (!this.isWindows()) {
            this.hubStart();
            this.prepareExitHandler();
        }
    }

    public void hubStart() {
        OpenBCI_GUI.println((String)"Launching application from local data dir");
        try {
            if (this.isWindows()) {
                OpenBCI_GUI.println((String)"OpenBCI_GUI: hubStart: OS Detected: Windows");
                this.nodeHubby = OpenBCI_GUI.launch((String[])new String[]{this.dataPath("OpenBCIHub.exe")});
            } else if (this.isLinux()) {
                OpenBCI_GUI.println((String)"OpenBCI_GUI: hubStart: OS Detected: Linux");
                this.nodeHubby = OpenBCI_GUI.exec((String[])new String[]{this.dataPath("OpenBCIHub")});
            } else {
                OpenBCI_GUI.println((String)"OpenBCI_GUI: hubStart: OS Detected: Mac");
                this.nodeHubby = OpenBCI_GUI.launch((String[])new String[]{this.dataPath("OpenBCIHub.app")});
            }
        }
        catch (Exception e) {
            OpenBCI_GUI.println((String)("hubStart: " + e));
        }
    }

    public boolean hubStop() {
        if (this.isWindows()) {
            return this.killRunningprocessWin();
        }
        this.killRunningProcessMac();
        return true;
    }

    private boolean isLinux() {
        return System.getProperty("os.name").toLowerCase().indexOf("linux") > -1;
    }

    private boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().indexOf("windows") > -1;
    }

    private boolean isMac() {
        return !this.isWindows() && !this.isLinux();
    }

    public void killRunningProcessMac() {
        try {
            String line;
            Process p = Runtime.getRuntime().exec("ps -e");
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = input.readLine()) != null) {
                if (!line.contains(this.nodeHubName)) continue;
                try {
                    this.endProcess(this.getProcessIdFromLineMac(line));
                    OpenBCI_GUI.println((String)("Killed: " + line));
                }
                catch (Exception err) {
                    OpenBCI_GUI.println((String)("Failed to stop process: " + line + "\n\n"));
                    err.printStackTrace();
                }
            }
            input.close();
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    public boolean killRunningprocessWin() {
        try {
            Runtime.getRuntime().exec("taskkill /F /IM OpenBCIHub.exe");
            return true;
        }
        catch (Exception err) {
            err.printStackTrace();
            return false;
        }
    }

    public int getProcessIdFromLineMac(String line) {
        line = OpenBCI_GUI.trim((String)line);
        String[] components = line.split(" ");
        return Integer.parseInt(components[0]);
    }

    public void endProcess(int pid) {
        Runtime rt = Runtime.getRuntime();
        try {
            rt.exec("kill -9 " + pid);
        }
        catch (IOException err) {
            err.printStackTrace();
        }
    }

    public void setupWidgetManager() {
        this.wm = new WidgetManager(this);
    }

    public void initSystem() {
        OpenBCI_GUI.println();
        OpenBCI_GUI.println();
        OpenBCI_GUI.println((String)"=================================================");
        OpenBCI_GUI.println((String)"||             INITIALIZING SYSTEM             ||");
        OpenBCI_GUI.println((String)"=================================================");
        OpenBCI_GUI.println();
        this.verbosePrint("OpenBCI_GUI: initSystem: -- Init 0 -- " + this.millis());
        this.timeOfInit = this.millis();
        this.verbosePrint("timeOfInit = " + this.timeOfInit);
        this.verbosePrint("OpenBCI_GUI: initSystem: Preparing data variables...");
        if (this.eegDataSource == 2) {
            OpenBCI_GUI.println((String)("OpenBCI_GUI: initSystem: loading playback data from " + this.playbackData_fname));
            try {
                this.playbackData_table = new Table_CSV(this.playbackData_fname);
                this.playbackData_table.removeColumn(0);
            }
            catch (Exception exception) {
                OpenBCI_GUI.println((String)("OpenBCI_GUI: initSystem: could not open file for playback: " + this.playbackData_fname));
                OpenBCI_GUI.println((String)"   : quitting...");
                this.hub.killAndShowMsg("Could not open file for playback: " + this.playbackData_fname);
            }
            OpenBCI_GUI.println((String)("OpenBCI_GUI: initSystem: loading complete.  " + this.playbackData_table.getRowCount() + " rows of data, which is " + OpenBCI_GUI.round((float)(PApplet.parseFloat((int)this.playbackData_table.getRowCount()) / this.getSampleRateSafe())) + " seconds of EEG data"));
        }
        this.verbosePrint("OpenBCI_GUI: initSystem: Initializing core data objects");
        this.nDataBackBuff = 3 * (int)this.getSampleRateSafe();
        this.dataPacketBuff = new DataPacket_ADS1299[this.nDataBackBuff];
        this.nPointsPerUpdate = PApplet.parseInt((float)OpenBCI_GUI.round((float)(PApplet.parseFloat((int)40) * this.getSampleRateSafe() / 1000.0f)));
        this.dataBuffX = new float[(int)(this.dataBuff_len_sec * this.getSampleRateSafe())];
        this.dataBuffY_uV = new float[this.nchan][this.dataBuffX.length];
        this.dataBuffY_filtY_uV = new float[this.nchan][this.dataBuffX.length];
        this.yLittleBuff = new float[this.nPointsPerUpdate];
        this.yLittleBuff_uV = new float[this.nchan][this.nPointsPerUpdate];
        this.auxBuff = new float[3][this.nPointsPerUpdate];
        this.accelerometerBuff = new float[3][500];
        int i = 0;
        while (i < this.n_aux_ifEnabled) {
            int j = 0;
            while (j < this.accelerometerBuff[0].length) {
                this.accelerometerBuff[i][j] = 0.0f;
                ++j;
            }
            ++i;
        }
        this.data_elec_imp_ohm = new float[this.nchan];
        this.is_railed = new DataStatus[this.nchan];
        i = 0;
        while (i < this.nchan) {
            this.is_railed[i] = new DataStatus(this.threshold_railed, this.threshold_railed_warn);
            ++i;
        }
        i = 0;
        while (i < this.nDataBackBuff) {
            this.dataPacketBuff[i] = new DataPacket_ADS1299(this.nchan, this.n_aux_ifEnabled);
            ++i;
        }
        this.dataProcessing = new DataProcessing(this.nchan, this.getSampleRateSafe());
        this.dataProcessing_user = new DataProcessing_User(this.nchan, this.getSampleRateSafe());
        this.prepareData(this.dataBuffX, this.dataBuffY_uV, this.getSampleRateSafe());
        this.verbosePrint("OpenBCI_GUI: initSystem: -- Init 1 -- " + this.millis());
        this.verbosePrint("OpenBCI_GUI: initSystem: Initializing FFT data objects");
        int Ichan = 0;
        while (Ichan < this.nchan) {
            this.fftBuff[Ichan] = new FFT(this.getNfftSafe(), this.getSampleRateSafe());
            ++Ichan;
        }
        this.initializeFFTObjects(this.fftBuff, this.dataBuffY_uV, this.getNfftSafe(), this.getSampleRateSafe());
        this.verbosePrint("OpenBCI_GUI: initSystem: -- Init 2 -- " + this.millis());
        this.verbosePrint("OpenBCI_GUI: initSystem: Closing ControlPanel...");
        this.controlPanel.close();
        this.topNav.controlPanelCollapser.setIsActive(false);
        this.verbosePrint("OpenBCI_GUI: initSystem: Initializing comms with hub....");
        this.hub.changeState(1);
        switch (this.eegDataSource) {
            case 0: {
                int nEEDataValuesPerPacket = this.nchan;
                boolean useAux = true;
                if (this.cyton.getInterface() == 0) {
                    this.cyton = new Cyton(this, this.openBCI_portName, this.openBCI_baud, nEEDataValuesPerPacket, useAux, this.n_aux_ifEnabled, this.cyton.getInterface());
                    break;
                }
                if (this.hub.getWiFiStyle() == WIFI_DYNAMIC) {
                    this.cyton = new Cyton(this, this.wifi_portName, this.openBCI_baud, nEEDataValuesPerPacket, useAux, this.n_aux_ifEnabled, this.cyton.getInterface());
                    break;
                }
                this.cyton = new Cyton(this, this.wifi_ipAddress, this.openBCI_baud, nEEDataValuesPerPacket, useAux, this.n_aux_ifEnabled, this.cyton.getInterface());
                break;
            }
            case 3: {
                break;
            }
            case 2: {
                break;
            }
            case 1: {
                if (this.ganglion.getInterface() == 1 || this.ganglion.getInterface() == 3) {
                    this.hub.connectBLE(this.ganglion_portName);
                    break;
                }
                if (this.hub.getWiFiStyle() == WIFI_DYNAMIC) {
                    this.hub.connectWifi(this.wifi_portName);
                    break;
                }
                this.hub.connectWifi(this.wifi_ipAddress);
                break;
            }
        }
        this.verbosePrint("OpenBCI_GUI: initSystem: -- Init 3 -- " + this.millis());
        if (this.abandonInit) {
            this.haltSystem();
            OpenBCI_GUI.println((String)"Failed to connect to data source... 1");
            this.outputError("Failed to connect to data source fail point 1");
        } else {
            OpenBCI_GUI.println((String)("  3a -- " + this.millis()));
            this.topNav.initSecondaryNav();
            OpenBCI_GUI.println((String)("  3b -- " + this.millis()));
            if (this.eegDataSource == 0) {
                this.openNewLogFile(this.fileName);
            }
            if (this.eegDataSource == 1) {
                this.openNewLogFile(this.fileName);
            }
            this.setupWidgetManager();
            if (!this.abandonInit) {
                OpenBCI_GUI.println((String)("  3c -- " + this.millis()));
                this.nextPlayback_millis = this.millis();
                this.w_timeSeries.hsc.loadDefaultChannelSettings();
                if (this.eegDataSource != 1 && this.eegDataSource != 0) {
                    this.systemMode = 10;
                }
                if (!this.abandonInit) {
                    this.controlPanel.close();
                } else {
                    this.haltSystem();
                    OpenBCI_GUI.println((String)"Failed to connect to data source... 2");
                }
            } else {
                this.haltSystem();
                OpenBCI_GUI.println((String)"Failed to connect to data source... 3");
            }
        }
        this.verbosePrint("OpenBCI_GUI: initSystem: -- Init 4 -- " + this.millis());
        this.midInit = false;
        this.abandonInit = false;
    }

    public float getSampleRateSafe() {
        if (this.eegDataSource == 1) {
            return this.ganglion.getSampleRate();
        }
        if (this.eegDataSource == 0) {
            return this.cyton.getSampleRate();
        }
        if (this.eegDataSource == 2) {
            return this.playbackData_table.getSampleRate();
        }
        return 250.0f;
    }

    public int getNfftSafe() {
        int sampleRate = (int)this.getSampleRateSafe();
        switch (sampleRate) {
            case 1000: {
                return 1024;
            }
            case 1600: {
                return 2048;
            }
        }
        return 256;
    }

    public void startRunning() {
        this.verbosePrint("startRunning...");
        this.output("Data stream started.");
        if (this.eegDataSource == 1) {
            if (this.ganglion != null) {
                this.ganglion.startDataTransfer();
            }
        } else if (this.cyton != null) {
            OpenBCI_GUI.println((String)"DEBUG: start data transfer");
            this.cyton.startDataTransfer();
        }
        this.isRunning = true;
    }

    public void stopRunning() {
        this.verbosePrint("OpenBCI_GUI: stopRunning: stop running...");
        if (this.isRunning) {
            this.output("Data stream stopped.");
        }
        if (this.eegDataSource == 1) {
            if (this.ganglion != null) {
                this.ganglion.stopDataTransfer();
            }
        } else if (this.cyton != null) {
            this.cyton.stopDataTransfer();
        }
        this.timeSinceStopRunning = this.millis();
        this.isRunning = false;
    }

    public void stopButtonWasPressed() {
        if (this.isRunning) {
            this.verbosePrint("openBCI_GUI: stopButton was pressed...stopping data transfer...");
            this.wm.setUpdating(false);
            this.stopRunning();
            this.topNav.stopButton.setString("Start Data Stream");
            this.topNav.stopButton.setColorNotPressed(this.color(184, 220, 105));
            if (this.eegDataSource == 1 && this.ganglion.isCheckingImpedance()) {
                this.ganglion.impedanceStop();
                this.w_ganglionImpedance.startStopCheck.but_txt = "Start Impedance Check";
            }
        } else {
            this.verbosePrint("openBCI_GUI: startButton was pressed...starting data transfer...");
            this.wm.setUpdating(true);
            this.startRunning();
            this.topNav.stopButton.setString("Stop Data Stream");
            this.topNav.stopButton.setColorNotPressed(this.color(224, 56, 45));
            this.nextPlayback_millis = this.millis();
            if (this.eegDataSource == 1 && this.ganglion.isCheckingImpedance()) {
                this.ganglion.impedanceStop();
                this.w_ganglionImpedance.startStopCheck.but_txt = "Start Impedance Check";
            }
        }
    }

    public void haltSystem() {
        OpenBCI_GUI.println((String)"openBCI_GUI: haltSystem: Halting system for reconfiguration of settings...");
        if (this.initSystemButton.but_txt == "STOP SYSTEM") {
            this.initSystemButton.but_txt = "START SYSTEM";
        }
        this.stopRunning();
        if (this.cyton.isPortOpen() && this.w_pulsesensor.analogReadOn) {
            this.hub.sendCommand("/0");
            OpenBCI_GUI.println((String)"Stopping Analog Read to read accelerometer");
            this.w_pulsesensor.analogModeButton.setString("Turn Analog Read On");
            this.w_pulsesensor.analogReadOn = false;
        }
        this.curDataPacketInd = -1;
        this.lastReadDataPacketInd = -1;
        this.pointCounter = 0;
        this.currentTableRowIndex = 0;
        this.prevBytes = 0;
        this.prevMillis = this.millis();
        this.byteRate_perSec = 0;
        this.drawLoop_counter = 0;
        this.openBCI_portName = "N/A";
        this.ganglion_portName = "N/A";
        this.wifi_portName = "N/A";
        this.controlPanel.resetListItems();
        if (this.eegDataSource == 0) {
            this.closeLogFile();
            this.cyton.closeSDandPort();
        }
        if (this.eegDataSource == 1) {
            if (this.ganglion.isCheckingImpedance()) {
                this.ganglion.impedanceStop();
                this.w_ganglionImpedance.startStopCheck.but_txt = "Start Impedance Check";
            }
            this.closeLogFile();
            this.ganglion.closePort();
        }
        this.systemMode = 0;
        this.hub.changeState(0);
        this.abandonInit = false;
        this.bleList.items.clear();
        this.wifiList.items.clear();
    }

    public void delayedInit() {
        new GPlot((PApplet)this);
    }

    public void systemUpdate() {
        if (this.isHubInitialized && !this.isHubObjectInitialized && this.millis() - this.timeOfSetup >= 1500) {
            this.hub = new Hub(this);
            OpenBCI_GUI.println((String)"Instantiating hub object...");
            this.isHubObjectInitialized = true;
            this.thread("delayedInit");
        }
        this.win_x = this.width;
        this.win_y = this.height;
        this.helpWidget.update();
        if (this.systemMode == 0) {
            this.controlPanel.update();
            this.topNav.update();
            if (this.widthOfLastScreen != this.width || this.heightOfLastScreen != this.height) {
                this.topNav.screenHasBeenResized(this.width, this.height);
            }
        }
        if (this.systemMode == 10) {
            if (this.isRunning) {
                this.pointCounter = this.getDataIfAvailable(this.pointCounter);
                if (this.pointCounter >= this.nPointsPerUpdate) {
                    this.pointCounter = 0;
                    this.processNewData();
                    if (!((float)this.millis() - this.timeOfGUIreinitialize > (float)this.reinitializeGUIdelay)) {
                        OpenBCI_GUI.println((String)"OpenBCI_GUI: systemUpdate: reinitializing GUI after resize... not updating GUI");
                    }
                    this.redrawScreenNow = true;
                }
            } else if (this.eegDataSource == 2 && !this.has_processed && !this.isOldData) {
                this.lastReadDataPacketInd = 0;
                this.pointCounter = 0;
                try {
                    this.process_input_file();
                }
                catch (Exception exception) {
                    this.isOldData = true;
                    this.output("Error processing timestamps, are you using old data?");
                }
            }
            if (this.widthOfLastScreen != this.width || this.heightOfLastScreen != this.height) {
                OpenBCI_GUI.println((String)"OpenBCI_GUI: setup: RESIZED");
                this.screenHasBeenResized = true;
                this.timeOfLastScreenResize = this.millis();
                this.widthOfLastScreen = this.width;
                this.heightOfLastScreen = this.height;
            }
            if (this.screenHasBeenResized) {
                this.ourApplet = this;
                this.topNav.screenHasBeenResized(this.width, this.height);
                this.wm.screenResized();
            }
            if (this.screenHasBeenResized && (float)this.millis() - this.timeOfLastScreenResize > (float)this.reinitializeGUIdelay) {
                this.screenHasBeenResized = false;
                OpenBCI_GUI.println((String)"systemUpdate: reinitializing GUI");
                this.timeOfGUIreinitialize = this.millis();
                this.playground.x = this.width;
            }
            if (!this.initSystemThreadLock && this.wm.isWMInitialized) {
                this.wm.update();
                this.playground.update();
            }
        }
    }

    public void systemDraw() {
        this.background(this.bgColor);
        this.noStroke();
        if (this.systemMode >= 10 && !this.initSystemThreadLock) {
            int drawLoopCounter_thresh = 100;
            if (this.redrawScreenNow || this.drawLoop_counter >= drawLoopCounter_thresh) {
                this.drawLoop_counter = 0;
                this.redrawScreenNow = false;
                block1 : switch (this.eegDataSource) {
                    case 0: {
                        switch (this.outputDataSource) {
                            case 1: {
                                this.surface.setTitle(String.valueOf(PApplet.parseInt((float)this.frameRate)) + " fps, " + PApplet.parseInt((float)(PApplet.parseFloat((int)this.fileoutput_odf.getRowsWritten()) / this.getSampleRateSafe())) + " secs Saved, Writing to " + this.output_fname);
                                break block1;
                            }
                            case 2: {
                                this.surface.setTitle(String.valueOf(PApplet.parseInt((float)this.frameRate)) + " fps, " + PApplet.parseInt((float)this.fileoutput_bdf.getRecordsWritten()) + " secs Saved, Writing to " + this.output_fname);
                                break block1;
                            }
                        }
                        this.surface.setTitle(String.valueOf(PApplet.parseInt((float)this.frameRate)) + " fps");
                        break;
                    }
                    case 3: {
                        this.surface.setTitle(String.valueOf(PApplet.parseInt((float)this.frameRate)) + " fps, Using Synthetic EEG Data");
                        break;
                    }
                    case 2: {
                        this.surface.setTitle(String.valueOf(PApplet.parseInt((float)this.frameRate)) + " fps, Playing " + PApplet.parseInt((float)(PApplet.parseFloat((int)this.currentTableRowIndex) / this.getSampleRateSafe())) + " of " + PApplet.parseInt((float)(PApplet.parseFloat((int)this.playbackData_table.getRowCount()) / this.getSampleRateSafe())) + " secs, Reading from: " + this.playbackData_fname);
                        break;
                    }
                    case 1: {
                        this.surface.setTitle(String.valueOf(PApplet.parseInt((float)this.frameRate)) + " fps, Ganglion!");
                    }
                }
            }
            if ((float)this.millis() - this.timeOfGUIreinitialize > (float)this.reinitializeGUIdelay) {
                try {
                    this.wm.draw();
                }
                catch (Exception e) {
                    OpenBCI_GUI.println((String)e.getMessage());
                    this.reinitializeGUIdelay *= 2;
                    OpenBCI_GUI.println((String)("OpenBCI_GUI: systemDraw: New GUI reinitialize delay = " + this.reinitializeGUIdelay));
                }
            } else {
                OpenBCI_GUI.println((String)"OpenBCI_GUI: systemDraw: reinitializing GUI after resize... not drawing GUI");
            }
            this.drawContainers();
        } else {
            this.surface.setTitle(String.valueOf(PApplet.parseInt((float)this.frameRate)) + " fps \u2014 OpenBCI GUI");
        }
        if (this.systemMode >= 0) {
            this.topNav.draw();
            if (this.controlPanel.isOpen) {
                this.controlPanel.draw();
            }
            this.helpWidget.draw();
        }
        if (this.systemMode == -10) {
            if (this.hasIntroAnimation) {
                this.introAnimation();
            } else {
                this.systemMode = 0;
            }
        }
        if ((this.hub.get_state() == 1 || this.hub.get_state() == 2) && this.systemMode == 0) {
            this.pushStyle();
            this.imageMode(3);
            this.image((PImage)this.loadingGIF, this.width / 2, this.height / 2, 128.0f, 128.0f);
            this.popStyle();
            if (this.millis() % 1000 < 500) {
                this.output("Attempting to establish a connection with your OpenBCI Board...");
            } else {
                this.output("");
            }
            if ((long)this.millis() - this.timeOfInit > 12000L) {
                this.haltSystem();
                this.initSystemButton.but_txt = "START SYSTEM";
                this.output("Init timeout. Verify your Serial/COM Port. Power DOWN/UP your OpenBCI & USB Dongle. Then retry Initialization.");
                this.controlPanel.open();
            }
        }
        if (this.drawPresentation) {
            this.myPresentation.draw();
        }
        this.buttonHelpText.draw();
        this.mouseOutOfBounds();
    }

    public void introAnimation() {
        this.pushStyle();
        this.imageMode(3);
        this.background(255);
        int t1 = 4000;
        int t2 = 6000;
        int t3 = 8000;
        float transparency = 0.0f;
        if (this.millis() >= t1) {
            transparency = OpenBCI_GUI.map((float)this.millis(), (float)t1, (float)t2, (float)0.0f, (float)255.0f);
            this.tint(255, transparency);
            this.image(this.cog, this.width / 2, this.height / 2, this.width / 6, this.width / 6);
            this.textFont(this.p3, 16.0f);
            this.textLeading(24.0f);
            this.fill(31.0f, 69.0f, 110.0f, transparency);
            this.textAlign(3, 3);
            this.text("OpenBCI GUI v3.3.1\nMay 2018", this.width / 2, this.height / 2 + this.width / 9);
        }
        if (this.millis() >= t3) {
            this.systemMode = 0;
            this.controlPanel.isOpen = true;
        }
        this.popStyle();
    }

    public void mouseOutOfBounds() {
        if (this.windowOriginSet && this.mouseInFrame) {
            try {
                if (MouseInfo.getPointerInfo().getLocation().x <= this.appletOriginX || MouseInfo.getPointerInfo().getLocation().x >= this.appletOriginX + this.width || MouseInfo.getPointerInfo().getLocation().y <= this.appletOriginY || MouseInfo.getPointerInfo().getLocation().y >= this.appletOriginY + this.height) {
                    this.mouseX = 0;
                    this.mouseY = 0;
                    this.mouseInFrame = false;
                }
            }
            catch (RuntimeException runtimeException) {
                this.verbosePrint("Error happened while cursor left application...");
            }
        } else if (this.mouseX > 0 && this.mouseX < this.width && this.mouseY > 0 && this.mouseY < this.height) {
            this.loc = this.getWindowLocation("processing.opengl.PGraphics2D");
            this.appletOriginX = (int)this.loc.x;
            this.appletOriginY = (int)this.loc.y;
            this.windowOriginSet = true;
            this.mouseInFrame = true;
        }
    }

    public PVector getWindowLocation(String renderer) {
        PVector l = new PVector();
        if (renderer == "processing.opengl.PGraphics2D" || renderer == "processing.opengl.PGraphics3D") {
            Point p = new Point();
            ((GLWindow)this.surface.getNative()).getLocationOnScreen(p);
            l.x = p.getX();
            l.y = p.getY();
        } else if (renderer == "processing.awt.PGraphicsJava2D") {
            Frame f = ((PSurfaceAWT.SmoothCanvas)this.surface.getNative()).getFrame();
            l.x = f.getX();
            l.y = f.getY();
        }
        return l;
    }

    public void setupContainers() {
        this.widthOfLastScreen_C = this.width;
        this.heightOfLastScreen_C = this.height;
        this.container[0] = new Container(0.0f, 0.0f, this.width, this.topNav_h, 0.0f);
        this.container[5] = new Container(0.0f, this.topNav_h, this.width, this.height - (this.topNav_h + this.bottomNav_h), 1.0f);
        this.container[1] = new Container(this.container[5], "TOP_LEFT");
        this.container[2] = new Container(this.container[5], "TOP");
        this.container[3] = new Container(this.container[5], "TOP_RIGHT");
        this.container[4] = new Container(this.container[5], "LEFT");
        this.container[6] = new Container(this.container[5], "RIGHT");
        this.container[7] = new Container(this.container[5], "BOTTOM_LEFT");
        this.container[8] = new Container(this.container[5], "BOTTOM");
        this.container[9] = new Container(this.container[5], "BOTTOM_RIGHT");
        this.container[10] = new Container(0.0f, this.height - this.bottomNav_h, this.width, 50.0f, 0.0f);
        this.container[11] = new Container(this.container[3], "TOP");
        this.container[12] = new Container(this.container[3], "BOTTOM");
        this.container[13] = new Container(this.container[9], "TOP");
        this.container[14] = new Container(this.container[9], "BOTTOM");
        this.container[15] = new Container(this.container[6], "TOP_LEFT");
        this.container[16] = new Container(this.container[6], "TOP_RIGHT");
        this.container[17] = new Container(this.container[6], "BOTTOM_LEFT");
        this.container[18] = new Container(this.container[6], "BOTTOM_RIGHT");
    }

    public void drawContainers() {
        int i = 0;
        while (i < this.container.length) {
            this.container[i].draw();
            ++i;
        }
        if (this.widthOfLastScreen_C != this.width || this.heightOfLastScreen_C != this.height) {
            OpenBCI_GUI.println((String)"OpenBCI_GUI: setup: RESIZED");
            this.setupContainers();
            this.widthOfLastScreen = this.width;
            this.heightOfLastScreen = this.height;
        }
    }

    public void controlEvent(ControlEvent theEvent) {
        Map<String, Object> bob;
        if (theEvent.isFrom("sourceList")) {
            this.controlPanel.hideAllBoxes();
            bob = ((MenuList)theEvent.getController()).getItem(PApplet.parseInt((float)theEvent.getValue()));
            String str = (String)bob.get("headline");
            int newDataSource = PApplet.parseInt((float)theEvent.getValue());
            if (newDataSource != 3 && newDataSource != 2 && !this.hub.nodeProcessHandshakeComplete) {
                if (this.isWindows()) {
                    this.output("Please launch OpenBCI Hub prior to launching this application. Learn at docs.openbci.com", 4);
                } else {
                    this.output("Unable to establish link to Hub. Checkout tutorial at docs.openbci.com/OpenBCI%20Software/01-OpenBCI_GUI", 4);
                }
                this.eegDataSource = -1;
                return;
            }
            this.protocolBLEGanglion.color_notPressed = this.autoFileName.color_notPressed;
            this.protocolWifiGanglion.color_notPressed = this.autoFileName.color_notPressed;
            if (this.isMac()) {
                this.protocolBLED112Ganglion.color_notPressed = this.autoFileName.color_notPressed;
            }
            this.protocolWifiCyton.color_notPressed = this.autoFileName.color_notPressed;
            this.protocolSerialCyton.color_notPressed = this.autoFileName.color_notPressed;
            this.eegDataSource = newDataSource;
            this.ganglion.setInterface(-1);
            this.cyton.setInterface(-1);
            if (newDataSource == 0) {
                this.updateToNChan(8);
                this.chanButton8.color_notPressed = this.isSelected_color;
                this.chanButton16.color_notPressed = this.autoFileName.color_notPressed;
                this.latencyCyton5ms.color_notPressed = this.autoFileName.color_notPressed;
                this.latencyCyton10ms.color_notPressed = this.isSelected_color;
                this.latencyCyton20ms.color_notPressed = this.autoFileName.color_notPressed;
                this.hub.setLatency(10000);
                this.wifiInternetProtocolCytonTCP.color_notPressed = this.isSelected_color;
                this.wifiInternetProtocolCytonUDP.color_notPressed = this.autoFileName.color_notPressed;
                this.wifiInternetProtocolCytonUDPBurst.color_notPressed = this.autoFileName.color_notPressed;
                this.hub.setWifiInternetProtocol(TCP);
                this.hub.setWiFiStyle(WIFI_DYNAMIC);
                this.wifiIPAddressDyanmic.color_notPressed = this.isSelected_color;
                this.wifiIPAddressStatic.color_notPressed = this.autoFileName.color_notPressed;
            } else if (newDataSource == 1) {
                this.updateToNChan(4);
                if (this.isWindows() && !this.isHubInitialized) {
                    this.hubInit();
                    this.timeOfSetup = this.millis();
                }
                this.latencyGanglion5ms.color_notPressed = this.autoFileName.color_notPressed;
                this.latencyGanglion10ms.color_notPressed = this.isSelected_color;
                this.latencyGanglion20ms.color_notPressed = this.autoFileName.color_notPressed;
                this.hub.setLatency(10000);
                this.wifiInternetProtocolGanglionTCP.color_notPressed = this.isSelected_color;
                this.wifiInternetProtocolGanglionUDP.color_notPressed = this.autoFileName.color_notPressed;
                this.wifiInternetProtocolGanglionUDPBurst.color_notPressed = this.autoFileName.color_notPressed;
                this.hub.setWifiInternetProtocol(TCP);
                this.hub.setWiFiStyle(WIFI_DYNAMIC);
                this.wifiIPAddressDyanmic.color_notPressed = this.isSelected_color;
                this.wifiIPAddressStatic.color_notPressed = this.autoFileName.color_notPressed;
            } else if (newDataSource == 2) {
                this.updateToNChan(8);
                this.playbackChanButton4.color_notPressed = this.autoFileName.color_notPressed;
                this.playbackChanButton8.color_notPressed = this.isSelected_color;
                this.playbackChanButton16.color_notPressed = this.autoFileName.color_notPressed;
            } else if (newDataSource == 3) {
                this.updateToNChan(8);
                this.synthChanButton4.color_notPressed = this.autoFileName.color_notPressed;
                this.synthChanButton8.color_notPressed = this.isSelected_color;
                this.synthChanButton16.color_notPressed = this.autoFileName.color_notPressed;
            }
            this.output("The new data source is " + str + " and NCHAN = [" + this.nchan + "]");
        }
        if (theEvent.isFrom("serialList")) {
            bob = ((MenuList)theEvent.getController()).getItem(PApplet.parseInt((float)theEvent.getValue()));
            this.openBCI_portName = (String)bob.get("headline");
            this.output("OpenBCI Port Name = " + this.openBCI_portName);
        }
        if (theEvent.isFrom("bleList")) {
            bob = ((MenuList)theEvent.getController()).getItem(PApplet.parseInt((float)theEvent.getValue()));
            this.ganglion_portName = (String)bob.get("headline");
            this.output("Ganglion Device Name = " + this.ganglion_portName);
        }
        if (theEvent.isFrom("wifiList")) {
            bob = ((MenuList)theEvent.getController()).getItem(PApplet.parseInt((float)theEvent.getValue()));
            this.wifi_portName = (String)bob.get("headline");
            this.output("Wifi Device Name = " + this.wifi_portName);
        }
        if (theEvent.isFrom("sdTimes")) {
            bob = ((MenuList)theEvent.getController()).getItem(PApplet.parseInt((float)theEvent.getValue()));
            this.sdSettingString = (String)bob.get("headline");
            this.sdSetting = PApplet.parseInt((float)theEvent.getValue());
            if (this.sdSetting != 0) {
                this.output("OpenBCI microSD Setting = " + this.sdSettingString + " recording time");
            } else {
                this.output("OpenBCI microSD Setting = " + this.sdSettingString);
            }
            this.verbosePrint("SD setting = " + this.sdSetting);
        }
        if (theEvent.isFrom("channelList")) {
            int setChannelInt = PApplet.parseInt((float)theEvent.getValue()) + 1;
            ((MenuList)((Object)this.cp5Popup.get(MenuList.class, "channelList"))).setVisible(false);
            this.channelPopup.setClicked(false);
            if (this.setChannel.wasPressed) {
                this.set_channel(this.rcBox, setChannelInt);
                this.setChannel.wasPressed = false;
            } else if (this.ovrChannel.wasPressed) {
                this.set_channel_over(this.rcBox, setChannelInt);
                this.ovrChannel.wasPressed = false;
            }
            OpenBCI_GUI.println((String)"still goin off");
        }
    }

    public void initButtonPressed() {
        if (this.initSystemButton.but_txt == "START SYSTEM") {
            if (this.eegDataSource == 0 && this.cyton.getInterface() == -1 || this.eegDataSource == 1 && this.ganglion.getInterface() == -1) {
                this.output("No Transfer Protocol selected. Please select your Transfer Protocol and retry system initiation.");
                this.initSystemButton.wasPressed = false;
                this.initSystemButton.setIsActive(false);
                return;
            }
            if (this.eegDataSource == 0 && this.cyton.getInterface() == 0 && this.openBCI_portName == "N/A") {
                this.output("No Serial/COM port selected. Please select your Serial/COM port and retry system initiation.");
                this.initSystemButton.wasPressed = false;
                this.initSystemButton.setIsActive(false);
                return;
            }
            if (this.eegDataSource == 0 && this.cyton.getInterface() == 2 && this.wifi_portName == "N/A" && this.hub.getWiFiStyle() == WIFI_DYNAMIC) {
                this.output("No Wifi Shield selected. Please select your Wifi Shield and retry system initiation.");
                this.initSystemButton.wasPressed = false;
                this.initSystemButton.setIsActive(false);
                return;
            }
            if (this.eegDataSource == 2 && this.playbackData_fname == "N/A") {
                this.output("No playback file selected. Please select a playback file and retry system initiation.");
                this.initSystemButton.wasPressed = false;
                this.initSystemButton.setIsActive(false);
                return;
            }
            if (this.eegDataSource == 1 && (this.ganglion.getInterface() == 1 || this.ganglion.getInterface() == 3) && this.ganglion_portName == "N/A") {
                this.output("No BLE device selected. Please select your Ganglion device and retry system initiation.");
                this.initSystemButton.wasPressed = false;
                this.initSystemButton.setIsActive(false);
                return;
            }
            if (this.eegDataSource == 1 && this.ganglion.getInterface() == 2 && this.wifi_portName == "N/A" && this.hub.getWiFiStyle() == WIFI_DYNAMIC) {
                this.output("No Wifi Shield selected. Please select your Wifi Shield and retry system initiation.");
                this.initSystemButton.wasPressed = false;
                this.initSystemButton.setIsActive(false);
                return;
            }
            if (this.eegDataSource == -1) {
                this.output("No DATA SOURCE selected. Please select a DATA SOURCE and retry system initiation.");
                this.initSystemButton.wasPressed = false;
                this.initSystemButton.setIsActive(false);
                return;
            }
            this.initSystemButton.setString("STOP SYSTEM");
            if (this.eegDataSource == 0) {
                this.verbosePrint("ControlPanel \u2014 port is open: " + this.cyton.isPortOpen());
                if (this.cyton.isPortOpen()) {
                    this.cyton.closePort();
                }
            } else if (this.eegDataSource == 1) {
                this.verbosePrint("ControlPanel \u2014 port is open: " + this.ganglion.isPortOpen());
                if (this.ganglion.isPortOpen()) {
                    this.ganglion.closePort();
                }
            }
            if (this.eegDataSource == 1) {
                this.fileName = ((Textfield)this.cp5.get(Textfield.class, "fileNameGanglion")).getText();
            } else if (this.eegDataSource == 0) {
                this.fileName = ((Textfield)this.cp5.get(Textfield.class, "fileName")).getText();
            }
            if (this.hub.getWiFiStyle() == WIFI_STATIC && (this.cyton.isWifi() || this.ganglion.isWifi())) {
                this.wifi_ipAddress = ((Textfield)this.cp5.get(Textfield.class, "staticIPAddress")).getText();
                OpenBCI_GUI.println((String)("Static IP address of " + this.wifi_ipAddress));
            }
            this.midInit = true;
            OpenBCI_GUI.println((String)"initSystem yoo");
            this.initSystem();
        } else {
            this.output("Learn how to use this application and more at docs.openbci.com");
            this.initSystemButton.setString("START SYSTEM");
            ((Textfield)this.cp5.get(Textfield.class, "fileName")).setText(this.getDateString());
            ((Textfield)this.cp5.get(Textfield.class, "fileNameGanglion")).setText(this.getDateString());
            ((Textfield)this.cp5.get(Textfield.class, "staticIPAddress")).setText(this.wifi_ipAddress);
            this.haltSystem();
        }
    }

    public void updateToNChan(int _nchan) {
        this.nchan = _nchan;
        this.fftBuff = new FFT[this.nchan];
        this.yLittleBuff_uV = new float[this.nchan][this.nPointsPerUpdate];
        this.output("Channel count set to " + OpenBCI_GUI.str((int)this.nchan));
        OpenBCI_GUI.println((String)("channel count set to " + OpenBCI_GUI.str((int)this.nchan)));
        this.hub.initDataPackets(_nchan, 3);
        this.ganglion.initDataPackets(_nchan, 3);
        this.cyton.initDataPackets(_nchan, 3);
        this.updateChannelArrays(this.nchan);
    }

    public void set_channel_popup() {
    }

    public Map<String, Object> makeItem(String theHeadline) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("headline", theHeadline);
        return m;
    }

    public void openNewLogFile(String _fileName) {
        switch (this.outputDataSource) {
            case 1: {
                this.openNewLogFileODF(_fileName);
                break;
            }
            case 2: {
                this.openNewLogFileBDF(_fileName);
                break;
            }
        }
    }

    public void openNewLogFileBDF(String _fileName) {
        if (this.fileoutput_bdf != null) {
            OpenBCI_GUI.println((String)"OpenBCI_GUI: closing log file");
            this.closeLogFile();
        }
        this.fileoutput_bdf = new OutputFile_BDF(this.getSampleRateSafe(), this.nchan, _fileName);
        this.output_fname = this.fileoutput_bdf.fname;
        OpenBCI_GUI.println((String)("cyton: openNewLogFile: opened BDF output file: " + this.output_fname));
        this.output("cyton: openNewLogFile: opened BDF output file: " + this.output_fname);
    }

    public void openNewLogFileODF(String _fileName) {
        if (this.fileoutput_odf != null) {
            OpenBCI_GUI.println((String)"OpenBCI_GUI: closing log file");
            this.closeLogFile();
        }
        this.fileoutput_odf = new OutputFile_rawtxt(this.getSampleRateSafe(), _fileName);
        this.output_fname = this.fileoutput_odf.fname;
        OpenBCI_GUI.println((String)("cyton: openNewLogFile: opened ODF output file: " + this.output_fname));
        this.output("cyton: openNewLogFile: opened ODF output file: " + this.output_fname);
    }

    public void playbackSelected(File selection) {
        if (selection == null) {
            OpenBCI_GUI.println((String)"DataLogging: playbackSelected: Window was closed or the user hit cancel.");
        } else {
            OpenBCI_GUI.println((String)("DataLogging: playbackSelected: User selected " + selection.getAbsolutePath()));
            this.output("You have selected \"" + selection.getAbsolutePath() + "\" for playback.");
            this.playbackData_fname = selection.getAbsolutePath();
        }
    }

    public void closeLogFile() {
        switch (this.outputDataSource) {
            case 1: {
                this.closeLogFileODF();
                break;
            }
            case 2: {
                this.closeLogFileBDF();
                break;
            }
        }
    }

    public void closeLogFileBDF() {
        if (this.fileoutput_bdf != null) {
            this.fileoutput_bdf.closeFile();
        }
    }

    public void closeLogFileODF() {
        if (this.fileoutput_odf != null) {
            this.fileoutput_odf.closeFile();
        }
    }

    public void fileSelected(File selection) {
        if (selection == null) {
            OpenBCI_GUI.println((String)"fileSelected: no selection so far...");
        } else {
            this.playbackData_fname = selection.getAbsolutePath();
        }
    }

    public String getDateString() {
        String fname = String.valueOf(OpenBCI_GUI.year()) + "-";
        if (OpenBCI_GUI.month() < 10) {
            fname = String.valueOf(fname) + "0";
        }
        fname = String.valueOf(fname) + OpenBCI_GUI.month() + "-";
        if (OpenBCI_GUI.day() < 10) {
            fname = String.valueOf(fname) + "0";
        }
        fname = String.valueOf(fname) + OpenBCI_GUI.day();
        fname = String.valueOf(fname) + "_";
        if (OpenBCI_GUI.hour() < 10) {
            fname = String.valueOf(fname) + "0";
        }
        fname = String.valueOf(fname) + OpenBCI_GUI.hour() + "-";
        if (OpenBCI_GUI.minute() < 10) {
            fname = String.valueOf(fname) + "0";
        }
        fname = String.valueOf(fname) + OpenBCI_GUI.minute() + "-";
        if (OpenBCI_GUI.second() < 10) {
            fname = String.valueOf(fname) + "0";
        }
        fname = String.valueOf(fname) + OpenBCI_GUI.second();
        return fname;
    }

    public void createPlaybackFileFromSD() {
        this.logFileName = "SavedData/SDconverted-" + this.getDateString() + ".csv";
        this.dataWriter = this.createWriter(this.logFileName);
        this.dataWriter.println("%OBCI SD Convert - " + this.getDateString());
        this.dataWriter.println("%");
        this.dataWriter.println("%Sample Rate = 250.0 Hz");
        this.dataWriter.println("%First Column = SampleIndex");
        this.dataWriter.println("%Last Column = Timestamp");
        this.dataWriter.println("%Other Columns = EEG data in microvolts followed by Accel Data (in G) interleaved with Aux Data");
    }

    public void sdFileSelected(File selection) {
        if (selection == null) {
            OpenBCI_GUI.println((String)"Window was closed or the user hit cancel.");
        } else {
            OpenBCI_GUI.println((String)("User selected " + selection.getAbsolutePath()));
            this.dataReader = this.createReader(selection.getAbsolutePath());
            this.controlPanel.convertingSD = true;
            OpenBCI_GUI.println((String)"Timing SD file conversion...");
            this.thatTime = this.millis();
        }
    }

    public void convertSDFile() {
        try {
            this.dataLine = this.dataReader.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.dataLine = null;
        }
        if (this.dataLine == null) {
            this.thisTime = (long)this.millis() - this.thatTime;
            this.controlPanel.convertingSD = false;
            OpenBCI_GUI.println((String)"nothing left in file");
            OpenBCI_GUI.println((String)("SD file conversion took " + this.thisTime + " mS"));
            this.outputSuccess("SD file converted to " + this.logFileName);
            this.dataWriter.flush();
            this.dataWriter.close();
        } else {
            this.hexNums = OpenBCI_GUI.splitTokens((String)this.dataLine, (String)",");
            if (this.hexNums[0].charAt(0) == '%') {
                OpenBCI_GUI.println((String)this.dataLine);
                this.printNextLine = true;
            } else {
                if (this.hexNums.length < 13) {
                    this.convert8channelLine();
                } else {
                    this.convert16channelLine();
                }
                if (this.printNextLine) {
                    this.printNextLine = false;
                }
            }
        }
    }

    public void convert16channelLine() {
        if (this.printNextLine) {
            int i = 0;
            while (i < this.hexNums.length) {
                this.h = this.hexNums[i];
                this.intData[i] = this.h.length() % 2 == 0 ? (float)OpenBCI_GUI.unhex((String)this.h) : 0.0f;
                this.dataWriter.print(this.intData[i]);
                OpenBCI_GUI.print((float)this.intData[i]);
                if (this.hexNums.length > 1) {
                    this.dataWriter.print(", ");
                    OpenBCI_GUI.print((String)", ");
                }
                ++i;
            }
            this.dataWriter.println();
            OpenBCI_GUI.println();
            return;
        }
        int i = 0;
        while (i < this.hexNums.length) {
            this.h = this.hexNums[i];
            if (i > 0) {
                this.h = this.h.charAt(0) > '7' ? "FF" + this.hexNums[i] : "00" + this.hexNums[i];
                if (i > 16) {
                    this.h = this.h.charAt(0) == 'F' ? "FF" + this.h : "00" + this.h;
                }
            }
            this.floatData[i] = this.h.length() % 2 == 0 ? (float)OpenBCI_GUI.unhex((String)this.h) : 0.0f;
            if (i >= 1 && i <= 16) {
                int n = i;
                this.floatData[n] = this.floatData[n] * this.cyton.get_scale_fac_uVolts_per_count();
            } else if (i != 0) {
                int n = i;
                this.floatData[n] = this.floatData[n] * this.cyton.get_scale_fac_accel_G_per_count();
            }
            if (i == 0) {
                this.dataWriter.print(PApplet.parseInt((float)this.floatData[i]));
            } else {
                this.dataWriter.print(this.floatData[i]);
            }
            if (i < this.hexNums.length - 1) {
                this.dataWriter.print(",");
            }
            ++i;
        }
        this.dataWriter.println();
    }

    public void convert8channelLine() {
        if (this.printNextLine) {
            int i = 0;
            while (i < this.hexNums.length) {
                this.h = this.hexNums[i];
                this.intData[i] = this.h.length() % 2 == 0 ? (float)OpenBCI_GUI.unhex((String)this.h) : 0.0f;
                OpenBCI_GUI.print((float)this.intData[i]);
                this.dataWriter.print(this.intData[i]);
                if (this.hexNums.length > 1) {
                    this.dataWriter.print(", ");
                    OpenBCI_GUI.print((String)", ");
                }
                ++i;
            }
            this.dataWriter.println();
            OpenBCI_GUI.println();
            return;
        }
        int i = 0;
        while (i < this.hexNums.length) {
            this.h = this.hexNums[i];
            if (i > 0) {
                this.h = this.h.charAt(0) > '7' ? "FF" + this.hexNums[i] : "00" + this.hexNums[i];
                if (i > 8) {
                    this.h = this.h.charAt(0) == 'F' ? "FF" + this.h : "00" + this.h;
                }
            }
            if (this.h.length() > 8) break;
            this.floatData[i] = this.h.length() % 2 == 0 ? (float)OpenBCI_GUI.unhex((String)this.h) : 0.0f;
            if (i >= 1 && i <= 8) {
                int n = i;
                this.floatData[n] = this.floatData[n] * this.cyton.get_scale_fac_uVolts_per_count();
            } else if (i != 0) {
                int n = i;
                this.floatData[n] = this.floatData[n] * this.cyton.get_scale_fac_accel_G_per_count();
            }
            if (i == 0) {
                this.dataWriter.print(PApplet.parseInt((float)this.floatData[i]));
            } else {
                this.dataWriter.print(this.floatData[i]);
            }
            if (i < this.hexNums.length - 1) {
                this.dataWriter.print(",");
            }
            ++i;
        }
        this.dataWriter.println();
    }

    public void process_input_file() throws Exception {
        this.processed_file = new HashMap();
        this.index_of_times = new HashMap();
        this.index_of_times_rev = new HashMap();
        float[][] localLittleBuff = new float[this.nchan][this.nPointsPerUpdate];
        try {
            while (!this.hasRepeated) {
                this.currentTableRowIndex = this.getPlaybackDataFromTable(this.playbackData_table, this.currentTableRowIndex, this.cyton.get_scale_fac_uVolts_per_count(), this.cyton.get_scale_fac_accel_G_per_count(), this.dataPacketBuff[this.lastReadDataPacketInd]);
                int Ichan = 0;
                while (Ichan < this.nchan) {
                    localLittleBuff[Ichan][this.pointCounter] = (float)this.dataPacketBuff[this.lastReadDataPacketInd].values[Ichan] * this.cyton.get_scale_fac_uVolts_per_count();
                    ++Ichan;
                }
                this.processed_file.put(this.curTimestamp, localLittleBuff);
                this.index_of_times.put(this.indices, this.curTimestamp);
                this.index_of_times_rev.put(this.curTimestamp, this.indices);
                ++this.indices;
            }
        }
        catch (Exception exception) {
            throw new Exception();
        }
        OpenBCI_GUI.println((String)"Finished filling hashmap");
        this.has_processed = true;
    }

    public int getDataIfAvailable(int pointCounter) {
        block13: {
            block14: {
                block12: {
                    if (this.eegDataSource != 0) break block12;
                    while (this.curDataPacketInd != this.lastReadDataPacketInd && pointCounter < this.nPointsPerUpdate) {
                        this.lastReadDataPacketInd = (this.lastReadDataPacketInd + 1) % this.dataPacketBuff.length;
                        int Ichan = 0;
                        while (Ichan < this.nchan) {
                            this.yLittleBuff_uV[Ichan][pointCounter] = (float)this.dataPacketBuff[this.lastReadDataPacketInd].values[Ichan] * this.cyton.get_scale_fac_uVolts_per_count();
                            ++Ichan;
                        }
                        int auxChan = 0;
                        while (auxChan < 3) {
                            this.auxBuff[auxChan][pointCounter] = this.dataPacketBuff[this.lastReadDataPacketInd].auxValues[auxChan];
                            ++auxChan;
                        }
                        ++pointCounter;
                    }
                    break block13;
                }
                if (this.eegDataSource != 1) break block14;
                while (this.curDataPacketInd != this.lastReadDataPacketInd && pointCounter < this.nPointsPerUpdate) {
                    this.lastReadDataPacketInd = (this.lastReadDataPacketInd + 1) % this.dataPacketBuff.length;
                    int Ichan = 0;
                    while (Ichan < this.nchan) {
                        this.yLittleBuff_uV[Ichan][pointCounter] = (float)this.dataPacketBuff[this.lastReadDataPacketInd].values[Ichan] * this.ganglion.get_scale_fac_uVolts_per_count();
                        ++Ichan;
                    }
                    ++pointCounter;
                }
                break block13;
            }
            int current_millis = this.millis();
            if (current_millis < this.nextPlayback_millis) break block13;
            int increment_millis = PApplet.parseInt((float)((float)OpenBCI_GUI.round((float)(PApplet.parseFloat((int)this.nPointsPerUpdate) * 1000.0f / this.getSampleRateSafe())) / this.playback_speed_fac));
            if (this.nextPlayback_millis < 0) {
                this.nextPlayback_millis = current_millis;
            }
            this.nextPlayback_millis += increment_millis;
            this.lastReadDataPacketInd = 0;
            int i = 0;
            while (i < this.nPointsPerUpdate) {
                ++this.dataPacketBuff[this.lastReadDataPacketInd].sampleIndex;
                switch (this.eegDataSource) {
                    case 3: {
                        this.synthesizeData(this.nchan, this.getSampleRateSafe(), this.cyton.get_scale_fac_uVolts_per_count(), this.dataPacketBuff[this.lastReadDataPacketInd]);
                        break;
                    }
                    case 2: {
                        this.currentTableRowIndex = this.getPlaybackDataFromTable(this.playbackData_table, this.currentTableRowIndex, this.cyton.get_scale_fac_uVolts_per_count(), this.cyton.get_scale_fac_accel_G_per_count(), this.dataPacketBuff[this.lastReadDataPacketInd]);
                    }
                }
                int Ichan = 0;
                while (Ichan < this.nchan) {
                    this.yLittleBuff_uV[Ichan][pointCounter] = (float)this.dataPacketBuff[this.lastReadDataPacketInd].values[Ichan] * this.cyton.get_scale_fac_uVolts_per_count();
                    ++Ichan;
                }
                ++pointCounter;
                ++i;
            }
        }
        return pointCounter;
    }

    public void processNewData() {
        float inst_byteRate_perSec = (int)(1000.0f * (float)(this.openBCI_byteCount - this.prevBytes) / (float)(this.millis() - this.prevMillis));
        this.prevMillis = this.millis();
        this.prevBytes = this.openBCI_byteCount;
        this.avgBitRate.addValue(inst_byteRate_perSec);
        this.byteRate_perSec = (int)this.avgBitRate.calcMean();
        int Ichan = 0;
        while (Ichan < this.nchan) {
            this.appendAndShift(this.dataBuffY_uV[Ichan], this.yLittleBuff_uV[Ichan]);
            this.dataBuffY_filtY_uV[Ichan] = (float[])this.dataBuffY_uV[Ichan].clone();
            ++Ichan;
        }
        this.dataProcessing.process(this.yLittleBuff_uV, this.dataBuffY_uV, this.dataBuffY_filtY_uV, this.fftBuff);
        this.dataProcessing_user.process(this.yLittleBuff_uV, this.dataBuffY_uV, this.dataBuffY_filtY_uV, this.fftBuff);
        this.dataProcessing.newDataToSend = true;
        Ichan = 0;
        while (Ichan < this.nchan) {
            this.is_railed[Ichan].update(this.dataPacketBuff[this.lastReadDataPacketInd].values[Ichan]);
            ++Ichan;
        }
        Ichan = 0;
        while (Ichan < this.nchan) {
            float impedance = OpenBCI_GUI.sqrt((float)2.0f) * this.dataProcessing.data_std_uV[Ichan] * 1.0E-6f / this.cyton.get_leadOffDrive_amps();
            if ((impedance -= this.cyton.get_series_resistor()) < 0.0f) {
                impedance = 0.0f;
            }
            this.data_elec_imp_ohm[Ichan] = impedance;
            ++Ichan;
        }
    }

    public void appendAndShift(float[] data, float[] newData) {
        int nshift = newData.length;
        int end = data.length - nshift;
        int i = 0;
        while (i < end) {
            data[i] = data[i + nshift];
            ++i;
        }
        i = 0;
        while (i < nshift) {
            data[end + i] = newData[i];
            ++i;
        }
    }

    public void appendAndShift(float[] data, float newData) {
        int nshift = 1;
        int end = data.length - nshift;
        int i = 0;
        while (i < end) {
            data[i] = data[i + nshift];
            ++i;
        }
        data[end] = newData;
    }

    public void synthesizeData(int nchan, float fs_Hz, float scale_fac_uVolts_per_count, DataPacket_ADS1299 curDataPacket) {
        int Ichan = 0;
        while (Ichan < nchan) {
            float val_uV;
            if (this.isChannelActive(Ichan)) {
                val_uV = this.randomGaussian() * OpenBCI_GUI.sqrt((float)(fs_Hz / 2.0f));
                if (Ichan == 0) {
                    val_uV *= 10.0f;
                }
                if (Ichan == 1) {
                    int n = Ichan;
                    this.sine_phase_rad[n] = this.sine_phase_rad[n] + 62.831856f / fs_Hz;
                    if (this.sine_phase_rad[Ichan] > (float)Math.PI * 2) {
                        int n2 = Ichan;
                        this.sine_phase_rad[n2] = this.sine_phase_rad[n2] - (float)Math.PI * 2;
                    }
                    val_uV += 10.0f * OpenBCI_GUI.sqrt((float)2.0f) * OpenBCI_GUI.sin((float)this.sine_phase_rad[Ichan]);
                } else if (Ichan == 2) {
                    int n = Ichan;
                    this.sine_phase_rad[n] = this.sine_phase_rad[n] + 314.15927f / fs_Hz;
                    if (this.sine_phase_rad[Ichan] > (float)Math.PI * 2) {
                        int n3 = Ichan;
                        this.sine_phase_rad[n3] = this.sine_phase_rad[n3] - (float)Math.PI * 2;
                    }
                    val_uV += 50.0f * OpenBCI_GUI.sqrt((float)2.0f) * OpenBCI_GUI.sin((float)this.sine_phase_rad[Ichan]);
                } else if (Ichan == 3) {
                    int n = Ichan;
                    this.sine_phase_rad[n] = this.sine_phase_rad[n] + 376.99112f / fs_Hz;
                    if (this.sine_phase_rad[Ichan] > (float)Math.PI * 2) {
                        int n4 = Ichan;
                        this.sine_phase_rad[n4] = this.sine_phase_rad[n4] - (float)Math.PI * 2;
                    }
                    val_uV += 50.0f * OpenBCI_GUI.sqrt((float)2.0f) * OpenBCI_GUI.sin((float)this.sine_phase_rad[Ichan]);
                }
            } else {
                val_uV = 0.0f;
            }
            curDataPacket.values[Ichan] = (int)(0.5f + val_uV / scale_fac_uVolts_per_count);
            ++Ichan;
        }
    }

    public void prepareData(float[] dataBuffX, float[][] dataBuffY_uV, float fs_Hz) {
        int xoffset = dataBuffX.length - 1;
        int i = 0;
        while (i < dataBuffX.length) {
            dataBuffX[i] = (float)(i - xoffset) / fs_Hz;
            int Ichan = 0;
            while (Ichan < this.nchan) {
                dataBuffY_uV[Ichan][i] = 0.0f;
                ++Ichan;
            }
            ++i;
        }
    }

    public void initializeFFTObjects(FFT[] fftBuff, float[][] dataBuffY_uV, int Nfft, float fs_Hz) {
        int Ichan = 0;
        while (Ichan < this.nchan) {
            fftBuff[Ichan].window(FFT.HAMMING);
            float[] fooData = this.isFFTFiltered ? this.dataBuffY_filtY_uV[Ichan] : dataBuffY_uV[Ichan];
            fooData = Arrays.copyOfRange(fooData, fooData.length - Nfft, fooData.length);
            fftBuff[Ichan].forward(fooData);
            ++Ichan;
        }
    }

    public int getPlaybackDataFromTable(Table datatable, int currentTableRowIndex, float scale_fac_uVolts_per_count, float scale_fac_accel_G_per_count, DataPacket_ADS1299 curDataPacket) {
        float val_uV = 0.0f;
        float[] acc_G = new float[this.n_aux_ifEnabled];
        boolean acc_newData = false;
        if (currentTableRowIndex >= datatable.getRowCount()) {
            OpenBCI_GUI.println((String)"OpenBCI_GUI: getPlaybackDataFromTable: hit the end of the playback data file.  starting over...");
            this.hasRepeated = true;
            currentTableRowIndex = 0;
        } else {
            int Iacc;
            TableRow row = datatable.getRow(currentTableRowIndex);
            ++currentTableRowIndex;
            int Ichan = 0;
            while (Ichan < this.nchan) {
                val_uV = this.isChannelActive(Ichan) && Ichan < datatable.getColumnCount() ? row.getFloat(Ichan) : 0.0f;
                curDataPacket.values[Ichan] = (int)(0.5f + val_uV / scale_fac_uVolts_per_count);
                ++Ichan;
            }
            try {
                Iacc = 0;
                while (Iacc < this.n_aux_ifEnabled) {
                    acc_G[Iacc] = Iacc < datatable.getColumnCount() ? row.getFloat(Iacc + this.nchan) : 0.0f;
                    curDataPacket.auxValues[Iacc] = (int)(0.5f + acc_G[Iacc] / scale_fac_accel_G_per_count);
                    if (acc_G[Iacc] != 0.0f) {
                        acc_newData = true;
                    }
                    ++Iacc;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
            if (acc_newData) {
                Iacc = 0;
                while (Iacc < this.n_aux_ifEnabled) {
                    this.appendAndShift(this.accelerometerBuff[Iacc], acc_G[Iacc]);
                    ++Iacc;
                }
            }
            if (!this.isOldData) {
                this.curTimestamp = row.getString(this.nchan + 3);
            }
            if (!this.isRunning) {
                try {
                    row.getString(this.nchan + 3);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    OpenBCI_GUI.println((Object)e);
                    OpenBCI_GUI.println((String)"8 Channel");
                }
            }
        }
        return currentTableRowIndex;
    }

    public void verbosePrint(String _string) {
        if (this.isVerbose) {
            OpenBCI_GUI.println((String)_string);
        }
    }

    public void delay(int delay) {
        int time = this.millis();
        while (this.millis() - time <= delay) {
        }
    }

    public void output(String _output) {
        this.output(_output, 0);
    }

    public void output(String _output, int level) {
        this.helpWidget.output(_output, level);
    }

    public void outputError(String _output) {
        this.output(_output, 4);
    }

    public void outputInfo(String _output) {
        this.output(_output, 1);
    }

    public void outputSuccess(String _output) {
        this.output(_output, 2);
    }

    public void outputWarn(String _output) {
        this.output(_output, 3);
    }

    public void signPost(String identifier) {
        if (this.printSignPosts) {
            this.millisSinceLastSignPost = (float)this.millis() - this.millisOfLastSignPost;
            OpenBCI_GUI.println((String)("SIGN POST: [" + identifier + "][" + this.millisSinceLastSignPost + "]"));
            this.millisOfLastSignPost = this.millis();
        }
    }

    public float std(float[] data) {
        float ave = this.mean(data);
        float val = 0.0f;
        int i = 0;
        while (i < data.length) {
            val += OpenBCI_GUI.pow((float)(data[i] - ave), (float)2.0f);
            ++i;
        }
        return (float)Math.sqrt(val /= (float)data.length);
    }

    public float mean(float[] data) {
        return this.mean(data, data.length);
    }

    public int medianDestructive(int[] data) {
        OpenBCI_GUI.sort((int[])data);
        int midPoint = data.length / 2;
        return data[midPoint];
    }

    public int findMax(float[] data) {
        float maxVal = data[0];
        int maxInd = 0;
        int I = 1;
        while (I < data.length) {
            if (data[I] > maxVal) {
                maxVal = data[I];
                maxInd = I;
            }
            ++I;
        }
        return maxInd;
    }

    public float mean(float[] data, int Nback) {
        return this.sum(data, Nback) / (float)Nback;
    }

    public float sum(float[] data) {
        return this.sum(data, data.length);
    }

    public float sum(float[] data, int Nback) {
        float sum = 0.0f;
        if (Nback > 0) {
            int i = data.length - Nback;
            while (i < data.length) {
                sum += data[i];
                ++i;
            }
        }
        return sum;
    }

    public float calcDotProduct(float[] data1, float[] data2) {
        int len = OpenBCI_GUI.min((int)data1.length, (int)data2.length);
        float val = 0.0f;
        int I = 0;
        while (I < len) {
            val += data1[I] * data2[I];
            ++I;
        }
        return val;
    }

    public float log10(float val) {
        return (float)Math.log10(val);
    }

    public float filterWEA_1stOrderIIR(float[] filty, float learn_fac, float filt_state) {
        float prev = filt_state;
        int i = 0;
        while (i < filty.length) {
            filty[i] = prev * (1.0f - learn_fac) + filty[i] * learn_fac;
            prev = filty[i];
            ++i;
        }
        return prev;
    }

    public void filterIIR(double[] filt_b, double[] filt_a, float[] data) {
        int Nback = filt_b.length;
        double[] prev_y = new double[Nback];
        double[] prev_x = new double[Nback];
        int i = 0;
        while (i < data.length) {
            int j = Nback - 1;
            while (j > 0) {
                prev_y[j] = prev_y[j - 1];
                prev_x[j] = prev_x[j - 1];
                --j;
            }
            prev_x[0] = data[i];
            double out = 0.0;
            int j2 = 0;
            while (j2 < Nback) {
                out += filt_b[j2] * prev_x[j2];
                if (j2 > 0) {
                    out -= filt_a[j2] * prev_y[j2];
                }
                ++j2;
            }
            prev_y[0] = out;
            data[i] = (float)out;
            ++i;
        }
    }

    public void removeMean(float[] filty, int Nback) {
        float meanVal = this.mean(filty, Nback);
        int i = 0;
        while (i < filty.length) {
            int n = i++;
            filty[n] = filty[n] - meanVal;
        }
    }

    public void rereferenceTheMontage(float[][] data) {
        int n_chan = data.length;
        int n_points = data[0].length;
        int Ipoint = 0;
        while (Ipoint < n_points) {
            float sum = 0.0f;
            int Ichan = 0;
            while (Ichan < n_chan) {
                sum += data[Ichan][Ipoint];
                ++Ichan;
            }
            float mean = sum / (float)n_chan;
            Ichan = 0;
            while (Ichan < n_chan) {
                float[] fArray = data[Ichan];
                int n = Ipoint;
                fArray[n] = fArray[n] - mean;
                ++Ichan;
            }
            ++Ipoint;
        }
    }

    public void updateChannelArrays(int _nchan) {
        this.channelSettingValues = new char[_nchan][this.numSettingsPerChannel];
        this.impedanceCheckValues = new char[_nchan][2];
    }

    public void activateChannel(int Ichan) {
        OpenBCI_GUI.println((String)("OpenBCI_GUI: activating channel " + (Ichan + 1)));
        if (this.eegDataSource == 0) {
            if (this.cyton.isPortOpen()) {
                this.verbosePrint("**");
                this.cyton.changeChannelState(Ichan, true);
            }
        } else if (this.eegDataSource == 1) {
            this.ganglion.changeChannelState(Ichan, true);
        }
        if (Ichan < this.nchan) {
            this.channelSettingValues[Ichan][0] = 48;
        }
    }

    public void deactivateChannel(int Ichan) {
        OpenBCI_GUI.println((String)("OpenBCI_GUI: deactivating channel " + (Ichan + 1)));
        if (this.eegDataSource == 0) {
            if (this.cyton.isPortOpen()) {
                this.verbosePrint("**");
                this.cyton.changeChannelState(Ichan, false);
            }
        } else if (this.eegDataSource == 1) {
            this.ganglion.changeChannelState(Ichan, false);
        }
        if (Ichan < this.nchan) {
            this.channelSettingValues[Ichan][0] = 49;
        }
    }

    public boolean isChannelActive(int Ichan) {
        boolean return_val = false;
        return_val = this.channelSettingValues[Ichan][0] != '1';
        return return_val;
    }

    public void keyPressed() {
        if (!this.controlPanel.isOpen && !this.isNetworkingTextActive()) {
            if (PApplet.parseInt((char)this.key) >= 32 && PApplet.parseInt((char)this.key) <= 126) {
                this.parseKey(this.key);
            } else {
                this.parseKeycode(this.keyCode);
            }
        }
        if (this.key == '\u001b') {
            this.key = '\u0000';
        }
    }

    public void parseKey(char val) {
        switch (val) {
            case ' ': {
                this.stopButtonWasPressed();
                break;
            }
            case '.': {
                if (this.drawEMG) {
                    this.drawAccel = true;
                    this.drawPulse = false;
                    this.drawHead = false;
                    this.drawEMG = false;
                    break;
                }
                if (this.drawAccel) {
                    this.drawAccel = false;
                    this.drawPulse = true;
                    this.drawHead = false;
                    this.drawEMG = false;
                    break;
                }
                if (this.drawPulse) {
                    this.drawAccel = false;
                    this.drawPulse = false;
                    this.drawHead = true;
                    this.drawEMG = false;
                    break;
                }
                if (!this.drawHead) break;
                this.drawAccel = false;
                this.drawPulse = false;
                this.drawHead = false;
                this.drawEMG = true;
                break;
            }
            case ',': {
                this.drawContainers = !this.drawContainers;
                break;
            }
            case '<': {
                this.w_timeSeries.setUpdating(!this.w_timeSeries.isUpdating());
                break;
            }
            case '>': {
                if (this.eegDataSource != 1) break;
                this.ganglion.enterBootloaderMode();
                break;
            }
            case '{': {
                if (this.colorScheme == this.COLOR_SCHEME_DEFAULT) {
                    this.colorScheme = this.COLOR_SCHEME_ALTERNATIVE_A;
                } else if (this.colorScheme == this.COLOR_SCHEME_ALTERNATIVE_A) {
                    this.colorScheme = this.COLOR_SCHEME_DEFAULT;
                }
                this.topNav.updateNavButtonsBasedOnColorScheme();
                OpenBCI_GUI.println((String)"Changing color scheme.");
                break;
            }
            case '/': {
                this.drawAccel = !this.drawAccel;
                this.drawPulse = !this.drawPulse;
                break;
            }
            case '\\': {
                this.drawFFT = !this.drawFFT;
                this.drawBionics = !this.drawBionics;
                break;
            }
            case '1': {
                this.deactivateChannel(0);
                break;
            }
            case '2': {
                this.deactivateChannel(1);
                break;
            }
            case '3': {
                this.deactivateChannel(2);
                break;
            }
            case '4': {
                this.deactivateChannel(3);
                break;
            }
            case '5': {
                this.deactivateChannel(4);
                break;
            }
            case '6': {
                this.deactivateChannel(5);
                break;
            }
            case '7': {
                this.deactivateChannel(6);
                break;
            }
            case '8': {
                this.deactivateChannel(7);
                break;
            }
            case 'q': {
                if (this.nchan != 16) break;
                this.deactivateChannel(8);
                break;
            }
            case 'w': {
                if (this.nchan != 16) break;
                this.deactivateChannel(9);
                break;
            }
            case 'e': {
                if (this.nchan != 16) break;
                this.deactivateChannel(10);
                break;
            }
            case 'r': {
                if (this.nchan != 16) break;
                this.deactivateChannel(11);
                break;
            }
            case 't': {
                if (this.nchan != 16) break;
                this.deactivateChannel(12);
                break;
            }
            case 'y': {
                if (this.nchan != 16) break;
                this.deactivateChannel(13);
                break;
            }
            case 'u': {
                if (this.nchan != 16) break;
                this.deactivateChannel(14);
                break;
            }
            case 'i': {
                if (this.nchan != 16) break;
                this.deactivateChannel(15);
                break;
            }
            case ':': {
                OpenBCI_GUI.println((String)"test...");
                this.isNetworkingTextActive();
                break;
            }
            case '!': {
                this.activateChannel(0);
                break;
            }
            case '@': {
                this.activateChannel(1);
                break;
            }
            case '#': {
                this.activateChannel(2);
                break;
            }
            case '$': {
                this.activateChannel(3);
                break;
            }
            case '%': {
                this.activateChannel(4);
                break;
            }
            case '^': {
                this.activateChannel(5);
                break;
            }
            case '&': {
                this.activateChannel(6);
                break;
            }
            case '*': {
                this.activateChannel(7);
                break;
            }
            case 'Q': {
                if (this.nchan != 16) break;
                this.activateChannel(8);
                break;
            }
            case 'W': {
                if (this.nchan != 16) break;
                this.activateChannel(9);
                break;
            }
            case 'E': {
                if (this.nchan != 16) break;
                this.activateChannel(10);
                break;
            }
            case 'R': {
                if (this.nchan != 16) break;
                this.activateChannel(11);
                break;
            }
            case 'T': {
                if (this.nchan != 16) break;
                this.activateChannel(12);
                break;
            }
            case 'Y': {
                if (this.nchan != 16) break;
                this.activateChannel(13);
                break;
            }
            case 'U': {
                if (this.nchan != 16) break;
                this.activateChannel(14);
                break;
            }
            case 'I': {
                if (this.nchan != 16) break;
                this.activateChannel(15);
                break;
            }
            case 's': {
                OpenBCI_GUI.println((String)"case s...");
                this.stopRunning();
                break;
            }
            case 'b': {
                OpenBCI_GUI.println((String)"case b...");
                this.startRunning();
                break;
            }
            case 'n': {
                OpenBCI_GUI.println((String)("cyton: " + this.cyton));
                break;
            }
            case '?': {
                this.cyton.printRegisters();
                break;
            }
            case 'd': {
                this.verbosePrint("Updating GUI's channel settings to default...");
                this.w_timeSeries.hsc.loadDefaultChannelSettings();
                this.cyton.configureAllChannelsToDefault();
                break;
            }
            case 'm': {
                String picfname = "OpenBCI-" + this.getDateString() + ".jpg";
                OpenBCI_GUI.println((String)("OpenBCI_GUI: 'm' was pressed...taking screenshot:" + picfname));
                this.saveFrame("./SavedData/" + picfname);
                break;
            }
            default: {
                if (this.eegDataSource == 0) {
                    OpenBCI_GUI.println((String)("Interactivity: '" + this.key + "' Pressed...sending to Cyton..."));
                    this.cyton.write(this.key);
                    break;
                }
                if (this.eegDataSource != 1) break;
                OpenBCI_GUI.println((String)("Interactivity: '" + this.key + "' Pressed...sending to Ganglion..."));
                this.hub.sendCommand(this.key);
            }
        }
    }

    public void parseKeycode(int val) {
        switch (val) {
            case 8: {
                OpenBCI_GUI.println((String)("OpenBCI_GUI: parseKeycode(" + val + "): received BACKSPACE keypress.  Ignoring..."));
                break;
            }
            case 9: {
                OpenBCI_GUI.println((String)("OpenBCI_GUI: parseKeycode(" + val + "): received TAB keypress.  Ignoring..."));
                break;
            }
            case 10: {
                OpenBCI_GUI.println((String)"Enter was pressed.");
                this.drawPresentation = !this.drawPresentation;
                break;
            }
            case 16: {
                OpenBCI_GUI.println((String)("OpenBCI_GUI: parseKeycode(" + val + "): received SHIFT keypress.  Ignoring..."));
                break;
            }
            case 17: {
                break;
            }
            case 18: {
                OpenBCI_GUI.println((String)("OpenBCI_GUI: parseKeycode(" + val + "): received ALT keypress.  Ignoring..."));
                break;
            }
            case 20: {
                OpenBCI_GUI.println((String)("OpenBCI_GUI: parseKeycode(" + val + "): received CAPS LOCK keypress.  Ignoring..."));
                break;
            }
            case 27: {
                OpenBCI_GUI.println((String)("OpenBCI_GUI: parseKeycode(" + val + "): received ESC keypress.  Stopping OpenBCI..."));
                break;
            }
            case 33: {
                OpenBCI_GUI.println((String)("OpenBCI_GUI: parseKeycode(" + val + "): received PAGE UP keypress.  Ignoring..."));
                break;
            }
            case 34: {
                OpenBCI_GUI.println((String)("OpenBCI_GUI: parseKeycode(" + val + "): received PAGE DOWN keypress.  Ignoring..."));
                break;
            }
            case 35: {
                OpenBCI_GUI.println((String)("OpenBCI_GUI: parseKeycode(" + val + "): received END keypress.  Ignoring..."));
                break;
            }
            case 36: {
                OpenBCI_GUI.println((String)("OpenBCI_GUI: parseKeycode(" + val + "): received HOME keypress.  Ignoring..."));
                break;
            }
            case 37: {
                if (!((float)this.millis() - this.myPresentation.timeOfLastSlideChange >= 250.0f) || this.myPresentation.currentSlide < 0) break;
                this.myPresentation.slideBack();
                this.myPresentation.timeOfLastSlideChange = this.millis();
                break;
            }
            case 38: {
                OpenBCI_GUI.println((String)("OpenBCI_GUI: parseKeycode(" + val + "): received UP ARROW keypress.  Ignoring..."));
                this.dataProcessing_user.switchesActive = true;
                break;
            }
            case 39: {
                if (!((float)this.millis() - this.myPresentation.timeOfLastSlideChange >= 250.0f) || this.myPresentation.currentSlide >= this.myPresentation.presentationSlides.length - 1) break;
                this.myPresentation.slideForward();
                this.myPresentation.timeOfLastSlideChange = this.millis();
                break;
            }
            case 40: {
                OpenBCI_GUI.println((String)("OpenBCI_GUI: parseKeycode(" + val + "): received DOWN ARROW keypress.  Ignoring..."));
                this.dataProcessing_user.switchesActive = false;
                break;
            }
            case 112: {
                OpenBCI_GUI.println((String)("OpenBCI_GUI: parseKeycode(" + val + "): received F1 keypress.  Ignoring..."));
                break;
            }
            case 113: {
                OpenBCI_GUI.println((String)("OpenBCI_GUI: parseKeycode(" + val + "): received F2 keypress.  Ignoring..."));
                break;
            }
            case 114: {
                OpenBCI_GUI.println((String)("OpenBCI_GUI: parseKeycode(" + val + "): received F3 keypress.  Ignoring..."));
                break;
            }
            case 115: {
                OpenBCI_GUI.println((String)("OpenBCI_GUI: parseKeycode(" + val + "): received F4 keypress.  Ignoring..."));
                break;
            }
            case 116: {
                OpenBCI_GUI.println((String)("OpenBCI_GUI: parseKeycode(" + val + "): received F5 keypress.  Ignoring..."));
                break;
            }
            case 117: {
                OpenBCI_GUI.println((String)("OpenBCI_GUI: parseKeycode(" + val + "): received F6 keypress.  Ignoring..."));
                break;
            }
            case 118: {
                OpenBCI_GUI.println((String)("OpenBCI_GUI: parseKeycode(" + val + "): received F7 keypress.  Ignoring..."));
                break;
            }
            case 119: {
                OpenBCI_GUI.println((String)("OpenBCI_GUI: parseKeycode(" + val + "): received F8 keypress.  Ignoring..."));
                break;
            }
            case 120: {
                OpenBCI_GUI.println((String)("OpenBCI_GUI: parseKeycode(" + val + "): received F9 keypress.  Ignoring..."));
                break;
            }
            case 121: {
                OpenBCI_GUI.println((String)("OpenBCI_GUI: parseKeycode(" + val + "): received F10 keypress.  Ignoring..."));
                break;
            }
            case 122: {
                OpenBCI_GUI.println((String)("OpenBCI_GUI: parseKeycode(" + val + "): received F11 keypress.  Ignoring..."));
                break;
            }
            case 123: {
                OpenBCI_GUI.println((String)("OpenBCI_GUI: parseKeycode(" + val + "): received F12 keypress.  Ignoring..."));
                break;
            }
            case 127: {
                OpenBCI_GUI.println((String)("OpenBCI_GUI: parseKeycode(" + val + "): received DELETE keypress.  Ignoring..."));
                break;
            }
            case 155: {
                OpenBCI_GUI.println((String)("OpenBCI_GUI: parseKeycode(" + val + "): received INSERT keypress.  Ignoring..."));
                break;
            }
            default: {
                OpenBCI_GUI.println((String)("OpenBCI_GUI: parseKeycode(" + val + "): value is not known.  Ignoring..."));
            }
        }
    }

    public void mouseDragged() {
        if (this.systemMode >= 10 && !this.controlPanel.isOpen) {
            this.wm.mouseDragged();
        }
    }

    public void mousePressed() {
        if (this.systemMode >= 10 && !this.controlPanel.isOpen) {
            this.wm.mousePressed();
        }
        this.topNav.mousePressed();
        if (this.controlPanel.isOpen && this.systemMode == 10) {
            if (this.mouseX > 0 && this.mouseX < this.controlPanel.w && this.mouseY > 0 && this.mouseY < this.controlPanel.initBox.y + this.controlPanel.initBox.h) {
                OpenBCI_GUI.println((String)"OpenBCI_GUI: mousePressed: clicked in CP box");
                this.controlPanel.CPmousePressed();
            } else {
                OpenBCI_GUI.println((String)"OpenBCI_GUI: mousePressed: outside of CP clicked");
                this.controlPanel.isOpen = false;
                this.topNav.controlPanelCollapser.setIsActive(false);
                this.output("Press the \"Press to Start\" button to initialize the data stream.");
            }
        }
        this.redrawScreenNow = true;
        if (this.playground.isMouseHere()) {
            this.playground.mousePressed();
        }
        if (this.playground.isMouseInButton()) {
            this.playground.toggleWindow();
        }
    }

    public void mouseReleased() {
        if (this.controlPanel.isOpen) {
            this.controlPanel.CPmouseReleased();
        }
        this.topNav.mouseReleased();
        if (this.systemMode >= 10) {
            this.wm.mouseReleased();
            this.redrawScreenNow = true;
        }
        if (this.screenHasBeenResized) {
            OpenBCI_GUI.println((String)"OpenBCI_GUI: mouseReleased: screen has been resized...");
            this.screenHasBeenResized = false;
        }
        if (this.playground.isMouseHere()) {
            this.playground.mouseReleased();
        }
        this.playground.isMouseInButton();
    }

    public void openURLInBrowser(String _url) {
        try {
            String url = _url;
            Desktop.getDesktop().browse(URI.create(url));
            this.output("Attempting to use your default browser to launch: " + url);
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }

    public void toggleFrameRate() {
        this.frameRateCounter = this.frameRateCounter < 3 ? ++this.frameRateCounter : 1;
        if (this.frameRateCounter == 0) {
            this.frameRate(24.0f);
            this.topNav.fpsButton.setString("24 fps");
        }
        if (this.frameRateCounter == 1) {
            this.frameRate(30.0f);
            this.topNav.fpsButton.setString("30 fps");
        }
        if (this.frameRateCounter == 2) {
            this.frameRate(45.0f);
            this.topNav.fpsButton.setString("45 fps");
        }
        if (this.frameRateCounter == 3) {
            this.frameRate(60.0f);
            this.topNav.fpsButton.setString("60 fps");
        }
    }

    public boolean isNetworkingTextActive() {
        boolean isAFieldActive = false;
        if (this.w_networking != null) {
            int numTextFields = this.w_networking.cp5_networking.getAll(Textfield.class).size();
            int i = 0;
            while (i < numTextFields) {
                if (((Textfield)this.w_networking.cp5_networking.getAll(Textfield.class).get(i)).isFocus()) {
                    isAFieldActive = true;
                }
                ++i;
            }
        }
        OpenBCI_GUI.println((boolean)isAFieldActive);
        return isAFieldActive;
    }

    public void toggleHighDPI() {
        this.highDPI = !this.highDPI;
        OpenBCI_GUI.println((String)("High DPI? " + this.highDPI));
    }

    public void clientEvent(Client someClient) {
        char newChar = this.hub.tcpClient.readChar();
        while (newChar != '\uffff') {
            String posMatch;
            int p = this.hub.tcpBufferPositon++;
            this.hub.tcpBuffer[p] = newChar;
            if (p > 2 && (posMatch = new String(this.hub.tcpBuffer, p - 2, 3)).equals(TCP_STOP)) {
                if (!this.hub.nodeProcessHandshakeComplete) {
                    this.hub.nodeProcessHandshakeComplete = true;
                    this.hub.setHubIsRunning(true);
                    OpenBCI_GUI.println((String)"Hub: clientEvent: handshake complete");
                }
                String msg = new String(this.hub.tcpBuffer, 0, p);
                if (this.eegDataSource == 1) {
                    this.hub.parseMessage(msg);
                    if (this.hub.deviceListUpdated) {
                        this.hub.deviceListUpdated = false;
                        if (this.ganglion.isBLE()) {
                            this.controlPanel.bleBox.refreshBLEList();
                        } else {
                            this.controlPanel.wifiBox.refreshWifiList();
                        }
                    }
                } else if (this.eegDataSource == 0) {
                    this.hub.parseMessage(msg);
                    if (this.hub.deviceListUpdated) {
                        this.hub.deviceListUpdated = false;
                        this.controlPanel.wifiBox.refreshWifiList();
                    }
                }
                this.hub.tcpBufferPositon = 0;
            }
            newChar = this.hub.tcpClient.readChar();
        }
    }

    public void serialEvent(Serial port) {
        if (this.iSerial.isOpenBCISerial(port)) {
            boolean echoBytes = !this.iSerial.isStateNormal();
            this.iSerial.read(echoBytes);
            ++this.openBCI_byteCount;
            if (this.iSerial.get_isNewDataPacketAvailable()) {
                OpenBCI_GUI.println((String)"woo got a new packet");
                this.curDataPacketInd = (this.curDataPacketInd + 1) % this.dataPacketBuff.length;
                this.cyton.copyDataPacketTo(this.dataPacketBuff[this.curDataPacketInd]);
                this.iSerial.set_isNewDataPacketAvailable(false);
                if (this.werePacketsDroppedSerial) {
                    int i = this.numPacketsDroppedSerial;
                    while (i > 0) {
                        int tempDataPacketInd = this.curDataPacketInd - i;
                        if (tempDataPacketInd >= 0 && tempDataPacketInd < this.dataPacketBuff.length) {
                            this.cyton.copyDataPacketTo(this.dataPacketBuff[tempDataPacketInd]);
                        } else {
                            this.cyton.copyDataPacketTo(this.dataPacketBuff[tempDataPacketInd + 255]);
                        }
                        --i;
                    }
                    this.werePacketsDroppedSerial = false;
                    this.numPacketsDroppedSerial = 0;
                }
                switch (this.outputDataSource) {
                    case 1: {
                        this.fileoutput_odf.writeRawData_dataPacket(this.dataPacketBuff[this.curDataPacketInd], this.cyton.get_scale_fac_uVolts_per_count(), this.cyton.get_scale_fac_accel_G_per_count(), PApplet.parseByte((int)192));
                        break;
                    }
                    case 2: {
                        this.curBDFDataPacketInd = this.curDataPacketInd;
                        this.thread("writeRawData_dataPacket_bdf");
                        break;
                    }
                }
                ++this.newPacketCounter;
            }
        } else if (this.no_start_connection) {
            if (this.board_message == null || this.dollaBillz > 2) {
                this.board_message = new StringBuilder();
                this.dollaBillz = 0;
            }
            this.inByte = PApplet.parseByte((int)port.read());
            OpenBCI_GUI.print((byte)this.inByte);
            if (PApplet.parseChar((byte)this.inByte) == 'S' || PApplet.parseChar((byte)this.inByte) == 'F') {
                this.isOpenBCI = true;
            }
            if (this.inByte != -1) {
                if (this.isGettingPoll) {
                    if (this.inByte != 36) {
                        if (!this.spaceFound) {
                            this.board_message.append(PApplet.parseChar((byte)this.inByte));
                        } else {
                            this.hexToInt = Integer.parseInt(String.format("%02X", this.inByte), 16);
                        }
                        if (PApplet.parseChar((byte)this.inByte) == ' ') {
                            this.spaceFound = true;
                        }
                    } else {
                        ++this.dollaBillz;
                    }
                } else if (this.inByte != 36) {
                    this.board_message.append(PApplet.parseChar((byte)this.inByte));
                } else {
                    ++this.dollaBillz;
                }
            }
        } else {
            this.inByte = PApplet.parseByte((int)port.read());
            if (this.isOpenBCI) {
                if (this.board_message == null || this.dollaBillz > 2) {
                    this.board_message = new StringBuilder();
                    this.dollaBillz = 0;
                }
                if (this.inByte != 36) {
                    this.board_message.append(PApplet.parseChar((byte)this.inByte));
                } else {
                    ++this.dollaBillz;
                }
            } else if (PApplet.parseChar((byte)this.inByte) == 'S' || PApplet.parseChar((byte)this.inByte) == 'F') {
                this.isOpenBCI = true;
                if (this.board_message == null) {
                    this.board_message = new StringBuilder();
                    this.board_message.append(PApplet.parseChar((byte)this.inByte));
                }
            }
        }
    }

    public void autoconnect() {
        String[] serialPorts = new String[Serial.list().length];
        String serialPort = "";
        serialPorts = Serial.list();
        int i = 0;
        while (i < serialPorts.length) {
            try {
                serialPort = serialPorts[i];
                this.board = new Serial((PApplet)this, serialPort, 115200);
                OpenBCI_GUI.print((String)"blasss try ");
                OpenBCI_GUI.print((int)i);
                OpenBCI_GUI.print((String)" ");
                OpenBCI_GUI.print((String)serialPort);
                OpenBCI_GUI.println((String)" at 115200 baud");
                this.output("Attempting to connect at 115200 baud to " + serialPort);
                this.delay(5000);
                this.board.write(118);
                this.delay(2000);
                if (this.confirm_openbci()) {
                    OpenBCI_GUI.println((String)("Board connected on port " + serialPorts[i] + " with BAUD 115200"));
                    this.output("Connected to " + serialPort + "!");
                    this.openBCI_portName = serialPorts[i];
                    this.openBCI_baud = 115200;
                    this.board.stop();
                    return;
                }
                OpenBCI_GUI.println((String)("Board not on port " + serialPorts[i] + " with BAUD 115200"));
                this.board.stop();
            }
            catch (Exception e) {
                OpenBCI_GUI.println((String)("Exception " + serialPorts[i] + " " + e));
            }
            try {
                this.board = new Serial((PApplet)this, serialPort, 230400);
                OpenBCI_GUI.print((String)"try ");
                OpenBCI_GUI.print((int)i);
                OpenBCI_GUI.print((String)" ");
                OpenBCI_GUI.print((String)serialPort);
                OpenBCI_GUI.println((String)" at 230400 baud");
                this.output("Attempting to connect at 230400 baud to " + serialPort);
                this.delay(5000);
                this.board.write(118);
                this.delay(2000);
                if (this.confirm_openbci()) {
                    OpenBCI_GUI.println((String)("Board connected on port " + serialPorts[i] + " with BAUD 230400"));
                    this.output("Connected to " + serialPort + "!");
                    this.openBCI_baud = 230400;
                    this.openBCI_portName = serialPorts[i];
                    this.board.stop();
                    return;
                }
                OpenBCI_GUI.println((String)("Board not on port " + serialPorts[i] + " with BAUD 230400"));
                this.board.stop();
            }
            catch (Exception e) {
                OpenBCI_GUI.println((String)("Exception " + serialPorts[i] + " " + e));
            }
            ++i;
        }
    }

    public boolean confirm_openbci() {
        return this.board_message != null && this.board_message.toString().toLowerCase().contains("ads");
    }

    public boolean confirm_openbci_v2() {
        return this.board_message.toString().toLowerCase().contains("success");
    }

    public boolean confirm_connected() {
        return this.board_message != null && this.board_message.toString().toLowerCase().contains("success");
    }

    public boolean print_bytes(RadioConfigBox rc) {
        if (this.board_message != null) {
            OpenBCI_GUI.println((String)this.board_message.toString());
            rc.print_onscreen(this.board_message.toString());
            return true;
        }
        return false;
    }

    public void print_bytes_error(RadioConfigBox rcConfig) {
        OpenBCI_GUI.println((String)"Error reading from Serial/COM port");
        rcConfig.print_onscreen("Error reading from Serial port. Try a different port?");
        this.board = null;
    }

    public boolean connect_to_portName(RadioConfigBox rcConfig) {
        if (this.openBCI_portName != "N/A") {
            this.output("Attempting to open Serial/COM port: " + this.openBCI_portName);
            try {
                OpenBCI_GUI.println((String)("Radios_Config: connect_to_portName: attempting to open serial port: " + this.openBCI_portName));
                this.serial_output = new Serial((PApplet)this, this.openBCI_portName, this.openBCI_baud);
                this.serial_output.clear();
                OpenBCI_GUI.println((String)"Radios_Config: connect_to_portName: port is open!");
                this.board = this.serial_output;
                return true;
            }
            catch (RuntimeException e) {
                if (e.getMessage().contains("<init>")) {
                    this.serial_output = null;
                    System.out.println("Radios_Config: connect_to_portName: port in use, trying again later...");
                } else {
                    OpenBCI_GUI.println((String)("RunttimeException: " + e));
                    this.output("Error connecting to selected Serial/COM port. Make sure your board is powered up and your dongle is plugged in.");
                    rcConfig.print_onscreen("Error connecting to Serial port. Try a different port?");
                }
                this.board = null;
                OpenBCI_GUI.println((String)("Radios_Config: connect_to_portName: failed to connect to " + this.openBCI_portName));
                return false;
            }
        }
        this.output("No Serial/COM port selected. Please select your Serial/COM port and retry");
        rcConfig.print_onscreen("Select a Serial/COM port, then try again");
        return false;
    }

    public void system_status(RadioConfigBox rcConfig) {
        OpenBCI_GUI.println((String)"Radios_Config: system_status");
        if (this.board == null && !this.connect_to_portName(rcConfig)) {
            return;
        }
        if (this.board != null) {
            this.board.write(240);
            this.board.write(7);
            this.delay(100);
            if (!this.print_bytes(rcConfig)) {
                this.print_bytes_error(rcConfig);
            }
        } else {
            OpenBCI_GUI.println((String)"Error, no board connected");
            rcConfig.print_onscreen("No board connected!");
        }
    }

    public void scan_channels(RadioConfigBox rcConfig) {
        OpenBCI_GUI.println((String)"Radios_Config: scan_channels");
        if (this.board == null && !this.connect_to_portName(rcConfig)) {
            return;
        }
        int i = 1;
        while (i < 26) {
            this.set_channel_over(rcConfig, i);
            this.system_status(rcConfig);
            if (this.confirm_connected()) {
                return;
            }
            ++i;
        }
    }

    public void get_channel(RadioConfigBox rcConfig) {
        OpenBCI_GUI.println((String)"Radios_Config: get_channel");
        if (this.board == null && !this.connect_to_portName(rcConfig)) {
            return;
        }
        if (this.board != null) {
            this.board.write(240);
            this.board.write(0);
            this.delay(100);
            if (!this.print_bytes(rcConfig)) {
                this.print_bytes_error(rcConfig);
            }
        } else {
            OpenBCI_GUI.println((String)"Error, no board connected");
            rcConfig.print_onscreen("No board connected!");
        }
    }

    public void set_channel(RadioConfigBox rcConfig, int channel_number) {
        OpenBCI_GUI.println((String)"Radios_Config: set_channel");
        if (this.board == null && !this.connect_to_portName(rcConfig)) {
            return;
        }
        if (this.board != null) {
            if (channel_number > 0) {
                this.board.write(240);
                this.board.write(1);
                this.board.write((int)PApplet.parseByte((int)channel_number));
                this.delay(1000);
                if (!this.print_bytes(rcConfig)) {
                    this.print_bytes_error(rcConfig);
                }
            } else {
                rcConfig.print_onscreen("Please Select a Channel");
            }
        } else {
            OpenBCI_GUI.println((String)"Error, no board connected");
            rcConfig.print_onscreen("No board connected!");
        }
    }

    public void set_channel_over(RadioConfigBox rcConfig, int channel_number) {
        OpenBCI_GUI.println((String)"Radios_Config: set_ovr_channel");
        if (this.board == null && !this.connect_to_portName(rcConfig)) {
            return;
        }
        if (this.board != null) {
            if (channel_number > 0) {
                this.board.write(240);
                this.board.write(2);
                this.board.write((int)PApplet.parseByte((int)channel_number));
                this.delay(100);
                if (!this.print_bytes(rcConfig)) {
                    this.print_bytes_error(rcConfig);
                }
            } else {
                rcConfig.print_onscreen("Please Select a Channel");
            }
        } else {
            OpenBCI_GUI.println((String)"Error, no board connected");
            rcConfig.print_onscreen("No board connected!");
        }
    }

    public void incrementFilterConfiguration() {
        this.dataProcessing.incrementFilterConfiguration();
        this.topNav.filtBPButton.but_txt = "BP Filt\n" + this.dataProcessing.getShortFilterDescription();
    }

    public void incrementNotchConfiguration() {
        this.dataProcessing.incrementNotchConfiguration();
        this.topNav.filtNotchButton.but_txt = "Notch\n" + this.dataProcessing.getShortNotchDescription();
    }

    public void VertScale_AR(int n) {
        if (n == 0) {
            int i = 0;
            while (i < this.w_analogRead.numAnalogReadBars) {
                this.w_analogRead.analogReadBars[i].adjustVertScale(0);
                ++i;
            }
        } else if (n == 1) {
            int i = 0;
            while (i < this.w_analogRead.numAnalogReadBars) {
                this.w_analogRead.analogReadBars[i].adjustVertScale(50);
                ++i;
            }
        } else if (n == 2) {
            int i = 0;
            while (i < this.w_analogRead.numAnalogReadBars) {
                this.w_analogRead.analogReadBars[i].adjustVertScale(100);
                ++i;
            }
        } else if (n == 3) {
            int i = 0;
            while (i < this.w_analogRead.numAnalogReadBars) {
                this.w_analogRead.analogReadBars[i].adjustVertScale(200);
                ++i;
            }
        } else if (n == 4) {
            int i = 0;
            while (i < this.w_analogRead.numAnalogReadBars) {
                this.w_analogRead.analogReadBars[i].adjustVertScale(400);
                ++i;
            }
        } else if (n == 5) {
            int i = 0;
            while (i < this.w_analogRead.numAnalogReadBars) {
                this.w_analogRead.analogReadBars[i].adjustVertScale(1000);
                ++i;
            }
        } else if (n == 6) {
            int i = 0;
            while (i < this.w_analogRead.numAnalogReadBars) {
                this.w_analogRead.analogReadBars[i].adjustVertScale(10000);
                ++i;
            }
        }
        this.closeAllDropdowns();
    }

    public void Duration_AR(int n) {
        if (n == 0) {
            int i = 0;
            while (i < this.w_analogRead.numAnalogReadBars) {
                this.w_analogRead.analogReadBars[i].adjustTimeAxis(1);
                ++i;
            }
        } else if (n == 1) {
            int i = 0;
            while (i < this.w_analogRead.numAnalogReadBars) {
                this.w_analogRead.analogReadBars[i].adjustTimeAxis(3);
                ++i;
            }
        } else if (n == 2) {
            int i = 0;
            while (i < this.w_analogRead.numAnalogReadBars) {
                this.w_analogRead.analogReadBars[i].adjustTimeAxis(5);
                ++i;
            }
        } else if (n == 3) {
            int i = 0;
            while (i < this.w_analogRead.numAnalogReadBars) {
                this.w_analogRead.analogReadBars[i].adjustTimeAxis(7);
                ++i;
            }
        }
        this.closeAllDropdowns();
    }

    public void SmoothEMG(int n) {
        float samplesPerSecond = this.eegDataSource == 1 ? 200.0f : 250.0f;
        int i = 0;
        while (i < this.w_emg.motorWidgets.length) {
            if (n == 0) {
                this.w_emg.motorWidgets[i].averagePeriod = samplesPerSecond * 0.01f;
            }
            if (n == 1) {
                this.w_emg.motorWidgets[i].averagePeriod = samplesPerSecond * 0.1f;
            }
            if (n == 2) {
                this.w_emg.motorWidgets[i].averagePeriod = samplesPerSecond * 0.15f;
            }
            if (n == 3) {
                this.w_emg.motorWidgets[i].averagePeriod = samplesPerSecond * 0.25f;
            }
            if (n == 4) {
                this.w_emg.motorWidgets[i].averagePeriod = samplesPerSecond * 0.5f;
            }
            if (n == 5) {
                this.w_emg.motorWidgets[i].averagePeriod = samplesPerSecond * 0.75f;
            }
            if (n == 6) {
                this.w_emg.motorWidgets[i].averagePeriod = samplesPerSecond * 1.0f;
            }
            if (n == 7) {
                this.w_emg.motorWidgets[i].averagePeriod = samplesPerSecond * 2.0f;
            }
            ++i;
        }
        this.closeAllDropdowns();
    }

    public void uVLimit(int n) {
        int i = 0;
        while (i < this.w_emg.motorWidgets.length) {
            if (n == 0) {
                this.w_emg.motorWidgets[i].acceptableLimitUV = 50.0f;
            }
            if (n == 1) {
                this.w_emg.motorWidgets[i].acceptableLimitUV = 100.0f;
            }
            if (n == 2) {
                this.w_emg.motorWidgets[i].acceptableLimitUV = 200.0f;
            }
            if (n == 3) {
                this.w_emg.motorWidgets[i].acceptableLimitUV = 400.0f;
            }
            ++i;
        }
        this.closeAllDropdowns();
    }

    public void CreepSpeed(int n) {
        int i = 0;
        while (i < this.w_emg.motorWidgets.length) {
            if (n == 0) {
                this.w_emg.motorWidgets[i].creepSpeed = 0.9f;
            }
            if (n == 1) {
                this.w_emg.motorWidgets[i].creepSpeed = 0.95f;
            }
            if (n == 2) {
                this.w_emg.motorWidgets[i].creepSpeed = 0.98f;
            }
            if (n == 3) {
                this.w_emg.motorWidgets[i].creepSpeed = 0.99f;
            }
            if (n == 4) {
                this.w_emg.motorWidgets[i].creepSpeed = 0.999f;
            }
            ++i;
        }
        this.closeAllDropdowns();
    }

    public void minUVRange(int n) {
        int i = 0;
        while (i < this.w_emg.motorWidgets.length) {
            if (n == 0) {
                this.w_emg.motorWidgets[i].minRange = 10.0f;
            }
            if (n == 1) {
                this.w_emg.motorWidgets[i].minRange = 20.0f;
            }
            if (n == 2) {
                this.w_emg.motorWidgets[i].minRange = 40.0f;
            }
            if (n == 3) {
                this.w_emg.motorWidgets[i].minRange = 80.0f;
            }
            ++i;
        }
        this.closeAllDropdowns();
    }

    public void ChannelSelection(int n) {
        this.w_emg.currChannel = n;
        this.closeAllDropdowns();
    }

    public void EventType(int n) {
        if (n == 0) {
            this.w_emg.events[this.w_emg.currChannel] = true;
        } else if (n == 1) {
            this.w_emg.events[this.w_emg.currChannel] = false;
        }
        this.closeAllDropdowns();
    }

    public void BaudRate(int n) {
        if (!this.w_emg.baudList.get(n).equals("NONE")) {
            this.w_emg.theBaud = Integer.parseInt(this.w_emg.baudList.get(n));
        }
        this.closeAllDropdowns();
    }

    public void SerialSelection(int n) {
        if (!this.w_emg.serList.get(n).equals("NONE")) {
            this.w_emg.theSerial = this.w_emg.serList.get(n);
        }
        this.closeAllDropdowns();
    }

    public void MaxFreq(int n) {
        this.w_fft.fft_plot.setXLim(0.1f, (float)this.w_fft.xLimOptions[n]);
        this.closeAllDropdowns();
    }

    public void VertScale(int n) {
        this.w_fft.fft_plot.setYLim(0.1f, (float)this.w_fft.yLimOptions[n]);
        this.closeAllDropdowns();
    }

    public void LogLin(int n) {
        if (n == 0) {
            this.w_fft.fft_plot.setLogScale("y");
        } else {
            this.w_fft.fft_plot.setLogScale("");
        }
        this.closeAllDropdowns();
    }

    public void Smoothing(int n) {
        this.smoothFac_ind = n;
        this.closeAllDropdowns();
    }

    public void UnfiltFilt(int n) {
        this.isFFTFiltered = n == 0;
        this.closeAllDropdowns();
    }

    public void StrokeKeyWhenFocused(int n) {
        if (n == 0) {
            this.w_focus.enableKey = false;
            OpenBCI_GUI.println((String)"The robot ignores focused state and will not press any key.");
        } else if (n == 1) {
            this.w_focus.enableKey = true;
            this.w_focus.keyNum = 0;
            OpenBCI_GUI.println((String)"The robot will keep pressing Arrow Up key when you are focused, and release the key when you lose focus.");
        } else if (n == 2) {
            this.w_focus.enableKey = true;
            this.w_focus.keyNum = 1;
            OpenBCI_GUI.println((String)"The robot will keep pressing Spacebar when you are focused, and release the key when you lose focus.");
        }
        this.closeAllDropdowns();
    }

    public void SerialSendFocused(int n) {
        if (n == 0) {
            this.w_focus.enableSerial = false;
            OpenBCI_GUI.println((String)"Serial write off.");
        } else if (n == 1) {
            this.w_focus.enableSerial = true;
            OpenBCI_GUI.println((String)"Serial write on, writing character 1 (int 49) when focused, and character 0 (int 48) when losing focus.");
            OpenBCI_GUI.println((String)("Current output port name: " + this.serial_output_portName + ". Current baud rate: " + this.serial_output_baud + "."));
            OpenBCI_GUI.println((String)"You can change serial settings in OpenBCI_GUI.pde by searching serial_output.");
        }
        this.closeAllDropdowns();
    }

    public void ChooseFocusColor(int n) {
        if (n == 0) {
            this.w_focus.focusColors = FocusColors.GREEN;
            this.w_focus.onColorChange();
        } else if (n == 1) {
            this.w_focus.focusColors = FocusColors.ORANGE;
            this.w_focus.onColorChange();
        } else if (n == 2) {
            this.w_focus.focusColors = FocusColors.CYAN;
            this.w_focus.onColorChange();
        }
        this.closeAllDropdowns();
    }

    public void OpenBionicsSerialOut(int n) {
        if (!this.w_openbionics.serialListOB.get(n).equals("NONE")) {
            this.w_openbionics.obName = (String)this.w_openbionics.serialListOB.get(n);
        }
        this.closeAllDropdowns();
    }

    public void BaudList(int n) {
        if (!this.w_openbionics.baudListOB.get(n).equals("NONE")) {
            this.w_openbionics.obBaud = (String)this.w_openbionics.baudListOB.get(n);
        }
        this.closeAllDropdowns();
    }

    public void obChanList(int n) {
        this.w_openbionics.fingerChans[this.w_openbionics.drawConfig] = n - 1;
        this.closeAllDropdowns();
    }

    public void Dropdown1(int n) {
        OpenBCI_GUI.println((String)("Item " + (n + 1) + " selected from Dropdown 1"));
        if (n != 0) {
            // empty if block
        }
        this.closeAllDropdowns();
    }

    public void Dropdown2(int n) {
        OpenBCI_GUI.println((String)("Item " + (n + 1) + " selected from Dropdown 2"));
        this.closeAllDropdowns();
    }

    public void Dropdown3(int n) {
        OpenBCI_GUI.println((String)("Item " + (n + 1) + " selected from Dropdown 3"));
        this.closeAllDropdowns();
    }

    public void VertScale_TS(int n) {
        if (n == 0) {
            int i = 0;
            while (i < this.w_timeSeries.numChannelBars) {
                this.w_timeSeries.channelBars[i].adjustVertScale(0);
                ++i;
            }
        } else if (n == 1) {
            int i = 0;
            while (i < this.w_timeSeries.numChannelBars) {
                this.w_timeSeries.channelBars[i].adjustVertScale(50);
                ++i;
            }
        } else if (n == 2) {
            int i = 0;
            while (i < this.w_timeSeries.numChannelBars) {
                this.w_timeSeries.channelBars[i].adjustVertScale(100);
                ++i;
            }
        } else if (n == 3) {
            int i = 0;
            while (i < this.w_timeSeries.numChannelBars) {
                this.w_timeSeries.channelBars[i].adjustVertScale(200);
                ++i;
            }
        } else if (n == 4) {
            int i = 0;
            while (i < this.w_timeSeries.numChannelBars) {
                this.w_timeSeries.channelBars[i].adjustVertScale(400);
                ++i;
            }
        } else if (n == 5) {
            int i = 0;
            while (i < this.w_timeSeries.numChannelBars) {
                this.w_timeSeries.channelBars[i].adjustVertScale(1000);
                ++i;
            }
        } else if (n == 6) {
            int i = 0;
            while (i < this.w_timeSeries.numChannelBars) {
                this.w_timeSeries.channelBars[i].adjustVertScale(10000);
                ++i;
            }
        }
        this.closeAllDropdowns();
    }

    public void Duration(int n) {
        if (n == 0) {
            int i = 0;
            while (i < this.w_timeSeries.numChannelBars) {
                this.w_timeSeries.channelBars[i].adjustTimeAxis(1);
                ++i;
            }
        } else if (n == 1) {
            int i = 0;
            while (i < this.w_timeSeries.numChannelBars) {
                this.w_timeSeries.channelBars[i].adjustTimeAxis(3);
                ++i;
            }
        } else if (n == 2) {
            int i = 0;
            while (i < this.w_timeSeries.numChannelBars) {
                this.w_timeSeries.channelBars[i].adjustTimeAxis(5);
                ++i;
            }
        } else if (n == 3) {
            int i = 0;
            while (i < this.w_timeSeries.numChannelBars) {
                this.w_timeSeries.channelBars[i].adjustTimeAxis(7);
                ++i;
            }
        }
        this.closeAllDropdowns();
    }

    public void Spillover(int n) {
        this.w_timeSeries.allowSpillover = n != 0;
        this.closeAllDropdowns();
    }

    public float convertRawGanglionImpedanceToTarget(float _actual) {
        float _target = _actual <= 22.0f ? 0.0034f * OpenBCI_GUI.pow((float)_actual, (float)3.0f) - 0.1443f * OpenBCI_GUI.pow((float)_actual, (float)2.0f) + 3.1324f * _actual - 10.59f : 9.0E-6f * OpenBCI_GUI.pow((float)_actual, (float)4.0f) - 0.001f * OpenBCI_GUI.pow((float)_actual, (float)3.0f) + 0.0409f * OpenBCI_GUI.pow((float)_actual, (float)2.0f) + 0.6445f * OpenBCI_GUI.pow((float)_actual, (float)1.0f) - 1.0f;
        return _target;
    }

    public void Ten20(int n) {
        this.closeAllDropdowns();
    }

    public void Headset(int n) {
        this.closeAllDropdowns();
    }

    public void Polarity(int n) {
        if (n == 0) {
            this.w_headPlot.headPlot.use_polarity = true;
        } else {
            this.w_headPlot.headPlot.use_polarity = false;
        }
        this.closeAllDropdowns();
    }

    public void ShowContours(int n) {
        if (n == 0) {
            this.w_headPlot.headPlot.drawHeadAsContours = true;
        } else if (n == 1) {
            this.w_headPlot.headPlot.drawHeadAsContours = false;
        }
        this.closeAllDropdowns();
    }

    public void SmoothingHeadPlot(int n) {
        this.w_headPlot.setSmoothFac(this.smoothFac[n]);
        this.closeAllDropdowns();
    }

    public void UnfiltFiltHeadPlot(int n) {
        this.closeAllDropdowns();
    }

    public void Intensity(int n) {
        this.vertScaleFactor_ind = n;
        this.updateVertScale();
        this.closeAllDropdowns();
    }

    public void setVertScaleFactor_ind(int ind) {
        this.vertScaleFactor_ind = OpenBCI_GUI.max((int)0, (int)ind);
        if (ind >= this.vertScaleFactor.length) {
            this.vertScaleFactor_ind = 0;
        }
        this.updateVertScale();
    }

    public void updateVertScale() {
        this.vertScale_uV = this.default_vertScale_uV * this.vertScaleFactor[this.vertScaleFactor_ind];
        this.w_headPlot.headPlot.setMaxIntensity_uV(this.vertScale_uV);
    }

    public void doHardCalcs() {
        if (!this.w_headPlot.headPlot.threadLock) {
            this.w_headPlot.headPlot.threadLock = true;
            this.w_headPlot.headPlot.setPositionSize(this.w_headPlot.headPlot.hp_x, this.w_headPlot.headPlot.hp_y, this.w_headPlot.headPlot.hp_w, this.w_headPlot.headPlot.hp_h, this.w_headPlot.headPlot.hp_win_x, this.w_headPlot.headPlot.hp_win_y);
            this.w_headPlot.headPlot.hardCalcsDone = true;
            this.w_headPlot.headPlot.threadLock = false;
        }
    }

    public void Protocol(int protocolIndex) {
        if (protocolIndex == 0) {
            this.w_networking.protocolMode = "OSC";
        } else if (protocolIndex == 1) {
            this.w_networking.protocolMode = "UDP";
        } else if (protocolIndex == 2) {
            this.w_networking.protocolMode = "LSL";
        } else if (protocolIndex == 3) {
            this.w_networking.protocolMode = "Serial";
        }
        OpenBCI_GUI.println((String)(String.valueOf(this.w_networking.protocolMode) + " selected from Protocol Menu"));
        this.w_networking.screenResized();
        this.w_networking.showCP5();
        this.closeAllDropdowns();
    }

    public void dataType1(int n) {
        this.w_networking.closeAllDropdowns();
    }

    public void dataType2(int n) {
        this.w_networking.closeAllDropdowns();
    }

    public void dataType3(int n) {
        this.w_networking.closeAllDropdowns();
    }

    public void port_name(int n) {
        this.w_networking.closeAllDropdowns();
    }

    public void baud_rate(int n) {
        this.w_networking.closeAllDropdowns();
    }

    public void closeAllDropdowns() {
        int i = 0;
        while (i < this.wm.widgets.size()) {
            this.wm.widgets.get((int)i).dropdownsShouldBeClosed = true;
            ++i;
        }
    }

    public void WidgetSelector(int n) {
        OpenBCI_GUI.println((String)("New widget [" + n + "] selected for container..."));
        boolean isSelectedWidgetActive = this.wm.widgets.get((int)n).isActive;
        int theContainer = -1;
        int i = 0;
        while (i < this.wm.widgets.size()) {
            if (this.wm.widgets.get(i).isMouseHere()) {
                theContainer = this.wm.widgets.get((int)i).currentContainer;
                if (isSelectedWidgetActive) {
                    this.wm.widgets.get(i).setContainer(this.wm.widgets.get((int)n).currentContainer);
                } else {
                    this.wm.widgets.get((int)i).isActive = false;
                }
            }
            ++i;
        }
        this.wm.widgets.get((int)n).isActive = true;
        this.wm.widgets.get(n).setContainer(theContainer);
        this.closeAllDropdowns();
    }

    public void setupWidgets(PApplet _this, ArrayList<Widget> w) {
        this.w_timeSeries = new W_timeSeries(_this);
        this.w_timeSeries.setTitle("Time Series");
        this.addWidget(this.w_timeSeries, w);
        this.w_fft = new W_fft(_this);
        this.w_fft.setTitle("FFT Plot");
        this.addWidget(this.w_fft, w);
        this.w_accelerometer = new W_accelerometer(_this);
        this.w_accelerometer.setTitle("Accelerometer");
        this.w_networking = new W_networking(_this);
        this.w_networking.setTitle("Networking");
        if (this.nchan == 4 && this.eegDataSource == 1) {
            this.w_ganglionImpedance = new W_ganglionImpedance(_this);
            this.w_ganglionImpedance.setTitle("Ganglion Signal");
            this.addWidget(this.w_ganglionImpedance, w);
            this.addWidget(this.w_networking, w);
            this.addWidget(this.w_accelerometer, w);
        } else {
            this.addWidget(this.w_accelerometer, w);
            this.addWidget(this.w_networking, w);
        }
        this.w_bandPower = new W_BandPower(_this);
        this.w_bandPower.setTitle("Band Power");
        this.addWidget(this.w_bandPower, w);
        this.w_headPlot = new W_headPlot(_this);
        this.w_headPlot.setTitle("Head Plot");
        this.addWidget(this.w_headPlot, w);
        this.w_emg = new W_emg(_this);
        this.w_emg.setTitle("EMG");
        this.addWidget(this.w_emg, w);
        this.w_focus = new W_Focus(_this);
        this.w_focus.setTitle("Focus Widget");
        this.addWidget(this.w_focus, w);
        if (this.eegDataSource != 1) {
            this.w_pulsesensor = new W_PulseSensor(_this);
            this.w_pulsesensor.setTitle("Pulse Sensor");
            this.addWidget(this.w_pulsesensor, w);
            this.w_digitalRead = new W_DigitalRead(_this);
            this.w_digitalRead.setTitle("Digital Read");
            this.addWidget(this.w_digitalRead, w);
            this.w_analogRead = new W_AnalogRead(_this);
            this.w_analogRead.setTitle("Analog Read");
            this.addWidget(this.w_analogRead, w);
            this.w_markermode = new W_MarkerMode(_this);
            this.w_markermode.setTitle("Marker Mode");
            this.addWidget(this.w_markermode, w);
        }
        this.w_template1 = new W_template(_this);
        this.w_template1.setTitle("Widget Template 1");
        this.addWidget(this.w_template1, w);
    }

    public void addWidget(Widget myNewWidget, ArrayList<Widget> w) {
        w.add(myNewWidget);
    }

    public void settings() {
        this.size(1024, 768, "processing.opengl.PGraphics2D");
        this.smooth();
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"OpenBCI_GUI"};
        if (passedArgs != null) {
            PApplet.main((String[])OpenBCI_GUI.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    class AnalogReadBar {
        int analogInputPin;
        int auxValuesPosition;
        String analogInputString;
        int x;
        int y;
        int w;
        int h;
        boolean isOn;
        GPlot plot;
        GPointsArray analogReadPoints;
        int nPoints;
        int numSeconds;
        float timeBetweenPoints;
        int channelColor;
        boolean isAutoscale;
        int autoScaleYLim = 0;
        TextBox analogValue;
        TextBox analogPin;
        TextBox digitalPin;
        boolean drawAnalogValue;
        int lastProcessedDataPacketInd = 0;
        int[] analogReadData;

        AnalogReadBar(PApplet _parent, int _analogInputPin, int _x, int _y, int _w, int _h) {
            this.analogInputPin = _analogInputPin;
            int digitalPinNum = 0;
            if (this.analogInputPin == 7) {
                this.auxValuesPosition = 2;
                digitalPinNum = 13;
            } else if (this.analogInputPin == 6) {
                this.auxValuesPosition = 1;
                digitalPinNum = 12;
            } else {
                this.analogInputPin = 5;
                this.auxValuesPosition = 0;
                digitalPinNum = 11;
            }
            this.analogInputString = OpenBCI_GUI.str((int)this.analogInputPin);
            this.isOn = true;
            this.x = _x;
            this.y = _y;
            this.w = _w;
            this.h = _h;
            this.numSeconds = 5;
            this.plot = new GPlot(_parent);
            this.plot.setPos((float)(this.x + 36 + 4), (float)this.y);
            this.plot.setDim((float)(this.w - 36 - 4), (float)this.h);
            this.plot.setMar(0.0f, 0.0f, 0.0f, 0.0f);
            this.plot.setLineColor(OpenBCI_GUI.this.channelColors[this.auxValuesPosition % 8]);
            this.plot.setXLim(-3.2f, -2.9f);
            this.plot.setYLim(-200.0f, 200.0f);
            this.plot.setPointSize(2.0f);
            this.plot.setPointColor(0);
            if (OpenBCI_GUI.this.cyton.isWifi()) {
                if (this.auxValuesPosition == 1) {
                    this.plot.getXAxis().setAxisLabelText("Time (s)");
                }
            } else if (this.auxValuesPosition == 2) {
                this.plot.getXAxis().setAxisLabelText("Time (s)");
            }
            this.nPoints = this.nPointsBasedOnDataSource();
            this.analogReadData = new int[this.nPoints];
            this.analogReadPoints = new GPointsArray(this.nPoints);
            this.timeBetweenPoints = (float)this.numSeconds / (float)this.nPoints;
            int i = 0;
            while (i < this.nPoints) {
                float time = -((float)this.numSeconds) + (float)i * this.timeBetweenPoints;
                float analog_value = 0.0f;
                GPoint tempPoint = new GPoint(time, analog_value);
                this.analogReadPoints.set(i, tempPoint);
                ++i;
            }
            this.plot.setPoints(this.analogReadPoints);
            this.analogValue = new TextBox(OpenBCI_GUI.TCP_CMD_DATA, this.x + 36 + 4 + (this.w - 36 - 4) - 2, this.y + this.h);
            this.analogValue.textColor = OpenBCI_GUI.this.color(OpenBCI_GUI.this.bgColor);
            this.analogValue.alignH = 39;
            this.analogValue.drawBackground = true;
            this.analogValue.backgroundColor = OpenBCI_GUI.this.color(255, 255, 255, 125);
            this.analogPin = new TextBox("A" + this.analogInputString, this.x + 3, this.y + this.h);
            this.analogPin.textColor = OpenBCI_GUI.this.color(OpenBCI_GUI.this.bgColor);
            this.analogPin.alignH = 3;
            this.digitalPin = new TextBox("(D" + digitalPinNum + ")", this.x + 3, this.y + this.h + 12);
            this.digitalPin.textColor = OpenBCI_GUI.this.color(OpenBCI_GUI.this.bgColor);
            this.digitalPin.alignH = 3;
            this.drawAnalogValue = true;
        }

        public void update() {
            float val = OpenBCI_GUI.this.hub.validAccelValues[this.auxValuesPosition];
            this.analogValue.string = String.format(this.getFmt(val), Float.valueOf(val));
            this.updatePlotPoints();
            if (this.isAutoscale) {
                this.autoScale();
            }
        }

        private String getFmt(float val) {
            String fmt = val > 100.0f ? "%.0f" : (val > 10.0f ? "%.1f" : "%.2f");
            return fmt;
        }

        public void updatePlotPoints() {
            int numSamplesToProcess = OpenBCI_GUI.this.curDataPacketInd - this.lastProcessedDataPacketInd;
            if (numSamplesToProcess < 0) {
                numSamplesToProcess += OpenBCI_GUI.this.dataPacketBuff.length;
            }
            if (numSamplesToProcess > 0) {
                int i = 0;
                while (i < this.analogReadData.length - numSamplesToProcess) {
                    this.analogReadData[i] = this.analogReadData[i + numSamplesToProcess];
                    ++i;
                }
            }
            int samplesProcessed = 0;
            while (samplesProcessed < numSamplesToProcess) {
                int voltage;
                ++this.lastProcessedDataPacketInd;
                if (this.lastProcessedDataPacketInd > OpenBCI_GUI.this.dataPacketBuff.length - 1) {
                    this.lastProcessedDataPacketInd = 0;
                }
                this.analogReadData[this.analogReadData.length - numSamplesToProcess + samplesProcessed] = voltage = OpenBCI_GUI.this.dataPacketBuff[this.lastProcessedDataPacketInd].auxValues[this.auxValuesPosition];
                ++samplesProcessed;
            }
            if (numSamplesToProcess > 0) {
                int i = 0;
                while (i < this.nPoints) {
                    float timey = -((float)this.numSeconds) + (float)i * this.timeBetweenPoints;
                    float voltage = this.analogReadData[i];
                    GPoint tempPoint = new GPoint(timey, voltage);
                    this.analogReadPoints.set(i, tempPoint);
                    ++i;
                }
                this.plot.setPoints(this.analogReadPoints);
            }
        }

        public void draw() {
            OpenBCI_GUI.this.pushStyle();
            OpenBCI_GUI.this.stroke(31.0f, 69.0f, 110.0f, 50.0f);
            OpenBCI_GUI.this.fill(OpenBCI_GUI.this.color(125, 30, 12, 30));
            OpenBCI_GUI.this.rect(this.x + 36 + 4, this.y, this.w - 36 - 4, this.h);
            this.plot.beginDraw();
            this.plot.drawBox();
            this.plot.drawGridLines(0);
            this.plot.drawLines();
            if (OpenBCI_GUI.this.cyton.isWifi()) {
                if (this.auxValuesPosition == 1) {
                    this.plot.drawXAxis();
                    this.plot.getXAxis().draw();
                }
            } else if (this.auxValuesPosition == 2) {
                this.plot.drawXAxis();
                this.plot.getXAxis().draw();
            }
            this.plot.endDraw();
            if (this.drawAnalogValue) {
                this.analogValue.draw();
                this.analogPin.draw();
                this.digitalPin.draw();
            }
            OpenBCI_GUI.this.popStyle();
        }

        public int nPointsBasedOnDataSource() {
            return this.numSeconds * (int)OpenBCI_GUI.this.getSampleRateSafe();
        }

        public void adjustTimeAxis(int _newTimeSize) {
            this.numSeconds = _newTimeSize;
            this.plot.setXLim((float)(-_newTimeSize), 0.0f);
            this.nPoints = this.nPointsBasedOnDataSource();
            this.analogReadPoints = new GPointsArray(this.nPoints);
            if (_newTimeSize > 1) {
                this.plot.getXAxis().setNTicks(_newTimeSize);
            } else {
                this.plot.getXAxis().setNTicks(10);
            }
            if (OpenBCI_GUI.this.w_analogRead != null && OpenBCI_GUI.this.w_analogRead.isUpdating()) {
                this.updatePlotPoints();
            }
        }

        public void adjustVertScale(int _vertScaleValue) {
            if (_vertScaleValue == 0) {
                this.isAutoscale = true;
            } else {
                this.isAutoscale = false;
                this.plot.setYLim((float)(-_vertScaleValue), (float)_vertScaleValue);
            }
        }

        public void autoScale() {
            this.autoScaleYLim = 0;
            int i = 0;
            while (i < this.nPoints) {
                if (PApplet.parseInt((float)OpenBCI_GUI.abs((float)this.analogReadPoints.getY(i))) > this.autoScaleYLim) {
                    this.autoScaleYLim = PApplet.parseInt((float)OpenBCI_GUI.abs((float)this.analogReadPoints.getY(i)));
                }
                ++i;
            }
            this.plot.setYLim((float)(-this.autoScaleYLim), (float)this.autoScaleYLim);
        }

        public void screenResized(int _x, int _y, int _w, int _h) {
            this.x = _x;
            this.y = _y;
            this.w = _w;
            this.h = _h;
            this.plot.setPos((float)(this.x + 36 + 4), (float)this.y);
            this.plot.setDim((float)(this.w - 36 - 4), (float)this.h);
            this.analogValue.x = this.x + 36 + 4 + (this.w - 36 - 4) - 2;
            this.analogValue.y = this.y + this.h;
            this.analogPin.x = this.x + 14;
            this.analogPin.y = this.y + PApplet.parseInt((float)((float)this.h / 2.0f));
            this.digitalPin.x = this.analogPin.x;
            this.digitalPin.y = this.analogPin.y + 12;
        }
    }

    class BLEBox {
        int x;
        int y;
        int w;
        int h;
        int padding;

        BLEBox(int _x, int _y, int _w, int _h, int _padding) {
            this.x = _x;
            this.y = _y;
            this.w = _w;
            this.h = 140 + _padding;
            this.padding = _padding;
            OpenBCI_GUI.this.refreshBLE = new Button(this.x + this.padding, this.y + this.padding * 4 + 72 + 8, this.w - this.padding * 5, 24, "START SEARCH", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
            OpenBCI_GUI.this.bleList = new MenuList(OpenBCI_GUI.this.cp5, "bleList", this.w - this.padding * 2, 72, OpenBCI_GUI.this.p4);
            OpenBCI_GUI.this.bleList.setPosition(this.x + this.padding, this.y + this.padding * 3 + 8);
        }

        public void update() {
        }

        public void updateListPosition() {
            OpenBCI_GUI.this.bleList.setPosition(this.x + this.padding, this.y + this.padding * 3);
        }

        public void draw() {
            OpenBCI_GUI.this.pushStyle();
            OpenBCI_GUI.this.fill(OpenBCI_GUI.this.boxColor);
            OpenBCI_GUI.this.stroke(OpenBCI_GUI.this.boxStrokeColor);
            OpenBCI_GUI.this.strokeWeight(1.0f);
            OpenBCI_GUI.this.rect(this.x, this.y, this.w, this.h);
            OpenBCI_GUI.this.fill(OpenBCI_GUI.this.bgColor);
            OpenBCI_GUI.this.textFont(OpenBCI_GUI.this.h3, 16.0f);
            OpenBCI_GUI.this.textAlign(37, 101);
            OpenBCI_GUI.this.text("BLE DEVICES", this.x + this.padding, this.y + this.padding);
            OpenBCI_GUI.this.popStyle();
            OpenBCI_GUI.this.refreshBLE.draw();
            if (OpenBCI_GUI.this.isHubInitialized && OpenBCI_GUI.this.isHubObjectInitialized && OpenBCI_GUI.this.ganglion.isBLE() && OpenBCI_GUI.this.hub.isSearching()) {
                OpenBCI_GUI.this.image((PImage)OpenBCI_GUI.this.loadingGIF_blue, this.w + 225, this.y + this.padding * 4 + 72 + 10, 20.0f, 20.0f);
                OpenBCI_GUI.this.refreshBLE.setString("SEARCHING...");
            } else {
                OpenBCI_GUI.this.refreshBLE.setString("START SEARCH");
            }
        }

        public void refreshBLEList() {
            OpenBCI_GUI.this.bleList.items.clear();
            int i = 0;
            while (i < OpenBCI_GUI.this.hub.deviceList.length) {
                String tempPort = OpenBCI_GUI.this.hub.deviceList[i];
                OpenBCI_GUI.this.bleList.addItem(OpenBCI_GUI.this.makeItem(tempPort));
                ++i;
            }
            OpenBCI_GUI.this.bleList.updateMenu();
        }
    }

    public abstract class BasicSlider {
        float x;
        float y;
        float w;
        float h;
        float yBot;
        float yTop;
        boolean isPressed = false;
        int cNormal = -3355444;
        int cPressed = -65536;

        BasicSlider(float _x, float _yBot, float _yTop) {
            this.x = _x;
            this.yBot = _yBot;
            this.yTop = _yTop;
            this.w = 10.0f;
            this.h = 10.0f;
        }

        public abstract void update();

        public abstract void screenResized(float var1, float var2, float var3);

        public abstract float getVal();

        public abstract void setVal(float var1);

        public void draw() {
            if (this.isPressed) {
                OpenBCI_GUI.this.fill(this.cPressed);
            } else {
                OpenBCI_GUI.this.fill(this.cNormal);
            }
            OpenBCI_GUI.this.noStroke();
            OpenBCI_GUI.this.triangle(this.x - this.w / 2.0f, this.y, this.x + this.w / 2.0f, this.y - this.h / 2.0f, this.x + this.w / 2.0f, this.y + this.h / 2.0f);
        }

        public void mousePressed() {
            if (OpenBCI_GUI.abs((float)((float)OpenBCI_GUI.this.mouseX - this.x)) <= this.w / 2.0f && OpenBCI_GUI.abs((float)((float)OpenBCI_GUI.this.mouseY - this.y)) <= this.h / 2.0f) {
                this.isPressed = true;
            }
        }

        public void mouseReleased() {
            if (this.isPressed) {
                this.isPressed = false;
            }
        }
    }

    class Button {
        int but_x;
        int but_y;
        int but_dx;
        int but_dy;
        int currentColor;
        int color_hover;
        int color_pressed;
        int color_highlight;
        int color_notPressed;
        int buttonStrokeColor;
        int textColorActive;
        int textColorNotActive;
        int rectHighlight;
        boolean drawHand;
        boolean isCircleButton;
        int cornerRoundness;
        boolean buttonHasStroke;
        boolean isActive;
        boolean isDropdownButton;
        boolean wasPressed;
        public String but_txt;
        boolean showHelpText;
        boolean helpTimerStarted;
        String helpText;
        String myURL;
        int mouseOverButtonStart;
        PFont buttonFont;
        int buttonTextSize;
        PImage bgImage;
        boolean hasbgImage;

        public Button(int x, int y, int w, int h, String txt) {
            this.color_hover = OpenBCI_GUI.this.color(177, 184, 193);
            this.color_pressed = OpenBCI_GUI.this.color(150, 170, 200);
            this.color_highlight = OpenBCI_GUI.this.color(102);
            this.color_notPressed = OpenBCI_GUI.this.color(255);
            this.buttonStrokeColor = OpenBCI_GUI.this.bgColor;
            this.textColorActive = OpenBCI_GUI.this.color(255);
            this.textColorNotActive = OpenBCI_GUI.this.bgColor;
            this.drawHand = false;
            this.isCircleButton = false;
            this.cornerRoundness = 0;
            this.buttonHasStroke = true;
            this.isActive = false;
            this.isDropdownButton = false;
            this.wasPressed = false;
            this.helpText = "";
            this.myURL = "";
            this.mouseOverButtonStart = 0;
            this.hasbgImage = false;
            this.setup(x, y, w, h, txt);
            this.buttonFont = OpenBCI_GUI.this.p5;
            this.buttonTextSize = 12;
        }

        public Button(int x, int y, int w, int h, String txt, int fontSize) {
            this.color_hover = OpenBCI_GUI.this.color(177, 184, 193);
            this.color_pressed = OpenBCI_GUI.this.color(150, 170, 200);
            this.color_highlight = OpenBCI_GUI.this.color(102);
            this.color_notPressed = OpenBCI_GUI.this.color(255);
            this.buttonStrokeColor = OpenBCI_GUI.this.bgColor;
            this.textColorActive = OpenBCI_GUI.this.color(255);
            this.textColorNotActive = OpenBCI_GUI.this.bgColor;
            this.drawHand = false;
            this.isCircleButton = false;
            this.cornerRoundness = 0;
            this.buttonHasStroke = true;
            this.isActive = false;
            this.isDropdownButton = false;
            this.wasPressed = false;
            this.helpText = "";
            this.myURL = "";
            this.mouseOverButtonStart = 0;
            this.hasbgImage = false;
            this.setup(x, y, w, h, txt);
            this.buttonFont = OpenBCI_GUI.this.p5;
            this.buttonTextSize = 12;
        }

        public void setup(int x, int y, int w, int h, String txt) {
            this.but_x = x;
            this.but_y = y;
            this.but_dx = w;
            this.but_dy = h;
            this.setString(txt);
        }

        public void setX(int _but_x) {
            this.but_x = _but_x;
        }

        public void setY(int _but_y) {
            this.but_y = _but_y;
        }

        public void setPos(int _but_x, int _but_y) {
            this.but_x = _but_x;
            this.but_y = _but_y;
        }

        public void setFont(PFont _newFont) {
            this.buttonFont = _newFont;
        }

        public void setFont(PFont _newFont, int _newTextSize) {
            this.buttonFont = _newFont;
            this.buttonTextSize = _newTextSize;
        }

        public void setCircleButton(boolean _isCircleButton) {
            this.isCircleButton = _isCircleButton;
            if (this.isCircleButton) {
                this.cornerRoundness = 0;
            }
        }

        public void setCornerRoundess(int _cornerRoundness) {
            if (!this.isCircleButton) {
                this.cornerRoundness = _cornerRoundness;
            }
        }

        public void setString(String txt) {
            this.but_txt = txt;
        }

        public void setHelpText(String _helpText) {
            this.helpText = _helpText;
        }

        public void setURL(String _myURL) {
            this.myURL = _myURL;
        }

        public void goToURL() {
            if (this.myURL != "") {
                OpenBCI_GUI.this.openURLInBrowser(this.myURL);
            }
        }

        public void setBackgroundImage(PImage _bgImage) {
            this.bgImage = _bgImage;
            this.hasbgImage = true;
        }

        public boolean isActive() {
            return this.isActive;
        }

        public void setIsActive(boolean val) {
            this.isActive = val;
        }

        public void makeDropdownButton(boolean val) {
            this.isDropdownButton = val;
        }

        public boolean isMouseHere() {
            if (this.overRect(this.but_x, this.but_y, this.but_dx, this.but_dy)) {
                if (!this.helpTimerStarted) {
                    this.helpTimerStarted = true;
                    this.mouseOverButtonStart = OpenBCI_GUI.this.millis();
                } else if (OpenBCI_GUI.this.millis() - this.mouseOverButtonStart >= 1000) {
                    this.showHelpText = true;
                }
                return true;
            }
            this.setIsActive(false);
            if (this.helpTimerStarted) {
                OpenBCI_GUI.this.buttonHelpText.setVisible(false);
                this.showHelpText = false;
                this.helpTimerStarted = false;
            }
            return false;
        }

        public int getColor() {
            this.currentColor = this.isActive ? this.color_pressed : (this.isMouseHere() ? this.color_hover : this.color_notPressed);
            return this.currentColor;
        }

        public void setCurrentColor(int _color) {
            this.currentColor = _color;
        }

        public void setColorPressed(int _color) {
            this.color_pressed = _color;
        }

        public void setColorNotPressed(int _color) {
            this.color_notPressed = _color;
        }

        public void setStrokeColor(int _color) {
            this.buttonStrokeColor = _color;
        }

        public void hasStroke(boolean _trueORfalse) {
            this.buttonHasStroke = _trueORfalse;
        }

        public boolean overRect(int x, int y, int width, int height) {
            return OpenBCI_GUI.this.mouseX >= x && OpenBCI_GUI.this.mouseX <= x + width && OpenBCI_GUI.this.mouseY >= y && OpenBCI_GUI.this.mouseY <= y + height;
        }

        public void draw(int _x, int _y) {
            this.but_x = _x;
            this.but_y = _y;
            this.draw();
        }

        public void draw() {
            OpenBCI_GUI.this.pushStyle();
            OpenBCI_GUI.this.ellipseMode(0);
            OpenBCI_GUI.this.fill(this.getColor());
            if (this.buttonHasStroke) {
                OpenBCI_GUI.this.stroke(this.buttonStrokeColor);
            } else {
                OpenBCI_GUI.this.noStroke();
            }
            if (this.isCircleButton) {
                OpenBCI_GUI.this.ellipse(this.but_x, this.but_y, this.but_dx, this.but_dy);
            } else if (this.cornerRoundness == 0) {
                OpenBCI_GUI.this.rect(this.but_x, this.but_y, this.but_dx, this.but_dy);
            } else {
                OpenBCI_GUI.this.rect(this.but_x, this.but_y, this.but_dx, this.but_dy, this.cornerRoundness);
            }
            if (this.isActive) {
                OpenBCI_GUI.this.fill(this.textColorActive);
            } else {
                OpenBCI_GUI.this.fill(this.textColorNotActive);
            }
            OpenBCI_GUI.this.stroke(255);
            OpenBCI_GUI.this.textFont(this.buttonFont);
            OpenBCI_GUI.this.textSize(this.buttonTextSize);
            OpenBCI_GUI.this.textAlign(3, 3);
            OpenBCI_GUI.this.textLeading(OpenBCI_GUI.round((float)(0.9f * (OpenBCI_GUI.this.textAscent() + OpenBCI_GUI.this.textDescent()))));
            int x1 = this.but_x + this.but_dx / 2;
            int y1 = this.but_y + this.but_dy / 2;
            if (this.hasbgImage) {
                OpenBCI_GUI.this.imageMode(3);
                OpenBCI_GUI.this.image(this.bgImage, this.but_x + this.but_dx / 2, this.but_y + this.but_dy / 2, this.but_dx - 8, this.but_dy - 8);
            } else if (this.buttonFont == OpenBCI_GUI.this.h1 || this.buttonFont == OpenBCI_GUI.this.h2 || this.buttonFont == OpenBCI_GUI.this.h3 || this.buttonFont == OpenBCI_GUI.this.h4 || this.buttonFont == OpenBCI_GUI.this.h5) {
                OpenBCI_GUI.this.text(this.but_txt, x1, y1 - 1);
            } else if (this.buttonFont == OpenBCI_GUI.this.p1 || this.buttonFont == OpenBCI_GUI.this.p2 || this.buttonFont == OpenBCI_GUI.this.p3 || this.buttonFont == OpenBCI_GUI.this.p4 || this.buttonFont == OpenBCI_GUI.this.p5 || this.buttonFont == OpenBCI_GUI.this.p6) {
                OpenBCI_GUI.this.textLeading(12.0f);
                OpenBCI_GUI.this.text(this.but_txt, x1, y1 - 2);
            } else {
                OpenBCI_GUI.this.text(this.but_txt, x1, y1);
            }
            if (this.showHelpText && this.helpText != "") {
                OpenBCI_GUI.this.buttonHelpText.setButtonHelpText(this.helpText, this.but_x + this.but_dx / 2, this.but_y + 3 * this.but_dy / 4);
                OpenBCI_GUI.this.buttonHelpText.setVisible(true);
            }
            if (this.isDropdownButton) {
                OpenBCI_GUI.this.pushStyle();
                OpenBCI_GUI.this.fill(255);
                OpenBCI_GUI.this.noStroke();
                if (this.isActive) {
                    float point1x = (float)this.but_x + ((float)this.but_dx - 3.0f * (float)this.but_dy / 4.0f);
                    float point1y = (float)this.but_y + (float)this.but_dy / 3.0f;
                    float point2x = (float)this.but_x + ((float)this.but_dx - (float)this.but_dy / 4.0f);
                    float point2y = (float)this.but_y + (float)this.but_dy / 3.0f;
                    float point3x = (float)this.but_x + ((float)this.but_dx - (float)this.but_dy / 2.0f);
                    float point3y = (float)this.but_y + 2.0f * (float)this.but_dy / 3.0f;
                    OpenBCI_GUI.this.triangle(point1x, point1y, point2x, point2y, point3x, point3y);
                } else {
                    float point1x = (float)this.but_x + ((float)this.but_dx - 3.0f * (float)this.but_dy / 4.0f);
                    float point1y = (float)this.but_y + 2.0f * (float)this.but_dy / 3.0f;
                    float point2x = (float)this.but_x + ((float)this.but_dx - (float)this.but_dy / 4.0f);
                    float point2y = (float)this.but_y + 2.0f * (float)this.but_dy / 3.0f;
                    float point3x = (float)this.but_x + ((float)this.but_dx - (float)this.but_dy / 2.0f);
                    float point3y = (float)this.but_y + (float)this.but_dy / 3.0f;
                    OpenBCI_GUI.this.triangle(point1x, point1y, point2x, point2y, point3x, point3y);
                }
                OpenBCI_GUI.this.popStyle();
            }
            OpenBCI_GUI.this.popStyle();
        }
    }

    class ButtonHelpText {
        int x;
        int y;
        int w;
        int h;
        String myText = "";
        boolean isVisible;
        int numLines;
        int lineSpacing = 14;
        int padding = 10;

        ButtonHelpText() {
        }

        public void setVisible(boolean _isVisible) {
            this.isVisible = _isVisible;
        }

        public void setButtonHelpText(String _myText, int _x, int _y) {
            this.myText = _myText;
            this.x = _x;
            this.y = _y;
        }

        public void draw() {
            if (this.isVisible) {
                OpenBCI_GUI.this.pushStyle();
                OpenBCI_GUI.this.textAlign(3, 101);
                OpenBCI_GUI.this.textFont(OpenBCI_GUI.this.p5, 12.0f);
                OpenBCI_GUI.this.textLeading(this.lineSpacing);
                OpenBCI_GUI.this.stroke(31.0f, 69.0f, 110.0f);
                OpenBCI_GUI.this.fill(255);
                this.numLines = (int)((float)this.myText.length() / 30.0f) + 1;
                if (this.x <= OpenBCI_GUI.this.width / 2) {
                    OpenBCI_GUI.this.rect(this.x, this.y, 200.0f, 2 * this.padding + this.numLines * this.lineSpacing + 4);
                    OpenBCI_GUI.this.fill(31.0f, 69.0f, 110.0f);
                    OpenBCI_GUI.this.text(this.myText, this.x + this.padding, this.y + this.padding, 180.0f, this.numLines * this.lineSpacing + 4);
                } else {
                    OpenBCI_GUI.this.rect(this.x - 200, this.y, 200.0f, 2 * this.padding + this.numLines * this.lineSpacing + 4);
                    OpenBCI_GUI.this.fill(31.0f, 69.0f, 110.0f);
                    OpenBCI_GUI.this.text(this.myText, this.x + this.padding - 200, this.y + this.padding, 180.0f, this.numLines * this.lineSpacing + 4);
                }
                OpenBCI_GUI.this.popStyle();
            }
        }
    }

    class ChannelBar {
        int channelNumber;
        String channelString;
        int x;
        int y;
        int w;
        int h;
        boolean isOn;
        Button onOffButton;
        int onOff_diameter;
        int impButton_diameter;
        Button impCheckButton;
        GPlot plot;
        GPointsArray channelPoints;
        int nPoints;
        int numSeconds;
        float timeBetweenPoints;
        int channelColor;
        boolean isAutoscale;
        int autoScaleYLim = 0;
        TextBox voltageValue;
        TextBox impValue;
        boolean drawVoltageValue;
        boolean drawImpValue;

        ChannelBar(PApplet _parent, int _channelNumber, int _x, int _y, int _w, int _h) {
            this.channelNumber = _channelNumber;
            this.channelString = OpenBCI_GUI.str((int)this.channelNumber);
            this.isOn = true;
            this.x = _x;
            this.y = _y;
            this.w = _w;
            this.h = _h;
            this.onOff_diameter = this.h > 26 ? 26 : this.h - 2;
            this.onOffButton = new Button(this.x + 6, this.y + PApplet.parseInt((float)(this.h / 2)) - PApplet.parseInt((float)(this.onOff_diameter / 2)), this.onOff_diameter, this.onOff_diameter, this.channelString, OpenBCI_GUI.this.fontInfo.buttonLabel_size);
            this.onOffButton.setFont(OpenBCI_GUI.this.h2, 16);
            this.onOffButton.setCircleButton(true);
            this.onOffButton.setColorNotPressed(OpenBCI_GUI.this.channelColors[(this.channelNumber - 1) % 8]);
            this.onOffButton.hasStroke(false);
            if (OpenBCI_GUI.this.eegDataSource == 0) {
                this.impButton_diameter = 22;
                this.impCheckButton = new Button(this.x + 36, this.y + PApplet.parseInt((float)(this.h / 2)) - PApplet.parseInt((float)(this.impButton_diameter / 2)), this.impButton_diameter, this.impButton_diameter, "\u2126", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
                this.impCheckButton.setFont(OpenBCI_GUI.this.h2, 16);
                this.impCheckButton.setCircleButton(true);
                this.impCheckButton.setColorNotPressed(OpenBCI_GUI.this.color(255));
                this.impCheckButton.hasStroke(false);
            } else {
                this.impButton_diameter = 0;
            }
            this.numSeconds = 5;
            this.plot = new GPlot(_parent);
            this.plot.setPos((float)(this.x + 36 + 4 + this.impButton_diameter), (float)this.y);
            this.plot.setDim((float)(this.w - 36 - 4 - this.impButton_diameter), (float)this.h);
            this.plot.setMar(0.0f, 0.0f, 0.0f, 0.0f);
            this.plot.setLineColor(OpenBCI_GUI.this.channelColors[(this.channelNumber - 1) % 8]);
            this.plot.setXLim(-5.0f, 0.0f);
            this.plot.setYLim(-200.0f, 200.0f);
            this.plot.setPointSize(2.0f);
            this.plot.setPointColor(0);
            if (this.channelNumber == OpenBCI_GUI.this.nchan) {
                this.plot.getXAxis().setAxisLabelText("Time (s)");
            }
            this.nPoints = this.nPointsBasedOnDataSource();
            this.channelPoints = new GPointsArray(this.nPoints);
            this.timeBetweenPoints = (float)this.numSeconds / (float)this.nPoints;
            int i = 0;
            while (i < this.nPoints) {
                float time = -((float)this.numSeconds) + (float)i * this.timeBetweenPoints;
                float filt_uV_value = 0.0f;
                GPoint tempPoint = new GPoint(time, filt_uV_value);
                this.channelPoints.set(i, tempPoint);
                ++i;
            }
            this.plot.setPoints(this.channelPoints);
            this.voltageValue = new TextBox("", this.x + 36 + 4 + this.impButton_diameter + (this.w - 36 - 4 - this.impButton_diameter) - 2, this.y + this.h);
            this.voltageValue.textColor = OpenBCI_GUI.this.color(OpenBCI_GUI.this.bgColor);
            this.voltageValue.alignH = 39;
            this.voltageValue.drawBackground = true;
            this.voltageValue.backgroundColor = OpenBCI_GUI.this.color(255, 255, 255, 125);
            this.impValue = new TextBox("", this.x + 36 + 4 + this.impButton_diameter + 2, this.y + this.h);
            this.impValue.textColor = OpenBCI_GUI.this.color(OpenBCI_GUI.this.bgColor);
            this.impValue.alignH = 37;
            this.impValue.drawBackground = true;
            this.impValue.backgroundColor = OpenBCI_GUI.this.color(255, 255, 255, 125);
            this.drawVoltageValue = true;
            this.drawImpValue = false;
        }

        public void update() {
            float val = OpenBCI_GUI.this.dataProcessing.data_std_uV[this.channelNumber - 1];
            this.voltageValue.string = String.valueOf(String.format(this.getFmt(val), Float.valueOf(val))) + " uVrms";
            if (OpenBCI_GUI.this.is_railed != null) {
                if (OpenBCI_GUI.this.is_railed[this.channelNumber - 1].is_railed) {
                    this.voltageValue.string = "RAILED";
                } else if (OpenBCI_GUI.this.is_railed[this.channelNumber - 1].is_railed_warn) {
                    this.voltageValue.string = "NEAR RAILED - " + String.format(this.getFmt(val), Float.valueOf(val)) + " uVrms";
                }
            }
            val = OpenBCI_GUI.this.data_elec_imp_ohm[this.channelNumber - 1] / 1000.0f;
            this.impValue.string = String.valueOf(String.format(this.getFmt(val), Float.valueOf(val))) + " kOhm";
            if (OpenBCI_GUI.this.is_railed != null && OpenBCI_GUI.this.is_railed[this.channelNumber - 1].is_railed) {
                this.impValue.string = "RAILED";
            }
            this.updatePlotPoints();
            if (this.isAutoscale) {
                this.autoScale();
            }
        }

        private String getFmt(float val) {
            String fmt = val > 100.0f ? "%.0f" : (val > 10.0f ? "%.1f" : "%.2f");
            return fmt;
        }

        public void updatePlotPoints() {
            if (OpenBCI_GUI.this.dataBuffY_filtY_uV[this.channelNumber - 1].length > this.nPoints) {
                int i = OpenBCI_GUI.this.dataBuffY_filtY_uV[this.channelNumber - 1].length - this.nPoints;
                while (i < OpenBCI_GUI.this.dataBuffY_filtY_uV[this.channelNumber - 1].length) {
                    float time = -((float)this.numSeconds) + (float)(i - (OpenBCI_GUI.this.dataBuffY_filtY_uV[this.channelNumber - 1].length - this.nPoints)) * this.timeBetweenPoints;
                    float filt_uV_value = OpenBCI_GUI.this.dataBuffY_filtY_uV[this.channelNumber - 1][i];
                    GPoint tempPoint = new GPoint(time, filt_uV_value);
                    this.channelPoints.set(i - (OpenBCI_GUI.this.dataBuffY_filtY_uV[this.channelNumber - 1].length - this.nPoints), tempPoint);
                    ++i;
                }
                this.plot.setPoints(this.channelPoints);
            }
        }

        public void draw() {
            OpenBCI_GUI.this.pushStyle();
            OpenBCI_GUI.this.stroke(31.0f, 69.0f, 110.0f, 50.0f);
            OpenBCI_GUI.this.fill(255);
            OpenBCI_GUI.this.rect(this.x, this.y, this.w, this.h);
            this.onOffButton.draw();
            if (OpenBCI_GUI.this.eegDataSource == 0) {
                this.impCheckButton.draw();
            }
            OpenBCI_GUI.this.stroke(31.0f, 69.0f, 110.0f, 50.0f);
            OpenBCI_GUI.this.fill(OpenBCI_GUI.this.color(125, 30, 12, 30));
            OpenBCI_GUI.this.rect(this.x + 36 + 4 + this.impButton_diameter, this.y, this.w - 36 - 4 - this.impButton_diameter, this.h);
            this.plot.beginDraw();
            this.plot.drawBox();
            this.plot.drawGridLines(0);
            this.plot.drawLines();
            if (this.channelNumber == OpenBCI_GUI.this.nchan) {
                this.plot.drawXAxis();
                this.plot.getXAxis().draw();
            }
            this.plot.endDraw();
            if (this.drawImpValue) {
                this.impValue.draw();
            }
            if (this.drawVoltageValue) {
                this.voltageValue.draw();
            }
            OpenBCI_GUI.this.popStyle();
        }

        public void setDrawImp(boolean _trueFalse) {
            this.drawImpValue = _trueFalse;
        }

        public int nPointsBasedOnDataSource() {
            return this.numSeconds * (int)OpenBCI_GUI.this.getSampleRateSafe();
        }

        public void adjustTimeAxis(int _newTimeSize) {
            this.numSeconds = _newTimeSize;
            this.plot.setXLim((float)(-_newTimeSize), 0.0f);
            this.nPoints = this.nPointsBasedOnDataSource();
            this.channelPoints = new GPointsArray(this.nPoints);
            if (_newTimeSize > 1) {
                this.plot.getXAxis().setNTicks(_newTimeSize);
            } else {
                this.plot.getXAxis().setNTicks(10);
            }
            if (OpenBCI_GUI.this.w_timeSeries.isUpdating()) {
                this.updatePlotPoints();
            }
        }

        public void adjustVertScale(int _vertScaleValue) {
            if (_vertScaleValue == 0) {
                this.isAutoscale = true;
            } else {
                this.isAutoscale = false;
                this.plot.setYLim((float)(-_vertScaleValue), (float)_vertScaleValue);
            }
        }

        public void autoScale() {
            this.autoScaleYLim = 0;
            int i = 0;
            while (i < this.nPoints) {
                if (PApplet.parseInt((float)OpenBCI_GUI.abs((float)this.channelPoints.getY(i))) > this.autoScaleYLim) {
                    this.autoScaleYLim = PApplet.parseInt((float)OpenBCI_GUI.abs((float)this.channelPoints.getY(i)));
                }
                ++i;
            }
            this.plot.setYLim((float)(-this.autoScaleYLim), (float)this.autoScaleYLim);
        }

        public void screenResized(int _x, int _y, int _w, int _h) {
            this.x = _x;
            this.y = _y;
            this.w = _w;
            this.h = _h;
            if (this.h > 26) {
                this.onOffButton.but_dx = this.onOff_diameter = 26;
                this.onOffButton.but_dy = this.onOff_diameter;
            } else {
                this.onOffButton.but_dx = this.onOff_diameter = this.h - 2;
                this.onOffButton.but_dy = this.onOff_diameter;
            }
            this.onOffButton.but_x = this.x + 6;
            this.onOffButton.but_y = this.y + PApplet.parseInt((float)(this.h / 2)) - PApplet.parseInt((float)(this.onOff_diameter / 2));
            if (OpenBCI_GUI.this.eegDataSource == 0) {
                this.impCheckButton.but_x = this.x + 36;
                this.impCheckButton.but_y = this.y + PApplet.parseInt((float)(this.h / 2)) - PApplet.parseInt((float)(this.impButton_diameter / 2));
            }
            this.plot.setPos((float)(this.x + 36 + 4 + this.impButton_diameter), (float)this.y);
            this.plot.setDim((float)(this.w - 36 - 4 - this.impButton_diameter), (float)this.h);
            this.voltageValue.x = this.x + 36 + 4 + this.impButton_diameter + (this.w - 36 - 4 - this.impButton_diameter) - 2;
            this.voltageValue.y = this.y + this.h;
            this.impValue.x = this.x + 36 + 4 + this.impButton_diameter + 2;
            this.impValue.y = this.y + this.h;
        }

        public void mousePressed() {
            if (this.onOffButton.isMouseHere()) {
                OpenBCI_GUI.println((String)("[" + this.channelNumber + "] onOff pressed"));
                this.onOffButton.setIsActive(true);
            }
            if (OpenBCI_GUI.this.eegDataSource == 0 && this.impCheckButton.isMouseHere()) {
                OpenBCI_GUI.println((String)("[" + this.channelNumber + "] imp pressed"));
                this.impCheckButton.setIsActive(true);
            }
        }

        public void mouseReleased() {
            if (this.onOffButton.isMouseHere()) {
                OpenBCI_GUI.println((String)("[" + this.channelNumber + "] onOff released"));
                if (this.isOn) {
                    this.isOn = false;
                    OpenBCI_GUI.this.deactivateChannel(this.channelNumber - 1);
                    this.onOffButton.setColorNotPressed(OpenBCI_GUI.this.color(50));
                } else {
                    this.isOn = true;
                    OpenBCI_GUI.this.activateChannel(this.channelNumber - 1);
                    this.onOffButton.setColorNotPressed(OpenBCI_GUI.this.channelColors[(this.channelNumber - 1) % 8]);
                }
            }
            this.onOffButton.setIsActive(false);
            if (OpenBCI_GUI.this.eegDataSource == 0) {
                if (this.impCheckButton.isMouseHere() && this.impCheckButton.isActive()) {
                    OpenBCI_GUI.println((String)("[" + this.channelNumber + "] imp released"));
                    OpenBCI_GUI.this.w_timeSeries.hsc.toggleImpedanceCheck(this.channelNumber - 1);
                    if (this.drawImpValue) {
                        this.drawImpValue = false;
                        this.impCheckButton.setColorNotPressed(OpenBCI_GUI.this.color(255));
                    } else {
                        this.drawImpValue = true;
                        this.impCheckButton.setColorNotPressed(OpenBCI_GUI.this.color(50));
                    }
                }
                this.impCheckButton.setIsActive(false);
            }
        }
    }

    class ChannelCountBox {
        int x;
        int y;
        int w;
        int h;
        int padding;
        boolean isSystemInitialized;

        ChannelCountBox(int _x, int _y, int _w, int _h, int _padding) {
            this.x = _x;
            this.y = _y;
            this.w = _w;
            this.h = 73;
            this.padding = _padding;
            OpenBCI_GUI.this.chanButton8 = new Button(this.x + this.padding, this.y + this.padding * 2 + 18, (this.w - this.padding * 3) / 2, 24, "8 CHANNELS", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
            if (OpenBCI_GUI.this.nchan == 8) {
                OpenBCI_GUI.this.chanButton8.color_notPressed = OpenBCI_GUI.this.isSelected_color;
            }
            OpenBCI_GUI.this.chanButton16 = new Button(this.x + this.padding * 2 + (this.w - this.padding * 3) / 2, this.y + this.padding * 2 + 18, (this.w - this.padding * 3) / 2, 24, "16 CHANNELS", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
            if (OpenBCI_GUI.this.nchan == 16) {
                OpenBCI_GUI.this.chanButton16.color_notPressed = OpenBCI_GUI.this.isSelected_color;
            }
        }

        public void update() {
        }

        public void draw() {
            OpenBCI_GUI.this.pushStyle();
            OpenBCI_GUI.this.fill(OpenBCI_GUI.this.boxColor);
            OpenBCI_GUI.this.stroke(OpenBCI_GUI.this.boxStrokeColor);
            OpenBCI_GUI.this.strokeWeight(1.0f);
            OpenBCI_GUI.this.rect(this.x, this.y, this.w, this.h);
            OpenBCI_GUI.this.fill(OpenBCI_GUI.this.bgColor);
            OpenBCI_GUI.this.textFont(OpenBCI_GUI.this.h3, 16.0f);
            OpenBCI_GUI.this.textAlign(37, 101);
            OpenBCI_GUI.this.text("CHANNEL COUNT ", this.x + this.padding, this.y + this.padding);
            OpenBCI_GUI.this.fill(OpenBCI_GUI.this.bgColor);
            OpenBCI_GUI.this.textFont(OpenBCI_GUI.this.h3, 16.0f);
            OpenBCI_GUI.this.textAlign(37, 101);
            OpenBCI_GUI.this.text("  (" + OpenBCI_GUI.str((int)OpenBCI_GUI.this.nchan) + ")", this.x + this.padding + 142, this.y + this.padding);
            OpenBCI_GUI.this.popStyle();
            OpenBCI_GUI.this.chanButton8.draw();
            OpenBCI_GUI.this.chanButton8.but_y = this.y + this.padding * 2 + 18;
            OpenBCI_GUI.this.chanButton16.draw();
            OpenBCI_GUI.this.chanButton16.but_y = this.y + this.padding * 2 + 18;
        }
    }

    class ChannelPopup {
        int x;
        int y;
        int w;
        int h;
        int padding;
        boolean clicked;

        ChannelPopup(int _x, int _y, int _w, int _h, int _padding) {
            this.x = _x + _w * 2;
            this.y = _y;
            this.w = _w;
            this.h = 171 + _padding;
            this.padding = _padding;
            this.clicked = false;
            OpenBCI_GUI.this.channelList = new MenuList(OpenBCI_GUI.this.cp5Popup, "channelList", this.w - this.padding * 2, 140, OpenBCI_GUI.this.p4);
            OpenBCI_GUI.this.channelList.setPosition(this.x + this.padding, this.y + this.padding * 3);
            int i = 1;
            while (i < 26) {
                OpenBCI_GUI.this.channelList.addItem(OpenBCI_GUI.this.makeItem(String.valueOf(i)));
                ++i;
            }
        }

        public void update() {
        }

        public void draw() {
            OpenBCI_GUI.this.pushStyle();
            OpenBCI_GUI.this.fill(OpenBCI_GUI.this.boxColor);
            OpenBCI_GUI.this.stroke(OpenBCI_GUI.this.boxStrokeColor);
            OpenBCI_GUI.this.strokeWeight(1.0f);
            OpenBCI_GUI.this.rect(this.x, this.y, this.w, this.h);
            OpenBCI_GUI.this.fill(OpenBCI_GUI.this.bgColor);
            OpenBCI_GUI.this.textFont(OpenBCI_GUI.this.h3, 16.0f);
            OpenBCI_GUI.this.textAlign(37, 101);
            OpenBCI_GUI.this.text("CHANNEL SELECTION", this.x + this.padding, this.y + this.padding);
            OpenBCI_GUI.this.popStyle();
            OpenBCI_GUI.this.refreshPort.draw();
        }

        public void setClicked(boolean click) {
            this.clicked = click;
        }

        public boolean wasClicked() {
            return this.clicked;
        }
    }

    public class Container {
        public float x0;
        public float y0;
        public float w0;
        public float h0;
        public float x;
        public float y;
        public float w;
        public float h;
        public float margin;

        public Container(float _x0, float _y0, float _w0, float _h0, float _margin) {
            this.margin = _margin;
            this.x0 = _x0;
            this.y0 = _y0;
            this.w0 = _w0;
            this.h0 = _h0;
            this.x = this.x0 + this.margin;
            this.y = this.y0 + this.margin;
            this.w = this.w0 - this.margin * 2.0f;
            this.h = this.h0 - this.margin * 2.0f;
        }

        public Container(Container master, String _type) {
            this.margin = master.margin;
            if (_type == "WHOLE") {
                this.x0 = master.x0;
                this.y0 = master.y0;
                this.w0 = master.w0;
                this.h0 = master.h0;
                this.w = master.w;
                this.h = master.h;
                this.x = master.x;
                this.y = master.y;
            } else if (_type == "LEFT") {
                this.x0 = master.x0;
                this.y0 = master.y0;
                this.w0 = master.w0 / 2.0f;
                this.h0 = master.h0;
                this.w = (master.w - this.margin) / 2.0f;
                this.h = master.h;
                this.x = master.x;
                this.y = master.y;
            } else if (_type == "RIGHT") {
                this.x0 = master.x0 + master.w0 / 2.0f;
                this.y0 = master.y0;
                this.w0 = master.w0 / 2.0f;
                this.h0 = master.h0;
                this.w = (master.w - this.margin) / 2.0f;
                this.h = master.h;
                this.x = master.x + this.w + this.margin;
                this.y = master.y;
            } else if (_type == "TOP") {
                this.x0 = master.x0;
                this.y0 = master.y0;
                this.w0 = master.w0;
                this.h0 = master.h0 / 2.0f;
                this.w = master.w;
                this.h = (master.h - this.margin) / 2.0f;
                this.x = master.x;
                this.y = master.y;
            } else if (_type == "BOTTOM") {
                this.x0 = master.x0;
                this.y0 = master.y0 + master.h0 / 2.0f;
                this.w0 = master.w0;
                this.h0 = master.h0 / 2.0f;
                this.w = master.w;
                this.h = (master.h - this.margin) / 2.0f;
                this.x = master.x;
                this.y = master.y + this.h + this.margin;
            } else if (_type == "TOP_LEFT") {
                this.x0 = master.x0;
                this.y0 = master.y0;
                this.w0 = master.w0 / 2.0f;
                this.h0 = master.h0 / 2.0f;
                this.w = (master.w - this.margin) / 2.0f;
                this.h = (master.h - this.margin) / 2.0f;
                this.x = master.x;
                this.y = master.y;
            } else if (_type == "TOP_RIGHT") {
                this.x0 = master.x0 + master.w0 / 2.0f;
                this.y0 = master.y0;
                this.w0 = master.w0 / 2.0f;
                this.h0 = master.h0 / 2.0f;
                this.w = (master.w - this.margin) / 2.0f;
                this.h = (master.h - this.margin) / 2.0f;
                this.x = master.x + this.w + this.margin;
                this.y = master.y;
            } else if (_type == "BOTTOM_LEFT") {
                this.x0 = master.x0;
                this.y0 = master.y0 + master.h0 / 2.0f;
                this.w0 = master.w0 / 2.0f;
                this.h0 = master.h0 / 2.0f;
                this.w = (master.w - this.margin) / 2.0f;
                this.h = (master.h - this.margin) / 2.0f;
                this.x = master.x;
                this.y = master.y + this.h + this.margin;
            } else if (_type == "BOTTOM_RIGHT") {
                this.x0 = master.x0 + master.w0 / 2.0f;
                this.y0 = master.y0 + master.h0 / 2.0f;
                this.w0 = master.w0 / 2.0f;
                this.h0 = master.h0 / 2.0f;
                this.w = (master.w - this.margin) / 2.0f;
                this.h = (master.h - this.margin) / 2.0f;
                this.x = master.x + this.w + this.margin;
                this.y = master.y + this.h + this.margin;
            }
        }

        public void draw() {
            if (OpenBCI_GUI.this.drawContainers) {
                OpenBCI_GUI.this.pushStyle();
                OpenBCI_GUI.this.fill(102.0f, 255.0f, 71.0f, 100.0f);
                OpenBCI_GUI.this.noStroke();
                OpenBCI_GUI.this.rect(this.x0, this.y0, this.w0, this.h0);
                OpenBCI_GUI.this.fill(31.0f, 69.0f, 110.0f, 100.0f);
                OpenBCI_GUI.this.noStroke();
                OpenBCI_GUI.this.rect(this.x, this.y, this.w, this.h);
                OpenBCI_GUI.this.popStyle();
            }
        }
    }

    class ControlPanel {
        public int x = 3;
        public int y;
        public int w;
        public int h;
        public boolean isOpen;
        boolean showSourceBox;
        boolean showSerialBox;
        boolean showFileBox;
        boolean showChannelBox;
        boolean showInitBox;
        PlotFontInfo fontInfo;
        DataSourceBox dataSourceBox;
        SerialBox serialBox;
        DataLogBox dataLogBox;
        ChannelCountBox channelCountBox;
        InitBox initBox;
        SyntheticChannelCountBox synthChannelCountBox;
        PlaybackChannelCountBox playbackChannelCountBox;
        PlaybackFileBox playbackFileBox;
        SDConverterBox sdConverterBox;
        BLEBox bleBox;
        DataLogBoxGanglion dataLogBoxGanglion;
        WifiBox wifiBox;
        InterfaceBoxCyton interfaceBoxCyton;
        InterfaceBoxGanglion interfaceBoxGanglion;
        SampleRateCytonBox sampleRateCytonBox;
        SampleRateGanglionBox sampleRateGanglionBox;
        LatencyCytonBox latencyCytonBox;
        LatencyGanglionBox latencyGanglionBox;
        WifiTransferProtcolCytonBox wifiTransferProtcolCytonBox;
        WifiTransferProtcolGanglionBox wifiTransferProtcolGanglionBox;
        SDBox sdBox;
        boolean drawStopInstructions;
        int globalPadding;
        int globalBorder;
        boolean convertingSD = false;

        ControlPanel(OpenBCI_GUI mainClass) {
            this.y = 3 + OpenBCI_GUI.this.topNav.controlPanelCollapser.but_dy;
            this.w = OpenBCI_GUI.this.topNav.controlPanelCollapser.but_dx;
            this.h = OpenBCI_GUI.this.height - PApplet.parseInt((float)OpenBCI_GUI.this.helpWidget.h);
            this.isOpen = !OpenBCI_GUI.this.hasIntroAnimation;
            this.fontInfo = new PlotFontInfo();
            this.globalPadding = 10;
            this.globalBorder = 0;
            OpenBCI_GUI.this.cp5 = new ControlP5((PApplet)mainClass);
            OpenBCI_GUI.this.cp5Popup = new ControlP5((PApplet)mainClass);
            OpenBCI_GUI.this.cp5.setAutoDraw(false);
            OpenBCI_GUI.this.cp5Popup.setAutoDraw(false);
            this.dataSourceBox = new DataSourceBox(this.x, this.y, this.w, this.h, this.globalPadding);
            this.interfaceBoxCyton = new InterfaceBoxCyton(this.x + this.w, this.dataSourceBox.y, this.w, this.h, this.globalPadding);
            this.interfaceBoxGanglion = new InterfaceBoxGanglion(this.x + this.w, this.dataSourceBox.y, this.w, this.h, this.globalPadding);
            this.serialBox = new SerialBox(this.x + this.w, this.interfaceBoxCyton.y + this.interfaceBoxCyton.h, this.w, this.h, this.globalPadding);
            this.wifiBox = new WifiBox(this.x + this.w, this.interfaceBoxCyton.y + this.interfaceBoxCyton.h, this.w, this.h, this.globalPadding);
            this.dataLogBox = new DataLogBox(this.x + this.w, this.serialBox.y + this.serialBox.h, this.w, this.h, this.globalPadding);
            this.channelCountBox = new ChannelCountBox(this.x + this.w, this.dataLogBox.y + this.dataLogBox.h, this.w, this.h, this.globalPadding);
            this.synthChannelCountBox = new SyntheticChannelCountBox(this.x + this.w, this.dataSourceBox.y, this.w, this.h, this.globalPadding);
            this.sdBox = new SDBox(this.x + this.w, this.channelCountBox.y + this.channelCountBox.h, this.w, this.h, this.globalPadding);
            this.sampleRateCytonBox = new SampleRateCytonBox(this.x + this.w + this.x + this.w - 3, this.channelCountBox.y, this.w, this.h, this.globalPadding);
            this.latencyCytonBox = new LatencyCytonBox(this.x + this.w + this.x + this.w - 3, this.sampleRateCytonBox.y + this.sampleRateCytonBox.h, this.w, this.h, this.globalPadding);
            this.wifiTransferProtcolCytonBox = new WifiTransferProtcolCytonBox(this.x + this.w + this.x + this.w - 3, this.latencyCytonBox.y + this.latencyCytonBox.h, this.w, this.h, this.globalPadding);
            this.playbackChannelCountBox = new PlaybackChannelCountBox(this.x + this.w, this.dataSourceBox.y, this.w, this.h, this.globalPadding);
            this.playbackFileBox = new PlaybackFileBox(this.x + this.w, this.playbackChannelCountBox.y + this.playbackChannelCountBox.h, this.w, this.h, this.globalPadding);
            this.sdConverterBox = new SDConverterBox(this.x + this.w, this.playbackFileBox.y + this.playbackFileBox.h, this.w, this.h, this.globalPadding);
            OpenBCI_GUI.this.rcBox = new RadioConfigBox(this.x + this.w, this.y, this.w, this.h, this.globalPadding);
            OpenBCI_GUI.this.channelPopup = new ChannelPopup(this.x + this.w, this.y, this.w, this.h, this.globalPadding);
            OpenBCI_GUI.this.pollPopup = new PollPopup(this.x + this.w, this.y, this.w, this.h, this.globalPadding);
            OpenBCI_GUI.this.wcBox = new WifiConfigBox(this.x + this.w, this.y, this.w, this.h, this.globalPadding);
            this.initBox = new InitBox(this.x, this.dataSourceBox.y + this.dataSourceBox.h, this.w, this.h, this.globalPadding);
            this.bleBox = new BLEBox(this.x + this.w, this.interfaceBoxGanglion.y + this.interfaceBoxGanglion.h, this.w, this.h, this.globalPadding);
            this.dataLogBoxGanglion = new DataLogBoxGanglion(this.x + this.w, this.bleBox.y + this.bleBox.h, this.w, this.h, this.globalPadding);
            this.sampleRateGanglionBox = new SampleRateGanglionBox(this.x + this.w, this.dataLogBoxGanglion.y + this.dataLogBoxGanglion.h, this.w, this.h, this.globalPadding);
            this.latencyGanglionBox = new LatencyGanglionBox(this.x + this.w, this.sampleRateGanglionBox.y + this.sampleRateGanglionBox.h, this.w, this.h, this.globalPadding);
            this.wifiTransferProtcolGanglionBox = new WifiTransferProtcolGanglionBox(this.x + this.w, this.latencyGanglionBox.y + this.latencyGanglionBox.h, this.w, this.h, this.globalPadding);
        }

        public void resetListItems() {
            OpenBCI_GUI.this.serialList.activeItem = -1;
            OpenBCI_GUI.this.bleList.activeItem = -1;
            OpenBCI_GUI.this.wifiList.activeItem = -1;
        }

        public void open() {
            this.isOpen = true;
            OpenBCI_GUI.this.topNav.controlPanelCollapser.setIsActive(true);
        }

        public void close() {
            this.isOpen = false;
            OpenBCI_GUI.this.topNav.controlPanelCollapser.setIsActive(false);
        }

        public void update() {
            if (this.isOpen) {
                if (!OpenBCI_GUI.this.cp5.isVisible()) {
                    OpenBCI_GUI.this.cp5.show();
                    OpenBCI_GUI.this.cp5Popup.show();
                }
            } else if (OpenBCI_GUI.this.cp5.isVisible()) {
                OpenBCI_GUI.this.cp5.hide();
                OpenBCI_GUI.this.cp5Popup.hide();
            }
            if (Serial.list().length != OpenBCI_GUI.this.serialPorts.length && OpenBCI_GUI.this.systemMode != 10) {
                OpenBCI_GUI.println((String)"Refreshing port list...");
                this.refreshPortList();
            }
            this.dataSourceBox.update();
            this.serialBox.update();
            this.bleBox.update();
            this.dataLogBox.update();
            this.channelCountBox.update();
            this.synthChannelCountBox.update();
            this.playbackChannelCountBox.update();
            this.sdBox.update();
            OpenBCI_GUI.this.rcBox.update();
            OpenBCI_GUI.this.wcBox.update();
            this.initBox.update();
            OpenBCI_GUI.this.channelPopup.update();
            OpenBCI_GUI.this.serialList.updateMenu();
            OpenBCI_GUI.this.bleList.updateMenu();
            OpenBCI_GUI.this.wifiList.updateMenu();
            this.dataLogBoxGanglion.update();
            this.latencyCytonBox.update();
            this.wifiTransferProtcolCytonBox.update();
            this.wifiBox.update();
            this.interfaceBoxCyton.update();
            this.interfaceBoxGanglion.update();
            this.latencyGanglionBox.update();
            this.wifiTransferProtcolGanglionBox.update();
            while (this.convertingSD) {
                OpenBCI_GUI.this.convertSDFile();
            }
            if (OpenBCI_GUI.this.isHubInitialized && OpenBCI_GUI.this.isHubObjectInitialized) {
                if (!(OpenBCI_GUI.this.ganglion.getInterface() != 1 && OpenBCI_GUI.this.ganglion.getInterface() != 3 || OpenBCI_GUI.this.calledForBLEList)) {
                    OpenBCI_GUI.this.calledForBLEList = true;
                    if (OpenBCI_GUI.this.hub.isHubRunning()) {
                        OpenBCI_GUI.this.hub.searchDeviceStart();
                    }
                }
                if (!(OpenBCI_GUI.this.ganglion.getInterface() != 2 && OpenBCI_GUI.this.cyton.getInterface() != 2 || OpenBCI_GUI.this.calledForWifiList)) {
                    OpenBCI_GUI.this.calledForWifiList = true;
                    if (OpenBCI_GUI.this.hub.isHubRunning()) {
                        OpenBCI_GUI.this.hub.searchDeviceStart();
                    }
                }
            }
        }

        public void draw() {
            OpenBCI_GUI.this.pushStyle();
            OpenBCI_GUI.this.noStroke();
            this.initBox.draw();
            if (OpenBCI_GUI.this.systemMode == 10) {
                this.drawStopInstructions = true;
            }
            if (OpenBCI_GUI.this.systemMode != 10) {
                this.dataSourceBox.draw();
                this.drawStopInstructions = false;
                OpenBCI_GUI.this.cp5.setVisible(true);
                OpenBCI_GUI.this.cp5Popup.setVisible(true);
                if (OpenBCI_GUI.this.eegDataSource == 0) {
                    if (OpenBCI_GUI.this.cyton.getInterface() == -1) {
                        this.interfaceBoxCyton.draw();
                    } else {
                        this.interfaceBoxCyton.draw();
                        if (OpenBCI_GUI.this.cyton.getInterface() == 0) {
                            this.serialBox.y = this.interfaceBoxCyton.y + this.interfaceBoxCyton.h;
                            this.serialBox.draw();
                            this.dataLogBox.y = this.serialBox.y + this.serialBox.h;
                            ((MenuList)((Object)OpenBCI_GUI.this.cp5.get(MenuList.class, "serialList"))).setVisible(true);
                            if (OpenBCI_GUI.this.rcBox.isShowing) {
                                OpenBCI_GUI.this.rcBox.draw();
                                if (OpenBCI_GUI.this.channelPopup.wasClicked()) {
                                    OpenBCI_GUI.this.channelPopup.draw();
                                    ((MenuList)((Object)OpenBCI_GUI.this.cp5Popup.get(MenuList.class, "channelList"))).setVisible(true);
                                    ((MenuList)((Object)OpenBCI_GUI.this.cp5Popup.get(MenuList.class, "pollList"))).setVisible(false);
                                    ((MenuList)((Object)OpenBCI_GUI.this.cp5.get(MenuList.class, "serialList"))).setVisible(true);
                                    ((MenuList)((Object)OpenBCI_GUI.this.cp5.get(MenuList.class, "sdTimes"))).setVisible(true);
                                } else if (OpenBCI_GUI.this.pollPopup.wasClicked()) {
                                    OpenBCI_GUI.this.pollPopup.draw();
                                    ((MenuList)((Object)OpenBCI_GUI.this.cp5Popup.get(MenuList.class, "pollList"))).setVisible(true);
                                    ((MenuList)((Object)OpenBCI_GUI.this.cp5Popup.get(MenuList.class, "channelList"))).setVisible(false);
                                    ((Textfield)OpenBCI_GUI.this.cp5.get(Textfield.class, "fileName")).setVisible(true);
                                    ((MenuList)((Object)OpenBCI_GUI.this.cp5.get(MenuList.class, "serialList"))).setVisible(true);
                                    ((MenuList)((Object)OpenBCI_GUI.this.cp5.get(MenuList.class, "sdTimes"))).setVisible(true);
                                    ((Textfield)OpenBCI_GUI.this.cp5.get(Textfield.class, "staticIPAddress")).setVisible(false);
                                }
                            }
                        } else if (OpenBCI_GUI.this.cyton.getInterface() == 2) {
                            this.wifiBox.y = this.interfaceBoxCyton.y + this.interfaceBoxCyton.h;
                            this.wifiBox.draw();
                            this.dataLogBox.y = this.wifiBox.y + this.wifiBox.h;
                            if (OpenBCI_GUI.this.hub.getWiFiStyle() == OpenBCI_GUI.WIFI_STATIC) {
                                ((Textfield)OpenBCI_GUI.this.cp5.get(Textfield.class, "staticIPAddress")).setVisible(true);
                                ((MenuList)((Object)OpenBCI_GUI.this.cp5.get(MenuList.class, "wifiList"))).setVisible(false);
                            } else {
                                ((Textfield)OpenBCI_GUI.this.cp5.get(Textfield.class, "staticIPAddress")).setVisible(false);
                                ((MenuList)((Object)OpenBCI_GUI.this.cp5.get(MenuList.class, "wifiList"))).setVisible(true);
                            }
                            if (OpenBCI_GUI.this.wcBox.isShowing) {
                                OpenBCI_GUI.this.wcBox.draw();
                            }
                            this.sampleRateCytonBox.draw();
                            this.latencyCytonBox.draw();
                            this.wifiTransferProtcolCytonBox.draw();
                        }
                        this.channelCountBox.y = this.dataLogBox.y + this.dataLogBox.h;
                        this.sdBox.y = this.channelCountBox.y + this.channelCountBox.h;
                        this.sampleRateCytonBox.y = this.channelCountBox.y;
                        this.latencyCytonBox.y = this.sampleRateCytonBox.y + this.sampleRateCytonBox.h;
                        this.wifiTransferProtcolCytonBox.y = this.latencyCytonBox.y + this.latencyCytonBox.h;
                        this.dataLogBox.draw();
                        this.channelCountBox.draw();
                        this.sdBox.draw();
                        ((Textfield)OpenBCI_GUI.this.cp5.get(Textfield.class, "fileName")).setVisible(true);
                        ((Textfield)OpenBCI_GUI.this.cp5.get(Textfield.class, "fileNameGanglion")).setVisible(false);
                        ((MenuList)((Object)OpenBCI_GUI.this.cp5.get(MenuList.class, "sdTimes"))).setVisible(true);
                    }
                } else if (OpenBCI_GUI.this.eegDataSource == 2) {
                    this.playbackChannelCountBox.draw();
                    this.playbackFileBox.draw();
                    this.sdConverterBox.draw();
                    ((MenuList)((Object)OpenBCI_GUI.this.cp5.get(MenuList.class, "serialList"))).setVisible(false);
                    ((MenuList)((Object)OpenBCI_GUI.this.cp5.get(MenuList.class, "sdTimes"))).setVisible(false);
                    ((MenuList)((Object)OpenBCI_GUI.this.cp5Popup.get(MenuList.class, "channelList"))).setVisible(false);
                    ((MenuList)((Object)OpenBCI_GUI.this.cp5Popup.get(MenuList.class, "pollList"))).setVisible(false);
                } else if (OpenBCI_GUI.this.eegDataSource == 3) {
                    this.synthChannelCountBox.draw();
                } else if (OpenBCI_GUI.this.eegDataSource == 1) {
                    if (OpenBCI_GUI.this.ganglion.getInterface() == -1) {
                        this.interfaceBoxGanglion.draw();
                    } else {
                        this.interfaceBoxGanglion.draw();
                        if (OpenBCI_GUI.this.ganglion.getInterface() == 1 || OpenBCI_GUI.this.ganglion.getInterface() == 3) {
                            this.bleBox.y = this.interfaceBoxGanglion.y + this.interfaceBoxGanglion.h;
                            this.dataLogBoxGanglion.y = this.bleBox.y + this.bleBox.h;
                            this.bleBox.draw();
                            ((MenuList)((Object)OpenBCI_GUI.this.cp5.get(MenuList.class, "bleList"))).setVisible(true);
                            ((Textfield)OpenBCI_GUI.this.cp5.get(Textfield.class, "staticIPAddress")).setVisible(false);
                        } else if (OpenBCI_GUI.this.ganglion.getInterface() == 2) {
                            this.wifiBox.y = this.interfaceBoxGanglion.y + this.interfaceBoxGanglion.h;
                            this.dataLogBoxGanglion.y = this.wifiBox.y + this.wifiBox.h;
                            this.wifiBox.draw();
                            if (OpenBCI_GUI.this.hub.getWiFiStyle() == OpenBCI_GUI.WIFI_STATIC) {
                                ((Textfield)OpenBCI_GUI.this.cp5.get(Textfield.class, "staticIPAddress")).setVisible(true);
                                ((MenuList)((Object)OpenBCI_GUI.this.cp5.get(MenuList.class, "wifiList"))).setVisible(false);
                            } else {
                                ((Textfield)OpenBCI_GUI.this.cp5.get(Textfield.class, "staticIPAddress")).setVisible(false);
                                ((MenuList)((Object)OpenBCI_GUI.this.cp5.get(MenuList.class, "wifiList"))).setVisible(true);
                            }
                            if (OpenBCI_GUI.this.wcBox.isShowing) {
                                OpenBCI_GUI.this.wcBox.draw();
                            }
                            this.latencyGanglionBox.y = this.dataLogBoxGanglion.y + this.dataLogBoxGanglion.h;
                            this.sampleRateGanglionBox.y = this.latencyGanglionBox.y + this.latencyGanglionBox.h;
                            this.wifiTransferProtcolGanglionBox.y += this.wifiTransferProtcolGanglionBox.h;
                            this.latencyGanglionBox.draw();
                            this.sampleRateGanglionBox.draw();
                            this.wifiTransferProtcolGanglionBox.draw();
                        }
                        this.dataLogBoxGanglion.draw();
                        ((Textfield)OpenBCI_GUI.this.cp5.get(Textfield.class, "fileName")).setVisible(false);
                        ((Textfield)OpenBCI_GUI.this.cp5.get(Textfield.class, "fileNameGanglion")).setVisible(true);
                    }
                } else {
                    this.hideAllBoxes();
                }
            } else {
                OpenBCI_GUI.this.cp5.setVisible(false);
                OpenBCI_GUI.this.cp5Popup.setVisible(false);
            }
            if (this.drawStopInstructions) {
                OpenBCI_GUI.this.pushStyle();
                OpenBCI_GUI.this.fill(OpenBCI_GUI.this.boxColor);
                OpenBCI_GUI.this.strokeWeight(1.0f);
                OpenBCI_GUI.this.stroke(OpenBCI_GUI.this.boxStrokeColor);
                OpenBCI_GUI.this.rect(this.x, this.y, this.w, this.dataSourceBox.h);
                String stopInstructions = "Press the \"STOP SYSTEM\" button to change your data source or edit system settings.";
                OpenBCI_GUI.this.textAlign(3, 101);
                OpenBCI_GUI.this.textFont(OpenBCI_GUI.this.p4, 14.0f);
                OpenBCI_GUI.this.fill(OpenBCI_GUI.this.bgColor);
                OpenBCI_GUI.this.text(stopInstructions, this.x + this.globalPadding * 2, this.y + this.globalPadding * 3, this.w - this.globalPadding * 4, this.dataSourceBox.h - this.globalPadding * 4);
                OpenBCI_GUI.this.popStyle();
            }
            OpenBCI_GUI.this.textFont(OpenBCI_GUI.this.p4, 14.0f);
            OpenBCI_GUI.this.cp5Popup.draw();
            OpenBCI_GUI.this.cp5.draw();
            OpenBCI_GUI.this.popStyle();
        }

        public void hideRadioPopoutBox() {
            OpenBCI_GUI.this.rcBox.isShowing = false;
            OpenBCI_GUI.this.cp5Popup.hide();
            ((MenuList)((Object)OpenBCI_GUI.this.cp5Popup.get(MenuList.class, "channelList"))).setVisible(false);
            ((MenuList)((Object)OpenBCI_GUI.this.cp5Popup.get(MenuList.class, "pollList"))).setVisible(false);
            OpenBCI_GUI.this.popOutRadioConfigButton.setString(">");
            OpenBCI_GUI.this.rcBox.print_onscreen("");
            if (OpenBCI_GUI.this.board != null) {
                OpenBCI_GUI.this.board.stop();
            }
            OpenBCI_GUI.this.board = null;
        }

        public void hideWifiPopoutBox() {
            OpenBCI_GUI.this.wcBox.isShowing = false;
            OpenBCI_GUI.this.popOutWifiConfigButton.setString(">");
            OpenBCI_GUI.this.wcBox.updateMessage("");
            if (OpenBCI_GUI.this.hub.isPortOpen()) {
                OpenBCI_GUI.this.hub.closePort();
            }
        }

        public void refreshPortList() {
            OpenBCI_GUI.this.serialPorts = new String[Serial.list().length];
            OpenBCI_GUI.this.serialPorts = Serial.list();
            OpenBCI_GUI.this.serialList.items.clear();
            int i = 0;
            while (i < OpenBCI_GUI.this.serialPorts.length) {
                String tempPort = OpenBCI_GUI.this.serialPorts[OpenBCI_GUI.this.serialPorts.length - 1 - i];
                OpenBCI_GUI.this.serialList.addItem(OpenBCI_GUI.this.makeItem(tempPort));
                ++i;
            }
            OpenBCI_GUI.this.serialList.updateMenu();
        }

        public void hideAllBoxes() {
            ((Textfield)OpenBCI_GUI.this.cp5.get(Textfield.class, "fileName")).setVisible(false);
            ((Textfield)OpenBCI_GUI.this.cp5.get(Textfield.class, "staticIPAddress")).setVisible(false);
            ((Textfield)OpenBCI_GUI.this.cp5.get(Textfield.class, "fileNameGanglion")).setVisible(false);
            ((MenuList)((Object)OpenBCI_GUI.this.cp5.get(MenuList.class, "serialList"))).setVisible(false);
            ((MenuList)((Object)OpenBCI_GUI.this.cp5.get(MenuList.class, "bleList"))).setVisible(false);
            ((MenuList)((Object)OpenBCI_GUI.this.cp5.get(MenuList.class, "sdTimes"))).setVisible(false);
            ((MenuList)((Object)OpenBCI_GUI.this.cp5.get(MenuList.class, "wifiList"))).setVisible(false);
            ((MenuList)((Object)OpenBCI_GUI.this.cp5Popup.get(MenuList.class, "channelList"))).setVisible(false);
            ((MenuList)((Object)OpenBCI_GUI.this.cp5Popup.get(MenuList.class, "pollList"))).setVisible(false);
        }

        public void CPmousePressed() {
            if (OpenBCI_GUI.this.initSystemButton.isMouseHere()) {
                OpenBCI_GUI.this.initSystemButton.setIsActive(true);
                OpenBCI_GUI.this.initSystemButton.wasPressed = true;
            }
            if (OpenBCI_GUI.this.systemMode != 10) {
                if ((OpenBCI_GUI.this.eegDataSource == 0 || OpenBCI_GUI.this.eegDataSource == 1) && (OpenBCI_GUI.this.cyton.isWifi() || OpenBCI_GUI.this.ganglion.isWifi())) {
                    if (OpenBCI_GUI.this.getIpAddress.isMouseHere()) {
                        OpenBCI_GUI.this.getIpAddress.setIsActive(true);
                        OpenBCI_GUI.this.getIpAddress.wasPressed = true;
                    }
                    if (OpenBCI_GUI.this.getFirmwareVersion.isMouseHere()) {
                        OpenBCI_GUI.this.getFirmwareVersion.setIsActive(true);
                        OpenBCI_GUI.this.getFirmwareVersion.wasPressed = true;
                    }
                    if (OpenBCI_GUI.this.getMacAddress.isMouseHere()) {
                        OpenBCI_GUI.this.getMacAddress.setIsActive(true);
                        OpenBCI_GUI.this.getMacAddress.wasPressed = true;
                    }
                    if (OpenBCI_GUI.this.eraseCredentials.isMouseHere()) {
                        OpenBCI_GUI.this.eraseCredentials.setIsActive(true);
                        OpenBCI_GUI.this.eraseCredentials.wasPressed = true;
                    }
                    if (OpenBCI_GUI.this.getTypeOfAttachedBoard.isMouseHere()) {
                        OpenBCI_GUI.this.getTypeOfAttachedBoard.setIsActive(true);
                        OpenBCI_GUI.this.getTypeOfAttachedBoard.wasPressed = true;
                    }
                    if (OpenBCI_GUI.this.popOutWifiConfigButton.isMouseHere()) {
                        OpenBCI_GUI.this.popOutWifiConfigButton.setIsActive(true);
                        OpenBCI_GUI.this.popOutWifiConfigButton.wasPressed = true;
                    }
                    if (OpenBCI_GUI.this.wifiIPAddressDyanmic.isMouseHere()) {
                        OpenBCI_GUI.this.wifiIPAddressDyanmic.setIsActive(true);
                        OpenBCI_GUI.this.wifiIPAddressDyanmic.wasPressed = true;
                        OpenBCI_GUI.this.wifiIPAddressDyanmic.color_notPressed = OpenBCI_GUI.this.isSelected_color;
                        OpenBCI_GUI.this.wifiIPAddressStatic.color_notPressed = OpenBCI_GUI.this.autoFileName.color_notPressed;
                    }
                    if (OpenBCI_GUI.this.wifiIPAddressStatic.isMouseHere()) {
                        OpenBCI_GUI.this.wifiIPAddressStatic.setIsActive(true);
                        OpenBCI_GUI.this.wifiIPAddressStatic.wasPressed = true;
                        OpenBCI_GUI.this.wifiIPAddressStatic.color_notPressed = OpenBCI_GUI.this.isSelected_color;
                        OpenBCI_GUI.this.wifiIPAddressDyanmic.color_notPressed = OpenBCI_GUI.this.autoFileName.color_notPressed;
                    }
                }
                if (OpenBCI_GUI.this.eegDataSource == 0) {
                    if (OpenBCI_GUI.this.cyton.isSerial()) {
                        if (OpenBCI_GUI.this.popOutRadioConfigButton.isMouseHere()) {
                            OpenBCI_GUI.this.popOutRadioConfigButton.setIsActive(true);
                            OpenBCI_GUI.this.popOutRadioConfigButton.wasPressed = true;
                        }
                        if (OpenBCI_GUI.this.refreshPort.isMouseHere()) {
                            OpenBCI_GUI.this.refreshPort.setIsActive(true);
                            OpenBCI_GUI.this.refreshPort.wasPressed = true;
                        }
                    }
                    if (OpenBCI_GUI.this.cyton.isWifi() && OpenBCI_GUI.this.refreshWifi.isMouseHere()) {
                        OpenBCI_GUI.this.refreshWifi.setIsActive(true);
                        OpenBCI_GUI.this.refreshWifi.wasPressed = true;
                    }
                    if (OpenBCI_GUI.this.autoFileName.isMouseHere()) {
                        OpenBCI_GUI.this.autoFileName.setIsActive(true);
                        OpenBCI_GUI.this.autoFileName.wasPressed = true;
                    }
                    if (OpenBCI_GUI.this.outputODF.isMouseHere()) {
                        OpenBCI_GUI.this.outputODF.setIsActive(true);
                        OpenBCI_GUI.this.outputODF.wasPressed = true;
                        OpenBCI_GUI.this.outputODF.color_notPressed = OpenBCI_GUI.this.isSelected_color;
                        OpenBCI_GUI.this.outputBDF.color_notPressed = OpenBCI_GUI.this.autoFileName.color_notPressed;
                    }
                    if (OpenBCI_GUI.this.outputBDF.isMouseHere()) {
                        OpenBCI_GUI.this.outputBDF.setIsActive(true);
                        OpenBCI_GUI.this.outputBDF.wasPressed = true;
                        OpenBCI_GUI.this.outputBDF.color_notPressed = OpenBCI_GUI.this.isSelected_color;
                        OpenBCI_GUI.this.outputODF.color_notPressed = OpenBCI_GUI.this.autoFileName.color_notPressed;
                    }
                    if (OpenBCI_GUI.this.chanButton8.isMouseHere()) {
                        OpenBCI_GUI.this.chanButton8.setIsActive(true);
                        OpenBCI_GUI.this.chanButton8.wasPressed = true;
                        OpenBCI_GUI.this.chanButton8.color_notPressed = OpenBCI_GUI.this.isSelected_color;
                        OpenBCI_GUI.this.chanButton16.color_notPressed = OpenBCI_GUI.this.autoFileName.color_notPressed;
                    }
                    if (OpenBCI_GUI.this.chanButton16.isMouseHere()) {
                        OpenBCI_GUI.this.chanButton16.setIsActive(true);
                        OpenBCI_GUI.this.chanButton16.wasPressed = true;
                        OpenBCI_GUI.this.chanButton8.color_notPressed = OpenBCI_GUI.this.autoFileName.color_notPressed;
                        OpenBCI_GUI.this.chanButton16.color_notPressed = OpenBCI_GUI.this.isSelected_color;
                    }
                    if (OpenBCI_GUI.this.getChannel.isMouseHere()) {
                        OpenBCI_GUI.this.getChannel.setIsActive(true);
                        OpenBCI_GUI.this.getChannel.wasPressed = true;
                    }
                    if (OpenBCI_GUI.this.setChannel.isMouseHere()) {
                        OpenBCI_GUI.this.setChannel.setIsActive(true);
                        OpenBCI_GUI.this.setChannel.wasPressed = true;
                    }
                    if (OpenBCI_GUI.this.ovrChannel.isMouseHere()) {
                        OpenBCI_GUI.this.ovrChannel.setIsActive(true);
                        OpenBCI_GUI.this.ovrChannel.wasPressed = true;
                    }
                    if (OpenBCI_GUI.this.protocolWifiCyton.isMouseHere()) {
                        OpenBCI_GUI.this.protocolWifiCyton.setIsActive(true);
                        OpenBCI_GUI.this.protocolWifiCyton.wasPressed = true;
                        OpenBCI_GUI.this.protocolWifiCyton.color_notPressed = OpenBCI_GUI.this.isSelected_color;
                        OpenBCI_GUI.this.protocolSerialCyton.color_notPressed = OpenBCI_GUI.this.autoFileName.color_notPressed;
                    }
                    if (OpenBCI_GUI.this.protocolSerialCyton.isMouseHere()) {
                        OpenBCI_GUI.this.protocolSerialCyton.setIsActive(true);
                        OpenBCI_GUI.this.protocolSerialCyton.wasPressed = true;
                        OpenBCI_GUI.this.protocolWifiCyton.color_notPressed = OpenBCI_GUI.this.autoFileName.color_notPressed;
                        OpenBCI_GUI.this.protocolSerialCyton.color_notPressed = OpenBCI_GUI.this.isSelected_color;
                    }
                    if (OpenBCI_GUI.this.autoscan.isMouseHere()) {
                        OpenBCI_GUI.this.autoscan.setIsActive(true);
                        OpenBCI_GUI.this.autoscan.wasPressed = true;
                    }
                    if (OpenBCI_GUI.this.systemStatus.isMouseHere()) {
                        OpenBCI_GUI.this.systemStatus.setIsActive(true);
                        OpenBCI_GUI.this.systemStatus.wasPressed = true;
                    }
                    if (OpenBCI_GUI.this.sampleRate250.isMouseHere()) {
                        OpenBCI_GUI.this.sampleRate250.setIsActive(true);
                        OpenBCI_GUI.this.sampleRate250.wasPressed = true;
                        OpenBCI_GUI.this.sampleRate250.color_notPressed = OpenBCI_GUI.this.isSelected_color;
                        OpenBCI_GUI.this.sampleRate500.color_notPressed = OpenBCI_GUI.this.autoFileName.color_notPressed;
                        OpenBCI_GUI.this.sampleRate1000.color_notPressed = OpenBCI_GUI.this.autoFileName.color_notPressed;
                    }
                    if (OpenBCI_GUI.this.sampleRate500.isMouseHere()) {
                        OpenBCI_GUI.this.sampleRate500.setIsActive(true);
                        OpenBCI_GUI.this.sampleRate500.wasPressed = true;
                        OpenBCI_GUI.this.sampleRate500.color_notPressed = OpenBCI_GUI.this.isSelected_color;
                        OpenBCI_GUI.this.sampleRate250.color_notPressed = OpenBCI_GUI.this.autoFileName.color_notPressed;
                        OpenBCI_GUI.this.sampleRate1000.color_notPressed = OpenBCI_GUI.this.autoFileName.color_notPressed;
                    }
                    if (OpenBCI_GUI.this.sampleRate1000.isMouseHere()) {
                        OpenBCI_GUI.this.sampleRate1000.setIsActive(true);
                        OpenBCI_GUI.this.sampleRate1000.wasPressed = true;
                        OpenBCI_GUI.this.sampleRate1000.color_notPressed = OpenBCI_GUI.this.isSelected_color;
                        OpenBCI_GUI.this.sampleRate250.color_notPressed = OpenBCI_GUI.this.autoFileName.color_notPressed;
                        OpenBCI_GUI.this.sampleRate500.color_notPressed = OpenBCI_GUI.this.autoFileName.color_notPressed;
                    }
                    if (OpenBCI_GUI.this.latencyCyton5ms.isMouseHere()) {
                        OpenBCI_GUI.this.latencyCyton5ms.setIsActive(true);
                        OpenBCI_GUI.this.latencyCyton5ms.wasPressed = true;
                        OpenBCI_GUI.this.latencyCyton5ms.color_notPressed = OpenBCI_GUI.this.isSelected_color;
                        OpenBCI_GUI.this.latencyCyton10ms.color_notPressed = OpenBCI_GUI.this.autoFileName.color_notPressed;
                        OpenBCI_GUI.this.latencyCyton20ms.color_notPressed = OpenBCI_GUI.this.autoFileName.color_notPressed;
                    }
                    if (OpenBCI_GUI.this.latencyCyton10ms.isMouseHere()) {
                        OpenBCI_GUI.this.latencyCyton10ms.setIsActive(true);
                        OpenBCI_GUI.this.latencyCyton10ms.wasPressed = true;
                        OpenBCI_GUI.this.latencyCyton10ms.color_notPressed = OpenBCI_GUI.this.isSelected_color;
                        OpenBCI_GUI.this.latencyCyton5ms.color_notPressed = OpenBCI_GUI.this.autoFileName.color_notPressed;
                        OpenBCI_GUI.this.latencyCyton20ms.color_notPressed = OpenBCI_GUI.this.autoFileName.color_notPressed;
                    }
                    if (OpenBCI_GUI.this.latencyCyton20ms.isMouseHere()) {
                        OpenBCI_GUI.this.latencyCyton20ms.setIsActive(true);
                        OpenBCI_GUI.this.latencyCyton20ms.wasPressed = true;
                        OpenBCI_GUI.this.latencyCyton20ms.color_notPressed = OpenBCI_GUI.this.isSelected_color;
                        OpenBCI_GUI.this.latencyCyton5ms.color_notPressed = OpenBCI_GUI.this.autoFileName.color_notPressed;
                        OpenBCI_GUI.this.latencyCyton10ms.color_notPressed = OpenBCI_GUI.this.autoFileName.color_notPressed;
                    }
                    if (OpenBCI_GUI.this.wifiInternetProtocolCytonTCP.isMouseHere()) {
                        OpenBCI_GUI.this.wifiInternetProtocolCytonTCP.setIsActive(true);
                        OpenBCI_GUI.this.wifiInternetProtocolCytonTCP.wasPressed = true;
                        OpenBCI_GUI.this.wifiInternetProtocolCytonTCP.color_notPressed = OpenBCI_GUI.this.isSelected_color;
                        OpenBCI_GUI.this.wifiInternetProtocolCytonUDP.color_notPressed = OpenBCI_GUI.this.autoFileName.color_notPressed;
                        OpenBCI_GUI.this.wifiInternetProtocolCytonUDPBurst.color_notPressed = OpenBCI_GUI.this.autoFileName.color_notPressed;
                    }
                    if (OpenBCI_GUI.this.wifiInternetProtocolCytonUDP.isMouseHere()) {
                        OpenBCI_GUI.this.wifiInternetProtocolCytonUDP.setIsActive(true);
                        OpenBCI_GUI.this.wifiInternetProtocolCytonUDP.wasPressed = true;
                        OpenBCI_GUI.this.wifiInternetProtocolCytonUDP.color_notPressed = OpenBCI_GUI.this.isSelected_color;
                        OpenBCI_GUI.this.wifiInternetProtocolCytonTCP.color_notPressed = OpenBCI_GUI.this.autoFileName.color_notPressed;
                        OpenBCI_GUI.this.wifiInternetProtocolCytonUDPBurst.color_notPressed = OpenBCI_GUI.this.autoFileName.color_notPressed;
                    }
                    if (OpenBCI_GUI.this.wifiInternetProtocolCytonUDPBurst.isMouseHere()) {
                        OpenBCI_GUI.this.wifiInternetProtocolCytonUDPBurst.setIsActive(true);
                        OpenBCI_GUI.this.wifiInternetProtocolCytonUDPBurst.wasPressed = true;
                        OpenBCI_GUI.this.wifiInternetProtocolCytonUDPBurst.color_notPressed = OpenBCI_GUI.this.isSelected_color;
                        OpenBCI_GUI.this.wifiInternetProtocolCytonTCP.color_notPressed = OpenBCI_GUI.this.autoFileName.color_notPressed;
                        OpenBCI_GUI.this.wifiInternetProtocolCytonUDP.color_notPressed = OpenBCI_GUI.this.autoFileName.color_notPressed;
                    }
                }
                if (OpenBCI_GUI.this.eegDataSource == 1) {
                    if (OpenBCI_GUI.this.autoFileNameGanglion.isMouseHere()) {
                        OpenBCI_GUI.this.autoFileNameGanglion.setIsActive(true);
                        OpenBCI_GUI.this.autoFileNameGanglion.wasPressed = true;
                    }
                    if (OpenBCI_GUI.this.outputODFGanglion.isMouseHere()) {
                        OpenBCI_GUI.this.outputODFGanglion.setIsActive(true);
                        OpenBCI_GUI.this.outputODFGanglion.wasPressed = true;
                        OpenBCI_GUI.this.outputODFGanglion.color_notPressed = OpenBCI_GUI.this.isSelected_color;
                        OpenBCI_GUI.this.outputBDFGanglion.color_notPressed = OpenBCI_GUI.this.autoFileName.color_notPressed;
                    }
                    if (OpenBCI_GUI.this.outputBDFGanglion.isMouseHere()) {
                        OpenBCI_GUI.this.outputBDFGanglion.setIsActive(true);
                        OpenBCI_GUI.this.outputBDFGanglion.wasPressed = true;
                        OpenBCI_GUI.this.outputBDFGanglion.color_notPressed = OpenBCI_GUI.this.isSelected_color;
                        OpenBCI_GUI.this.outputODFGanglion.color_notPressed = OpenBCI_GUI.this.autoFileName.color_notPressed;
                    }
                    if (OpenBCI_GUI.this.ganglion.isWifi()) {
                        if (OpenBCI_GUI.this.refreshWifi.isMouseHere()) {
                            OpenBCI_GUI.this.refreshWifi.setIsActive(true);
                            OpenBCI_GUI.this.refreshWifi.wasPressed = true;
                        }
                    } else if (OpenBCI_GUI.this.refreshBLE.isMouseHere()) {
                        OpenBCI_GUI.this.refreshBLE.setIsActive(true);
                        OpenBCI_GUI.this.refreshBLE.wasPressed = true;
                    }
                    if (OpenBCI_GUI.this.protocolBLEGanglion.isMouseHere()) {
                        OpenBCI_GUI.this.protocolBLEGanglion.setIsActive(true);
                        OpenBCI_GUI.this.protocolBLEGanglion.wasPressed = true;
                        if (OpenBCI_GUI.this.isMac()) {
                            OpenBCI_GUI.this.protocolBLED112Ganglion.color_notPressed = OpenBCI_GUI.this.autoFileName.color_notPressed;
                        }
                        OpenBCI_GUI.this.protocolBLEGanglion.color_notPressed = OpenBCI_GUI.this.isSelected_color;
                        OpenBCI_GUI.this.protocolWifiGanglion.color_notPressed = OpenBCI_GUI.this.autoFileName.color_notPressed;
                    }
                    if (OpenBCI_GUI.this.protocolWifiGanglion.isMouseHere()) {
                        OpenBCI_GUI.this.protocolWifiGanglion.setIsActive(true);
                        OpenBCI_GUI.this.protocolWifiGanglion.wasPressed = true;
                        if (OpenBCI_GUI.this.isMac()) {
                            OpenBCI_GUI.this.protocolBLED112Ganglion.color_notPressed = OpenBCI_GUI.this.autoFileName.color_notPressed;
                        }
                        OpenBCI_GUI.this.protocolWifiGanglion.color_notPressed = OpenBCI_GUI.this.isSelected_color;
                        OpenBCI_GUI.this.protocolBLEGanglion.color_notPressed = OpenBCI_GUI.this.autoFileName.color_notPressed;
                    }
                    if (OpenBCI_GUI.this.isMac() && OpenBCI_GUI.this.protocolBLED112Ganglion.isMouseHere()) {
                        OpenBCI_GUI.this.protocolBLED112Ganglion.setIsActive(true);
                        OpenBCI_GUI.this.protocolBLED112Ganglion.wasPressed = true;
                        OpenBCI_GUI.this.protocolBLEGanglion.color_notPressed = OpenBCI_GUI.this.autoFileName.color_notPressed;
                        OpenBCI_GUI.this.protocolBLED112Ganglion.color_notPressed = OpenBCI_GUI.this.isSelected_color;
                        OpenBCI_GUI.this.protocolWifiGanglion.color_notPressed = OpenBCI_GUI.this.autoFileName.color_notPressed;
                    }
                    if (OpenBCI_GUI.this.sampleRate200.isMouseHere()) {
                        OpenBCI_GUI.this.sampleRate200.setIsActive(true);
                        OpenBCI_GUI.this.sampleRate200.wasPressed = true;
                        OpenBCI_GUI.this.sampleRate200.color_notPressed = OpenBCI_GUI.this.isSelected_color;
                        OpenBCI_GUI.this.sampleRate1600.color_notPressed = OpenBCI_GUI.this.autoFileName.color_notPressed;
                    }
                    if (OpenBCI_GUI.this.sampleRate1600.isMouseHere()) {
                        OpenBCI_GUI.this.sampleRate1600.setIsActive(true);
                        OpenBCI_GUI.this.sampleRate1600.wasPressed = true;
                        OpenBCI_GUI.this.sampleRate1600.color_notPressed = OpenBCI_GUI.this.isSelected_color;
                        OpenBCI_GUI.this.sampleRate200.color_notPressed = OpenBCI_GUI.this.autoFileName.color_notPressed;
                    }
                    if (OpenBCI_GUI.this.latencyGanglion5ms.isMouseHere()) {
                        OpenBCI_GUI.this.latencyGanglion5ms.setIsActive(true);
                        OpenBCI_GUI.this.latencyGanglion5ms.wasPressed = true;
                        OpenBCI_GUI.this.latencyGanglion5ms.color_notPressed = OpenBCI_GUI.this.isSelected_color;
                        OpenBCI_GUI.this.latencyGanglion10ms.color_notPressed = OpenBCI_GUI.this.autoFileName.color_notPressed;
                        OpenBCI_GUI.this.latencyGanglion20ms.color_notPressed = OpenBCI_GUI.this.autoFileName.color_notPressed;
                    }
                    if (OpenBCI_GUI.this.latencyGanglion10ms.isMouseHere()) {
                        OpenBCI_GUI.this.latencyGanglion10ms.setIsActive(true);
                        OpenBCI_GUI.this.latencyGanglion10ms.wasPressed = true;
                        OpenBCI_GUI.this.latencyGanglion10ms.color_notPressed = OpenBCI_GUI.this.isSelected_color;
                        OpenBCI_GUI.this.latencyGanglion5ms.color_notPressed = OpenBCI_GUI.this.autoFileName.color_notPressed;
                        OpenBCI_GUI.this.latencyGanglion20ms.color_notPressed = OpenBCI_GUI.this.autoFileName.color_notPressed;
                    }
                    if (OpenBCI_GUI.this.latencyGanglion20ms.isMouseHere()) {
                        OpenBCI_GUI.this.latencyGanglion20ms.setIsActive(true);
                        OpenBCI_GUI.this.latencyGanglion20ms.wasPressed = true;
                        OpenBCI_GUI.this.latencyGanglion20ms.color_notPressed = OpenBCI_GUI.this.isSelected_color;
                        OpenBCI_GUI.this.latencyGanglion5ms.color_notPressed = OpenBCI_GUI.this.autoFileName.color_notPressed;
                        OpenBCI_GUI.this.latencyGanglion10ms.color_notPressed = OpenBCI_GUI.this.autoFileName.color_notPressed;
                    }
                    if (OpenBCI_GUI.this.wifiInternetProtocolGanglionTCP.isMouseHere()) {
                        OpenBCI_GUI.this.wifiInternetProtocolGanglionTCP.setIsActive(true);
                        OpenBCI_GUI.this.wifiInternetProtocolGanglionTCP.wasPressed = true;
                        OpenBCI_GUI.this.wifiInternetProtocolGanglionTCP.color_notPressed = OpenBCI_GUI.this.isSelected_color;
                        OpenBCI_GUI.this.wifiInternetProtocolGanglionUDP.color_notPressed = OpenBCI_GUI.this.autoFileName.color_notPressed;
                        OpenBCI_GUI.this.wifiInternetProtocolGanglionUDPBurst.color_notPressed = OpenBCI_GUI.this.autoFileName.color_notPressed;
                    }
                    if (OpenBCI_GUI.this.wifiInternetProtocolGanglionUDP.isMouseHere()) {
                        OpenBCI_GUI.this.wifiInternetProtocolGanglionUDP.setIsActive(true);
                        OpenBCI_GUI.this.wifiInternetProtocolGanglionUDP.wasPressed = true;
                        OpenBCI_GUI.this.wifiInternetProtocolGanglionUDP.color_notPressed = OpenBCI_GUI.this.isSelected_color;
                        OpenBCI_GUI.this.wifiInternetProtocolGanglionTCP.color_notPressed = OpenBCI_GUI.this.autoFileName.color_notPressed;
                        OpenBCI_GUI.this.wifiInternetProtocolGanglionUDPBurst.color_notPressed = OpenBCI_GUI.this.autoFileName.color_notPressed;
                    }
                    if (OpenBCI_GUI.this.wifiInternetProtocolGanglionUDPBurst.isMouseHere()) {
                        OpenBCI_GUI.this.wifiInternetProtocolGanglionUDPBurst.setIsActive(true);
                        OpenBCI_GUI.this.wifiInternetProtocolGanglionUDPBurst.wasPressed = true;
                        OpenBCI_GUI.this.wifiInternetProtocolGanglionUDPBurst.color_notPressed = OpenBCI_GUI.this.isSelected_color;
                        OpenBCI_GUI.this.wifiInternetProtocolGanglionTCP.color_notPressed = OpenBCI_GUI.this.autoFileName.color_notPressed;
                        OpenBCI_GUI.this.wifiInternetProtocolGanglionUDP.color_notPressed = OpenBCI_GUI.this.autoFileName.color_notPressed;
                    }
                }
                if (OpenBCI_GUI.this.eegDataSource == 2) {
                    if (OpenBCI_GUI.this.selectPlaybackFile.isMouseHere()) {
                        OpenBCI_GUI.this.selectPlaybackFile.setIsActive(true);
                        OpenBCI_GUI.this.selectPlaybackFile.wasPressed = true;
                    }
                    if (OpenBCI_GUI.this.selectSDFile.isMouseHere()) {
                        OpenBCI_GUI.this.selectSDFile.setIsActive(true);
                        OpenBCI_GUI.this.selectSDFile.wasPressed = true;
                    }
                    if (OpenBCI_GUI.this.playbackChanButton4.isMouseHere()) {
                        OpenBCI_GUI.this.playbackChanButton4.setIsActive(true);
                        OpenBCI_GUI.this.playbackChanButton4.wasPressed = true;
                        OpenBCI_GUI.this.playbackChanButton4.color_notPressed = OpenBCI_GUI.this.isSelected_color;
                        OpenBCI_GUI.this.playbackChanButton8.color_notPressed = OpenBCI_GUI.this.autoFileName.color_notPressed;
                        OpenBCI_GUI.this.playbackChanButton16.color_notPressed = OpenBCI_GUI.this.autoFileName.color_notPressed;
                    }
                    if (OpenBCI_GUI.this.playbackChanButton8.isMouseHere()) {
                        OpenBCI_GUI.this.playbackChanButton8.setIsActive(true);
                        OpenBCI_GUI.this.playbackChanButton8.wasPressed = true;
                        OpenBCI_GUI.this.playbackChanButton8.color_notPressed = OpenBCI_GUI.this.isSelected_color;
                        OpenBCI_GUI.this.playbackChanButton4.color_notPressed = OpenBCI_GUI.this.autoFileName.color_notPressed;
                        OpenBCI_GUI.this.playbackChanButton16.color_notPressed = OpenBCI_GUI.this.autoFileName.color_notPressed;
                    }
                    if (OpenBCI_GUI.this.playbackChanButton16.isMouseHere()) {
                        OpenBCI_GUI.this.playbackChanButton16.setIsActive(true);
                        OpenBCI_GUI.this.playbackChanButton16.wasPressed = true;
                        OpenBCI_GUI.this.playbackChanButton16.color_notPressed = OpenBCI_GUI.this.isSelected_color;
                        OpenBCI_GUI.this.playbackChanButton4.color_notPressed = OpenBCI_GUI.this.autoFileName.color_notPressed;
                        OpenBCI_GUI.this.playbackChanButton8.color_notPressed = OpenBCI_GUI.this.autoFileName.color_notPressed;
                    }
                }
                if (OpenBCI_GUI.this.eegDataSource == 3) {
                    if (OpenBCI_GUI.this.synthChanButton4.isMouseHere()) {
                        OpenBCI_GUI.this.synthChanButton4.setIsActive(true);
                        OpenBCI_GUI.this.synthChanButton4.wasPressed = true;
                        OpenBCI_GUI.this.synthChanButton4.color_notPressed = OpenBCI_GUI.this.isSelected_color;
                        OpenBCI_GUI.this.synthChanButton8.color_notPressed = OpenBCI_GUI.this.autoFileName.color_notPressed;
                        OpenBCI_GUI.this.synthChanButton16.color_notPressed = OpenBCI_GUI.this.autoFileName.color_notPressed;
                    }
                    if (OpenBCI_GUI.this.synthChanButton8.isMouseHere()) {
                        OpenBCI_GUI.this.synthChanButton8.setIsActive(true);
                        OpenBCI_GUI.this.synthChanButton8.wasPressed = true;
                        OpenBCI_GUI.this.synthChanButton8.color_notPressed = OpenBCI_GUI.this.isSelected_color;
                        OpenBCI_GUI.this.synthChanButton4.color_notPressed = OpenBCI_GUI.this.autoFileName.color_notPressed;
                        OpenBCI_GUI.this.synthChanButton16.color_notPressed = OpenBCI_GUI.this.autoFileName.color_notPressed;
                    }
                    if (OpenBCI_GUI.this.synthChanButton16.isMouseHere()) {
                        OpenBCI_GUI.this.synthChanButton16.setIsActive(true);
                        OpenBCI_GUI.this.synthChanButton16.wasPressed = true;
                        OpenBCI_GUI.this.synthChanButton16.color_notPressed = OpenBCI_GUI.this.isSelected_color;
                        OpenBCI_GUI.this.synthChanButton4.color_notPressed = OpenBCI_GUI.this.autoFileName.color_notPressed;
                        OpenBCI_GUI.this.synthChanButton8.color_notPressed = OpenBCI_GUI.this.autoFileName.color_notPressed;
                    }
                }
            }
        }

        public void CPmouseReleased() {
            String output;
            if (OpenBCI_GUI.this.popOutRadioConfigButton.isMouseHere() && OpenBCI_GUI.this.popOutRadioConfigButton.wasPressed) {
                OpenBCI_GUI.this.popOutRadioConfigButton.wasPressed = false;
                OpenBCI_GUI.this.popOutRadioConfigButton.setIsActive(false);
                if (OpenBCI_GUI.this.cyton.isSerial()) {
                    if (OpenBCI_GUI.this.rcBox.isShowing) {
                        this.hideRadioPopoutBox();
                    } else {
                        OpenBCI_GUI.this.rcBox.isShowing = true;
                        OpenBCI_GUI.this.popOutRadioConfigButton.setString("<");
                    }
                }
            }
            if (OpenBCI_GUI.this.rcBox.isShowing) {
                if (OpenBCI_GUI.this.getChannel.isMouseHere() && OpenBCI_GUI.this.getChannel.wasPressed) {
                    OpenBCI_GUI.this.get_channel(OpenBCI_GUI.this.rcBox);
                    OpenBCI_GUI.this.getChannel.wasPressed = false;
                    OpenBCI_GUI.this.getChannel.setIsActive(false);
                }
                if (OpenBCI_GUI.this.setChannel.isMouseHere() && OpenBCI_GUI.this.setChannel.wasPressed) {
                    OpenBCI_GUI.this.channelPopup.setClicked(true);
                    OpenBCI_GUI.this.pollPopup.setClicked(false);
                    OpenBCI_GUI.this.setChannel.setIsActive(false);
                }
                if (OpenBCI_GUI.this.ovrChannel.isMouseHere() && OpenBCI_GUI.this.ovrChannel.wasPressed) {
                    OpenBCI_GUI.this.channelPopup.setClicked(true);
                    OpenBCI_GUI.this.pollPopup.setClicked(false);
                    OpenBCI_GUI.this.ovrChannel.setIsActive(false);
                }
                if (OpenBCI_GUI.this.autoscan.isMouseHere() && OpenBCI_GUI.this.autoscan.wasPressed) {
                    OpenBCI_GUI.this.autoscan.wasPressed = false;
                    OpenBCI_GUI.this.autoscan.setIsActive(false);
                    OpenBCI_GUI.this.scan_channels(OpenBCI_GUI.this.rcBox);
                }
                if (OpenBCI_GUI.this.systemStatus.isMouseHere() && OpenBCI_GUI.this.systemStatus.wasPressed) {
                    OpenBCI_GUI.this.system_status(OpenBCI_GUI.this.rcBox);
                    OpenBCI_GUI.this.systemStatus.setIsActive(false);
                    OpenBCI_GUI.this.systemStatus.wasPressed = false;
                }
            }
            if (OpenBCI_GUI.this.popOutWifiConfigButton.isMouseHere() && OpenBCI_GUI.this.popOutWifiConfigButton.wasPressed) {
                OpenBCI_GUI.this.popOutWifiConfigButton.wasPressed = false;
                OpenBCI_GUI.this.popOutWifiConfigButton.setIsActive(false);
                if (OpenBCI_GUI.this.cyton.isWifi() || OpenBCI_GUI.this.ganglion.isWifi()) {
                    if (OpenBCI_GUI.this.wcBox.isShowing) {
                        this.hideWifiPopoutBox();
                    } else if (OpenBCI_GUI.this.hub.getWiFiStyle() == OpenBCI_GUI.WIFI_STATIC) {
                        OpenBCI_GUI.this.wifi_ipAddress = ((Textfield)OpenBCI_GUI.this.cp5.get(Textfield.class, "staticIPAddress")).getText();
                        OpenBCI_GUI.println((String)("Static IP address of " + OpenBCI_GUI.this.wifi_ipAddress));
                        OpenBCI_GUI.this.output("Static IP address of " + OpenBCI_GUI.this.wifi_ipAddress);
                        OpenBCI_GUI.this.hub.examineWifi(OpenBCI_GUI.this.wifi_ipAddress);
                        OpenBCI_GUI.this.wcBox.isShowing = true;
                        OpenBCI_GUI.this.popOutWifiConfigButton.setString("<");
                    } else if (OpenBCI_GUI.this.wifi_portName == "N/A") {
                        OpenBCI_GUI.this.output("Please select a WiFi Shield first. Can't see your WiFi Shield? Learn how at docs.openbci.com/Tutorials/03-Wifi_Getting_Started_Guide");
                    } else {
                        OpenBCI_GUI.this.output("Attempting to connect to WiFi Shield named " + OpenBCI_GUI.this.wifi_portName);
                        OpenBCI_GUI.this.hub.examineWifi(OpenBCI_GUI.this.wifi_portName);
                        OpenBCI_GUI.this.wcBox.isShowing = true;
                        OpenBCI_GUI.this.popOutWifiConfigButton.setString("<");
                    }
                }
            }
            if (OpenBCI_GUI.this.wcBox.isShowing) {
                if (OpenBCI_GUI.this.getIpAddress.isMouseHere() && OpenBCI_GUI.this.getIpAddress.wasPressed) {
                    OpenBCI_GUI.this.hub.getWifiInfo(OpenBCI_GUI.TCP_WIFI_GET_IP_ADDRESS);
                    OpenBCI_GUI.this.getIpAddress.wasPressed = false;
                    OpenBCI_GUI.this.getIpAddress.setIsActive(false);
                }
                if (OpenBCI_GUI.this.getFirmwareVersion.isMouseHere() && OpenBCI_GUI.this.getFirmwareVersion.wasPressed) {
                    OpenBCI_GUI.this.hub.getWifiInfo(OpenBCI_GUI.TCP_WIFI_GET_FIRMWARE_VERSION);
                    OpenBCI_GUI.this.getFirmwareVersion.wasPressed = false;
                    OpenBCI_GUI.this.getFirmwareVersion.setIsActive(false);
                }
                if (OpenBCI_GUI.this.getMacAddress.isMouseHere() && OpenBCI_GUI.this.getMacAddress.wasPressed) {
                    OpenBCI_GUI.this.hub.getWifiInfo(OpenBCI_GUI.TCP_WIFI_GET_MAC_ADDRESS);
                    OpenBCI_GUI.this.getMacAddress.wasPressed = false;
                    OpenBCI_GUI.this.getMacAddress.setIsActive(false);
                }
                if (OpenBCI_GUI.this.eraseCredentials.isMouseHere() && OpenBCI_GUI.this.eraseCredentials.wasPressed) {
                    OpenBCI_GUI.this.hub.getWifiInfo(OpenBCI_GUI.TCP_WIFI_ERASE_CREDENTIALS);
                    OpenBCI_GUI.this.eraseCredentials.wasPressed = false;
                    OpenBCI_GUI.this.eraseCredentials.setIsActive(false);
                }
                if (OpenBCI_GUI.this.getTypeOfAttachedBoard.isMouseHere() && OpenBCI_GUI.this.getTypeOfAttachedBoard.wasPressed) {
                    OpenBCI_GUI.this.hub.getWifiInfo(OpenBCI_GUI.TCP_WIFI_GET_TYPE_OF_ATTACHED_BOARD);
                    OpenBCI_GUI.this.getTypeOfAttachedBoard.wasPressed = false;
                    OpenBCI_GUI.this.getTypeOfAttachedBoard.setIsActive(false);
                }
            }
            if (OpenBCI_GUI.this.initSystemButton.isMouseHere() && OpenBCI_GUI.this.initSystemButton.wasPressed) {
                if (OpenBCI_GUI.this.rcBox.isShowing) {
                    this.hideRadioPopoutBox();
                }
                if (OpenBCI_GUI.this.wcBox.isShowing) {
                    this.hideWifiPopoutBox();
                }
                OpenBCI_GUI.this.initButtonPressed();
            }
            if (OpenBCI_GUI.this.refreshPort.isMouseHere() && OpenBCI_GUI.this.refreshPort.wasPressed) {
                OpenBCI_GUI.this.output("Serial/COM List Refreshed");
                this.refreshPortList();
            }
            if (OpenBCI_GUI.this.refreshBLE.isMouseHere() && OpenBCI_GUI.this.refreshBLE.wasPressed) {
                if (OpenBCI_GUI.this.isHubObjectInitialized) {
                    OpenBCI_GUI.this.output("BLE Devices Refreshing");
                    OpenBCI_GUI.this.bleList.items.clear();
                    OpenBCI_GUI.this.hub.searchDeviceStart();
                } else {
                    OpenBCI_GUI.this.output("Please wait till BLE is fully initalized");
                }
            }
            if (OpenBCI_GUI.this.refreshWifi.isMouseHere() && OpenBCI_GUI.this.refreshWifi.wasPressed) {
                if (OpenBCI_GUI.this.isHubObjectInitialized) {
                    OpenBCI_GUI.this.output("Wifi Devices Refreshing");
                    OpenBCI_GUI.this.wifiList.items.clear();
                    OpenBCI_GUI.this.hub.searchDeviceStart();
                } else {
                    OpenBCI_GUI.this.output("Please wait till hub is fully initalized");
                }
            }
            if (OpenBCI_GUI.this.wifiIPAddressDyanmic.isMouseHere() && OpenBCI_GUI.this.wifiIPAddressDyanmic.wasPressed) {
                OpenBCI_GUI.this.hub.setWiFiStyle(OpenBCI_GUI.WIFI_DYNAMIC);
                this.wifiBox.h = 200;
                output = "Using " + (OpenBCI_GUI.this.hub.getWiFiStyle() == OpenBCI_GUI.WIFI_STATIC ? "Static" : "Dynamic") + " IP address of the WiFi Shield!";
                OpenBCI_GUI.this.outputInfo(output);
                OpenBCI_GUI.println((String)output);
            }
            if (OpenBCI_GUI.this.wifiIPAddressStatic.isMouseHere() && OpenBCI_GUI.this.wifiIPAddressStatic.wasPressed) {
                OpenBCI_GUI.this.hub.setWiFiStyle(OpenBCI_GUI.WIFI_STATIC);
                this.wifiBox.h = 120;
                output = "Using " + (OpenBCI_GUI.this.hub.getWiFiStyle() == OpenBCI_GUI.WIFI_STATIC ? "Static" : "Dynamic") + " IP address of the WiFi Shield!";
                OpenBCI_GUI.this.outputInfo(output);
                OpenBCI_GUI.println((String)output);
            }
            if (OpenBCI_GUI.this.protocolBLEGanglion.isMouseHere() && OpenBCI_GUI.this.protocolBLEGanglion.wasPressed) {
                OpenBCI_GUI.this.wifiList.items.clear();
                OpenBCI_GUI.this.bleList.items.clear();
                OpenBCI_GUI.this.controlPanel.hideAllBoxes();
                if (OpenBCI_GUI.this.isHubObjectInitialized) {
                    OpenBCI_GUI.this.output("Protocol BLE Selected for Ganglion");
                    if (OpenBCI_GUI.this.hub.isPortOpen()) {
                        OpenBCI_GUI.this.hub.closePort();
                    }
                    OpenBCI_GUI.this.ganglion.setInterface(1);
                } else {
                    OpenBCI_GUI.this.outputWarn("Please wait till hub is fully initalized");
                }
            }
            if (OpenBCI_GUI.this.isMac() && OpenBCI_GUI.this.protocolBLED112Ganglion.isMouseHere() && OpenBCI_GUI.this.protocolBLED112Ganglion.wasPressed) {
                OpenBCI_GUI.println((String)"protocolBLED112Ganglion");
                OpenBCI_GUI.this.wifiList.items.clear();
                OpenBCI_GUI.this.bleList.items.clear();
                OpenBCI_GUI.this.controlPanel.hideAllBoxes();
                if (OpenBCI_GUI.this.isHubObjectInitialized) {
                    OpenBCI_GUI.this.output("Protocol BLED112 Selected for Ganglion");
                    OpenBCI_GUI.println((String)"Protocol BLED112 Selected for Ganglion");
                    if (OpenBCI_GUI.this.hub.isPortOpen()) {
                        OpenBCI_GUI.this.hub.closePort();
                    }
                    OpenBCI_GUI.this.ganglion.setInterface(3);
                } else {
                    OpenBCI_GUI.this.outputWarn("Please wait till hub is fully initalized");
                }
            }
            if (OpenBCI_GUI.this.protocolWifiGanglion.isMouseHere() && OpenBCI_GUI.this.protocolWifiGanglion.wasPressed) {
                OpenBCI_GUI.println((String)"protocolWifiGanglion");
                OpenBCI_GUI.this.wifiList.items.clear();
                OpenBCI_GUI.this.bleList.items.clear();
                OpenBCI_GUI.this.controlPanel.hideAllBoxes();
                OpenBCI_GUI.println((String)("isHubObjectInitialized: " + (OpenBCI_GUI.this.isHubObjectInitialized ? "true" : "else")));
                if (OpenBCI_GUI.this.isHubObjectInitialized) {
                    OpenBCI_GUI.this.output("Protocol Wifi Selected for Ganglion");
                    if (OpenBCI_GUI.this.hub.isPortOpen()) {
                        OpenBCI_GUI.this.hub.closePort();
                    }
                    OpenBCI_GUI.this.ganglion.setInterface(2);
                } else {
                    OpenBCI_GUI.this.output("Please wait till hub is fully initalized");
                }
            }
            if (OpenBCI_GUI.this.protocolSerialCyton.isMouseHere() && OpenBCI_GUI.this.protocolSerialCyton.wasPressed) {
                OpenBCI_GUI.this.wifiList.items.clear();
                OpenBCI_GUI.this.bleList.items.clear();
                OpenBCI_GUI.this.controlPanel.hideAllBoxes();
                if (OpenBCI_GUI.this.isHubObjectInitialized) {
                    OpenBCI_GUI.this.output("Protocol Serial Selected for Cyton");
                    if (OpenBCI_GUI.this.hub.isPortOpen()) {
                        OpenBCI_GUI.this.hub.closePort();
                    }
                    OpenBCI_GUI.this.cyton.setInterface(0);
                } else {
                    OpenBCI_GUI.this.output("Please wait till hub is fully initalized");
                }
            }
            if (OpenBCI_GUI.this.protocolWifiCyton.isMouseHere() && OpenBCI_GUI.this.protocolWifiCyton.wasPressed) {
                OpenBCI_GUI.this.wifiList.items.clear();
                OpenBCI_GUI.this.bleList.items.clear();
                OpenBCI_GUI.this.controlPanel.hideAllBoxes();
                if (OpenBCI_GUI.this.isHubObjectInitialized) {
                    OpenBCI_GUI.this.output("Protocol Wifi Selected for Cyton");
                    if (OpenBCI_GUI.this.hub.isPortOpen()) {
                        OpenBCI_GUI.this.hub.closePort();
                    }
                    OpenBCI_GUI.this.cyton.setInterface(2);
                } else {
                    OpenBCI_GUI.this.output("Please wait till hub is fully initalized");
                }
            }
            if (OpenBCI_GUI.this.autoFileName.isMouseHere() && OpenBCI_GUI.this.autoFileName.wasPressed) {
                OpenBCI_GUI.this.output("Autogenerated Cyton \"File Name\" based on current date/time");
                ((Textfield)OpenBCI_GUI.this.cp5.get(Textfield.class, "fileName")).setText(OpenBCI_GUI.this.getDateString());
            }
            if (OpenBCI_GUI.this.outputODF.isMouseHere() && OpenBCI_GUI.this.outputODF.wasPressed) {
                OpenBCI_GUI.this.output("Output has been set to OpenBCI Data Format");
                OpenBCI_GUI.this.outputDataSource = 1;
            }
            if (OpenBCI_GUI.this.outputBDF.isMouseHere() && OpenBCI_GUI.this.outputBDF.wasPressed) {
                OpenBCI_GUI.this.output("Output has been set to BDF+ (biosemi data format based off EDF)");
                OpenBCI_GUI.this.outputDataSource = 2;
            }
            if (OpenBCI_GUI.this.autoFileNameGanglion.isMouseHere() && OpenBCI_GUI.this.autoFileNameGanglion.wasPressed) {
                OpenBCI_GUI.this.output("Autogenerated Ganglion \"File Name\" based on current date/time");
                ((Textfield)OpenBCI_GUI.this.cp5.get(Textfield.class, "fileNameGanglion")).setText(OpenBCI_GUI.this.getDateString());
            }
            if (OpenBCI_GUI.this.outputODFGanglion.isMouseHere() && OpenBCI_GUI.this.outputODFGanglion.wasPressed) {
                OpenBCI_GUI.this.output("Output has been set to OpenBCI Data Format");
                OpenBCI_GUI.this.outputDataSource = 1;
            }
            if (OpenBCI_GUI.this.outputBDFGanglion.isMouseHere() && OpenBCI_GUI.this.outputBDFGanglion.wasPressed) {
                OpenBCI_GUI.this.output("Output has been set to BDF+ (biosemi data format based off EDF)");
                OpenBCI_GUI.this.outputDataSource = 2;
            }
            if (OpenBCI_GUI.this.chanButton8.isMouseHere() && OpenBCI_GUI.this.chanButton8.wasPressed) {
                OpenBCI_GUI.this.updateToNChan(8);
            }
            if (OpenBCI_GUI.this.chanButton16.isMouseHere() && OpenBCI_GUI.this.chanButton16.wasPressed) {
                OpenBCI_GUI.this.updateToNChan(16);
            }
            if (OpenBCI_GUI.this.sampleRate200.isMouseHere() && OpenBCI_GUI.this.sampleRate200.wasPressed) {
                OpenBCI_GUI.this.ganglion.setSampleRate(200);
            }
            if (OpenBCI_GUI.this.sampleRate1600.isMouseHere() && OpenBCI_GUI.this.sampleRate1600.wasPressed) {
                OpenBCI_GUI.this.ganglion.setSampleRate(1600);
            }
            if (OpenBCI_GUI.this.sampleRate250.isMouseHere() && OpenBCI_GUI.this.sampleRate250.wasPressed) {
                OpenBCI_GUI.this.cyton.setSampleRate(250);
            }
            if (OpenBCI_GUI.this.sampleRate500.isMouseHere() && OpenBCI_GUI.this.sampleRate500.wasPressed) {
                OpenBCI_GUI.this.cyton.setSampleRate(500);
            }
            if (OpenBCI_GUI.this.sampleRate1000.isMouseHere() && OpenBCI_GUI.this.sampleRate1000.wasPressed) {
                OpenBCI_GUI.this.cyton.setSampleRate(1000);
            }
            if (OpenBCI_GUI.this.playbackChanButton4.isMouseHere() && OpenBCI_GUI.this.playbackChanButton4.wasPressed) {
                OpenBCI_GUI.this.updateToNChan(4);
            }
            if (OpenBCI_GUI.this.playbackChanButton8.isMouseHere() && OpenBCI_GUI.this.playbackChanButton8.wasPressed) {
                OpenBCI_GUI.this.updateToNChan(8);
            }
            if (OpenBCI_GUI.this.playbackChanButton16.isMouseHere() && OpenBCI_GUI.this.playbackChanButton16.wasPressed) {
                OpenBCI_GUI.this.updateToNChan(16);
            }
            if (OpenBCI_GUI.this.synthChanButton4.isMouseHere() && OpenBCI_GUI.this.synthChanButton4.wasPressed) {
                OpenBCI_GUI.this.updateToNChan(4);
            }
            if (OpenBCI_GUI.this.synthChanButton8.isMouseHere() && OpenBCI_GUI.this.synthChanButton8.wasPressed) {
                OpenBCI_GUI.this.updateToNChan(8);
            }
            if (OpenBCI_GUI.this.synthChanButton16.isMouseHere() && OpenBCI_GUI.this.synthChanButton16.wasPressed) {
                OpenBCI_GUI.this.updateToNChan(16);
            }
            if (OpenBCI_GUI.this.latencyCyton5ms.isMouseHere() && OpenBCI_GUI.this.latencyCyton5ms.wasPressed) {
                OpenBCI_GUI.this.hub.setLatency(5000);
            }
            if (OpenBCI_GUI.this.latencyCyton10ms.isMouseHere() && OpenBCI_GUI.this.latencyCyton10ms.wasPressed) {
                OpenBCI_GUI.this.hub.setLatency(10000);
            }
            if (OpenBCI_GUI.this.latencyCyton20ms.isMouseHere() && OpenBCI_GUI.this.latencyCyton20ms.wasPressed) {
                OpenBCI_GUI.this.hub.setLatency(20000);
            }
            if (OpenBCI_GUI.this.latencyGanglion5ms.isMouseHere() && OpenBCI_GUI.this.latencyGanglion5ms.wasPressed) {
                OpenBCI_GUI.this.hub.setLatency(5000);
            }
            if (OpenBCI_GUI.this.latencyGanglion10ms.isMouseHere() && OpenBCI_GUI.this.latencyGanglion10ms.wasPressed) {
                OpenBCI_GUI.this.hub.setLatency(10000);
            }
            if (OpenBCI_GUI.this.latencyGanglion20ms.isMouseHere() && OpenBCI_GUI.this.latencyGanglion20ms.wasPressed) {
                OpenBCI_GUI.this.hub.setLatency(20000);
            }
            if (OpenBCI_GUI.this.wifiInternetProtocolCytonTCP.isMouseHere() && OpenBCI_GUI.this.wifiInternetProtocolCytonTCP.wasPressed) {
                OpenBCI_GUI.this.hub.setWifiInternetProtocol(OpenBCI_GUI.TCP);
            }
            if (OpenBCI_GUI.this.wifiInternetProtocolCytonUDP.isMouseHere() && OpenBCI_GUI.this.wifiInternetProtocolCytonUDP.wasPressed) {
                OpenBCI_GUI.this.hub.setWifiInternetProtocol(OpenBCI_GUI.UDP);
            }
            if (OpenBCI_GUI.this.wifiInternetProtocolCytonUDPBurst.isMouseHere() && OpenBCI_GUI.this.wifiInternetProtocolCytonUDPBurst.wasPressed) {
                OpenBCI_GUI.this.hub.setWifiInternetProtocol(OpenBCI_GUI.UDP_BURST);
            }
            if (OpenBCI_GUI.this.wifiInternetProtocolGanglionTCP.isMouseHere() && OpenBCI_GUI.this.wifiInternetProtocolGanglionTCP.wasPressed) {
                OpenBCI_GUI.this.hub.setWifiInternetProtocol(OpenBCI_GUI.TCP);
            }
            if (OpenBCI_GUI.this.wifiInternetProtocolGanglionUDP.isMouseHere() && OpenBCI_GUI.this.wifiInternetProtocolGanglionUDP.wasPressed) {
                OpenBCI_GUI.this.hub.setWifiInternetProtocol(OpenBCI_GUI.UDP);
            }
            if (OpenBCI_GUI.this.wifiInternetProtocolGanglionUDPBurst.isMouseHere() && OpenBCI_GUI.this.wifiInternetProtocolGanglionUDPBurst.wasPressed) {
                OpenBCI_GUI.this.hub.setWifiInternetProtocol(OpenBCI_GUI.UDP_BURST);
            }
            if (OpenBCI_GUI.this.selectPlaybackFile.isMouseHere() && OpenBCI_GUI.this.selectPlaybackFile.wasPressed) {
                OpenBCI_GUI.this.output("select a file for playback");
                OpenBCI_GUI.this.selectInput("Select a pre-recorded file for playback:", "playbackSelected");
            }
            if (OpenBCI_GUI.this.selectSDFile.isMouseHere() && OpenBCI_GUI.this.selectSDFile.wasPressed) {
                OpenBCI_GUI.this.output("select an SD file to convert to a playback file");
                OpenBCI_GUI.this.createPlaybackFileFromSD();
                OpenBCI_GUI.this.selectInput("Select an SD file to convert for playback:", "sdFileSelected");
            }
            OpenBCI_GUI.this.refreshPort.setIsActive(false);
            OpenBCI_GUI.this.refreshPort.wasPressed = false;
            OpenBCI_GUI.this.refreshBLE.setIsActive(false);
            OpenBCI_GUI.this.refreshBLE.wasPressed = false;
            OpenBCI_GUI.this.refreshWifi.setIsActive(false);
            OpenBCI_GUI.this.refreshWifi.wasPressed = false;
            OpenBCI_GUI.this.protocolBLEGanglion.setIsActive(false);
            OpenBCI_GUI.this.protocolBLEGanglion.wasPressed = false;
            if (OpenBCI_GUI.this.isMac()) {
                OpenBCI_GUI.this.protocolBLED112Ganglion.setIsActive(false);
                OpenBCI_GUI.this.protocolBLED112Ganglion.wasPressed = false;
            }
            OpenBCI_GUI.this.protocolWifiGanglion.setIsActive(false);
            OpenBCI_GUI.this.protocolWifiGanglion.wasPressed = false;
            OpenBCI_GUI.this.protocolSerialCyton.setIsActive(false);
            OpenBCI_GUI.this.protocolSerialCyton.wasPressed = false;
            OpenBCI_GUI.this.protocolWifiCyton.setIsActive(false);
            OpenBCI_GUI.this.protocolWifiCyton.wasPressed = false;
            OpenBCI_GUI.this.initSystemButton.setIsActive(false);
            OpenBCI_GUI.this.initSystemButton.wasPressed = false;
            OpenBCI_GUI.this.autoFileName.setIsActive(false);
            OpenBCI_GUI.this.autoFileName.wasPressed = false;
            OpenBCI_GUI.this.outputBDF.setIsActive(false);
            OpenBCI_GUI.this.outputBDF.wasPressed = false;
            OpenBCI_GUI.this.outputODF.setIsActive(false);
            OpenBCI_GUI.this.outputODF.wasPressed = false;
            OpenBCI_GUI.this.autoFileNameGanglion.setIsActive(false);
            OpenBCI_GUI.this.autoFileNameGanglion.wasPressed = false;
            OpenBCI_GUI.this.wifiIPAddressDyanmic.setIsActive(false);
            OpenBCI_GUI.this.wifiIPAddressDyanmic.wasPressed = false;
            OpenBCI_GUI.this.wifiIPAddressStatic.setIsActive(false);
            OpenBCI_GUI.this.wifiIPAddressStatic.wasPressed = false;
            OpenBCI_GUI.this.outputBDFGanglion.setIsActive(false);
            OpenBCI_GUI.this.outputBDFGanglion.wasPressed = false;
            OpenBCI_GUI.this.outputODFGanglion.setIsActive(false);
            OpenBCI_GUI.this.outputODFGanglion.wasPressed = false;
            OpenBCI_GUI.this.chanButton8.setIsActive(false);
            OpenBCI_GUI.this.chanButton8.wasPressed = false;
            OpenBCI_GUI.this.sampleRate200.setIsActive(false);
            OpenBCI_GUI.this.sampleRate200.wasPressed = false;
            OpenBCI_GUI.this.sampleRate1600.setIsActive(false);
            OpenBCI_GUI.this.sampleRate1600.wasPressed = false;
            OpenBCI_GUI.this.sampleRate250.setIsActive(false);
            OpenBCI_GUI.this.sampleRate250.wasPressed = false;
            OpenBCI_GUI.this.sampleRate500.setIsActive(false);
            OpenBCI_GUI.this.sampleRate500.wasPressed = false;
            OpenBCI_GUI.this.sampleRate1000.setIsActive(false);
            OpenBCI_GUI.this.sampleRate1000.wasPressed = false;
            OpenBCI_GUI.this.latencyCyton5ms.setIsActive(false);
            OpenBCI_GUI.this.latencyCyton5ms.wasPressed = false;
            OpenBCI_GUI.this.latencyCyton10ms.setIsActive(false);
            OpenBCI_GUI.this.latencyCyton10ms.wasPressed = false;
            OpenBCI_GUI.this.latencyCyton20ms.setIsActive(false);
            OpenBCI_GUI.this.latencyCyton20ms.wasPressed = false;
            OpenBCI_GUI.this.latencyGanglion5ms.setIsActive(false);
            OpenBCI_GUI.this.latencyGanglion5ms.wasPressed = false;
            OpenBCI_GUI.this.latencyGanglion10ms.setIsActive(false);
            OpenBCI_GUI.this.latencyGanglion10ms.wasPressed = false;
            OpenBCI_GUI.this.latencyGanglion20ms.setIsActive(false);
            OpenBCI_GUI.this.latencyGanglion20ms.wasPressed = false;
            OpenBCI_GUI.this.wifiInternetProtocolCytonTCP.setIsActive(false);
            OpenBCI_GUI.this.wifiInternetProtocolCytonTCP.wasPressed = false;
            OpenBCI_GUI.this.wifiInternetProtocolCytonUDP.setIsActive(false);
            OpenBCI_GUI.this.wifiInternetProtocolCytonUDP.wasPressed = false;
            OpenBCI_GUI.this.wifiInternetProtocolCytonUDPBurst.setIsActive(false);
            OpenBCI_GUI.this.wifiInternetProtocolCytonUDPBurst.wasPressed = false;
            OpenBCI_GUI.this.wifiInternetProtocolGanglionTCP.setIsActive(false);
            OpenBCI_GUI.this.wifiInternetProtocolGanglionTCP.wasPressed = false;
            OpenBCI_GUI.this.wifiInternetProtocolGanglionUDP.setIsActive(false);
            OpenBCI_GUI.this.wifiInternetProtocolGanglionUDP.wasPressed = false;
            OpenBCI_GUI.this.wifiInternetProtocolGanglionUDPBurst.setIsActive(false);
            OpenBCI_GUI.this.wifiInternetProtocolGanglionUDPBurst.wasPressed = false;
            OpenBCI_GUI.this.synthChanButton4.setIsActive(false);
            OpenBCI_GUI.this.synthChanButton4.wasPressed = false;
            OpenBCI_GUI.this.synthChanButton8.setIsActive(false);
            OpenBCI_GUI.this.synthChanButton8.wasPressed = false;
            OpenBCI_GUI.this.synthChanButton16.setIsActive(false);
            OpenBCI_GUI.this.synthChanButton16.wasPressed = false;
            OpenBCI_GUI.this.playbackChanButton4.setIsActive(false);
            OpenBCI_GUI.this.playbackChanButton4.wasPressed = false;
            OpenBCI_GUI.this.playbackChanButton8.setIsActive(false);
            OpenBCI_GUI.this.playbackChanButton8.wasPressed = false;
            OpenBCI_GUI.this.playbackChanButton16.setIsActive(false);
            OpenBCI_GUI.this.playbackChanButton16.wasPressed = false;
            OpenBCI_GUI.this.chanButton16.setIsActive(false);
            OpenBCI_GUI.this.chanButton16.wasPressed = false;
            OpenBCI_GUI.this.selectPlaybackFile.setIsActive(false);
            OpenBCI_GUI.this.selectPlaybackFile.wasPressed = false;
            OpenBCI_GUI.this.selectSDFile.setIsActive(false);
            OpenBCI_GUI.this.selectSDFile.wasPressed = false;
        }
    }

    class Cyton {
        private int nEEGValuesPerPacket = 8;
        private int nAuxValuesPerPacket = 3;
        private DataPacket_ADS1299 rawReceivedDataPacket;
        private DataPacket_ADS1299 missedDataPacket;
        private DataPacket_ADS1299 dataPacket;
        private int nAuxValues;
        private boolean isNewDataPacketAvailable = false;
        private OutputStream output;
        private int prevSampleIndex = 0;
        private int serialErrorCounter = 0;
        private final int fsHzSerialCyton = 250;
        private final int fsHzSerialCytonDaisy = 125;
        private final int fsHzWifi = 1000;
        private final int NfftSerialCyton = 256;
        private final int NfftSerialCytonDaisy = 256;
        private final int NfftWifi = 1024;
        private final float ADS1299_Vref = 4.5f;
        private float ADS1299_gain = 24.0f;
        private float openBCI_series_resistor_ohms = 2200.0f;
        private float scale_fac_uVolts_per_count = 4.5f / (OpenBCI_GUI.pow((float)2.0f, (float)23.0f) - 1.0f) / this.ADS1299_gain * 1000000.0f;
        private final float scale_fac_accel_G_per_count = 0.002f / OpenBCI_GUI.pow((float)2.0f, (float)4.0f);
        private final float leadOffDrive_amps = 6.0E-9f;
        boolean isBiasAuto = true;
        private int curBoardMode = 0;
        final char[] EOT = new char[]{'$', '$', '$'};
        char[] prev3chars = new char[]{'#', '#', '#'};
        public String potentialFailureMessage = "";
        public String defaultChannelSettings = "";
        public String daisyOrNot = "";
        public int hardwareSyncStep = 0;
        private long timeOfLastCommand = 0L;
        private int curInterface = 0;
        private int sampleRate = 1000;
        PApplet mainApplet;
        private int nDataValuesInPacket = 0;
        private int localByteCounter = 0;
        private int localChannelCounter = 0;
        private int PACKET_readstate = 0;
        private byte[] localAdsByteBuffer = new byte[3];
        private byte[] localAccelByteBuffer = new byte[2];
        private long timeOfLastChannelWrite = 0L;
        private int channelWriteCounter = 0;
        private boolean isWritingChannel = false;
        private long timeOfLastImpWrite = 0L;
        private int impWriteCounter = 0;
        private boolean isWritingImp = false;

        public float getSampleRate() {
            if (this.isSerial()) {
                if (OpenBCI_GUI.this.nchan == 16) {
                    return 125.0f;
                }
                return 250.0f;
            }
            return OpenBCI_GUI.this.hub.getSampleRate();
        }

        public int getNfft() {
            if (this.isWifi()) {
                if (this.sampleRate == 250) {
                    return 256;
                }
                return 1024;
            }
            if (OpenBCI_GUI.this.nchan == 16) {
                return 256;
            }
            return 256;
        }

        public int getBoardMode() {
            return this.curBoardMode;
        }

        public int getInterface() {
            return this.curInterface;
        }

        public float get_Vref() {
            return 4.5f;
        }

        public void set_ADS1299_gain(float _gain) {
            this.ADS1299_gain = _gain;
            this.scale_fac_uVolts_per_count = 4.5f / (OpenBCI_GUI.pow((float)2.0f, (float)23.0f) - 1.0f) / this.ADS1299_gain * 1000000.0f;
        }

        public float get_ADS1299_gain() {
            return this.ADS1299_gain;
        }

        public float get_series_resistor() {
            return this.openBCI_series_resistor_ohms;
        }

        public float get_scale_fac_uVolts_per_count() {
            return this.scale_fac_uVolts_per_count;
        }

        public float get_scale_fac_accel_G_per_count() {
            return this.scale_fac_accel_G_per_count;
        }

        public float get_leadOffDrive_amps() {
            return 6.0E-9f;
        }

        public String get_defaultChannelSettings() {
            return this.defaultChannelSettings;
        }

        public void setBoardMode(int boardMode) {
            OpenBCI_GUI.this.hub.sendCommand("/" + boardMode);
            this.curBoardMode = boardMode;
            OpenBCI_GUI.print((String)("Cyton: setBoardMode to :" + this.curBoardMode));
        }

        public void setSampleRate(int _sampleRate) {
            this.sampleRate = _sampleRate;
            OpenBCI_GUI.this.output("Setting sample rate for Cyton to " + this.sampleRate + "Hz");
            OpenBCI_GUI.println((String)("Setting sample rate for Cyton to " + this.sampleRate + "Hz"));
            OpenBCI_GUI.this.hub.setSampleRate(this.sampleRate);
        }

        public boolean setInterface(int _interface) {
            this.curInterface = _interface;
            OpenBCI_GUI.println((String)("setInterface: curInterface: " + this.getInterface()));
            if (this.isWifi()) {
                this.setSampleRate(1000);
                OpenBCI_GUI.this.hub.setProtocol(OpenBCI_GUI.PROTOCOL_WIFI);
            } else if (this.isSerial()) {
                this.setSampleRate(250);
                OpenBCI_GUI.this.hub.setProtocol(OpenBCI_GUI.PROTOCOL_SERIAL);
            }
            return true;
        }

        Cyton() {
        }

        Cyton(PApplet applet, String comPort, int baud, int nEEGValuesPerOpenBCI, boolean useAux, int nAuxValuesPerOpenBCI, int _interface) {
            this.curInterface = _interface;
            this.initDataPackets(nEEGValuesPerOpenBCI, nAuxValuesPerOpenBCI);
            if (this.isSerial()) {
                OpenBCI_GUI.this.hub.connectSerial(comPort);
            } else if (this.isWifi()) {
                OpenBCI_GUI.this.hub.connectWifi(comPort);
            }
        }

        public void initDataPackets(int _nEEGValuesPerPacket, int _nAuxValuesPerPacket) {
            this.nEEGValuesPerPacket = _nEEGValuesPerPacket;
            this.nAuxValuesPerPacket = _nAuxValuesPerPacket;
            this.rawReceivedDataPacket = new DataPacket_ADS1299(this.nEEGValuesPerPacket, this.nAuxValuesPerPacket);
            this.missedDataPacket = new DataPacket_ADS1299(this.nEEGValuesPerPacket, this.nAuxValuesPerPacket);
            this.dataPacket = new DataPacket_ADS1299(this.nEEGValuesPerPacket, this.nAuxValuesPerPacket);
            int i = 0;
            while (i < this.nEEGValuesPerPacket) {
                this.rawReceivedDataPacket.values[i] = 0;
                ++i;
            }
            i = 0;
            while (i < this.nEEGValuesPerPacket) {
                this.dataPacket.values[i] = 0;
                this.missedDataPacket.values[i] = 0;
                ++i;
            }
            i = 0;
            while (i < this.nAuxValuesPerPacket) {
                this.rawReceivedDataPacket.auxValues[i] = 0;
                this.dataPacket.auxValues[i] = 0;
                this.missedDataPacket.auxValues[i] = 0;
                ++i;
            }
        }

        public int closeSDandPort() {
            this.closeSDFile();
            return this.closePort();
        }

        public int closePort() {
            if (this.isSerial()) {
                return OpenBCI_GUI.this.hub.disconnectSerial();
            }
            return OpenBCI_GUI.this.hub.disconnectWifi();
        }

        public int closeSDFile() {
            OpenBCI_GUI.println((String)"Closing any open SD file. Writing 'j' to OpenBCI.");
            if (this.isPortOpen()) {
                this.write('j');
            }
            OpenBCI_GUI.this.delay(100);
            return 0;
        }

        public void syncWithHardware(int sdSetting) {
            switch (this.hardwareSyncStep) {
                case 1: {
                    OpenBCI_GUI.println((String)("Cyton: syncWithHardware: [1] Sending channel count (" + OpenBCI_GUI.this.nchan + ") to OpenBCI..."));
                    if (OpenBCI_GUI.this.nchan == 8) {
                        this.write('c');
                    }
                    if (OpenBCI_GUI.this.nchan != 16) break;
                    this.write('C', false);
                    break;
                }
                case 2: {
                    OpenBCI_GUI.println((String)"Cyton: syncWithHardware: [2] Reseting OpenBCI registers to default... writing 'd'...");
                    this.write('d');
                    break;
                }
                case 3: {
                    OpenBCI_GUI.println((String)"Cyton: syncWithHardware: [3] Retrieving OpenBCI's channel settings to sync with GUI... writing 'D'... waiting for $$$...");
                    this.write('D', false);
                    break;
                }
                case 4: {
                    OpenBCI_GUI.println((String)"Cyton: syncWithHardware: [4] Retrieving OpenBCI's full register map for verification... writing '?'... waiting for $$$...");
                    this.write('?', false);
                    break;
                }
                case 5: {
                    switch (sdSetting) {
                        case 1: {
                            this.write('A', false);
                            break;
                        }
                        case 2: {
                            this.write('S', false);
                            break;
                        }
                        case 3: {
                            this.write('F', false);
                            break;
                        }
                        case 4: {
                            this.write('G', false);
                            break;
                        }
                        case 5: {
                            this.write('H', false);
                            break;
                        }
                        case 6: {
                            this.write('J', false);
                            break;
                        }
                        case 7: {
                            this.write('K', false);
                            break;
                        }
                        case 8: {
                            this.write('L', false);
                            break;
                        }
                    }
                    OpenBCI_GUI.println((String)("Cyton: syncWithHardware: [5] Writing selected SD setting (" + OpenBCI_GUI.this.sdSettingString + ") to OpenBCI..."));
                    if (!OpenBCI_GUI.this.abandonInit) break;
                    OpenBCI_GUI.this.haltSystem();
                    OpenBCI_GUI.this.output("No daisy board present. Make sure you selected the correct number of channels.");
                    OpenBCI_GUI.this.controlPanel.open();
                    OpenBCI_GUI.this.abandonInit = false;
                    break;
                }
                case 6: {
                    OpenBCI_GUI.this.output("Cyton: syncWithHardware: The GUI is done intializing. Click outside of the control panel to interact with the GUI.");
                    OpenBCI_GUI.this.hub.changeState(4);
                    OpenBCI_GUI.this.systemMode = 10;
                    OpenBCI_GUI.this.controlPanel.close();
                    OpenBCI_GUI.this.topNav.controlPanelCollapser.setIsActive(false);
                }
            }
        }

        public void writeCommand(String val) {
            if (OpenBCI_GUI.this.hub.isHubRunning()) {
                OpenBCI_GUI.this.hub.write(String.valueOf(val));
            }
        }

        public boolean write(char val) {
            if (OpenBCI_GUI.this.hub.isHubRunning()) {
                OpenBCI_GUI.this.hub.sendCommand(val);
                return true;
            }
            return false;
        }

        public boolean write(char val, boolean _readyToSend) {
            return this.write(val);
        }

        public boolean write(String out, boolean _readyToSend) {
            return this.write(out);
        }

        public boolean write(String out) {
            if (OpenBCI_GUI.this.hub.isHubRunning()) {
                OpenBCI_GUI.this.hub.write(out);
                return true;
            }
            return false;
        }

        private boolean isSerial() {
            return this.curInterface == 0;
        }

        private boolean isWifi() {
            return this.curInterface == 2;
        }

        public void startDataTransfer() {
            if (this.isPortOpen()) {
                if (this.isSerial()) {
                    OpenBCI_GUI.this.hub.changeState(3);
                    OpenBCI_GUI.println((String)"Cyton: startDataTransfer(): writing 'b' to the serial port...");
                    this.write('b');
                } else if (this.isWifi()) {
                    OpenBCI_GUI.println((String)"Cyton: startDataTransfer(): writing 'b' to the wifi shield...");
                    this.write('b');
                }
            } else {
                OpenBCI_GUI.println((String)"port not open");
            }
        }

        public void stopDataTransfer() {
            if (this.isPortOpen()) {
                OpenBCI_GUI.this.hub.changeState(4);
                OpenBCI_GUI.println((String)"Cyton: startDataTransfer(): writing 's' to the serial port...");
                this.write('s');
            }
        }

        public void printRegisters() {
            if (this.isPortOpen()) {
                OpenBCI_GUI.println((String)"Cyton: printRegisters(): Writing ? to OpenBCI...");
                this.write('?');
            }
        }

        private boolean isPortOpen() {
            if (this.isWifi() || this.isSerial()) {
                return OpenBCI_GUI.this.hub.isPortOpen();
            }
            return false;
        }

        public void changeChannelState(int Ichan, boolean activate) {
            if (this.isPortOpen() && Ichan >= 0) {
                if (activate) {
                    OpenBCI_GUI.this.w_timeSeries.hsc.powerUpChannel(Ichan);
                } else {
                    OpenBCI_GUI.this.w_timeSeries.hsc.powerDownChannel(Ichan);
                }
            }
        }

        public void deactivateChannel(int Ichan) {
            if (this.isPortOpen() && Ichan >= 0 && Ichan < OpenBCI_GUI.this.command_deactivate_channel.length) {
                this.write(OpenBCI_GUI.this.command_deactivate_channel[Ichan]);
            }
        }

        public void activateChannel(int Ichan) {
            if (this.isPortOpen() && Ichan >= 0 && Ichan < OpenBCI_GUI.this.command_activate_channel.length) {
                this.write(OpenBCI_GUI.this.command_activate_channel[Ichan]);
            }
        }

        public boolean isStateNormal() {
            return OpenBCI_GUI.this.hub.get_state() == 3;
        }

        private int copyRawDataToFullData() {
            if (this.dataPacket.values.length < 2 * this.rawReceivedDataPacket.values.length) {
                return this.rawReceivedDataPacket.copyTo(this.dataPacket);
            }
            int offsetInd_values = 0;
            int offsetInd_aux = 0;
            if (this.rawReceivedDataPacket.sampleIndex % 2 == 0) {
                offsetInd_values = this.rawReceivedDataPacket.values.length;
                offsetInd_aux = 0;
            }
            return this.rawReceivedDataPacket.copyTo(this.dataPacket, offsetInd_values, offsetInd_aux);
        }

        public int copyDataPacketTo(DataPacket_ADS1299 target) {
            return this.dataPacket.copyTo(target);
        }

        public void configureAllChannelsToDefault() {
            this.write('d');
        }

        public void initChannelWrite(int _numChannel) {
            this.timeOfLastChannelWrite = OpenBCI_GUI.this.millis();
            this.isWritingChannel = true;
        }

        public void syncChannelSettings() {
            this.write("r,start,;\n");
        }

        public char getCommandForGain(int gain) {
            switch (gain) {
                case 1: {
                    return '0';
                }
                case 2: {
                    return '1';
                }
                case 4: {
                    return '2';
                }
                case 6: {
                    return '3';
                }
                case 8: {
                    return '4';
                }
                case 12: {
                    return '5';
                }
            }
            return '6';
        }

        public char getCommandForInputType(String inputType) {
            if (inputType.equals("normal")) {
                return '0';
            }
            if (inputType.equals("shorted")) {
                return '1';
            }
            if (inputType.equals("biasMethod")) {
                return '2';
            }
            if (inputType.equals("mvdd")) {
                return '3';
            }
            if (inputType.equals("temp")) {
                return '4';
            }
            if (inputType.equals("testsig")) {
                return '5';
            }
            if (inputType.equals("biasDrp")) {
                return '6';
            }
            if (inputType.equals("biasDrn")) {
                return '7';
            }
            return '0';
        }

        public int getGainForCommand(char cmd) {
            switch (cmd) {
                case '0': {
                    return 1;
                }
                case '1': {
                    return 2;
                }
                case '2': {
                    return 4;
                }
                case '3': {
                    return 6;
                }
                case '4': {
                    return 8;
                }
                case '5': {
                    return 12;
                }
            }
            return 24;
        }

        public String getInputTypeForCommand(char cmd) {
            switch (cmd) {
                case '1': {
                    return "shorted";
                }
                case '2': {
                    return "biasMethod";
                }
                case '3': {
                    return "mvdd";
                }
                case '4': {
                    return "temp";
                }
                case '5': {
                    return "testsig";
                }
                case '6': {
                    return "biasDrp";
                }
                case '7': {
                    return "biasDrn";
                }
            }
            return "normal";
        }

        public String getSDSettingForSetting(int setting) {
            switch (setting) {
                case 1: {
                    return "5min";
                }
                case 2: {
                    return "15min";
                }
                case 3: {
                    return "30min";
                }
                case 4: {
                    return "1hour";
                }
                case 5: {
                    return "2hour";
                }
                case 6: {
                    return "4hour";
                }
                case 7: {
                    return "12hour";
                }
                case 8: {
                    return "24hour";
                }
            }
            return "";
        }

        public void writeChannelSettings(int _numChannel, char[][] channelSettingValues) {
            String output = "r,set,";
            output = String.valueOf(output) + Integer.toString(_numChannel) + ",";
            output = String.valueOf(output) + channelSettingValues[_numChannel][0] + ",";
            output = String.valueOf(output) + this.getGainForCommand(channelSettingValues[_numChannel][1]) + ",";
            output = String.valueOf(output) + this.getInputTypeForCommand(channelSettingValues[_numChannel][2]) + ",";
            output = String.valueOf(output) + channelSettingValues[_numChannel][3] + ",";
            output = String.valueOf(output) + channelSettingValues[_numChannel][4] + ",";
            output = String.valueOf(output) + channelSettingValues[_numChannel][5] + OpenBCI_GUI.TCP_STOP;
            this.write(output);
            this.isWritingChannel = false;
        }

        public boolean get_isWritingImp() {
            return this.isWritingImp;
        }

        public void writeImpedanceSettings(int _numChannel, char[][] impedanceCheckValues) {
            String output = "i,set,";
            output = _numChannel < 8 ? String.valueOf(output) + (char)(48 + (_numChannel + 1)) + "," : String.valueOf(output) + OpenBCI_GUI.this.command_activate_channel[_numChannel] + ",";
            output = String.valueOf(output) + impedanceCheckValues[_numChannel][0] + ",";
            output = String.valueOf(output) + impedanceCheckValues[_numChannel][1] + OpenBCI_GUI.TCP_STOP;
            this.write(output);
            this.isWritingImp = false;
        }
    }

    class DataLogBox {
        int x;
        int y;
        int w;
        int h;
        int padding;
        String fileName;
        String fileStatus;
        boolean isFileOpen;

        DataLogBox(int _x, int _y, int _w, int _h, int _padding) {
            this.x = _x;
            this.y = _y;
            this.w = _w;
            this.h = 127;
            this.padding = _padding;
            this.isFileOpen = false;
            this.fileStatus = "NO FILE CREATED";
            OpenBCI_GUI.this.autoFileName = new Button(this.x + this.padding, this.y + 66, this.w - this.padding * 2, 24, "AUTOGENERATE FILE NAME", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
            OpenBCI_GUI.this.outputODF = new Button(this.x + this.padding, this.y + this.padding * 2 + 18 + 58, (this.w - this.padding * 3) / 2, 24, "OpenBCI", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
            if (OpenBCI_GUI.this.outputDataSource == 1) {
                OpenBCI_GUI.this.outputODF.color_notPressed = OpenBCI_GUI.this.isSelected_color;
            }
            OpenBCI_GUI.this.outputBDF = new Button(this.x + this.padding * 2 + (this.w - this.padding * 3) / 2, this.y + this.padding * 2 + 18 + 58, (this.w - this.padding * 3) / 2, 24, "BDF+", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
            if (OpenBCI_GUI.this.outputDataSource == 2) {
                OpenBCI_GUI.this.outputBDF.color_notPressed = OpenBCI_GUI.this.isSelected_color;
            }
            ((Textfield)((Textfield)((Textfield)((Textfield)((Textfield)((Textfield)((Textfield)((Textfield)((Textfield)OpenBCI_GUI.this.cp5.addTextfield("fileName").setPosition((float)(this.x + 90), (float)(this.y + 32))).setCaptionLabel("")).setSize(157, 26).setFont(OpenBCI_GUI.this.f2)).setFocus(false).setColor(OpenBCI_GUI.this.color(26, 26, 26)).setColorBackground(OpenBCI_GUI.this.color(255, 255, 255))).setColorValueLabel(OpenBCI_GUI.this.color(0, 0, 0))).setColorForeground(OpenBCI_GUI.this.isSelected_color)).setColorActive(OpenBCI_GUI.this.isSelected_color)).setColorCursor(OpenBCI_GUI.this.color(26, 26, 26)).setText(OpenBCI_GUI.this.getDateString()).align(5, 10, 20, 40)).onDoublePress(OpenBCI_GUI.this.cb)).setAutoClear(true);
        }

        public void update() {
        }

        public void draw() {
            OpenBCI_GUI.this.pushStyle();
            OpenBCI_GUI.this.fill(OpenBCI_GUI.this.boxColor);
            OpenBCI_GUI.this.stroke(OpenBCI_GUI.this.boxStrokeColor);
            OpenBCI_GUI.this.strokeWeight(1.0f);
            OpenBCI_GUI.this.rect(this.x, this.y, this.w, this.h);
            OpenBCI_GUI.this.fill(OpenBCI_GUI.this.bgColor);
            OpenBCI_GUI.this.textFont(OpenBCI_GUI.this.h3, 16.0f);
            OpenBCI_GUI.this.textAlign(37, 101);
            OpenBCI_GUI.this.text("DATA LOG FILE", this.x + this.padding, this.y + this.padding);
            OpenBCI_GUI.this.textFont(OpenBCI_GUI.this.p4, 14.0f);
            OpenBCI_GUI.this.text("File Name", this.x + this.padding, this.y + this.padding * 2 + 14);
            OpenBCI_GUI.this.popStyle();
            ((Textfield)OpenBCI_GUI.this.cp5.get(Textfield.class, "fileName")).setPosition((float)(this.x + 90), (float)(this.y + 32));
            OpenBCI_GUI.this.autoFileName.but_y = this.y + 66;
            OpenBCI_GUI.this.autoFileName.draw();
            OpenBCI_GUI.this.outputODF.but_y = this.y + this.padding * 2 + 18 + 58;
            OpenBCI_GUI.this.outputODF.draw();
            OpenBCI_GUI.this.outputBDF.but_y = this.y + this.padding * 2 + 18 + 58;
            OpenBCI_GUI.this.outputBDF.draw();
        }
    }

    class DataLogBoxGanglion {
        int x;
        int y;
        int w;
        int h;
        int padding;
        String fileName;
        String fileStatus;
        boolean isFileOpen;

        DataLogBoxGanglion(int _x, int _y, int _w, int _h, int _padding) {
            this.x = _x;
            this.y = _y;
            this.w = _w;
            this.h = 127;
            this.padding = _padding;
            this.isFileOpen = false;
            this.fileStatus = "NO FILE CREATED";
            OpenBCI_GUI.this.autoFileNameGanglion = new Button(this.x + this.padding, this.y + 66, this.w - this.padding * 2, 24, "AUTOGENERATE FILE NAME", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
            OpenBCI_GUI.this.outputODFGanglion = new Button(this.x + this.padding, this.y + this.padding * 2 + 18 + 58, (this.w - this.padding * 3) / 2, 24, "OpenBCI", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
            if (OpenBCI_GUI.this.outputDataSource == 1) {
                OpenBCI_GUI.this.outputODFGanglion.color_notPressed = OpenBCI_GUI.this.isSelected_color;
            }
            OpenBCI_GUI.this.outputBDFGanglion = new Button(this.x + this.padding * 2 + (this.w - this.padding * 3) / 2, this.y + this.padding * 2 + 18 + 58, (this.w - this.padding * 3) / 2, 24, "BDF+", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
            if (OpenBCI_GUI.this.outputDataSource == 2) {
                OpenBCI_GUI.this.outputODFGanglion.color_notPressed = OpenBCI_GUI.this.isSelected_color;
            }
            ((Textfield)((Textfield)((Textfield)((Textfield)((Textfield)((Textfield)((Textfield)((Textfield)((Textfield)OpenBCI_GUI.this.cp5.addTextfield("fileNameGanglion").setPosition((float)(this.x + 90), (float)(this.y + 32))).setCaptionLabel("")).setSize(157, 26).setFont(OpenBCI_GUI.this.f2)).setFocus(false).setColor(OpenBCI_GUI.this.color(26, 26, 26)).setColorBackground(OpenBCI_GUI.this.color(255, 255, 255))).setColorValueLabel(OpenBCI_GUI.this.color(0, 0, 0))).setColorForeground(OpenBCI_GUI.this.isSelected_color)).setColorActive(OpenBCI_GUI.this.isSelected_color)).setColorCursor(OpenBCI_GUI.this.color(26, 26, 26)).setText(OpenBCI_GUI.this.getDateString()).align(5, 10, 20, 40)).onDoublePress(OpenBCI_GUI.this.cb)).setAutoClear(true);
        }

        public void update() {
        }

        public void draw() {
            OpenBCI_GUI.this.pushStyle();
            OpenBCI_GUI.this.fill(OpenBCI_GUI.this.boxColor);
            OpenBCI_GUI.this.stroke(OpenBCI_GUI.this.boxStrokeColor);
            OpenBCI_GUI.this.strokeWeight(1.0f);
            OpenBCI_GUI.this.rect(this.x, this.y, this.w, this.h);
            OpenBCI_GUI.this.fill(OpenBCI_GUI.this.bgColor);
            OpenBCI_GUI.this.textFont(OpenBCI_GUI.this.h3, 16.0f);
            OpenBCI_GUI.this.textAlign(37, 101);
            OpenBCI_GUI.this.text("DATA LOG FILE", this.x + this.padding, this.y + this.padding);
            OpenBCI_GUI.this.textFont(OpenBCI_GUI.this.p4, 14.0f);
            OpenBCI_GUI.this.text("File Name", this.x + this.padding, this.y + this.padding * 2 + 14);
            OpenBCI_GUI.this.popStyle();
            ((Textfield)OpenBCI_GUI.this.cp5.get(Textfield.class, "fileNameGanglion")).setPosition((float)(this.x + 90), (float)(this.y + 32));
            OpenBCI_GUI.this.autoFileNameGanglion.but_y = this.y + 66;
            OpenBCI_GUI.this.autoFileNameGanglion.draw();
            OpenBCI_GUI.this.outputODFGanglion.but_y = this.y + this.padding * 2 + 18 + 58;
            OpenBCI_GUI.this.outputODFGanglion.draw();
            OpenBCI_GUI.this.outputBDFGanglion.but_y = this.y + this.padding * 2 + 18 + 58;
            OpenBCI_GUI.this.outputBDFGanglion.draw();
        }
    }

    class DataPacket_ADS1299 {
        private final int rawAdsSize = 3;
        private final int rawAuxSize = 2;
        int sampleIndex;
        int[] values;
        int[] auxValues;
        byte[][] rawValues;
        byte[][] rawAuxValues;

        DataPacket_ADS1299(int nValues, int nAuxValues) {
            this.values = new int[nValues];
            this.auxValues = new int[nAuxValues];
            this.rawValues = new byte[nValues][3];
            this.rawAuxValues = new byte[nAuxValues][3];
        }

        public int printToConsole() {
            OpenBCI_GUI.print((String)"printToConsole: DataPacket = ");
            OpenBCI_GUI.print((int)this.sampleIndex);
            int i = 0;
            while (i < this.values.length) {
                OpenBCI_GUI.print((String)(", " + this.values[i]));
                ++i;
            }
            i = 0;
            while (i < this.auxValues.length) {
                OpenBCI_GUI.print((String)(", " + this.auxValues[i]));
                ++i;
            }
            OpenBCI_GUI.println();
            return 0;
        }

        public int copyTo(DataPacket_ADS1299 target) {
            return this.copyTo(target, 0, 0);
        }

        public int copyTo(DataPacket_ADS1299 target, int target_startInd_values, int target_startInd_aux) {
            target.sampleIndex = this.sampleIndex;
            return this.copyValuesAndAuxTo(target, target_startInd_values, target_startInd_aux);
        }

        public int copyValuesAndAuxTo(DataPacket_ADS1299 target, int target_startInd_values, int target_startInd_aux) {
            int nvalues = this.values.length;
            int i = 0;
            while (i < nvalues) {
                target.values[target_startInd_values + i] = this.values[i];
                target.rawValues[target_startInd_values + i] = this.rawValues[i];
                ++i;
            }
            nvalues = this.auxValues.length;
            i = 0;
            while (i < nvalues) {
                target.auxValues[target_startInd_aux + i] = this.auxValues[i];
                target.rawAuxValues[target_startInd_aux + i] = this.rawAuxValues[i];
                ++i;
            }
            return 0;
        }
    }

    class DataProcessing {
        private float fs_Hz;
        private int nchan;
        final int N_FILT_CONFIGS = 5;
        FilterConstants[] filtCoeff_bp = new FilterConstants[5];
        final int N_NOTCH_CONFIGS = 3;
        FilterConstants[] filtCoeff_notch = new FilterConstants[3];
        private int currentFilt_ind = 3;
        private int currentNotch_ind = 0;
        float[] data_std_uV;
        float[] polarity;
        boolean newDataToSend;
        private String[] binNames;
        final int[] processing_band_low_Hz = new int[]{1, 4, 8, 13, 30};
        final int[] processing_band_high_Hz = new int[]{4, 8, 13, 30, 55};
        float[][] avgPowerInBins;
        float[] headWidePower;
        int numBins;

        DataProcessing(int NCHAN, float sample_rate_Hz) {
            this.nchan = NCHAN;
            this.fs_Hz = sample_rate_Hz;
            this.data_std_uV = new float[this.nchan];
            this.polarity = new float[this.nchan];
            this.newDataToSend = false;
            this.avgPowerInBins = new float[this.nchan][this.processing_band_low_Hz.length];
            this.headWidePower = new float[this.processing_band_low_Hz.length];
            this.defineFilters();
        }

        private void defineFilters() {
            int n_filt = this.filtCoeff_notch.length;
            int Ifilt = 0;
            while (Ifilt < n_filt) {
                switch (Ifilt) {
                    case 0: {
                        double[] a2;
                        double[] b2;
                        switch (PApplet.parseInt((float)this.fs_Hz)) {
                            case 125: {
                                b2 = new double[]{0.9313788414001465, 3.700812816619873, 5.539031982421875, 3.700812816619873, 0.9313788414001465};
                                a2 = new double[]{1.0, 3.832462f, 5.534317493438721, 3.5691637992858887, 0.8674721121788025};
                                break;
                            }
                            case 200: {
                                b2 = new double[]{0.9565432071685791, 1.182936191558838, 2.2788143157958984, 1.182936191558838, 0.9565432071685791};
                                a2 = new double[]{1.0, 1.209223f, 2.2769248485565186, 1.1566492319107056, 0.9149758219718933};
                                break;
                            }
                            case 250: {
                                b2 = new double[]{0.965080976486206, -0.24246832728385925, 1.9453915357589722, -0.24246832728385925, 0.965080976486206};
                                a2 = new double[]{1.0, -0.24677826464176178, 1.9441717863082886, -0.23815837502479553, 0.9313817024230957};
                                break;
                            }
                            case 500: {
                                b2 = new double[]{0.9823854565620422, -2.864738941192627, 4.0532402992248535, -2.864738941192627, 0.9823854565620422};
                                a2 = new double[]{1.0, -2.890195608139038, 4.0529303550720215, -2.839282f, 0.9650811553001404};
                                break;
                            }
                            case 1000: {
                                b2 = new double[]{0.9911535978317261, -3.686278f, 5.409789562225342, -3.686278f, 0.9911535978317261};
                                a2 = new double[]{1.0, -3.702655792236328, 5.4097113609313965, -3.6699001789093018, 0.9823854565620422};
                                break;
                            }
                            case 1600: {
                                b2 = new double[]{0.9944617748260498, -3.867968797683716, 5.750049114227295, -3.867968797683716, 0.9944617748260498};
                                a2 = new double[]{1.0, -3.878709316253662, 5.75001859664917, -3.857228f, 0.9889542460441589};
                                break;
                            }
                            default: {
                                OpenBCI_GUI.println((String)"EEG_Processing: *** ERROR *** Filters can only work at 125Hz, 200Hz, 250 Hz, 1000Hz or 1600Hz");
                                b2 = new double[]{1.0};
                                a2 = new double[]{1.0};
                            }
                        }
                        this.filtCoeff_notch[Ifilt] = new FilterConstants(b2, a2, "Notch 60Hz", "60Hz");
                        break;
                    }
                    case 1: {
                        double[] a2;
                        double[] b2;
                        switch (PApplet.parseInt((float)this.fs_Hz)) {
                            case 125: {
                                b2 = new double[]{0.9313788414001465, 3.017817f, 4.307310581207275, 3.017817f, 0.9313788414001465};
                                a2 = new double[]{1.0, 3.1251697540283203, 4.302596092224121, 2.91046404838562, 0.8674721121788025};
                                break;
                            }
                            case 200: {
                                b2 = new double[]{0.9565432071685791, -2.3428552803205643E-16, 1.9130864143371582, -2.3428552803205643E-16, 0.9565432071685791};
                                a2 = new double[]{1.0, -1.4155343563970746E-15, 1.9111970663070679, -1.366962099069724E-15, 0.9149758219718933};
                                break;
                            }
                            case 250: {
                                b2 = new double[]{0.965080976486206, -1.1932826042175293, 2.299023151397705, -1.1932826042175293, 0.965080976486206};
                                a2 = new double[]{1.0, -1.2144935131072998, 2.2978034019470215, -1.1720715761184692, 0.9313817024230957};
                                break;
                            }
                            case 500: {
                                b2 = new double[]{0.9823854565620422, -3.179316997528076, 4.537095546722412, -3.179316997528076, 0.9823854565620422};
                                a2 = new double[]{1.0, -3.207569122314453, 4.536785125732422, -3.151064872741699, 0.9650811553001404};
                                break;
                            }
                            case 1000: {
                                b2 = new double[]{0.9911535978317261, -3.770646810531616, 5.56847620010376, -3.770646810531616, 0.9911535978317261};
                                a2 = new double[]{1.0, -3.7873995304107666, 5.568398f, -3.753894090652466, 0.9823854565620422};
                                break;
                            }
                            case 1600: {
                                b2 = new double[]{0.9944617748260498, -3.901444f, 5.815432071685791, -3.901444f, 0.9944617748260498};
                                a2 = new double[]{1.0, -3.9122776985168457, 5.815401077270508, -3.890610456466675, 0.9889542460441589};
                                break;
                            }
                            default: {
                                OpenBCI_GUI.println((String)"EEG_Processing: *** ERROR *** Filters can only work at 125Hz, 200Hz, 250 Hz, 1000Hz or 1600Hz");
                                b2 = new double[]{1.0};
                                a2 = new double[]{1.0};
                            }
                        }
                        this.filtCoeff_notch[Ifilt] = new FilterConstants(b2, a2, "Notch 50Hz", "50Hz");
                        break;
                    }
                    case 2: {
                        double[] b2 = new double[]{1.0};
                        double[] a2 = new double[]{1.0};
                        this.filtCoeff_notch[Ifilt] = new FilterConstants(b2, a2, "No Notch", "None");
                    }
                }
                ++Ifilt;
            }
            n_filt = this.filtCoeff_bp.length;
            Ifilt = 0;
            while (Ifilt < n_filt) {
                String short_txt;
                String filt_txt;
                double[] a;
                double[] b;
                switch (Ifilt) {
                    case 0: {
                        switch (PApplet.parseInt((float)this.fs_Hz)) {
                            case 125: {
                                b = new double[]{0.6158772110939026, 0.0, -1.2317544221878052, 0.0, 0.6158772110939026};
                                a = new double[]{1.0, -0.7893075346946716, -0.8532639145851135, 0.263711f, 0.3851904273033142};
                                break;
                            }
                            case 200: {
                                b = new double[]{0.2837512195110321, 0.0, -0.5675024390220642, 0.0, 0.2837512195110321};
                                a = new double[]{1.0, -1.9738037586212158, 1.1718124151229858, -0.36866453289985657, 0.17181238532066345};
                                break;
                            }
                            case 250: {
                                b = new double[]{0.20013873279094696, 0.0, -0.4002774655818939, 0.0, 0.20013873279094696};
                                a = new double[]{1.0, -2.3559346199035645, 1.941257119178772, -0.7847063541412354, 0.1999076008796692};
                                break;
                            }
                            case 500: {
                                b = new double[]{0.06520165503025055, 0.0, -0.1304033100605011, 0.0, 0.06520165503025055};
                                a = new double[]{1.0, -3.1463656425476074, 3.717545986175537, -1.991183f, 0.4200455f};
                                break;
                            }
                            case 1000: {
                                b = new double[]{0.01936156675219536, 0.0, -0.03872313350439072, 0.0, 0.01936156675219536};
                                a = new double[]{1.0, -3.566072f, 4.779918193817139, -2.8609118461608887, 0.6470689177513123};
                                break;
                            }
                            case 1600: {
                                b = new double[]{0.008128857240080833, 0.0, -0.016257714480161667, 0.0, 0.008128857240080833};
                                a = new double[]{1.0, -3.7278075218200684, 5.217564582824707, -3.2515218257904053, 0.761765f};
                                break;
                            }
                            default: {
                                OpenBCI_GUI.println((String)"EEG_Processing: *** ERROR *** Filters can only work at 125Hz, 200Hz, 250 Hz, 1000Hz or 1600Hz");
                                b = new double[]{1.0};
                                a = new double[]{1.0};
                            }
                        }
                        filt_txt = "Bandpass 1-50Hz";
                        short_txt = "1-50 Hz";
                        break;
                    }
                    case 1: {
                        switch (PApplet.parseInt((float)this.fs_Hz)) {
                            case 125: {
                                b = new double[]{0.018650395795702934, 0.0, -0.03730079159140587, 0.0, 0.018650395795702934};
                                a = new double[]{1.0, -3.1716246604919434, 4.116708755493164, -2.556199550628662, 0.6528377532958984};
                                break;
                            }
                            case 200: {
                                b = new double[]{0.007820207625627518, 0.0, -0.015640415251255035, 0.0, 0.007820207625627518};
                                a = new double[]{1.0, -3.567769f, 4.92946195602417, -3.1207032203674316, 0.766006588935852};
                                break;
                            }
                            case 250: {
                                b = new double[]{0.005129268392920494, 0.0, -0.010258536785840988, 0.0, 0.005129268392920494};
                                a = new double[]{1.0, -3.6788954734802246, 5.1797003746032715, -3.3058018684387207, 0.8079496026039124};
                                break;
                            }
                            case 500: {
                                b = new double[]{0.0013487118994817138, 0.0, -0.0026974237989634275, 0.0, 0.0013487118994817138};
                                a = new double[]{1.0, -3.865509510040283, 5.631525993347168, -3.66468f, 0.8988589644432068};
                                break;
                            }
                            case 1000: {
                                b = new double[]{3.460413427092135E-4, 0.0, -6.92082685418427E-4, 0.0, 3.460413427092135E-4};
                                a = new double[]{1.0, -3.9396095275878906, 5.8275f, -3.8359594345092773, 0.9480817317962646};
                                break;
                            }
                            case 1600: {
                                b = new double[]{1.3651071640197188E-4, 0.0, -2.7302143280394375E-4, 0.0, 1.3651071640197188E-4};
                                a = new double[]{1.0, -3.963898181915283, 5.895071983337402, -3.898399f, 0.9672273993492126};
                                break;
                            }
                            default: {
                                OpenBCI_GUI.println((String)"EEG_Processing: *** ERROR *** Filters can only work at 125Hz, 200Hz, 250 Hz, 1000Hz or 1600Hz");
                                b = new double[]{1.0};
                                a = new double[]{1.0};
                            }
                        }
                        filt_txt = "Bandpass 7-13Hz";
                        short_txt = "7-13 Hz";
                        break;
                    }
                    case 2: {
                        switch (PApplet.parseInt((float)this.fs_Hz)) {
                            case 125: {
                                b = new double[]{0.3503463864326477, 0.0, -0.7006927728652954, 0.0, 0.3503463864326477};
                                a = new double[]{1.0, 0.1752282679080963, -0.2118469476699829, 0.013723035342991352, 0.18023207783699036};
                                break;
                            }
                            case 200: {
                                b = new double[]{0.1674838f, 0.0, -0.3349676f, 0.0, 0.1674838f};
                                a = new double[]{1.0, -1.5669505596160889, 1.226966142654419, -0.6195191740989685, 0.2269662f};
                                break;
                            }
                            case 250: {
                                b = new double[]{0.11735104024410248, 0.0, -0.23470208048820496, 0.0, 0.11735104024410248};
                                a = new double[]{1.0, -2.137430191040039, 2.038578f, -1.0701444149017334, 0.2946365177631378};
                                break;
                            }
                            case 500: {
                                b = new double[]{0.036574836820364, 0.0, -0.073149673640728, 0.0, 0.036574836820364};
                                a = new double[]{1.0, -3.1888065338134766, 3.980372f, -2.318359851837158, 0.5371946096420288};
                                break;
                            }
                            case 1000: {
                                b = new double[]{0.010432413779199123, 0.0, -0.020864827558398247, 0.0, 0.010432413779199123};
                                a = new double[]{1.0, -3.6362674236297607, 5.01393985748291, -3.1096456050872803, 0.7327260375022888};
                                break;
                            }
                            case 1600: {
                                b = new double[]{0.004298847168684006, 0.0, -0.008597694337368011, 0.0, 0.004298847168684006};
                                a = new double[]{1.0, -3.7841298580169678, 5.39377498626709, -3.432873487472534, 0.8233495950698853};
                                break;
                            }
                            default: {
                                OpenBCI_GUI.println((String)"EEG_Processing: *** ERROR *** Filters can only work at 125Hz, 200Hz, 250 Hz, 1000Hz or 1600Hz");
                                b = new double[]{1.0};
                                a = new double[]{1.0};
                            }
                        }
                        filt_txt = "Bandpass 15-50Hz";
                        short_txt = "15-50 Hz";
                        break;
                    }
                    case 3: {
                        switch (PApplet.parseInt((float)this.fs_Hz)) {
                            case 125: {
                                b = new double[]{0.5299672484397888, 0.0, -1.0599344968795776, 0.0, 0.5299672484397888};
                                a = new double[]{1.0, -0.5170037746429443, -0.7343184351921082, 0.1038434f, 0.2946365177631378};
                                break;
                            }
                            case 200: {
                                b = new double[]{0.24834108352661133, 0.0, -0.49668216705322266, 0.0, 0.24834108352661133};
                                a = new double[]{1.0, -1.8654948472976685, 1.177578091621399, -0.4606655240058899, 0.1775781214237213};
                                break;
                            }
                            case 250: {
                                b = new double[]{0.17508764564990997, 0.0, -0.3501753f, 0.0, 0.17508764564990997};
                                a = new double[]{1.0, -2.299055337905884, 1.967497706413269, -0.8748055696487427, 0.21965397894382477};
                                break;
                            }
                            case 500: {
                                b = new double[]{0.05644846335053444, 0.0, -0.11289692670106888, 0.0, 0.05644846335053444};
                                a = new double[]{1.0, -3.159463405609131, 3.792684316635132, -2.082573413848877, 0.4504454433917999};
                                break;
                            }
                            case 1000: {
                                b = new double[]{0.016581932082772255, 0.0, -0.03316386416554451, 0.0, 0.016581932082772255};
                                a = new double[]{1.0, -3.586239814758301, 4.84628963470459, -2.930427312850952, 0.6704578995704651};
                                break;
                            }
                            case 1600: {
                                b = new double[]{0.006925793364644051, 0.0, -0.013851586729288101, 0.0, 0.006925793364644051};
                                a = new double[]{1.0, -3.7439231872558594, 5.267588138580322, -3.302525758743286, 0.778874f};
                                break;
                            }
                            default: {
                                OpenBCI_GUI.println((String)"EEG_Processing: *** ERROR *** Filters can only work at 125Hz, 200Hz, 250 Hz, 1000Hz or 1600Hz");
                                b = new double[]{1.0};
                                a = new double[]{1.0};
                            }
                        }
                        filt_txt = "Bandpass 5-50Hz";
                        short_txt = "5-50 Hz";
                        break;
                    }
                    default: {
                        b = new double[]{1.0};
                        a = new double[]{1.0};
                        filt_txt = "No BP Filter";
                        short_txt = "No Filter";
                    }
                }
                this.filtCoeff_bp[Ifilt] = new FilterConstants(b, a, filt_txt, short_txt);
                ++Ifilt;
            }
        }

        public String getFilterDescription() {
            return String.valueOf(this.filtCoeff_bp[this.currentFilt_ind].name) + ", " + this.filtCoeff_notch[this.currentNotch_ind].name;
        }

        public String getShortFilterDescription() {
            return this.filtCoeff_bp[this.currentFilt_ind].short_name;
        }

        public String getShortNotchDescription() {
            return this.filtCoeff_notch[this.currentNotch_ind].short_name;
        }

        public void incrementFilterConfiguration() {
            ++this.currentFilt_ind;
            if (this.currentFilt_ind >= 5) {
                this.currentFilt_ind = 0;
            }
        }

        public void incrementNotchConfiguration() {
            ++this.currentNotch_ind;
            if (this.currentNotch_ind >= 3) {
                this.currentNotch_ind = 0;
            }
        }

        public void process(float[][] data_newest_uV, float[][] data_long_uV, float[][] data_forDisplay_uV, FFT[] fftData) {
            int Nfft = OpenBCI_GUI.this.getNfftSafe();
            int Ichan = 0;
            while (Ichan < this.nchan) {
                OpenBCI_GUI.this.filterIIR(this.filtCoeff_notch[this.currentNotch_ind].b, this.filtCoeff_notch[this.currentNotch_ind].a, data_forDisplay_uV[Ichan]);
                OpenBCI_GUI.this.filterIIR(this.filtCoeff_bp[this.currentFilt_ind].b, this.filtCoeff_bp[this.currentFilt_ind].a, data_forDisplay_uV[Ichan]);
                float[] fooData_filt = OpenBCI_GUI.this.dataBuffY_filtY_uV[Ichan];
                fooData_filt = Arrays.copyOfRange(fooData_filt, fooData_filt.length - (int)this.fs_Hz, fooData_filt.length);
                this.data_std_uV[Ichan] = OpenBCI_GUI.this.std(fooData_filt);
                ++Ichan;
            }
            float[] prevFFTdata = new float[OpenBCI_GUI.this.fftBuff[0].specSize()];
            int Ichan2 = 0;
            while (Ichan2 < this.nchan) {
                int I = 0;
                while (I < OpenBCI_GUI.this.fftBuff[Ichan2].specSize()) {
                    prevFFTdata[I] = OpenBCI_GUI.this.fftBuff[Ichan2].getBand(I);
                    ++I;
                }
                float[] fooData = OpenBCI_GUI.this.isFFTFiltered ? OpenBCI_GUI.this.dataBuffY_filtY_uV[Ichan2] : OpenBCI_GUI.this.dataBuffY_uV[Ichan2];
                fooData = Arrays.copyOfRange(fooData, fooData.length - Nfft, fooData.length);
                float meanData = OpenBCI_GUI.this.mean(fooData);
                int I2 = 0;
                while (I2 < fooData.length) {
                    int n = I2++;
                    fooData[n] = fooData[n] - meanData;
                }
                OpenBCI_GUI.this.fftBuff[Ichan2].forward(fooData);
                I2 = 0;
                while (I2 <= Nfft / 2) {
                    OpenBCI_GUI.this.fftBuff[Ichan2].setBand(I2, OpenBCI_GUI.this.fftBuff[Ichan2].getBand(I2) / (float)Nfft);
                    ++I2;
                }
                I2 = 1;
                while (I2 < Nfft / 2) {
                    OpenBCI_GUI.this.fftBuff[Ichan2].setBand(I2, OpenBCI_GUI.this.fftBuff[Ichan2].getBand(I2) * 2.0f);
                    ++I2;
                }
                double min_val = 0.01;
                int I3 = 0;
                while (I3 < OpenBCI_GUI.this.fftBuff[Ichan2].specSize()) {
                    double foo;
                    if ((double)prevFFTdata[I3] < min_val) {
                        prevFFTdata[I3] = (float)min_val;
                    }
                    if ((foo = (double)OpenBCI_GUI.this.fftBuff[Ichan2].getBand(I3)) < min_val) {
                        foo = min_val;
                    }
                    foo = (1.0 - (double)OpenBCI_GUI.this.smoothFac[OpenBCI_GUI.this.smoothFac_ind]) * Math.log(Math.pow(foo, 2.0));
                    foo += (double)OpenBCI_GUI.this.smoothFac[OpenBCI_GUI.this.smoothFac_ind] * Math.log(Math.pow(prevFFTdata[I3], 2.0));
                    foo = Math.sqrt(Math.exp(foo));
                    OpenBCI_GUI.this.fftBuff[Ichan2].setBand(I3, (float)foo);
                    ++I3;
                }
                int i = 0;
                while (i < this.processing_band_low_Hz.length) {
                    float sum = 0.0f;
                    int Ibin = 0;
                    while (Ibin <= Nfft / 2) {
                        float FFT_freq_Hz = OpenBCI_GUI.this.fftBuff[Ichan2].indexToFreq(Ibin);
                        float psdx = 0.0f;
                        if (FFT_freq_Hz >= (float)this.processing_band_low_Hz[i] && FFT_freq_Hz < (float)this.processing_band_high_Hz[i]) {
                            psdx = Ibin != 0 && Ibin != Nfft / 2 ? OpenBCI_GUI.this.fftBuff[Ichan2].getBand(Ibin) * OpenBCI_GUI.this.fftBuff[Ichan2].getBand(Ibin) * (float)Nfft / OpenBCI_GUI.this.getSampleRateSafe() / 4.0f : OpenBCI_GUI.this.fftBuff[Ichan2].getBand(Ibin) * OpenBCI_GUI.this.fftBuff[Ichan2].getBand(Ibin) * (float)Nfft / OpenBCI_GUI.this.getSampleRateSafe();
                            sum += psdx;
                        }
                        ++Ibin;
                    }
                    this.avgPowerInBins[Ichan2][i] = sum;
                    ++i;
                }
                ++Ichan2;
            }
            int i = 0;
            while (i < this.processing_band_low_Hz.length) {
                float sum = 0.0f;
                int j = 0;
                while (j < this.nchan) {
                    sum += this.avgPowerInBins[j][i];
                    ++j;
                }
                this.headWidePower[i] = sum / (float)this.nchan;
                ++i;
            }
            int refChanInd = OpenBCI_GUI.this.findMax(this.data_std_uV);
            float[] refData_uV = OpenBCI_GUI.this.dataBuffY_filtY_uV[refChanInd];
            refData_uV = Arrays.copyOfRange(refData_uV, refData_uV.length - (int)this.fs_Hz, refData_uV.length);
            int Ichan3 = 0;
            while (Ichan3 < this.nchan) {
                float[] fooData_filt = OpenBCI_GUI.this.dataBuffY_filtY_uV[Ichan3];
                float dotProd = OpenBCI_GUI.this.calcDotProduct(fooData_filt = Arrays.copyOfRange(fooData_filt, fooData_filt.length - (int)this.fs_Hz, fooData_filt.length), refData_uV);
                this.polarity[Ichan3] = dotProd >= 0.0f ? 1.0f : -1.0f;
                ++Ichan3;
            }
        }
    }

    class DataProcessing_User {
        private float fs_Hz;
        private int n_chan;
        boolean switchesActive = false;
        Button leftConfig;
        Button midConfig;
        Button rightConfig;

        DataProcessing_User(int NCHAN, float sample_rate_Hz) {
            this.leftConfig = new Button(3 * (OpenBCI_GUI.this.width / 4) - 65, OpenBCI_GUI.this.height / 4 - 120, 20, 20, "\\/", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
            this.midConfig = new Button(3 * (OpenBCI_GUI.this.width / 4) + 63, OpenBCI_GUI.this.height / 4 - 120, 20, 20, "\\/", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
            this.rightConfig = new Button(3 * (OpenBCI_GUI.this.width / 4) + 190, OpenBCI_GUI.this.height / 4 - 120, 20, 20, "\\/", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
            this.n_chan = NCHAN;
            this.fs_Hz = sample_rate_Hz;
        }

        public void process(float[][] data_newest_uV, float[][] data_long_uV, float[][] data_forDisplay_uV, FFT[] fftData) {
        }
    }

    class DataSourceBox {
        int x;
        int y;
        int w;
        int h;
        int padding;
        int numItems = 4;
        int boxHeight = 24;
        int spacing = 43;
        CheckBox sourceCheckBox;

        DataSourceBox(int _x, int _y, int _w, int _h, int _padding) {
            this.x = _x;
            this.y = _y;
            this.w = _w;
            this.h = this.spacing + this.numItems * this.boxHeight;
            this.padding = _padding;
            OpenBCI_GUI.this.sourceList = new MenuList(OpenBCI_GUI.this.cp5, "sourceList", this.w - this.padding * 2, this.numItems * this.boxHeight, OpenBCI_GUI.this.p4);
            OpenBCI_GUI.this.sourceList.setPosition(this.x + this.padding, this.y + this.padding * 2 + 13);
            OpenBCI_GUI.this.sourceList.addItem(OpenBCI_GUI.this.makeItem("LIVE (from Cyton)"));
            OpenBCI_GUI.this.sourceList.addItem(OpenBCI_GUI.this.makeItem("LIVE (from Ganglion)"));
            OpenBCI_GUI.this.sourceList.addItem(OpenBCI_GUI.this.makeItem("PLAYBACK (from file)"));
            OpenBCI_GUI.this.sourceList.addItem(OpenBCI_GUI.this.makeItem("SYNTHETIC (algorithmic)"));
            OpenBCI_GUI.this.sourceList.scrollerLength = 10;
        }

        public void update() {
        }

        public void draw() {
            OpenBCI_GUI.this.pushStyle();
            OpenBCI_GUI.this.fill(OpenBCI_GUI.this.boxColor);
            OpenBCI_GUI.this.stroke(OpenBCI_GUI.this.boxStrokeColor);
            OpenBCI_GUI.this.strokeWeight(1.0f);
            OpenBCI_GUI.this.rect(this.x, this.y, this.w, this.h);
            OpenBCI_GUI.this.fill(OpenBCI_GUI.this.bgColor);
            OpenBCI_GUI.this.textFont(OpenBCI_GUI.this.h3, 16.0f);
            OpenBCI_GUI.this.textAlign(37, 101);
            OpenBCI_GUI.this.text("DATA SOURCE", this.x + this.padding, this.y + this.padding);
            OpenBCI_GUI.this.popStyle();
        }
    }

    class DataStatus {
        public boolean is_railed = false;
        private int threshold_railed;
        public boolean is_railed_warn;
        private int threshold_railed_warn;

        DataStatus(int thresh_railed, int thresh_railed_warn) {
            this.threshold_railed = thresh_railed;
            this.is_railed_warn = false;
            this.threshold_railed_warn = thresh_railed_warn;
        }

        public void update(int data_value) {
            this.is_railed = false;
            if (OpenBCI_GUI.abs((int)data_value) >= this.threshold_railed) {
                this.is_railed = true;
            }
            this.is_railed_warn = false;
            if (OpenBCI_GUI.abs((int)data_value) >= this.threshold_railed_warn) {
                this.is_railed_warn = true;
            }
        }
    }

    class DetectionData_FreqDomain {
        public float inband_uV = 0.0f;
        public float inband_freq_Hz = 0.0f;
        public float guard_uV = 0.0f;
        public float thresh_uV = 0.0f;
        public boolean isDetected = false;

        DetectionData_FreqDomain() {
        }
    }

    class DigitalReadDot {
        int digitalInputPin;
        int digitalInputVal;
        String digitalInputString;
        int padding;
        boolean isOn;
        TextBox digitalValue;
        TextBox digitalPin;
        boolean drawDigitalValue;
        int dotStroke = -2960686;
        int dot0Fill = -657931;
        int dot1Fill = -657931;
        int val0Fill = -16777216;
        int val1Fill = -1;
        int DotX;
        int DotY;
        int DotWidth;
        int DotHeight;
        float DotCorner;

        DigitalReadDot(PApplet _parent, int _digitalInputPin, int _x, int _y, int _w, int _h, int _padding) {
            this.digitalInputPin = _digitalInputPin;
            this.digitalInputString = OpenBCI_GUI.str((int)this.digitalInputPin);
            this.digitalInputVal = 0;
            this.isOn = true;
            this.dot1Fill = this.digitalInputPin == 11 ? OpenBCI_GUI.this.channelColors[0] : (this.digitalInputPin == 12 ? OpenBCI_GUI.this.channelColors[1] : (this.digitalInputPin == 13 ? OpenBCI_GUI.this.channelColors[2] : (this.digitalInputPin == 17 ? OpenBCI_GUI.this.channelColors[3] : OpenBCI_GUI.this.channelColors[4])));
            this.DotX = _x;
            this.DotY = _y;
            this.DotWidth = _w;
            this.DotHeight = _h;
            this.padding = _padding;
            this.digitalValue = new TextBox("", this.DotX, this.DotY);
            this.digitalValue.textColor = OpenBCI_GUI.this.color(this.val0Fill);
            this.digitalValue.alignH = 3;
            this.digitalValue.alignV = 3;
            this.digitalPin = new TextBox("D" + this.digitalInputString, this.DotX, this.DotY - this.DotWidth);
            this.digitalPin.textColor = OpenBCI_GUI.this.color(OpenBCI_GUI.this.bgColor);
            this.digitalPin.alignH = 3;
            this.drawDigitalValue = true;
        }

        public void update() {
            this.digitalInputVal = this.digitalInputPin == 11 ? (OpenBCI_GUI.this.hub.validAccelValues[0] & 0xFF00) >> 8 : (this.digitalInputPin == 12 ? OpenBCI_GUI.this.hub.validAccelValues[0] & 0xFF : (this.digitalInputPin == 13 ? (OpenBCI_GUI.this.hub.validAccelValues[1] & 0xFF00) >> 8 : (this.digitalInputPin == 17 ? OpenBCI_GUI.this.hub.validAccelValues[1] & 0xFF : OpenBCI_GUI.this.hub.validAccelValues[2])));
            this.digitalValue.string = String.format("%d", this.digitalInputVal);
        }

        public void draw() {
            OpenBCI_GUI.this.pushStyle();
            if (this.digitalInputVal == 1) {
                OpenBCI_GUI.this.fill(this.dot1Fill);
                this.digitalValue.textColor = this.val1Fill;
            } else {
                OpenBCI_GUI.this.fill(this.dot0Fill);
                this.digitalValue.textColor = this.val0Fill;
            }
            OpenBCI_GUI.this.stroke(this.dotStroke);
            OpenBCI_GUI.this.ellipse(this.DotX, this.DotY, this.DotWidth, this.DotHeight);
            if (this.drawDigitalValue) {
                this.digitalValue.draw();
                this.digitalPin.draw();
            }
            OpenBCI_GUI.this.popStyle();
        }

        public void screenResized(int _x, int _y, int _w, int _h) {
            this.DotX = _x;
            this.DotY = _y;
            this.DotWidth = _w;
            this.DotHeight = _h;
            this.DotCorner = OpenBCI_GUI.sqrt((float)2.0f) * (float)this.DotWidth / 2.0f / 2.0f;
            this.digitalPin.x = this.DotX;
            this.digitalPin.y = this.DotY - PApplet.parseInt((float)((float)this.DotWidth / 2.0f));
            this.digitalValue.x = this.DotX;
            this.digitalValue.y = this.DotY;
        }
    }

    class FilterConstants {
        public double[] a;
        public double[] b;
        public String name;
        public String short_name;

        FilterConstants(double[] b_given, double[] a_given, String name_given, String short_name_given) {
            this.b = new double[b_given.length];
            this.a = new double[b_given.length];
            int i = 0;
            while (i < this.b.length) {
                this.b[i] = b_given[i];
                ++i;
            }
            i = 0;
            while (i < this.a.length) {
                this.a[i] = a_given[i];
                ++i;
            }
            this.name = name_given;
            this.short_name = short_name_given;
        }
    }

    public static enum FocusColors {
        GREEN,
        CYAN,
        ORANGE;

    }

    public class FocusSlider
    extends BasicSlider {
        private float val;
        final float valMin = 0.0f;
        final float valMax = 0.9f;

        FocusSlider(float _x, float _yBot, float _yTop, float _val) {
            super(_x, _yBot, _yTop);
            this.val = 0.0f;
            this.valMin = 0.0f;
            this.valMax = 0.9f;
            this.val = OpenBCI_GUI.constrain((float)_val, (float)0.0f, (float)0.9f);
            this.y = OpenBCI_GUI.map((float)this.val, (float)0.0f, (float)1.0f, (float)this.yBot, (float)this.yTop);
        }

        @Override
        public void update() {
            if (this.isPressed) {
                float newVal = OpenBCI_GUI.map((float)OpenBCI_GUI.this.mouseY, (float)this.yBot, (float)this.yTop, (float)0.0f, (float)1.0f);
                this.val = OpenBCI_GUI.constrain((float)newVal, (float)0.0f, (float)0.9f);
                this.y = OpenBCI_GUI.map((float)this.val, (float)0.0f, (float)1.0f, (float)this.yBot, (float)this.yTop);
                OpenBCI_GUI.println((float)this.val);
            }
        }

        @Override
        public void screenResized(float _x, float _yBot, float _yTop) {
            this.x = _x;
            this.yBot = _yBot;
            this.yTop = _yTop;
            this.y = OpenBCI_GUI.map((float)this.val, (float)0.0f, (float)1.0f, (float)this.yBot, (float)this.yTop);
        }

        @Override
        public float getVal() {
            return this.val;
        }

        @Override
        public void setVal(float _val) {
            this.val = OpenBCI_GUI.constrain((float)_val, (float)0.0f, (float)0.9f);
            this.y = OpenBCI_GUI.map((float)this.val, (float)0.0f, (float)1.0f, (float)this.yBot, (float)this.yTop);
        }
    }

    public class FocusSlider_Static
    extends BasicSlider {
        private float val;
        final float valMin = 0.5f;
        final float valMax = 5.0f;

        FocusSlider_Static(float _x, float _yBot, float _yTop) {
            super(_x, _yBot, _yTop);
            this.val = 0.0f;
            this.valMin = 0.5f;
            this.valMax = 5.0f;
            this.val = 1.0f;
            this.y = this.yTop;
        }

        @Override
        public void update() {
            if (this.isPressed) {
                float diff = OpenBCI_GUI.map((float)OpenBCI_GUI.this.mouseY, (float)this.yBot, (float)this.yTop, (float)-0.07f, (float)0.0f);
                this.val = OpenBCI_GUI.constrain((float)(this.val + diff), (float)0.5f, (float)5.0f);
                OpenBCI_GUI.println((float)this.val);
            }
        }

        @Override
        public void screenResized(float _x, float _yBot, float _yTop) {
            this.x = _x;
            this.yBot = _yBot;
            this.y = this.yTop = _yTop;
        }

        @Override
        public float getVal() {
            return this.val;
        }

        @Override
        public void setVal(float _val) {
            this.val = OpenBCI_GUI.constrain((float)_val, (float)0.5f, (float)5.0f);
        }
    }

    class Ganglion {
        static final String TCP_CMD_ACCEL = "a";
        static final String TCP_CMD_CONNECT = "c";
        static final String TCP_CMD_COMMAND = "k";
        static final String TCP_CMD_DISCONNECT = "d";
        static final String TCP_CMD_DATA = "t";
        static final String TCP_CMD_ERROR = "e";
        static final String TCP_CMD_IMPEDANCE = "i";
        static final String TCP_CMD_LOG = "l";
        static final String TCP_CMD_SCAN = "s";
        static final String TCP_CMD_STATUS = "q";
        static final String TCP_STOP = ",;\n";
        static final String TCP_ACTION_START = "start";
        static final String TCP_ACTION_STATUS = "status";
        static final String TCP_ACTION_STOP = "stop";
        static final String GANGLION_BOOTLOADER_MODE = ">";
        static final int NUM_ACCEL_DIMS = 3;
        static final int RESP_ERROR_UNKNOWN = 499;
        static final int RESP_ERROR_BAD_PACKET = 500;
        static final int RESP_ERROR_BAD_NOBLE_START = 501;
        static final int RESP_ERROR_ALREADY_CONNECTED = 408;
        static final int RESP_ERROR_COMMAND_NOT_RECOGNIZED = 406;
        static final int RESP_ERROR_DEVICE_NOT_FOUND = 405;
        static final int RESP_ERROR_NO_OPEN_BLE_DEVICE = 400;
        static final int RESP_ERROR_UNABLE_TO_CONNECT = 402;
        static final int RESP_ERROR_UNABLE_TO_DISCONNECT = 401;
        static final int RESP_ERROR_SCAN_ALREADY_SCANNING = 409;
        static final int RESP_ERROR_SCAN_NONE_FOUND = 407;
        static final int RESP_ERROR_SCAN_NO_SCAN_TO_STOP = 410;
        static final int RESP_ERROR_SCAN_COULD_NOT_START = 412;
        static final int RESP_ERROR_SCAN_COULD_NOT_STOP = 411;
        static final int RESP_GANGLION_FOUND = 201;
        static final int RESP_SUCCESS = 200;
        static final int RESP_SUCCESS_DATA_ACCEL = 202;
        static final int RESP_SUCCESS_DATA_IMPEDANCE = 203;
        static final int RESP_SUCCESS_DATA_SAMPLE = 204;
        static final int RESP_STATUS_CONNECTED = 300;
        static final int RESP_STATUS_DISCONNECTED = 301;
        static final int RESP_STATUS_SCANNING = 302;
        static final int RESP_STATUS_NOT_SCANNING = 303;
        private int nEEGValuesPerPacket = 4;
        private int nAuxValuesPerPacket = 3;
        private final float fsHzBLE = 200.0f;
        private final float fsHzWifi = 1600.0f;
        private final int NfftBLE = 256;
        private final int NfftWifi = 2048;
        private final float MCP3912_Vref = 1.2f;
        private float MCP3912_gain = 1.0f;
        private float scale_fac_uVolts_per_count = 1200000.0f / (8388607.0f * this.MCP3912_gain * 1.5f * 51.0f);
        private float scale_fac_accel_G_per_count_ble = 0.016f;
        private float scale_fac_accel_G_per_count_wifi = 0.001f;
        private int curInterface = -1;
        private DataPacket_ADS1299 dataPacket;
        private boolean connected = false;
        public int numberOfDevices = 0;
        public int maxNumberOfDevices = 10;
        private boolean checkingImpedance = false;
        private boolean accelModeActive = false;
        public boolean impedanceUpdated = false;
        public int[] impedanceArray = new int[5];
        private int sampleRate = 1600;
        private PApplet mainApplet;

        public float getSampleRate() {
            if (this.isBLE()) {
                return 200.0f;
            }
            return OpenBCI_GUI.this.hub.getSampleRate();
        }

        public int getNfft() {
            if (this.isWifi()) {
                if (OpenBCI_GUI.this.hub.getSampleRate() == 200) {
                    return 256;
                }
                return 2048;
            }
            return 256;
        }

        public float get_scale_fac_uVolts_per_count() {
            return this.scale_fac_uVolts_per_count;
        }

        public float get_scale_fac_accel_G_per_count() {
            if (this.isWifi()) {
                return this.scale_fac_accel_G_per_count_wifi;
            }
            return this.scale_fac_accel_G_per_count_ble;
        }

        public boolean isCheckingImpedance() {
            return this.checkingImpedance;
        }

        public boolean isAccelModeActive() {
            return this.accelModeActive;
        }

        public void overrideCheckingImpedance(boolean val) {
            this.checkingImpedance = val;
        }

        public int getInterface() {
            return this.curInterface;
        }

        public boolean isBLE() {
            return this.curInterface == 1 || this.curInterface == 3;
        }

        public boolean isWifi() {
            return this.curInterface == 2;
        }

        public boolean isPortOpen() {
            return OpenBCI_GUI.this.hub.isPortOpen();
        }

        Ganglion() {
        }

        Ganglion(PApplet applet) {
            this.mainApplet = applet;
            this.initDataPackets(this.nEEGValuesPerPacket, this.nAuxValuesPerPacket);
        }

        public void initDataPackets(int _nEEGValuesPerPacket, int _nAuxValuesPerPacket) {
            this.nEEGValuesPerPacket = _nEEGValuesPerPacket;
            this.nAuxValuesPerPacket = _nAuxValuesPerPacket;
            this.dataPacket = new DataPacket_ADS1299(this.nEEGValuesPerPacket, this.nAuxValuesPerPacket);
            int i = 0;
            while (i < this.nEEGValuesPerPacket) {
                this.dataPacket.values[i] = 0;
                ++i;
            }
            i = 0;
            while (i < this.nAuxValuesPerPacket) {
                this.dataPacket.auxValues[i] = 0;
                ++i;
            }
        }

        private void handleError(int code, String msg) {
            OpenBCI_GUI.this.output("Code " + code + "Error: " + msg);
            OpenBCI_GUI.println((String)("Code " + code + "Error: " + msg));
        }

        public void processImpedance(String msg) {
            int channel;
            String[] list = OpenBCI_GUI.split((String)msg, (char)',');
            if (Integer.parseInt(list[1]) == 203 && (channel = Integer.parseInt(list[2])) < 5) {
                int value;
                this.impedanceArray[channel] = value = Integer.parseInt(list[3]);
                if (channel == 0) {
                    this.impedanceUpdated = true;
                    OpenBCI_GUI.println((String)("Impedance for channel reference is " + value + " ohms."));
                } else {
                    OpenBCI_GUI.println((String)("Impedance for channel " + channel + " is " + value + " ohms."));
                }
            }
        }

        public void setSampleRate(int _sampleRate) {
            this.sampleRate = _sampleRate;
            OpenBCI_GUI.this.hub.setSampleRate(this.sampleRate);
            OpenBCI_GUI.this.output("Setting sample rate for Ganglion to " + this.sampleRate + "Hz");
        }

        public void setInterface(int _interface) {
            this.curInterface = _interface;
            if (this.isBLE()) {
                this.setSampleRate(200);
                if (_interface == 1) {
                    OpenBCI_GUI.this.hub.setProtocol(OpenBCI_GUI.PROTOCOL_BLE);
                } else {
                    OpenBCI_GUI.this.hub.setProtocol("bled112");
                }
            } else if (this.isWifi()) {
                this.setSampleRate(1600);
                OpenBCI_GUI.this.hub.setProtocol(OpenBCI_GUI.PROTOCOL_WIFI);
                OpenBCI_GUI.this.hub.searchDeviceStart();
            }
        }

        public int copyDataPacketTo(DataPacket_ADS1299 target) {
            return this.dataPacket.copyTo(target);
        }

        public int closePort() {
            if (this.isBLE()) {
                OpenBCI_GUI.this.hub.disconnectBLE();
            } else if (this.isWifi()) {
                OpenBCI_GUI.this.hub.disconnectWifi();
            }
            return 0;
        }

        public void startDataTransfer() {
            OpenBCI_GUI.this.hub.changeState(3);
            OpenBCI_GUI.println((String)"Ganglion: startDataTransfer(): sending 'b");
            if (this.checkingImpedance) {
                this.impedanceStop();
                OpenBCI_GUI.this.delay(100);
                OpenBCI_GUI.this.hub.sendCommand('b');
            } else {
                OpenBCI_GUI.this.hub.sendCommand('b');
            }
        }

        public void stopDataTransfer() {
            OpenBCI_GUI.this.hub.changeState(4);
            OpenBCI_GUI.println((String)"Ganglion: stopDataTransfer(): sending 's");
            OpenBCI_GUI.this.hub.sendCommand('s');
        }

        private void printGanglion(String msg) {
            OpenBCI_GUI.print((String)"Ganglion: ");
            OpenBCI_GUI.println((String)msg);
        }

        public void changeChannelState(int Ichan, boolean activate) {
            if (this.isPortOpen() && Ichan >= 0) {
                if (activate) {
                    OpenBCI_GUI.println((String)("Ganglion: changeChannelState(): activate: sending " + OpenBCI_GUI.this.command_activate_channel[Ichan]));
                    OpenBCI_GUI.this.hub.sendCommand(OpenBCI_GUI.this.command_activate_channel[Ichan]);
                    OpenBCI_GUI.this.w_timeSeries.hsc.powerUpChannel(Ichan);
                } else {
                    OpenBCI_GUI.println((String)("Ganglion: changeChannelState(): deactivate: sending " + OpenBCI_GUI.this.command_deactivate_channel[Ichan]));
                    OpenBCI_GUI.this.hub.sendCommand(OpenBCI_GUI.this.command_deactivate_channel[Ichan]);
                    OpenBCI_GUI.this.w_timeSeries.hsc.powerDownChannel(Ichan);
                }
            }
        }

        public void accelStart() {
            OpenBCI_GUI.println((String)"Ganglion: accell: START");
            OpenBCI_GUI.this.hub.write("a,start,;\n");
            this.accelModeActive = true;
        }

        public void accelStop() {
            OpenBCI_GUI.println((String)"Ganglion: accel: STOP");
            OpenBCI_GUI.this.hub.write("a,stop,;\n");
            this.accelModeActive = false;
        }

        public void impedanceStart() {
            OpenBCI_GUI.println((String)"Ganglion: impedance: START");
            OpenBCI_GUI.this.hub.write("i,start,;\n");
            this.checkingImpedance = true;
        }

        public void impedanceStop() {
            OpenBCI_GUI.println((String)"Ganglion: impedance: STOP");
            OpenBCI_GUI.this.hub.write("i,stop,;\n");
            this.checkingImpedance = false;
        }

        public void enterBootloaderMode() {
            OpenBCI_GUI.println((String)"Ganglion: Entering Bootloader Mode");
            OpenBCI_GUI.this.hub.sendCommand(GANGLION_BOOTLOADER_MODE.charAt(0));
            OpenBCI_GUI.this.delay(500);
            this.closePort();
            OpenBCI_GUI.this.haltSystem();
            OpenBCI_GUI.this.initSystemButton.setString("START SYSTEM");
            OpenBCI_GUI.this.controlPanel.open();
            OpenBCI_GUI.this.output("Ganglion now in bootloader mode! Enjoy!");
        }
    }

    class GraphDataPoint {
        public double x;
        public double y;
        public String x_units;
        public String y_units;

        GraphDataPoint() {
        }
    }

    class HardwareSettingsController {
        boolean isVisible = false;
        int x;
        int y;
        int w;
        int h;
        int spaceBetweenButtons = 5;
        Button[][] channelSettingButtons;
        char[] previousSRB2;
        char[] previousBIAS;
        char[] maxValuesPerSetting;
        int channelToWrite;
        int impChannelToWrite;
        boolean rewriteChannelWhenDoneWriting;
        int channelToWriteWhenDoneWriting;
        boolean rewriteImpedanceWhenDoneWriting;
        int impChannelToWriteWhenDoneWriting;
        char final_pORn;
        char final_onORoff;

        HardwareSettingsController(int _x, int _y, int _w, int _h, int _channelBarHeight) {
            this.channelSettingButtons = new Button[OpenBCI_GUI.this.nchan][OpenBCI_GUI.this.numSettingsPerChannel];
            this.previousSRB2 = new char[OpenBCI_GUI.this.nchan];
            this.previousBIAS = new char[OpenBCI_GUI.this.nchan];
            this.maxValuesPerSetting = new char[]{'1', '6', '7', '1', '1', '1'};
            this.channelToWrite = -1;
            this.impChannelToWrite = -1;
            this.rewriteChannelWhenDoneWriting = false;
            this.channelToWriteWhenDoneWriting = 0;
            this.rewriteImpedanceWhenDoneWriting = false;
            this.impChannelToWriteWhenDoneWriting = 0;
            this.final_pORn = (char)48;
            this.final_onORoff = (char)48;
            this.x = _x;
            this.y = _y;
            this.w = _w;
            this.h = _h;
            this.createChannelSettingButtons(_channelBarHeight);
        }

        public void update() {
            int i = 0;
            while (i < OpenBCI_GUI.this.nchan) {
                int j = 0;
                while (j < OpenBCI_GUI.this.numSettingsPerChannel) {
                    switch (j) {
                        case 0: {
                            if (OpenBCI_GUI.this.channelSettingValues[i][j] == '0') {
                                OpenBCI_GUI.this.w_timeSeries.channelBars[i].onOffButton.setColorNotPressed(OpenBCI_GUI.this.channelColors[i % 8]);
                            }
                            if (OpenBCI_GUI.this.channelSettingValues[i][j] != '1') break;
                            OpenBCI_GUI.this.w_timeSeries.channelBars[i].onOffButton.setColorNotPressed(75);
                            break;
                        }
                        case 1: {
                            if (OpenBCI_GUI.this.channelSettingValues[i][j] == '0') {
                                this.channelSettingButtons[i][1].setString("x1");
                            }
                            if (OpenBCI_GUI.this.channelSettingValues[i][j] == '1') {
                                this.channelSettingButtons[i][1].setString("x2");
                            }
                            if (OpenBCI_GUI.this.channelSettingValues[i][j] == '2') {
                                this.channelSettingButtons[i][1].setString("x4");
                            }
                            if (OpenBCI_GUI.this.channelSettingValues[i][j] == '3') {
                                this.channelSettingButtons[i][1].setString("x6");
                            }
                            if (OpenBCI_GUI.this.channelSettingValues[i][j] == '4') {
                                this.channelSettingButtons[i][1].setString("x8");
                            }
                            if (OpenBCI_GUI.this.channelSettingValues[i][j] == '5') {
                                this.channelSettingButtons[i][1].setString("x12");
                            }
                            if (OpenBCI_GUI.this.channelSettingValues[i][j] != '6') break;
                            this.channelSettingButtons[i][1].setString("x24");
                            break;
                        }
                        case 2: {
                            if (OpenBCI_GUI.this.channelSettingValues[i][j] == '0') {
                                this.channelSettingButtons[i][2].setString("Normal");
                            }
                            if (OpenBCI_GUI.this.channelSettingValues[i][j] == '1') {
                                this.channelSettingButtons[i][2].setString("Shorted");
                            }
                            if (OpenBCI_GUI.this.channelSettingValues[i][j] == '2') {
                                this.channelSettingButtons[i][2].setString("BIAS_MEAS");
                            }
                            if (OpenBCI_GUI.this.channelSettingValues[i][j] == '3') {
                                this.channelSettingButtons[i][2].setString("MVDD");
                            }
                            if (OpenBCI_GUI.this.channelSettingValues[i][j] == '4') {
                                this.channelSettingButtons[i][2].setString("Temp.");
                            }
                            if (OpenBCI_GUI.this.channelSettingValues[i][j] == '5') {
                                this.channelSettingButtons[i][2].setString("Test");
                            }
                            if (OpenBCI_GUI.this.channelSettingValues[i][j] == '6') {
                                this.channelSettingButtons[i][2].setString("BIAS_DRP");
                            }
                            if (OpenBCI_GUI.this.channelSettingValues[i][j] != '7') break;
                            this.channelSettingButtons[i][2].setString("BIAS_DRN");
                            break;
                        }
                        case 3: {
                            if (OpenBCI_GUI.this.channelSettingValues[i][j] == '0') {
                                this.channelSettingButtons[i][3].setString("Don't Include");
                            }
                            if (OpenBCI_GUI.this.channelSettingValues[i][j] != '1') break;
                            this.channelSettingButtons[i][3].setString("Include");
                            break;
                        }
                        case 4: {
                            if (OpenBCI_GUI.this.channelSettingValues[i][j] == '0') {
                                this.channelSettingButtons[i][4].setString("Off");
                            }
                            if (OpenBCI_GUI.this.channelSettingValues[i][j] != '1') break;
                            this.channelSettingButtons[i][4].setString("On");
                            break;
                        }
                        case 5: {
                            if (OpenBCI_GUI.this.channelSettingValues[i][j] == '0') {
                                this.channelSettingButtons[i][5].setString("No");
                            }
                            if (OpenBCI_GUI.this.channelSettingValues[i][j] != '1') break;
                            this.channelSettingButtons[i][5].setString("Yes");
                        }
                    }
                    ++j;
                }
                ++i;
            }
            if (this.rewriteImpedanceWhenDoneWriting && !OpenBCI_GUI.this.cyton.get_isWritingImp()) {
                this.initImpWrite(this.impChannelToWriteWhenDoneWriting, this.final_pORn, this.final_onORoff);
                this.rewriteImpedanceWhenDoneWriting = false;
            }
        }

        public void draw() {
            OpenBCI_GUI.this.pushStyle();
            if (this.isVisible) {
                OpenBCI_GUI.this.noStroke();
                OpenBCI_GUI.this.fill(0.0f, 0.0f, 0.0f, 100.0f);
                OpenBCI_GUI.this.rect(this.x, this.y, this.w, this.h);
                int i = 0;
                while (i < OpenBCI_GUI.this.nchan) {
                    int j = 1;
                    while (j < 6) {
                        this.channelSettingButtons[i][j].draw();
                        ++j;
                    }
                    ++i;
                }
                OpenBCI_GUI.this.fill(OpenBCI_GUI.this.bgColor);
                OpenBCI_GUI.this.textFont(OpenBCI_GUI.this.p6, 10.0f);
                OpenBCI_GUI.this.textAlign(3, 101);
                OpenBCI_GUI.this.text("PGA Gain", this.x + this.w / 10 * 1, this.y - 1);
                OpenBCI_GUI.this.text("Input Type", this.x + this.w / 10 * 3, this.y - 1);
                OpenBCI_GUI.this.text("  Bias ", this.x + this.w / 10 * 5, this.y - 1);
                OpenBCI_GUI.this.text("SRB2", this.x + this.w / 10 * 7, this.y - 1);
                OpenBCI_GUI.this.text("SRB1", this.x + this.w / 10 * 9, this.y - 1);
                if (OpenBCI_GUI.this.eegDataSource != 0) {
                    OpenBCI_GUI.this.fill(0.0f, 0.0f, 0.0f, 200.0f);
                    OpenBCI_GUI.this.noStroke();
                    OpenBCI_GUI.this.rect(this.x - 2, this.y, this.w + 1, this.h);
                    OpenBCI_GUI.this.fill(255);
                    OpenBCI_GUI.this.textAlign(3, 3);
                    OpenBCI_GUI.this.textFont(OpenBCI_GUI.this.h1, 18.0f);
                    OpenBCI_GUI.this.text("DATA SOURCE (LIVE) only", this.x + this.w / 2, this.y + this.h / 2);
                }
            }
            OpenBCI_GUI.this.popStyle();
        }

        public void loadDefaultChannelSettings() {
            int i = 0;
            while (i < OpenBCI_GUI.this.nchan) {
                OpenBCI_GUI.this.channelSettingValues[i][0] = 48;
                OpenBCI_GUI.this.channelSettingValues[i][1] = 54;
                OpenBCI_GUI.this.channelSettingValues[i][2] = 48;
                OpenBCI_GUI.this.channelSettingValues[i][3] = 49;
                OpenBCI_GUI.this.channelSettingValues[i][4] = 49;
                OpenBCI_GUI.this.channelSettingValues[i][5] = 48;
                int k = 0;
                while (k < 2) {
                    OpenBCI_GUI.this.impedanceCheckValues[i][k] = 48;
                    ++k;
                }
                ++i;
            }
            this.update();
        }

        public void activateChannel(int Ichan) {
            OpenBCI_GUI.println((String)("OpenBCI_GUI: activating channel " + (Ichan + 1)));
            if (OpenBCI_GUI.this.eegDataSource == 0) {
                if (OpenBCI_GUI.this.cyton.isPortOpen()) {
                    OpenBCI_GUI.this.verbosePrint("**");
                    OpenBCI_GUI.this.cyton.changeChannelState(Ichan, true);
                }
            } else if (OpenBCI_GUI.this.eegDataSource == 1) {
                OpenBCI_GUI.this.ganglion.changeChannelState(Ichan, true);
            }
            if (Ichan < OpenBCI_GUI.this.nchan) {
                OpenBCI_GUI.this.channelSettingValues[Ichan][0] = 48;
                OpenBCI_GUI.this.w_timeSeries.hsc.update();
            }
        }

        public void deactivateChannel(int Ichan) {
            OpenBCI_GUI.println((String)("OpenBCI_GUI: deactivating channel " + (Ichan + 1)));
            if (OpenBCI_GUI.this.eegDataSource == 0) {
                if (OpenBCI_GUI.this.cyton.isPortOpen()) {
                    OpenBCI_GUI.this.verbosePrint("**");
                    OpenBCI_GUI.this.cyton.changeChannelState(Ichan, false);
                }
            } else if (OpenBCI_GUI.this.eegDataSource == 1) {
                OpenBCI_GUI.this.ganglion.changeChannelState(Ichan, false);
            }
            if (Ichan < OpenBCI_GUI.this.nchan) {
                OpenBCI_GUI.this.channelSettingValues[Ichan][0] = 49;
                OpenBCI_GUI.this.w_timeSeries.hsc.update();
            }
        }

        public boolean isChannelActive(int Ichan) {
            boolean return_val = false;
            return_val = OpenBCI_GUI.this.channelSettingValues[Ichan][0] != '1';
            return return_val;
        }

        public void powerDownChannel(int _numChannel) {
            OpenBCI_GUI.this.verbosePrint("Powering down channel " + OpenBCI_GUI.str((int)(PApplet.parseInt((float)_numChannel) + PApplet.parseInt((float)1.0f))));
            this.previousBIAS[_numChannel] = OpenBCI_GUI.this.channelSettingValues[_numChannel][3];
            this.previousSRB2[_numChannel] = OpenBCI_GUI.this.channelSettingValues[_numChannel][4];
            OpenBCI_GUI.this.channelSettingValues[_numChannel][3] = 48;
            OpenBCI_GUI.this.channelSettingValues[_numChannel][4] = 48;
            OpenBCI_GUI.this.channelSettingValues[_numChannel][0] = 49;
            OpenBCI_GUI.this.verbosePrint("Command: " + OpenBCI_GUI.this.command_deactivate_channel[_numChannel]);
            OpenBCI_GUI.this.cyton.deactivateChannel(_numChannel);
        }

        public void powerUpChannel(int _numChannel) {
            OpenBCI_GUI.this.verbosePrint("Powering up channel " + OpenBCI_GUI.str((int)(PApplet.parseInt((float)_numChannel) + PApplet.parseInt((float)1.0f))));
            OpenBCI_GUI.this.channelSettingValues[_numChannel][3] = this.previousBIAS[_numChannel];
            OpenBCI_GUI.this.channelSettingValues[_numChannel][4] = this.previousSRB2[_numChannel];
            OpenBCI_GUI.this.channelSettingValues[_numChannel][0] = 48;
            OpenBCI_GUI.this.verbosePrint("Command: " + OpenBCI_GUI.this.command_activate_channel[_numChannel]);
            OpenBCI_GUI.this.cyton.activateChannel(_numChannel);
        }

        public void initChannelWrite(int _numChannel) {
            if (!OpenBCI_GUI.this.cyton.get_isWritingImp()) {
                OpenBCI_GUI.this.verbosePrint("Writing channel settings for channel " + OpenBCI_GUI.str((int)(_numChannel + 1)) + " to OpenBCI!");
                OpenBCI_GUI.this.cyton.initChannelWrite(_numChannel);
                this.channelToWrite = _numChannel;
            }
        }

        public void initImpWrite(int _numChannel, char pORn, char onORoff) {
            OpenBCI_GUI.this.verbosePrint("Writing impedance check settings (" + pORn + "," + onORoff + ") for channel " + OpenBCI_GUI.str((int)(_numChannel + 1)) + " to OpenBCI!");
            if (pORn == 'p') {
                OpenBCI_GUI.this.impedanceCheckValues[_numChannel][0] = onORoff;
            }
            if (pORn == 'n') {
                OpenBCI_GUI.this.impedanceCheckValues[_numChannel][1] = onORoff;
            }
            OpenBCI_GUI.this.cyton.writeImpedanceSettings(_numChannel, OpenBCI_GUI.this.impedanceCheckValues);
        }

        public void createChannelSettingButtons(int _channelBarHeight) {
            OpenBCI_GUI.this.verbosePrint("ChannelController: createChannelSettingButtons: creating channel setting buttons...");
            int buttonW = 0;
            int buttonX = 0;
            int buttonH = 0;
            int buttonY = 0;
            String buttonString = "";
            int i = 0;
            while (i < OpenBCI_GUI.this.nchan) {
                int j = 1;
                while (j < 6) {
                    Button tempButton;
                    buttonW = PApplet.parseInt((float)((this.w - this.spaceBetweenButtons * 6) / 5));
                    buttonX = PApplet.parseInt((float)(this.x + this.spaceBetweenButtons * j + (j - 1) * buttonW));
                    buttonH = 18;
                    buttonY = PApplet.parseInt((float)(this.y + _channelBarHeight * i + (_channelBarHeight - buttonH) / 2));
                    buttonString = "N/A";
                    this.channelSettingButtons[i][j] = tempButton = new Button(buttonX, buttonY, buttonW, buttonH, buttonString, 14);
                    ++j;
                }
                ++i;
            }
        }

        public void mousePressed() {
            if (this.isVisible) {
                int i = 0;
                while (i < OpenBCI_GUI.this.nchan) {
                    int j = 1;
                    while (j < OpenBCI_GUI.this.numSettingsPerChannel) {
                        if (this.channelSettingButtons[i][j].isMouseHere()) {
                            this.channelSettingButtons[i][j].wasPressed = true;
                            this.channelSettingButtons[i][j].isActive = true;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }

        public void mouseReleased() {
            if (this.isVisible) {
                int i = 0;
                while (i < OpenBCI_GUI.this.nchan) {
                    int j = 1;
                    while (j < OpenBCI_GUI.this.numSettingsPerChannel) {
                        if (this.channelSettingButtons[i][j].isMouseHere() && this.channelSettingButtons[i][j].wasPressed) {
                            if (OpenBCI_GUI.this.channelSettingValues[i][j] < this.maxValuesPerSetting[j]) {
                                char[] cArray = OpenBCI_GUI.this.channelSettingValues[i];
                                int n = j;
                                cArray[n] = (char)(cArray[n] + '\u0001');
                            } else {
                                OpenBCI_GUI.this.channelSettingValues[i][j] = 48;
                            }
                            OpenBCI_GUI.this.cyton.writeChannelSettings(i, OpenBCI_GUI.this.channelSettingValues);
                        }
                        this.channelSettingButtons[i][j].isActive = false;
                        this.channelSettingButtons[i][j].wasPressed = false;
                        ++j;
                    }
                    ++i;
                }
            }
        }

        public void screenResized(int _x, int _y, int _w, int _h, int _channelBarHeight) {
            this.x = _x;
            this.y = _y;
            this.w = _w;
            this.h = _h;
            int buttonW = 0;
            int buttonX = 0;
            int buttonH = 0;
            int buttonY = 0;
            int i = 0;
            while (i < OpenBCI_GUI.this.nchan) {
                int j = 1;
                while (j < 6) {
                    buttonW = PApplet.parseInt((float)((this.w - this.spaceBetweenButtons * 6) / 5));
                    buttonX = PApplet.parseInt((float)(this.x + this.spaceBetweenButtons * j + (j - 1) * buttonW));
                    buttonH = 18;
                    buttonY = PApplet.parseInt((float)(this.y + _channelBarHeight * i + (_channelBarHeight - buttonH) / 2));
                    this.channelSettingButtons[i][j].but_x = buttonX;
                    this.channelSettingButtons[i][j].but_y = buttonY;
                    this.channelSettingButtons[i][j].but_dx = buttonW;
                    this.channelSettingButtons[i][j].but_dy = buttonH;
                    ++j;
                }
                ++i;
            }
        }

        public void toggleImpedanceCheck(int _channelNumber) {
            if (OpenBCI_GUI.this.channelSettingValues[_channelNumber][4] == '1') {
                if (OpenBCI_GUI.this.impedanceCheckValues[_channelNumber][1] < '1') {
                    this.initImpWrite(_channelNumber, 'n', '1');
                    OpenBCI_GUI.println((String)("Imp[" + _channelNumber + "] is on."));
                } else {
                    this.initImpWrite(_channelNumber, 'n', '0');
                    OpenBCI_GUI.println((String)("Imp[" + _channelNumber + "] is off."));
                }
            }
            if (OpenBCI_GUI.this.channelSettingValues[_channelNumber][4] == '0') {
                if (OpenBCI_GUI.this.impedanceCheckValues[_channelNumber][0] < '1') {
                    this.initImpWrite(_channelNumber, 'p', '1');
                } else {
                    this.initImpWrite(_channelNumber, 'p', '0');
                }
            }
        }
    }

    class HeadPlot {
        private float rel_posX;
        private float rel_posY;
        private float rel_width;
        private float rel_height;
        private int circ_x;
        private int circ_y;
        private int circ_diam;
        private int earL_x;
        private int earL_y;
        private int earR_x;
        private int earR_y;
        private int ear_width;
        private int ear_height;
        private int[] nose_x;
        private int[] nose_y;
        private float[][] electrode_xy;
        private float[] ref_electrode_xy;
        private float[][][] electrode_color_weightFac;
        private int[][] electrode_rgb;
        private float[][] headVoltage;
        private int elec_diam;
        PFont font;
        public float[] intensity_data_uV;
        public float[] polarity_data;
        private DataStatus[] is_railed;
        private float intense_min_uV = 0.0f;
        private float intense_max_uV = 1.0f;
        private float assumed_railed_voltage_uV = 1.0f;
        private float log10_intense_min_uV = 0.0f;
        private float log10_intense_max_uV = 1.0f;
        PImage headImage;
        private int image_x;
        private int image_y;
        public boolean drawHeadAsContours;
        private boolean plot_color_as_log = true;
        public float smooth_fac = 0.0f;
        private boolean use_polarity = true;
        private int mouse_over_elec_index = -1;
        private boolean isDragging = false;
        private float drag_x;
        private float drag_y;
        public int hp_win_x = 0;
        public int hp_win_y = 0;
        public int hp_x = 0;
        public int hp_y = 0;
        public int hp_w = 0;
        public int hp_h = 0;
        public boolean hardCalcsDone = false;
        public boolean threadLock = false;
        int count_call = 0;

        HeadPlot(float x, float y, float w, float h, int win_x, int win_y, int n) {
            int n_elec = n;
            this.nose_x = new int[3];
            this.nose_y = new int[3];
            this.electrode_xy = new float[n_elec][2];
            this.ref_electrode_xy = new float[2];
            this.electrode_rgb = new int[3][n_elec];
            this.font = OpenBCI_GUI.this.createFont("Arial", 16.0f);
            this.drawHeadAsContours = true;
            this.rel_posX = x;
            this.rel_posY = y;
            this.rel_width = w;
            this.rel_height = h;
            this.setWindowDimensions(win_x, win_y);
            this.setMaxIntensity_uV(200.0f);
        }

        HeadPlot(int _x, int _y, int _w, int _h, int _win_x, int _win_y) {
            int n_elec = OpenBCI_GUI.this.nchan;
            this.nose_x = new int[3];
            this.nose_y = new int[3];
            this.electrode_xy = new float[n_elec][2];
            this.ref_electrode_xy = new float[2];
            this.electrode_rgb = new int[3][n_elec];
            this.font = OpenBCI_GUI.this.p5;
            this.drawHeadAsContours = true;
            this.hp_x = _x;
            this.hp_y = _y;
            this.hp_w = _w;
            this.hp_h = _h;
            this.hp_win_x = _win_x;
            this.hp_win_y = _win_y;
            OpenBCI_GUI.this.thread("doHardCalcs");
            this.setMaxIntensity_uV(200.0f);
        }

        public void setPositionSize(int _x, int _y, int _w, int _h, int _win_x, int _win_y) {
            float percentMargin = 0.1f;
            _x += (int)(PApplet.parseFloat((int)_w) * percentMargin);
            _y = _y + (int)(PApplet.parseFloat((int)_h) * percentMargin) - OpenBCI_GUI.this.navHeight / 2;
            _w = (int)(PApplet.parseFloat((int)_w) - 2.0f * (PApplet.parseFloat((int)_w) * percentMargin));
            _h = (int)(PApplet.parseFloat((int)_h) - 2.0f * (PApplet.parseFloat((int)_h) * percentMargin));
            this.rel_posX = PApplet.parseFloat((int)_x) / (float)_win_x;
            this.rel_posY = PApplet.parseFloat((int)_y) / (float)_win_y;
            this.rel_width = PApplet.parseFloat((int)_w) / (float)_win_x;
            this.rel_height = PApplet.parseFloat((int)_h) / (float)_win_y;
            this.setWindowDimensions(_win_x, _win_y);
        }

        public void setIntensityData_byRef(float[] data, DataStatus[] is_rail) {
            this.intensity_data_uV = data;
            this.is_railed = is_rail;
        }

        public void setPolarityData_byRef(float[] data) {
            this.polarity_data = data;
        }

        public String getUsePolarityTrueFalse() {
            if (this.use_polarity) {
                return "True";
            }
            return "False";
        }

        public void setMaxIntensity_uV(float val_uV) {
            this.intense_max_uV = val_uV;
            this.intense_min_uV = this.intense_max_uV / 200.0f * 5.0f;
            this.assumed_railed_voltage_uV = this.intense_max_uV;
            this.log10_intense_max_uV = OpenBCI_GUI.this.log10(this.intense_max_uV);
            this.log10_intense_min_uV = OpenBCI_GUI.this.log10(this.intense_min_uV);
        }

        public void set_plotColorAsLog(boolean state) {
            this.plot_color_as_log = state;
        }

        public void setWindowDimensions(int win_width, int win_height) {
            float square_width;
            int n_elec = this.electrode_xy.length;
            float nose_relLen = 0.075f;
            float nose_relWidth = 0.05f;
            float nose_relGutter = 0.02f;
            float ear_relLen = 0.15f;
            float ear_relWidth = 0.075f;
            float total_width = square_width = OpenBCI_GUI.min((float)(this.rel_width * (float)win_width), (float)(this.rel_height * (float)win_height));
            float total_height = square_width;
            float nose_height = total_height * nose_relLen;
            this.ear_width = (int)(ear_relWidth * total_width);
            this.ear_height = (int)(ear_relLen * total_height);
            int circ_width_foo = (int)(total_width - 2.0f * (float)this.ear_width / 2.0f);
            int circ_height_foo = (int)(total_height - nose_height);
            this.circ_diam = OpenBCI_GUI.min((int)circ_width_foo, (int)circ_height_foo);
            this.circ_x = (int)((this.rel_posX + 0.5f * this.rel_width) * (float)win_width);
            this.circ_y = (int)((this.rel_posY + 0.5f * this.rel_height) * (float)win_height + nose_height);
            this.earL_x = this.circ_x - this.circ_diam / 2;
            this.earR_x = this.circ_x + this.circ_diam / 2;
            this.earL_y = this.circ_y;
            this.earR_y = this.circ_y;
            this.nose_x[0] = this.circ_x - (int)(nose_relWidth / 2.0f * (float)win_width);
            this.nose_x[1] = this.circ_x + (int)(nose_relWidth / 2.0f * (float)win_width);
            this.nose_x[2] = this.circ_x;
            this.nose_y[0] = this.circ_y - (int)((float)this.circ_diam / 2.0f - nose_relGutter * (float)win_height);
            this.nose_y[1] = this.nose_y[0];
            this.nose_y[2] = this.circ_y - (int)((float)this.circ_diam / 2.0f + nose_height);
            float elec_relDiam = 0.12f;
            this.elec_diam = (int)(elec_relDiam * (float)this.circ_diam);
            this.setElectrodeLocations(n_elec, elec_relDiam);
            this.image_x = PApplet.parseInt((float)OpenBCI_GUI.round((float)((float)this.circ_x - 0.5f * (float)this.circ_diam - 0.5f * (float)this.ear_width)));
            this.image_y = this.nose_y[2];
            this.headImage = OpenBCI_GUI.this.createImage(PApplet.parseInt((float)total_width), PApplet.parseInt((float)total_height), 2);
            int Iy = 0;
            while (Iy < this.headImage.height) {
                int Ix = 0;
                while (Ix < this.headImage.width) {
                    this.headImage.set(Ix, Iy, OpenBCI_GUI.this.color(0, 0, 0, 0));
                    ++Ix;
                }
                ++Iy;
            }
            int n_wide_full = PApplet.parseInt((float)total_width);
            int n_tall_full = PApplet.parseInt((float)total_height);
            this.computePixelWeightingFactors_multiScale(n_wide_full, n_tall_full);
        }

        private void setElectrodeLocations(int n_elec, float elec_relDiam) {
            int n_elec_to_load = n_elec + 1;
            Table elec_relXY = new Table();
            String default_fname = "electrode_positions_default.txt";
            try {
                elec_relXY = OpenBCI_GUI.this.loadTable(default_fname, "header,csv");
            }
            catch (NullPointerException nullPointerException) {}
            if (elec_relXY == null || elec_relXY.getRowCount() < n_elec_to_load) {
                OpenBCI_GUI.println((String)("headPlot: electrode position file not found or was wrong size: " + default_fname));
                OpenBCI_GUI.println((String)"        : using defaults...");
                elec_relXY = this.createDefaultElectrodeLocations(default_fname, elec_relDiam);
            }
            int i = 0;
            while (i < OpenBCI_GUI.min((int)this.electrode_xy.length, (int)elec_relXY.getRowCount())) {
                this.electrode_xy[i][0] = this.circ_x + (int)(elec_relXY.getFloat(i, 0) * (float)this.circ_diam);
                this.electrode_xy[i][1] = this.circ_y + (int)(elec_relXY.getFloat(i, 1) * (float)this.circ_diam);
                ++i;
            }
            this.ref_electrode_xy[0] = this.circ_x + (int)(elec_relXY.getFloat(elec_relXY.getRowCount() - 1, 0) * (float)this.circ_diam);
            this.ref_electrode_xy[1] = this.circ_y + (int)(elec_relXY.getFloat(elec_relXY.getRowCount() - 1, 1) * (float)this.circ_diam);
        }

        private Table createDefaultElectrodeLocations(String fname, float elec_relDiam) {
            float[][] elec_relXY = new float[16][2];
            elec_relXY[0][0] = -0.125f;
            elec_relXY[0][1] = -0.5f + elec_relDiam * 0.7f;
            elec_relXY[1][0] = -elec_relXY[0][0];
            elec_relXY[1][1] = elec_relXY[0][1];
            elec_relXY[2][0] = -0.2f;
            elec_relXY[2][1] = 0.0f;
            elec_relXY[3][0] = -elec_relXY[2][0];
            elec_relXY[3][1] = elec_relXY[2][1];
            elec_relXY[4][0] = -0.3425f;
            elec_relXY[4][1] = 0.27f;
            elec_relXY[5][0] = -elec_relXY[4][0];
            elec_relXY[5][1] = elec_relXY[4][1];
            elec_relXY[6][0] = -0.125f;
            elec_relXY[6][1] = 0.5f - elec_relDiam * 0.7f;
            elec_relXY[7][0] = -elec_relXY[6][0];
            elec_relXY[7][1] = elec_relXY[6][1];
            elec_relXY[8][0] = elec_relXY[4][0];
            elec_relXY[8][1] = -elec_relXY[4][1];
            elec_relXY[9][0] = -elec_relXY[8][0];
            elec_relXY[9][1] = elec_relXY[8][1];
            elec_relXY[10][0] = -0.18f;
            elec_relXY[10][1] = -0.15f;
            elec_relXY[11][0] = -elec_relXY[10][0];
            elec_relXY[11][1] = elec_relXY[10][1];
            elec_relXY[12][0] = -0.5f + elec_relDiam * 0.65f;
            elec_relXY[12][1] = 0.0f;
            elec_relXY[13][0] = -elec_relXY[12][0];
            elec_relXY[13][1] = elec_relXY[12][1];
            elec_relXY[14][0] = elec_relXY[10][0];
            elec_relXY[14][1] = -elec_relXY[10][1];
            elec_relXY[15][0] = -elec_relXY[14][0];
            elec_relXY[15][1] = elec_relXY[14][1];
            float[] ref_elec_relXY = new float[]{0.0f, 0.0f};
            Table table_elec_relXY = new Table();
            table_elec_relXY.addColumn("X", 3);
            table_elec_relXY.addColumn("Y", 3);
            int I = 0;
            while (I < elec_relXY.length) {
                table_elec_relXY.addRow();
                table_elec_relXY.setFloat(I, "X", elec_relXY[I][0]);
                table_elec_relXY.setFloat(I, "Y", elec_relXY[I][1]);
                ++I;
            }
            table_elec_relXY.addRow();
            table_elec_relXY.setFloat(table_elec_relXY.getRowCount() - 1, "X", ref_elec_relXY[0]);
            table_elec_relXY.setFloat(table_elec_relXY.getRowCount() - 1, "Y", ref_elec_relXY[1]);
            String full_fname = "Data\\" + fname;
            try {
                OpenBCI_GUI.this.saveTable(table_elec_relXY, full_fname, "csv");
            }
            catch (NullPointerException nullPointerException) {
                OpenBCI_GUI.println((String)("headPlot: createDefaultElectrodeLocations: could not write file to " + full_fname));
            }
            return table_elec_relXY;
        }

        private void computePixelWeightingFactors_multiScale(int n_wide_full, int n_tall_full) {
            int Iy;
            int n_elec = this.electrode_xy.length;
            int decimation = 10;
            int n_wide_small = n_wide_full / decimation + 1;
            int n_tall_small = n_tall_full / decimation + 1;
            float[][][] weightFac = new float[n_elec][n_wide_small][n_tall_small];
            int[][][] pixelAddress = new int[n_wide_small][n_tall_small][2];
            int Ix = 0;
            while (Ix < n_wide_small) {
                int Iy2 = 0;
                while (Iy2 < n_tall_small) {
                    pixelAddress[Ix][Iy2][0] = Ix * decimation;
                    pixelAddress[Ix][Iy2][1] = Iy2 * decimation;
                    ++Iy2;
                }
                ++Ix;
            }
            this.computePixelWeightingFactors_trueAverage(pixelAddress, weightFac);
            this.electrode_color_weightFac = new float[n_elec][n_wide_full][n_tall_full];
            this.headVoltage = new float[n_wide_full][n_tall_full];
            int Ix2 = 0;
            while (Ix2 < n_wide_full) {
                int Ix_source = Ix2 / decimation;
                float dx_frac = PApplet.parseFloat((int)(Ix2 - Ix_source * decimation)) / PApplet.parseFloat((int)decimation);
                Iy = 0;
                while (Iy < n_tall_full) {
                    int Iy_source = Iy / decimation;
                    float dy_frac = PApplet.parseFloat((int)(Iy - Iy_source * decimation)) / PApplet.parseFloat((int)decimation);
                    int Ielec = 0;
                    while (Ielec < n_elec) {
                        if (Ix_source < n_wide_small - 1 && Iy_source < n_tall_small - 1) {
                            this.electrode_color_weightFac[Ielec][Ix2][Iy] = this.interpolate2D(weightFac[Ielec], Ix_source, Iy_source, Ix_source + 1, Iy_source + 1, dx_frac, dy_frac);
                        } else if (Ix_source < n_wide_small - 1) {
                            dy_frac = 0.0f;
                            this.electrode_color_weightFac[Ielec][Ix2][Iy] = this.interpolate2D(weightFac[Ielec], Ix_source, Iy_source, Ix_source + 1, Iy_source, dx_frac, dy_frac);
                        } else if (Iy_source < n_tall_small - 1) {
                            dx_frac = 0.0f;
                            this.electrode_color_weightFac[Ielec][Ix2][Iy] = this.interpolate2D(weightFac[Ielec], Ix_source, Iy_source, Ix_source, Iy_source + 1, dx_frac, dy_frac);
                        } else {
                            this.electrode_color_weightFac[Ielec][Ix2][Iy] = weightFac[Ielec][Ix_source][Iy_source];
                        }
                        ++Ielec;
                    }
                    ++Iy;
                }
                ++Ix2;
            }
            int[][][] pixelAddress_full = new int[n_wide_full][n_tall_full][2];
            int Ix3 = 0;
            while (Ix3 < n_wide_full) {
                Iy = 0;
                while (Iy < n_tall_full) {
                    pixelAddress_full[Ix3][Iy][0] = Ix3;
                    pixelAddress_full[Ix3][Iy][1] = Iy;
                    ++Iy;
                }
                ++Ix3;
            }
            this.cleanUpTheBoundaries(pixelAddress_full, this.electrode_color_weightFac);
        }

        private float interpolate2D(float[][] weightFac, int Ix1, int Iy1, int Ix2, int Iy2, float dx_frac, float dy_frac) {
            if (Ix1 >= weightFac.length) {
                OpenBCI_GUI.println((String)("headPlot: interpolate2D: Ix1 = " + Ix1 + ", weightFac.length = " + weightFac.length));
            }
            float foo1 = (weightFac[Ix2][Iy1] - weightFac[Ix1][Iy1]) * dx_frac + weightFac[Ix1][Iy1];
            float foo2 = (weightFac[Ix2][Iy2] - weightFac[Ix1][Iy2]) * dx_frac + weightFac[Ix1][Iy2];
            return (foo2 - foo1) * dy_frac + foo1;
        }

        private void computePixelWeightingFactors() {
            int n_elec = this.electrode_xy.length;
            int withinElecInd = -1;
            float elec_radius = 0.5f * (float)this.elec_diam;
            float sum_weight_fac = 0.0f;
            float[] weight_fac = new float[n_elec];
            int Iy = 0;
            while (Iy < this.headImage.height) {
                int pixel_y = this.image_y + Iy;
                int Ix = 0;
                while (Ix < this.headImage.width) {
                    int Ielec;
                    int pixel_x = this.image_x + Ix;
                    if (!this.isPixelInsideHead(pixel_x, pixel_y)) {
                        Ielec = 0;
                        while (Ielec < n_elec) {
                            this.electrode_color_weightFac[Ielec][Ix][Iy] = -1.0f;
                            ++Ielec;
                        }
                    } else {
                        sum_weight_fac = 0.0f;
                        withinElecInd = -1;
                        Ielec = 0;
                        while (Ielec < n_elec) {
                            float dist = OpenBCI_GUI.max((float)1.0f, (float)this.calcDistance(pixel_x, pixel_y, this.electrode_xy[Ielec][0], this.electrode_xy[Ielec][1]));
                            if (dist < elec_radius) {
                                withinElecInd = Ielec;
                            }
                            float foo_dist = OpenBCI_GUI.max((float)1.0f, (float)OpenBCI_GUI.abs((float)(dist - elec_radius)));
                            weight_fac[Ielec] = 1.0f / foo_dist;
                            weight_fac[Ielec] = weight_fac[Ielec] * weight_fac[Ielec] * weight_fac[Ielec];
                            sum_weight_fac += weight_fac[Ielec];
                            ++Ielec;
                        }
                        Ielec = 0;
                        while (Ielec < n_elec) {
                            this.electrode_color_weightFac[Ielec][Ix][Iy] = withinElecInd > -1 ? (Ielec == withinElecInd ? 1.0f : 0.0f) : weight_fac[Ielec] / sum_weight_fac;
                            ++Ielec;
                        }
                    }
                    ++Ix;
                }
                ++Iy;
            }
        }

        public void computePixelWeightingFactors_trueAverage(int[][][] pixelAddress, float[][][] weightFac) {
            int n_wide = pixelAddress.length;
            int n_tall = pixelAddress[0].length;
            int n_elec = this.electrode_xy.length;
            int[][] withinElectrode = new int[n_wide][n_tall];
            boolean[][] withinHead = new boolean[n_wide][n_tall];
            int[][][][] toPixels = new int[n_wide][n_tall][4][2];
            int[][][] toElectrodes = new int[n_wide][n_tall][4];
            this.whereAreThePixels(pixelAddress, withinHead, withinElectrode);
            this.makeAllTheConnections(withinHead, withinElectrode, toPixels, toElectrodes);
            int Ielec = 0;
            while (Ielec < n_elec) {
                this.computeWeightFactorsGivenOneElectrode_iterative(toPixels, toElectrodes, Ielec, weightFac);
                ++Ielec;
            }
        }

        private void cleanUpTheBoundaries(int[][][] pixelAddress, float[][][] weightFac) {
            int n_wide = pixelAddress.length;
            int n_tall = pixelAddress[0].length;
            int n_elec = this.electrode_xy.length;
            int[][] withinElectrode = new int[n_wide][n_tall];
            boolean[][] withinHead = new boolean[n_wide][n_tall];
            this.whereAreThePixels(pixelAddress, withinHead, withinElectrode);
            int Ix = 0;
            while (Ix < n_wide) {
                int Iy = 0;
                while (Iy < n_tall) {
                    int Ielec;
                    if (!withinHead[Ix][Iy]) {
                        Ielec = 0;
                        while (Ielec < n_elec) {
                            weightFac[Ielec][Ix][Iy] = -1.0f;
                            ++Ielec;
                        }
                    } else {
                        Ielec = 0;
                        while (Ielec < n_elec) {
                            if (weightFac[Ielec][Ix][Iy] < 0.0f) {
                                weightFac[Ielec][Ix][Iy] = this.getClosestWeightFac(weightFac[Ielec], Ix, Iy);
                            }
                            ++Ielec;
                        }
                        if (withinElectrode[Ix][Iy] > -1) {
                            Ielec = 0;
                            while (Ielec < n_elec) {
                                weightFac[Ielec][Ix][Iy] = 0.0f;
                                if (Ielec == withinElectrode[Ix][Iy]) {
                                    weightFac[Ielec][Ix][Iy] = 1.0f;
                                }
                                ++Ielec;
                            }
                        }
                    }
                    ++Iy;
                }
                ++Ix;
            }
        }

        private float getClosestWeightFac(float[][] weightFac, int Ix, int Iy) {
            int n_wide = weightFac.length;
            int n_tall = weightFac[0].length;
            float sum = 0.0f;
            int n_sum = 0;
            float new_weightFac = -1.0f;
            int step = 1;
            boolean done = false;
            while (!done) {
                int Ix_test;
                boolean anyWithinBounds = false;
                sum = 0.0f;
                n_sum = 0;
                int Iy_test = Iy + step;
                if (Iy_test >= 0 && Iy_test < n_tall) {
                    Ix_test = Ix - step;
                    while (Ix_test <= Ix + step) {
                        if (Ix_test >= 0 && Ix_test < n_wide) {
                            anyWithinBounds = true;
                            if (weightFac[Ix_test][Iy_test] >= 0.0f) {
                                sum += weightFac[Ix_test][Iy_test];
                                ++n_sum;
                            }
                        }
                        ++Ix_test;
                    }
                }
                if ((Ix_test = Ix + step) >= 0 && Ix_test < n_wide) {
                    Iy_test = Iy - step;
                    while (Iy_test <= Iy + step) {
                        if (Iy_test >= 0 && Iy_test < n_tall) {
                            anyWithinBounds = true;
                            if (weightFac[Ix_test][Iy_test] >= 0.0f) {
                                sum += weightFac[Ix_test][Iy_test];
                                ++n_sum;
                            }
                        }
                        ++Iy_test;
                    }
                }
                if ((Iy_test = Iy - step) >= 0 && Iy_test < n_tall) {
                    Ix_test = Ix - step;
                    while (Ix_test <= Ix + step) {
                        if (Ix_test >= 0 && Ix_test < n_wide) {
                            anyWithinBounds = true;
                            if (weightFac[Ix_test][Iy_test] >= 0.0f) {
                                sum += weightFac[Ix_test][Iy_test];
                                ++n_sum;
                            }
                        }
                        ++Ix_test;
                    }
                }
                if ((Ix_test = Ix - step) >= 0 && Ix_test < n_wide) {
                    Iy_test = Iy - step;
                    while (Iy_test <= Iy + step) {
                        if (Iy_test >= 0 && Iy_test < n_tall) {
                            anyWithinBounds = true;
                            if (weightFac[Ix_test][Iy_test] >= 0.0f) {
                                sum += weightFac[Ix_test][Iy_test];
                                ++n_sum;
                            }
                        }
                        ++Iy_test;
                    }
                }
                if (n_sum > 0) {
                    new_weightFac = sum / (float)n_sum;
                    done = true;
                    continue;
                }
                ++step;
                done = !anyWithinBounds;
            }
            return new_weightFac;
        }

        private void computeWeightFactorsGivenOneElectrode_iterative(int[][][][] toPixels, int[][][] toElectrodes, int Ielec, float[][][] pixelVal) {
            int n_wide = toPixels.length;
            int n_tall = toPixels[0].length;
            int n_dir = toPixels[0][0].length;
            float[][] prevVal = new float[n_wide][n_tall];
            float min_val = 0.0f;
            float max_val = 0.0f;
            boolean anyConnections = false;
            int pixel_step = 1;
            int lim_iter_count = 2000;
            float dVal_threshold = 1.0E-5f;
            float change_fac = 0.2f;
            int iter_count = 0;
            float max_dVal = 10.0f * dVal_threshold;
            while (iter_count < lim_iter_count && max_dVal > dVal_threshold) {
                int Iy;
                ++iter_count;
                max_dVal = 0.0f;
                min_val = 1000.0f;
                max_val = -1000.0f;
                int Ix = 0;
                while (Ix < n_wide) {
                    Iy = 0;
                    while (Iy < n_tall) {
                        prevVal[Ix][Iy] = pixelVal[Ielec][Ix][Iy];
                        ++Iy;
                    }
                    ++Ix;
                }
                Ix = 0;
                while (Ix < n_wide) {
                    Iy = 0;
                    while (Iy < n_tall) {
                        float total = 0.0f;
                        anyConnections = false;
                        int Idir = 0;
                        while (Idir < n_dir) {
                            if (toPixels[Ix][Iy][Idir][0] > -1) {
                                int Ix_targ = toPixels[Ix][Iy][Idir][0];
                                int Iy_targ = toPixels[Ix][Iy][Idir][1];
                                total += prevVal[Ix_targ][Iy_targ] - prevVal[Ix][Iy];
                                anyConnections = true;
                            }
                            if (toElectrodes[Ix][Iy][Idir] > -1) {
                                total = toElectrodes[Ix][Iy][Idir] == Ielec ? (total += 1.0f - prevVal[Ix][Iy]) : (total += 0.0f - prevVal[Ix][Iy]);
                                anyConnections = true;
                            }
                            ++Idir;
                        }
                        if (anyConnections) {
                            float dVal = change_fac * total;
                            pixelVal[Ielec][Ix][Iy] = prevVal[Ix][Iy] + dVal;
                            max_dVal = OpenBCI_GUI.max((float)max_dVal, (float)OpenBCI_GUI.abs((float)dVal));
                            min_val = OpenBCI_GUI.min((float)min_val, (float)pixelVal[Ielec][Ix][Iy]);
                            max_val = OpenBCI_GUI.max((float)max_val, (float)pixelVal[Ielec][Ix][Iy]);
                        } else {
                            pixelVal[Ielec][Ix][Iy] = -1.0f;
                        }
                        Iy += pixel_step;
                    }
                    Ix += pixel_step;
                }
            }
            if (iter_count >= lim_iter_count) {
                OpenBCI_GUI.println((String)("headPlot: computeWeightFactor: Ielec " + Ielec + ", solution complete with " + iter_count + " iterations. max_dVal = " + max_dVal));
            }
        }

        private void makeAllTheConnections(boolean[][] withinHead, int[][] withinElectrode, int[][][][] toPixels, int[][][] toElectrodes) {
            int n_wide = toPixels.length;
            int n_tall = toPixels[0].length;
            int cfr_ignored_0 = this.electrode_xy.length;
            int Iy = 0;
            while (Iy < n_tall) {
                int Ix = 0;
                while (Ix < n_wide) {
                    int Idirection = 0;
                    while (Idirection < 4) {
                        int Ix_try = -1;
                        int Iy_try = -1;
                        switch (Idirection) {
                            case 0: {
                                Ix_try = Ix - 1;
                                Iy_try = Iy;
                                break;
                            }
                            case 1: {
                                Ix_try = Ix + 1;
                                Iy_try = Iy;
                                break;
                            }
                            case 2: {
                                Ix_try = Ix;
                                Iy_try = Iy - 1;
                                break;
                            }
                            case 3: {
                                Ix_try = Ix;
                                Iy_try = Iy + 1;
                            }
                        }
                        toPixels[Ix][Iy][Idirection][0] = -1;
                        toPixels[Ix][Iy][Idirection][1] = -1;
                        toElectrodes[Ix][Iy][Idirection] = -1;
                        if (Ix_try >= 0 && Ix_try < n_wide && Iy_try >= 0 && Iy_try < n_tall) {
                            if (withinElectrode[Ix_try][Iy_try] >= 0) {
                                toElectrodes[Ix][Iy][Idirection] = withinElectrode[Ix_try][Iy_try];
                            } else if (withinHead[Ix_try][Iy_try]) {
                                toPixels[Ix][Iy][Idirection][0] = Ix_try;
                                toPixels[Ix][Iy][Idirection][1] = Iy_try;
                            }
                        }
                        ++Idirection;
                    }
                    ++Ix;
                }
                ++Iy;
            }
        }

        private void whereAreThePixels(int[][][] pixelAddress, boolean[][] withinHead, int[][] withinElectrode) {
            float dist;
            int pixel_y;
            int pixel_x;
            int n_wide = pixelAddress.length;
            int n_tall = pixelAddress[0].length;
            int n_elec = this.electrode_xy.length;
            int withinElecInd = -1;
            float elec_radius = 0.5f * (float)this.elec_diam;
            int Iy = 0;
            while (Iy < n_tall) {
                int Ix = 0;
                while (Ix < n_wide) {
                    pixel_x = pixelAddress[Ix][Iy][0] + this.image_x;
                    pixel_y = pixelAddress[Ix][Iy][1] + this.image_y;
                    withinHead[Ix][Iy] = this.isPixelInsideHead(pixel_x, pixel_y);
                    withinElecInd = -1;
                    int Ielec = 0;
                    while (Ielec < n_elec) {
                        dist = OpenBCI_GUI.max((float)1.0f, (float)this.calcDistance(pixel_x, pixel_y, this.electrode_xy[Ielec][0], this.electrode_xy[Ielec][1]));
                        if (dist < elec_radius) {
                            withinElecInd = Ielec;
                        }
                        ++Ielec;
                    }
                    withinElectrode[Ix][Iy] = withinElecInd;
                    ++Ix;
                }
                ++Iy;
            }
            int Ielec = 0;
            while (Ielec < n_elec) {
                float min_dist = 1.0E10f;
                int best_Ix = 0;
                int best_Iy = 0;
                int Iy2 = 0;
                while (Iy2 < n_tall) {
                    int Ix = 0;
                    while (Ix < n_wide) {
                        pixel_x = pixelAddress[Ix][Iy2][0] + this.image_x;
                        pixel_y = pixelAddress[Ix][Iy2][1] + this.image_y;
                        dist = this.calcDistance(pixel_x, pixel_y, this.electrode_xy[Ielec][0], this.electrode_xy[Ielec][1]);
                        if (dist < min_dist) {
                            min_dist = dist;
                            best_Ix = Ix;
                            best_Iy = Iy2;
                        }
                        ++Ix;
                    }
                    ++Iy2;
                }
                withinElectrode[best_Ix][best_Iy] = Ielec++;
            }
        }

        private void updateHeadImage() {
            int Iy = 0;
            while (Iy < this.headImage.height) {
                int Ix = 0;
                while (Ix < this.headImage.width) {
                    if (this.electrode_color_weightFac[0][Ix][Iy] >= 0.0f) {
                        this.headImage.set(Ix, Iy, this.calcPixelColor(Ix, Iy));
                    } else {
                        this.headImage.set(Ix, Iy, OpenBCI_GUI.this.color(0, 0, 0, 0));
                    }
                    ++Ix;
                }
                ++Iy;
            }
        }

        private void convertVoltagesToHeadImage() {
            int Iy = 0;
            while (Iy < this.headImage.height) {
                int Ix = 0;
                while (Ix < this.headImage.width) {
                    if (this.electrode_color_weightFac[0][Ix][Iy] >= 0.0f) {
                        this.headImage.set(Ix, Iy, this.calcPixelColor(this.headVoltage[Ix][Iy]));
                    } else {
                        this.headImage.set(Ix, Iy, OpenBCI_GUI.this.color(0, 0, 0, 0));
                    }
                    ++Ix;
                }
                ++Iy;
            }
        }

        private void updateHeadVoltages() {
            int Iy = 0;
            while (Iy < this.headImage.height) {
                int Ix = 0;
                while (Ix < this.headImage.width) {
                    this.headVoltage[Ix][Iy] = this.electrode_color_weightFac[0][Ix][Iy] >= 0.0f ? this.calcPixelVoltage(Ix, Iy, this.headVoltage[Ix][Iy]) : -1.0f;
                    ++Ix;
                }
                ++Iy;
            }
        }

        private float calcPixelVoltage(int pixel_Ix, int pixel_Iy, float prev_val) {
            int n_elec = this.electrode_xy.length;
            float voltage = 0.0f;
            float low = this.intense_min_uV;
            float high = this.intense_max_uV;
            int Ielec = 0;
            while (Ielec < n_elec) {
                float weight = this.electrode_color_weightFac[Ielec][pixel_Ix][pixel_Iy];
                float elec_volt = OpenBCI_GUI.max((float)low, (float)OpenBCI_GUI.min((float)this.intensity_data_uV[Ielec], (float)high));
                if (this.use_polarity) {
                    elec_volt *= this.polarity_data[Ielec];
                }
                if (this.is_railed[Ielec].is_railed) {
                    elec_volt = this.assumed_railed_voltage_uV;
                }
                voltage += weight * elec_volt;
                ++Ielec;
            }
            if (this.smooth_fac > 0.0f) {
                voltage = this.smooth_fac * prev_val + (1.0f - this.smooth_fac) * voltage;
            }
            return voltage;
        }

        private int calcPixelColor(float pixel_volt_uV) {
            float[] new_rgb = new float[]{224.0f, 56.0f, 45.0f};
            if (pixel_volt_uV < 0.0f) {
                new_rgb[0] = 54.0f;
                new_rgb[1] = 87.0f;
                new_rgb[2] = 158.0f;
            }
            float intensity = OpenBCI_GUI.constrain((float)OpenBCI_GUI.abs((float)pixel_volt_uV), (float)this.intense_min_uV, (float)this.intense_max_uV);
            intensity = this.plot_color_as_log ? OpenBCI_GUI.map((float)OpenBCI_GUI.this.log10(intensity), (float)this.log10_intense_min_uV, (float)this.log10_intense_max_uV, (float)0.0f, (float)1.0f) : OpenBCI_GUI.map((float)intensity, (float)this.intense_min_uV, (float)this.intense_max_uV, (float)0.0f, (float)1.0f);
            int i = 0;
            while (i < 3) {
                float val = new_rgb[i] / 255.0f;
                new_rgb[i] = (val + (1.0f - val) * (1.0f - intensity)) * 255.0f;
                new_rgb[i] = OpenBCI_GUI.constrain((float)new_rgb[i], (float)0.0f, (float)255.0f);
                ++i;
            }
            this.quantizeColor(new_rgb);
            return OpenBCI_GUI.this.color(PApplet.parseInt((float)new_rgb[0]), PApplet.parseInt((float)new_rgb[1]), PApplet.parseInt((float)new_rgb[2]), 255);
        }

        private void quantizeColor(float[] new_rgb) {
            int n_colors = 12;
            int ticks_per_color = 256 / (n_colors + 1);
            int Irgb = 0;
            while (Irgb < 3) {
                new_rgb[Irgb] = OpenBCI_GUI.min((float)255.0f, (float)(PApplet.parseFloat((int)PApplet.parseInt((float)(new_rgb[Irgb] / (float)ticks_per_color))) * (float)ticks_per_color));
                ++Irgb;
            }
        }

        private int calcPixelColor(int pixel_Ix, int pixel_Iy) {
            float[] new_rgb = new float[]{0.0f, 0.0f, 0.0f};
            int Ielec = 0;
            while (Ielec < this.electrode_xy.length) {
                float weight = this.electrode_color_weightFac[Ielec][pixel_Ix][pixel_Iy];
                int Irgb = 0;
                while (Irgb < 3) {
                    int n = Irgb;
                    new_rgb[n] = new_rgb[n] + weight * (float)this.electrode_rgb[Irgb][Ielec];
                    ++Irgb;
                }
                ++Ielec;
            }
            this.quantizeColor(new_rgb);
            return OpenBCI_GUI.this.color(PApplet.parseInt((float)new_rgb[0]), PApplet.parseInt((float)new_rgb[1]), PApplet.parseInt((float)new_rgb[2]), 255);
        }

        private float calcDistance(int x, int y, float ref_x, float ref_y) {
            float dx = PApplet.parseFloat((int)x) - ref_x;
            float dy = PApplet.parseFloat((int)y) - ref_y;
            return OpenBCI_GUI.sqrt((float)(dx * dx + dy * dy));
        }

        private void updateElectrodeColors() {
            int[] nArray = new int[3];
            nArray[0] = 255;
            int[] rgb = nArray;
            int[] new_rgb = new int[3];
            float low = this.intense_min_uV;
            float high = this.intense_max_uV;
            float log_low = this.log10_intense_min_uV;
            float log_high = this.log10_intense_max_uV;
            int Ielec = 0;
            while (Ielec < this.electrode_xy.length) {
                float intensity = OpenBCI_GUI.constrain((float)this.intensity_data_uV[Ielec], (float)low, (float)high);
                intensity = this.plot_color_as_log ? OpenBCI_GUI.map((float)OpenBCI_GUI.this.log10(intensity), (float)log_low, (float)log_high, (float)0.0f, (float)1.0f) : OpenBCI_GUI.map((float)intensity, (float)low, (float)high, (float)0.0f, (float)1.0f);
                int i = 0;
                while (i < 3) {
                    float val = (float)rgb[i] / 255.0f;
                    new_rgb[i] = (int)((val + (1.0f - val) * (1.0f - intensity)) * 255.0f);
                    new_rgb[i] = OpenBCI_GUI.constrain((int)new_rgb[i], (int)0, (int)255);
                    ++i;
                }
                if (this.is_railed[Ielec].is_railed) {
                    int[] nArray2 = new int[3];
                    nArray2[0] = 127;
                    new_rgb = nArray2;
                }
                this.electrode_rgb[0][Ielec] = new_rgb[0];
                this.electrode_rgb[1][Ielec] = new_rgb[1];
                this.electrode_rgb[2][Ielec] = new_rgb[2];
                ++Ielec;
            }
        }

        private boolean isMouseOverElectrode(int n) {
            float elec_mouse_x_dist = this.electrode_xy[n][0] - (float)OpenBCI_GUI.this.mouseX;
            float elec_mouse_y_dist = this.electrode_xy[n][1] - (float)OpenBCI_GUI.this.mouseY;
            return elec_mouse_x_dist * elec_mouse_x_dist + elec_mouse_y_dist * elec_mouse_y_dist < (float)(this.elec_diam * this.elec_diam / 4);
        }

        private boolean isDraggedElecInsideHead() {
            int dx = OpenBCI_GUI.this.mouseX - this.circ_x;
            int dy = OpenBCI_GUI.this.mouseY - this.circ_y;
            return dx * dx + dy * dy < (this.circ_diam - this.elec_diam) * (this.circ_diam - this.elec_diam) / 4;
        }

        public void mousePressed() {
            if (this.mouse_over_elec_index > -1) {
                this.isDragging = true;
                this.drag_x = (float)OpenBCI_GUI.this.mouseX - this.electrode_xy[this.mouse_over_elec_index][0];
                this.drag_y = (float)OpenBCI_GUI.this.mouseY - this.electrode_xy[this.mouse_over_elec_index][1];
            } else {
                this.isDragging = false;
            }
        }

        public void mouseDragged() {
            if (this.isDragging && this.mouse_over_elec_index > -1 && this.isDraggedElecInsideHead()) {
                this.electrode_xy[this.mouse_over_elec_index][0] = (float)OpenBCI_GUI.this.mouseX - this.drag_x;
                this.electrode_xy[this.mouse_over_elec_index][1] = (float)OpenBCI_GUI.this.mouseY - this.drag_y;
            }
        }

        public void mouseReleased() {
            this.isDragging = false;
        }

        public boolean isPixelInsideHead(int pixel_x, int pixel_y) {
            int dx = pixel_x - this.circ_x;
            int dy = pixel_y - this.circ_y;
            float r = OpenBCI_GUI.sqrt((float)(PApplet.parseFloat((int)(dx * dx)) + PApplet.parseFloat((int)(dy * dy))));
            return r <= 0.5f * (float)this.circ_diam;
        }

        public void update() {
            this.updateElectrodeColors();
            if (!this.threadLock && this.hardCalcsDone) {
                this.updateHeadVoltages();
                this.convertVoltagesToHeadImage();
            }
        }

        public void draw() {
            OpenBCI_GUI.this.pushStyle();
            OpenBCI_GUI.this.smooth();
            OpenBCI_GUI.this.fill(255.0f, 255.0f, 255.0f);
            OpenBCI_GUI.this.stroke(125.0f, 125.0f, 125.0f);
            OpenBCI_GUI.this.triangle(this.nose_x[0], this.nose_y[0], this.nose_x[1], this.nose_y[1], this.nose_x[2], this.nose_y[2]);
            OpenBCI_GUI.this.ellipse(this.earL_x, this.earL_y, this.ear_width, this.ear_height);
            OpenBCI_GUI.this.ellipse(this.earR_x, this.earR_y, this.ear_width, this.ear_height);
            OpenBCI_GUI.this.fill(255.0f, 255.0f, 255.0f, 255.0f);
            OpenBCI_GUI.this.strokeWeight(1.0f);
            OpenBCI_GUI.this.ellipse(this.circ_x, this.circ_y, this.circ_diam, this.circ_diam);
            if (this.drawHeadAsContours) {
                OpenBCI_GUI.this.image(this.headImage, this.image_x, this.image_y);
                OpenBCI_GUI.this.noFill();
                OpenBCI_GUI.this.strokeWeight(1.0f);
                OpenBCI_GUI.this.ellipse(this.circ_x, this.circ_y, this.circ_diam, this.circ_diam);
            }
            if (!this.isDragging) {
                this.mouse_over_elec_index = -1;
            }
            int Ielec = 0;
            while (Ielec < this.electrode_xy.length) {
                if (this.drawHeadAsContours) {
                    OpenBCI_GUI.this.noFill();
                } else {
                    OpenBCI_GUI.this.fill(this.electrode_rgb[0][Ielec], this.electrode_rgb[1][Ielec], this.electrode_rgb[2][Ielec]);
                }
                if (!this.isDragging && this.isMouseOverElectrode(Ielec)) {
                    this.mouse_over_elec_index = Ielec;
                    OpenBCI_GUI.this.strokeWeight(2.0f);
                } else if (this.mouse_over_elec_index == Ielec) {
                    OpenBCI_GUI.this.strokeWeight(2.0f);
                } else {
                    OpenBCI_GUI.this.strokeWeight(1.0f);
                }
                OpenBCI_GUI.this.ellipse(this.electrode_xy[Ielec][0], this.electrode_xy[Ielec][1], this.elec_diam, this.elec_diam);
                ++Ielec;
            }
            OpenBCI_GUI.this.fill(0.0f, 0.0f, 0.0f);
            OpenBCI_GUI.this.textFont(this.font);
            OpenBCI_GUI.this.textAlign(3, 3);
            int i = 0;
            while (i < this.electrode_xy.length) {
                OpenBCI_GUI.this.text(i + 1, this.electrode_xy[i][0], this.electrode_xy[i][1]);
                ++i;
            }
            OpenBCI_GUI.this.text("R", this.ref_electrode_xy[0], this.ref_electrode_xy[1]);
            OpenBCI_GUI.this.popStyle();
        }
    }

    class HelpWidget {
        public float x;
        public float y;
        public float w;
        public float h;
        String currentOutput = "Learn how to use this application and more at docs.openbci.com/OpenBCI%20Software/01-OpenBCI_GUI";
        int padding = 5;
        int outputStart = 0;
        int outputDurationMs = 3000;
        boolean animatingMessage = false;
        int curOutputLevel = 0;

        HelpWidget(float _xPos, float _yPos, float _width, float _height) {
            this.x = _xPos;
            this.y = _yPos;
            this.w = _width;
            this.h = _height;
        }

        public void update() {
            if (this.animatingMessage && OpenBCI_GUI.this.millis() > this.outputStart + this.outputDurationMs) {
                this.animatingMessage = false;
                this.curOutputLevel = 0;
            }
        }

        public void draw() {
            OpenBCI_GUI.this.pushStyle();
            if (OpenBCI_GUI.this.colorScheme == OpenBCI_GUI.this.COLOR_SCHEME_DEFAULT) {
                OpenBCI_GUI.this.stroke(OpenBCI_GUI.this.bgColor);
                OpenBCI_GUI.this.fill(255);
                OpenBCI_GUI.this.rect(-1.0f, (float)OpenBCI_GUI.this.height - this.h, OpenBCI_GUI.this.width + 2, this.h);
                OpenBCI_GUI.this.noStroke();
                OpenBCI_GUI.this.strokeWeight(1.0f);
                OpenBCI_GUI.this.stroke(OpenBCI_GUI.this.color(0, 5, 11));
                OpenBCI_GUI.this.fill(OpenBCI_GUI.this.color(0, 5, 11));
                OpenBCI_GUI.this.rect(this.x + (float)this.padding, (float)OpenBCI_GUI.this.height - this.h + (float)this.padding, OpenBCI_GUI.this.width - this.padding * 2, this.h - (float)(this.padding * 2));
                OpenBCI_GUI.this.textFont(OpenBCI_GUI.this.p4);
                OpenBCI_GUI.this.textSize(14.0f);
                OpenBCI_GUI.this.fill(255);
                OpenBCI_GUI.this.textAlign(37, 101);
                OpenBCI_GUI.this.text(this.currentOutput, this.padding * 2, (float)OpenBCI_GUI.this.height - this.h + (float)this.padding);
            } else if (OpenBCI_GUI.this.colorScheme == OpenBCI_GUI.this.COLOR_SCHEME_ALTERNATIVE_A) {
                OpenBCI_GUI.this.stroke(OpenBCI_GUI.this.bgColor);
                OpenBCI_GUI.this.fill(31.0f, 69.0f, 110.0f);
                OpenBCI_GUI.this.rect(-1.0f, (float)OpenBCI_GUI.this.height - this.h, OpenBCI_GUI.this.width + 2, this.h);
                OpenBCI_GUI.this.noStroke();
                OpenBCI_GUI.this.strokeWeight(1.0f);
                OpenBCI_GUI.this.stroke(this.getBackgroundColor());
                OpenBCI_GUI.this.fill(this.getBackgroundColor());
                OpenBCI_GUI.this.rect(this.x + (float)this.padding, (float)OpenBCI_GUI.this.height - this.h + (float)this.padding, OpenBCI_GUI.this.width - this.padding * 2, this.h - (float)(this.padding * 2));
                OpenBCI_GUI.this.textFont(OpenBCI_GUI.this.p4);
                OpenBCI_GUI.this.textSize(14.0f);
                OpenBCI_GUI.this.fill(this.getTextColor());
                OpenBCI_GUI.this.textAlign(37, 101);
                OpenBCI_GUI.this.text(this.currentOutput, this.padding * 2, (float)OpenBCI_GUI.this.height - this.h + (float)this.padding);
            }
            OpenBCI_GUI.this.popStyle();
        }

        private int getTextColor() {
            switch (this.curOutputLevel) {
                case 1: {
                    return -16756069;
                }
                case 2: {
                    return -11564528;
                }
                case 3: {
                    return -6332416;
                }
                case 4: {
                    return -2621428;
                }
            }
            return OpenBCI_GUI.this.color(0, 5, 11);
        }

        private int getBackgroundColor() {
            switch (this.curOutputLevel) {
                case 1: {
                    return -4332040;
                }
                case 2: {
                    return -2100545;
                }
                case 3: {
                    return -69709;
                }
                case 4: {
                    return -11566;
                }
            }
            return OpenBCI_GUI.this.color(255);
        }

        public void output(String _output, int level) {
            if (level == 0) {
                this.animatingMessage = false;
            } else {
                this.animatingMessage = true;
                this.outputStart = OpenBCI_GUI.this.millis();
            }
            this.curOutputLevel = level;
            this.currentOutput = _output;
        }
    }

    class Hub {
        public int curLatency = 10000;
        public String[] deviceList = new String[0];
        public boolean deviceListUpdated = false;
        private int bleErrorCounter = 0;
        private int prevSampleIndex = 0;
        private int requestedSampleRate = 0;
        private boolean setSampleRate = false;
        private int state = 0;
        int prevState_millis = 0;
        private int nEEGValuesPerPacket = 8;
        private int nAuxValuesPerPacket = 3;
        private int tcpHubPort = 10996;
        private String tcpHubIP = "127.0.0.1";
        private String tcpHubFull = String.valueOf(this.tcpHubIP) + ":" + this.tcpHubPort;
        private boolean tcpClientActive = false;
        private int tcpTimeout = 1000;
        private String firmwareVersion = "";
        private DataPacket_ADS1299 dataPacket;
        public Client tcpClient;
        private boolean portIsOpen = false;
        private boolean connected = false;
        public int numberOfDevices = 0;
        public int maxNumberOfDevices = 10;
        private boolean hubRunning = false;
        public char[] tcpBuffer = new char[4096];
        public int tcpBufferPositon = 0;
        private String curProtocol = "wifi";
        private String curInternetProtocol = "tcp";
        private String curWiFiStyle = "dynamic";
        private boolean waitingForResponse = false;
        private boolean nodeProcessHandshakeComplete = false;
        private boolean searching = false;
        public boolean shouldStartNodeApp = false;
        private boolean checkingImpedance = false;
        private boolean connectForWifiConfig = false;
        private boolean accelModeActive = false;
        private boolean newAccelData = false;
        public int[] accelArray = new int[3];
        public int[] validAccelValues = new int[3];
        public int validLastMarker;
        public boolean validNewAccelData = false;
        public boolean impedanceUpdated = false;
        public int[] impedanceArray = new int[5];
        private String curBLEHardware = "noble";
        private PApplet mainApplet;

        public int get_state() {
            return this.state;
        }

        public int getLatency() {
            return this.curLatency;
        }

        public String getCurBLEHardware() {
            return this.curBLEHardware;
        }

        public String getWifiInternetProtocol() {
            return this.curInternetProtocol;
        }

        public String getWiFiStyle() {
            return this.curWiFiStyle;
        }

        public boolean isPortOpen() {
            return this.portIsOpen;
        }

        public boolean isHubRunning() {
            return this.hubRunning;
        }

        public boolean isSearching() {
            return this.searching;
        }

        public boolean isCheckingImpedance() {
            return this.checkingImpedance;
        }

        public boolean isAccelModeActive() {
            return this.accelModeActive;
        }

        public void setLatency(int latency) {
            this.curLatency = latency;
            OpenBCI_GUI.this.output("Setting Latency to " + latency);
            OpenBCI_GUI.println((String)("Setting Latency to " + latency));
        }

        public void setCurBLEHardware(String bleHardware) {
            this.curBLEHardware = bleHardware;
            OpenBCI_GUI.this.output("Setting BLE Hardware to " + bleHardware);
            OpenBCI_GUI.println((String)("Setting BLE Hardware to " + bleHardware));
        }

        public void setWifiInternetProtocol(String internetProtocol) {
            this.curInternetProtocol = internetProtocol;
            OpenBCI_GUI.this.output("Setting WiFi Internet Protocol to " + internetProtocol);
            OpenBCI_GUI.println((String)("Setting WiFi Internet Protocol to " + internetProtocol));
        }

        public void setWiFiStyle(String wifiStyle) {
            this.curWiFiStyle = wifiStyle;
            OpenBCI_GUI.this.output("Setting WiFi style to " + wifiStyle);
            OpenBCI_GUI.println((String)("Setting WiFi style to " + wifiStyle));
        }

        Hub() {
        }

        Hub(PApplet applet) {
            this.mainApplet = applet;
            this.startTCPClient(this.mainApplet);
        }

        public void initDataPackets(int _nEEGValuesPerPacket, int _nAuxValuesPerPacket) {
            this.nEEGValuesPerPacket = _nEEGValuesPerPacket;
            this.nAuxValuesPerPacket = _nAuxValuesPerPacket;
            this.dataPacket = new DataPacket_ADS1299(this.nEEGValuesPerPacket, this.nAuxValuesPerPacket);
            int i = 0;
            while (i < this.nEEGValuesPerPacket) {
                this.dataPacket.values[i] = 0;
                ++i;
            }
            i = 0;
            while (i < this.nAuxValuesPerPacket) {
                this.dataPacket.auxValues[i] = 0;
                ++i;
            }
        }

        public boolean startTCPClient(PApplet applet) {
            try {
                this.tcpClient = new Client(applet, this.tcpHubIP, this.tcpHubPort);
                return true;
            }
            catch (Exception e) {
                OpenBCI_GUI.println((String)("startTCPClient: ConnectException: " + e));
                return false;
            }
        }

        public boolean getStatus() {
            try {
                this.write("q,;\n");
                this.waitingForResponse = true;
                return true;
            }
            catch (NullPointerException nullPointerException) {
                return false;
            }
        }

        public void setHubIsRunning(boolean isRunning) {
            this.hubRunning = isRunning;
        }

        public void parseMessage(String msg) {
            String[] list = OpenBCI_GUI.split((String)msg, (char)',');
            switch (list[0].charAt(0)) {
                case 'b': {
                    this.processBoardType(msg);
                    break;
                }
                case 'c': {
                    this.processConnect(msg);
                    break;
                }
                case 'a': {
                    this.processAccel(msg);
                    break;
                }
                case 'd': {
                    this.processDisconnect(msg);
                    break;
                }
                case 'i': {
                    this.processImpedance(msg);
                    break;
                }
                case 't': {
                    this.processData(msg);
                    break;
                }
                case 'e': {
                    int code = PApplet.parseInt((String)list[1]);
                    OpenBCI_GUI.println((String)("Hub: parseMessage: error: " + list[2]));
                    if (code != 434) break;
                    OpenBCI_GUI.this.output("Hub in data folder outdated. Download a new hub for your OS at https://github.com/OpenBCI/OpenBCI_Ganglion_Electron/releases/latest");
                    break;
                }
                case 'x': {
                    this.processExamine(msg);
                    break;
                }
                case 's': {
                    this.processScan(msg);
                    break;
                }
                case 'l': {
                    OpenBCI_GUI.println((String)("Hub: Log: " + list[1]));
                    break;
                }
                case 'p': {
                    this.processProtocol(msg);
                    break;
                }
                case 'q': {
                    this.processStatus(msg);
                    break;
                }
                case 'r': {
                    this.processRegisterQuery(msg);
                    break;
                }
                case 'm': {
                    this.processSDCard(msg);
                    break;
                }
                case 'w': {
                    this.processWifi(msg);
                    break;
                }
                case 'k': {
                    this.processCommand(msg);
                    break;
                }
                default: {
                    OpenBCI_GUI.println((String)("Hub: parseMessage: default: " + msg));
                    OpenBCI_GUI.this.output("Hub in data folder outdated. Download a new hub for your OS at https://github.com/OpenBCI/OpenBCI_Ganglion_Electron/releases/latest");
                }
            }
        }

        private void handleError(int code, String msg) {
            OpenBCI_GUI.this.output("Code " + code + " Error: " + msg);
            OpenBCI_GUI.println((String)("Code " + code + " Error: " + msg));
        }

        public void setBoardType(String boardType) {
            OpenBCI_GUI.println((String)("Hub: setBoardType(): sending '" + boardType + " -- " + OpenBCI_GUI.this.millis()));
            this.write("b," + boardType + OpenBCI_GUI.TCP_STOP);
        }

        private void processBoardType(String msg) {
            String[] list = OpenBCI_GUI.split((String)msg, (char)',');
            int code = Integer.parseInt(list[1]);
            switch (code) {
                case 200: {
                    if (OpenBCI_GUI.this.sdSetting > 0) {
                        OpenBCI_GUI.println((String)("Hub: processBoardType: success, starting SD card now -- " + OpenBCI_GUI.this.millis()));
                        this.sdCardStart(OpenBCI_GUI.this.sdSetting);
                        break;
                    }
                    OpenBCI_GUI.println((String)("Hub: processBoardType: success -- " + OpenBCI_GUI.this.millis()));
                    this.initAndShowGUI();
                    break;
                }
                default: {
                    this.killAndShowMsg(list[2]);
                }
            }
        }

        private void processConnect(String msg) {
            String[] list = OpenBCI_GUI.split((String)msg, (char)',');
            int code = Integer.parseInt(list[1]);
            OpenBCI_GUI.println((String)("Hub: processConnect: made it -- " + OpenBCI_GUI.this.millis() + " code: " + code));
            switch (code) {
                case 200: 
                case 408: {
                    this.firmwareVersion = list[2];
                    this.changeState(2);
                    if (OpenBCI_GUI.this.eegDataSource == 0) {
                        if (OpenBCI_GUI.this.nchan == 8) {
                            this.setBoardType("cyton");
                            break;
                        }
                        this.setBoardType("daisy");
                        break;
                    }
                    OpenBCI_GUI.println((String)("Hub: parseMessage: connect: success! -- " + OpenBCI_GUI.this.millis()));
                    this.initAndShowGUI();
                    break;
                }
                case 402: {
                    OpenBCI_GUI.println((String)"Error in processConnect: RESP_ERROR_UNABLE_TO_CONNECT");
                    if (list[2].equals("Error: Invalid sample rate")) {
                        if (OpenBCI_GUI.this.eegDataSource == 0) {
                            this.killAndShowMsg("WiFi Shield is connected to a Ganglion. Please select LIVE (from Ganglion) instead of LIVE (from Cyton)");
                            break;
                        }
                        this.killAndShowMsg("WiFi Shield is connected to a Cyton. Please select LIVE (from Cyton) instead LIVE (from Cyton)");
                        break;
                    }
                    this.killAndShowMsg(list[2]);
                    break;
                }
                case 435: {
                    OpenBCI_GUI.println((String)"Error in processConnect: RESP_ERROR_WIFI_NEEDS_UPDATE");
                    this.killAndShowMsg("WiFi Shield Firmware is out of date. Learn to update: docs.openbci.com/Hardware/12-Wifi_Programming_Tutorial");
                    break;
                }
                default: {
                    OpenBCI_GUI.println((String)"Error in processConnect");
                    this.handleError(code, list[2]);
                }
            }
        }

        private void processExamine(String msg) {
            String[] list = OpenBCI_GUI.split((String)msg, (char)',');
            int code = Integer.parseInt(list[1]);
            switch (code) {
                case 200: {
                    this.portIsOpen = true;
                    OpenBCI_GUI.this.output("Connected to WiFi Shield named " + OpenBCI_GUI.this.wifi_portName);
                    if (!OpenBCI_GUI.this.wcBox.isShowing) break;
                    OpenBCI_GUI.this.wcBox.updateMessage("Connected to WiFi Shield named " + OpenBCI_GUI.this.wifi_portName);
                    break;
                }
                case 408: {
                    this.portIsOpen = true;
                    OpenBCI_GUI.this.output("WiFi Shield is still connected to " + OpenBCI_GUI.this.wifi_portName);
                    break;
                }
                case 402: {
                    OpenBCI_GUI.this.output("No WiFi Shield found, visit docs.openbci.com/Tutorials/03-Wifi_Getting_Started_Guide to learn how to connect.");
                    break;
                }
                default: {
                    if (OpenBCI_GUI.this.wcBox.isShowing) {
                        OpenBCI_GUI.println((String)"it is showing");
                    }
                    this.handleError(code, list[2]);
                }
            }
        }

        private void initAndShowGUI() {
            this.changeState(3);
            OpenBCI_GUI.this.systemMode = 10;
            OpenBCI_GUI.this.controlPanel.close();
            OpenBCI_GUI.this.topNav.controlPanelCollapser.setIsActive(false);
            String firmwareString = " Cyton firmware ";
            firmwareString = OpenBCI_GUI.this.eegDataSource == 0 ? String.valueOf(firmwareString) + this.firmwareVersion : "";
            OpenBCI_GUI.this.outputSuccess("The GUI is done intializing." + firmwareString + " Press \"Start Data Stream\" to start streaming!");
            this.portIsOpen = true;
            OpenBCI_GUI.this.controlPanel.hideAllBoxes();
        }

        private void killAndShowMsg(String msg) {
            OpenBCI_GUI.this.abandonInit = true;
            OpenBCI_GUI.this.initSystemButton.setString("START SYSTEM");
            OpenBCI_GUI.this.controlPanel.open();
            OpenBCI_GUI.this.outputError(msg);
            this.portIsOpen = false;
            OpenBCI_GUI.this.haltSystem();
        }

        public void sendCommand(char c) {
            OpenBCI_GUI.println((String)("Hub: sendCommand(char): sending '" + c + "'"));
            this.write("k," + c + OpenBCI_GUI.TCP_STOP);
        }

        public void sendCommand(String s) {
            OpenBCI_GUI.println((String)("Hub: sendCommand(String): sending '" + s + "'"));
            this.write("k," + s + OpenBCI_GUI.TCP_STOP);
        }

        public void processCommand(String msg) {
            String[] list = OpenBCI_GUI.split((String)msg, (char)',');
            int code = Integer.parseInt(list[1]);
            switch (code) {
                case 200: {
                    OpenBCI_GUI.println((String)("Hub: processCommand: success -- " + OpenBCI_GUI.this.millis()));
                    break;
                }
                case 406: {
                    OpenBCI_GUI.println((String)("Hub: processCommand: ERROR_COMMAND_NOT_ABLE_TO_BE_SENT -- " + OpenBCI_GUI.this.millis() + " " + list[2]));
                    break;
                }
                case 420: {
                    OpenBCI_GUI.println((String)("Hub: processCommand: RESP_ERROR_PROTOCOL_NOT_STARTED -- " + OpenBCI_GUI.this.millis() + " " + list[2]));
                    break;
                }
            }
        }

        public void processAccel(String msg) {
            String[] list = OpenBCI_GUI.split((String)msg, (char)',');
            if (Integer.parseInt(list[1]) == 202) {
                int i = 0;
                while (i < 3) {
                    this.accelArray[i] = Integer.parseInt(list[i + 2]);
                    ++i;
                }
                this.newAccelData = true;
                if (this.accelArray[0] > 0 || this.accelArray[1] > 0 || this.accelArray[2] > 0) {
                    i = 0;
                    while (i < 3) {
                        this.validAccelValues[i] = this.accelArray[i];
                        ++i;
                    }
                }
            }
        }

        public void processData(String msg) {
            block21: {
                try {
                    String[] list = OpenBCI_GUI.split((String)msg, (char)',');
                    Integer.parseInt(list[1]);
                    int stopByte = 192;
                    if (OpenBCI_GUI.this.eegDataSource != 1 && OpenBCI_GUI.this.eegDataSource != 0 || OpenBCI_GUI.this.systemMode != 10 || !OpenBCI_GUI.this.isRunning) break block21;
                    if (Integer.parseInt(list[1]) == 204) {
                        this.dataPacket.sampleIndex = PApplet.parseInt((float)Integer.parseInt(list[2]));
                        if (this.dataPacket.sampleIndex - this.prevSampleIndex != 1 && this.dataPacket.sampleIndex != 0) {
                            ++this.bleErrorCounter;
                            OpenBCI_GUI.this.werePacketsDroppedHub = true;
                            OpenBCI_GUI.this.numPacketsDroppedHub = this.dataPacket.sampleIndex < this.prevSampleIndex ? this.dataPacket.sampleIndex + (this.curProtocol == OpenBCI_GUI.PROTOCOL_BLE ? 200 : 255) - this.prevSampleIndex : this.dataPacket.sampleIndex - this.prevSampleIndex;
                            OpenBCI_GUI.println((String)("Hub: apparent sampleIndex jump from Serial data: " + this.prevSampleIndex + " to  " + this.dataPacket.sampleIndex + ".  Keeping packet. (" + this.bleErrorCounter + ")"));
                            OpenBCI_GUI.println((String)("numPacketsDropped = " + OpenBCI_GUI.this.numPacketsDroppedHub));
                        }
                        this.prevSampleIndex = this.dataPacket.sampleIndex;
                        int i = 0;
                        while (i < this.nEEGValuesPerPacket) {
                            this.dataPacket.values[i] = Integer.parseInt(list[3 + i]);
                            ++i;
                        }
                        if (this.newAccelData) {
                            this.newAccelData = false;
                            i = 0;
                            while (i < 3) {
                                this.dataPacket.auxValues[i] = this.accelArray[i];
                                this.dataPacket.rawAuxValues[i][0] = PApplet.parseByte((int)this.accelArray[i]);
                                ++i;
                            }
                        } else if (list.length > this.nEEGValuesPerPacket + 5) {
                            int valCounter = this.nEEGValuesPerPacket + 3;
                            stopByte = Integer.parseInt(list[valCounter++]);
                            int valsToRead = list.length - valCounter - 1;
                            if (stopByte == 192) {
                                int i2 = 0;
                                while (i2 < 3) {
                                    this.accelArray[i2] = Integer.parseInt(list[valCounter++]);
                                    this.dataPacket.auxValues[i2] = this.accelArray[i2];
                                    this.dataPacket.rawAuxValues[i2][0] = PApplet.parseByte((int)this.accelArray[i2]);
                                    this.dataPacket.rawAuxValues[i2][1] = PApplet.parseByte((int)(this.accelArray[i2] >> 8));
                                    ++i2;
                                }
                                if (this.accelArray[0] > 0 || this.accelArray[1] > 0 || this.accelArray[2] > 0) {
                                    i2 = 0;
                                    while (i2 < 3) {
                                        this.validAccelValues[i2] = this.accelArray[i2];
                                        ++i2;
                                    }
                                }
                            } else if (valsToRead == 6) {
                                int i3 = 0;
                                while (i3 < 3) {
                                    int val1 = Integer.parseInt(list[valCounter++]);
                                    int val2 = Integer.parseInt(list[valCounter++]);
                                    this.dataPacket.auxValues[i3] = val1 << 8 | val2;
                                    this.validAccelValues[i3] = val1 << 8 | val2;
                                    this.dataPacket.rawAuxValues[i3][0] = PApplet.parseByte((int)val2);
                                    this.dataPacket.rawAuxValues[i3][1] = PApplet.parseByte((int)(val1 << 8));
                                    ++i3;
                                }
                            }
                        }
                        this.getRawValues(this.dataPacket);
                        OpenBCI_GUI.this.curDataPacketInd = (OpenBCI_GUI.this.curDataPacketInd + 1) % OpenBCI_GUI.this.dataPacketBuff.length;
                        this.copyDataPacketTo(OpenBCI_GUI.this.dataPacketBuff[OpenBCI_GUI.this.curDataPacketInd]);
                        switch (OpenBCI_GUI.this.outputDataSource) {
                            case 1: {
                                if (OpenBCI_GUI.this.eegDataSource == 1) {
                                    OpenBCI_GUI.this.fileoutput_odf.writeRawData_dataPacket(OpenBCI_GUI.this.dataPacketBuff[OpenBCI_GUI.this.curDataPacketInd], OpenBCI_GUI.this.ganglion.get_scale_fac_uVolts_per_count(), OpenBCI_GUI.this.ganglion.get_scale_fac_accel_G_per_count(), stopByte);
                                    break;
                                }
                                OpenBCI_GUI.this.fileoutput_odf.writeRawData_dataPacket(OpenBCI_GUI.this.dataPacketBuff[OpenBCI_GUI.this.curDataPacketInd], OpenBCI_GUI.this.cyton.get_scale_fac_uVolts_per_count(), OpenBCI_GUI.this.cyton.get_scale_fac_accel_G_per_count(), stopByte);
                                break;
                            }
                            case 2: {
                                OpenBCI_GUI.this.fileoutput_bdf.writeRawData_dataPacket(OpenBCI_GUI.this.dataPacketBuff[OpenBCI_GUI.this.curDataPacketInd]);
                                break;
                            }
                        }
                        ++OpenBCI_GUI.this.newPacketCounter;
                        break block21;
                    }
                    ++this.bleErrorCounter;
                    OpenBCI_GUI.println((String)"Hub: parseMessage: data: bad");
                }
                catch (Exception e) {
                    OpenBCI_GUI.print((String)"\n\n");
                    OpenBCI_GUI.println((String)msg);
                    OpenBCI_GUI.println((String)("Hub: parseMessage: error: " + e));
                    e.printStackTrace();
                }
            }
        }

        private void processDisconnect(String msg) {
            String[] list = OpenBCI_GUI.split((String)msg, (char)',');
            int code = Integer.parseInt(list[1]);
            switch (code) {
                case 200: {
                    if (!this.waitingForResponse) {
                        if (OpenBCI_GUI.this.eegDataSource == 0) {
                            this.killAndShowMsg("Dang! Lost connection to Cyton. Please move closer or get a new battery!");
                            break;
                        }
                        this.killAndShowMsg("Dang! Lost connection to Ganglion. Please move closer or get a new battery!");
                        break;
                    }
                    this.waitingForResponse = false;
                    break;
                }
            }
            this.portIsOpen = false;
        }

        private void processImpedance(String msg) {
            String[] list = OpenBCI_GUI.split((String)msg, (char)',');
            int code = Integer.parseInt(list[1]);
            switch (code) {
                case 414: {
                    OpenBCI_GUI.this.ganglion.overrideCheckingImpedance(false);
                }
                case 415: 
                case 430: 
                case 431: {
                    this.handleError(code, list[2]);
                    break;
                }
                case 203: {
                    OpenBCI_GUI.this.ganglion.processImpedance(msg);
                    break;
                }
                case 200: {
                    OpenBCI_GUI.this.output("Success: Impedance " + list[2] + ".");
                    break;
                }
                default: {
                    this.handleError(code, list[2]);
                }
            }
        }

        private void processProtocol(String msg) {
            String[] list = OpenBCI_GUI.split((String)msg, (char)',');
            int code = Integer.parseInt(list[1]);
            switch (code) {
                case 200: {
                    OpenBCI_GUI.this.output("Transfer Protocol set to " + list[2]);
                    OpenBCI_GUI.println((String)("Transfer Protocol set to " + list[2]));
                    if (OpenBCI_GUI.this.eegDataSource != 1 || !OpenBCI_GUI.this.ganglion.isBLE()) break;
                    OpenBCI_GUI.this.outputInfo("BLE was powered up sucessfully, now searching for BLE devices.");
                    break;
                }
                case 419: {
                    OpenBCI_GUI.this.outputError("Failed to start Ganglion BLE Driver, please see http://docs.openbci.com/Tutorials/02-Ganglion_Getting%20Started_Guide");
                    OpenBCI_GUI.println((String)"Failed to start Ganglion BLE Driver, please see http://docs.openbci.com/Tutorials/02-Ganglion_Getting%20Started_Guide");
                    break;
                }
                default: {
                    this.handleError(code, list[2]);
                }
            }
        }

        private void processStatus(String msg) {
            String[] list = OpenBCI_GUI.split((String)msg, (char)',');
            int code = Integer.parseInt(list[1]);
            if (this.waitingForResponse) {
                this.waitingForResponse = false;
                OpenBCI_GUI.println((String)"Node process up!");
            }
            if (code == 501) {
                OpenBCI_GUI.println((String)"Hub: processStatus: Problem in the Hub");
                OpenBCI_GUI.this.output("Problem starting Ganglion Hub. Please make sure compatible USB is configured, then restart this GUI.");
            } else {
                OpenBCI_GUI.println((String)"Hub: processStatus: Started Successfully");
            }
        }

        private void processRegisterQuery(String msg) {
            String[] list = OpenBCI_GUI.split((String)msg, (char)',');
            int code = Integer.parseInt(list[1]);
            switch (code) {
                case 423: {
                    this.killAndShowMsg("Failed to sync with Cyton, please power cycle your dongle and board.");
                    OpenBCI_GUI.println((String)("RESP_ERROR_CHANNEL_SETTINGS general error: " + list[2]));
                    break;
                }
                case 422: {
                    OpenBCI_GUI.println((String)"tried to sync channel settings but there was already one in progress");
                    break;
                }
                case 424: {
                    OpenBCI_GUI.println((String)("an error was thrown trying to set the channels | error: " + list[2]));
                    break;
                }
                case 425: {
                    OpenBCI_GUI.println((String)("an error was thrown trying to call the function to set the channels | error: " + list[2]));
                    break;
                }
                case 200: {
                    String action;
                    switch (action = list[2]) {
                        case "start": {
                            OpenBCI_GUI.println((String)"Query registers for cyton channel settings");
                        }
                    }
                    break;
                }
                case 207: {
                    int channelNumber = Integer.parseInt(list[2]);
                    OpenBCI_GUI.this.channelSettingValues[channelNumber][0] = list[3].equals("true") ? 49 : 48;
                    OpenBCI_GUI.this.channelSettingValues[channelNumber][1] = OpenBCI_GUI.this.cyton.getCommandForGain(Integer.parseInt(list[4]));
                    OpenBCI_GUI.this.channelSettingValues[channelNumber][2] = OpenBCI_GUI.this.cyton.getCommandForInputType(list[5]);
                    OpenBCI_GUI.this.channelSettingValues[channelNumber][3] = list[6].equals("true") ? 49 : 48;
                    OpenBCI_GUI.this.channelSettingValues[channelNumber][4] = list[7].equals("true") ? 49 : 48;
                    OpenBCI_GUI.this.channelSettingValues[channelNumber][5] = list[8].equals("true") ? 49 : 48;
                }
            }
        }

        private void processScan(String msg) {
            String[] list = OpenBCI_GUI.split((String)msg, (char)',');
            int code = Integer.parseInt(list[1]);
            switch (code) {
                case 201: 
                case 205: {
                    if (!this.searchDeviceAdd(list[2])) break;
                    this.deviceListUpdated = true;
                    break;
                }
                case 409: {
                    this.searching = true;
                    break;
                }
                case 200: {
                    String action;
                    switch (action = list[2]) {
                        case "start": {
                            this.searching = true;
                            break;
                        }
                        case "stop": {
                            this.searching = false;
                        }
                    }
                    break;
                }
                case 432: {
                    this.searching = false;
                    break;
                }
                case 412: {
                    this.handleError(code, list[2]);
                    this.searching = false;
                    break;
                }
                case 411: {
                    this.handleError(code, list[2]);
                    this.searching = false;
                    break;
                }
                case 302: {
                    this.searching = true;
                    break;
                }
                case 303: {
                    this.searching = false;
                    break;
                }
                case 410: {
                    this.searching = false;
                    break;
                }
                default: {
                    this.handleError(code, list[2]);
                }
            }
        }

        public void sdCardStart(int sdSetting) {
            String sdSettingStr = OpenBCI_GUI.this.cyton.getSDSettingForSetting(sdSetting);
            OpenBCI_GUI.println((String)("Hub: sdCardStart(): sending '" + sdSettingStr + "' with value " + sdSetting));
            this.write("m,start," + sdSettingStr + OpenBCI_GUI.TCP_STOP);
        }

        private void processSDCard(String msg) {
            String[] list = OpenBCI_GUI.split((String)msg, (char)',');
            int code = Integer.parseInt(list[1]);
            String action = list[2];
            switch (code) {
                case 200: {
                    switch (action) {
                        case "start": {
                            OpenBCI_GUI.println((String)"sd card setting set so now attempting to sync channel settings");
                            this.initAndShowGUI();
                            break;
                        }
                        case "stop": {
                            OpenBCI_GUI.println((String)list[3]);
                        }
                    }
                    break;
                }
                case 499: {
                    switch (action) {
                        case "start": {
                            this.killAndShowMsg(list[3]);
                            break;
                        }
                        case "stop": {
                            OpenBCI_GUI.println((String)list[3]);
                        }
                    }
                    break;
                }
                default: {
                    this.handleError(code, list[2]);
                }
            }
        }

        public void writeRawData_dataPacket_bdf() {
            OpenBCI_GUI.this.fileoutput_bdf.writeRawData_dataPacket(OpenBCI_GUI.this.dataPacketBuff[OpenBCI_GUI.this.curBDFDataPacketInd]);
        }

        public int copyDataPacketTo(DataPacket_ADS1299 target) {
            return this.dataPacket.copyTo(target);
        }

        private void getRawValues(DataPacket_ADS1299 packet) {
            int i = 0;
            while (i < OpenBCI_GUI.this.nchan) {
                int val = packet.values[i];
                byte[] rawValue = new byte[3];
                rawValue[2] = PApplet.parseByte((int)(val & 0xFF));
                rawValue[1] = PApplet.parseByte((int)((val & 0xFF00) >> 8));
                rawValue[0] = PApplet.parseByte((int)((val & 0xFF0000) >> 16));
                packet.rawValues[i] = rawValue;
                ++i;
            }
        }

        public boolean isSuccessCode(int c) {
            return c == 200;
        }

        public void updateSyncState(int sdSetting) {
            if (OpenBCI_GUI.this.millis() - this.prevState_millis > 3000 && this.prevState_millis != 0 && this.state == 1) {
                this.state = 2;
                OpenBCI_GUI.this.timeOfLastCommand = OpenBCI_GUI.this.millis();
                OpenBCI_GUI.println((String)"InterfaceHub: systemUpdate: [0] Sending 'v' to OpenBCI to reset hardware in case of 32bit board...");
            }
        }

        public void closePort() {
            switch (this.curProtocol) {
                case "ble": {
                    this.disconnectBLE();
                    break;
                }
                case "wifi": {
                    this.disconnectWifi();
                    break;
                }
                case "serial": {
                    this.disconnectSerial();
                    break;
                }
            }
            this.changeState(0);
        }

        public void connectBLE(String id) {
            this.write("c," + id + OpenBCI_GUI.TCP_STOP);
            OpenBCI_GUI.this.verbosePrint("OpenBCI_GUI: hub : Sent connect to Hub - Id: " + id);
        }

        public void disconnectBLE() {
            this.waitingForResponse = true;
            this.write("d,ble,,;\n");
        }

        public void connectWifi(String id) {
            this.write("c," + id + "," + this.requestedSampleRate + "," + this.curLatency + "," + this.curInternetProtocol + OpenBCI_GUI.TCP_STOP);
            OpenBCI_GUI.this.verbosePrint("OpenBCI_GUI: hub : Sent connect to Hub - Id: " + id + " SampleRate: " + this.requestedSampleRate + "Hz Latency: " + this.curLatency + "ms");
        }

        public void examineWifi(String id) {
            this.write("x," + id + OpenBCI_GUI.TCP_STOP);
        }

        public int disconnectWifi() {
            this.waitingForResponse = true;
            this.write("d,wifi,,;\n");
            return 0;
        }

        public void connectSerial(String id) {
            this.waitingForResponse = true;
            this.write("c," + id + OpenBCI_GUI.TCP_STOP);
            OpenBCI_GUI.this.verbosePrint("OpenBCI_GUI: hub : Sent connect to Hub - Id: " + id);
            OpenBCI_GUI.this.delay(1000);
        }

        public int disconnectSerial() {
            OpenBCI_GUI.println((String)"disconnecting serial");
            this.waitingForResponse = true;
            this.write("d,serial,,;\n");
            return 0;
        }

        public void setProtocol(String _protocol) {
            this.curProtocol = _protocol;
            this.write("p,start," + this.curProtocol + OpenBCI_GUI.TCP_STOP);
        }

        public int getSampleRate() {
            return this.requestedSampleRate;
        }

        public void setSampleRate(int _sampleRate) {
            this.requestedSampleRate = _sampleRate;
            this.setSampleRate = true;
            OpenBCI_GUI.println((String)("\n\nsample rate set to: " + _sampleRate));
        }

        public void getWifiInfo(String info) {
            this.write("w," + info + OpenBCI_GUI.TCP_STOP);
        }

        public void setWifiInfo(String info, int value) {
            this.write("w," + info + "," + value + OpenBCI_GUI.TCP_STOP);
        }

        /*
         * Enabled aggressive block sorting
         */
        private void processWifi(String msg) {
            String[] list = OpenBCI_GUI.split((String)msg, (char)',');
            int code = Integer.parseInt(list[1]);
            switch (code) {
                case 427: {
                    OpenBCI_GUI.println((String)"Sent an action to hub for wifi info but the command was unrecognized");
                    OpenBCI_GUI.this.output("Sent an action to hub for wifi info but the command was unrecognized");
                    return;
                }
                case 426: {
                    OpenBCI_GUI.println((String)"Tried to get wifi info but no WiFi Shield was connected.");
                    OpenBCI_GUI.this.output("Tried to get wifi info but no WiFi Shield was connected.");
                    return;
                }
                case 424: {
                    OpenBCI_GUI.println((String)("an error was thrown trying to set the channels | error: " + list[2]));
                    return;
                }
                case 425: {
                    OpenBCI_GUI.println((String)("an error was thrown trying to call the function to set the channels | error: " + list[2]));
                    return;
                }
                case 200: {
                    if (OpenBCI_GUI.this.wcBox.isShowing) {
                        String msgForWcBox = list[3];
                        switch (list[2]) {
                            case "getTypeOfAttachedBoard": {
                                switch (list[3]) {
                                    case "none": {
                                        msgForWcBox = "No OpenBCI Board attached to WiFi Shield";
                                        break;
                                    }
                                    case "ganglion": {
                                        msgForWcBox = "4-channel Ganglion attached to WiFi Shield";
                                        break;
                                    }
                                    case "cyton": {
                                        msgForWcBox = "8-channel Cyton attached to WiFi Shield";
                                        break;
                                    }
                                    case "daisy": {
                                        msgForWcBox = "16-channel Cyton with Daisy attached to WiFi Shield";
                                        break;
                                    }
                                }
                                break;
                            }
                            case "eraseCredentials": {
                                OpenBCI_GUI.this.output("WiFi credentials have been erased and WiFi Shield is in hotspot mode. If erase fails, remove WiFi Shield from OpenBCI Board.");
                                msgForWcBox = "";
                                OpenBCI_GUI.this.controlPanel.hideWifiPopoutBox();
                                OpenBCI_GUI.this.wifi_portName = "N/A";
                                this.clearDeviceList();
                                OpenBCI_GUI.this.controlPanel.wifiBox.refreshWifiList();
                                break;
                            }
                        }
                        OpenBCI_GUI.this.wcBox.updateMessage(msgForWcBox);
                    }
                    OpenBCI_GUI.println((String)("Success for wifi " + list[2] + ": " + list[3]));
                    return;
                }
            }
        }

        public boolean write(String out) {
            try {
                this.tcpClient.write(out);
                return true;
            }
            catch (Exception exception) {
                if (OpenBCI_GUI.this.isWindows()) {
                    this.killAndShowMsg("Please start OpenBCIHub before launching this application.");
                } else {
                    this.killAndShowMsg("Hub has crashed, please restart your application.");
                }
                OpenBCI_GUI.println((String)"Error: Attempted to TCP write with no server connection initialized");
                return false;
            }
        }

        public boolean write(char val) {
            return this.write(String.valueOf(val));
        }

        public int changeState(int newState) {
            this.state = newState;
            this.prevState_millis = OpenBCI_GUI.this.millis();
            return 0;
        }

        public void clearDeviceList() {
            this.deviceList = null;
            this.numberOfDevices = 0;
        }

        public void searchDeviceStart() {
            this.clearDeviceList();
            this.write("s,start,;\n");
        }

        public void searchDeviceStop() {
            this.write("s,stop,;\n");
        }

        public boolean searchDeviceAdd(String localName) {
            if (this.numberOfDevices == 0) {
                ++this.numberOfDevices;
                this.deviceList = new String[this.numberOfDevices];
                this.deviceList[0] = localName;
                return true;
            }
            boolean willAddToDeviceList = true;
            int i = 0;
            while (i < this.numberOfDevices) {
                if (localName.equals(this.deviceList[i])) {
                    willAddToDeviceList = false;
                    break;
                }
                ++i;
            }
            if (willAddToDeviceList) {
                ++this.numberOfDevices;
                String[] tempList = new String[this.numberOfDevices];
                OpenBCI_GUI.arrayCopy((Object)this.deviceList, (Object)tempList);
                tempList[this.numberOfDevices - 1] = localName;
                this.deviceList = tempList;
                return true;
            }
            return false;
        }
    }

    class InitBox {
        int x;
        int y;
        int w;
        int h;
        int padding;
        boolean initButtonPressed;
        boolean isSystemInitialized;

        InitBox(int _x, int _y, int _w, int _h, int _padding) {
            this.x = _x;
            this.y = _y;
            this.w = _w;
            this.h = 50;
            this.padding = _padding;
            OpenBCI_GUI.this.initSystemButton = new Button(this.padding, this.y + this.padding, this.w - this.padding * 2, this.h - this.padding * 2, "START SYSTEM", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
            this.initButtonPressed = false;
        }

        public void update() {
        }

        public void draw() {
            OpenBCI_GUI.this.pushStyle();
            OpenBCI_GUI.this.fill(OpenBCI_GUI.this.boxColor);
            OpenBCI_GUI.this.stroke(OpenBCI_GUI.this.boxStrokeColor);
            OpenBCI_GUI.this.strokeWeight(1.0f);
            OpenBCI_GUI.this.rect(this.x, this.y, this.w, this.h);
            OpenBCI_GUI.this.popStyle();
            OpenBCI_GUI.this.initSystemButton.draw();
        }
    }

    class InterfaceBoxCyton {
        int x;
        int y;
        int w;
        int h;
        int padding;

        InterfaceBoxCyton(int _x, int _y, int _w, int _h, int _padding) {
            this.x = _x;
            this.y = _y;
            this.w = _w;
            this.h = (24 + _padding) * 3;
            this.padding = _padding;
            OpenBCI_GUI.this.protocolSerialCyton = new Button(this.x + this.padding, this.y + this.padding * 3, this.w - this.padding * 2, 24, "Serial (from Dongle)", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
            OpenBCI_GUI.this.protocolWifiCyton = new Button(this.x + this.padding, this.y + this.padding * 4 + 24, this.w - this.padding * 2, 24, "Wifi (from Wifi Shield)", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
        }

        public void update() {
        }

        public void draw() {
            OpenBCI_GUI.this.pushStyle();
            OpenBCI_GUI.this.fill(OpenBCI_GUI.this.boxColor);
            OpenBCI_GUI.this.stroke(OpenBCI_GUI.this.boxStrokeColor);
            OpenBCI_GUI.this.strokeWeight(1.0f);
            OpenBCI_GUI.this.rect(this.x, this.y, this.w, this.h);
            OpenBCI_GUI.this.fill(OpenBCI_GUI.this.bgColor);
            OpenBCI_GUI.this.textFont(OpenBCI_GUI.this.h3, 16.0f);
            OpenBCI_GUI.this.textAlign(37, 101);
            OpenBCI_GUI.this.text("PICK TRANSFER PROTOCOL", this.x + this.padding, this.y + this.padding);
            OpenBCI_GUI.this.popStyle();
            OpenBCI_GUI.this.protocolSerialCyton.draw();
            OpenBCI_GUI.this.protocolWifiCyton.draw();
        }
    }

    class InterfaceBoxGanglion {
        int x;
        int y;
        int w;
        int h;
        int padding;

        InterfaceBoxGanglion(int _x, int _y, int _w, int _h, int _padding) {
            this.x = _x;
            this.y = _y;
            this.w = _w;
            this.h = (24 + _padding) * 3;
            this.padding = _padding;
            if (OpenBCI_GUI.this.isMac()) {
                this.h = (24 + _padding) * 4;
                OpenBCI_GUI.this.protocolBLEGanglion = new Button(this.x + this.padding, this.y + this.padding * 3, this.w - this.padding * 2, 24, "Bluetooth (Built In)", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
                OpenBCI_GUI.this.protocolBLED112Ganglion = new Button(this.x + this.padding, this.y + this.padding * 4 + 24, this.w - this.padding * 2, 24, "Bluetooth (BLED112 Dongle)", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
                OpenBCI_GUI.this.protocolWifiGanglion = new Button(this.x + this.padding, this.y + this.padding * 5 + 48, this.w - this.padding * 2, 24, "Wifi (from Wifi Shield)", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
            } else {
                OpenBCI_GUI.this.protocolBLEGanglion = new Button(this.x + this.padding, this.y + this.padding * 3, this.w - this.padding * 2, 24, "Bluetooth (CSR Dongle)", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
                OpenBCI_GUI.this.protocolWifiGanglion = new Button(this.x + this.padding, this.y + this.padding * 4 + 24, this.w - this.padding * 2, 24, "Wifi (from Wifi Shield)", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
            }
        }

        public void update() {
        }

        public void draw() {
            OpenBCI_GUI.this.pushStyle();
            OpenBCI_GUI.this.fill(OpenBCI_GUI.this.boxColor);
            OpenBCI_GUI.this.stroke(OpenBCI_GUI.this.boxStrokeColor);
            OpenBCI_GUI.this.strokeWeight(1.0f);
            OpenBCI_GUI.this.rect(this.x, this.y, this.w, this.h);
            OpenBCI_GUI.this.fill(OpenBCI_GUI.this.bgColor);
            OpenBCI_GUI.this.textFont(OpenBCI_GUI.this.h3, 16.0f);
            OpenBCI_GUI.this.textAlign(37, 101);
            OpenBCI_GUI.this.text("PICK TRANSFER PROTOCOL", this.x + this.padding, this.y + this.padding);
            OpenBCI_GUI.this.popStyle();
            OpenBCI_GUI.this.protocolBLEGanglion.draw();
            OpenBCI_GUI.this.protocolWifiGanglion.draw();
            if (OpenBCI_GUI.this.isMac()) {
                OpenBCI_GUI.this.protocolBLED112Ganglion.draw();
            }
        }
    }

    class InterfaceSerial {
        private Serial serial_openBCI = null;
        private boolean portIsOpen = false;
        static final int DATAMODE_BIN = 2;
        static final int DATAMODE_BIN_WAUX = 1;
        static final int STATE_NOCOM = 0;
        static final int STATE_COMINIT = 1;
        static final int STATE_SYNCWITHHARDWARE = 2;
        static final int STATE_NORMAL = 3;
        static final int STATE_STOPPED = 4;
        static final int COM_INIT_MSEC = 3000;
        static final byte BYTE_START = -96;
        static final byte BYTE_END = -64;
        int prefered_datamode = 1;
        private int state = 0;
        int dataMode = -1;
        int prevState_millis = 0;
        private int nEEGValuesPerPacket = 8;
        private int nAuxValuesPerPacket = 3;
        private DataPacket_ADS1299 rawReceivedDataPacket;
        private DataPacket_ADS1299 missedDataPacket;
        private DataPacket_ADS1299 dataPacket;
        public int[] validAuxValues = new int[3];
        public boolean[] freshAuxValuesAvailable = new boolean[3];
        public boolean freshAuxValues = false;
        private int nAuxValues;
        private boolean isNewDataPacketAvailable = false;
        private OutputStream output;
        private int prevSampleIndex = 0;
        private int serialErrorCounter = 0;
        private final float fs_Hz = 250.0f;
        private final float ADS1299_Vref = 4.5f;
        private float ADS1299_gain = 24.0f;
        private float openBCI_series_resistor_ohms = 2200.0f;
        private float scale_fac_uVolts_per_count = 4.5f / (OpenBCI_GUI.pow((float)2.0f, (float)23.0f) - 1.0f) / this.ADS1299_gain * 1000000.0f;
        private final float scale_fac_accel_G_per_count = 0.002f / OpenBCI_GUI.pow((float)2.0f, (float)4.0f);
        private final float leadOffDrive_amps = 6.0E-9f;
        private final String failureMessage = "Failure: Communications timeout - Device failed to poll Host";
        boolean isBiasAuto = true;
        final char[] EOT = new char[]{'$', '$', '$'};
        char[] prev3chars = new char[]{'#', '#', '#'};
        private boolean readyToSend = false;
        private long timeOfLastCommand = 0L;
        private int nDataValuesInPacket = 0;
        private int localByteCounter = 0;
        private int localChannelCounter = 0;
        private int PACKET_readstate = 0;
        private byte[] localAdsByteBuffer = new byte[3];
        private byte[] localAccelByteBuffer = new byte[2];

        public boolean isReadyToSend() {
            return this.readyToSend;
        }

        public void setReadyToSend(boolean _readyToSend) {
            this.readyToSend = _readyToSend;
        }

        public int get_state() {
            return this.state;
        }

        public boolean get_isNewDataPacketAvailable() {
            return this.isNewDataPacketAvailable;
        }

        public void set_isNewDataPacketAvailable(boolean _isNewDataPacketAvailable) {
            this.isNewDataPacketAvailable = _isNewDataPacketAvailable;
        }

        InterfaceSerial() {
        }

        InterfaceSerial(PApplet applet, String comPort, int baud, int nEEGValuesPerOpenBCI, boolean useAux, int nAuxValuesPerOpenBCI) {
            OpenBCI_GUI.println((String)("InterfaceSerial: prefered_datamode = " + this.prefered_datamode + ", nValuesPerPacket = " + this.nEEGValuesPerPacket));
            if (this.prefered_datamode == 1 && !useAux) {
                this.prefered_datamode = 2;
                this.nAuxValues = 0;
            }
            this.dataMode = this.prefered_datamode;
            this.initDataPackets(nEEGValuesPerOpenBCI, nAuxValuesPerOpenBCI);
        }

        public void initDataPackets(int numEEG, int numAux) {
            this.nEEGValuesPerPacket = numEEG;
            this.nAuxValuesPerPacket = numAux;
            this.rawReceivedDataPacket = new DataPacket_ADS1299(this.nEEGValuesPerPacket, this.nAuxValuesPerPacket);
            this.missedDataPacket = new DataPacket_ADS1299(this.nEEGValuesPerPacket, this.nAuxValuesPerPacket);
            this.dataPacket = new DataPacket_ADS1299(this.nEEGValuesPerPacket, this.nAuxValuesPerPacket);
            int i = 0;
            while (i < this.nEEGValuesPerPacket) {
                this.rawReceivedDataPacket.values[i] = 0;
                ++i;
            }
            i = 0;
            while (i < this.nEEGValuesPerPacket) {
                this.dataPacket.values[i] = 0;
                this.missedDataPacket.values[i] = 0;
                ++i;
            }
            i = 0;
            while (i < this.nAuxValuesPerPacket) {
                this.rawReceivedDataPacket.auxValues[i] = 0;
                this.dataPacket.auxValues[i] = 0;
                this.missedDataPacket.auxValues[i] = 0;
                ++i;
            }
        }

        public int openSerialPort(PApplet applet, String comPort, int baud) {
            OpenBCI_GUI.this.output("Attempting to open Serial/COM port: " + OpenBCI_GUI.this.openBCI_portName);
            try {
                OpenBCI_GUI.println((String)("InterfaceSerial: openSerialPort: attempting to open serial port: " + OpenBCI_GUI.this.openBCI_portName));
                this.serial_openBCI = new Serial(applet, comPort, baud);
                this.serial_openBCI.clear();
                this.portIsOpen = true;
                OpenBCI_GUI.println((String)("InterfaceSerial: openSerialPort: port is open (t)? ... " + this.portIsOpen));
                this.changeState(1);
                return 0;
            }
            catch (RuntimeException e) {
                if (e.getMessage().contains("<init>")) {
                    this.serial_openBCI = null;
                    System.out.println("InterfaceSerial: openSerialPort: port in use, trying again later...");
                    this.portIsOpen = false;
                } else {
                    OpenBCI_GUI.println((String)("RunttimeException: " + e));
                    OpenBCI_GUI.this.output("Error connecting to selected Serial/COM port. Make sure your board is powered up and your dongle is plugged in.");
                    OpenBCI_GUI.this.abandonInit = true;
                }
                return 0;
            }
        }

        public int changeState(int newState) {
            this.state = newState;
            this.prevState_millis = OpenBCI_GUI.this.millis();
            return 0;
        }

        public int finalizeCOMINIT() {
            this.changeState(3);
            return 0;
        }

        public int closeSDandSerialPort() {
            int returnVal = 0;
            OpenBCI_GUI.this.cyton.closeSDFile();
            this.readyToSend = false;
            returnVal = this.closeSerialPort();
            this.prevState_millis = 0;
            OpenBCI_GUI.this.cyton.hardwareSyncStep = 0;
            return returnVal;
        }

        public int closeSerialPort() {
            this.portIsOpen = false;
            if (this.serial_openBCI != null) {
                this.serial_openBCI.stop();
            }
            this.serial_openBCI = null;
            this.state = 0;
            OpenBCI_GUI.println((String)"InterfaceSerial: closeSerialPort: closed");
            return 0;
        }

        public void updateSyncState(int sdSetting) {
            if (OpenBCI_GUI.this.millis() - this.prevState_millis > 3000 && this.prevState_millis != 0 && this.state == 1) {
                this.state = 2;
                this.timeOfLastCommand = OpenBCI_GUI.this.millis();
                this.serial_openBCI.clear();
                OpenBCI_GUI.this.cyton.potentialFailureMessage = "";
                OpenBCI_GUI.this.cyton.defaultChannelSettings = "";
                OpenBCI_GUI.this.cyton.daisyOrNot = "";
                OpenBCI_GUI.println((String)"InterfaceSerial: systemUpdate: [0] Sending 'v' to OpenBCI to reset hardware in case of 32bit board...");
                this.serial_openBCI.write(118);
            }
            if (this.state == 2 && !OpenBCI_GUI.this.currentlySyncing && (long)OpenBCI_GUI.this.millis() - this.timeOfLastCommand > 200L && this.readyToSend) {
                OpenBCI_GUI.println((String)("sdSetting: " + sdSetting));
                this.timeOfLastCommand = OpenBCI_GUI.this.millis();
                ++OpenBCI_GUI.this.cyton.hardwareSyncStep;
                OpenBCI_GUI.this.cyton.syncWithHardware(sdSetting);
            }
        }

        public void sendChar(char val) {
            if (this.isSerialPortOpen()) {
                OpenBCI_GUI.println((String)("sending out: " + val));
                this.serial_openBCI.write((int)val);
            } else {
                OpenBCI_GUI.println((String)("nope no out: " + val));
            }
        }

        public void write(String msg) {
            if (this.isSerialPortOpen()) {
                this.serial_openBCI.write(msg);
            }
        }

        public boolean isSerialPortOpen() {
            return this.portIsOpen & this.serial_openBCI != null;
        }

        public boolean isOpenBCISerial(Serial port) {
            return this.serial_openBCI == port;
        }

        public void clear() {
            if (this.serial_openBCI != null) {
                this.serial_openBCI.clear();
            }
        }

        public int read() {
            return this.read(false);
        }

        public int read(boolean echoChar) {
            if (!this.isSerialPortOpen()) {
                OpenBCI_GUI.println((String)"InterfaceSerial port not open aborting.");
                return 0;
            }
            byte inByte = PApplet.parseByte((int)this.serial_openBCI.read());
            OpenBCI_GUI.print((byte)inByte);
            if (echoChar) {
                char inASCII = PApplet.parseChar((byte)inByte);
                if (!OpenBCI_GUI.this.isRunning && (long)OpenBCI_GUI.this.millis() - OpenBCI_GUI.this.timeSinceStopRunning > 500L) {
                    OpenBCI_GUI.print((char)PApplet.parseChar((byte)inByte));
                }
                this.prev3chars[0] = this.prev3chars[1];
                this.prev3chars[1] = this.prev3chars[2];
                this.prev3chars[2] = inASCII;
                if (OpenBCI_GUI.this.cyton.hardwareSyncStep == 0 && inASCII != '$') {
                    OpenBCI_GUI.this.cyton.potentialFailureMessage = String.valueOf(OpenBCI_GUI.this.cyton.potentialFailureMessage) + inASCII;
                }
                if (OpenBCI_GUI.this.cyton.hardwareSyncStep == 1 && inASCII != '$') {
                    OpenBCI_GUI.this.cyton.daisyOrNot = String.valueOf(OpenBCI_GUI.this.cyton.daisyOrNot) + inASCII;
                    if (OpenBCI_GUI.this.nchan == 16 && OpenBCI_GUI.this.cyton.daisyOrNot.charAt(OpenBCI_GUI.this.cyton.daisyOrNot.length() - 1) == '8') {
                        OpenBCI_GUI.this.verbosePrint(" received from OpenBCI... Abandoning hardware initiation.");
                        OpenBCI_GUI.this.abandonInit = true;
                    }
                }
                if (OpenBCI_GUI.this.cyton.hardwareSyncStep == 3 && inASCII != '$') {
                    OpenBCI_GUI.this.cyton.defaultChannelSettings = String.valueOf(OpenBCI_GUI.this.cyton.defaultChannelSettings) + inASCII;
                }
                if (this.prev3chars[0] == this.EOT[0] && this.prev3chars[1] == this.EOT[1] && this.prev3chars[2] == this.EOT[2]) {
                    OpenBCI_GUI.this.verbosePrint(" > EOT detected...");
                    if (OpenBCI_GUI.this.cyton.hardwareSyncStep == 0 && OpenBCI_GUI.this.cyton.potentialFailureMessage.equals("Failure: Communications timeout - Device failed to poll Host")) {
                        OpenBCI_GUI.this.closeLogFile();
                        return 0;
                    }
                    this.prev3chars[2] = 35;
                    if (OpenBCI_GUI.this.cyton.hardwareSyncStep == 3) {
                        OpenBCI_GUI.println((String)"InterfaceSerial: read(): x");
                        OpenBCI_GUI.println((String)OpenBCI_GUI.this.cyton.defaultChannelSettings);
                        OpenBCI_GUI.println((String)"InterfaceSerial: read(): y");
                        OpenBCI_GUI.this.w_timeSeries.hsc.loadDefaultChannelSettings();
                        OpenBCI_GUI.println((String)"InterfaceSerial: read(): z");
                    }
                    this.readyToSend = true;
                }
            }
            if (this.output != null) {
                try {
                    this.output.write(inByte);
                }
                catch (IOException e) {
                    System.err.println("InterfaceSerial: read(): Caught IOException: " + e.getMessage());
                }
            }
            this.interpretBinaryStream(inByte);
            return PApplet.parseInt((byte)inByte);
        }

        public void interpretBinaryStream(byte actbyte) {
            boolean flag_copyRawDataToFullData = false;
            switch (this.PACKET_readstate) {
                case 0: {
                    if (actbyte != PApplet.parseByte((int)160)) break;
                    ++this.PACKET_readstate;
                    break;
                }
                case 1: {
                    byte inByte = actbyte;
                    this.rawReceivedDataPacket.sampleIndex = PApplet.parseInt((byte)inByte);
                    if (this.rawReceivedDataPacket.sampleIndex - this.prevSampleIndex != 1 && this.rawReceivedDataPacket.sampleIndex != 0) {
                        ++this.serialErrorCounter;
                        OpenBCI_GUI.this.werePacketsDroppedSerial = true;
                        OpenBCI_GUI.this.numPacketsDroppedSerial = this.rawReceivedDataPacket.sampleIndex < this.prevSampleIndex ? this.rawReceivedDataPacket.sampleIndex + 255 - this.prevSampleIndex : this.rawReceivedDataPacket.sampleIndex - this.prevSampleIndex;
                        OpenBCI_GUI.println((String)("InterfaceSerial: apparent sampleIndex jump from Serial data: " + this.prevSampleIndex + " to  " + this.rawReceivedDataPacket.sampleIndex + ".  Keeping packet. (" + this.serialErrorCounter + ")"));
                        if (OpenBCI_GUI.this.outputDataSource == 2) {
                            int fakePacketsToWrite = this.rawReceivedDataPacket.sampleIndex - this.prevSampleIndex - 1;
                            int i = 0;
                            while (i < fakePacketsToWrite) {
                                OpenBCI_GUI.this.fileoutput_bdf.writeRawData_dataPacket(this.missedDataPacket);
                                ++i;
                            }
                            OpenBCI_GUI.println((String)("InterfaceSerial: because BDF, wrote " + fakePacketsToWrite + " empty data packet(s)"));
                        }
                    }
                    this.prevSampleIndex = this.rawReceivedDataPacket.sampleIndex;
                    this.localByteCounter = 0;
                    this.localChannelCounter = 0;
                    ++this.PACKET_readstate;
                    break;
                }
                case 2: {
                    this.localAdsByteBuffer[this.localByteCounter] = actbyte;
                    ++this.localByteCounter;
                    if (this.localByteCounter != 3) break;
                    this.rawReceivedDataPacket.values[this.localChannelCounter] = this.interpret24bitAsInt32(this.localAdsByteBuffer);
                    OpenBCI_GUI.arrayCopy((Object)this.localAdsByteBuffer, (Object)this.rawReceivedDataPacket.rawValues[this.localChannelCounter]);
                    ++this.localChannelCounter;
                    if (this.localChannelCounter == 8) {
                        ++this.PACKET_readstate;
                        if (this.prefered_datamode != 1) {
                            ++this.PACKET_readstate;
                        }
                        this.localByteCounter = 0;
                        this.localChannelCounter = 0;
                        break;
                    }
                    this.localByteCounter = 0;
                    break;
                }
                case 3: {
                    this.localAccelByteBuffer[this.localByteCounter] = actbyte;
                    ++this.localByteCounter;
                    if (this.localByteCounter != 2) break;
                    this.rawReceivedDataPacket.auxValues[this.localChannelCounter] = this.interpret16bitAsInt32(this.localAccelByteBuffer);
                    OpenBCI_GUI.arrayCopy((Object)this.localAccelByteBuffer, (Object)this.rawReceivedDataPacket.rawAuxValues[this.localChannelCounter]);
                    if (this.rawReceivedDataPacket.auxValues[this.localChannelCounter] != 0) {
                        this.validAuxValues[this.localChannelCounter] = this.rawReceivedDataPacket.auxValues[this.localChannelCounter];
                        this.freshAuxValuesAvailable[this.localChannelCounter] = true;
                        this.freshAuxValues = true;
                    } else {
                        this.freshAuxValues = false;
                    }
                    ++this.localChannelCounter;
                    if (this.localChannelCounter == this.nAuxValues) {
                        ++this.PACKET_readstate;
                        this.localByteCounter = 0;
                        break;
                    }
                    this.localByteCounter = 0;
                    break;
                }
                case 4: {
                    if (actbyte == PApplet.parseByte((int)192) || actbyte == PApplet.parseByte((int)193)) {
                        this.isNewDataPacketAvailable = true;
                        flag_copyRawDataToFullData = true;
                    } else {
                        ++this.serialErrorCounter;
                        OpenBCI_GUI.println((String)("InterfaceSerial: interpretBinaryStream: Actbyte = " + actbyte));
                        OpenBCI_GUI.println((String)("InterfaceSerial: interpretBinaryStream: expecteding end-of-packet byte is missing.  Discarding packet. (" + this.serialErrorCounter + ")"));
                    }
                    this.PACKET_readstate = 0;
                    break;
                }
                default: {
                    OpenBCI_GUI.println((String)("InterfaceSerial: interpretBinaryStream: Unknown byte: " + actbyte + " .  Continuing..."));
                    this.PACKET_readstate = 0;
                }
            }
            if (flag_copyRawDataToFullData) {
                this.copyRawDataToFullData();
            }
        }

        public boolean isStateNormal() {
            return this.state == 3;
        }

        private int interpret24bitAsInt32(byte[] byteArray) {
            int newInt = (0xFF & byteArray[0]) << 16 | (0xFF & byteArray[1]) << 8 | 0xFF & byteArray[2];
            newInt = (newInt & 0x800000) > 0 ? (newInt |= 0xFF000000) : (newInt &= 0xFFFFFF);
            return newInt;
        }

        private int interpret16bitAsInt32(byte[] byteArray) {
            int newInt = (0xFF & byteArray[0]) << 8 | 0xFF & byteArray[1];
            newInt = (newInt & 0x8000) > 0 ? (newInt |= 0xFFFF0000) : (newInt &= 0xFFFF);
            return newInt;
        }

        private int copyRawDataToFullData() {
            if (this.dataPacket.values.length < 2 * this.rawReceivedDataPacket.values.length) {
                return this.rawReceivedDataPacket.copyTo(this.dataPacket);
            }
            int offsetInd_values = 0;
            int offsetInd_aux = 0;
            if (this.rawReceivedDataPacket.sampleIndex % 2 == 0) {
                offsetInd_values = this.rawReceivedDataPacket.values.length;
                offsetInd_aux = 0;
            }
            return this.rawReceivedDataPacket.copyTo(this.dataPacket, offsetInd_values, offsetInd_aux);
        }

        public int copyDataPacketTo(DataPacket_ADS1299 target) {
            this.isNewDataPacketAvailable = false;
            return this.dataPacket.copyTo(target);
        }
    }

    class LatencyCytonBox {
        int x;
        int y;
        int w;
        int h;
        int padding;

        LatencyCytonBox(int _x, int _y, int _w, int _h, int _padding) {
            this.x = _x;
            this.y = _y;
            this.w = _w;
            this.h = 73;
            this.padding = _padding;
            OpenBCI_GUI.this.latencyCyton5ms = new Button(this.x + this.padding, this.y + this.padding * 2 + 18, (this.w - this.padding * 4) / 3, 24, "5ms", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
            if (OpenBCI_GUI.this.hub.getLatency() == 5000) {
                OpenBCI_GUI.this.latencyCyton5ms.color_notPressed = OpenBCI_GUI.this.isSelected_color;
            }
            OpenBCI_GUI.this.latencyCyton10ms = new Button(this.x + this.padding * 2 + (this.w - this.padding * 4) / 3, this.y + this.padding * 2 + 18, (this.w - this.padding * 4) / 3, 24, "10ms", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
            if (OpenBCI_GUI.this.hub.getLatency() == 10000) {
                OpenBCI_GUI.this.latencyCyton10ms.color_notPressed = OpenBCI_GUI.this.isSelected_color;
            }
            OpenBCI_GUI.this.latencyCyton20ms = new Button(this.x + this.padding * 3 + (this.w - this.padding * 4) / 3 * 2, this.y + this.padding * 2 + 18, (this.w - this.padding * 4) / 3, 24, "20ms", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
            if (OpenBCI_GUI.this.hub.getLatency() == 20000) {
                OpenBCI_GUI.this.latencyCyton20ms.color_notPressed = OpenBCI_GUI.this.isSelected_color;
            }
        }

        public void update() {
        }

        public void draw() {
            OpenBCI_GUI.this.pushStyle();
            OpenBCI_GUI.this.fill(OpenBCI_GUI.this.boxColor);
            OpenBCI_GUI.this.stroke(OpenBCI_GUI.this.boxStrokeColor);
            OpenBCI_GUI.this.strokeWeight(1.0f);
            OpenBCI_GUI.this.rect(this.x, this.y, this.w, this.h);
            OpenBCI_GUI.this.fill(OpenBCI_GUI.this.bgColor);
            OpenBCI_GUI.this.textFont(OpenBCI_GUI.this.h3, 16.0f);
            OpenBCI_GUI.this.textAlign(37, 101);
            OpenBCI_GUI.this.text("LATENCY ", this.x + this.padding, this.y + this.padding);
            OpenBCI_GUI.this.fill(OpenBCI_GUI.this.bgColor);
            OpenBCI_GUI.this.textFont(OpenBCI_GUI.this.h3, 16.0f);
            OpenBCI_GUI.this.textAlign(37, 101);
            OpenBCI_GUI.this.text("  " + OpenBCI_GUI.str((int)(OpenBCI_GUI.this.hub.getLatency() / 1000)) + "ms", this.x + this.padding + 142, this.y + this.padding);
            OpenBCI_GUI.this.popStyle();
            OpenBCI_GUI.this.latencyCyton5ms.draw();
            OpenBCI_GUI.this.latencyCyton10ms.draw();
            OpenBCI_GUI.this.latencyCyton20ms.draw();
            OpenBCI_GUI.this.latencyCyton10ms.but_y = OpenBCI_GUI.this.latencyCyton5ms.but_y = this.y + this.padding * 2 + 18;
            OpenBCI_GUI.this.latencyCyton20ms.but_y = OpenBCI_GUI.this.latencyCyton5ms.but_y;
        }
    }

    class LatencyGanglionBox {
        int x;
        int y;
        int w;
        int h;
        int padding;

        LatencyGanglionBox(int _x, int _y, int _w, int _h, int _padding) {
            this.x = _x;
            this.y = _y;
            this.w = _w;
            this.h = 73;
            this.padding = _padding;
            OpenBCI_GUI.this.latencyGanglion5ms = new Button(this.x + this.padding, this.y + this.padding * 2 + 18, (this.w - this.padding * 4) / 3, 24, "5ms", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
            if (OpenBCI_GUI.this.hub.getLatency() == 5000) {
                OpenBCI_GUI.this.latencyGanglion5ms.color_notPressed = OpenBCI_GUI.this.isSelected_color;
            }
            OpenBCI_GUI.this.latencyGanglion10ms = new Button(this.x + this.padding * 2 + (this.w - this.padding * 4) / 3, this.y + this.padding * 2 + 18, (this.w - this.padding * 4) / 3, 24, "10ms", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
            if (OpenBCI_GUI.this.hub.getLatency() == 10000) {
                OpenBCI_GUI.this.latencyGanglion10ms.color_notPressed = OpenBCI_GUI.this.isSelected_color;
            }
            OpenBCI_GUI.this.latencyGanglion20ms = new Button(this.x + this.padding * 3 + (this.w - this.padding * 4) / 3 * 2, this.y + this.padding * 2 + 18, (this.w - this.padding * 4) / 3, 24, "20ms", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
            if (OpenBCI_GUI.this.hub.getLatency() == 20000) {
                OpenBCI_GUI.this.latencyGanglion20ms.color_notPressed = OpenBCI_GUI.this.isSelected_color;
            }
        }

        public void update() {
        }

        public void draw() {
            OpenBCI_GUI.this.pushStyle();
            OpenBCI_GUI.this.fill(OpenBCI_GUI.this.boxColor);
            OpenBCI_GUI.this.stroke(OpenBCI_GUI.this.boxStrokeColor);
            OpenBCI_GUI.this.strokeWeight(1.0f);
            OpenBCI_GUI.this.rect(this.x, this.y, this.w, this.h);
            OpenBCI_GUI.this.fill(OpenBCI_GUI.this.bgColor);
            OpenBCI_GUI.this.textFont(OpenBCI_GUI.this.h3, 16.0f);
            OpenBCI_GUI.this.textAlign(37, 101);
            OpenBCI_GUI.this.text("LATENCY ", this.x + this.padding, this.y + this.padding);
            OpenBCI_GUI.this.fill(OpenBCI_GUI.this.bgColor);
            OpenBCI_GUI.this.textFont(OpenBCI_GUI.this.h3, 16.0f);
            OpenBCI_GUI.this.textAlign(37, 101);
            OpenBCI_GUI.this.text("  " + OpenBCI_GUI.str((int)(OpenBCI_GUI.this.hub.getLatency() / 1000)) + "ms", this.x + this.padding + 142, this.y + this.padding);
            OpenBCI_GUI.this.popStyle();
            OpenBCI_GUI.this.latencyGanglion5ms.draw();
            OpenBCI_GUI.this.latencyGanglion10ms.draw();
            OpenBCI_GUI.this.latencyGanglion20ms.draw();
            OpenBCI_GUI.this.latencyGanglion10ms.but_y = OpenBCI_GUI.this.latencyGanglion5ms.but_y = this.y + this.padding * 2 + 18;
            OpenBCI_GUI.this.latencyGanglion20ms.but_y = OpenBCI_GUI.this.latencyGanglion5ms.but_y;
        }
    }

    class Layout {
        Container[] myContainers;
        int[] containerInts;

        Layout(int[] _myContainers) {
            this.myContainers = new Container[_myContainers.length];
            this.containerInts = new int[_myContainers.length];
            int i = 0;
            while (i < _myContainers.length) {
                this.myContainers[i] = OpenBCI_GUI.this.container[_myContainers[i]];
                this.containerInts[i] = _myContainers[i];
                ++i;
            }
        }

        public Container getContainer(int _numContainer) {
            if (_numContainer < this.myContainers.length) {
                return this.myContainers[_numContainer];
            }
            OpenBCI_GUI.println((String)"tried to return a non-existant container...");
            return this.myContainers[this.myContainers.length - 1];
        }
    }

    class LayoutSelector {
        int x;
        int y;
        int w = 180;
        int h;
        int margin;
        int b_w;
        int b_h;
        boolean isVisible;
        ArrayList<Button> layoutOptions;

        LayoutSelector() {
            this.x = OpenBCI_GUI.this.width - this.w - 3;
            this.y = OpenBCI_GUI.this.navBarHeight * 2 - 3;
            this.margin = 6;
            this.b_h = this.b_w = (this.w - 5 * this.margin) / 4;
            this.h = this.margin * 3 + this.b_h * 2;
            this.isVisible = false;
            this.layoutOptions = new ArrayList();
            this.addLayoutOptionButton();
        }

        public void update() {
        }

        public void draw() {
            if (this.isVisible) {
                OpenBCI_GUI.this.pushStyle();
                OpenBCI_GUI.this.stroke(OpenBCI_GUI.this.bgColor);
                OpenBCI_GUI.this.fill(57.0f, 128.0f, 204.0f);
                OpenBCI_GUI.this.rect(this.x, this.y, this.w, this.h);
                int i = 0;
                while (i < this.layoutOptions.size()) {
                    this.layoutOptions.get(i).draw();
                    ++i;
                }
                OpenBCI_GUI.this.fill(57.0f, 128.0f, 204.0f);
                OpenBCI_GUI.this.noStroke();
                OpenBCI_GUI.this.rect(this.x + this.w - (OpenBCI_GUI.this.topNav.layoutButton.but_dx - 1), this.y, OpenBCI_GUI.this.topNav.layoutButton.but_dx - 1, 1.0f);
                OpenBCI_GUI.this.popStyle();
            }
        }

        public void isMouseHere() {
        }

        public void mousePressed() {
            if (this.isVisible) {
                int i = 0;
                while (i < this.layoutOptions.size()) {
                    if (this.layoutOptions.get(i).isMouseHere()) {
                        this.layoutOptions.get(i).setIsActive(true);
                    }
                    ++i;
                }
            }
        }

        public void mouseReleased() {
            if (this.isVisible) {
                if (!(OpenBCI_GUI.this.mouseX >= this.x && OpenBCI_GUI.this.mouseX <= this.x + this.w && OpenBCI_GUI.this.mouseY >= this.y && OpenBCI_GUI.this.mouseY <= this.y + this.h || OpenBCI_GUI.this.topNav.layoutButton.isMouseHere())) {
                    this.toggleVisibility();
                }
                int i = 0;
                while (i < this.layoutOptions.size()) {
                    if (this.layoutOptions.get(i).isMouseHere() && this.layoutOptions.get(i).isActive()) {
                        int layoutSelected = i + 1;
                        OpenBCI_GUI.println((String)("Layout [" + layoutSelected + "] selected."));
                        OpenBCI_GUI.this.output("Layout [" + layoutSelected + "] selected.");
                        this.layoutOptions.get(i).setIsActive(false);
                        this.toggleVisibility();
                        OpenBCI_GUI.this.wm.setNewContainerLayout(layoutSelected - 1);
                    }
                    ++i;
                }
            }
        }

        public void screenResized() {
            int oldX = this.x;
            this.x = OpenBCI_GUI.this.width - this.w - 3;
            int dx = oldX - this.x;
            int i = 0;
            while (i < this.layoutOptions.size()) {
                this.layoutOptions.get(i).setX(this.layoutOptions.get((int)i).but_x - dx);
                ++i;
            }
        }

        public void toggleVisibility() {
            boolean bl = this.isVisible = !this.isVisible;
            if (this.isVisible) {
                int i = 0;
                while (i < OpenBCI_GUI.this.wm.widgets.size()) {
                    int j = 0;
                    while (j < OpenBCI_GUI.this.wm.widgets.get((int)i).cp5_widget.getAll().size()) {
                        OpenBCI_GUI.this.wm.widgets.get((int)i).cp5_widget.getController(((ControllerInterface)OpenBCI_GUI.this.wm.widgets.get((int)i).cp5_widget.getAll().get(j)).getAddress()).lock();
                        ++j;
                    }
                    ++i;
                }
            } else {
                int i = 0;
                while (i < OpenBCI_GUI.this.wm.widgets.size()) {
                    int j = 0;
                    while (j < OpenBCI_GUI.this.wm.widgets.get((int)i).cp5_widget.getAll().size()) {
                        OpenBCI_GUI.this.wm.widgets.get((int)i).cp5_widget.getController(((ControllerInterface)OpenBCI_GUI.this.wm.widgets.get((int)i).cp5_widget.getAll().get(j)).getAddress()).unlock();
                        ++j;
                    }
                    ++i;
                }
            }
        }

        public void addLayoutOptionButton() {
            Button tempLayoutButton = new Button(this.x + this.margin, this.y + this.margin, this.b_w, this.b_h, "N/A");
            PImage tempBackgroundImage = OpenBCI_GUI.this.loadImage("layout_buttons/layout_1.png");
            tempLayoutButton.setBackgroundImage(tempBackgroundImage);
            this.layoutOptions.add(tempLayoutButton);
            tempLayoutButton = new Button(this.x + 2 * this.margin + this.b_w * 1, this.y + this.margin, this.b_w, this.b_h, "N/A");
            tempBackgroundImage = OpenBCI_GUI.this.loadImage("layout_buttons/layout_2.png");
            tempLayoutButton.setBackgroundImage(tempBackgroundImage);
            this.layoutOptions.add(tempLayoutButton);
            tempLayoutButton = new Button(this.x + 3 * this.margin + this.b_w * 2, this.y + this.margin, this.b_w, this.b_h, "N/A");
            tempBackgroundImage = OpenBCI_GUI.this.loadImage("layout_buttons/layout_3.png");
            tempLayoutButton.setBackgroundImage(tempBackgroundImage);
            this.layoutOptions.add(tempLayoutButton);
            tempLayoutButton = new Button(this.x + 4 * this.margin + this.b_w * 3, this.y + this.margin, this.b_w, this.b_h, "N/A");
            tempBackgroundImage = OpenBCI_GUI.this.loadImage("layout_buttons/layout_4.png");
            tempLayoutButton.setBackgroundImage(tempBackgroundImage);
            this.layoutOptions.add(tempLayoutButton);
            tempLayoutButton = new Button(this.x + this.margin, this.y + 2 * this.margin + 1 * this.b_h, this.b_w, this.b_h, "N/A");
            tempBackgroundImage = OpenBCI_GUI.this.loadImage("layout_buttons/layout_5.png");
            tempLayoutButton.setBackgroundImage(tempBackgroundImage);
            this.layoutOptions.add(tempLayoutButton);
            tempLayoutButton = new Button(this.x + 2 * this.margin + this.b_w * 1, this.y + 2 * this.margin + 1 * this.b_h, this.b_w, this.b_h, "N/A");
            tempBackgroundImage = OpenBCI_GUI.this.loadImage("layout_buttons/layout_6.png");
            tempLayoutButton.setBackgroundImage(tempBackgroundImage);
            this.layoutOptions.add(tempLayoutButton);
            tempLayoutButton = new Button(this.x + 3 * this.margin + this.b_w * 2, this.y + 2 * this.margin + 1 * this.b_h, this.b_w, this.b_h, "N/A");
            tempBackgroundImage = OpenBCI_GUI.this.loadImage("layout_buttons/layout_7.png");
            tempLayoutButton.setBackgroundImage(tempBackgroundImage);
            this.layoutOptions.add(tempLayoutButton);
            tempLayoutButton = new Button(this.x + 4 * this.margin + this.b_w * 3, this.y + 2 * this.margin + 1 * this.b_h, this.b_w, this.b_h, "N/A");
            tempBackgroundImage = OpenBCI_GUI.this.loadImage("layout_buttons/layout_8.png");
            tempLayoutButton.setBackgroundImage(tempBackgroundImage);
            this.layoutOptions.add(tempLayoutButton);
            this.h = this.margin * 4 + this.b_h * 3;
            tempLayoutButton = new Button(this.x + this.margin, this.y + 3 * this.margin + 2 * this.b_h, this.b_w, this.b_h, "N/A");
            tempBackgroundImage = OpenBCI_GUI.this.loadImage("layout_buttons/layout_9.png");
            tempLayoutButton.setBackgroundImage(tempBackgroundImage);
            this.layoutOptions.add(tempLayoutButton);
            tempLayoutButton = new Button(this.x + 2 * this.margin + this.b_w * 1, this.y + 3 * this.margin + 2 * this.b_h, this.b_w, this.b_h, "N/A");
            tempBackgroundImage = OpenBCI_GUI.this.loadImage("layout_buttons/layout_10.png");
            tempLayoutButton.setBackgroundImage(tempBackgroundImage);
            this.layoutOptions.add(tempLayoutButton);
            tempLayoutButton = new Button(this.x + 3 * this.margin + this.b_w * 2, this.y + 3 * this.margin + 2 * this.b_h, this.b_w, this.b_h, "N/A");
            tempBackgroundImage = OpenBCI_GUI.this.loadImage("layout_buttons/layout_11.png");
            tempLayoutButton.setBackgroundImage(tempBackgroundImage);
            this.layoutOptions.add(tempLayoutButton);
            tempLayoutButton = new Button(this.x + 4 * this.margin + this.b_w * 3, this.y + 3 * this.margin + 2 * this.b_h, this.b_w, this.b_h, "N/A");
            tempBackgroundImage = OpenBCI_GUI.this.loadImage("layout_buttons/layout_12.png");
            tempLayoutButton.setBackgroundImage(tempBackgroundImage);
            this.layoutOptions.add(tempLayoutButton);
        }

        public void updateLayoutOptionButtons() {
        }
    }

    public class MenuList
    extends Controller {
        float pos;
        float npos;
        int itemHeight;
        int scrollerLength;
        int scrollerWidth;
        List<Map<String, Object>> items;
        PGraphics menu;
        boolean updateMenu;
        boolean drawHand;
        int hoverItem;
        int activeItem;
        PFont menuFont;
        int padding;

        MenuList(ControlP5 c, String theName, int theWidth, int theHeight, PFont theFont) {
            super(c, theName, 0.0f, 0.0f, theWidth, theHeight);
            this.itemHeight = 24;
            this.scrollerLength = 40;
            this.scrollerWidth = 15;
            this.items = new ArrayList<Map<String, Object>>();
            this.hoverItem = -1;
            this.activeItem = -1;
            this.menuFont = OpenBCI_GUI.this.p4;
            this.padding = 7;
            c.register((ControllerInterface)this);
            this.menu = OpenBCI_GUI.this.createGraphics(this.getWidth(), this.getHeight());
            this.menuFont = OpenBCI_GUI.this.p4;
            this.getValueLabel().setSize(14);
            this.getCaptionLabel().setSize(14);
            this.setView((ControllerView)new ControllerView<MenuList>(){

                public void display(PGraphics pg, MenuList t) {
                    if (MenuList.this.updateMenu) {
                        MenuList.this.updateMenu();
                    }
                    if (MenuList.this.inside()) {
                        MenuList.this.menu.beginDraw();
                        int len = -(MenuList.this.itemHeight * MenuList.this.items.size()) + MenuList.this.getHeight();
                        int ty = len != 0 ? PApplet.parseInt((float)OpenBCI_GUI.map((float)MenuList.this.pos, (float)len, (float)0.0f, (float)(MenuList.this.getHeight() - MenuList.this.scrollerLength - 2), (float)2.0f)) : 0;
                        MenuList.this.menu.fill(((MenuList)MenuList.this).OpenBCI_GUI.this.bgColor, 100.0f);
                        if (ty > 0) {
                            MenuList.this.menu.rect((float)(MenuList.this.getWidth() - MenuList.this.scrollerWidth - 2), (float)ty, (float)MenuList.this.scrollerWidth, (float)MenuList.this.scrollerLength);
                        }
                        MenuList.this.menu.endDraw();
                    }
                    pg.image((PImage)MenuList.this.menu, 0.0f, 0.0f);
                }
            });
            this.updateMenu();
        }

        public void updateMenu() {
            int len = -(this.itemHeight * this.items.size()) + this.getHeight();
            this.npos = OpenBCI_GUI.constrain((float)this.npos, (float)len, (float)0.0f);
            this.pos += (this.npos - this.pos) * 0.1f;
            this.menu.beginDraw();
            this.menu.noStroke();
            this.menu.background(255, 64.0f);
            this.menu.textFont(this.menuFont);
            this.menu.pushMatrix();
            this.menu.translate(0.0f, this.pos);
            this.menu.pushMatrix();
            int i0 = this.itemHeight * this.items.size() != 0 ? PApplet.max((int)0, (int)PApplet.parseInt((float)OpenBCI_GUI.map((float)(-this.pos), (float)0.0f, (float)(this.itemHeight * this.items.size()), (float)0.0f, (float)this.items.size()))) : 0;
            int range = OpenBCI_GUI.ceil((float)(PApplet.parseFloat((int)this.getHeight()) / PApplet.parseFloat((int)this.itemHeight) + 1.0f));
            int i1 = PApplet.min((int)this.items.size(), (int)(i0 + range));
            this.menu.translate(0.0f, (float)(i0 * this.itemHeight));
            int i = i0;
            while (i < i1) {
                Map<String, Object> m = this.items.get(i);
                this.menu.fill(255, 100.0f);
                if (i == this.hoverItem) {
                    this.menu.fill(127.0f, 134.0f, 143.0f);
                }
                if (i == this.activeItem) {
                    this.menu.stroke(184.0f, 220.0f, 105.0f, 255.0f);
                    this.menu.strokeWeight(1.0f);
                    this.menu.fill(184.0f, 220.0f, 105.0f, 255.0f);
                    this.menu.rect(0.0f, 0.0f, (float)(this.getWidth() - 1), (float)(this.itemHeight - 1));
                    this.menu.noStroke();
                } else {
                    this.menu.rect(0.0f, 0.0f, (float)this.getWidth(), (float)(this.itemHeight - 1));
                }
                this.menu.fill(OpenBCI_GUI.this.bgColor);
                this.menu.textFont(this.menuFont);
                try {
                    this.menu.text(m.get("headline").toString(), 8.0f, (float)(this.itemHeight - this.padding));
                    this.menu.translate(0.0f, (float)this.itemHeight);
                }
                catch (Exception exception) {
                    OpenBCI_GUI.println((String)"Nothing in list...");
                }
                ++i;
            }
            this.menu.popMatrix();
            this.menu.popMatrix();
            this.menu.endDraw();
            this.updateMenu = OpenBCI_GUI.abs((float)(this.npos - this.pos)) > 0.01f;
        }

        public void onClick() {
            OpenBCI_GUI.println((String)"click");
            if (this.getPointer().x() > this.getWidth() - this.scrollerWidth) {
                if (this.getHeight() != 0) {
                    this.npos = -OpenBCI_GUI.map((float)this.getPointer().y(), (float)0.0f, (float)this.getHeight(), (float)0.0f, (float)(this.items.size() * this.itemHeight));
                }
                this.updateMenu = true;
            } else {
                int len = this.itemHeight * this.items.size();
                int index = 0;
                if (len != 0) {
                    index = PApplet.parseInt((float)OpenBCI_GUI.map((float)((float)this.getPointer().y() - this.pos), (float)0.0f, (float)len, (float)0.0f, (float)this.items.size()));
                }
                this.setValue(index);
                this.activeItem = index;
            }
            this.updateMenu = true;
        }

        public void onMove() {
            if (this.getPointer().x() > this.getWidth() || this.getPointer().x() < 0 || this.getPointer().y() < 0 || this.getPointer().y() > this.getHeight()) {
                this.hoverItem = -1;
            } else {
                int len = this.itemHeight * this.items.size();
                int index = 0;
                if (len != 0) {
                    index = PApplet.parseInt((float)OpenBCI_GUI.map((float)((float)this.getPointer().y() - this.pos), (float)0.0f, (float)len, (float)0.0f, (float)this.items.size()));
                }
                this.hoverItem = index;
            }
            this.updateMenu = true;
        }

        public void onDrag() {
            if (this.getPointer().x() > this.getWidth() - this.scrollerWidth) {
                this.npos = -OpenBCI_GUI.map((float)this.getPointer().y(), (float)0.0f, (float)this.getHeight(), (float)0.0f, (float)(this.items.size() * this.itemHeight));
                this.updateMenu = true;
            } else {
                this.npos += (float)(this.getPointer().dy() * 2);
                this.updateMenu = true;
            }
        }

        public void onScroll(int n) {
            this.npos += (float)(n * 4);
            this.updateMenu = true;
        }

        public void addItem(Map<String, Object> m) {
            this.items.add(m);
            this.updateMenu = true;
        }

        public void removeItem(Map<String, Object> m) {
            this.items.remove(m);
            this.updateMenu = true;
        }

        public Map<String, Object> getItem(int theIndex) {
            return this.items.get(theIndex);
        }
    }

    class NavBarDropdown {
        String id;
        String title;
        List<String> items;
        int defaultItem;

        NavBarDropdown(String _id, String _title, List _items, int _defaultItem) {
            this.id = _id;
            this.title = _title;
            this.items = _items;
            this.defaultItem = _defaultItem;
        }

        public void update() {
        }

        public void draw() {
        }

        public void screenResized() {
        }

        public void mousePressed() {
        }

        public void mouseReleased() {
        }

        public String returnDefaultAsString() {
            String _defaultItem = this.items.get(this.defaultItem);
            return _defaultItem;
        }
    }

    public class OutputFile_BDF {
        private PrintWriter writer;
        private OutputStream dstream;
        static final int BDF_HEADER_SIZE_VERSION = 8;
        static final int BDF_HEADER_SIZE_PATIENT_ID = 80;
        static final int BDF_HEADER_SIZE_RECORDING_ID = 80;
        static final int BDF_HEADER_SIZE_RECORDING_START_DATE = 8;
        static final int BDF_HEADER_SIZE_RECORDING_START_TIME = 8;
        static final int BDF_HEADER_SIZE_BYTES_IN_HEADER = 8;
        static final int BDF_HEADER_SIZE_RESERVED = 44;
        static final int BDF_HEADER_SIZE_NUMBER_DATA_RECORDS = 8;
        static final int BDF_HEADER_SIZE_DURATION_OF_DATA_RECORD = 8;
        static final int BDF_HEADER_SIZE_NUMBER_SIGNALS = 4;
        static final int BDF_HEADER_NS_SIZE_LABEL = 16;
        static final int BDF_HEADER_NS_SIZE_TRANSDUCER_TYPE = 80;
        static final int BDF_HEADER_NS_SIZE_PHYSICAL_DIMENSION = 8;
        static final int BDF_HEADER_NS_SIZE_PHYSICAL_MINIMUM = 8;
        static final int BDF_HEADER_NS_SIZE_PHYSICAL_MAXIMUM = 8;
        static final int BDF_HEADER_NS_SIZE_DIGITAL_MINIMUM = 8;
        static final int BDF_HEADER_NS_SIZE_DIGITAL_MAXIMUM = 8;
        static final int BDF_HEADER_NS_SIZE_PREFILTERING = 80;
        static final int BDF_HEADER_NS_SIZE_NR = 8;
        static final int BDF_HEADER_NS_SIZE_RESERVED = 32;
        static final String BDF_HEADER_DATA_CONTINUOUS = "BDF+C";
        static final String BDF_HEADER_DATA_DISCONTINUOUS = "BDF+D";
        static final String BDF_HEADER_PHYSICAL_DIMENISION_UV = "uV";
        static final String BDF_HEADER_PHYSICAL_DIMENISION_G = "g";
        static final String BDF_HEADER_TRANSDUCER_AGAGCL = "AgAgCl electrode";
        static final String BDF_HEADER_TRANSDUCER_MEMS = "MEMS";
        static final String BDF_HEADER_ANNOTATIONS = "BDF Annotations ";
        static final int BDF_HEADER_BYTES_BLOCK = 256;
        DateFormat startDateFormat = new SimpleDateFormat("dd.MM.yy");
        DateFormat startTimeFormat = new SimpleDateFormat("hh.mm.ss");
        private char bdf_version_header = (char)255;
        private char[] bdf_version = new char[]{'B', 'I', 'O', 'S', 'E', 'M', 'I'};
        private String bdf_patient_id_subfield_hospoital_code = "X";
        private String bdf_patient_id_subfield_sex = "X";
        private String bdf_patient_id_subfield_birthdate = "X";
        private String bdf_patient_id_subfield_name = "X";
        private String bdf_recording_id_subfield_prefix = "X";
        private String bdf_recording_id_subfield_startdate = "X";
        private String bdf_recording_id_subfield_admin_code = "X";
        private String bdf_recording_id_subfield_investigator = "X";
        private String bdf_recording_id_subfield_equipment = "X";
        private String bdf_digital_minimum_ADC_24bit = "-8388608";
        private String bdf_digital_maximum_ADC_24bit = "8388607";
        private String bdf_digital_minimum_ADC_12bit = "-2048";
        private String bdf_digital_maximum_ADC_12bit = "2047";
        private String bdf_physical_minimum_ADC_24bit = "-187500";
        private String bdf_physical_maximum_ADC_24bit = "187500";
        private String bdf_physical_minimum_ADC_Accel = "-4";
        private String bdf_physical_maximum_ADC_Accel = "4";
        private String bdf_physical_minimum_ADC_24bit_ganglion = "-15686";
        private String bdf_physical_maximum_ADC_24bit_ganglion = "15686";
        private final float ADS1299_Vref = 4.5f;
        private float ADS1299_gain = 24.0f;
        private float scale_fac_uVolts_per_count = 4.5f / (OpenBCI_GUI.pow((float)2.0f, (float)23.0f) - 1.0f) / this.ADS1299_gain * 1000000.0f;
        private int bdf_number_of_data_records = -1;
        public boolean continuous = true;
        public boolean write_accel = true;
        private float dataRecordDuration = 1.0f;
        private int nbAnnotations = 1;
        private int nbAux = 3;
        private int nbChan = 8;
        private int sampleSize = 3;
        private String[] labelsAnnotations = new String[this.nbAnnotations];
        private String[] transducerAnnotations = new String[this.nbAnnotations];
        private String[] physicalDimensionAnnotations = new String[this.nbAnnotations];
        private String[] physicalMinimumAnnotations = new String[this.nbAnnotations];
        private String[] physicalMaximumAnnotations = new String[this.nbAnnotations];
        private String[] digitalMinimumAnnotations = new String[this.nbAnnotations];
        private String[] digitalMaximumAnnotations = new String[this.nbAnnotations];
        private String[] prefilteringAnnotations = new String[this.nbAnnotations];
        private String[] nbSamplesPerDataRecordAnnotations = new String[this.nbAnnotations];
        private String[] reservedAnnotations = new String[this.nbAnnotations];
        private String[] labelsAux = new String[this.nbAux];
        private String[] transducerAux = new String[this.nbAux];
        private String[] physicalDimensionAux = new String[this.nbAux];
        private String[] physicalMinimumAux = new String[this.nbAux];
        private String[] physicalMaximumAux = new String[this.nbAux];
        private String[] digitalMinimumAux = new String[this.nbAux];
        private String[] digitalMaximumAux = new String[this.nbAux];
        private String[] prefilteringAux = new String[this.nbAux];
        private String[] nbSamplesPerDataRecordAux = new String[this.nbAux];
        private String[] reservedAux = new String[this.nbAux];
        private String[] labelsEEG = new String[this.nbChan];
        private String[] transducerEEG = new String[this.nbChan];
        private String[] physicalDimensionEEG = new String[this.nbChan];
        private String[] physicalMinimumEEG = new String[this.nbChan];
        private String[] physicalMaximumEEG = new String[this.nbChan];
        private String[] digitalMinimumEEG = new String[this.nbChan];
        private String[] digitalMaximumEEG = new String[this.nbChan];
        private String[] prefilteringEEG = new String[this.nbChan];
        private String[] nbSamplesPerDataRecordEEG = new String[this.nbChan];
        private String[] reservedEEG = new String[this.nbChan];
        private String tempWriterPrefix = "temp.txt";
        private int fs_Hz = 250;
        private int accel_Hz = 25;
        private int samplesInDataRecord = 0;
        private int dataRecordsWritten = 0;
        private Date startTime;
        private boolean startTimeCaptured = false;
        private int timeDataRecordStart = 0;
        private byte[][][] auxValBuf;
        private byte[][][] auxValBuf_buffer;
        private byte[][][] chanValBuf;
        private byte[][][] chanValBuf_buffer;
        public String fname = "";
        public int nbSamplesPerAnnontation = 20;
        public DataPacket_ADS1299 data_t;

        OutputFile_BDF(float _fs_Hz, int _nbChan) {
            this.fname = this.getFileName();
            this.fs_Hz = (int)_fs_Hz;
            this.nbChan = _nbChan;
            this.init();
        }

        OutputFile_BDF(float _fs_Hz, int _nbChan, String _fileName) {
            this.fname = this.getFileName(_fileName);
            this.fs_Hz = (int)_fs_Hz;
            this.nbChan = _nbChan;
            this.init();
        }

        private void init() {
            this.setNbAnnotations(this.nbAnnotations);
            this.setNbAux(this.nbAux);
            this.setNbChan(this.nbChan);
            this.auxValBuf = new byte[this.nbAux][this.fs_Hz][this.sampleSize];
            this.auxValBuf_buffer = new byte[this.nbAux][this.fs_Hz][this.sampleSize];
            this.chanValBuf = new byte[this.nbChan][this.fs_Hz][this.sampleSize];
            this.chanValBuf_buffer = new byte[this.nbChan][this.fs_Hz][this.sampleSize];
            this.dstream = OpenBCI_GUI.this.createOutput(this.tempWriterPrefix);
            this.dataRecordsWritten = 0;
        }

        public void writeRawData_dataPacket(DataPacket_ADS1299 data) {
            if (!this.startTimeCaptured) {
                this.startTime = new Date();
                this.startTimeCaptured = true;
                this.timeDataRecordStart = OpenBCI_GUI.this.millis();
            }
            this.writeChannelDataValues(data.rawValues);
            if (OpenBCI_GUI.this.eegDataSource == 0) {
                this.writeAuxDataValues(data.rawAuxValues);
            }
            ++this.samplesInDataRecord;
            if (this.samplesInDataRecord >= this.fs_Hz) {
                OpenBCI_GUI.arrayCopy((Object)this.chanValBuf, (Object)this.chanValBuf_buffer);
                if (OpenBCI_GUI.this.eegDataSource == 0) {
                    OpenBCI_GUI.arrayCopy((Object)this.auxValBuf, (Object)this.auxValBuf_buffer);
                }
                this.samplesInDataRecord = 0;
                this.writeDataOut();
            }
        }

        private void writeDataOut() {
            try {
                int lenWritten;
                int k;
                int j;
                int i = 0;
                while (i < this.nbChan) {
                    j = 0;
                    while (j < this.fs_Hz) {
                        k = 0;
                        while (k < 3) {
                            this.dstream.write(this.chanValBuf_buffer[i][j][k]);
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
                if (OpenBCI_GUI.this.eegDataSource == 0) {
                    i = 0;
                    while (i < this.nbAux) {
                        j = 0;
                        while (j < this.fs_Hz) {
                            k = 0;
                            while (k < 3) {
                                this.dstream.write(this.auxValBuf_buffer[i][j][k]);
                                ++k;
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
                this.dstream.write(43);
                String _t = OpenBCI_GUI.str((int)((OpenBCI_GUI.this.millis() - this.timeDataRecordStart) / 1000));
                int strLen = _t.length();
                int i2 = 0;
                while (i2 < strLen) {
                    this.dstream.write(_t.charAt(i2));
                    ++i2;
                }
                this.dstream.write(20);
                this.dstream.write(20);
                int i3 = lenWritten = 1 + strLen + 1 + 1;
                while (i3 < this.nbSamplesPerAnnontation * this.sampleSize) {
                    this.dstream.write(0);
                    ++i3;
                }
                ++this.dataRecordsWritten;
            }
            catch (Exception e) {
                OpenBCI_GUI.println((String)"writeRawData_dataPacket: Exception ");
                e.printStackTrace();
            }
        }

        public void closeFile() {
            OpenBCI_GUI.this.output("Closed the temp data file. Now opening a new file");
            try {
                this.dstream.close();
            }
            catch (Exception e) {
                OpenBCI_GUI.println((String)"closeFile: dstream close exception ");
                e.printStackTrace();
            }
            OpenBCI_GUI.println((String)"closeFile: started...");
            OutputStream o = OpenBCI_GUI.this.createOutput(this.fname);
            OpenBCI_GUI.println((String)"closeFile: made file");
            this.writeHeader(o);
            OpenBCI_GUI.this.output("Header writen, now writing data.");
            OpenBCI_GUI.println((String)"closeFile: wrote header");
            this.writeData(o);
            OpenBCI_GUI.this.output("Data written. Closing new file.");
            OpenBCI_GUI.println((String)"closeFile: wrote data");
        }

        public int getRecordsWritten() {
            return this.dataRecordsWritten;
        }

        public void setAnnotationsArraysToSize(int n) {
            this.labelsAnnotations = new String[n];
            this.transducerAnnotations = new String[n];
            this.physicalDimensionAnnotations = new String[n];
            this.physicalMinimumAnnotations = new String[n];
            this.physicalMaximumAnnotations = new String[n];
            this.digitalMinimumAnnotations = new String[n];
            this.digitalMaximumAnnotations = new String[n];
            this.prefilteringAnnotations = new String[n];
            this.nbSamplesPerDataRecordAnnotations = new String[n];
            this.reservedAnnotations = new String[n];
        }

        public void setAuxArraysToSize(int n) {
            this.labelsAux = new String[n];
            this.transducerAux = new String[n];
            this.physicalDimensionAux = new String[n];
            this.physicalMinimumAux = new String[n];
            this.physicalMaximumAux = new String[n];
            this.digitalMinimumAux = new String[n];
            this.digitalMaximumAux = new String[n];
            this.prefilteringAux = new String[n];
            this.nbSamplesPerDataRecordAux = new String[n];
            this.reservedAux = new String[n];
        }

        public void setEEGArraysToSize(int n) {
            this.labelsEEG = new String[n];
            this.transducerEEG = new String[n];
            this.physicalDimensionEEG = new String[n];
            this.physicalMinimumEEG = new String[n];
            this.physicalMaximumEEG = new String[n];
            this.digitalMinimumEEG = new String[n];
            this.digitalMaximumEEG = new String[n];
            this.prefilteringEEG = new String[n];
            this.nbSamplesPerDataRecordEEG = new String[n];
            this.reservedEEG = new String[n];
        }

        public boolean setEEGLabelForIndex(String s, int index) {
            if (index < this.nbChan) {
                this.labelsEEG[index] = s;
                return true;
            }
            return false;
        }

        public void setNbAnnotations(int n) {
            if (n < 1) {
                n = 1;
            }
            this.nbAnnotations = n;
            this.setAnnotationsArraysToSize(n);
            this.setAnnotationsArraysToDefaults();
        }

        public void setNbAux(int n) {
            if (n < 1) {
                n = 1;
            }
            this.nbAux = n;
            this.setAuxArraysToSize(n);
            this.setAuxArraysToDefaults();
        }

        public void setNbChan(int n) {
            if (n < 1) {
                n = 1;
            }
            this.nbChan = n;
            this.setEEGArraysToSize(n);
            this.setEEGArraysToDefaults();
        }

        public String setPatientIdSex(String s) {
            this.bdf_patient_id_subfield_sex = this.swapSpacesForUnderscores(s);
            return this.bdf_patient_id_subfield_sex;
        }

        public String setPatientIdBirthdate(String s) {
            this.bdf_patient_id_subfield_birthdate = this.swapSpacesForUnderscores(s);
            return this.bdf_patient_id_subfield_birthdate;
        }

        public String setPatientIdName(String s) {
            this.bdf_patient_id_subfield_name = this.swapSpacesForUnderscores(s);
            return this.bdf_patient_id_subfield_name;
        }

        public boolean setEEGPrefilterForIndex(String s, int index) {
            if (index < this.nbChan) {
                this.prefilteringEEG[index] = s;
                return true;
            }
            return false;
        }

        public String setRecordingIdAdminCode(String s) {
            this.bdf_recording_id_subfield_admin_code = this.swapSpacesForUnderscores(s);
            return this.bdf_recording_id_subfield_admin_code;
        }

        public String setRecordingIdInvestigator(String s) {
            this.bdf_recording_id_subfield_investigator = this.swapSpacesForUnderscores(s);
            return this.bdf_recording_id_subfield_investigator;
        }

        public String setRecordingIdEquipment(String s) {
            this.bdf_recording_id_subfield_equipment = this.swapSpacesForUnderscores(s);
            return this.bdf_recording_id_subfield_equipment;
        }

        public boolean setTransducerForIndex(String s, int index) {
            if (index < this.nbChan) {
                this.transducerEEG[index] = s;
                return true;
            }
            return false;
        }

        private String combineStringIntoSizeTimes(String s, int size, int times) {
            String output = "";
            int i = 0;
            while (i < times) {
                output = String.valueOf(output) + this.padStringRight(s, size);
                ++i;
            }
            return output;
        }

        private int getBytesInHeader() {
            return 256 + 256 * this.getNbSignals();
        }

        private String getContinuity() {
            if (this.continuous) {
                return BDF_HEADER_DATA_CONTINUOUS;
            }
            return BDF_HEADER_DATA_DISCONTINUOUS;
        }

        private String getDateString(DateFormat d) {
            return d.format(new Date());
        }

        private String getDateString(Date d, DateFormat df) {
            return df.format(d);
        }

        private String getFileName() {
            String output = "";
            output = String.valueOf(output) + OpenBCI_GUI.year() + "-";
            if (OpenBCI_GUI.month() < 10) {
                output = String.valueOf(output) + "0";
            }
            output = String.valueOf(output) + OpenBCI_GUI.month() + "-";
            if (OpenBCI_GUI.day() < 10) {
                output = String.valueOf(output) + "0";
            }
            output = String.valueOf(output) + OpenBCI_GUI.day();
            output = String.valueOf(output) + "_";
            if (OpenBCI_GUI.hour() < 10) {
                output = String.valueOf(output) + "0";
            }
            output = String.valueOf(output) + OpenBCI_GUI.hour() + "-";
            if (OpenBCI_GUI.minute() < 10) {
                output = String.valueOf(output) + "0";
            }
            output = String.valueOf(output) + OpenBCI_GUI.minute() + "-";
            if (OpenBCI_GUI.second() < 10) {
                output = String.valueOf(output) + "0";
            }
            output = String.valueOf(output) + OpenBCI_GUI.second();
            return this.getFileName(output);
        }

        private String getFileName(String s) {
            String output = "SavedData" + System.getProperty("file.separator") + "OpenBCI-BDF-";
            output = String.valueOf(output) + s;
            output = String.valueOf(output) + ".bdf";
            return output;
        }

        private int getNbSignals() {
            if (OpenBCI_GUI.this.eegDataSource == 0) {
                return this.nbChan + this.nbAux + this.nbAnnotations;
            }
            return this.nbChan + this.nbAnnotations;
        }

        private String joinStringArray(String[] stringArray, String delimiter) {
            String output = "";
            int numberOfElements = stringArray.length;
            int i = 0;
            while (i < numberOfElements) {
                output = String.valueOf(output) + stringArray[i];
                output = String.valueOf(output) + delimiter;
                ++i;
            }
            return output;
        }

        private String padStringRight(String s, int size) {
            char[] output = new char[size];
            int len = 0;
            if (s != null) {
                len = s.length();
            }
            int i = 0;
            while (i < size) {
                output[i] = i < len ? s.charAt(i) : (char)32;
                ++i;
            }
            return new String(output, 0, size);
        }

        private void setAuxArraysToDefaults() {
            this.labelsAux[0] = "Accel X";
            this.labelsAux[1] = "Accel Y";
            this.labelsAux[2] = "Accel Z";
            this.setStringArray(this.transducerAux, BDF_HEADER_TRANSDUCER_MEMS, this.nbAux);
            this.setStringArray(this.physicalDimensionAux, BDF_HEADER_PHYSICAL_DIMENISION_G, this.nbAux);
            this.setStringArray(this.digitalMinimumAux, this.bdf_digital_minimum_ADC_12bit, this.nbAux);
            this.setStringArray(this.digitalMaximumAux, this.bdf_digital_maximum_ADC_12bit, this.nbAux);
            this.setStringArray(this.physicalMinimumAux, this.bdf_physical_minimum_ADC_Accel, this.nbAux);
            this.setStringArray(this.physicalMaximumAux, this.bdf_physical_maximum_ADC_Accel, this.nbAux);
            this.setStringArray(this.prefilteringAux, " ", this.nbAux);
            this.setStringArray(this.nbSamplesPerDataRecordAux, OpenBCI_GUI.str((int)this.fs_Hz), this.nbAux);
            this.setStringArray(this.reservedAux, " ", this.nbAux);
        }

        private void setAnnotationsArraysToDefaults() {
            this.setStringArray(this.labelsAnnotations, BDF_HEADER_ANNOTATIONS, 1);
            this.setStringArray(this.transducerAnnotations, " ", 1);
            this.setStringArray(this.physicalDimensionAnnotations, " ", 1);
            this.setStringArray(this.digitalMinimumAnnotations, this.bdf_digital_minimum_ADC_24bit, 1);
            this.setStringArray(this.digitalMaximumAnnotations, this.bdf_digital_maximum_ADC_24bit, 1);
            if (OpenBCI_GUI.this.eegDataSource == 1) {
                this.setStringArray(this.physicalMinimumAnnotations, this.bdf_physical_minimum_ADC_24bit_ganglion, 1);
                this.setStringArray(this.physicalMaximumAnnotations, this.bdf_physical_maximum_ADC_24bit_ganglion, 1);
            } else {
                this.setStringArray(this.physicalMinimumAnnotations, this.bdf_physical_minimum_ADC_24bit, 1);
                this.setStringArray(this.physicalMaximumAnnotations, this.bdf_physical_maximum_ADC_24bit, 1);
            }
            this.setStringArray(this.prefilteringAnnotations, " ", 1);
            this.nbSamplesPerDataRecordAnnotations[0] = OpenBCI_GUI.str((int)this.nbSamplesPerAnnontation);
            this.setStringArray(this.reservedAnnotations, " ", 1);
        }

        private void setEEGArraysToDefaults() {
            int i = 1;
            while (i <= this.nbChan) {
                this.labelsEEG[i - 1] = "EEG " + i;
                ++i;
            }
            this.setStringArray(this.transducerEEG, BDF_HEADER_TRANSDUCER_AGAGCL, this.nbChan);
            this.setStringArray(this.physicalDimensionEEG, BDF_HEADER_PHYSICAL_DIMENISION_UV, this.nbChan);
            this.setStringArray(this.digitalMinimumEEG, this.bdf_digital_minimum_ADC_24bit, this.nbChan);
            this.setStringArray(this.digitalMaximumEEG, this.bdf_digital_maximum_ADC_24bit, this.nbChan);
            this.setStringArray(this.physicalMinimumEEG, this.bdf_physical_minimum_ADC_24bit, this.nbChan);
            this.setStringArray(this.physicalMaximumEEG, this.bdf_physical_maximum_ADC_24bit, this.nbChan);
            this.setStringArray(this.prefilteringEEG, " ", this.nbChan);
            this.setStringArray(this.nbSamplesPerDataRecordEEG, OpenBCI_GUI.str((int)this.fs_Hz), this.nbChan);
            this.setStringArray(this.reservedEEG, " ", this.nbChan);
        }

        private void setStringArray(String[] arr, String val, int len) {
            int i = 0;
            while (i < len) {
                arr[i] = val;
                ++i;
            }
        }

        private byte swapByte(byte val) {
            int mask = 128;
            int res = 0;
            int i = 0;
            while (i < 8) {
                int temp = val & mask;
                res = res >> 1 | temp << i;
                mask >>= 1;
                ++i;
            }
            return (byte)res;
        }

        private String swapSpacesForUnderscores(String s) {
            int len = s.length();
            char[] output = new char[len];
            int i = 0;
            while (i < len) {
                output[i] = s.charAt(i) == ' ' ? 95 : s.charAt(i);
                ++i;
            }
            return new String(output, 0, len);
        }

        private void writeChannelDataValues(byte[][] values) {
            int i = 0;
            while (i < this.nbChan) {
                this.chanValBuf[i][this.samplesInDataRecord][0] = this.swapByte(values[i][2]);
                this.chanValBuf[i][this.samplesInDataRecord][1] = this.swapByte(values[i][1]);
                this.chanValBuf[i][this.samplesInDataRecord][2] = this.swapByte(values[i][0]);
                ++i;
            }
        }

        private void writeAuxDataValues(byte[][] values) {
            int i = 0;
            while (i < this.nbAux) {
                if (this.write_accel) {
                    boolean zeroPack = true;
                    int t = values[i][0] & 0xF;
                    values[i][0] = (byte)(values[i][0] >> 4);
                    if (values[i][0] >= 8) {
                        zeroPack = false;
                    }
                    values[i][1] = (byte)(values[i][1] >> 4);
                    values[i][1] = (byte)(values[i][1] | t);
                    if (!zeroPack) {
                        values[i][0] = (byte)(values[i][0] | 0xF0);
                    }
                    this.auxValBuf[i][this.samplesInDataRecord][0] = this.swapByte(values[i][1]);
                    this.auxValBuf[i][this.samplesInDataRecord][1] = this.swapByte(values[i][0]);
                    this.auxValBuf[i][this.samplesInDataRecord][2] = zeroPack ? 0 : -1;
                }
                ++i;
            }
        }

        private void writeData(OutputStream o) {
            InputStream input = OpenBCI_GUI.this.createInput(this.tempWriterPrefix);
            try {
                try {
                    OpenBCI_GUI.println((String)"writeData: started...");
                    int data = input.read();
                    int byteCount = 0;
                    while (data != -1) {
                        o.write(data);
                        data = input.read();
                        ++byteCount;
                    }
                    OpenBCI_GUI.println((String)("writeData: finished: wrote " + byteCount + " bytes"));
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        input.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    input.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        private void writeHeader(OutputStream o) {
            try {
                o.write(255);
                this.writeString(this.padStringRight(new String(this.bdf_version), 7), o);
                String[] temp1 = new String[]{this.bdf_patient_id_subfield_hospoital_code, this.bdf_patient_id_subfield_sex, this.bdf_patient_id_subfield_birthdate, this.bdf_patient_id_subfield_name};
                this.writeString(this.padStringRight(this.joinStringArray(temp1, " "), 80), o);
                String[] temp2 = new String[]{this.bdf_recording_id_subfield_prefix, this.bdf_recording_id_subfield_startdate, this.bdf_recording_id_subfield_admin_code, this.bdf_recording_id_subfield_investigator, this.bdf_recording_id_subfield_equipment};
                this.writeString(this.padStringRight(this.joinStringArray(temp2, " "), 80), o);
                this.writeString(this.getDateString(this.startTime, this.startDateFormat), o);
                this.writeString(this.getDateString(this.startTime, this.startTimeFormat), o);
                this.writeString(this.padStringRight(OpenBCI_GUI.str((int)this.getBytesInHeader()), 8), o);
                this.writeString(this.padStringRight("24BIT", 44), o);
                this.writeString(this.padStringRight(OpenBCI_GUI.str((int)this.dataRecordsWritten), 8), o);
                this.writeString(this.padStringRight("1", 8), o);
                this.writeString(this.padStringRight(OpenBCI_GUI.str((int)this.getNbSignals()), 4), o);
                this.writeStringArrayWithPaddingTimes(this.labelsEEG, 16, o);
                if (OpenBCI_GUI.this.eegDataSource == 0) {
                    this.writeStringArrayWithPaddingTimes(this.labelsAux, 16, o);
                }
                this.writeStringArrayWithPaddingTimes(this.labelsAnnotations, 16, o);
                this.writeStringArrayWithPaddingTimes(this.transducerEEG, 80, o);
                if (OpenBCI_GUI.this.eegDataSource == 0) {
                    this.writeStringArrayWithPaddingTimes(this.transducerAux, 80, o);
                }
                this.writeStringArrayWithPaddingTimes(this.transducerAnnotations, 80, o);
                this.writeStringArrayWithPaddingTimes(this.physicalDimensionEEG, 8, o);
                if (OpenBCI_GUI.this.eegDataSource == 0) {
                    this.writeStringArrayWithPaddingTimes(this.physicalDimensionAux, 8, o);
                }
                this.writeStringArrayWithPaddingTimes(this.physicalDimensionAnnotations, 8, o);
                this.writeStringArrayWithPaddingTimes(this.physicalMinimumEEG, 8, o);
                if (OpenBCI_GUI.this.eegDataSource == 0) {
                    this.writeStringArrayWithPaddingTimes(this.physicalMinimumAux, 8, o);
                }
                this.writeStringArrayWithPaddingTimes(this.physicalMinimumAnnotations, 8, o);
                this.writeStringArrayWithPaddingTimes(this.physicalMaximumEEG, 8, o);
                if (OpenBCI_GUI.this.eegDataSource == 0) {
                    this.writeStringArrayWithPaddingTimes(this.physicalMaximumAux, 8, o);
                }
                this.writeStringArrayWithPaddingTimes(this.physicalMaximumAnnotations, 8, o);
                this.writeStringArrayWithPaddingTimes(this.digitalMinimumEEG, 8, o);
                if (OpenBCI_GUI.this.eegDataSource == 0) {
                    this.writeStringArrayWithPaddingTimes(this.digitalMinimumAux, 8, o);
                }
                this.writeStringArrayWithPaddingTimes(this.digitalMinimumAnnotations, 8, o);
                this.writeStringArrayWithPaddingTimes(this.digitalMaximumEEG, 8, o);
                if (OpenBCI_GUI.this.eegDataSource == 0) {
                    this.writeStringArrayWithPaddingTimes(this.digitalMaximumAux, 8, o);
                }
                this.writeStringArrayWithPaddingTimes(this.digitalMaximumAnnotations, 8, o);
                this.writeStringArrayWithPaddingTimes(this.prefilteringEEG, 80, o);
                if (OpenBCI_GUI.this.eegDataSource == 0) {
                    this.writeStringArrayWithPaddingTimes(this.prefilteringAux, 80, o);
                }
                this.writeStringArrayWithPaddingTimes(this.prefilteringAnnotations, 80, o);
                this.writeStringArrayWithPaddingTimes(this.nbSamplesPerDataRecordEEG, 8, o);
                if (OpenBCI_GUI.this.eegDataSource == 0) {
                    this.writeStringArrayWithPaddingTimes(this.nbSamplesPerDataRecordAux, 8, o);
                }
                this.writeStringArrayWithPaddingTimes(this.nbSamplesPerDataRecordAnnotations, 8, o);
                this.writeStringArrayWithPaddingTimes(this.reservedEEG, 32, o);
                if (OpenBCI_GUI.this.eegDataSource == 0) {
                    this.writeStringArrayWithPaddingTimes(this.reservedAux, 32, o);
                }
                this.writeStringArrayWithPaddingTimes(this.reservedAnnotations, 32, o);
            }
            catch (Exception e) {
                OpenBCI_GUI.println((String)("writeHeader: Exception " + e));
            }
        }

        private void writeStringArrayWithPaddingTimes(String[] arr, int padding, OutputStream o) {
            int len = arr.length;
            int i = 0;
            while (i < len) {
                this.writeString(this.padStringRight(arr[i], padding), o);
                ++i;
            }
        }

        private void writeString(String s, OutputStream o) {
            int len = s.length();
            try {
                int i = 0;
                while (i < len) {
                    o.write(s.charAt(i));
                    ++i;
                }
            }
            catch (Exception e) {
                OpenBCI_GUI.println((String)("writeString: exception: " + e));
            }
        }
    }

    public class OutputFile_rawtxt {
        PrintWriter output;
        String fname = "SavedData" + System.getProperty("file.separator") + "OpenBCI-RAW-";
        private int rowsWritten;

        OutputFile_rawtxt(float fs_Hz) {
            this.fname = String.valueOf(this.fname) + OpenBCI_GUI.year() + "-";
            if (OpenBCI_GUI.month() < 10) {
                this.fname = String.valueOf(this.fname) + "0";
            }
            this.fname = String.valueOf(this.fname) + OpenBCI_GUI.month() + "-";
            if (OpenBCI_GUI.day() < 10) {
                this.fname = String.valueOf(this.fname) + "0";
            }
            this.fname = String.valueOf(this.fname) + OpenBCI_GUI.day();
            this.fname = String.valueOf(this.fname) + "_";
            if (OpenBCI_GUI.hour() < 10) {
                this.fname = String.valueOf(this.fname) + "0";
            }
            this.fname = String.valueOf(this.fname) + OpenBCI_GUI.hour() + "-";
            if (OpenBCI_GUI.minute() < 10) {
                this.fname = String.valueOf(this.fname) + "0";
            }
            this.fname = String.valueOf(this.fname) + OpenBCI_GUI.minute() + "-";
            if (OpenBCI_GUI.second() < 10) {
                this.fname = String.valueOf(this.fname) + "0";
            }
            this.fname = String.valueOf(this.fname) + OpenBCI_GUI.second();
            this.fname = String.valueOf(this.fname) + ".txt";
            this.output = OpenBCI_GUI.this.createWriter(this.fname);
            this.writeHeader(fs_Hz);
            this.rowsWritten = 0;
        }

        OutputFile_rawtxt(float fs_Hz, String _fileName) {
            this.fname = String.valueOf(this.fname) + _fileName;
            this.fname = String.valueOf(this.fname) + ".txt";
            this.output = OpenBCI_GUI.this.createWriter(this.fname);
            this.writeHeader(fs_Hz);
            this.rowsWritten = 0;
        }

        public void writeHeader(float fs_Hz) {
            this.output.println("%OpenBCI Raw EEG Data");
            this.output.println("%");
            this.output.println("%Sample Rate = " + fs_Hz + " Hz");
            this.output.println("%First Column = SampleIndex");
            this.output.println("%Last Column = Timestamp ");
            this.output.println("%Other Columns = EEG data in microvolts followed by Accel Data (in G) interleaved with Aux Data");
            this.output.flush();
        }

        public void writeRawData_dataPacket(DataPacket_ADS1299 data, float scale_to_uV, float scale_for_aux, int stopByte) {
            Date date = new Date();
            if (this.output != null) {
                this.output.print(Integer.toString(data.sampleIndex));
                this.writeValues(data.values, scale_to_uV);
                if (OpenBCI_GUI.this.eegDataSource == 1) {
                    this.writeAccValues(data.auxValues, scale_for_aux);
                } else if (stopByte == 193) {
                    this.writeAuxValues(data);
                } else {
                    this.writeAccValues(data.auxValues, scale_for_aux);
                }
                this.output.print(", " + OpenBCI_GUI.this.dateFormat.format(date));
                this.output.println();
                ++this.rowsWritten;
            }
        }

        private void writeValues(int[] values, float scale_fac) {
            int nVal = values.length;
            int Ival = 0;
            while (Ival < nVal) {
                this.output.print(", ");
                this.output.print(String.format(Locale.US, "%.2f", Float.valueOf(scale_fac * PApplet.parseFloat((int)values[Ival]))));
                ++Ival;
            }
        }

        private void writeAccValues(int[] values, float scale_fac) {
            int nVal = values.length;
            int Ival = 0;
            while (Ival < nVal) {
                this.output.print(", ");
                this.output.print(String.format(Locale.US, "%.3f", Float.valueOf(scale_fac * PApplet.parseFloat((int)values[Ival]))));
                ++Ival;
            }
        }

        private void writeAuxValues(DataPacket_ADS1299 data) {
            block8: {
                block6: {
                    block10: {
                        block9: {
                            block7: {
                                if (OpenBCI_GUI.this.eegDataSource != 0) break block6;
                                if (OpenBCI_GUI.this.cyton.getBoardMode() != 3) break block7;
                                if (OpenBCI_GUI.this.cyton.isWifi()) {
                                    this.output.print(", " + ((data.auxValues[0] & 0xFF00) >> 8));
                                    this.output.print(", " + (data.auxValues[0] & 0xFF));
                                    this.output.print(", " + data.auxValues[1]);
                                } else {
                                    this.output.print(", " + ((data.auxValues[0] & 0xFF00) >> 8));
                                    this.output.print(", " + (data.auxValues[0] & 0xFF));
                                    this.output.print(", " + ((data.auxValues[1] & 0xFF00) >> 8));
                                    this.output.print(", " + (data.auxValues[1] & 0xFF));
                                    this.output.print(", " + data.auxValues[2]);
                                }
                                break block8;
                            }
                            if (OpenBCI_GUI.this.cyton.getBoardMode() != 2) break block9;
                            if (OpenBCI_GUI.this.cyton.isWifi()) {
                                this.output.print(", " + data.auxValues[0]);
                                this.output.print(", " + data.auxValues[1]);
                            } else {
                                this.output.print(", " + data.auxValues[0]);
                                this.output.print(", " + data.auxValues[1]);
                                this.output.print(", " + data.auxValues[2]);
                            }
                            break block8;
                        }
                        if (OpenBCI_GUI.this.cyton.getBoardMode() != 4) break block10;
                        this.output.print(", " + data.auxValues[0]);
                        if (data.auxValues[0] <= 0) break block8;
                        OpenBCI_GUI.this.hub.validLastMarker = data.auxValues[0];
                        break block8;
                    }
                    int Ival = 0;
                    while (Ival < 3) {
                        this.output.print(", " + data.auxValues[Ival]);
                        ++Ival;
                    }
                    break block8;
                }
                int i = 0;
                while (i < 3) {
                    this.output.print(", " + (data.auxValues[i] & 0xFF));
                    this.output.print(", " + ((data.auxValues[i] & 0xFF00) >> 8));
                    ++i;
                }
            }
        }

        public void closeFile() {
            this.output.flush();
            this.output.close();
        }

        public int getRowsWritten() {
            return this.rowsWritten;
        }
    }

    class PlaybackChannelCountBox {
        int x;
        int y;
        int w;
        int h;
        int padding;
        boolean isSystemInitialized;

        PlaybackChannelCountBox(int _x, int _y, int _w, int _h, int _padding) {
            this.x = _x;
            this.y = _y;
            this.w = _w;
            this.h = 73;
            this.padding = _padding;
            OpenBCI_GUI.this.playbackChanButton4 = new Button(this.x + this.padding, this.y + this.padding * 2 + 18, (this.w - this.padding * 4) / 3, 24, "4 chan", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
            if (OpenBCI_GUI.this.nchan == 4) {
                OpenBCI_GUI.this.playbackChanButton4.color_notPressed = OpenBCI_GUI.this.isSelected_color;
            }
            OpenBCI_GUI.this.playbackChanButton8 = new Button(this.x + this.padding * 2 + (this.w - this.padding * 4) / 3, this.y + this.padding * 2 + 18, (this.w - this.padding * 4) / 3, 24, "8 chan", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
            if (OpenBCI_GUI.this.nchan == 8) {
                OpenBCI_GUI.this.playbackChanButton8.color_notPressed = OpenBCI_GUI.this.isSelected_color;
            }
            OpenBCI_GUI.this.playbackChanButton16 = new Button(this.x + this.padding * 3 + (this.w - this.padding * 4) / 3 * 2, this.y + this.padding * 2 + 18, (this.w - this.padding * 4) / 3, 24, "16 chan", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
            if (OpenBCI_GUI.this.nchan == 16) {
                OpenBCI_GUI.this.playbackChanButton16.color_notPressed = OpenBCI_GUI.this.isSelected_color;
            }
        }

        public void update() {
        }

        public void draw() {
            OpenBCI_GUI.this.pushStyle();
            OpenBCI_GUI.this.fill(OpenBCI_GUI.this.boxColor);
            OpenBCI_GUI.this.stroke(OpenBCI_GUI.this.boxStrokeColor);
            OpenBCI_GUI.this.strokeWeight(1.0f);
            OpenBCI_GUI.this.rect(this.x, this.y, this.w, this.h);
            OpenBCI_GUI.this.fill(OpenBCI_GUI.this.bgColor);
            OpenBCI_GUI.this.textFont(OpenBCI_GUI.this.h3, 16.0f);
            OpenBCI_GUI.this.textAlign(37, 101);
            OpenBCI_GUI.this.text("CHANNEL COUNT", this.x + this.padding, this.y + this.padding);
            OpenBCI_GUI.this.fill(OpenBCI_GUI.this.bgColor);
            OpenBCI_GUI.this.textFont(OpenBCI_GUI.this.h3, 16.0f);
            OpenBCI_GUI.this.textAlign(37, 101);
            OpenBCI_GUI.this.text("  (" + OpenBCI_GUI.str((int)OpenBCI_GUI.this.nchan) + ")", this.x + this.padding + 142, this.y + this.padding);
            OpenBCI_GUI.this.popStyle();
            OpenBCI_GUI.this.playbackChanButton4.draw();
            OpenBCI_GUI.this.playbackChanButton8.draw();
            OpenBCI_GUI.this.playbackChanButton16.draw();
        }
    }

    class PlaybackFileBox {
        int x;
        int y;
        int w;
        int h;
        int padding;

        PlaybackFileBox(int _x, int _y, int _w, int _h, int _padding) {
            this.x = _x;
            this.y = _y;
            this.w = _w;
            this.h = 67;
            this.padding = _padding;
            OpenBCI_GUI.this.selectPlaybackFile = new Button(this.x + this.padding, this.y + this.padding * 2 + 13, this.w - this.padding * 2, 24, "SELECT PLAYBACK FILE", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
        }

        public void update() {
        }

        public void draw() {
            OpenBCI_GUI.this.pushStyle();
            OpenBCI_GUI.this.fill(OpenBCI_GUI.this.boxColor);
            OpenBCI_GUI.this.stroke(OpenBCI_GUI.this.boxStrokeColor);
            OpenBCI_GUI.this.strokeWeight(1.0f);
            OpenBCI_GUI.this.rect(this.x, this.y, this.w, this.h);
            OpenBCI_GUI.this.fill(OpenBCI_GUI.this.bgColor);
            OpenBCI_GUI.this.textFont(OpenBCI_GUI.this.h3, 16.0f);
            OpenBCI_GUI.this.textAlign(37, 101);
            OpenBCI_GUI.this.text("PLAYBACK FILE", this.x + this.padding, this.y + this.padding);
            OpenBCI_GUI.this.popStyle();
            OpenBCI_GUI.this.selectPlaybackFile.draw();
        }
    }

    class PlaybackScrollbar {
        int swidth;
        int sheight;
        float xpos;
        float ypos;
        float spos;
        float newspos;
        float sposMin;
        float sposMax;
        boolean over;
        boolean locked;
        float ratio;
        int num_indices;

        PlaybackScrollbar(float xp, float yp, int sw, int sh, int is) {
            this.swidth = sw;
            this.sheight = sh;
            int widthtoheight = sw - sh;
            this.ratio = (float)sw / (float)widthtoheight;
            this.xpos = xp;
            this.ypos = yp - (float)(this.sheight / 2);
            this.newspos = this.spos = this.xpos;
            this.sposMin = this.xpos;
            this.sposMax = this.xpos + (float)this.swidth - (float)(this.sheight / 2);
            this.num_indices = is;
        }

        public void update() {
            this.over = this.overEvent();
            if (OpenBCI_GUI.this.mousePressed && this.over) {
                this.locked = true;
            }
            if (!OpenBCI_GUI.this.mousePressed) {
                this.locked = false;
            }
            if (this.locked) {
                this.newspos = this.constrain(OpenBCI_GUI.this.mouseX - this.sheight / 2, this.sposMin, this.sposMax);
            }
            if (OpenBCI_GUI.abs((float)(this.newspos - this.spos)) > 1.0f) {
                this.spos += this.newspos - this.spos;
            }
        }

        public float constrain(float val, float minv, float maxv) {
            return OpenBCI_GUI.min((float)OpenBCI_GUI.max((float)val, (float)minv), (float)maxv);
        }

        public boolean overEvent() {
            if ((float)OpenBCI_GUI.this.mouseX > this.xpos && (float)OpenBCI_GUI.this.mouseX < this.xpos + (float)this.swidth && (float)OpenBCI_GUI.this.mouseY > this.ypos && (float)OpenBCI_GUI.this.mouseY < this.ypos + (float)this.sheight) {
                OpenBCI_GUI.this.cursor(12);
                return true;
            }
            OpenBCI_GUI.this.cursor(0);
            return false;
        }

        public int get_index() {
            float seperate_val = this.sposMax / (float)this.num_indices;
            int index = 0;
            while (index < this.num_indices + 1) {
                if (this.getPos() >= seperate_val * (float)index && this.getPos() <= seperate_val * (float)(index + 1)) {
                    return index;
                }
                if (index == this.num_indices && this.getPos() >= seperate_val * (float)index) {
                    return this.num_indices;
                }
                ++index;
            }
            return -1;
        }

        public void display() {
            OpenBCI_GUI.this.noStroke();
            OpenBCI_GUI.this.fill(204);
            OpenBCI_GUI.this.rect(this.xpos, this.ypos, this.swidth, this.sheight);
            if (this.over || this.locked) {
                OpenBCI_GUI.this.fill(0.0f, 0.0f, 0.0f);
            } else {
                OpenBCI_GUI.this.fill(102.0f, 102.0f, 102.0f);
            }
            OpenBCI_GUI.this.rect(this.spos, this.ypos, this.sheight / 2, this.sheight);
        }

        public float getPos() {
            return this.spos * this.ratio;
        }
    }

    class Playground {
        float x;
        float y;
        float w;
        float h;
        int boxBG;
        int strokeColor;
        float topMargin;
        float bottomMargin;
        boolean isOpen;
        boolean collapsing;
        Button collapser;

        Playground(int _topMargin) {
            this.topMargin = _topMargin;
            this.bottomMargin = OpenBCI_GUI.this.helpWidget.h;
            this.isOpen = false;
            this.collapsing = true;
            this.boxBG = OpenBCI_GUI.this.color(255);
            this.strokeColor = OpenBCI_GUI.this.color(138, 146, 153);
            this.collapser = new Button(0, 0, 20, 60, "<", 14);
            this.x = OpenBCI_GUI.this.width;
            this.y = this.topMargin;
            this.w = 0.0f;
            this.h = (float)OpenBCI_GUI.this.height - (this.topMargin + this.bottomMargin);
        }

        public void update() {
            if (this.collapsing) {
                this.collapse();
            } else {
                this.expand();
            }
            if (this.x > (float)OpenBCI_GUI.this.width) {
                this.x = OpenBCI_GUI.this.width;
            }
        }

        public void draw() {
            OpenBCI_GUI.this.pushStyle();
            OpenBCI_GUI.this.fill(this.boxBG);
            OpenBCI_GUI.this.stroke(this.strokeColor);
            OpenBCI_GUI.this.rect((float)OpenBCI_GUI.this.width - this.w, this.topMargin, this.w, (float)OpenBCI_GUI.this.height - (this.topMargin + this.bottomMargin));
            OpenBCI_GUI.this.textFont(OpenBCI_GUI.this.f1);
            OpenBCI_GUI.this.textAlign(37, 101);
            OpenBCI_GUI.this.fill(OpenBCI_GUI.this.bgColor);
            OpenBCI_GUI.this.text("Developer Playground", this.x + 10.0f, this.y + 10.0f);
            OpenBCI_GUI.this.fill(255.0f, 0.0f, 0.0f);
            OpenBCI_GUI.this.popStyle();
        }

        public boolean isMouseHere() {
            return (float)OpenBCI_GUI.this.mouseX >= this.x && OpenBCI_GUI.this.mouseX <= OpenBCI_GUI.this.width && (float)OpenBCI_GUI.this.mouseY >= this.y && (float)OpenBCI_GUI.this.mouseY <= (float)OpenBCI_GUI.this.height - this.bottomMargin;
        }

        public boolean isMouseInButton() {
            return OpenBCI_GUI.this.mouseX >= this.collapser.but_x && OpenBCI_GUI.this.mouseX <= this.collapser.but_x + this.collapser.but_dx && OpenBCI_GUI.this.mouseY >= this.collapser.but_y && OpenBCI_GUI.this.mouseY <= this.collapser.but_y + this.collapser.but_dy;
        }

        public void toggleWindow() {
        }

        public void mousePressed() {
        }

        public void mouseReleased() {
        }

        public void expand() {
            if (this.w <= (float)(OpenBCI_GUI.this.width / 3)) {
                this.w += 50.0f;
                this.x = (float)OpenBCI_GUI.this.width - this.w;
            }
        }

        public void collapse() {
            if (this.w >= 0.0f) {
                this.w -= 50.0f;
                this.x = (float)OpenBCI_GUI.this.width - this.w;
            }
        }
    }

    class PlotFontInfo {
        String fontName = "fonts/Raleway-Regular.otf";
        int axisLabel_size = 16;
        int tickLabel_size = 14;
        int buttonLabel_size = 12;

        PlotFontInfo() {
        }
    }

    class PollPopup {
        int x;
        int y;
        int w;
        int h;
        int padding;
        boolean clicked;

        PollPopup(int _x, int _y, int _w, int _h, int _padding) {
            this.x = _x + _w * 2;
            this.y = _y;
            this.w = _w;
            this.h = 171 + _padding;
            this.padding = _padding;
            this.clicked = false;
            OpenBCI_GUI.this.pollList = new MenuList(OpenBCI_GUI.this.cp5Popup, "pollList", this.w - this.padding * 2, 140, OpenBCI_GUI.this.p4);
            OpenBCI_GUI.this.pollList.setPosition(this.x + this.padding, this.y + this.padding * 3);
            int i = 0;
            while (i < 256) {
                OpenBCI_GUI.this.pollList.addItem(OpenBCI_GUI.this.makeItem(String.valueOf(i)));
                ++i;
            }
        }

        public void update() {
        }

        public void draw() {
            OpenBCI_GUI.this.pushStyle();
            OpenBCI_GUI.this.fill(OpenBCI_GUI.this.boxColor);
            OpenBCI_GUI.this.stroke(OpenBCI_GUI.this.boxStrokeColor);
            OpenBCI_GUI.this.strokeWeight(1.0f);
            OpenBCI_GUI.this.rect(this.x, this.y, this.w, this.h);
            OpenBCI_GUI.this.fill(OpenBCI_GUI.this.bgColor);
            OpenBCI_GUI.this.textFont(OpenBCI_GUI.this.h3, 16.0f);
            OpenBCI_GUI.this.textAlign(37, 101);
            OpenBCI_GUI.this.text("POLL SELECTION", this.x + this.padding, this.y + this.padding);
            OpenBCI_GUI.this.popStyle();
            OpenBCI_GUI.this.refreshPort.draw();
        }

        public void setClicked(boolean click) {
            this.clicked = click;
        }

        public boolean wasClicked() {
            return this.clicked;
        }
    }

    class Presentation {
        int slideCount = 4;
        PImage[] presentationSlides = new PImage[this.slideCount];
        float timeOfLastSlideChange = 0.0f;
        int currentSlide = 0;
        boolean lockSlides = false;

        Presentation() {
            OpenBCI_GUI.println((String)"attempting to load images for presentation...");
            this.presentationSlides[0] = OpenBCI_GUI.this.loadImage("prez-images/Presentation.000.jpg");
            this.presentationSlides[1] = OpenBCI_GUI.this.loadImage("prez-images/Presentation.001.jpg");
            this.presentationSlides[2] = OpenBCI_GUI.this.loadImage("prez-images/Presentation.002.jpg");
            this.presentationSlides[3] = OpenBCI_GUI.this.loadImage("prez-images/Presentation.003.jpg");
            OpenBCI_GUI.println((String)"DONE loading images!");
        }

        public void slideForward() {
            if (this.currentSlide < this.slideCount - 1 && OpenBCI_GUI.this.drawPresentation && !this.lockSlides) {
                OpenBCI_GUI.println((String)"Slide Forward!");
                ++this.currentSlide;
            } else {
                OpenBCI_GUI.println((String)"No more slides. Can't go forward...");
            }
        }

        public void slideBack() {
            if (this.currentSlide > 0 && OpenBCI_GUI.this.drawPresentation && !this.lockSlides) {
                OpenBCI_GUI.println((String)"Slide Back!");
                --this.currentSlide;
            } else {
                OpenBCI_GUI.println((String)"On the first slide. Can't go back...");
            }
        }

        public void draw() {
            OpenBCI_GUI.this.pushStyle();
            OpenBCI_GUI.this.image(this.presentationSlides[this.currentSlide], 0.0f, 0.0f, OpenBCI_GUI.this.width, OpenBCI_GUI.this.height);
            if (this.lockSlides) {
                OpenBCI_GUI.this.pushStyle();
                OpenBCI_GUI.this.fill(255.0f, 0.0f, 0.0f);
                OpenBCI_GUI.this.rect(OpenBCI_GUI.this.width - 50, 25.0f, 25.0f, 25.0f);
                OpenBCI_GUI.this.popStyle();
            }
            OpenBCI_GUI.this.textFont(OpenBCI_GUI.this.p3, 16.0f);
            OpenBCI_GUI.this.fill(OpenBCI_GUI.this.openbciBlue);
            OpenBCI_GUI.this.textAlign(3);
            OpenBCI_GUI.this.text("Press [Enter] to exit presentation mode.", OpenBCI_GUI.this.width / 2, 31 * (OpenBCI_GUI.this.height / 32));
            OpenBCI_GUI.this.popStyle();
        }
    }

    class RadioConfigBox {
        int x;
        int y;
        int w;
        int h;
        int padding;
        String last_message = "";
        Serial board;
        boolean isShowing;

        RadioConfigBox(int _x, int _y, int _w, int _h, int _padding) {
            this.x = _x + _w;
            this.y = _y;
            this.w = _w;
            this.h = 255;
            this.padding = _padding;
            this.isShowing = false;
            OpenBCI_GUI.this.getChannel = new Button(this.x + this.padding, this.y + this.padding * 2 + 18, (this.w - this.padding * 3) / 2, 24, "GET CHANNEL", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
            OpenBCI_GUI.this.systemStatus = new Button(this.x + 2 * this.padding + (this.w - this.padding * 3) / 2, this.y + this.padding * 2 + 18, (this.w - this.padding * 3) / 2, 24, "STATUS", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
            OpenBCI_GUI.this.setChannel = new Button(this.x + this.padding, this.y + this.padding * 3 + 18 + 24, (this.w - this.padding * 3) / 2, 24, "CHANGE CHAN.", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
            OpenBCI_GUI.this.autoscan = new Button(this.x + 2 * this.padding + (this.w - this.padding * 3) / 2, this.y + this.padding * 3 + 18 + 24, (this.w - this.padding * 3) / 2, 24, "AUTOSCAN", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
            OpenBCI_GUI.this.ovrChannel = new Button(this.x + this.padding, this.y + this.padding * 4 + 18 + 48, this.w - this.padding * 2, 24, "OVERRIDE DONGLE", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
            OpenBCI_GUI.this.getChannel.setHelpText("Get the current channel of your Cyton and USB Dongle");
            OpenBCI_GUI.this.setChannel.setHelpText("Change the channel of your Cyton and USB Dongle");
            OpenBCI_GUI.this.ovrChannel.setHelpText("Change the channel of the USB Dongle only");
            OpenBCI_GUI.this.autoscan.setHelpText("Scan through channels and connect to a nearby Cyton");
            OpenBCI_GUI.this.systemStatus.setHelpText("Get the connection status of your Cyton system");
        }

        public void update() {
        }

        public void draw() {
            OpenBCI_GUI.this.pushStyle();
            OpenBCI_GUI.this.fill(OpenBCI_GUI.this.boxColor);
            OpenBCI_GUI.this.stroke(OpenBCI_GUI.this.boxStrokeColor);
            OpenBCI_GUI.this.strokeWeight(1.0f);
            OpenBCI_GUI.this.rect(this.x, this.y, this.w, this.h);
            OpenBCI_GUI.this.fill(OpenBCI_GUI.this.bgColor);
            OpenBCI_GUI.this.textFont(OpenBCI_GUI.this.h3, 16.0f);
            OpenBCI_GUI.this.textAlign(37, 101);
            OpenBCI_GUI.this.text("RADIO CONFIGURATION", this.x + this.padding, this.y + this.padding);
            OpenBCI_GUI.this.popStyle();
            OpenBCI_GUI.this.getChannel.draw();
            OpenBCI_GUI.this.setChannel.draw();
            OpenBCI_GUI.this.ovrChannel.draw();
            OpenBCI_GUI.this.systemStatus.draw();
            OpenBCI_GUI.this.autoscan.draw();
            this.print_onscreen(this.last_message);
        }

        public void print_onscreen(String localstring) {
            OpenBCI_GUI.this.textAlign(37);
            OpenBCI_GUI.this.fill(OpenBCI_GUI.this.bgColor);
            OpenBCI_GUI.this.rect(this.x + this.padding, this.y + this.padding * 8 + 13 + 48, this.w - this.padding * 2, 114 - this.padding);
            OpenBCI_GUI.this.fill(255);
            OpenBCI_GUI.this.text(localstring, this.x + this.padding + 10, this.y + this.padding * 8 + 5 + 48 + 15, this.w - this.padding * 3, 111 - this.padding - 15);
            this.last_message = localstring;
        }

        public void print_lastmessage() {
            OpenBCI_GUI.this.fill(OpenBCI_GUI.this.bgColor);
            OpenBCI_GUI.this.rect(this.x + this.padding, this.y + this.padding * 8 + 13 + 48, this.w - this.padding * 2, 114 - this.padding);
            OpenBCI_GUI.this.fill(255);
            OpenBCI_GUI.this.text(this.last_message, 180.0f, 340.0f, 240.0f, 60.0f);
        }
    }

    class RunningMean {
        private float[] values;
        private int cur_ind = 0;

        RunningMean(int N) {
            this.values = new float[N];
            this.cur_ind = 0;
        }

        public void addValue(float val) {
            this.values[this.cur_ind] = val;
            this.cur_ind = (this.cur_ind + 1) % this.values.length;
        }

        public float calcMean() {
            return OpenBCI_GUI.this.mean(this.values);
        }
    }

    class SDBox {
        int x;
        int y;
        int w;
        int h;
        int padding;

        SDBox(int _x, int _y, int _w, int _h, int _padding) {
            this.x = _x;
            this.y = _y;
            this.w = _w;
            this.h = 150;
            this.padding = _padding;
            OpenBCI_GUI.this.sdTimes = new MenuList(OpenBCI_GUI.this.cp5, "sdTimes", this.w - this.padding * 2, 108, OpenBCI_GUI.this.p4);
            OpenBCI_GUI.this.sdTimes.setPosition(this.x + this.padding, this.y + this.padding * 2 + 13);
            OpenBCI_GUI.this.serialPorts = Serial.list();
            OpenBCI_GUI.this.sdTimes.addItem(OpenBCI_GUI.this.makeItem("Do not write to SD..."));
            OpenBCI_GUI.this.sdTimes.addItem(OpenBCI_GUI.this.makeItem("5 minute maximum"));
            OpenBCI_GUI.this.sdTimes.addItem(OpenBCI_GUI.this.makeItem("15 minute maximum"));
            OpenBCI_GUI.this.sdTimes.addItem(OpenBCI_GUI.this.makeItem("30 minute maximum"));
            OpenBCI_GUI.this.sdTimes.addItem(OpenBCI_GUI.this.makeItem("1 hour maximum"));
            OpenBCI_GUI.this.sdTimes.addItem(OpenBCI_GUI.this.makeItem("2 hours maximum"));
            OpenBCI_GUI.this.sdTimes.addItem(OpenBCI_GUI.this.makeItem("4 hour maximum"));
            OpenBCI_GUI.this.sdTimes.addItem(OpenBCI_GUI.this.makeItem("12 hour maximum"));
            OpenBCI_GUI.this.sdTimes.addItem(OpenBCI_GUI.this.makeItem("24 hour maximum"));
            OpenBCI_GUI.this.sdTimes.activeItem = OpenBCI_GUI.this.sdSetting;
        }

        public void update() {
        }

        public void draw() {
            OpenBCI_GUI.this.pushStyle();
            OpenBCI_GUI.this.fill(OpenBCI_GUI.this.boxColor);
            OpenBCI_GUI.this.stroke(OpenBCI_GUI.this.boxStrokeColor);
            OpenBCI_GUI.this.strokeWeight(1.0f);
            OpenBCI_GUI.this.rect(this.x, this.y, this.w, this.h);
            OpenBCI_GUI.this.fill(OpenBCI_GUI.this.bgColor);
            OpenBCI_GUI.this.textFont(OpenBCI_GUI.this.h3, 16.0f);
            OpenBCI_GUI.this.textAlign(37, 101);
            OpenBCI_GUI.this.text("WRITE TO SD (Y/N)?", this.x + this.padding, this.y + this.padding);
            OpenBCI_GUI.this.popStyle();
            OpenBCI_GUI.this.sdTimes.setPosition(this.x + this.padding, this.y + this.padding * 2 + 13);
        }
    }

    class SDConverterBox {
        int x;
        int y;
        int w;
        int h;
        int padding;

        SDConverterBox(int _x, int _y, int _w, int _h, int _padding) {
            this.x = _x;
            this.y = _y;
            this.w = _w;
            this.h = 67;
            this.padding = _padding;
            OpenBCI_GUI.this.selectSDFile = new Button(this.x + this.padding, this.y + this.padding * 2 + 13, this.w - this.padding * 2, 24, "SELECT SD FILE", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
        }

        public void update() {
        }

        public void draw() {
            OpenBCI_GUI.this.pushStyle();
            OpenBCI_GUI.this.fill(OpenBCI_GUI.this.boxColor);
            OpenBCI_GUI.this.stroke(OpenBCI_GUI.this.boxStrokeColor);
            OpenBCI_GUI.this.strokeWeight(1.0f);
            OpenBCI_GUI.this.rect(this.x, this.y, this.w, this.h);
            OpenBCI_GUI.this.fill(OpenBCI_GUI.this.bgColor);
            OpenBCI_GUI.this.textFont(OpenBCI_GUI.this.h3, 16.0f);
            OpenBCI_GUI.this.textAlign(37, 101);
            OpenBCI_GUI.this.text("CONVERT SD FOR PLAYBACK", this.x + this.padding, this.y + this.padding);
            OpenBCI_GUI.this.popStyle();
            OpenBCI_GUI.this.selectSDFile.draw();
        }
    }

    class SampleRateCytonBox {
        int x;
        int y;
        int w;
        int h;
        int padding;
        boolean isSystemInitialized;

        SampleRateCytonBox(int _x, int _y, int _w, int _h, int _padding) {
            this.x = _x;
            this.y = _y;
            this.w = _w;
            this.h = 73;
            this.padding = _padding;
            OpenBCI_GUI.this.sampleRate250 = new Button(this.x + this.padding, this.y + this.padding * 2 + 18, (this.w - this.padding * 4) / 3, 24, "250Hz", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
            OpenBCI_GUI.this.sampleRate500 = new Button(this.x + this.padding * 2 + (this.w - this.padding * 4) / 3, this.y + this.padding * 2 + 18, (this.w - this.padding * 4) / 3, 24, "500Hz", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
            OpenBCI_GUI.this.sampleRate1000 = new Button(this.x + this.padding * 3 + (this.w - this.padding * 4) / 3 * 2, this.y + this.padding * 2 + 18, (this.w - this.padding * 4) / 3, 24, "1000Hz", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
            OpenBCI_GUI.this.sampleRate1000.color_notPressed = OpenBCI_GUI.this.isSelected_color;
        }

        public void update() {
        }

        public void draw() {
            OpenBCI_GUI.this.pushStyle();
            OpenBCI_GUI.this.fill(OpenBCI_GUI.this.boxColor);
            OpenBCI_GUI.this.stroke(OpenBCI_GUI.this.boxStrokeColor);
            OpenBCI_GUI.this.strokeWeight(1.0f);
            OpenBCI_GUI.this.rect(this.x, this.y, this.w, this.h);
            OpenBCI_GUI.this.fill(OpenBCI_GUI.this.bgColor);
            OpenBCI_GUI.this.textFont(OpenBCI_GUI.this.h3, 16.0f);
            OpenBCI_GUI.this.textAlign(37, 101);
            OpenBCI_GUI.this.text("SAMPLE RATE ", this.x + this.padding, this.y + this.padding);
            OpenBCI_GUI.this.fill(OpenBCI_GUI.this.bgColor);
            OpenBCI_GUI.this.textFont(OpenBCI_GUI.this.h3, 16.0f);
            OpenBCI_GUI.this.textAlign(37, 101);
            OpenBCI_GUI.this.text("  " + OpenBCI_GUI.str((int)((int)OpenBCI_GUI.this.cyton.getSampleRate())) + "Hz", this.x + this.padding + 142, this.y + this.padding);
            OpenBCI_GUI.this.popStyle();
            OpenBCI_GUI.this.sampleRate250.draw();
            OpenBCI_GUI.this.sampleRate500.draw();
            OpenBCI_GUI.this.sampleRate1000.draw();
            OpenBCI_GUI.this.sampleRate500.but_y = OpenBCI_GUI.this.sampleRate250.but_y = this.y + this.padding * 2 + 18;
            OpenBCI_GUI.this.sampleRate1000.but_y = OpenBCI_GUI.this.sampleRate250.but_y;
        }
    }

    class SampleRateGanglionBox {
        int x;
        int y;
        int w;
        int h;
        int padding;
        boolean isSystemInitialized;

        SampleRateGanglionBox(int _x, int _y, int _w, int _h, int _padding) {
            this.x = _x;
            this.y = _y;
            this.w = _w;
            this.h = 73;
            this.padding = _padding;
            OpenBCI_GUI.this.sampleRate200 = new Button(this.x + this.padding, this.y + this.padding * 2 + 18, (this.w - this.padding * 3) / 2, 24, "200Hz", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
            OpenBCI_GUI.this.sampleRate1600 = new Button(this.x + this.padding * 2 + (this.w - this.padding * 3) / 2, this.y + this.padding * 2 + 18, (this.w - this.padding * 3) / 2, 24, "1600Hz", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
            OpenBCI_GUI.this.sampleRate1600.color_notPressed = OpenBCI_GUI.this.isSelected_color;
        }

        public void update() {
        }

        public void draw() {
            OpenBCI_GUI.this.pushStyle();
            OpenBCI_GUI.this.fill(OpenBCI_GUI.this.boxColor);
            OpenBCI_GUI.this.stroke(OpenBCI_GUI.this.boxStrokeColor);
            OpenBCI_GUI.this.strokeWeight(1.0f);
            OpenBCI_GUI.this.rect(this.x, this.y, this.w, this.h);
            OpenBCI_GUI.this.fill(OpenBCI_GUI.this.bgColor);
            OpenBCI_GUI.this.textFont(OpenBCI_GUI.this.h3, 16.0f);
            OpenBCI_GUI.this.textAlign(37, 101);
            OpenBCI_GUI.this.text("SAMPLE RATE ", this.x + this.padding, this.y + this.padding);
            OpenBCI_GUI.this.fill(OpenBCI_GUI.this.bgColor);
            OpenBCI_GUI.this.textFont(OpenBCI_GUI.this.h3, 16.0f);
            OpenBCI_GUI.this.textAlign(37, 101);
            OpenBCI_GUI.this.text("  " + OpenBCI_GUI.str((int)((int)OpenBCI_GUI.this.ganglion.getSampleRate())) + "Hz", this.x + this.padding + 142, this.y + this.padding);
            OpenBCI_GUI.this.popStyle();
            OpenBCI_GUI.this.sampleRate200.draw();
            OpenBCI_GUI.this.sampleRate1600.draw();
            OpenBCI_GUI.this.sampleRate1600.but_y = OpenBCI_GUI.this.sampleRate200.but_y = this.y + this.padding * 2 + 18;
        }
    }

    class SerialBox {
        int x;
        int y;
        int w;
        int h;
        int padding;

        SerialBox(int _x, int _y, int _w, int _h, int _padding) {
            this.x = _x;
            this.y = _y;
            this.w = _w;
            this.h = 140 + _padding;
            this.padding = _padding;
            OpenBCI_GUI.this.refreshPort = new Button(this.x + this.padding, this.y + this.padding * 4 + 72 + 8, this.w - this.padding * 2, 24, "REFRESH LIST", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
            OpenBCI_GUI.this.popOutRadioConfigButton = new Button(this.x + this.padding + (this.w - this.padding * 4), this.y + this.padding, 20, 20, ">", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
            OpenBCI_GUI.this.serialList = new MenuList(OpenBCI_GUI.this.cp5, "serialList", this.w - this.padding * 2, 72, OpenBCI_GUI.this.p4);
            OpenBCI_GUI.this.serialList.setPosition(this.x + this.padding, this.y + this.padding * 3 + 8);
            OpenBCI_GUI.this.serialPorts = Serial.list();
            int i = 0;
            while (i < OpenBCI_GUI.this.serialPorts.length) {
                String tempPort = OpenBCI_GUI.this.serialPorts[OpenBCI_GUI.this.serialPorts.length - 1 - i];
                OpenBCI_GUI.this.serialList.addItem(OpenBCI_GUI.this.makeItem(tempPort));
                ++i;
            }
        }

        public void update() {
        }

        public void draw() {
            OpenBCI_GUI.this.pushStyle();
            OpenBCI_GUI.this.fill(OpenBCI_GUI.this.boxColor);
            OpenBCI_GUI.this.stroke(OpenBCI_GUI.this.boxStrokeColor);
            OpenBCI_GUI.this.strokeWeight(1.0f);
            OpenBCI_GUI.this.rect(this.x, this.y, this.w, this.h);
            OpenBCI_GUI.this.fill(OpenBCI_GUI.this.bgColor);
            OpenBCI_GUI.this.textFont(OpenBCI_GUI.this.h3, 16.0f);
            OpenBCI_GUI.this.textAlign(37, 101);
            OpenBCI_GUI.this.text("SERIAL/COM PORT", this.x + this.padding, this.y + this.padding);
            OpenBCI_GUI.this.popStyle();
            OpenBCI_GUI.this.refreshPort.draw();
            if (OpenBCI_GUI.this.cyton.isSerial()) {
                OpenBCI_GUI.this.popOutRadioConfigButton.draw();
            }
        }

        public void refreshSerialList() {
        }
    }

    class Stream
    extends Thread {
        String protocol;
        String dataType;
        String ip;
        int port;
        String address;
        int filter;
        String streamType;
        String streamName;
        int nChanLSL;
        int numChan = 0;
        Boolean isStreaming;
        Boolean newData = false;
        int start;
        int end;
        int bufferLen;
        float[] dataToSend;
        OscP5 osc;
        NetAddress netaddress;
        OscMessage msg;
        UDP udp;
        ByteBuffer buffer;
        LSL.StreamInfo info_data;
        LSL.StreamOutlet outlet_data;
        LSL.StreamInfo info_aux;
        LSL.StreamOutlet outlet_aux;
        Serial serial_networking;
        String portName;
        int baudRate;
        String serialMessage;
        PApplet pApplet;

        private void updateNumChan(int _numChan) {
            this.numChan = _numChan;
            OpenBCI_GUI.println((String)("Stream update numChan to " + this.numChan));
            this.dataToSend = new float[this.numChan * OpenBCI_GUI.this.nPointsPerUpdate];
            OpenBCI_GUI.println((String)("nPointsPerUpdate " + OpenBCI_GUI.this.nPointsPerUpdate));
            OpenBCI_GUI.println((String)("dataToSend len: " + this.numChan * OpenBCI_GUI.this.nPointsPerUpdate));
        }

        Stream(String dataType, String ip, int port, String address, int filter, int _nchan) {
            this.start = OpenBCI_GUI.this.dataBuffY_filtY_uV[0].length - 11;
            this.end = OpenBCI_GUI.this.dataBuffY_filtY_uV[0].length - 1;
            this.bufferLen = this.end - this.start;
            this.dataToSend = new float[this.numChan * this.bufferLen];
            this.serialMessage = "";
            this.protocol = "OSC";
            this.dataType = dataType;
            this.ip = ip;
            this.port = port;
            this.address = address;
            this.filter = filter;
            this.isStreaming = false;
            this.updateNumChan(_nchan);
            try {
                this.closeNetwork();
            }
            catch (Exception exception) {}
        }

        Stream(String dataType, String ip, int port, int filter, int _nchan) {
            this.start = OpenBCI_GUI.this.dataBuffY_filtY_uV[0].length - 11;
            this.end = OpenBCI_GUI.this.dataBuffY_filtY_uV[0].length - 1;
            this.bufferLen = this.end - this.start;
            this.dataToSend = new float[this.numChan * this.bufferLen];
            this.serialMessage = "";
            this.protocol = "UDP";
            this.dataType = dataType;
            this.ip = ip;
            this.port = port;
            this.filter = filter;
            this.isStreaming = false;
            this.updateNumChan(_nchan);
            this.buffer = this.dataType.equals("TimeSeries") ? ByteBuffer.allocate(4 * this.numChan) : ByteBuffer.allocate(504);
            try {
                this.closeNetwork();
            }
            catch (Exception exception) {}
        }

        Stream(String dataType, String streamName, String streamType, int nChanLSL, int filter, int _nchan) {
            this.start = OpenBCI_GUI.this.dataBuffY_filtY_uV[0].length - 11;
            this.end = OpenBCI_GUI.this.dataBuffY_filtY_uV[0].length - 1;
            this.bufferLen = this.end - this.start;
            this.dataToSend = new float[this.numChan * this.bufferLen];
            this.serialMessage = "";
            this.protocol = "LSL";
            this.dataType = dataType;
            this.streamName = streamName;
            this.streamType = streamType;
            this.nChanLSL = nChanLSL;
            this.filter = filter;
            this.isStreaming = false;
            this.updateNumChan(_nchan);
            try {
                this.closeNetwork();
            }
            catch (Exception exception) {}
        }

        Stream(String dataType, String portName, int baudRate, int filter, PApplet _this, int _nchan) {
            this.start = OpenBCI_GUI.this.dataBuffY_filtY_uV[0].length - 11;
            this.end = OpenBCI_GUI.this.dataBuffY_filtY_uV[0].length - 1;
            this.bufferLen = this.end - this.start;
            this.dataToSend = new float[this.numChan * this.bufferLen];
            this.serialMessage = "";
            this.protocol = "Serial";
            this.dataType = dataType;
            this.portName = portName;
            this.baudRate = baudRate;
            this.filter = filter;
            this.isStreaming = false;
            this.pApplet = _this;
            this.updateNumChan(_nchan);
            this.buffer = this.dataType.equals("TimeSeries") ? ByteBuffer.allocate(4 * this.numChan) : ByteBuffer.allocate(504);
            try {
                this.closeNetwork();
            }
            catch (Exception exception) {}
        }

        @Override
        public void start() {
            this.isStreaming = true;
            if (!this.protocol.equals("LSL")) {
                super.start();
            } else {
                this.openNetwork();
            }
        }

        @Override
        public void run() {
            if (!this.protocol.equals("LSL")) {
                this.openNetwork();
                while (this.isStreaming.booleanValue()) {
                    if (!OpenBCI_GUI.this.isRunning) {
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException e) {
                            OpenBCI_GUI.println((Object)e);
                        }
                        continue;
                    }
                    if (this.checkForData().booleanValue()) {
                        if (this.dataType.equals("TimeSeries")) {
                            this.sendTimeSeriesData();
                        } else if (this.dataType.equals("FFT")) {
                            this.sendFFTData();
                        } else if (this.dataType.equals("EMG")) {
                            this.sendEMGData();
                        } else if (this.dataType.equals("BandPower")) {
                            this.sendPowerBandData();
                        } else if (this.dataType.equals("Focus")) {
                            this.sendFocusData();
                        } else if (this.dataType.equals("WIDGET")) {
                            this.sendWidgetData();
                        }
                        this.setDataFalse();
                        continue;
                    }
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException e) {
                        OpenBCI_GUI.println((Object)e);
                    }
                }
            } else if (this.protocol.equals("LSL")) {
                if (!OpenBCI_GUI.this.isRunning) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException e) {
                        OpenBCI_GUI.println((Object)e);
                    }
                } else if (this.checkForData().booleanValue()) {
                    if (this.dataType.equals("TimeSeries")) {
                        this.sendTimeSeriesData();
                    } else if (this.dataType.equals("FFT")) {
                        this.sendFFTData();
                    } else if (this.dataType.equals("EMG")) {
                        this.sendEMGData();
                    } else if (this.dataType.equals("BandPower")) {
                        this.sendPowerBandData();
                    } else if (this.dataType.equals("Focus")) {
                        this.sendFocusData();
                    } else if (this.dataType.equals("WIDGET")) {
                        this.sendWidgetData();
                    }
                    this.setDataFalse();
                }
            }
        }

        public Boolean checkForData() {
            if (this.dataType.equals("TimeSeries")) {
                return OpenBCI_GUI.this.dataProcessing.newDataToSend;
            }
            if (this.dataType.equals("FFT")) {
                return OpenBCI_GUI.this.dataProcessing.newDataToSend;
            }
            if (this.dataType.equals("EMG")) {
                return OpenBCI_GUI.this.dataProcessing.newDataToSend;
            }
            if (this.dataType.equals("BandPower")) {
                return OpenBCI_GUI.this.dataProcessing.newDataToSend;
            }
            if (this.dataType.equals("Focus")) {
                return OpenBCI_GUI.this.dataProcessing.newDataToSend;
            }
            this.dataType.equals("WIDGET");
            return false;
        }

        public void setDataFalse() {
            if (this.dataType.equals("TimeSeries")) {
                OpenBCI_GUI.this.dataProcessing.newDataToSend = false;
            } else if (this.dataType.equals("FFT")) {
                OpenBCI_GUI.this.dataProcessing.newDataToSend = false;
            } else if (this.dataType.equals("EMG")) {
                OpenBCI_GUI.this.dataProcessing.newDataToSend = false;
            } else if (this.dataType.equals("BandPower")) {
                OpenBCI_GUI.this.dataProcessing.newDataToSend = false;
            } else if (this.dataType.equals("Focus")) {
                OpenBCI_GUI.this.dataProcessing.newDataToSend = false;
            } else {
                this.dataType.equals("WIDGET");
            }
        }

        public void sendTimeSeriesData() {
            block39: {
                block37: {
                    block41: {
                        block40: {
                            block38: {
                                if (this.filter != 0) break block37;
                                if (!this.protocol.equals("OSC")) break block38;
                                int i = 0;
                                while (i < OpenBCI_GUI.this.nPointsPerUpdate) {
                                    this.msg.clearArguments();
                                    int j = 0;
                                    while (j < this.numChan) {
                                        this.msg.add(OpenBCI_GUI.this.yLittleBuff_uV[j][i]);
                                        ++j;
                                    }
                                    try {
                                        this.osc.send((OscPacket)this.msg, this.netaddress);
                                    }
                                    catch (Exception e) {
                                        OpenBCI_GUI.println((Object)e);
                                    }
                                    ++i;
                                }
                                break block39;
                            }
                            if (!this.protocol.equals("UDP")) break block40;
                            int i = 0;
                            while (i < OpenBCI_GUI.this.nPointsPerUpdate) {
                                String outputter = "{\"type\":\"eeg\",\"data\":[";
                                int j = 0;
                                while (j < this.numChan) {
                                    outputter = String.valueOf(outputter) + OpenBCI_GUI.str((float)OpenBCI_GUI.this.yLittleBuff_uV[j][i]);
                                    outputter = j != this.numChan - 1 ? String.valueOf(outputter) + "," : String.valueOf(outputter) + "]}\r\n";
                                    ++j;
                                }
                                try {
                                    this.udp.send(outputter, this.ip, this.port);
                                }
                                catch (Exception e) {
                                    OpenBCI_GUI.println((Object)e);
                                }
                                ++i;
                            }
                            break block39;
                        }
                        if (!this.protocol.equals("LSL")) break block41;
                        int i = 0;
                        while (i < OpenBCI_GUI.this.nPointsPerUpdate) {
                            int j = 0;
                            while (j < this.numChan) {
                                this.dataToSend[j + this.numChan * i] = OpenBCI_GUI.this.yLittleBuff_uV[j][i];
                                ++j;
                            }
                            ++i;
                        }
                        this.outlet_data.push_chunk(this.dataToSend);
                        break block39;
                    }
                    if (!this.protocol.equals("Serial")) break block39;
                    int i = 0;
                    while (i < OpenBCI_GUI.this.nPointsPerUpdate) {
                        this.serialMessage = "[";
                        int j = 0;
                        while (j < this.numChan) {
                            float chan_uV = OpenBCI_GUI.this.yLittleBuff_uV[j][i];
                            String chan_uV_3dec = String.format("%.3f", Float.valueOf(chan_uV));
                            this.serialMessage = String.valueOf(this.serialMessage) + chan_uV_3dec;
                            if (j < this.numChan - 1) {
                                this.serialMessage = String.valueOf(this.serialMessage) + ",";
                            }
                            ++j;
                        }
                        this.serialMessage = String.valueOf(this.serialMessage) + "]";
                        try {
                            this.serial_networking.write(this.serialMessage);
                        }
                        catch (Exception e) {
                            OpenBCI_GUI.println((Object)e);
                        }
                        ++i;
                    }
                    break block39;
                }
                if (this.filter != 1) break block39;
                if (this.protocol.equals("OSC")) {
                    int i = 0;
                    while (i < OpenBCI_GUI.this.nPointsPerUpdate) {
                        this.msg.clearArguments();
                        int j = 0;
                        while (j < this.numChan) {
                            this.msg.add(OpenBCI_GUI.this.dataBuffY_filtY_uV[j][this.start + i]);
                            ++j;
                        }
                        try {
                            this.osc.send((OscPacket)this.msg, this.netaddress);
                        }
                        catch (Exception e) {
                            OpenBCI_GUI.println((Object)e);
                        }
                        ++i;
                    }
                } else if (this.protocol.equals("UDP")) {
                    int i = 0;
                    while (i < OpenBCI_GUI.this.nPointsPerUpdate) {
                        String outputter = "{\"type\":\"eeg\",\"data\":[";
                        int j = 0;
                        while (j < this.numChan) {
                            outputter = String.valueOf(outputter) + OpenBCI_GUI.str((float)OpenBCI_GUI.this.dataBuffY_filtY_uV[j][this.start + i]);
                            outputter = j != this.numChan - 1 ? String.valueOf(outputter) + "," : String.valueOf(outputter) + "]}\r\n";
                            ++j;
                        }
                        try {
                            this.udp.send(outputter, this.ip, this.port);
                        }
                        catch (Exception e) {
                            OpenBCI_GUI.println((Object)e);
                        }
                        ++i;
                    }
                } else if (this.protocol.equals("LSL")) {
                    int i = 0;
                    while (i < OpenBCI_GUI.this.nPointsPerUpdate) {
                        int j = 0;
                        while (j < this.numChan) {
                            this.dataToSend[j + this.numChan * i] = OpenBCI_GUI.this.dataBuffY_filtY_uV[j][i];
                            ++j;
                        }
                        ++i;
                    }
                    this.outlet_data.push_chunk(this.dataToSend);
                } else if (this.protocol.equals("Serial")) {
                    int i = 0;
                    while (i < OpenBCI_GUI.this.nPointsPerUpdate) {
                        this.serialMessage = "[";
                        int j = 0;
                        while (j < this.numChan) {
                            float chan_uV_filt = OpenBCI_GUI.this.dataBuffY_filtY_uV[j][this.start + i];
                            String chan_uV_filt_3dec = String.format("%.3f", Float.valueOf(chan_uV_filt));
                            this.serialMessage = String.valueOf(this.serialMessage) + chan_uV_filt_3dec;
                            if (j < this.numChan - 1) {
                                this.serialMessage = String.valueOf(this.serialMessage) + ",";
                            }
                            ++j;
                        }
                        this.serialMessage = String.valueOf(this.serialMessage) + "]";
                        try {
                            this.serial_networking.write(this.serialMessage);
                        }
                        catch (Exception e) {
                            OpenBCI_GUI.println((Object)e);
                        }
                        ++i;
                    }
                }
            }
        }

        public void sendFFTData() {
            block14: {
                block16: {
                    block15: {
                        if (this.filter != 0 && this.filter != 1) break block14;
                        if (!this.protocol.equals("OSC")) break block15;
                        int i = 0;
                        while (i < this.numChan) {
                            this.msg.clearArguments();
                            this.msg.add(i + 1);
                            int j = 0;
                            while (j < 125) {
                                this.msg.add(OpenBCI_GUI.this.fftBuff[i].getBand(j));
                                ++j;
                            }
                            try {
                                this.osc.send((OscPacket)this.msg, this.netaddress);
                            }
                            catch (Exception e) {
                                OpenBCI_GUI.println((Object)e);
                            }
                            ++i;
                        }
                        break block14;
                    }
                    if (!this.protocol.equals("UDP")) break block16;
                    String outputter = "{\"type\":\"fft\",\"data\":[[";
                    int i = 0;
                    while (i < this.numChan) {
                        int j = 0;
                        while (j < 125) {
                            outputter = String.valueOf(outputter) + OpenBCI_GUI.str((float)OpenBCI_GUI.this.fftBuff[i].getBand(j));
                            if (j != 124) {
                                outputter = String.valueOf(outputter) + ",";
                            }
                            ++j;
                        }
                        outputter = i != this.numChan - 1 ? String.valueOf(outputter) + "],[" : String.valueOf(outputter) + "]]}\r\n";
                        ++i;
                    }
                    try {
                        this.udp.send(outputter, this.ip, this.port);
                    }
                    catch (Exception e) {
                        OpenBCI_GUI.println((Object)e);
                    }
                    break block14;
                }
                if (this.protocol.equals("LSL") || !this.protocol.equals("Serial")) break block14;
                int i = 0;
                while (i < this.numChan) {
                    this.serialMessage = "[" + (i + 1) + ",";
                    int j = 0;
                    while (j < 125) {
                        float fft_band = OpenBCI_GUI.this.fftBuff[i].getBand(j);
                        String fft_band_3dec = String.format("%.3f", Float.valueOf(fft_band));
                        this.serialMessage = String.valueOf(this.serialMessage) + fft_band_3dec;
                        if (j < 124) {
                            this.serialMessage = String.valueOf(this.serialMessage) + ",";
                        }
                        ++j;
                    }
                    this.serialMessage = String.valueOf(this.serialMessage) + "]";
                    try {
                        this.serial_networking.write(this.serialMessage);
                    }
                    catch (Exception e) {
                        OpenBCI_GUI.println((Object)e);
                    }
                    ++i;
                }
            }
        }

        public void sendPowerBandData() {
            block16: {
                int numBandPower;
                block19: {
                    block18: {
                        block17: {
                            numBandPower = 5;
                            if (this.filter != 0 && this.filter != 1) break block16;
                            if (!this.protocol.equals("OSC")) break block17;
                            int i = 0;
                            while (i < this.numChan) {
                                this.msg.clearArguments();
                                this.msg.add(i + 1);
                                int j = 0;
                                while (j < numBandPower) {
                                    this.msg.add(OpenBCI_GUI.this.dataProcessing.avgPowerInBins[i][j]);
                                    ++j;
                                }
                                try {
                                    this.osc.send((OscPacket)this.msg, this.netaddress);
                                }
                                catch (Exception e) {
                                    OpenBCI_GUI.println((Object)e);
                                }
                                ++i;
                            }
                            break block16;
                        }
                        if (!this.protocol.equals("UDP")) break block18;
                        String outputter = "{\"type\":\"bandPower\",\"data\":[[";
                        int i = 0;
                        while (i < this.numChan) {
                            int j = 0;
                            while (j < numBandPower) {
                                outputter = String.valueOf(outputter) + OpenBCI_GUI.str((float)OpenBCI_GUI.this.dataProcessing.avgPowerInBins[i][j]);
                                if (j != numBandPower - 1) {
                                    outputter = String.valueOf(outputter) + ",";
                                }
                                ++j;
                            }
                            outputter = i != this.numChan - 1 ? String.valueOf(outputter) + "],[" : String.valueOf(outputter) + "]]}\r\n";
                            ++i;
                        }
                        try {
                            this.udp.send(outputter, this.ip, this.port);
                        }
                        catch (Exception e) {
                            OpenBCI_GUI.println((Object)e);
                        }
                        break block16;
                    }
                    if (!this.protocol.equals("LSL")) break block19;
                    float[] cfr_ignored_0 = new float[this.numChan * numBandPower];
                    int i = 0;
                    while (i < this.numChan) {
                        int j = 0;
                        while (j < numBandPower) {
                            this.dataToSend[j + this.numChan * i] = OpenBCI_GUI.this.dataProcessing.avgPowerInBins[i][j];
                            ++j;
                        }
                        ++i;
                    }
                    this.outlet_data.push_chunk(this.dataToSend);
                    break block16;
                }
                if (!this.protocol.equals("Serial")) break block16;
                int i = 0;
                while (i < this.numChan) {
                    this.serialMessage = "[" + (i + 1) + ",";
                    int j = 0;
                    while (j < numBandPower) {
                        float power_band = OpenBCI_GUI.this.dataProcessing.avgPowerInBins[i][j];
                        String power_band_3dec = String.format("%.3f", Float.valueOf(power_band));
                        this.serialMessage = String.valueOf(this.serialMessage) + power_band_3dec;
                        if (j < numBandPower - 1) {
                            this.serialMessage = String.valueOf(this.serialMessage) + ",";
                        }
                        ++j;
                    }
                    this.serialMessage = String.valueOf(this.serialMessage) + "]";
                    try {
                        this.serial_networking.write(this.serialMessage);
                    }
                    catch (Exception e) {
                        OpenBCI_GUI.println((Object)e);
                    }
                    ++i;
                }
            }
        }

        public void sendEMGData() {
            block11: {
                block14: {
                    block13: {
                        block12: {
                            if (this.filter != 0 && this.filter != 1) break block11;
                            if (!this.protocol.equals("OSC")) break block12;
                            int i = 0;
                            while (i < this.numChan) {
                                this.msg.clearArguments();
                                this.msg.add(i + 1);
                                this.msg.add(OpenBCI_GUI.this.w_emg.motorWidgets[i].output_normalized);
                                try {
                                    this.osc.send((OscPacket)this.msg, this.netaddress);
                                }
                                catch (Exception e) {
                                    OpenBCI_GUI.println((Object)e);
                                }
                                ++i;
                            }
                            break block11;
                        }
                        if (!this.protocol.equals("UDP")) break block13;
                        String outputter = "{\"type\":\"emg\",\"data\":[";
                        int i = 0;
                        while (i < this.numChan) {
                            outputter = String.valueOf(outputter) + OpenBCI_GUI.str((float)OpenBCI_GUI.this.w_emg.motorWidgets[i].output_normalized);
                            outputter = i != this.numChan - 1 ? String.valueOf(outputter) + "," : String.valueOf(outputter) + "]}\r\n";
                            ++i;
                        }
                        try {
                            this.udp.send(outputter, this.ip, this.port);
                        }
                        catch (Exception e) {
                            OpenBCI_GUI.println((Object)e);
                        }
                        break block11;
                    }
                    if (!this.protocol.equals("LSL")) break block14;
                    if (this.filter != 0) break block11;
                    int j = 0;
                    while (j < this.numChan) {
                        this.dataToSend[j] = OpenBCI_GUI.this.w_emg.motorWidgets[j].output_normalized;
                        ++j;
                    }
                    this.outlet_data.push_sample(this.dataToSend);
                    break block11;
                }
                if (this.protocol.equals("Serial")) {
                    int i = 0;
                    while (i < this.numChan) {
                        this.serialMessage = "[" + (i + 1) + ",";
                        float emg_normalized = OpenBCI_GUI.this.w_emg.motorWidgets[i].output_normalized;
                        String emg_normalized_3dec = String.format("%.3f", Float.valueOf(emg_normalized));
                        this.serialMessage = String.valueOf(this.serialMessage) + emg_normalized_3dec + "]";
                        try {
                            this.serial_networking.write(this.serialMessage);
                        }
                        catch (Exception e) {
                            OpenBCI_GUI.println((Object)e);
                        }
                        ++i;
                    }
                }
            }
        }

        public void sendFocusData() {
            if (this.filter == 0 || this.filter == 1) {
                if (this.protocol.equals("OSC")) {
                    this.msg.clearArguments();
                    this.msg.add(OpenBCI_GUI.this.w_focus.isFocused);
                    OpenBCI_GUI.println((boolean)OpenBCI_GUI.this.w_focus.isFocused);
                    try {
                        this.osc.send((OscPacket)this.msg, this.netaddress);
                    }
                    catch (Exception e) {
                        OpenBCI_GUI.println((Object)e);
                    }
                } else if (this.protocol.equals("UDP")) {
                    String outputter = "{\"type\":\"focus\",\"data\":";
                    outputter = String.valueOf(outputter) + OpenBCI_GUI.str((float)(OpenBCI_GUI.this.w_focus.isFocused ? 1.0f : 0.0f));
                    outputter = String.valueOf(outputter) + "]}\r\n";
                    try {
                        this.udp.send(outputter, this.ip, this.port);
                    }
                    catch (Exception e) {
                        OpenBCI_GUI.println((Object)e);
                    }
                } else if (this.protocol.equals("LSL")) {
                    float temp;
                    this.dataToSend[0] = temp = OpenBCI_GUI.this.w_focus.isFocused ? 1.0f : 0.0f;
                    this.outlet_data.push_chunk(this.dataToSend);
                } else if (this.protocol.equals("Serial")) {
                    int i = 0;
                    while (i < this.numChan) {
                        this.serialMessage = "";
                        String isFocused = Boolean.toString(OpenBCI_GUI.this.w_focus.isFocused);
                        this.serialMessage = String.valueOf(this.serialMessage) + isFocused;
                        try {
                            OpenBCI_GUI.println((String)this.serialMessage);
                            this.serial_networking.write(this.serialMessage);
                        }
                        catch (Exception e) {
                            OpenBCI_GUI.println((Object)e);
                        }
                        ++i;
                    }
                }
            }
        }

        public void sendWidgetData() {
        }

        public void quit() {
            this.isStreaming = false;
            this.closeNetwork();
            this.interrupt();
        }

        public void closeNetwork() {
            if (this.protocol.equals("OSC")) {
                try {
                    this.osc.stop();
                }
                catch (Exception e) {
                    OpenBCI_GUI.println((Object)e);
                }
            } else if (this.protocol.equals("UDP")) {
                this.udp.close();
            } else if (this.protocol.equals("LSL")) {
                this.outlet_data.close();
            } else if (this.protocol.equals("Serial")) {
                try {
                    this.serial_networking.clear();
                    this.serial_networking.stop();
                    OpenBCI_GUI.println((String)("Successfully closed SERIAL/COM port " + this.portName));
                }
                catch (Exception exception) {
                    OpenBCI_GUI.println((String)("Failed to close SERIAL/COM port " + this.portName));
                }
            }
        }

        public void openNetwork() {
            OpenBCI_GUI.println((Object)this.getAttributes());
            if (this.protocol.equals("OSC")) {
                this.osc = new OscP5((Object)this, this.port + 1000);
                this.netaddress = new NetAddress(this.ip, this.port);
                this.msg = new OscMessage(this.address);
            } else if (this.protocol.equals("UDP")) {
                this.udp = new UDP((Object)this);
                this.udp.setBuffer(20000);
                this.udp.listen(false);
                this.udp.log(false);
                OpenBCI_GUI.println((String)"UDP successfully connected");
                OpenBCI_GUI.this.output("UDP successfully connected");
            } else if (this.protocol.equals("LSL")) {
                String stream_id = "openbcieeg12345";
                this.info_data = new LSL.StreamInfo(this.streamName, this.streamType, this.nChanLSL, (double)OpenBCI_GUI.this.getSampleRateSafe(), 1, stream_id);
                this.outlet_data = new LSL.StreamOutlet(this.info_data);
            } else if (this.protocol.equals("Serial")) {
                try {
                    this.serial_networking = new Serial(this.pApplet, this.portName, this.baudRate);
                    this.serial_networking.clear();
                    OpenBCI_GUI.this.verbosePrint("Successfully opened SERIAL/COM: " + this.portName);
                    OpenBCI_GUI.this.output("Successfully opened SERIAL/COM (" + this.baudRate + "): " + this.portName);
                }
                catch (Exception e) {
                    OpenBCI_GUI.this.verbosePrint("W_networking.pde: could not open SERIAL PORT: " + this.portName);
                    OpenBCI_GUI.println((String)("Error: " + e));
                }
            }
        }

        public List getAttributes() {
            ArrayList<Object> attributes = new ArrayList<Object>();
            if (this.protocol.equals("OSC")) {
                attributes.add(this.dataType);
                attributes.add(this.ip);
                attributes.add(this.port);
                attributes.add(this.address);
                attributes.add(this.filter);
            } else if (this.protocol.equals("UDP")) {
                attributes.add(this.dataType);
                attributes.add(this.ip);
                attributes.add(this.port);
                attributes.add(this.filter);
            } else if (this.protocol.equals("LSL")) {
                attributes.add(this.dataType);
                attributes.add(this.streamName);
                attributes.add(this.streamType);
                attributes.add(this.nChanLSL);
                attributes.add(this.filter);
            } else {
                this.protocol.equals("Serial");
            }
            return attributes;
        }
    }

    class SyntheticChannelCountBox {
        int x;
        int y;
        int w;
        int h;
        int padding;
        boolean isSystemInitialized;

        SyntheticChannelCountBox(int _x, int _y, int _w, int _h, int _padding) {
            this.x = _x;
            this.y = _y;
            this.w = _w;
            this.h = 73;
            this.padding = _padding;
            OpenBCI_GUI.this.synthChanButton4 = new Button(this.x + this.padding, this.y + this.padding * 2 + 18, (this.w - this.padding * 4) / 3, 24, "4 chan", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
            if (OpenBCI_GUI.this.nchan == 4) {
                OpenBCI_GUI.this.synthChanButton4.color_notPressed = OpenBCI_GUI.this.isSelected_color;
            }
            OpenBCI_GUI.this.synthChanButton8 = new Button(this.x + this.padding * 2 + (this.w - this.padding * 4) / 3, this.y + this.padding * 2 + 18, (this.w - this.padding * 4) / 3, 24, "8 chan", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
            if (OpenBCI_GUI.this.nchan == 8) {
                OpenBCI_GUI.this.synthChanButton8.color_notPressed = OpenBCI_GUI.this.isSelected_color;
            }
            OpenBCI_GUI.this.synthChanButton16 = new Button(this.x + this.padding * 3 + (this.w - this.padding * 4) / 3 * 2, this.y + this.padding * 2 + 18, (this.w - this.padding * 4) / 3, 24, "16 chan", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
            if (OpenBCI_GUI.this.nchan == 16) {
                OpenBCI_GUI.this.synthChanButton16.color_notPressed = OpenBCI_GUI.this.isSelected_color;
            }
        }

        public void update() {
        }

        public void draw() {
            OpenBCI_GUI.this.pushStyle();
            OpenBCI_GUI.this.fill(OpenBCI_GUI.this.boxColor);
            OpenBCI_GUI.this.stroke(OpenBCI_GUI.this.boxStrokeColor);
            OpenBCI_GUI.this.strokeWeight(1.0f);
            OpenBCI_GUI.this.rect(this.x, this.y, this.w, this.h);
            OpenBCI_GUI.this.fill(OpenBCI_GUI.this.bgColor);
            OpenBCI_GUI.this.textFont(OpenBCI_GUI.this.h3, 16.0f);
            OpenBCI_GUI.this.textAlign(37, 101);
            OpenBCI_GUI.this.text("CHANNEL COUNT", this.x + this.padding, this.y + this.padding);
            OpenBCI_GUI.this.fill(OpenBCI_GUI.this.bgColor);
            OpenBCI_GUI.this.textFont(OpenBCI_GUI.this.h3, 16.0f);
            OpenBCI_GUI.this.textAlign(37, 101);
            OpenBCI_GUI.this.text("  (" + OpenBCI_GUI.str((int)OpenBCI_GUI.this.nchan) + ")", this.x + this.padding + 142, this.y + this.padding);
            OpenBCI_GUI.this.popStyle();
            OpenBCI_GUI.this.synthChanButton4.draw();
            OpenBCI_GUI.this.synthChanButton8.draw();
            OpenBCI_GUI.this.synthChanButton16.draw();
        }
    }

    class Table_CSV
    extends Table {
        private int sampleRate;

        public int getSampleRate() {
            return this.sampleRate;
        }

        Table_CSV(String fname) throws IOException {
            this.init();
            this.readCSV(PApplet.createReader((InputStream)OpenBCI_GUI.this.createInput(fname)));
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void readCSV(BufferedReader reader) throws IOException {
            header = false;
            tsv = false;
            line = null;
            row = 0;
            if (this.rowCount != 0) ** GOTO lbl-1000
            this.setRowCount(10);
            try lbl-1000:
            // 5 sources

            {
                while ((line = reader.readLine()) != null) {
                    if (line.charAt(0) == '%') {
                        if (line.length() > 18 && line.charAt(1) == 'S') {
                            this.sampleRate = Integer.parseInt(line.substring(15, 18));
                            if (this.sampleRate == 100 || this.sampleRate == 160) {
                                this.sampleRate = Integer.parseInt(line.substring(15, 19));
                            }
                            OpenBCI_GUI.println((String)("Sample rate set to " + this.sampleRate));
                        }
                        OpenBCI_GUI.println((String)line);
                        continue;
                    }
                    if (row == this.getRowCount()) {
                        this.setRowCount(row << 1);
                    }
                    if (row == 0 && header) {
                        this.setColumnTitles(tsv != false ? PApplet.split((String)line, (char)'\t') : OpenBCI_GUI.split((String)line, (char)','));
                        header = false;
                    } else {
                        this.setRow(row, tsv != false ? PApplet.split((String)line, (char)'\t') : OpenBCI_GUI.split((String)line, (char)','));
                        ++row;
                    }
                    if (row % 10000 != 0) continue;
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Error reading table on line " + row, e);
            }
            if (row != this.getRowCount()) {
                this.setRowCount(row);
            }
        }
    }

    class TextBox {
        public int x;
        public int y;
        public int textColor;
        public int backgroundColor;
        private PFont font;
        private int fontSize;
        public String string;
        public boolean drawBackground;
        public int backgroundEdge_pixels;
        public int alignH;
        public int alignV;

        TextBox(String s, int x1, int y1) {
            this.string = s;
            this.x = x1;
            this.y = y1;
            this.backgroundColor = OpenBCI_GUI.this.color(255, 255, 255);
            this.textColor = OpenBCI_GUI.this.color(0, 0, 0);
            this.fontSize = 12;
            this.font = OpenBCI_GUI.this.p5;
            this.backgroundEdge_pixels = 1;
            this.drawBackground = false;
            this.alignH = 37;
            this.alignV = 102;
        }

        public void setFontSize(int size) {
            this.fontSize = size;
            this.font = OpenBCI_GUI.this.p5;
        }

        public void draw() {
            OpenBCI_GUI.this.noStroke();
            OpenBCI_GUI.this.textFont(this.font);
            if (this.drawBackground) {
                int w = PApplet.parseInt((float)OpenBCI_GUI.round((float)OpenBCI_GUI.this.textWidth(this.string)));
                int xbox = this.x - this.backgroundEdge_pixels;
                switch (this.alignH) {
                    case 37: {
                        xbox = this.x - this.backgroundEdge_pixels;
                        break;
                    }
                    case 39: {
                        xbox = this.x - w - this.backgroundEdge_pixels;
                        break;
                    }
                    case 3: {
                        xbox = this.x - PApplet.parseInt((float)OpenBCI_GUI.round((float)((float)w / 2.0f))) - this.backgroundEdge_pixels;
                    }
                }
                int h = PApplet.parseInt((float)OpenBCI_GUI.this.textAscent()) + 2 * this.backgroundEdge_pixels;
                int ybox = this.y - PApplet.parseInt((float)OpenBCI_GUI.round((float)OpenBCI_GUI.this.textAscent())) - this.backgroundEdge_pixels - 2;
                OpenBCI_GUI.this.fill(this.backgroundColor);
                OpenBCI_GUI.this.rect(xbox, ybox, w += 2 * this.backgroundEdge_pixels, h);
            }
            OpenBCI_GUI.this.fill(this.textColor);
            OpenBCI_GUI.this.textAlign(this.alignH, this.alignV);
            OpenBCI_GUI.this.text(this.string, this.x, this.y);
            OpenBCI_GUI.this.strokeWeight(1.0f);
        }
    }

    class TopNav {
        Button controlPanelCollapser;
        Button fpsButton;
        Button highRezButton;
        Button stopButton;
        public static final String stopButton_pressToStop_txt = "Stop Data Stream";
        public static final String stopButton_pressToStart_txt = "Start Data Stream";
        Button filtBPButton;
        Button filtNotchButton;
        Button tutorialsButton;
        Button shopButton;
        Button issuesButton;
        Button layoutButton;
        LayoutSelector layoutSelector;
        TutorialSelector tutorialSelector;
        boolean finishedInit = false;

        TopNav() {
            this.controlPanelCollapser = new Button(3, 3, 256, 26, "System Control Panel", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
            this.controlPanelCollapser.setFont(OpenBCI_GUI.this.h3, 16);
            this.controlPanelCollapser.setIsActive(true);
            this.controlPanelCollapser.isDropdownButton = true;
            this.fpsButton = new Button(262, 3, 73, 26, "XX fps", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
            if (OpenBCI_GUI.this.frameRateCounter == 0) {
                this.fpsButton.setString("24 fps");
            }
            if (OpenBCI_GUI.this.frameRateCounter == 1) {
                this.fpsButton.setString("30 fps");
            }
            if (OpenBCI_GUI.this.frameRateCounter == 2) {
                this.fpsButton.setString("45 fps");
            }
            if (OpenBCI_GUI.this.frameRateCounter == 3) {
                this.fpsButton.setString("60 fps");
            }
            this.fpsButton.setFont(OpenBCI_GUI.this.h3, 16);
            this.fpsButton.setHelpText("If you're having latency issues, try adjusting the frame rate and see if it helps!");
            this.highRezButton = new Button(338, 3, 26, 26, "XX", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
            this.controlPanelCollapser.setFont(OpenBCI_GUI.this.h3, 16);
            int butNum = 1;
            this.tutorialsButton = new Button(OpenBCI_GUI.this.width - 3 * butNum - 80, 3, 80, 26, "Help", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
            this.tutorialsButton.setFont(OpenBCI_GUI.this.h3, 16);
            this.tutorialsButton.setHelpText("Click to find links to helpful online tutorials and getting started guides. Also, check out how to create custom widgets for the GUI!");
            butNum = 2;
            this.issuesButton = new Button(OpenBCI_GUI.this.width - 3 * butNum - 80 - this.tutorialsButton.but_dx, 3, 80, 26, "Issues", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
            this.issuesButton.setHelpText("If you have suggestions or want to share a bug you've found, please create an issue on the GUI's Github repo!");
            this.issuesButton.setURL("https://github.com/OpenBCI/OpenBCI_GUI/issues");
            this.issuesButton.setFont(OpenBCI_GUI.this.h3, 16);
            butNum = 3;
            this.shopButton = new Button(OpenBCI_GUI.this.width - 3 * butNum - 80 - this.issuesButton.but_dx - this.tutorialsButton.but_dx, 3, 80, 26, "Shop", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
            this.shopButton.setHelpText("Head to our online store to purchase the latest OpenBCI hardware and accessories.");
            this.shopButton.setURL("http://shop.openbci.com/");
            this.shopButton.setFont(OpenBCI_GUI.this.h3, 16);
            this.layoutSelector = new LayoutSelector();
            this.tutorialSelector = new TutorialSelector();
            this.updateNavButtonsBasedOnColorScheme();
        }

        public void initSecondaryNav() {
            this.stopButton = new Button(3, 35, 170, 26, stopButton_pressToStart_txt, OpenBCI_GUI.this.fontInfo.buttonLabel_size);
            this.stopButton.setFont(OpenBCI_GUI.this.h4, 14);
            this.stopButton.setColorNotPressed(OpenBCI_GUI.this.color(184, 220, 105));
            this.stopButton.setHelpText("Press this button to Stop/Start the data stream. Or press <SPACEBAR>");
            this.filtNotchButton = new Button(7 + this.stopButton.but_dx, 35, 70, 26, "Notch\n" + OpenBCI_GUI.this.dataProcessing.getShortNotchDescription(), OpenBCI_GUI.this.fontInfo.buttonLabel_size);
            this.filtNotchButton.setFont(OpenBCI_GUI.this.p5, 12);
            this.filtNotchButton.setHelpText("Here you can adjust the Notch Filter that is applied to all \"Filtered\" data.");
            this.filtBPButton = new Button(11 + this.stopButton.but_dx + 70, 35, 70, 26, "BP Filt\n" + OpenBCI_GUI.this.dataProcessing.getShortFilterDescription(), OpenBCI_GUI.this.fontInfo.buttonLabel_size);
            this.filtBPButton.setFont(OpenBCI_GUI.this.p5, 12);
            this.filtBPButton.setHelpText("Here you can adjust the Band Pass Filter that is applied to all \"Filtered\" data.");
            this.layoutButton = new Button(OpenBCI_GUI.this.width - 3 - 60, 35, 60, 26, "Layout", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
            this.layoutButton.setHelpText("Here you can alter the overall layout of the GUI, allowing for different container configurations with more or less widgets.");
            this.layoutButton.setFont(OpenBCI_GUI.this.h4, 14);
            this.updateSecondaryNavButtonsColor();
        }

        public void updateNavButtonsBasedOnColorScheme() {
            if (OpenBCI_GUI.this.colorScheme == OpenBCI_GUI.this.COLOR_SCHEME_DEFAULT) {
                this.controlPanelCollapser.setColorNotPressed(OpenBCI_GUI.this.color(255));
                this.fpsButton.setColorNotPressed(OpenBCI_GUI.this.color(255));
                this.highRezButton.setColorNotPressed(OpenBCI_GUI.this.color(255));
                this.issuesButton.setColorNotPressed(OpenBCI_GUI.this.color(255));
                this.shopButton.setColorNotPressed(OpenBCI_GUI.this.color(255));
                this.tutorialsButton.setColorNotPressed(OpenBCI_GUI.this.color(255));
                this.controlPanelCollapser.textColorNotActive = OpenBCI_GUI.this.color(OpenBCI_GUI.this.bgColor);
                this.fpsButton.textColorNotActive = OpenBCI_GUI.this.color(OpenBCI_GUI.this.bgColor);
                this.highRezButton.textColorNotActive = OpenBCI_GUI.this.color(OpenBCI_GUI.this.bgColor);
                this.issuesButton.textColorNotActive = OpenBCI_GUI.this.color(OpenBCI_GUI.this.bgColor);
                this.shopButton.textColorNotActive = OpenBCI_GUI.this.color(OpenBCI_GUI.this.bgColor);
                this.tutorialsButton.textColorNotActive = OpenBCI_GUI.this.color(OpenBCI_GUI.this.bgColor);
            } else if (OpenBCI_GUI.this.colorScheme == OpenBCI_GUI.this.COLOR_SCHEME_ALTERNATIVE_A) {
                this.controlPanelCollapser.setColorNotPressed(OpenBCI_GUI.this.openbciBlue);
                this.fpsButton.setColorNotPressed(OpenBCI_GUI.this.openbciBlue);
                this.highRezButton.setColorNotPressed(OpenBCI_GUI.this.openbciBlue);
                this.issuesButton.setColorNotPressed(OpenBCI_GUI.this.openbciBlue);
                this.shopButton.setColorNotPressed(OpenBCI_GUI.this.openbciBlue);
                this.tutorialsButton.setColorNotPressed(OpenBCI_GUI.this.openbciBlue);
                this.controlPanelCollapser.textColorNotActive = OpenBCI_GUI.this.color(255);
                this.fpsButton.textColorNotActive = OpenBCI_GUI.this.color(255);
                this.highRezButton.textColorNotActive = OpenBCI_GUI.this.color(255);
                this.issuesButton.textColorNotActive = OpenBCI_GUI.this.color(255);
                this.shopButton.textColorNotActive = OpenBCI_GUI.this.color(255);
                this.tutorialsButton.textColorNotActive = OpenBCI_GUI.this.color(255);
            }
            if (OpenBCI_GUI.this.systemMode >= 10) {
                this.updateSecondaryNavButtonsColor();
            }
        }

        public void updateSecondaryNavButtonsColor() {
            if (OpenBCI_GUI.this.colorScheme == OpenBCI_GUI.this.COLOR_SCHEME_DEFAULT) {
                this.filtBPButton.setColorNotPressed(OpenBCI_GUI.this.color(255));
                this.filtNotchButton.setColorNotPressed(OpenBCI_GUI.this.color(255));
                this.layoutButton.setColorNotPressed(OpenBCI_GUI.this.color(255));
                this.filtBPButton.textColorNotActive = OpenBCI_GUI.this.color(OpenBCI_GUI.this.bgColor);
                this.filtNotchButton.textColorNotActive = OpenBCI_GUI.this.color(OpenBCI_GUI.this.bgColor);
                this.layoutButton.textColorNotActive = OpenBCI_GUI.this.color(OpenBCI_GUI.this.bgColor);
            } else if (OpenBCI_GUI.this.colorScheme == OpenBCI_GUI.this.COLOR_SCHEME_ALTERNATIVE_A) {
                this.filtBPButton.setColorNotPressed(OpenBCI_GUI.this.color(57, 128, 204));
                this.filtNotchButton.setColorNotPressed(OpenBCI_GUI.this.color(57, 128, 204));
                this.layoutButton.setColorNotPressed(OpenBCI_GUI.this.color(57, 128, 204));
                this.filtBPButton.textColorNotActive = OpenBCI_GUI.this.color(255);
                this.filtNotchButton.textColorNotActive = OpenBCI_GUI.this.color(255);
                this.layoutButton.textColorNotActive = OpenBCI_GUI.this.color(255);
            }
        }

        public void update() {
            if (OpenBCI_GUI.this.systemMode >= 10) {
                this.layoutSelector.update();
                this.tutorialSelector.update();
            }
        }

        public void draw() {
            OpenBCI_GUI.this.pushStyle();
            if (OpenBCI_GUI.this.colorScheme == OpenBCI_GUI.this.COLOR_SCHEME_DEFAULT) {
                OpenBCI_GUI.this.noStroke();
                OpenBCI_GUI.this.fill(229);
                OpenBCI_GUI.this.rect(0.0f, 0.0f, OpenBCI_GUI.this.width, OpenBCI_GUI.this.topNav_h);
                OpenBCI_GUI.this.stroke(OpenBCI_GUI.this.bgColor);
                OpenBCI_GUI.this.fill(255);
                OpenBCI_GUI.this.rect(-1.0f, 0.0f, OpenBCI_GUI.this.width + 2, OpenBCI_GUI.this.navBarHeight);
                OpenBCI_GUI.this.image(OpenBCI_GUI.this.logo_blue, OpenBCI_GUI.this.width / 2 - 64 - 2, 6.0f, 128.0f, 22.0f);
            } else if (OpenBCI_GUI.this.colorScheme == OpenBCI_GUI.this.COLOR_SCHEME_ALTERNATIVE_A) {
                OpenBCI_GUI.this.noStroke();
                OpenBCI_GUI.this.fill(100);
                OpenBCI_GUI.this.fill(57.0f, 128.0f, 204.0f);
                OpenBCI_GUI.this.rect(0.0f, 0.0f, OpenBCI_GUI.this.width, OpenBCI_GUI.this.topNav_h);
                OpenBCI_GUI.this.stroke(OpenBCI_GUI.this.bgColor);
                OpenBCI_GUI.this.fill(31.0f, 69.0f, 110.0f);
                OpenBCI_GUI.this.rect(-1.0f, 0.0f, OpenBCI_GUI.this.width + 2, OpenBCI_GUI.this.navBarHeight);
                OpenBCI_GUI.this.image(OpenBCI_GUI.this.logo_white, OpenBCI_GUI.this.width / 2 - 64 - 2, 6.0f, 128.0f, 22.0f);
            }
            OpenBCI_GUI.this.popStyle();
            if (OpenBCI_GUI.this.systemMode == 10) {
                this.stopButton.draw();
                this.filtBPButton.draw();
                this.filtNotchButton.draw();
                this.layoutButton.draw();
            }
            this.controlPanelCollapser.draw();
            this.fpsButton.draw();
            this.tutorialsButton.draw();
            this.issuesButton.draw();
            this.shopButton.draw();
            this.layoutSelector.draw();
            this.tutorialSelector.draw();
        }

        public void screenHasBeenResized(int _x, int _y) {
            this.tutorialsButton.but_x = OpenBCI_GUI.this.width - 3 - this.tutorialsButton.but_dx;
            this.issuesButton.but_x = OpenBCI_GUI.this.width - 6 - this.issuesButton.but_dx - this.tutorialsButton.but_dx;
            this.shopButton.but_x = OpenBCI_GUI.this.width - 9 - this.shopButton.but_dx - this.issuesButton.but_dx - this.tutorialsButton.but_dx;
            if (OpenBCI_GUI.this.systemMode == 10) {
                this.layoutButton.but_x = OpenBCI_GUI.this.width - 3 - this.layoutButton.but_dx;
                this.layoutSelector.screenResized();
                this.tutorialSelector.screenResized();
            }
        }

        public void mousePressed() {
            if (OpenBCI_GUI.this.systemMode >= 10) {
                if (this.stopButton.isMouseHere()) {
                    this.stopButton.setIsActive(true);
                    OpenBCI_GUI.this.stopButtonWasPressed();
                }
                if (this.filtBPButton.isMouseHere()) {
                    this.filtBPButton.setIsActive(true);
                    OpenBCI_GUI.this.incrementFilterConfiguration();
                }
                if (OpenBCI_GUI.this.topNav.filtNotchButton.isMouseHere()) {
                    this.filtNotchButton.setIsActive(true);
                    OpenBCI_GUI.this.incrementNotchConfiguration();
                }
                if (this.layoutButton.isMouseHere()) {
                    this.layoutButton.setIsActive(true);
                }
            }
            if (this.controlPanelCollapser.isMouseHere()) {
                if (this.controlPanelCollapser.isActive && OpenBCI_GUI.this.systemMode == 10) {
                    this.controlPanelCollapser.setIsActive(false);
                    OpenBCI_GUI.this.controlPanel.close();
                } else {
                    this.controlPanelCollapser.setIsActive(true);
                    OpenBCI_GUI.this.controlPanel.open();
                }
            } else if (OpenBCI_GUI.this.controlPanel.isOpen) {
                OpenBCI_GUI.this.controlPanel.CPmousePressed();
            }
            if (OpenBCI_GUI.this.controlPanel.isOpen) {
                this.controlPanelCollapser.setIsActive(true);
            }
            if (this.fpsButton.isMouseHere()) {
                this.fpsButton.setIsActive(true);
            }
            if (this.tutorialsButton.isMouseHere()) {
                this.tutorialsButton.setIsActive(true);
            }
            if (this.issuesButton.isMouseHere()) {
                this.issuesButton.setIsActive(true);
            }
            if (this.shopButton.isMouseHere()) {
                this.shopButton.setIsActive(true);
            }
            this.layoutSelector.mousePressed();
            this.tutorialSelector.mousePressed();
        }

        public void mouseReleased() {
            if (this.fpsButton.isMouseHere() && this.fpsButton.isActive()) {
                OpenBCI_GUI.this.toggleFrameRate();
            }
            if (this.tutorialsButton.isMouseHere() && this.tutorialsButton.isActive()) {
                this.tutorialSelector.toggleVisibility();
                this.tutorialsButton.setIsActive(true);
            }
            if (this.issuesButton.isMouseHere() && this.issuesButton.isActive()) {
                this.issuesButton.goToURL();
            }
            if (this.shopButton.isMouseHere() && this.shopButton.isActive()) {
                this.shopButton.goToURL();
            }
            if (OpenBCI_GUI.this.systemMode == 10) {
                if (!this.tutorialSelector.isVisible && this.layoutButton.isMouseHere() && this.layoutButton.isActive()) {
                    this.layoutSelector.toggleVisibility();
                    this.layoutButton.setIsActive(true);
                    OpenBCI_GUI.this.wm.printLayouts();
                }
                this.stopButton.setIsActive(false);
                this.filtBPButton.setIsActive(false);
                this.filtNotchButton.setIsActive(false);
                this.layoutButton.setIsActive(false);
            }
            this.fpsButton.setIsActive(false);
            this.highRezButton.setIsActive(false);
            this.tutorialsButton.setIsActive(false);
            this.issuesButton.setIsActive(false);
            this.shopButton.setIsActive(false);
            this.layoutSelector.mouseReleased();
            this.tutorialSelector.mouseReleased();
        }
    }

    class TutorialSelector {
        int x;
        int y;
        int w = 180;
        int h;
        int margin;
        int b_w;
        int b_h;
        boolean isVisible;
        ArrayList<Button> tutorialOptions;

        TutorialSelector() {
            this.x = OpenBCI_GUI.this.width - this.w - 3;
            this.y = OpenBCI_GUI.this.navBarHeight - 3;
            this.margin = 6;
            this.b_w = this.w - this.margin * 2;
            this.b_h = 22;
            this.h = this.margin * 3 + this.b_h * 2;
            this.isVisible = false;
            this.tutorialOptions = new ArrayList();
            this.addTutorialButtons();
        }

        public void update() {
        }

        public void draw() {
            if (this.isVisible) {
                OpenBCI_GUI.this.pushStyle();
                OpenBCI_GUI.this.stroke(OpenBCI_GUI.this.bgColor);
                OpenBCI_GUI.this.fill(31.0f, 69.0f, 110.0f);
                OpenBCI_GUI.this.rect(this.x, this.y, this.w, this.h);
                int i = 0;
                while (i < this.tutorialOptions.size()) {
                    this.tutorialOptions.get(i).draw();
                    ++i;
                }
                OpenBCI_GUI.this.fill(OpenBCI_GUI.this.openbciBlue);
                OpenBCI_GUI.this.noStroke();
                OpenBCI_GUI.this.rect(this.x + this.w - (OpenBCI_GUI.this.topNav.tutorialsButton.but_dx - 1), this.y, OpenBCI_GUI.this.topNav.tutorialsButton.but_dx - 1, 1.0f);
                OpenBCI_GUI.this.popStyle();
            }
        }

        public void isMouseHere() {
        }

        public void mousePressed() {
            if (this.isVisible) {
                int i = 0;
                while (i < this.tutorialOptions.size()) {
                    if (this.tutorialOptions.get(i).isMouseHere()) {
                        this.tutorialOptions.get(i).setIsActive(true);
                    }
                    ++i;
                }
            }
        }

        public void mouseReleased() {
            if (this.isVisible) {
                if (!(OpenBCI_GUI.this.mouseX >= this.x && OpenBCI_GUI.this.mouseX <= this.x + this.w && OpenBCI_GUI.this.mouseY >= this.y && OpenBCI_GUI.this.mouseY <= this.y + this.h || OpenBCI_GUI.this.topNav.tutorialsButton.isMouseHere())) {
                    this.toggleVisibility();
                }
                int i = 0;
                while (i < this.tutorialOptions.size()) {
                    if (this.tutorialOptions.get(i).isMouseHere() && this.tutorialOptions.get(i).isActive()) {
                        int tutorialSelected = i + 1;
                        this.tutorialOptions.get(i).setIsActive(false);
                        this.tutorialOptions.get(i).goToURL();
                        OpenBCI_GUI.println((String)("Attempting to use your default web browser to open " + this.tutorialOptions.get((int)i).myURL));
                        OpenBCI_GUI.this.output("Layout [" + tutorialSelected + "] selected.");
                        this.toggleVisibility();
                    }
                    ++i;
                }
            }
        }

        public void screenResized() {
            int oldX = this.x;
            this.x = OpenBCI_GUI.this.width - this.w - 3;
            int dx = oldX - this.x;
            int i = 0;
            while (i < this.tutorialOptions.size()) {
                this.tutorialOptions.get(i).setX(this.tutorialOptions.get((int)i).but_x - dx);
                ++i;
            }
        }

        public void toggleVisibility() {
            block6: {
                boolean bl = this.isVisible = !this.isVisible;
                if (OpenBCI_GUI.this.systemMode < 10) break block6;
                if (this.isVisible) {
                    int i = 0;
                    while (i < OpenBCI_GUI.this.wm.widgets.size()) {
                        int j = 0;
                        while (j < OpenBCI_GUI.this.wm.widgets.get((int)i).cp5_widget.getAll().size()) {
                            OpenBCI_GUI.this.wm.widgets.get((int)i).cp5_widget.getController(((ControllerInterface)OpenBCI_GUI.this.wm.widgets.get((int)i).cp5_widget.getAll().get(j)).getAddress()).lock();
                            ++j;
                        }
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < OpenBCI_GUI.this.wm.widgets.size()) {
                        int j = 0;
                        while (j < OpenBCI_GUI.this.wm.widgets.get((int)i).cp5_widget.getAll().size()) {
                            OpenBCI_GUI.this.wm.widgets.get((int)i).cp5_widget.getController(((ControllerInterface)OpenBCI_GUI.this.wm.widgets.get((int)i).cp5_widget.getAll().get(j)).getAddress()).unlock();
                            ++j;
                        }
                        ++i;
                    }
                }
            }
        }

        public void addTutorialButtons() {
            int buttonNumber = 0;
            Button tempTutorialButton = new Button(this.x + this.margin, this.y + this.margin * (buttonNumber + 1) + this.b_h * buttonNumber, this.b_w, this.b_h, "Getting Started");
            tempTutorialButton.setFont(OpenBCI_GUI.this.p5, 12);
            tempTutorialButton.setURL("http://docs.openbci.com/Tutorials/01-Cyton_Getting%20Started_Guide");
            this.tutorialOptions.add(tempTutorialButton);
            buttonNumber = 1;
            this.h = this.margin * (buttonNumber + 2) + this.b_h * (buttonNumber + 1);
            tempTutorialButton = new Button(this.x + this.margin, this.y + this.margin * (buttonNumber + 1) + this.b_h * buttonNumber, this.b_w, this.b_h, "Testing Impedance");
            tempTutorialButton.setFont(OpenBCI_GUI.this.p5, 12);
            tempTutorialButton.setURL("http://docs.openbci.com/Tutorials/01-Cyton_Getting%20Started_Guide#cyton-getting-started-guide-v-connect-yourself-to-openbci-4-launch-the-gui-and-adjust-your-channel-settings");
            this.tutorialOptions.add(tempTutorialButton);
            buttonNumber = 2;
            this.h = this.margin * (buttonNumber + 2) + this.b_h * (buttonNumber + 1);
            tempTutorialButton = new Button(this.x + this.margin, this.y + this.margin * (buttonNumber + 1) + this.b_h * buttonNumber, this.b_w, this.b_h, "OpenBCI Forum");
            tempTutorialButton.setFont(OpenBCI_GUI.this.p5, 12);
            tempTutorialButton.setURL("http://openbci.com/index.php/forum/");
            this.tutorialOptions.add(tempTutorialButton);
            buttonNumber = 3;
            this.h = this.margin * (buttonNumber + 2) + this.b_h * (buttonNumber + 1);
            tempTutorialButton = new Button(this.x + this.margin, this.y + this.margin * (buttonNumber + 1) + this.b_h * buttonNumber, this.b_w, this.b_h, "Building Custom Widgets");
            tempTutorialButton.setFont(OpenBCI_GUI.this.p5, 12);
            tempTutorialButton.setURL("http://docs.openbci.com/Tutorials/15-Custom_Widgets");
            this.tutorialOptions.add(tempTutorialButton);
        }

        public void updateLayoutOptionButtons() {
        }
    }

    class W_AnalogRead
    extends Widget {
        int numAnalogReadBars;
        float xF;
        float yF;
        float wF;
        float hF;
        float ts_padding;
        float ts_x;
        float ts_y;
        float ts_h;
        float ts_w;
        float plotBottomWell;
        float playbackWidgetHeight;
        int analogReadBarHeight;
        AnalogReadBar[] analogReadBars;
        int[] xLimOptions;
        int[] yLimOptions;
        boolean allowSpillover;
        TextBox[] chanValuesMontage;
        boolean showMontageValues;
        private boolean visible;
        private boolean updating;
        int startingVertScaleIndex;
        int startingHoriztonalScaleIndex;
        private boolean hasScrollbar;
        Button analogModeButton;

        W_AnalogRead(PApplet _parent) {
            super(_parent);
            this.xLimOptions = new int[]{1, 3, 5, 7};
            int[] nArray = new int[7];
            nArray[1] = 50;
            nArray[2] = 100;
            nArray[3] = 200;
            nArray[4] = 400;
            nArray[5] = 1000;
            nArray[6] = 10000;
            this.yLimOptions = nArray;
            this.allowSpillover = false;
            this.visible = true;
            this.updating = true;
            this.startingVertScaleIndex = 5;
            this.startingHoriztonalScaleIndex = 2;
            this.hasScrollbar = false;
            this.addDropdown("VertScale_AR", "Vert Scale", Arrays.asList("Auto", "50", "100", "200", "400", "1000", "10000"), this.startingVertScaleIndex);
            this.addDropdown("Duration_AR", "Window", Arrays.asList("1 sec", "3 sec", "5 sec", "7 sec"), this.startingHoriztonalScaleIndex);
            this.numAnalogReadBars = OpenBCI_GUI.this.cyton.isWifi() ? 2 : 3;
            this.xF = PApplet.parseFloat((int)this.x);
            this.yF = PApplet.parseFloat((int)this.y);
            this.wF = PApplet.parseFloat((int)this.w);
            this.hF = PApplet.parseFloat((int)this.h);
            this.plotBottomWell = 45.0f;
            this.ts_padding = 10.0f;
            this.ts_x = this.xF + this.ts_padding;
            this.ts_y = this.yF + this.ts_padding;
            this.ts_w = this.wF - this.ts_padding * 2.0f;
            this.ts_h = this.hF - this.playbackWidgetHeight - this.plotBottomWell - this.ts_padding * 2.0f;
            this.analogReadBarHeight = PApplet.parseInt((float)(this.ts_h / (float)this.numAnalogReadBars));
            this.analogReadBars = new AnalogReadBar[this.numAnalogReadBars];
            int i = 0;
            while (i < this.numAnalogReadBars) {
                AnalogReadBar tempBar;
                OpenBCI_GUI.println((String)("init analog read bar " + i));
                int analogReadBarY = PApplet.parseInt((float)this.ts_y) + i * this.analogReadBarHeight;
                this.analogReadBars[i] = tempBar = new AnalogReadBar(_parent, i + 5, PApplet.parseInt((float)this.ts_x), analogReadBarY, PApplet.parseInt((float)this.ts_w), this.analogReadBarHeight);
                this.analogReadBars[i].adjustVertScale(this.yLimOptions[this.startingVertScaleIndex]);
                this.analogReadBars[i].adjustTimeAxis(this.xLimOptions[this.startingHoriztonalScaleIndex]);
                ++i;
            }
            this.analogModeButton = new Button(this.x + 3, this.y + 3 - OpenBCI_GUI.this.navHeight, 120, OpenBCI_GUI.this.navHeight - 6, "Turn Analog Read On", 12);
            this.analogModeButton.setCornerRoundess(OpenBCI_GUI.this.navHeight - 6);
            this.analogModeButton.setFont(OpenBCI_GUI.this.p6, 10);
            this.analogModeButton.setColorNotPressed(OpenBCI_GUI.this.color(57, 128, 204));
            this.analogModeButton.textColorNotActive = OpenBCI_GUI.this.color(255);
            this.analogModeButton.hasStroke(false);
            if (OpenBCI_GUI.this.cyton.isWifi()) {
                this.analogModeButton.setHelpText("Click this button to activate/deactivate the analog read of your Cyton board from A5(D11) and A6(D12)");
            } else {
                this.analogModeButton.setHelpText("Click this button to activate/deactivate the analog read of your Cyton board from A5(D11), A6(D12) and A7(D13)");
            }
        }

        public boolean isVisible() {
            return this.visible;
        }

        public boolean isUpdating() {
            return this.updating;
        }

        public void setVisible(boolean _visible) {
            this.visible = _visible;
        }

        public void setUpdating(boolean _updating) {
            this.updating = _updating;
        }

        @Override
        public void update() {
            if (this.visible && this.updating) {
                super.update();
                int i = 0;
                while (i < this.numAnalogReadBars) {
                    this.analogReadBars[i].update();
                    ++i;
                }
            }
        }

        @Override
        public void draw() {
            if (this.visible) {
                super.draw();
                OpenBCI_GUI.this.pushStyle();
                this.analogModeButton.draw();
                if (OpenBCI_GUI.this.cyton.getBoardMode() != 2) {
                    this.analogModeButton.setString("Turn Analog Read On");
                } else {
                    this.analogModeButton.setString("Turn Analog Read Off");
                    int i = 0;
                    while (i < this.numAnalogReadBars) {
                        this.analogReadBars[i].draw();
                        ++i;
                    }
                }
                OpenBCI_GUI.this.popStyle();
            }
        }

        @Override
        public void screenResized() {
            super.screenResized();
            this.xF = PApplet.parseFloat((int)this.x);
            this.yF = PApplet.parseFloat((int)this.y);
            this.wF = PApplet.parseFloat((int)this.w);
            this.hF = PApplet.parseFloat((int)this.h);
            this.ts_x = this.xF + this.ts_padding;
            this.ts_y = this.yF + this.ts_padding;
            this.ts_w = this.wF - this.ts_padding * 2.0f;
            this.ts_h = this.hF - this.playbackWidgetHeight - this.plotBottomWell - this.ts_padding * 2.0f;
            this.analogReadBarHeight = PApplet.parseInt((float)(this.ts_h / (float)this.numAnalogReadBars));
            int i = 0;
            while (i < this.numAnalogReadBars) {
                int analogReadBarY = PApplet.parseInt((float)this.ts_y) + i * this.analogReadBarHeight;
                this.analogReadBars[i].screenResized(PApplet.parseInt((float)this.ts_x), analogReadBarY, PApplet.parseInt((float)this.ts_w), this.analogReadBarHeight);
                ++i;
            }
            this.analogModeButton.setPos(this.x + 3, this.y + 3 - OpenBCI_GUI.this.navHeight);
        }

        @Override
        public void mousePressed() {
            super.mousePressed();
            if (this.analogModeButton.isMouseHere()) {
                this.analogModeButton.setIsActive(true);
            }
        }

        @Override
        public void mouseReleased() {
            super.mouseReleased();
            if (this.analogModeButton.isActive && this.analogModeButton.isMouseHere() && OpenBCI_GUI.this.cyton.isPortOpen()) {
                if (OpenBCI_GUI.this.cyton.getBoardMode() != 2) {
                    OpenBCI_GUI.this.cyton.setBoardMode(2);
                    if (OpenBCI_GUI.this.cyton.isWifi()) {
                        OpenBCI_GUI.this.output("Starting to read analog inputs on pin marked A5 (D11) and A6 (D12)");
                    } else {
                        OpenBCI_GUI.this.output("Starting to read analog inputs on pin marked A5 (D11), A6 (D12) and A7 (D13)");
                    }
                } else {
                    OpenBCI_GUI.this.cyton.setBoardMode(0);
                    OpenBCI_GUI.this.output("Starting to read accelerometer");
                }
            }
            this.analogModeButton.setIsActive(false);
        }
    }

    class W_BandPower
    extends Widget {
        GPlot plot3;
        String[] bands;

        W_BandPower(PApplet _parent) {
            super(_parent);
            this.bands = new String[]{"DELTA", "THETA", "ALPHA", "BETA", "GAMMA"};
            this.plot3 = new GPlot(_parent, (float)this.x, (float)(this.y - OpenBCI_GUI.this.navHeight), (float)this.w, (float)(this.h + OpenBCI_GUI.this.navHeight));
            this.plot3.setPos((float)this.x, (float)this.y);
            this.plot3.setDim((float)this.w, (float)this.h);
            this.plot3.setLogScale("y");
            this.plot3.setYLim(0.1f, 100.0f);
            this.plot3.setXLim(0.0f, 5.0f);
            this.plot3.getYAxis().setNTicks(9);
            this.plot3.getTitle().setTextAlignment(37);
            this.plot3.getTitle().setRelativePos(0.0f);
            this.plot3.getYAxis().getAxisLabel().setText("(uV)^2 / Hz per channel");
            this.plot3.getYAxis().getAxisLabel().setTextAlignment(39);
            this.plot3.getYAxis().getAxisLabel().setRelativePos(1.0f);
            this.plot3.startHistograms(0);
            this.plot3.getHistogram().setDrawLabels(true);
            this.plot3.getHistogram().setBgColors(new int[]{OpenBCI_GUI.this.color(0, 0, 255, 50), OpenBCI_GUI.this.color(0, 0, 255, 100), OpenBCI_GUI.this.color(0, 0, 255, 150), OpenBCI_GUI.this.color(0, 0, 255, 200)});
        }

        @Override
        public void update() {
            super.update();
            GPointsArray points3 = new GPointsArray(OpenBCI_GUI.this.dataProcessing.headWidePower.length);
            points3.add(0.5f, OpenBCI_GUI.this.dataProcessing.headWidePower[0], "DELTA");
            points3.add(1.5f, OpenBCI_GUI.this.dataProcessing.headWidePower[1], "THETA");
            points3.add(2.5f, OpenBCI_GUI.this.dataProcessing.headWidePower[2], "ALPHA");
            points3.add(3.5f, OpenBCI_GUI.this.dataProcessing.headWidePower[3], "BETA");
            points3.add(4.5f, OpenBCI_GUI.this.dataProcessing.headWidePower[4], "GAMMA");
            this.plot3.setPoints(points3);
            this.plot3.getTitle().setText("Band Power");
        }

        @Override
        public void draw() {
            super.draw();
            this.plot3.beginDraw();
            this.plot3.drawBackground();
            this.plot3.drawBox();
            this.plot3.drawYAxis();
            this.plot3.drawTitle();
            this.plot3.drawHistograms();
            this.plot3.endDraw();
        }

        @Override
        public void screenResized() {
            super.screenResized();
            this.plot3.setPos((float)this.x, (float)(this.y - OpenBCI_GUI.this.navHeight));
            this.plot3.setOuterDim((float)this.w, (float)(this.h + OpenBCI_GUI.this.navHeight));
        }

        @Override
        public void mousePressed() {
            super.mousePressed();
        }

        @Override
        public void mouseReleased() {
            super.mouseReleased();
        }

        public void customFunction() {
        }
    }

    class W_DigitalRead
    extends Widget {
        int numDigitalReadDots;
        float xF;
        float yF;
        float wF;
        float hF;
        int dot_padding;
        float dot_x;
        float dot_y;
        float dot_h;
        float dot_w;
        float plotBottomWell;
        float playbackWidgetHeight;
        int digitalReadDotHeight;
        DigitalReadDot[] digitalReadDots;
        TextBox[] chanValuesMontage;
        boolean showMontageValues;
        private boolean visible;
        private boolean updating;
        Button digitalModeButton;

        W_DigitalRead(PApplet _parent) {
            super(_parent);
            this.visible = true;
            this.updating = true;
            this.numDigitalReadDots = OpenBCI_GUI.this.cyton.isWifi() ? 3 : 5;
            this.xF = PApplet.parseFloat((int)this.x);
            this.yF = PApplet.parseFloat((int)this.y);
            this.wF = PApplet.parseFloat((int)this.w);
            this.hF = PApplet.parseFloat((int)this.h);
            this.dot_padding = 10;
            this.dot_x = this.xF + (float)this.dot_padding;
            this.dot_y = this.yF + (float)this.dot_padding;
            this.dot_w = this.wF - (float)(this.dot_padding * 2);
            this.dot_h = this.hF - this.playbackWidgetHeight - this.plotBottomWell - (float)(this.dot_padding * 2);
            this.digitalReadDotHeight = PApplet.parseInt((float)(this.dot_h / (float)this.numDigitalReadDots));
            this.digitalReadDots = new DigitalReadDot[this.numDigitalReadDots];
            int i = 0;
            while (i < this.numDigitalReadDots) {
                DigitalReadDot tempDot;
                int digitalReadDotY = PApplet.parseInt((float)this.dot_y) + i * this.digitalReadDotHeight;
                int digitalReadDotX = PApplet.parseInt((float)this.dot_x) + i * this.digitalReadDotHeight;
                int digitalPin = 0;
                digitalPin = i == 0 ? 11 : (i == 1 ? 12 : (i == 2 ? (OpenBCI_GUI.this.cyton.isWifi() ? 17 : 13) : (i == 3 ? 17 : 18)));
                this.digitalReadDots[i] = tempDot = new DigitalReadDot(_parent, digitalPin, digitalReadDotX, digitalReadDotY, PApplet.parseInt((float)this.dot_w), this.digitalReadDotHeight, this.dot_padding);
                ++i;
            }
            this.digitalModeButton = new Button(this.x + 3, this.y + 3 - OpenBCI_GUI.this.navHeight, 120, OpenBCI_GUI.this.navHeight - 6, "Turn Analog Read On", 12);
            this.digitalModeButton.setCornerRoundess(OpenBCI_GUI.this.navHeight - 6);
            this.digitalModeButton.setFont(OpenBCI_GUI.this.p6, 10);
            this.digitalModeButton.setColorNotPressed(OpenBCI_GUI.this.color(57, 128, 204));
            this.digitalModeButton.textColorNotActive = OpenBCI_GUI.this.color(255);
            this.digitalModeButton.hasStroke(false);
            if (OpenBCI_GUI.this.cyton.isWifi()) {
                this.digitalModeButton.setHelpText("Click this button to activate/deactivate digital reading on the Cyton D11, D12, and D17");
            } else {
                this.digitalModeButton.setHelpText("Click this button to activate/deactivate digital reading on the Cyton D11, D12, D13, D17 and D18");
            }
        }

        public boolean isVisible() {
            return this.visible;
        }

        public boolean isUpdating() {
            return this.updating;
        }

        public void setVisible(boolean _visible) {
            this.visible = _visible;
        }

        public void setUpdating(boolean _updating) {
            this.updating = _updating;
        }

        @Override
        public void update() {
            if (this.visible && this.updating) {
                super.update();
                int i = 0;
                while (i < this.numDigitalReadDots) {
                    this.digitalReadDots[i].update();
                    ++i;
                }
            }
        }

        @Override
        public void draw() {
            if (this.visible) {
                super.draw();
                OpenBCI_GUI.this.pushStyle();
                this.digitalModeButton.draw();
                if (OpenBCI_GUI.this.cyton.getBoardMode() != 3) {
                    this.digitalModeButton.setString("Turn Digital Read On");
                } else {
                    this.digitalModeButton.setString("Turn Digital Read Off");
                    int i = 0;
                    while (i < this.numDigitalReadDots) {
                        this.digitalReadDots[i].draw();
                        ++i;
                    }
                }
                OpenBCI_GUI.this.popStyle();
            }
        }

        @Override
        public void screenResized() {
            super.screenResized();
            this.xF = PApplet.parseFloat((int)this.x);
            this.yF = PApplet.parseFloat((int)this.y);
            this.wF = PApplet.parseFloat((int)this.w);
            this.hF = PApplet.parseFloat((int)this.h);
            this.digitalReadDotHeight = this.wF > this.hF ? PApplet.parseInt((float)(this.hF / (float)(this.numDigitalReadDots + 1))) : PApplet.parseInt((float)(this.wF / (float)(this.numDigitalReadDots + 1)));
            if (this.numDigitalReadDots == 3) {
                this.digitalReadDots[0].screenResized(this.x + PApplet.parseInt((float)(this.wF * 0.33333334f)), this.y + PApplet.parseInt((float)(this.hF * 0.33333334f)), this.digitalReadDotHeight, this.digitalReadDotHeight);
                this.digitalReadDots[1].screenResized(this.x + PApplet.parseInt((float)(this.wF / 2.0f)), this.y + PApplet.parseInt((float)(this.hF / 2.0f)), this.digitalReadDotHeight, this.digitalReadDotHeight);
                this.digitalReadDots[2].screenResized(this.x + PApplet.parseInt((float)(this.wF * 0.6666667f)), this.y + PApplet.parseInt((float)(this.hF * 0.6666667f)), this.digitalReadDotHeight, this.digitalReadDotHeight);
            } else {
                int y_pad = this.y + this.dot_padding;
                this.digitalReadDots[0].screenResized(this.x + PApplet.parseInt((float)(this.wF * 0.125f)), y_pad + PApplet.parseInt((float)(this.hF * 0.125f)), this.digitalReadDotHeight, this.digitalReadDotHeight);
                this.digitalReadDots[2].screenResized(this.x + PApplet.parseInt((float)(this.wF / 2.0f)), y_pad + PApplet.parseInt((float)(this.hF / 2.0f)), this.digitalReadDotHeight, this.digitalReadDotHeight);
                this.digitalReadDots[4].screenResized(this.x + PApplet.parseInt((float)(this.wF * 0.875f)), y_pad + PApplet.parseInt((float)(this.hF * 0.875f)), this.digitalReadDotHeight, this.digitalReadDotHeight);
                this.digitalReadDots[1].screenResized(this.digitalReadDots[0].DotX + PApplet.parseInt((float)(this.wF * 0.1875f)), this.digitalReadDots[0].DotY + PApplet.parseInt((float)(this.hF * 0.1875f)), this.digitalReadDotHeight, this.digitalReadDotHeight);
                this.digitalReadDots[3].screenResized(this.digitalReadDots[2].DotX + PApplet.parseInt((float)(this.wF * 0.1875f)), this.digitalReadDots[2].DotY + PApplet.parseInt((float)(this.hF * 0.1875f)), this.digitalReadDotHeight, this.digitalReadDotHeight);
            }
            this.digitalModeButton.setPos(this.x + 3, this.y + 3 - OpenBCI_GUI.this.navHeight);
        }

        @Override
        public void mousePressed() {
            super.mousePressed();
            if (this.digitalModeButton.isMouseHere()) {
                this.digitalModeButton.setIsActive(true);
            }
        }

        @Override
        public void mouseReleased() {
            super.mouseReleased();
            if (this.digitalModeButton.isActive && this.digitalModeButton.isMouseHere() && OpenBCI_GUI.this.cyton.isPortOpen()) {
                if (OpenBCI_GUI.this.cyton.getBoardMode() != 3) {
                    OpenBCI_GUI.this.cyton.setBoardMode(3);
                    if (OpenBCI_GUI.this.cyton.isWifi()) {
                        OpenBCI_GUI.this.output("Starting to read digital inputs on pin marked D11, D12 and D17");
                    } else {
                        OpenBCI_GUI.this.output("Starting to read digital inputs on pin marked D11, D12, D13, D17 and D18");
                    }
                } else {
                    OpenBCI_GUI.this.cyton.setBoardMode(0);
                    OpenBCI_GUI.this.output("Starting to read accelerometer");
                }
            }
            this.digitalModeButton.setIsActive(false);
        }
    }

    class W_Focus
    extends Widget {
        Robot robot;
        boolean enableKey;
        int keyNum;
        boolean enableSerial;
        float alpha_avg;
        float beta_avg;
        boolean isFocused;
        float alpha_thresh;
        float beta_thresh;
        float alpha_upper;
        float beta_upper;
        boolean showAbout;
        PFont myfont;
        PFont f;
        FocusColors focusColors;
        int cBack;
        int cDark;
        int cMark;
        int cFocus;
        int cWave;
        int cPanel;
        float xc;
        float yc;
        float wc;
        float hc;
        float wg;
        float hg;
        float wl;
        float xg1;
        float yg1;
        float xg2;
        float yg2;
        float rp;
        float rb;
        float xb;
        float yb;
        FocusSlider sliderAlphaMid;
        FocusSlider sliderBetaMid;
        FocusSlider_Static sliderAlphaTop;

        W_Focus(PApplet _parent) {
            super(_parent);
            this.enableKey = false;
            this.keyNum = 0;
            this.enableSerial = false;
            this.alpha_avg = 0.0f;
            this.beta_avg = 0.0f;
            this.alpha_thresh = 0.7f;
            this.beta_thresh = 0.7f;
            this.alpha_upper = 2.0f;
            this.beta_upper = 2.0f;
            this.showAbout = false;
            this.myfont = OpenBCI_GUI.this.createFont("fonts/Raleway-SemiBold.otf", 12.0f);
            this.f = OpenBCI_GUI.this.createFont("Arial Bold", 24.0f);
            this.focusColors = FocusColors.GREEN;
            this.onColorChange();
            this.update_graphic_parameters();
            this.sliderAlphaMid = new FocusSlider((float)this.x + this.xg1 + this.wg * 0.8f, (float)this.y + this.yg1 + this.hg / 2.0f, (float)this.y + this.yg1 - this.hg / 2.0f, this.alpha_thresh / this.alpha_upper);
            this.sliderAlphaTop = new FocusSlider_Static((float)this.x + this.xg1 + this.wg * 0.8f, (float)this.y + this.yg1 + this.hg / 2.0f, (float)this.y + this.yg1 - this.hg / 2.0f);
            this.sliderBetaMid = new FocusSlider((float)this.x + this.xg2 + this.wg * 0.8f, (float)this.y + this.yg2 + this.hg / 2.0f, (float)this.y + this.yg2 - this.hg / 2.0f, this.beta_thresh / this.beta_upper);
            this.addDropdown("ChooseFocusColor", "Theme", Arrays.asList("Green", "Orange", "Cyan"), 0);
            this.addDropdown("StrokeKeyWhenFocused", "KeyPress", Arrays.asList("OFF", "UP", "SPACE"), 0);
            this.addDropdown("SerialSendFocused", "Serial", Arrays.asList("OFF", "ON"), 0);
            try {
                this.robot = new Robot();
            }
            catch (AWTException e) {
                e.printStackTrace();
                OpenBCI_GUI.this.exit();
            }
        }

        public void onColorChange() {
            switch (this.focusColors) {
                case GREEN: {
                    this.cBack = -1;
                    this.cDark = -13604698;
                    this.cMark = -11693607;
                    this.cFocus = -4662167;
                    this.cWave = -8902;
                    this.cPanel = -657931;
                    break;
                }
                case ORANGE: {
                    this.cBack = -1;
                    this.cDark = -13141052;
                    this.cMark = -10576158;
                    this.cFocus = -209327;
                    this.cWave = -8902;
                    this.cPanel = -657931;
                    break;
                }
                case CYAN: {
                    this.cBack = -1;
                    this.cDark = -13141052;
                    this.cMark = -10576158;
                    this.cFocus = -7211780;
                    this.cWave = -8902;
                    this.cPanel = -657931;
                }
            }
        }

        @Override
        public void update() {
            super.update();
            this.updateFocusState();
            this.invokeKeyStroke();
            this.sendFocusSerial();
            this.sliderAlphaMid.update();
            this.sliderAlphaTop.update();
            this.sliderBetaMid.update();
            this.alpha_thresh = this.alpha_upper * this.sliderAlphaMid.getVal();
            this.beta_thresh = this.beta_upper * this.sliderBetaMid.getVal();
            this.beta_upper = this.alpha_upper = this.sliderAlphaTop.getVal() * 2.0f;
            this.sliderAlphaMid.setVal(this.alpha_thresh / this.alpha_upper);
            this.sliderBetaMid.setVal(this.beta_thresh / this.beta_upper);
        }

        public void updateFocusState() {
            int alpha_count = 0;
            int beta_count = 0;
            int Ichan = 0;
            while (Ichan < 2) {
                int Ibin = 0;
                while (Ibin < OpenBCI_GUI.this.fftBuff[Ichan].specSize()) {
                    float FFT_freq_Hz = OpenBCI_GUI.this.fftBuff[Ichan].indexToFreq(Ibin);
                    float FFT_value_uV = OpenBCI_GUI.this.fftBuff[Ichan].getBand(Ibin);
                    if (FFT_freq_Hz >= 7.5f && FFT_freq_Hz <= 12.5f) {
                        this.alpha_avg += FFT_value_uV;
                        ++alpha_count;
                    } else if (FFT_freq_Hz > 12.5f && FFT_freq_Hz <= 30.0f) {
                        this.beta_avg += FFT_value_uV;
                        ++beta_count;
                    }
                    ++Ibin;
                }
                ++Ichan;
            }
            this.alpha_avg /= (float)alpha_count;
            this.beta_avg /= (float)beta_count;
            this.isFocused = this.alpha_avg > this.alpha_thresh && this.alpha_avg < this.alpha_upper && this.beta_avg < this.beta_thresh;
        }

        public void invokeKeyStroke() {
            if (this.enableKey) {
                if (this.keyNum == 0) {
                    if (this.isFocused) {
                        this.robot.keyPress(38);
                    } else {
                        this.robot.keyRelease(38);
                    }
                } else if (this.keyNum == 1) {
                    if (this.isFocused) {
                        this.robot.keyPress(32);
                    } else {
                        this.robot.keyRelease(32);
                    }
                }
            }
        }

        public void sendFocusSerial() {
            block3: {
                if (this.enableSerial) {
                    try {
                        OpenBCI_GUI.this.serial_output.write(PApplet.parseInt((boolean)this.isFocused) + 48);
                        OpenBCI_GUI.this.serial_output.write(10);
                    }
                    catch (RuntimeException runtimeException) {
                        if (!OpenBCI_GUI.this.isVerbose) break block3;
                        OpenBCI_GUI.println((String)"serial not present, search 'serial_output' in OpenBCI.pde and check serial settings.");
                    }
                }
            }
        }

        @Override
        public void draw() {
            super.draw();
            OpenBCI_GUI.this.pushStyle();
            OpenBCI_GUI.this.translate(this.x, this.y);
            OpenBCI_GUI.this.textAlign(3, 3);
            OpenBCI_GUI.this.textFont(this.myfont);
            OpenBCI_GUI.this.fill(this.cBack);
            OpenBCI_GUI.this.noStroke();
            OpenBCI_GUI.this.rect(0.0f, 0.0f, this.w, this.h);
            OpenBCI_GUI.this.fill(this.cPanel);
            OpenBCI_GUI.this.noStroke();
            OpenBCI_GUI.this.rect(this.rp, this.rp, (float)this.w - this.rp * 2.0f, (float)this.h - this.rp * 2.0f);
            OpenBCI_GUI.this.noStroke();
            if (this.isFocused) {
                OpenBCI_GUI.this.fill(this.cFocus);
                OpenBCI_GUI.this.stroke(this.cFocus);
            } else {
                OpenBCI_GUI.this.fill(this.cDark);
            }
            OpenBCI_GUI.this.ellipse(this.xc, this.yc, this.wc, this.hc);
            OpenBCI_GUI.this.noStroke();
            if (this.isFocused) {
                OpenBCI_GUI.this.fill(this.cFocus);
                OpenBCI_GUI.this.text("focused!", this.xc, this.yc + this.hc / 2.0f + 16.0f);
            } else {
                OpenBCI_GUI.this.fill(this.cMark);
                OpenBCI_GUI.this.text("not focused", this.xc, this.yc + this.hc / 2.0f + 16.0f);
            }
            OpenBCI_GUI.this.noStroke();
            OpenBCI_GUI.this.fill(this.cDark);
            OpenBCI_GUI.this.rect(this.xg1 - this.wg / 2.0f, this.yg1 - this.hg / 2.0f, this.wg, this.hg);
            float hat = OpenBCI_GUI.map((float)this.alpha_thresh, (float)0.0f, (float)this.alpha_upper, (float)0.0f, (float)this.hg);
            OpenBCI_GUI.this.stroke(this.cMark);
            OpenBCI_GUI.this.line(this.xg1 - this.wl / 2.0f, this.yg1 + this.hg / 2.0f, this.xg1 + this.wl / 2.0f, this.yg1 + this.hg / 2.0f);
            OpenBCI_GUI.this.line(this.xg1 - this.wl / 2.0f, this.yg1 - this.hg / 2.0f, this.xg1 + this.wl / 2.0f, this.yg1 - this.hg / 2.0f);
            OpenBCI_GUI.this.line(this.xg1 - this.wl / 2.0f, this.yg1 + this.hg / 2.0f - hat, this.xg1 + this.wl / 2.0f, this.yg1 + this.hg / 2.0f - hat);
            OpenBCI_GUI.this.noStroke();
            if (this.alpha_avg > this.alpha_thresh && this.alpha_avg < this.alpha_upper) {
                OpenBCI_GUI.this.fill(this.cFocus);
            } else {
                OpenBCI_GUI.this.fill(this.cMark);
            }
            OpenBCI_GUI.this.rect(this.xg1 - this.wg / 2.0f, this.yg1 - this.hg / 2.0f, this.wg, this.hg - hat);
            OpenBCI_GUI.this.text("alpha", this.xg1, this.yg1 + this.hg / 2.0f + 16.0f);
            OpenBCI_GUI.this.stroke(this.cMark);
            OpenBCI_GUI.this.line(this.xg1 + this.wg * 0.8f, this.yg1 - this.hg / 2.0f + 10.0f, this.xg1 + this.wg * 0.8f, this.yg1 + this.hg / 2.0f - hat - 10.0f);
            OpenBCI_GUI.this.noStroke();
            OpenBCI_GUI.this.fill(this.cMark);
            OpenBCI_GUI.this.text(String.format("%.01f", Float.valueOf(this.alpha_upper)), this.xg1 - this.wl / 2.0f - 14.0f, this.yg1 - this.hg / 2.0f);
            OpenBCI_GUI.this.text(String.format("%.01f", Float.valueOf(this.alpha_thresh)), this.xg1 - this.wl / 2.0f - 14.0f, this.yg1 + this.hg / 2.0f - hat);
            OpenBCI_GUI.this.text("0.0", this.xg1 - this.wl / 2.0f - 14.0f, this.yg1 + this.hg / 2.0f);
            OpenBCI_GUI.this.stroke(this.cWave);
            OpenBCI_GUI.this.strokeWeight(4.0f);
            float ha = OpenBCI_GUI.map((float)this.alpha_avg, (float)0.0f, (float)this.alpha_upper, (float)0.0f, (float)this.hg);
            ha = OpenBCI_GUI.constrain((float)ha, (float)0.0f, (float)this.hg);
            OpenBCI_GUI.this.line(this.xg1 - this.wl / 2.0f, this.yg1 + this.hg / 2.0f - ha, this.xg1 + this.wl / 2.0f, this.yg1 + this.hg / 2.0f - ha);
            OpenBCI_GUI.this.strokeWeight(1.0f);
            OpenBCI_GUI.this.noStroke();
            OpenBCI_GUI.this.fill(this.cDark);
            OpenBCI_GUI.this.rect(this.xg2 - this.wg / 2.0f, this.yg2 - this.hg / 2.0f, this.wg, this.hg);
            float hbt = OpenBCI_GUI.map((float)this.beta_thresh, (float)0.0f, (float)this.beta_upper, (float)0.0f, (float)this.hg);
            OpenBCI_GUI.this.stroke(this.cMark);
            OpenBCI_GUI.this.line(this.xg2 - this.wl / 2.0f, this.yg2 + this.hg / 2.0f, this.xg2 + this.wl / 2.0f, this.yg2 + this.hg / 2.0f);
            OpenBCI_GUI.this.line(this.xg2 - this.wl / 2.0f, this.yg2 - this.hg / 2.0f, this.xg2 + this.wl / 2.0f, this.yg2 - this.hg / 2.0f);
            OpenBCI_GUI.this.line(this.xg2 - this.wl / 2.0f, this.yg2 + this.hg / 2.0f - hbt, this.xg2 + this.wl / 2.0f, this.yg2 + this.hg / 2.0f - hbt);
            OpenBCI_GUI.this.noStroke();
            if (this.beta_avg < this.beta_thresh) {
                OpenBCI_GUI.this.fill(this.cFocus);
            } else {
                OpenBCI_GUI.this.fill(this.cMark);
            }
            OpenBCI_GUI.this.rect(this.xg2 - this.wg / 2.0f, this.yg2 + this.hg / 2.0f - hbt, this.wg, hbt);
            OpenBCI_GUI.this.text("beta", this.xg2, this.yg2 + this.hg / 2.0f + 16.0f);
            OpenBCI_GUI.this.stroke(this.cMark);
            float yt = this.yg2 + this.hg / 2.0f - hbt + 10.0f;
            yt = OpenBCI_GUI.constrain((float)yt, (float)(this.yg2 - this.hg / 2.0f + 10.0f), (float)(this.yg2 + this.hg / 2.0f));
            OpenBCI_GUI.this.line(this.xg2 + this.wg * 0.8f, this.yg2 + this.hg / 2.0f, this.xg2 + this.wg * 0.8f, yt);
            OpenBCI_GUI.this.noStroke();
            OpenBCI_GUI.this.fill(this.cMark);
            OpenBCI_GUI.this.text(String.format("%.01f", Float.valueOf(this.beta_upper)), this.xg2 - this.wl / 2.0f - 14.0f, this.yg2 - this.hg / 2.0f);
            OpenBCI_GUI.this.text(String.format("%.01f", Float.valueOf(this.beta_thresh)), this.xg2 - this.wl / 2.0f - 14.0f, this.yg2 + this.hg / 2.0f - hbt);
            OpenBCI_GUI.this.text("0.0", this.xg2 - this.wl / 2.0f - 14.0f, this.yg2 + this.hg / 2.0f);
            OpenBCI_GUI.this.stroke(this.cWave);
            OpenBCI_GUI.this.strokeWeight(4.0f);
            float hb = OpenBCI_GUI.map((float)this.beta_avg, (float)0.0f, (float)this.beta_upper, (float)0.0f, (float)this.hg);
            hb = OpenBCI_GUI.constrain((float)hb, (float)0.0f, (float)this.hg);
            OpenBCI_GUI.this.line(this.xg2 - this.wl / 2.0f, this.yg2 + this.hg / 2.0f - hb, this.xg2 + this.wl / 2.0f, this.yg2 + this.hg / 2.0f - hb);
            OpenBCI_GUI.this.strokeWeight(1.0f);
            OpenBCI_GUI.this.translate(-this.x, -this.y);
            this.sliderAlphaMid.draw();
            this.sliderAlphaTop.draw();
            this.sliderBetaMid.draw();
            OpenBCI_GUI.this.translate(this.x, this.y);
            if (this.showAbout) {
                OpenBCI_GUI.this.stroke(this.cDark);
                OpenBCI_GUI.this.fill(this.cBack);
                OpenBCI_GUI.this.rect(this.rp, this.rp, (float)this.w - this.rp * 2.0f, (float)this.h - this.rp * 2.0f);
                OpenBCI_GUI.this.textAlign(37, 101);
                OpenBCI_GUI.this.fill(this.cDark);
                OpenBCI_GUI.this.text("This widget recognizes a focused mental state by looking at alpha and beta wave levels on channel 1 & 2. For better result, try setting the smooth at 0.98 in FFT plot.\n\nThe algorithm thinks you are focused when the alpha level is between 0.7~2uV and the beta level is between 0~0.7 uV, otherwise it thinks you are not focused. It is designed based on Jordan Frand\u2019s brainwave and tested on other subjects, and you can playback Jordan's file in W_Focus folder.\n\nYou can turn on KeyPress and use your focus play a game, so whenever you are focused, the specified UP arrow or SPACE key will be pressed down, otherwise it will be released. You can also try out the Arduino output feature, example and instructions are included in W_Focus folder. For more information, contact wangshu.sun@hotmail.com.", this.rp * 1.5f, this.rp * 1.5f, (float)this.w - this.rp * 3.0f, (float)this.h - this.rp * 3.0f);
            }
            OpenBCI_GUI.this.noStroke();
            OpenBCI_GUI.this.fill(this.cDark);
            OpenBCI_GUI.this.ellipse(this.xb, this.yb, this.rb, this.rb);
            OpenBCI_GUI.this.fill(this.cBack);
            OpenBCI_GUI.this.textAlign(3, 3);
            if (this.showAbout) {
                OpenBCI_GUI.this.text(OpenBCI_GUI.TCP_CMD_EXAMINE, this.xb, this.yb);
            } else {
                OpenBCI_GUI.this.text("?", this.xb, this.yb);
            }
            OpenBCI_GUI.this.translate(-this.x, -this.y);
            OpenBCI_GUI.this.textAlign(37, 0);
            OpenBCI_GUI.this.popStyle();
        }

        @Override
        public void screenResized() {
            super.screenResized();
            this.update_graphic_parameters();
            this.sliderAlphaMid.screenResized((float)this.x + this.xg1 + this.wg * 0.8f, (float)this.y + this.yg1 + this.hg / 2.0f, (float)this.y + this.yg1 - this.hg / 2.0f);
            this.sliderAlphaTop.screenResized((float)this.x + this.xg1 + this.wg * 0.8f, (float)this.y + this.yg1 + this.hg / 2.0f, (float)this.y + this.yg1 - this.hg / 2.0f);
            this.sliderBetaMid.screenResized((float)this.x + this.xg2 + this.wg * 0.8f, (float)this.y + this.yg2 + this.hg / 2.0f, (float)this.y + this.yg2 - this.hg / 2.0f);
        }

        public void update_graphic_parameters() {
            this.xc = this.w / 4;
            this.yc = this.h / 2;
            this.wc = this.w / 4;
            this.hc = this.w / 4;
            this.wg = 0.07f * (float)this.w;
            this.hg = 0.64f * (float)this.h;
            this.wl = 0.11f * (float)this.w;
            this.xg1 = 0.6f * (float)this.w;
            this.yg1 = 0.5f * (float)this.h;
            this.xg2 = 0.83f * (float)this.w;
            this.yg2 = 0.5f * (float)this.h;
            this.rp = OpenBCI_GUI.max((float)((float)this.w * 0.05f), (float)((float)this.h * 0.05f));
            this.rb = 20.0f;
            this.xb = (float)this.w - this.rp;
            this.yb = this.rp;
        }

        @Override
        public void mousePressed() {
            super.mousePressed();
            if (OpenBCI_GUI.dist((float)OpenBCI_GUI.this.mouseX, (float)OpenBCI_GUI.this.mouseY, (float)(this.xb + (float)this.x), (float)(this.yb + (float)this.y)) <= this.rb) {
                this.showAbout = !this.showAbout;
            }
            this.sliderAlphaMid.mousePressed();
            this.sliderAlphaTop.mousePressed();
            this.sliderBetaMid.mousePressed();
        }

        @Override
        public void mouseReleased() {
            super.mouseReleased();
            this.sliderAlphaMid.mouseReleased();
            this.sliderAlphaTop.mouseReleased();
            this.sliderBetaMid.mouseReleased();
        }
    }

    class W_MarkerMode
    extends Widget {
        int graphStroke;
        int graphBG;
        int textColor;
        int strokeColor;
        int MarkerBuffSize;
        int padding;
        int MarkerWindowWidth;
        int MarkerWindowHeight;
        int MarkerWindowX;
        int MarkerWindowY;
        int eggshell;
        int Xcolor;
        float yMaxMin;
        float currentXvalue;
        int[] X;
        int lastMarker;
        int localValidLastMarker;
        float dummyX;
        float synthTime;
        int synthCount;
        boolean OBCI_inited;
        Button markerModeButton;

        W_MarkerMode(PApplet _parent) {
            super(_parent);
            this.graphStroke = -2960686;
            this.graphBG = -657931;
            this.textColor = -16777216;
            this.MarkerBuffSize = 500;
            this.padding = 30;
            this.lastMarker = 0;
            this.OBCI_inited = true;
            this.strokeColor = OpenBCI_GUI.this.color(138, 146, 153);
            this.eggshell = OpenBCI_GUI.this.color(255, 253, 248);
            this.Xcolor = OpenBCI_GUI.this.color(224, 56, 45);
            this.setGraphDimensions();
            this.yMaxMin = 256.0f;
            this.X = new int[this.MarkerBuffSize];
            this.synthTime = 0.0f;
            this.markerModeButton = new Button(this.x + 3, this.y + 3 - OpenBCI_GUI.this.navHeight, 120, OpenBCI_GUI.this.navHeight - 6, "Turn MarkerMode On", 12);
            this.markerModeButton.setCornerRoundess(OpenBCI_GUI.this.navHeight - 6);
            this.markerModeButton.setFont(OpenBCI_GUI.this.p6, 10);
            this.markerModeButton.setColorNotPressed(OpenBCI_GUI.this.color(57, 128, 204));
            this.markerModeButton.textColorNotActive = OpenBCI_GUI.this.color(255);
            this.markerModeButton.hasStroke(false);
            this.markerModeButton.setHelpText("Click this button to activate/deactivate the MarkerMode of your Cyton board!");
        }

        public void initPlayground(Cyton _OBCI) {
            this.OBCI_inited = true;
        }

        @Override
        public void update() {
            super.update();
            this.localValidLastMarker = OpenBCI_GUI.this.hub.validLastMarker;
            OpenBCI_GUI.this.hub.validLastMarker = 0;
            if (OpenBCI_GUI.this.eegDataSource == 3) {
                this.localValidLastMarker = this.synthesizeMarkerData();
            }
            if (OpenBCI_GUI.this.eegDataSource == 0 || OpenBCI_GUI.this.eegDataSource == 3) {
                if (OpenBCI_GUI.this.isRunning && OpenBCI_GUI.this.cyton.getBoardMode() == 4) {
                    if (this.localValidLastMarker > 0) {
                        this.lastMarker = this.localValidLastMarker;
                    }
                    this.X[this.X.length - 1] = PApplet.parseInt((float)OpenBCI_GUI.map((float)this.logScaleMarker(this.localValidLastMarker), (float)0.0f, (float)this.yMaxMin, (float)PApplet.parseFloat((int)(this.MarkerWindowY + this.MarkerWindowHeight)), (float)PApplet.parseFloat((int)this.MarkerWindowY)));
                    this.X[this.X.length - 1] = OpenBCI_GUI.constrain((int)this.X[this.X.length - 1], (int)this.MarkerWindowY, (int)(this.MarkerWindowY + this.MarkerWindowHeight));
                    this.shiftWave();
                }
            } else {
                this.currentXvalue = OpenBCI_GUI.this.accelerometerBuff[0][OpenBCI_GUI.this.accelerometerBuff[0].length - 1];
            }
        }

        @Override
        public void draw() {
            super.draw();
            OpenBCI_GUI.this.pushStyle();
            OpenBCI_GUI.this.fill(50);
            OpenBCI_GUI.this.textFont(OpenBCI_GUI.this.p4, 14.0f);
            OpenBCI_GUI.this.textAlign(3, 3);
            OpenBCI_GUI.this.fill(this.graphBG);
            OpenBCI_GUI.this.stroke(this.graphStroke);
            OpenBCI_GUI.this.rect(this.MarkerWindowX, this.MarkerWindowY, this.MarkerWindowWidth, this.MarkerWindowHeight);
            OpenBCI_GUI.this.line(this.MarkerWindowX, this.MarkerWindowY + this.MarkerWindowHeight / 2, this.MarkerWindowX + this.MarkerWindowWidth, this.MarkerWindowY + this.MarkerWindowHeight / 2);
            OpenBCI_GUI.this.fill(50);
            OpenBCI_GUI.this.textFont(OpenBCI_GUI.this.p5, 12.0f);
            OpenBCI_GUI.this.textAlign(3, 3);
            OpenBCI_GUI.this.text((int)this.yMaxMin, this.MarkerWindowX + this.MarkerWindowWidth + 12, this.MarkerWindowY);
            OpenBCI_GUI.this.text(16, this.MarkerWindowX + this.MarkerWindowWidth + 12, this.MarkerWindowY + this.MarkerWindowHeight / 2);
            OpenBCI_GUI.this.text("0", this.MarkerWindowX + this.MarkerWindowWidth + 12, this.MarkerWindowY + this.MarkerWindowHeight);
            OpenBCI_GUI.this.fill(this.graphBG);
            OpenBCI_GUI.this.stroke(this.graphStroke);
            OpenBCI_GUI.this.stroke(180);
            OpenBCI_GUI.this.fill(50);
            OpenBCI_GUI.this.textFont(OpenBCI_GUI.this.p3, 16.0f);
            if (OpenBCI_GUI.this.eegDataSource == 0 || OpenBCI_GUI.this.eegDataSource == 3) {
                this.markerModeButton.draw();
                this.drawMarkerValues();
                this.drawMarkerWave();
            } else {
                this.drawMarkerValues();
                this.drawMarkerWave2();
            }
            OpenBCI_GUI.this.popStyle();
        }

        public void setGraphDimensions() {
            this.MarkerWindowWidth = this.w - this.padding * 2;
            this.MarkerWindowHeight = PApplet.parseInt((float)(PApplet.parseFloat((int)this.h) - PApplet.parseFloat((int)(this.padding * 3))));
            this.MarkerWindowX = this.x + this.padding;
            this.MarkerWindowY = this.y + this.h - this.MarkerWindowHeight - this.padding;
        }

        @Override
        public void screenResized() {
            int prevY = this.y;
            super.screenResized();
            int dy = this.y - prevY;
            OpenBCI_GUI.println((String)("dy = " + dy));
            OpenBCI_GUI.println((String)"Acc Widget -- Screen Resized.");
            this.setGraphDimensions();
            int i = 0;
            while (i < this.X.length) {
                this.X[i] = this.MarkerWindowY + this.MarkerWindowHeight;
                ++i;
            }
            this.markerModeButton.setPos(this.x + 3, this.y + 3 - OpenBCI_GUI.this.navHeight);
        }

        @Override
        public void mousePressed() {
            super.mousePressed();
            if (this.markerModeButton.isMouseHere()) {
                this.markerModeButton.setIsActive(true);
            }
        }

        @Override
        public void mouseReleased() {
            super.mouseReleased();
            if (this.markerModeButton.isActive && this.markerModeButton.isMouseHere() && (OpenBCI_GUI.this.cyton.isPortOpen() && OpenBCI_GUI.this.eegDataSource == 0 || OpenBCI_GUI.this.eegDataSource == 3)) {
                if (OpenBCI_GUI.this.cyton.getBoardMode() != 4) {
                    OpenBCI_GUI.this.cyton.setBoardMode(4);
                    OpenBCI_GUI.this.output("Starting to read markers");
                    this.markerModeButton.setString("Turn Marker Off");
                } else {
                    OpenBCI_GUI.this.cyton.setBoardMode(0);
                    OpenBCI_GUI.this.output("Starting to read accelerometer");
                    this.markerModeButton.setString("Turn Marker On");
                }
            }
            this.markerModeButton.setIsActive(false);
        }

        public void drawMarkerValues() {
            OpenBCI_GUI.this.textAlign(37, 3);
            OpenBCI_GUI.this.textFont(OpenBCI_GUI.this.h1, 20.0f);
            OpenBCI_GUI.this.fill(this.Xcolor);
            OpenBCI_GUI.this.text("Last Marker = " + this.lastMarker, this.x + this.padding, (float)this.y + (float)(this.h / 12) * 1.5f);
        }

        public void shiftWave() {
            int i = 0;
            while (i < this.X.length - 1) {
                this.X[i] = this.X[i + 1];
                ++i;
            }
        }

        public void drawMarkerWave() {
            OpenBCI_GUI.this.noFill();
            OpenBCI_GUI.this.strokeWeight(2.0f);
            OpenBCI_GUI.this.beginShape();
            OpenBCI_GUI.this.stroke(this.Xcolor);
            int i = 0;
            while (i < this.X.length) {
                int xi = PApplet.parseInt((float)OpenBCI_GUI.map((float)i, (float)0.0f, (float)(this.X.length - 1), (float)0.0f, (float)(this.MarkerWindowWidth - 1)));
                OpenBCI_GUI.this.vertex(this.MarkerWindowX + xi, this.X[i]);
                ++i;
            }
            OpenBCI_GUI.this.endShape();
        }

        public void drawMarkerWave2() {
            OpenBCI_GUI.this.noFill();
            OpenBCI_GUI.this.strokeWeight(1.0f);
            OpenBCI_GUI.this.beginShape();
            OpenBCI_GUI.this.stroke(this.Xcolor);
            int i = 0;
            while (i < OpenBCI_GUI.this.accelerometerBuff[0].length) {
                int x = PApplet.parseInt((float)OpenBCI_GUI.map((float)OpenBCI_GUI.this.accelerometerBuff[0][i], (float)(-this.yMaxMin), (float)this.yMaxMin, (float)PApplet.parseFloat((int)(this.MarkerWindowY + this.MarkerWindowHeight)), (float)PApplet.parseFloat((int)this.MarkerWindowY)));
                x = OpenBCI_GUI.constrain((int)x, (int)this.MarkerWindowY, (int)(this.MarkerWindowY + this.MarkerWindowHeight));
                OpenBCI_GUI.this.vertex(this.MarkerWindowX + i, x);
                ++i;
            }
            OpenBCI_GUI.this.endShape();
        }

        public int synthesizeMarkerData() {
            int valueMarker;
            this.synthTime += 0.02f;
            if (this.synthCount++ > 10) {
                valueMarker = PApplet.parseInt((float)((OpenBCI_GUI.sin((float)this.synthTime) + 1.0f) * 127.0f));
                this.synthCount = 0;
            } else {
                valueMarker = 0;
            }
            return valueMarker;
        }

        public int logScaleMarker(float value) {
            return PApplet.parseInt((float)(OpenBCI_GUI.log((float)((float)PApplet.parseInt((float)value) + 1.0f)) * this.yMaxMin / OpenBCI_GUI.log((float)(this.yMaxMin + 1.0f))));
        }
    }

    class W_PulseSensor
    extends Widget {
        int graphStroke;
        int graphBG;
        int textColor;
        int count;
        int heart;
        int PulseBuffSize;
        int BPMbuffSize;
        int PulseWindowWidth;
        int PulseWindowHeight;
        int PulseWindowX;
        int PulseWindowY;
        int BPMwindowWidth;
        int BPMwindowHeight;
        int BPMwindowX;
        int BPMwindowY;
        int BPMposX;
        int BPMposY;
        int IBIposX;
        int IBIposY;
        int padding;
        int eggshell;
        int pulseWave;
        int[] PulseWaveY;
        int[] BPMwaveY;
        boolean rising;
        float theta;
        float amplitude;
        int syntheticMultiplier;
        long thisTime;
        long thatTime;
        int refreshRate;
        int[] rate;
        int sampleCounter;
        int lastBeatTime;
        int P;
        int T;
        int thresh;
        int amp;
        boolean firstBeat;
        boolean secondBeat;
        int BPM;
        int Signal;
        int IBI;
        boolean Pulse;
        boolean QS;
        int lastProcessedDataPacketInd;
        boolean analogReadOn;
        Button analogModeButton;

        W_PulseSensor(PApplet _parent) {
            super(_parent);
            this.graphStroke = -2960686;
            this.graphBG = -657931;
            this.textColor = -16777216;
            this.count = 0;
            this.heart = 0;
            this.PulseBuffSize = OpenBCI_GUI.this.dataPacketBuff.length;
            this.BPMbuffSize = 100;
            this.padding = 15;
            this.P = 512;
            this.T = 512;
            this.thresh = 530;
            this.amp = 0;
            this.firstBeat = true;
            this.secondBeat = false;
            this.IBI = 600;
            this.Pulse = false;
            this.QS = false;
            this.lastProcessedDataPacketInd = 0;
            this.analogReadOn = false;
            this.eggshell = OpenBCI_GUI.this.color(255, 253, 248);
            this.pulseWave = OpenBCI_GUI.this.color(224, 56, 45);
            this.PulseWaveY = new int[this.PulseBuffSize];
            this.BPMwaveY = new int[this.BPMbuffSize];
            this.rate = new int[10];
            this.setPulseWidgetVariables();
            this.initializePulseFinderVariables();
            this.analogModeButton = new Button(this.x + 3, this.y + 3 - OpenBCI_GUI.this.navHeight, 120, OpenBCI_GUI.this.navHeight - 6, "Turn Analog Read On", 12);
            this.analogModeButton.setCornerRoundess(OpenBCI_GUI.this.navHeight - 6);
            this.analogModeButton.setFont(OpenBCI_GUI.this.p6, 10);
            this.analogModeButton.setColorNotPressed(OpenBCI_GUI.this.color(57, 128, 204));
            this.analogModeButton.textColorNotActive = OpenBCI_GUI.this.color(255);
            this.analogModeButton.hasStroke(false);
            this.analogModeButton.setHelpText("Click this button to activate analog reading on the Cyton");
        }

        @Override
        public void update() {
            int numSamplesToProcess;
            super.update();
            if (OpenBCI_GUI.this.curDataPacketInd < 0) {
                return;
            }
            if (OpenBCI_GUI.this.eegDataSource == 0 || OpenBCI_GUI.this.eegDataSource != 1) {
                // empty if block
            }
            if ((numSamplesToProcess = OpenBCI_GUI.this.curDataPacketInd - this.lastProcessedDataPacketInd) < 0) {
                numSamplesToProcess += OpenBCI_GUI.this.dataPacketBuff.length;
            }
            if (numSamplesToProcess > 0) {
                int i = 0;
                while (i < this.PulseWaveY.length - numSamplesToProcess) {
                    this.PulseWaveY[i] = this.PulseWaveY[i + numSamplesToProcess];
                    ++i;
                }
            }
            int samplesProcessed = 0;
            while (samplesProcessed < numSamplesToProcess) {
                ++this.lastProcessedDataPacketInd;
                if (this.lastProcessedDataPacketInd > OpenBCI_GUI.this.dataPacketBuff.length - 1) {
                    this.lastProcessedDataPacketInd = 0;
                }
                int signal = OpenBCI_GUI.this.dataPacketBuff[this.lastProcessedDataPacketInd].auxValues[0];
                this.processSignal(signal);
                this.PulseWaveY[this.PulseWaveY.length - numSamplesToProcess + samplesProcessed] = signal;
                ++samplesProcessed;
            }
            if (this.QS) {
                this.QS = false;
                int i = 0;
                while (i < this.BPMwaveY.length - 1) {
                    this.BPMwaveY[i] = this.BPMwaveY[i + 1];
                    ++i;
                }
                this.BPMwaveY[this.BPMwaveY.length - 1] = this.BPM;
            }
        }

        @Override
        public void draw() {
            super.draw();
            OpenBCI_GUI.this.pushStyle();
            OpenBCI_GUI.this.fill(this.graphBG);
            OpenBCI_GUI.this.stroke(this.graphStroke);
            OpenBCI_GUI.this.rect(this.PulseWindowX, this.PulseWindowY, this.PulseWindowWidth, this.PulseWindowHeight);
            OpenBCI_GUI.this.rect(this.BPMwindowX, this.BPMwindowY, this.BPMwindowWidth, this.BPMwindowHeight);
            OpenBCI_GUI.this.fill(50);
            OpenBCI_GUI.this.textFont(OpenBCI_GUI.this.p4, 16.0f);
            OpenBCI_GUI.this.textAlign(37, 3);
            OpenBCI_GUI.this.text("BPM " + this.BPM, this.BPMposX, this.BPMposY);
            OpenBCI_GUI.this.text("IBI " + this.IBI + "mS", this.IBIposX, this.IBIposY);
            if (this.analogReadOn) {
                this.drawWaves();
            }
            this.analogModeButton.draw();
            OpenBCI_GUI.this.popStyle();
        }

        @Override
        public void screenResized() {
            super.screenResized();
            OpenBCI_GUI.println((String)"Pulse Sensor Widget -- Screen Resized.");
            this.setPulseWidgetVariables();
            this.analogModeButton.setPos(this.x + 3, this.y + 3 - OpenBCI_GUI.this.navHeight);
        }

        @Override
        public void mousePressed() {
            super.mousePressed();
            if (this.analogModeButton.isMouseHere()) {
                this.analogModeButton.setIsActive(true);
            }
        }

        @Override
        public void mouseReleased() {
            super.mouseReleased();
            if (this.analogModeButton.isActive && this.analogModeButton.isMouseHere() && OpenBCI_GUI.this.cyton.isPortOpen()) {
                if (this.analogReadOn) {
                    OpenBCI_GUI.this.cyton.setBoardMode(0);
                    OpenBCI_GUI.this.output("Starting to read accelerometer");
                    this.analogModeButton.setString("Turn Analog Read On");
                } else {
                    OpenBCI_GUI.this.cyton.setBoardMode(2);
                    OpenBCI_GUI.this.output("Starting to read analog inputs on pin marked D11");
                    this.analogModeButton.setString("Turn Analog Read Off");
                }
                this.analogReadOn = !this.analogReadOn;
            }
            this.analogModeButton.setIsActive(false);
        }

        public void setPulseWidgetVariables() {
            this.PulseWindowWidth = this.w / 4 * 3 - this.padding;
            this.PulseWindowHeight = this.h - this.padding * 2;
            this.PulseWindowX = this.x + this.padding;
            this.PulseWindowY = this.y + this.h - this.PulseWindowHeight - this.padding;
            this.BPMwindowWidth = this.w / 4 - (this.padding + this.padding / 2);
            this.BPMwindowHeight = this.PulseWindowHeight;
            this.BPMwindowX = this.PulseWindowX + this.PulseWindowWidth + this.padding / 2;
            this.BPMwindowY = this.PulseWindowY;
            this.BPMposX = this.BPMwindowX + this.padding / 2;
            this.BPMposY = this.y - this.padding;
            this.IBIposX = this.PulseWindowX + this.PulseWindowWidth / 2;
            this.IBIposY = this.y - this.padding;
        }

        public void initializePulseFinderVariables() {
            this.sampleCounter = 0;
            this.lastBeatTime = 0;
            this.P = 512;
            this.T = 512;
            this.thresh = 530;
            this.amp = 0;
            this.firstBeat = true;
            this.secondBeat = false;
            this.BPM = 0;
            this.Signal = 512;
            this.IBI = 600;
            this.Pulse = false;
            this.QS = false;
            this.theta = 0.0f;
            this.amplitude = 300.0f;
            this.syntheticMultiplier = 1;
            this.thatTime = OpenBCI_GUI.this.millis();
            int i = 0;
            while (i < this.PulseWaveY.length) {
                this.PulseWaveY[i] = this.Signal;
                ++i;
            }
            i = 0;
            while (i < this.BPMwaveY.length) {
                this.BPMwaveY[i] = this.BPM;
                ++i;
            }
        }

        public void drawWaves() {
            int yi;
            int xi;
            OpenBCI_GUI.this.noFill();
            OpenBCI_GUI.this.strokeWeight(1.0f);
            OpenBCI_GUI.this.stroke(this.pulseWave);
            OpenBCI_GUI.this.beginShape();
            int i = 0;
            while (i < this.PulseWaveY.length) {
                xi = PApplet.parseInt((float)OpenBCI_GUI.map((float)i, (float)0.0f, (float)(this.PulseWaveY.length - 1), (float)0.0f, (float)(this.PulseWindowWidth - 1)));
                yi = PApplet.parseInt((float)OpenBCI_GUI.map((float)this.PulseWaveY[i], (float)0.0f, (float)1023.0f, (float)PApplet.parseFloat((int)(this.PulseWindowY + this.PulseWindowHeight)), (float)PApplet.parseFloat((int)this.PulseWindowY)));
                OpenBCI_GUI.this.vertex(xi += this.PulseWindowX, yi);
                ++i;
            }
            OpenBCI_GUI.this.endShape();
            OpenBCI_GUI.this.strokeWeight(2.0f);
            OpenBCI_GUI.this.stroke(this.pulseWave);
            OpenBCI_GUI.this.beginShape();
            i = 0;
            while (i < this.BPMwaveY.length) {
                xi = PApplet.parseInt((float)OpenBCI_GUI.map((float)i, (float)0.0f, (float)(this.BPMwaveY.length - 1), (float)0.0f, (float)(this.BPMwindowWidth - 1)));
                yi = PApplet.parseInt((float)OpenBCI_GUI.map((float)this.BPMwaveY[i], (float)0.0f, (float)200.0f, (float)PApplet.parseFloat((int)(this.BPMwindowY + this.BPMwindowHeight)), (float)PApplet.parseFloat((int)this.BPMwindowY)));
                OpenBCI_GUI.this.vertex(xi += this.BPMwindowX, yi);
                ++i;
            }
            OpenBCI_GUI.this.endShape();
        }

        public void processSignal(int sample) {
            this.sampleCounter += 4 * this.syntheticMultiplier;
            int N = this.sampleCounter - this.lastBeatTime;
            if (sample < this.thresh && N > this.IBI / 5 * 3 && sample < this.T) {
                this.T = sample;
            }
            if (sample > this.thresh && sample > this.P) {
                this.P = sample;
            }
            if (N > 250 && sample > this.thresh && !this.Pulse && N > this.IBI / 5 * 3) {
                this.Pulse = true;
                this.IBI = this.sampleCounter - this.lastBeatTime;
                this.lastBeatTime = this.sampleCounter;
                if (this.secondBeat) {
                    this.secondBeat = false;
                    int i = 0;
                    while (i <= 9) {
                        this.rate[i] = this.IBI;
                        ++i;
                    }
                }
                if (this.firstBeat) {
                    this.firstBeat = false;
                    this.secondBeat = true;
                    return;
                }
                int runningTotal = 0;
                int i = 0;
                while (i <= 8) {
                    this.rate[i] = this.rate[i + 1];
                    runningTotal += this.rate[i];
                    ++i;
                }
                this.rate[9] = this.IBI;
                runningTotal += this.rate[9];
                this.BPM = 60000 / (runningTotal /= 10);
                this.BPM = OpenBCI_GUI.constrain((int)this.BPM, (int)0, (int)200);
                this.QS = true;
            }
            if (sample < this.thresh && this.Pulse) {
                this.Pulse = false;
                this.amp = this.P - this.T;
                this.P = this.thresh = this.amp / 2 + this.T;
                this.T = this.thresh;
            }
            if (N > 2500) {
                this.thresh = 530;
                this.P = 512;
                this.T = 512;
                this.lastBeatTime = this.sampleCounter;
                this.firstBeat = true;
                this.secondBeat = false;
            }
        }
    }

    class W_accelerometer
    extends Widget {
        int graphStroke;
        int graphBG;
        int textColor;
        int strokeColor;
        int AccelBuffSize;
        int padding;
        int AccelWindowWidth;
        int AccelWindowHeight;
        int AccelWindowX;
        int AccelWindowY;
        float PolarWindowX;
        float PolarWindowY;
        int PolarWindowWidth;
        int PolarWindowHeight;
        float PolarCorner;
        int eggshell;
        int Xcolor;
        int Ycolor;
        int Zcolor;
        float yMaxMin;
        float currentXvalue;
        float currentYvalue;
        float currentZvalue;
        int[] X;
        int[] Y;
        int[] Z;
        float dummyX;
        float dummyY;
        float dummyZ;
        boolean Xrising;
        boolean Yrising;
        boolean Zrising;
        boolean OBCI_inited;
        Button accelModeButton;

        W_accelerometer(PApplet _parent) {
            super(_parent);
            this.graphStroke = -2960686;
            this.graphBG = -657931;
            this.textColor = -16777216;
            this.AccelBuffSize = 500;
            this.padding = 30;
            this.OBCI_inited = true;
            this.strokeColor = OpenBCI_GUI.this.color(138, 146, 153);
            this.eggshell = OpenBCI_GUI.this.color(255, 253, 248);
            this.Xcolor = OpenBCI_GUI.this.color(224, 56, 45);
            this.Ycolor = OpenBCI_GUI.this.color(49, 113, 89);
            this.Zcolor = OpenBCI_GUI.this.color(54, 87, 158);
            this.setGraphDimensions();
            this.yMaxMin = this.adjustYMaxMinBasedOnSource();
            this.X = new int[this.AccelBuffSize];
            this.Y = new int[this.AccelBuffSize];
            this.Z = new int[this.AccelBuffSize];
            this.Xrising = true;
            this.Yrising = false;
            this.Zrising = true;
            int i = 0;
            while (i < this.X.length) {
                this.X[i] = this.AccelWindowY + this.AccelWindowHeight / 4;
                this.Y[i] = this.AccelWindowY + this.AccelWindowHeight / 2;
                this.Z[i] = this.AccelWindowY + this.AccelWindowHeight / 4 * 3;
                ++i;
            }
            this.accelModeButton = new Button(this.x + 3, this.y + 3 - OpenBCI_GUI.this.navHeight, 120, OpenBCI_GUI.this.navHeight - 6, "Turn Accel. On", 12);
            this.accelModeButton.setCornerRoundess(OpenBCI_GUI.this.navHeight - 6);
            this.accelModeButton.setFont(OpenBCI_GUI.this.p6, 10);
            this.accelModeButton.setColorNotPressed(OpenBCI_GUI.this.color(57, 128, 204));
            this.accelModeButton.textColorNotActive = OpenBCI_GUI.this.color(255);
            this.accelModeButton.hasStroke(false);
            this.accelModeButton.setHelpText("Click this button to activate/deactivate the accelerometer!");
        }

        public void initPlayground(Cyton _OBCI) {
            this.OBCI_inited = true;
        }

        public float adjustYMaxMinBasedOnSource() {
            float _yMaxMin = OpenBCI_GUI.this.eegDataSource == 0 ? 4.0f : (OpenBCI_GUI.this.eegDataSource == 1 || OpenBCI_GUI.this.nchan == 4 ? 2.0f : 4.0f);
            return _yMaxMin;
        }

        @Override
        public void update() {
            super.update();
            if (OpenBCI_GUI.this.isRunning) {
                if (OpenBCI_GUI.this.eegDataSource == 3) {
                    this.synthesizeAccelerometerData();
                    this.currentXvalue = OpenBCI_GUI.map((float)this.X[this.X.length - 1], (float)this.AccelWindowY, (float)(this.AccelWindowY + this.AccelWindowHeight), (float)this.yMaxMin, (float)(-this.yMaxMin));
                    this.currentYvalue = OpenBCI_GUI.map((float)this.Y[this.Y.length - 1], (float)this.AccelWindowY, (float)(this.AccelWindowY + this.AccelWindowHeight), (float)this.yMaxMin, (float)(-this.yMaxMin));
                    this.currentZvalue = OpenBCI_GUI.map((float)this.Z[this.Z.length - 1], (float)this.AccelWindowY, (float)(this.AccelWindowY + this.AccelWindowHeight), (float)this.yMaxMin, (float)(-this.yMaxMin));
                    this.shiftWave();
                } else if (OpenBCI_GUI.this.eegDataSource == 0) {
                    this.currentXvalue = (float)OpenBCI_GUI.this.hub.validAccelValues[0] * OpenBCI_GUI.this.cyton.get_scale_fac_accel_G_per_count();
                    this.currentYvalue = (float)OpenBCI_GUI.this.hub.validAccelValues[1] * OpenBCI_GUI.this.cyton.get_scale_fac_accel_G_per_count();
                    this.currentZvalue = (float)OpenBCI_GUI.this.hub.validAccelValues[2] * OpenBCI_GUI.this.cyton.get_scale_fac_accel_G_per_count();
                    this.X[this.X.length - 1] = PApplet.parseInt((float)OpenBCI_GUI.map((float)this.currentXvalue, (float)(-this.yMaxMin), (float)this.yMaxMin, (float)PApplet.parseFloat((int)(this.AccelWindowY + this.AccelWindowHeight)), (float)PApplet.parseFloat((int)this.AccelWindowY)));
                    this.X[this.X.length - 1] = OpenBCI_GUI.constrain((int)this.X[this.X.length - 1], (int)this.AccelWindowY, (int)(this.AccelWindowY + this.AccelWindowHeight));
                    this.Y[this.Y.length - 1] = PApplet.parseInt((float)OpenBCI_GUI.map((float)this.currentYvalue, (float)(-this.yMaxMin), (float)this.yMaxMin, (float)PApplet.parseFloat((int)(this.AccelWindowY + this.AccelWindowHeight)), (float)PApplet.parseFloat((int)this.AccelWindowY)));
                    this.Y[this.Y.length - 1] = OpenBCI_GUI.constrain((int)this.Y[this.Y.length - 1], (int)this.AccelWindowY, (int)(this.AccelWindowY + this.AccelWindowHeight));
                    this.Z[this.Z.length - 1] = PApplet.parseInt((float)OpenBCI_GUI.map((float)this.currentZvalue, (float)(-this.yMaxMin), (float)this.yMaxMin, (float)PApplet.parseFloat((int)(this.AccelWindowY + this.AccelWindowHeight)), (float)PApplet.parseFloat((int)this.AccelWindowY)));
                    this.Z[this.Z.length - 1] = OpenBCI_GUI.constrain((int)this.Z[this.Z.length - 1], (int)this.AccelWindowY, (int)(this.AccelWindowY + this.AccelWindowHeight));
                    this.shiftWave();
                } else if (OpenBCI_GUI.this.eegDataSource == 1) {
                    this.currentXvalue = (float)OpenBCI_GUI.this.hub.validAccelValues[0] * OpenBCI_GUI.this.ganglion.get_scale_fac_accel_G_per_count();
                    this.currentYvalue = (float)OpenBCI_GUI.this.hub.validAccelValues[1] * OpenBCI_GUI.this.ganglion.get_scale_fac_accel_G_per_count();
                    this.currentZvalue = (float)OpenBCI_GUI.this.hub.validAccelValues[2] * OpenBCI_GUI.this.ganglion.get_scale_fac_accel_G_per_count();
                    this.X[this.X.length - 1] = PApplet.parseInt((float)OpenBCI_GUI.map((float)this.currentXvalue, (float)(-this.yMaxMin), (float)this.yMaxMin, (float)PApplet.parseFloat((int)(this.AccelWindowY + this.AccelWindowHeight)), (float)PApplet.parseFloat((int)this.AccelWindowY)));
                    this.X[this.X.length - 1] = OpenBCI_GUI.constrain((int)this.X[this.X.length - 1], (int)this.AccelWindowY, (int)(this.AccelWindowY + this.AccelWindowHeight));
                    this.Y[this.Y.length - 1] = PApplet.parseInt((float)OpenBCI_GUI.map((float)this.currentYvalue, (float)(-this.yMaxMin), (float)this.yMaxMin, (float)PApplet.parseFloat((int)(this.AccelWindowY + this.AccelWindowHeight)), (float)PApplet.parseFloat((int)this.AccelWindowY)));
                    this.Y[this.Y.length - 1] = OpenBCI_GUI.constrain((int)this.Y[this.Y.length - 1], (int)this.AccelWindowY, (int)(this.AccelWindowY + this.AccelWindowHeight));
                    this.Z[this.Z.length - 1] = PApplet.parseInt((float)OpenBCI_GUI.map((float)this.currentZvalue, (float)(-this.yMaxMin), (float)this.yMaxMin, (float)PApplet.parseFloat((int)(this.AccelWindowY + this.AccelWindowHeight)), (float)PApplet.parseFloat((int)this.AccelWindowY)));
                    this.Z[this.Z.length - 1] = OpenBCI_GUI.constrain((int)this.Z[this.Z.length - 1], (int)this.AccelWindowY, (int)(this.AccelWindowY + this.AccelWindowHeight));
                    this.shiftWave();
                } else {
                    this.currentXvalue = OpenBCI_GUI.this.accelerometerBuff[0][OpenBCI_GUI.this.accelerometerBuff[0].length - 1];
                    this.currentYvalue = OpenBCI_GUI.this.accelerometerBuff[1][OpenBCI_GUI.this.accelerometerBuff[1].length - 1];
                    this.currentZvalue = OpenBCI_GUI.this.accelerometerBuff[2][OpenBCI_GUI.this.accelerometerBuff[2].length - 1];
                }
            }
        }

        @Override
        public void draw() {
            super.draw();
            OpenBCI_GUI.this.pushStyle();
            OpenBCI_GUI.this.fill(50);
            OpenBCI_GUI.this.textFont(OpenBCI_GUI.this.p4, 14.0f);
            OpenBCI_GUI.this.textAlign(3, 3);
            OpenBCI_GUI.this.text("z", this.PolarWindowX, this.PolarWindowY - (float)(this.PolarWindowHeight / 2) - 12.0f);
            OpenBCI_GUI.this.text(OpenBCI_GUI.TCP_CMD_EXAMINE, this.PolarWindowX + (float)(this.PolarWindowWidth / 2) + 8.0f, this.PolarWindowY - 5.0f);
            OpenBCI_GUI.this.text("y", this.PolarWindowX + this.PolarCorner + 10.0f, this.PolarWindowY - this.PolarCorner - 10.0f);
            OpenBCI_GUI.this.fill(this.graphBG);
            OpenBCI_GUI.this.stroke(this.graphStroke);
            OpenBCI_GUI.this.rect(this.AccelWindowX, this.AccelWindowY, this.AccelWindowWidth, this.AccelWindowHeight);
            OpenBCI_GUI.this.line(this.AccelWindowX, this.AccelWindowY + this.AccelWindowHeight / 2, this.AccelWindowX + this.AccelWindowWidth, this.AccelWindowY + this.AccelWindowHeight / 2);
            OpenBCI_GUI.this.fill(50);
            OpenBCI_GUI.this.textFont(OpenBCI_GUI.this.p5, 12.0f);
            OpenBCI_GUI.this.textAlign(3, 3);
            OpenBCI_GUI.this.text("+" + (int)this.yMaxMin + "g", this.AccelWindowX + this.AccelWindowWidth + 12, this.AccelWindowY);
            OpenBCI_GUI.this.text("0g", this.AccelWindowX + this.AccelWindowWidth + 12, this.AccelWindowY + this.AccelWindowHeight / 2);
            OpenBCI_GUI.this.text("-" + (int)this.yMaxMin + "g", this.AccelWindowX + this.AccelWindowWidth + 12, this.AccelWindowY + this.AccelWindowHeight);
            OpenBCI_GUI.this.fill(this.graphBG);
            OpenBCI_GUI.this.stroke(this.graphStroke);
            OpenBCI_GUI.this.ellipse(this.PolarWindowX, this.PolarWindowY, this.PolarWindowWidth, this.PolarWindowHeight);
            OpenBCI_GUI.this.stroke(180);
            OpenBCI_GUI.this.line(this.PolarWindowX - (float)(this.PolarWindowWidth / 2), this.PolarWindowY, this.PolarWindowX + (float)(this.PolarWindowWidth / 2), this.PolarWindowY);
            OpenBCI_GUI.this.line(this.PolarWindowX, this.PolarWindowY - (float)(this.PolarWindowHeight / 2), this.PolarWindowX, this.PolarWindowY + (float)(this.PolarWindowHeight / 2));
            OpenBCI_GUI.this.line(this.PolarWindowX - this.PolarCorner, this.PolarWindowY + this.PolarCorner, this.PolarWindowX + this.PolarCorner, this.PolarWindowY - this.PolarCorner);
            OpenBCI_GUI.this.fill(50);
            OpenBCI_GUI.this.textFont(OpenBCI_GUI.this.p3, 16.0f);
            if (OpenBCI_GUI.this.eegDataSource == 0) {
                this.drawAccValues();
                this.draw3DGraph();
                this.drawAccWave();
                if (OpenBCI_GUI.this.cyton.getBoardMode() != 0) {
                    this.accelModeButton.setString("Turn Accel On");
                    this.accelModeButton.draw();
                }
            } else if (OpenBCI_GUI.this.eegDataSource == 1) {
                if (OpenBCI_GUI.this.ganglion.isBLE()) {
                    this.accelModeButton.draw();
                }
                this.drawAccValues();
                this.draw3DGraph();
                this.drawAccWave();
            } else if (OpenBCI_GUI.this.eegDataSource == 3) {
                this.drawAccValues();
                this.draw3DGraph();
                this.drawAccWave();
            } else {
                this.drawAccValues();
                this.draw3DGraph();
                this.drawAccWave2();
            }
            OpenBCI_GUI.this.popStyle();
        }

        public void setGraphDimensions() {
            OpenBCI_GUI.println((String)("accel w " + this.w));
            OpenBCI_GUI.println((String)("accel h " + this.h));
            OpenBCI_GUI.println((String)("accel x " + this.x));
            OpenBCI_GUI.println((String)("accel y " + this.y));
            this.AccelWindowWidth = this.w - this.padding * 2;
            this.AccelWindowHeight = PApplet.parseInt((float)((PApplet.parseFloat((int)this.h) - PApplet.parseFloat((int)(this.padding * 3))) / 2.0f));
            this.AccelWindowX = this.x + this.padding;
            this.AccelWindowY = this.y + this.h - this.AccelWindowHeight - this.padding;
            this.PolarWindowWidth = this.AccelWindowHeight;
            this.PolarWindowHeight = this.AccelWindowHeight;
            this.PolarWindowX = this.x + this.w - this.padding - this.PolarWindowWidth / 2;
            this.PolarWindowY = this.y + this.padding + this.PolarWindowHeight / 2;
            this.PolarCorner = OpenBCI_GUI.sqrt((float)2.0f) * (float)this.PolarWindowWidth / 2.0f / 2.0f;
        }

        @Override
        public void screenResized() {
            int prevY = this.y;
            super.screenResized();
            this.setGraphDimensions();
            int i = 0;
            while (i < this.X.length) {
                this.X[i] = this.AccelWindowY + this.AccelWindowHeight / 4;
                this.Y[i] = this.AccelWindowY + this.AccelWindowHeight / 2;
                this.Z[i] = this.AccelWindowY + this.AccelWindowHeight / 4 * 3;
                ++i;
            }
            this.accelModeButton.setPos(this.x + 3, this.y + 3 - OpenBCI_GUI.this.navHeight);
        }

        @Override
        public void mousePressed() {
            super.mousePressed();
            if (OpenBCI_GUI.this.eegDataSource == 1) {
                if (OpenBCI_GUI.this.ganglion.isBLE() && this.accelModeButton.isMouseHere()) {
                    this.accelModeButton.setIsActive(true);
                }
            } else if (OpenBCI_GUI.this.eegDataSource == 0 && this.accelModeButton.isMouseHere()) {
                this.accelModeButton.setIsActive(true);
            }
        }

        @Override
        public void mouseReleased() {
            super.mouseReleased();
            if (OpenBCI_GUI.this.eegDataSource == 1) {
                if (this.accelModeButton.isActive && this.accelModeButton.isMouseHere()) {
                    if (OpenBCI_GUI.this.ganglion.isAccelModeActive()) {
                        OpenBCI_GUI.this.ganglion.accelStop();
                        this.accelModeButton.setString("Turn Accel On");
                    } else {
                        OpenBCI_GUI.this.ganglion.accelStart();
                        this.accelModeButton.setString("Turn Accel Off");
                    }
                }
                this.accelModeButton.setIsActive(false);
            } else if (OpenBCI_GUI.this.eegDataSource == 0) {
                if (this.accelModeButton.isActive && this.accelModeButton.isMouseHere()) {
                    OpenBCI_GUI.this.cyton.setBoardMode(0);
                    OpenBCI_GUI.this.output("Starting to read accelerometer");
                }
                this.accelModeButton.setIsActive(false);
            }
        }

        public void drawAccValues() {
            OpenBCI_GUI.this.textAlign(37, 3);
            OpenBCI_GUI.this.textFont(OpenBCI_GUI.this.h1, 20.0f);
            OpenBCI_GUI.this.fill(this.Xcolor);
            OpenBCI_GUI.this.text("X = " + OpenBCI_GUI.nf((float)this.currentXvalue, (int)1, (int)3) + " g", this.x + this.padding, (float)this.y + (float)(this.h / 12) * 1.5f);
            OpenBCI_GUI.this.fill(this.Ycolor);
            OpenBCI_GUI.this.text("Y = " + OpenBCI_GUI.nf((float)this.currentYvalue, (int)1, (int)3) + " g", this.x + this.padding, this.y + this.h / 12 * 3);
            OpenBCI_GUI.this.fill(this.Zcolor);
            OpenBCI_GUI.this.text("Z = " + OpenBCI_GUI.nf((float)this.currentZvalue, (int)1, (int)3) + " g", this.x + this.padding, (float)this.y + (float)(this.h / 12) * 4.5f);
        }

        public void shiftWave() {
            int i = 0;
            while (i < this.X.length - 1) {
                this.X[i] = this.X[i + 1];
                this.Y[i] = this.Y[i + 1];
                this.Z[i] = this.Z[i + 1];
                ++i;
            }
        }

        public void draw3DGraph() {
            OpenBCI_GUI.this.noFill();
            OpenBCI_GUI.this.strokeWeight(3.0f);
            OpenBCI_GUI.this.stroke(this.Xcolor);
            OpenBCI_GUI.this.line(this.PolarWindowX, this.PolarWindowY, this.PolarWindowX + OpenBCI_GUI.map((float)this.currentXvalue, (float)(-this.yMaxMin), (float)this.yMaxMin, (float)(-this.PolarWindowWidth / 2), (float)(this.PolarWindowWidth / 2)), this.PolarWindowY);
            OpenBCI_GUI.this.stroke(this.Ycolor);
            OpenBCI_GUI.this.line(this.PolarWindowX, this.PolarWindowY, this.PolarWindowX + OpenBCI_GUI.map((float)(OpenBCI_GUI.sqrt((float)2.0f) * this.currentYvalue / 2.0f), (float)(-this.yMaxMin), (float)this.yMaxMin, (float)(-this.PolarWindowWidth / 2), (float)(this.PolarWindowWidth / 2)), this.PolarWindowY + OpenBCI_GUI.map((float)(OpenBCI_GUI.sqrt((float)2.0f) * this.currentYvalue / 2.0f), (float)(-this.yMaxMin), (float)this.yMaxMin, (float)(this.PolarWindowWidth / 2), (float)(-this.PolarWindowWidth / 2)));
            OpenBCI_GUI.this.stroke(this.Zcolor);
            OpenBCI_GUI.this.line(this.PolarWindowX, this.PolarWindowY, this.PolarWindowX, this.PolarWindowY + OpenBCI_GUI.map((float)this.currentZvalue, (float)(-this.yMaxMin), (float)this.yMaxMin, (float)(this.PolarWindowWidth / 2), (float)(-this.PolarWindowWidth / 2)));
        }

        public void drawAccWave() {
            int xi;
            OpenBCI_GUI.this.noFill();
            OpenBCI_GUI.this.strokeWeight(1.0f);
            OpenBCI_GUI.this.beginShape();
            OpenBCI_GUI.this.stroke(this.Xcolor);
            int i = 0;
            while (i < this.X.length) {
                xi = PApplet.parseInt((float)OpenBCI_GUI.map((float)i, (float)0.0f, (float)(this.X.length - 1), (float)0.0f, (float)(this.AccelWindowWidth - 1)));
                OpenBCI_GUI.this.vertex(this.AccelWindowX + xi, this.X[i]);
                ++i;
            }
            OpenBCI_GUI.this.endShape();
            OpenBCI_GUI.this.beginShape();
            OpenBCI_GUI.this.stroke(this.Ycolor);
            i = 0;
            while (i < this.Y.length) {
                xi = PApplet.parseInt((float)OpenBCI_GUI.map((float)i, (float)0.0f, (float)(this.X.length - 1), (float)0.0f, (float)(this.AccelWindowWidth - 1)));
                OpenBCI_GUI.this.vertex(this.AccelWindowX + xi, this.Y[i]);
                ++i;
            }
            OpenBCI_GUI.this.endShape();
            OpenBCI_GUI.this.beginShape();
            OpenBCI_GUI.this.stroke(this.Zcolor);
            i = 0;
            while (i < this.Z.length) {
                xi = PApplet.parseInt((float)OpenBCI_GUI.map((float)i, (float)0.0f, (float)(this.X.length - 1), (float)0.0f, (float)(this.AccelWindowWidth - 1)));
                OpenBCI_GUI.this.vertex(this.AccelWindowX + xi, this.Z[i]);
                ++i;
            }
            OpenBCI_GUI.this.endShape();
        }

        public void drawAccWave2() {
            OpenBCI_GUI.this.noFill();
            OpenBCI_GUI.this.strokeWeight(1.0f);
            OpenBCI_GUI.this.beginShape();
            OpenBCI_GUI.this.stroke(this.Xcolor);
            int i = 0;
            while (i < OpenBCI_GUI.this.accelerometerBuff[0].length) {
                int x = PApplet.parseInt((float)OpenBCI_GUI.map((float)OpenBCI_GUI.this.accelerometerBuff[0][i], (float)(-this.yMaxMin), (float)this.yMaxMin, (float)PApplet.parseFloat((int)(this.AccelWindowY + this.AccelWindowHeight)), (float)PApplet.parseFloat((int)this.AccelWindowY)));
                x = OpenBCI_GUI.constrain((int)x, (int)this.AccelWindowY, (int)(this.AccelWindowY + this.AccelWindowHeight));
                OpenBCI_GUI.this.vertex(this.AccelWindowX + i, x);
                ++i;
            }
            OpenBCI_GUI.this.endShape();
            OpenBCI_GUI.this.beginShape();
            OpenBCI_GUI.this.stroke(this.Ycolor);
            i = 0;
            while (i < OpenBCI_GUI.this.accelerometerBuff[0].length) {
                int y = PApplet.parseInt((float)OpenBCI_GUI.map((float)OpenBCI_GUI.this.accelerometerBuff[1][i], (float)(-this.yMaxMin), (float)this.yMaxMin, (float)PApplet.parseFloat((int)(this.AccelWindowY + this.AccelWindowHeight)), (float)PApplet.parseFloat((int)this.AccelWindowY)));
                y = OpenBCI_GUI.constrain((int)y, (int)this.AccelWindowY, (int)(this.AccelWindowY + this.AccelWindowHeight));
                OpenBCI_GUI.this.vertex(this.AccelWindowX + i, y);
                ++i;
            }
            OpenBCI_GUI.this.endShape();
            OpenBCI_GUI.this.beginShape();
            OpenBCI_GUI.this.stroke(this.Zcolor);
            i = 0;
            while (i < OpenBCI_GUI.this.accelerometerBuff[0].length) {
                int z = PApplet.parseInt((float)OpenBCI_GUI.map((float)OpenBCI_GUI.this.accelerometerBuff[2][i], (float)(-this.yMaxMin), (float)this.yMaxMin, (float)PApplet.parseFloat((int)(this.AccelWindowY + this.AccelWindowHeight)), (float)PApplet.parseFloat((int)this.AccelWindowY)));
                z = OpenBCI_GUI.constrain((int)z, (int)this.AccelWindowY, (int)(this.AccelWindowY + this.AccelWindowHeight));
                OpenBCI_GUI.this.vertex(this.AccelWindowX + i, z);
                ++i;
            }
            OpenBCI_GUI.this.endShape();
        }

        public void synthesizeAccelerometerData() {
            if (this.Xrising) {
                int n = this.X.length - 1;
                this.X[n] = this.X[n] - 1;
                if (this.X[this.X.length - 1] <= this.AccelWindowY) {
                    this.Xrising = false;
                }
            } else {
                int n = this.X.length - 1;
                this.X[n] = this.X[n] + 1;
                if (this.X[this.X.length - 1] >= this.AccelWindowY + this.AccelWindowHeight) {
                    this.Xrising = true;
                }
            }
            if (this.Yrising) {
                int n = this.Y.length - 1;
                this.Y[n] = this.Y[n] - 1;
                if (this.Y[this.Y.length - 1] <= this.AccelWindowY) {
                    this.Yrising = false;
                }
            } else {
                int n = this.Y.length - 1;
                this.Y[n] = this.Y[n] + 1;
                if (this.Y[this.Y.length - 1] >= this.AccelWindowY + this.AccelWindowHeight) {
                    this.Yrising = true;
                }
            }
            if (this.Zrising) {
                int n = this.Z.length - 1;
                this.Z[n] = this.Z[n] - 1;
                if (this.Z[this.Z.length - 1] <= this.AccelWindowY) {
                    this.Zrising = false;
                }
            } else {
                int n = this.Z.length - 1;
                this.Z[n] = this.Z[n] + 1;
                if (this.Z[this.Z.length - 1] >= this.AccelWindowY + this.AccelWindowHeight) {
                    this.Zrising = true;
                }
            }
        }
    }

    class W_emg
    extends Widget {
        Motor_Widget[] motorWidgets;
        TripSlider[] tripSliders;
        TripSlider[] untripSliders;
        List<String> baudList;
        List<String> serList;
        List<String> channelList;
        boolean[] events;
        int currChannel;
        int theBaud;
        Button connectButton;
        Serial serialOutEMG;
        String theSerial;
        Boolean emgAdvanced;
        PApplet parent;

        W_emg(PApplet _parent) {
            super(_parent);
            this.emgAdvanced = false;
            this.parent = _parent;
            this.motorWidgets = new Motor_Widget[OpenBCI_GUI.this.nchan];
            int i = 0;
            while (i < OpenBCI_GUI.this.nchan) {
                this.motorWidgets[i] = new Motor_Widget();
                this.motorWidgets[i].ourChan = i;
                this.motorWidgets[i].averagePeriod = OpenBCI_GUI.this.eegDataSource == 1 ? 100.0f : 125.0f;
                ++i;
            }
            this.events = new boolean[OpenBCI_GUI.this.nchan];
            i = 0;
            while (i < OpenBCI_GUI.this.nchan) {
                this.events[i] = true;
                ++i;
            }
            this.addDropdown("SmoothEMG", "Smooth", Arrays.asList("0.01 s", "0.1 s", "0.15 s", "0.25 s", "0.5 s", "0.75 s", "1.0 s", "2.0 s"), 4);
            this.addDropdown("uVLimit", "uV Limit", Arrays.asList("50 uV", "100 uV", "200 uV", "400 uV"), 2);
            this.addDropdown("CreepSpeed", "Creep", Arrays.asList("0.9", "0.95", "0.98", "0.99", "0.999"), 3);
            this.addDropdown("minUVRange", "Min \u0394uV", Arrays.asList("10 uV", "20 uV", "40 uV", "80 uV"), 1);
            if (this.emgAdvanced.booleanValue()) {
                this.channelList = new ArrayList<String>();
                this.baudList = new ArrayList<String>();
                this.serList = new ArrayList<String>();
                i = 0;
                while (i < OpenBCI_GUI.this.nchan) {
                    this.channelList.add(Integer.toString(i + 1));
                    ++i;
                }
                this.currChannel = 0;
                this.theBaud = 230400;
                this.baudList.add("NONE");
                this.baudList.add(Integer.toString(230400));
                this.baudList.add(Integer.toString(115200));
                this.baudList.add(Integer.toString(57600));
                this.baudList.add(Integer.toString(38400));
                this.baudList.add(Integer.toString(28800));
                this.baudList.add(Integer.toString(19200));
                this.baudList.add(Integer.toString(14400));
                this.baudList.add(Integer.toString(9600));
                this.baudList.add(Integer.toString(7200));
                this.baudList.add(Integer.toString(4800));
                this.baudList.add(Integer.toString(3600));
                String[] serialPorts = Serial.list();
                this.serList.add("NONE");
                int i2 = 0;
                while (i2 < serialPorts.length) {
                    String tempPort = serialPorts[serialPorts.length - 1 - i2];
                    if (!tempPort.equals(OpenBCI_GUI.this.openBCI_portName)) {
                        this.serList.add(tempPort);
                    }
                    ++i2;
                }
                this.addDropdown("SerialSelection", "Output", this.serList, 0);
                this.addDropdown("ChannelSelection", "Channel", this.channelList, 0);
                this.addDropdown("EventType", "Event Type", Arrays.asList("Digital", "Analog"), 0);
                this.addDropdown("BaudRate", "Baud Rate", this.baudList, 0);
                this.tripSliders = new TripSlider[OpenBCI_GUI.this.nchan];
                this.untripSliders = new TripSlider[OpenBCI_GUI.this.nchan];
                this.initSliders(this.w, this.h);
            }
        }

        public void initSliders(int rw, int rh) {
            int rowNum = 4;
            int colNum = this.motorWidgets.length / rowNum;
            int index = 0;
            float rowOffset = rh / rowNum;
            float colOffset = rw / colNum;
            int i = 0;
            while (i < rowNum) {
                int j = 0;
                while (j < colNum) {
                    OpenBCI_GUI.println((String)("ROW: " + 4.0f * rowOffset / 8.0f));
                    this.tripSliders[index] = new TripSlider(PApplet.parseInt((float)(5.0f * colOffset / 8.0f * 0.498f)), PApplet.parseInt((float)(2.0f * rowOffset / 8.0f * 0.384f)), 4.0f * rowOffset / 8.0f * 0.408f, PApplet.parseInt((float)(3.0f * colOffset / 32.0f * 0.489f)), 2, this.tripSliders, true, this.motorWidgets[index]);
                    this.untripSliders[index] = new TripSlider(PApplet.parseInt((float)(5.0f * colOffset / 8.0f * 0.498f)), PApplet.parseInt((float)(2.0f * rowOffset / 8.0f * 0.384f)), 4.0f * rowOffset / 8.0f * 0.408f, PApplet.parseInt((float)(3.0f * colOffset / 32.0f * 0.489f)), 2, this.tripSliders, false, this.motorWidgets[index]);
                    this.tripSliders[index].setStretchPercentage(this.motorWidgets[index].tripThreshold);
                    this.untripSliders[index].setStretchPercentage(this.motorWidgets[index].untripThreshold);
                    ++index;
                    ++j;
                }
                ++i;
            }
        }

        @Override
        public void update() {
            super.update();
            this.process(OpenBCI_GUI.this.yLittleBuff_uV, OpenBCI_GUI.this.dataBuffY_uV, OpenBCI_GUI.this.dataBuffY_filtY_uV, OpenBCI_GUI.this.fftBuff);
        }

        @Override
        public void draw() {
            super.draw();
            OpenBCI_GUI.this.pushStyle();
            OpenBCI_GUI.this.noStroke();
            OpenBCI_GUI.this.fill(255);
            OpenBCI_GUI.this.rect(this.x, this.y, this.w, this.h);
            if (this.emgAdvanced.booleanValue()) {
                if (this.connectButton != null) {
                    this.connectButton.draw();
                } else {
                    this.connectButton = new Button(PApplet.parseInt((float)this.x) + 2, PApplet.parseInt((float)this.y) - OpenBCI_GUI.this.navHeight + 2, 100, OpenBCI_GUI.this.navHeight - 6, "Connect", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
                }
                OpenBCI_GUI.this.stroke(1.0f, 18.0f, 41.0f, 125.0f);
                if (this.connectButton != null && this.connectButton.wasPressed) {
                    OpenBCI_GUI.this.fill(0.0f, 255.0f, 0.0f);
                    OpenBCI_GUI.this.ellipse(this.x + 120, this.y - OpenBCI_GUI.this.navHeight / 2, 16.0f, 16.0f);
                } else if (this.connectButton != null && !this.connectButton.wasPressed) {
                    OpenBCI_GUI.this.fill(255.0f, 0.0f, 0.0f);
                    OpenBCI_GUI.this.ellipse(this.x + 120, this.y - OpenBCI_GUI.this.navHeight / 2, 16.0f, 16.0f);
                }
            }
            float rx = this.x;
            float ry = this.y;
            float rw = this.w;
            float rh = this.h;
            float scaleFactor = 1.0f;
            int rowNum = 4;
            int colNum = this.motorWidgets.length / rowNum;
            float rowOffset = rh / (float)rowNum;
            float colOffset = rw / (float)colNum;
            int index = 0;
            int i = 0;
            while (i < rowNum) {
                int j = 0;
                while (j < colNum) {
                    OpenBCI_GUI.this.pushMatrix();
                    float currx = rx + (float)j * colOffset;
                    float curry = ry + (float)i * rowOffset;
                    OpenBCI_GUI.this.translate(currx, curry);
                    OpenBCI_GUI.this.fill(OpenBCI_GUI.this.red(OpenBCI_GUI.this.channelColors[index % 8]), OpenBCI_GUI.this.green(OpenBCI_GUI.this.channelColors[index % 8]), OpenBCI_GUI.this.blue(OpenBCI_GUI.this.channelColors[index % 8]), 200.0f);
                    OpenBCI_GUI.this.noStroke();
                    OpenBCI_GUI.this.ellipse(2.0f * colOffset / 8.0f, rowOffset / 2.0f, scaleFactor * this.motorWidgets[i * colNum + j].myAverage, scaleFactor * this.motorWidgets[i * colNum + j].myAverage);
                    OpenBCI_GUI.this.noFill();
                    OpenBCI_GUI.this.strokeWeight(1.0f);
                    OpenBCI_GUI.this.stroke(OpenBCI_GUI.this.red(OpenBCI_GUI.this.bgColor), OpenBCI_GUI.this.green(OpenBCI_GUI.this.bgColor), OpenBCI_GUI.this.blue(OpenBCI_GUI.this.bgColor), 150.0f);
                    OpenBCI_GUI.this.ellipse(2.0f * colOffset / 8.0f, rowOffset / 2.0f, scaleFactor * this.motorWidgets[i * colNum + j].upperThreshold, scaleFactor * this.motorWidgets[i * colNum + j].upperThreshold);
                    OpenBCI_GUI.this.stroke(OpenBCI_GUI.this.red(OpenBCI_GUI.this.bgColor), OpenBCI_GUI.this.green(OpenBCI_GUI.this.bgColor), OpenBCI_GUI.this.blue(OpenBCI_GUI.this.bgColor), 150.0f);
                    OpenBCI_GUI.this.ellipse(2.0f * colOffset / 8.0f, rowOffset / 2.0f, scaleFactor * this.motorWidgets[i * colNum + j].lowerThreshold, scaleFactor * this.motorWidgets[i * colNum + j].lowerThreshold);
                    int _x = PApplet.parseInt((float)(5.0f * colOffset / 8.0f));
                    int _y = PApplet.parseInt((float)(2.0f * rowOffset / 8.0f));
                    int _w = PApplet.parseInt((float)(5.0f * colOffset / 32.0f));
                    int _h = PApplet.parseInt((float)(4.0f * rowOffset / 8.0f));
                    OpenBCI_GUI.this.noStroke();
                    OpenBCI_GUI.this.fill(OpenBCI_GUI.this.red(OpenBCI_GUI.this.channelColors[index % 8]), OpenBCI_GUI.this.green(OpenBCI_GUI.this.channelColors[index % 8]), OpenBCI_GUI.this.blue(OpenBCI_GUI.this.channelColors[index % 8]), 200.0f);
                    OpenBCI_GUI.this.rect(_x, 3 * _y + 1, _w, OpenBCI_GUI.map((float)this.motorWidgets[i * colNum + j].output_normalized, (float)0.0f, (float)1.0f, (float)0.0f, (float)(-1 * PApplet.parseInt((float)(4.0f * rowOffset / 8.0f)))));
                    OpenBCI_GUI.this.strokeWeight(1.0f);
                    OpenBCI_GUI.this.stroke(OpenBCI_GUI.this.red(OpenBCI_GUI.this.bgColor), OpenBCI_GUI.this.green(OpenBCI_GUI.this.bgColor), OpenBCI_GUI.this.blue(OpenBCI_GUI.this.bgColor), 150.0f);
                    OpenBCI_GUI.this.noFill();
                    OpenBCI_GUI.this.rect(_x, _y, _w, _h);
                    if (this.emgAdvanced.booleanValue()) {
                        this.tripSliders[index].update(currx, curry);
                        this.tripSliders[index].display(_x, _y, _w, _h);
                        this.untripSliders[index].update(currx, curry);
                        this.untripSliders[index].display(_x, _y, _w, _h);
                    }
                    OpenBCI_GUI.this.pushStyle();
                    OpenBCI_GUI.this.stroke(0);
                    OpenBCI_GUI.this.fill(OpenBCI_GUI.this.bgColor);
                    int _chan = index + 1;
                    OpenBCI_GUI.this.textFont(OpenBCI_GUI.this.p5, 12.0f);
                    OpenBCI_GUI.this.text(String.valueOf(_chan), 10.0f, 20.0f);
                    OpenBCI_GUI.this.popStyle();
                    ++index;
                    OpenBCI_GUI.this.popMatrix();
                    ++j;
                }
                ++i;
            }
            OpenBCI_GUI.this.popStyle();
        }

        @Override
        public void screenResized() {
            super.screenResized();
            if (this.emgAdvanced.booleanValue()) {
                this.connectButton.setPos(PApplet.parseInt((float)this.x) + 2, PApplet.parseInt((float)this.y) - OpenBCI_GUI.this.navHeight + 2);
                int i = 0;
                while (i < this.tripSliders.length) {
                    ++i;
                }
            }
        }

        @Override
        public void mousePressed() {
            super.mousePressed();
            if (this.emgAdvanced.booleanValue()) {
                if (this.connectButton.isMouseHere()) {
                    this.connectButton.setIsActive(true);
                    OpenBCI_GUI.println((String)"Connect pressed");
                } else {
                    this.connectButton.setIsActive(false);
                }
            }
        }

        @Override
        public void mouseReleased() {
            super.mouseReleased();
            if (this.emgAdvanced.booleanValue()) {
                if (this.connectButton != null && this.connectButton.isMouseHere()) {
                    try {
                        this.serialOutEMG = new Serial(this.parent, this.theSerial, this.theBaud);
                        this.connectButton.wasPressed = true;
                        OpenBCI_GUI.this.verbosePrint("Connected");
                        OpenBCI_GUI.this.output("Connected to " + this.theSerial);
                    }
                    catch (Exception exception) {
                        this.connectButton.wasPressed = false;
                        OpenBCI_GUI.this.verbosePrint("Could not connect!");
                        OpenBCI_GUI.this.output("Could not connect. Confirm that your Serial/COM port is correct and active.");
                    }
                    this.connectButton.setIsActive(false);
                }
                int i = 0;
                while (i < OpenBCI_GUI.this.nchan) {
                    this.tripSliders[i].releaseEvent();
                    this.untripSliders[i].releaseEvent();
                    ++i;
                }
            }
        }

        public void process(float[][] data_newest_uV, float[][] data_long_uV, float[][] data_forDisplay_uV, FFT[] fftData) {
            Motor_Widget[] motor_WidgetArray = this.motorWidgets;
            int n = this.motorWidgets.length;
            int n2 = 0;
            while (n2 < n) {
                Motor_Widget cfc = motor_WidgetArray[n2];
                cfc.myAverage = 0.0f;
                int i = data_forDisplay_uV[cfc.ourChan].length - PApplet.parseInt((float)cfc.averagePeriod);
                while (i < data_forDisplay_uV[cfc.ourChan].length) {
                    cfc.myAverage = OpenBCI_GUI.abs((float)data_forDisplay_uV[cfc.ourChan][i]) <= cfc.acceptableLimitUV ? (cfc.myAverage += OpenBCI_GUI.abs((float)data_forDisplay_uV[cfc.ourChan][i])) : (cfc.myAverage += cfc.acceptableLimitUV);
                    ++i;
                }
                cfc.myAverage /= cfc.averagePeriod;
                if (cfc.myAverage >= cfc.upperThreshold && cfc.myAverage <= cfc.acceptableLimitUV) {
                    cfc.upperThreshold = cfc.myAverage;
                }
                if (cfc.myAverage <= cfc.lowerThreshold) {
                    cfc.lowerThreshold = cfc.myAverage;
                }
                if (cfc.upperThreshold >= cfc.myAverage + cfc.minRange) {
                    cfc.upperThreshold *= cfc.creepSpeed;
                }
                if (cfc.lowerThreshold <= 1.0f) {
                    cfc.lowerThreshold = 1.0f;
                }
                if (cfc.lowerThreshold <= cfc.myAverage) {
                    cfc.lowerThreshold *= 1.0f / cfc.creepSpeed;
                }
                if (cfc.upperThreshold <= cfc.lowerThreshold + cfc.minRange) {
                    cfc.upperThreshold = cfc.lowerThreshold + cfc.minRange;
                }
                cfc.output_normalized = OpenBCI_GUI.map((float)cfc.myAverage, (float)cfc.lowerThreshold, (float)cfc.upperThreshold, (float)0.0f, (float)1.0f);
                if (cfc.output_normalized < 0.0f) {
                    cfc.output_normalized = 0.0f;
                }
                cfc.output_adjusted = -0.1f / (cfc.output_normalized * 255.0f) + 255.0f;
                switch (cfc.ourChan) {
                    case 0: {
                        if (this.events[0]) {
                            this.digitalEventChan0(cfc);
                            break;
                        }
                        this.analogEventChan0(cfc);
                        break;
                    }
                    case 1: {
                        if (this.events[1]) {
                            this.digitalEventChan1(cfc);
                            break;
                        }
                        this.analogEventChan1(cfc);
                        break;
                    }
                    case 2: {
                        if (this.events[2]) {
                            this.digitalEventChan2(cfc);
                            break;
                        }
                        this.analogEventChan2(cfc);
                        break;
                    }
                    case 3: {
                        if (this.events[3]) {
                            this.digitalEventChan3(cfc);
                            break;
                        }
                        this.analogEventChan3(cfc);
                        break;
                    }
                    case 4: {
                        if (this.events[4]) {
                            this.digitalEventChan4(cfc);
                            break;
                        }
                        this.analogEventChan4(cfc);
                        break;
                    }
                    case 5: {
                        if (this.events[5]) {
                            this.digitalEventChan5(cfc);
                            break;
                        }
                        this.analogEventChan5(cfc);
                        break;
                    }
                    case 6: {
                        if (this.events[6]) {
                            this.digitalEventChan6(cfc);
                            break;
                        }
                        this.analogEventChan6(cfc);
                        break;
                    }
                    case 7: {
                        if (this.events[7]) {
                            this.digitalEventChan7(cfc);
                            break;
                        }
                        this.analogEventChan7(cfc);
                        break;
                    }
                    case 8: {
                        if (this.events[8]) {
                            this.digitalEventChan8(cfc);
                            break;
                        }
                        this.analogEventChan8(cfc);
                        break;
                    }
                    case 9: {
                        if (this.events[9]) {
                            this.digitalEventChan9(cfc);
                            break;
                        }
                        this.analogEventChan9(cfc);
                        break;
                    }
                    case 10: {
                        if (this.events[10]) {
                            this.digitalEventChan10(cfc);
                            break;
                        }
                        this.analogEventChan10(cfc);
                        break;
                    }
                    case 11: {
                        if (this.events[11]) {
                            this.digitalEventChan11(cfc);
                            break;
                        }
                        this.analogEventChan11(cfc);
                        break;
                    }
                    case 12: {
                        if (this.events[12]) {
                            this.digitalEventChan12(cfc);
                            break;
                        }
                        this.analogEventChan12(cfc);
                        break;
                    }
                    case 13: {
                        if (this.events[13]) {
                            this.digitalEventChan13(cfc);
                            break;
                        }
                        this.analogEventChan13(cfc);
                        break;
                    }
                    case 14: {
                        if (this.events[14]) {
                            this.digitalEventChan14(cfc);
                            break;
                        }
                        this.analogEventChan14(cfc);
                        break;
                    }
                    case 15: {
                        if (this.events[15]) {
                            this.digitalEventChan15(cfc);
                            break;
                        }
                        this.analogEventChan15(cfc);
                        break;
                    }
                }
                ++n2;
            }
            if ((float)OpenBCI_GUI.this.millis() - this.motorWidgets[0].timeOfLastTrip >= 2000.0f && this.serialOutEMG != null) {
                switch (this.motorWidgets[0].switchCounter) {
                    case 1: {
                        this.serialOutEMG.write("G0");
                    }
                }
                this.motorWidgets[0].switchCounter = 0;
            }
            int Ichan = 0;
            while (Ichan < OpenBCI_GUI.this.nchan) {
                int Ibin = 0;
                while (Ibin < OpenBCI_GUI.this.fftBuff[Ichan].specSize()) {
                    fftData[Ichan].indexToFreq(Ibin);
                    fftData[Ichan].getBand(Ibin);
                    ++Ibin;
                }
                ++Ichan;
            }
        }

        public void digitalEventChan0(Motor_Widget cfc) {
            float output_normalized = cfc.output_normalized;
            float tripThreshold = cfc.tripThreshold;
            float untripThreshold = cfc.untripThreshold;
            boolean switchTripped = cfc.switchTripped;
            float timeOfLastTrip = cfc.timeOfLastTrip;
            int timeToWaitThresh = 750;
            if (output_normalized >= tripThreshold && !switchTripped && (float)OpenBCI_GUI.this.millis() - timeOfLastTrip >= (float)timeToWaitThresh) {
                cfc.switchTripped = true;
                cfc.timeOfLastTrip = OpenBCI_GUI.this.millis();
                ++cfc.switchCounter;
            }
            if (switchTripped && output_normalized <= untripThreshold) {
                cfc.switchTripped = false;
            }
        }

        public void digitalEventChan1(Motor_Widget cfc) {
            float output_normalized = cfc.output_normalized;
            float tripThreshold = cfc.tripThreshold;
            float untripThreshold = cfc.untripThreshold;
            boolean switchTripped = cfc.switchTripped;
            float timeOfLastTrip = cfc.timeOfLastTrip;
            int timeToWaitThresh = 750;
            if (output_normalized >= tripThreshold && !switchTripped && (float)OpenBCI_GUI.this.millis() - timeOfLastTrip >= (float)timeToWaitThresh) {
                cfc.switchTripped = true;
                cfc.timeOfLastTrip = OpenBCI_GUI.this.millis();
                ++cfc.switchCounter;
            }
            if (switchTripped && output_normalized <= untripThreshold) {
                cfc.switchTripped = false;
            }
        }

        public void digitalEventChan2(Motor_Widget cfc) {
            float output_normalized = cfc.output_normalized;
            float tripThreshold = cfc.tripThreshold;
            float untripThreshold = cfc.untripThreshold;
            boolean switchTripped = cfc.switchTripped;
            float timeOfLastTrip = cfc.timeOfLastTrip;
            int timeToWaitThresh = 750;
            if (output_normalized >= tripThreshold && !switchTripped && (float)OpenBCI_GUI.this.millis() - timeOfLastTrip >= (float)timeToWaitThresh) {
                cfc.switchTripped = true;
                cfc.timeOfLastTrip = OpenBCI_GUI.this.millis();
                ++cfc.switchCounter;
            }
            if (switchTripped && output_normalized <= untripThreshold) {
                cfc.switchTripped = false;
            }
        }

        public void digitalEventChan3(Motor_Widget cfc) {
            float output_normalized = cfc.output_normalized;
            float tripThreshold = cfc.tripThreshold;
            float untripThreshold = cfc.untripThreshold;
            boolean switchTripped = cfc.switchTripped;
            float timeOfLastTrip = cfc.timeOfLastTrip;
            int timeToWaitThresh = 750;
            if (output_normalized >= tripThreshold && !switchTripped && (float)OpenBCI_GUI.this.millis() - timeOfLastTrip >= (float)timeToWaitThresh) {
                cfc.switchTripped = true;
                cfc.timeOfLastTrip = OpenBCI_GUI.this.millis();
                ++cfc.switchCounter;
            }
            if (switchTripped && output_normalized <= untripThreshold) {
                cfc.switchTripped = false;
            }
        }

        public void digitalEventChan4(Motor_Widget cfc) {
            float output_normalized = cfc.output_normalized;
            float tripThreshold = cfc.tripThreshold;
            float untripThreshold = cfc.untripThreshold;
            boolean switchTripped = cfc.switchTripped;
            float timeOfLastTrip = cfc.timeOfLastTrip;
            int timeToWaitThresh = 750;
            if (output_normalized >= tripThreshold && !switchTripped && (float)OpenBCI_GUI.this.millis() - timeOfLastTrip >= (float)timeToWaitThresh) {
                cfc.switchTripped = true;
                cfc.timeOfLastTrip = OpenBCI_GUI.this.millis();
                ++cfc.switchCounter;
            }
            if (switchTripped && output_normalized <= untripThreshold) {
                cfc.switchTripped = false;
            }
        }

        public void digitalEventChan5(Motor_Widget cfc) {
            float output_normalized = cfc.output_normalized;
            float tripThreshold = cfc.tripThreshold;
            float untripThreshold = cfc.untripThreshold;
            boolean switchTripped = cfc.switchTripped;
            float timeOfLastTrip = cfc.timeOfLastTrip;
            int timeToWaitThresh = 750;
            if (output_normalized >= tripThreshold && !switchTripped && (float)OpenBCI_GUI.this.millis() - timeOfLastTrip >= (float)timeToWaitThresh) {
                cfc.switchTripped = true;
                cfc.timeOfLastTrip = OpenBCI_GUI.this.millis();
                ++cfc.switchCounter;
            }
            if (switchTripped && output_normalized <= untripThreshold) {
                cfc.switchTripped = false;
            }
        }

        public void digitalEventChan6(Motor_Widget cfc) {
            float output_normalized = cfc.output_normalized;
            float tripThreshold = cfc.tripThreshold;
            float untripThreshold = cfc.untripThreshold;
            boolean switchTripped = cfc.switchTripped;
            float timeOfLastTrip = cfc.timeOfLastTrip;
            int timeToWaitThresh = 750;
            if (output_normalized >= tripThreshold && !switchTripped && (float)OpenBCI_GUI.this.millis() - timeOfLastTrip >= (float)timeToWaitThresh) {
                cfc.switchTripped = true;
                cfc.timeOfLastTrip = OpenBCI_GUI.this.millis();
                ++cfc.switchCounter;
            }
            if (switchTripped && output_normalized <= untripThreshold) {
                cfc.switchTripped = false;
            }
        }

        public void digitalEventChan7(Motor_Widget cfc) {
            float output_normalized = cfc.output_normalized;
            float tripThreshold = cfc.tripThreshold;
            float untripThreshold = cfc.untripThreshold;
            boolean switchTripped = cfc.switchTripped;
            float timeOfLastTrip = cfc.timeOfLastTrip;
            int timeToWaitThresh = 750;
            if (output_normalized >= tripThreshold && !switchTripped && (float)OpenBCI_GUI.this.millis() - timeOfLastTrip >= (float)timeToWaitThresh) {
                cfc.switchTripped = true;
                cfc.timeOfLastTrip = OpenBCI_GUI.this.millis();
                ++cfc.switchCounter;
            }
            if (switchTripped && output_normalized <= untripThreshold) {
                cfc.switchTripped = false;
            }
        }

        public void digitalEventChan8(Motor_Widget cfc) {
            float output_normalized = cfc.output_normalized;
            float tripThreshold = cfc.tripThreshold;
            float untripThreshold = cfc.untripThreshold;
            boolean switchTripped = cfc.switchTripped;
            float timeOfLastTrip = cfc.timeOfLastTrip;
            int timeToWaitThresh = 750;
            if (output_normalized >= tripThreshold && !switchTripped && (float)OpenBCI_GUI.this.millis() - timeOfLastTrip >= (float)timeToWaitThresh) {
                cfc.switchTripped = true;
                cfc.timeOfLastTrip = OpenBCI_GUI.this.millis();
                ++cfc.switchCounter;
            }
            if (switchTripped && output_normalized <= untripThreshold) {
                cfc.switchTripped = false;
            }
        }

        public void digitalEventChan9(Motor_Widget cfc) {
            float output_normalized = cfc.output_normalized;
            float tripThreshold = cfc.tripThreshold;
            float untripThreshold = cfc.untripThreshold;
            boolean switchTripped = cfc.switchTripped;
            float timeOfLastTrip = cfc.timeOfLastTrip;
            int timeToWaitThresh = 750;
            if (output_normalized >= tripThreshold && !switchTripped && (float)OpenBCI_GUI.this.millis() - timeOfLastTrip >= (float)timeToWaitThresh) {
                cfc.switchTripped = true;
                cfc.timeOfLastTrip = OpenBCI_GUI.this.millis();
                ++cfc.switchCounter;
            }
            if (switchTripped && output_normalized <= untripThreshold) {
                cfc.switchTripped = false;
            }
        }

        public void digitalEventChan10(Motor_Widget cfc) {
            float output_normalized = cfc.output_normalized;
            float tripThreshold = cfc.tripThreshold;
            float untripThreshold = cfc.untripThreshold;
            boolean switchTripped = cfc.switchTripped;
            float timeOfLastTrip = cfc.timeOfLastTrip;
            int timeToWaitThresh = 750;
            if (output_normalized >= tripThreshold && !switchTripped && (float)OpenBCI_GUI.this.millis() - timeOfLastTrip >= (float)timeToWaitThresh) {
                cfc.switchTripped = true;
                cfc.timeOfLastTrip = OpenBCI_GUI.this.millis();
                ++cfc.switchCounter;
            }
            if (switchTripped && output_normalized <= untripThreshold) {
                cfc.switchTripped = false;
            }
        }

        public void digitalEventChan11(Motor_Widget cfc) {
            float output_normalized = cfc.output_normalized;
            float tripThreshold = cfc.tripThreshold;
            float untripThreshold = cfc.untripThreshold;
            boolean switchTripped = cfc.switchTripped;
            float timeOfLastTrip = cfc.timeOfLastTrip;
            int timeToWaitThresh = 750;
            if (output_normalized >= tripThreshold && !switchTripped && (float)OpenBCI_GUI.this.millis() - timeOfLastTrip >= (float)timeToWaitThresh) {
                cfc.switchTripped = true;
                cfc.timeOfLastTrip = OpenBCI_GUI.this.millis();
                ++cfc.switchCounter;
            }
            if (switchTripped && output_normalized <= untripThreshold) {
                cfc.switchTripped = false;
            }
        }

        public void digitalEventChan12(Motor_Widget cfc) {
            float output_normalized = cfc.output_normalized;
            float tripThreshold = cfc.tripThreshold;
            float untripThreshold = cfc.untripThreshold;
            boolean switchTripped = cfc.switchTripped;
            float timeOfLastTrip = cfc.timeOfLastTrip;
            int timeToWaitThresh = 750;
            if (output_normalized >= tripThreshold && !switchTripped && (float)OpenBCI_GUI.this.millis() - timeOfLastTrip >= (float)timeToWaitThresh) {
                cfc.switchTripped = true;
                cfc.timeOfLastTrip = OpenBCI_GUI.this.millis();
                ++cfc.switchCounter;
            }
            if (switchTripped && output_normalized <= untripThreshold) {
                cfc.switchTripped = false;
            }
        }

        public void digitalEventChan13(Motor_Widget cfc) {
            float output_normalized = cfc.output_normalized;
            float tripThreshold = cfc.tripThreshold;
            float untripThreshold = cfc.untripThreshold;
            boolean switchTripped = cfc.switchTripped;
            float timeOfLastTrip = cfc.timeOfLastTrip;
            int timeToWaitThresh = 750;
            if (output_normalized >= tripThreshold && !switchTripped && (float)OpenBCI_GUI.this.millis() - timeOfLastTrip >= (float)timeToWaitThresh) {
                cfc.switchTripped = true;
                cfc.timeOfLastTrip = OpenBCI_GUI.this.millis();
                ++cfc.switchCounter;
            }
            if (switchTripped && output_normalized <= untripThreshold) {
                cfc.switchTripped = false;
            }
        }

        public void digitalEventChan14(Motor_Widget cfc) {
            float output_normalized = cfc.output_normalized;
            float tripThreshold = cfc.tripThreshold;
            float untripThreshold = cfc.untripThreshold;
            boolean switchTripped = cfc.switchTripped;
            float timeOfLastTrip = cfc.timeOfLastTrip;
            int timeToWaitThresh = 750;
            if (output_normalized >= tripThreshold && !switchTripped && (float)OpenBCI_GUI.this.millis() - timeOfLastTrip >= (float)timeToWaitThresh) {
                cfc.switchTripped = true;
                cfc.timeOfLastTrip = OpenBCI_GUI.this.millis();
                ++cfc.switchCounter;
            }
            if (switchTripped && output_normalized <= untripThreshold) {
                cfc.switchTripped = false;
            }
        }

        public void digitalEventChan15(Motor_Widget cfc) {
            float output_normalized = cfc.output_normalized;
            float tripThreshold = cfc.tripThreshold;
            float untripThreshold = cfc.untripThreshold;
            boolean switchTripped = cfc.switchTripped;
            float timeOfLastTrip = cfc.timeOfLastTrip;
            int timeToWaitThresh = 750;
            if (output_normalized >= tripThreshold && !switchTripped && (float)OpenBCI_GUI.this.millis() - timeOfLastTrip >= (float)timeToWaitThresh) {
                cfc.switchTripped = true;
                cfc.timeOfLastTrip = OpenBCI_GUI.this.millis();
                ++cfc.switchCounter;
            }
            if (switchTripped && output_normalized <= untripThreshold) {
                cfc.switchTripped = false;
            }
        }

        public void analogEventChan0(Motor_Widget cfc) {
            float output_normalized = cfc.output_normalized;
            float cfr_ignored_0 = cfc.tripThreshold;
            float cfr_ignored_1 = cfc.untripThreshold;
            boolean cfr_ignored_2 = cfc.switchTripped;
            float cfr_ignored_3 = cfc.timeOfLastTrip;
            if (this.serialOutEMG != null) {
                if (PApplet.parseInt((float)OpenBCI_GUI.map((float)output_normalized, (float)0.0f, (float)1.0f, (float)0.0f, (float)100.0f)) > 10) {
                    this.serialOutEMG.write("G0P" + PApplet.parseInt((float)OpenBCI_GUI.map((float)output_normalized, (float)0.0f, (float)1.0f, (float)0.0f, (float)100.0f)));
                    OpenBCI_GUI.this.delay(10);
                } else {
                    this.serialOutEMG.write("G0P0");
                }
            }
        }

        public void analogEventChan1(Motor_Widget cfc) {
            float cfr_ignored_0 = cfc.output_normalized;
            float cfr_ignored_1 = cfc.tripThreshold;
            float cfr_ignored_2 = cfc.untripThreshold;
            boolean cfr_ignored_3 = cfc.switchTripped;
            float cfr_ignored_4 = cfc.timeOfLastTrip;
        }

        public void analogEventChan2(Motor_Widget cfc) {
            float cfr_ignored_0 = cfc.output_normalized;
            float cfr_ignored_1 = cfc.tripThreshold;
            float cfr_ignored_2 = cfc.untripThreshold;
            boolean cfr_ignored_3 = cfc.switchTripped;
            float cfr_ignored_4 = cfc.timeOfLastTrip;
        }

        public void analogEventChan3(Motor_Widget cfc) {
            float cfr_ignored_0 = cfc.output_normalized;
            float cfr_ignored_1 = cfc.tripThreshold;
            float cfr_ignored_2 = cfc.untripThreshold;
            boolean cfr_ignored_3 = cfc.switchTripped;
            float cfr_ignored_4 = cfc.timeOfLastTrip;
        }

        public void analogEventChan4(Motor_Widget cfc) {
            float cfr_ignored_0 = cfc.output_normalized;
            float cfr_ignored_1 = cfc.tripThreshold;
            float cfr_ignored_2 = cfc.untripThreshold;
            boolean cfr_ignored_3 = cfc.switchTripped;
            float cfr_ignored_4 = cfc.timeOfLastTrip;
        }

        public void analogEventChan5(Motor_Widget cfc) {
            float cfr_ignored_0 = cfc.output_normalized;
            float cfr_ignored_1 = cfc.tripThreshold;
            float cfr_ignored_2 = cfc.untripThreshold;
            boolean cfr_ignored_3 = cfc.switchTripped;
            float cfr_ignored_4 = cfc.timeOfLastTrip;
        }

        public void analogEventChan6(Motor_Widget cfc) {
            float cfr_ignored_0 = cfc.output_normalized;
            float cfr_ignored_1 = cfc.tripThreshold;
            float cfr_ignored_2 = cfc.untripThreshold;
            boolean cfr_ignored_3 = cfc.switchTripped;
            float cfr_ignored_4 = cfc.timeOfLastTrip;
        }

        public void analogEventChan7(Motor_Widget cfc) {
            float cfr_ignored_0 = cfc.output_normalized;
            float cfr_ignored_1 = cfc.tripThreshold;
            float cfr_ignored_2 = cfc.untripThreshold;
            boolean cfr_ignored_3 = cfc.switchTripped;
            float cfr_ignored_4 = cfc.timeOfLastTrip;
        }

        public void analogEventChan8(Motor_Widget cfc) {
            float cfr_ignored_0 = cfc.output_normalized;
            float cfr_ignored_1 = cfc.tripThreshold;
            float cfr_ignored_2 = cfc.untripThreshold;
            boolean cfr_ignored_3 = cfc.switchTripped;
            float cfr_ignored_4 = cfc.timeOfLastTrip;
        }

        public void analogEventChan9(Motor_Widget cfc) {
            float cfr_ignored_0 = cfc.output_normalized;
            float cfr_ignored_1 = cfc.tripThreshold;
            float cfr_ignored_2 = cfc.untripThreshold;
            boolean cfr_ignored_3 = cfc.switchTripped;
            float cfr_ignored_4 = cfc.timeOfLastTrip;
        }

        public void analogEventChan10(Motor_Widget cfc) {
            float cfr_ignored_0 = cfc.output_normalized;
            float cfr_ignored_1 = cfc.tripThreshold;
            float cfr_ignored_2 = cfc.untripThreshold;
            boolean cfr_ignored_3 = cfc.switchTripped;
            float cfr_ignored_4 = cfc.timeOfLastTrip;
        }

        public void analogEventChan11(Motor_Widget cfc) {
            float cfr_ignored_0 = cfc.output_normalized;
            float cfr_ignored_1 = cfc.tripThreshold;
            float cfr_ignored_2 = cfc.untripThreshold;
            boolean cfr_ignored_3 = cfc.switchTripped;
            float cfr_ignored_4 = cfc.timeOfLastTrip;
        }

        public void analogEventChan12(Motor_Widget cfc) {
            float cfr_ignored_0 = cfc.output_normalized;
            float cfr_ignored_1 = cfc.tripThreshold;
            float cfr_ignored_2 = cfc.untripThreshold;
            boolean cfr_ignored_3 = cfc.switchTripped;
            float cfr_ignored_4 = cfc.timeOfLastTrip;
        }

        public void analogEventChan13(Motor_Widget cfc) {
            float cfr_ignored_0 = cfc.output_normalized;
            float cfr_ignored_1 = cfc.tripThreshold;
            float cfr_ignored_2 = cfc.untripThreshold;
            boolean cfr_ignored_3 = cfc.switchTripped;
            float cfr_ignored_4 = cfc.timeOfLastTrip;
        }

        public void analogEventChan14(Motor_Widget cfc) {
            float cfr_ignored_0 = cfc.output_normalized;
            float cfr_ignored_1 = cfc.tripThreshold;
            float cfr_ignored_2 = cfc.untripThreshold;
            boolean cfr_ignored_3 = cfc.switchTripped;
            float cfr_ignored_4 = cfc.timeOfLastTrip;
        }

        public void analogEventChan15(Motor_Widget cfc) {
            float cfr_ignored_0 = cfc.output_normalized;
            float cfr_ignored_1 = cfc.tripThreshold;
            float cfr_ignored_2 = cfc.untripThreshold;
            boolean cfr_ignored_3 = cfc.switchTripped;
            float cfr_ignored_4 = cfc.timeOfLastTrip;
        }

        class Motor_Widget {
            boolean isTriggered = false;
            float upperThreshold = 25.0f;
            float lowerThreshold = 0.0f;
            int thresholdPeriod = 1250;
            int ourChan = 0;
            float myAverage = 0.0f;
            boolean switchTripped = false;
            int switchCounter = 0;
            float timeOfLastTrip = 0.0f;
            float tripThreshold = 0.75f;
            float untripThreshold = 0.5f;
            int output = 0;
            float output_normalized = 0.0f;
            float output_adjusted = 0.0f;
            boolean analogBool = true;
            boolean digitalBool = true;
            float averagePeriod;
            float acceptableLimitUV = 200.0f;
            float creepSpeed = 0.99f;
            float minRange = 20.0f;

            Motor_Widget() {
            }
        }

        class TripSlider {
            int lx;
            int ly;
            int boxx;
            int boxy;
            int stretch;
            int wid;
            int len;
            int boxLen;
            boolean over;
            boolean press;
            boolean locked = false;
            boolean otherslocked = false;
            boolean trip;
            boolean drawHand;
            TripSlider[] others;
            int current_color;
            Motor_Widget parent;

            TripSlider(int ix, int iy, float il, int iwid, int ilen, TripSlider[] o, boolean wastrip, Motor_Widget p) {
                this.current_color = OpenBCI_GUI.this.color(255, 255, 255);
                this.lx = ix;
                this.ly = iy;
                this.boxLen = PApplet.parseInt((float)il);
                this.wid = iwid;
                this.len = ilen;
                this.boxx = this.lx - this.wid / 2;
                this.boxy = this.ly - this.stretch - this.len / 2;
                this.others = o;
                this.trip = wastrip;
                this.parent = p;
            }

            public void update(float tx, float ty) {
                this.boxx = this.lx;
                this.boxy = PApplet.parseInt((float)(this.ly + this.stretch));
                int i = 0;
                while (i < this.others.length) {
                    if (this.others[i].locked) {
                        this.otherslocked = true;
                        break;
                    }
                    this.otherslocked = false;
                    ++i;
                }
                if (!this.otherslocked) {
                    this.overEvent(tx, ty);
                    this.pressEvent();
                }
                if (this.press) {
                    int mappedVal = PApplet.parseInt((float)((float)((W_emg)W_emg.this).OpenBCI_GUI.this.mouseY - (ty + (float)this.ly)));
                    this.stretch = !this.trip ? this.lock(mappedVal, PApplet.parseInt((float)(this.parent.untripThreshold * (float)this.boxLen)), this.boxLen) : this.lock(mappedVal, 0, PApplet.parseInt((float)(this.parent.tripThreshold * (float)this.boxLen)));
                    if (mappedVal > this.boxLen && !this.trip) {
                        this.parent.tripThreshold = 1.0f;
                    } else if (mappedVal > this.boxLen && this.trip) {
                        this.parent.untripThreshold = 1.0f;
                    } else if (mappedVal < 0 && !this.trip) {
                        this.parent.tripThreshold = 0.0f;
                    } else if (mappedVal < 0 && this.trip) {
                        this.parent.untripThreshold = 0.0f;
                    } else if (!this.trip) {
                        this.parent.tripThreshold = PApplet.parseFloat((int)mappedVal) / (float)this.boxLen;
                    } else if (this.trip) {
                        this.parent.untripThreshold = PApplet.parseFloat((int)mappedVal) / (float)this.boxLen;
                    }
                }
            }

            public void overEvent(float tx, float ty) {
                this.over = this.overRect(PApplet.parseInt((float)((float)this.boxx + tx)), PApplet.parseInt((float)((float)this.boxy + ty)), this.wid, this.len);
            }

            public void pressEvent() {
                if (this.over && ((W_emg)W_emg.this).OpenBCI_GUI.this.mousePressed || this.locked) {
                    this.press = true;
                    this.locked = true;
                } else {
                    this.press = false;
                }
            }

            public void releaseEvent() {
                this.locked = false;
            }

            public void setColor() {
                if (this.over) {
                    this.current_color = OpenBCI_GUI.this.color(127, 134, 143);
                    if (!this.drawHand) {
                        OpenBCI_GUI.this.cursor(12);
                        this.drawHand = true;
                    }
                } else {
                    this.current_color = this.trip ? OpenBCI_GUI.this.color(0, 255, 0) : OpenBCI_GUI.this.color(255, 0, 0);
                    if (this.drawHand) {
                        OpenBCI_GUI.this.cursor(0);
                        this.drawHand = false;
                    }
                }
            }

            public void setStretchPercentage(float val) {
                this.stretch = this.lock(PApplet.parseInt((float)((float)this.boxLen - (float)this.boxLen * val)), 0, this.boxLen);
            }

            public void display(float tx, float ty, float tw, float tl) {
                this.lx = PApplet.parseInt((float)tx);
                this.ly = PApplet.parseInt((float)ty);
                this.wid = PApplet.parseInt((float)tw);
                this.boxLen = PApplet.parseInt((float)tl);
                OpenBCI_GUI.this.fill(255);
                OpenBCI_GUI.this.strokeWeight(1.0f);
                OpenBCI_GUI.this.stroke(((W_emg)W_emg.this).OpenBCI_GUI.this.bgColor);
                this.setColor();
                OpenBCI_GUI.this.fill(this.current_color);
                OpenBCI_GUI.this.rect(this.boxx, this.boxy, this.wid, this.len);
            }

            public boolean overRect(int lx, int ly, int twidth, int theight) {
                return ((W_emg)W_emg.this).OpenBCI_GUI.this.mouseX >= lx && ((W_emg)W_emg.this).OpenBCI_GUI.this.mouseX <= lx + twidth && ((W_emg)W_emg.this).OpenBCI_GUI.this.mouseY >= ly && ((W_emg)W_emg.this).OpenBCI_GUI.this.mouseY <= ly + theight;
            }

            public int lock(int val, int minv, int maxv) {
                return OpenBCI_GUI.min((int)OpenBCI_GUI.max((int)val, (int)minv), (int)maxv);
            }
        }
    }

    class W_fft
    extends Widget {
        GPlot fft_plot;
        GPointsArray[] fft_points;
        int[] lineColor;
        int[] xLimOptions;
        int[] yLimOptions;
        int xLim;
        int xMax;
        int FFT_indexLim;
        int yLim;

        W_fft(PApplet _parent) {
            super(_parent);
            this.lineColor = new int[]{OpenBCI_GUI.this.color(129, 129, 129), OpenBCI_GUI.this.color(124, 75, 141), OpenBCI_GUI.this.color(54, 87, 158), OpenBCI_GUI.this.color(49, 113, 89), OpenBCI_GUI.this.color(221, 178, 13), OpenBCI_GUI.this.color(253, 94, 52), OpenBCI_GUI.this.color(224, 56, 45), OpenBCI_GUI.this.color(162, 82, 49), OpenBCI_GUI.this.color(129, 129, 129), OpenBCI_GUI.this.color(124, 75, 141), OpenBCI_GUI.this.color(54, 87, 158), OpenBCI_GUI.this.color(49, 113, 89), OpenBCI_GUI.this.color(221, 178, 13), OpenBCI_GUI.this.color(253, 94, 52), OpenBCI_GUI.this.color(224, 56, 45), OpenBCI_GUI.this.color(162, 82, 49)};
            this.xLimOptions = new int[]{20, 40, 60, 100, 120, 250, 500, 800};
            this.yLimOptions = new int[]{10, 50, 100, 1000};
            this.xLim = this.xLimOptions[2];
            this.xMax = this.xLimOptions[this.xLimOptions.length - 1];
            this.FFT_indexLim = PApplet.parseInt((float)(1.0f * (float)this.xMax * ((float)OpenBCI_GUI.this.getNfftSafe() / OpenBCI_GUI.this.getSampleRateSafe())));
            this.yLim = this.yLimOptions[2];
            this.addDropdown("MaxFreq", "Max Freq", Arrays.asList("20 Hz", "40 Hz", "60 Hz", "100 Hz", "120 Hz", "250 Hz", "500 Hz", "800 Hz"), 2);
            this.addDropdown("VertScale", "Max uV", Arrays.asList("10 uV", "50 uV", "100 uV", "1000 uV"), 2);
            this.addDropdown("LogLin", "Log/Lin", Arrays.asList("Log", "Linear"), 0);
            this.addDropdown("Smoothing", "Smooth", Arrays.asList("0.0", "0.5", "0.75", "0.9", "0.95", "0.98"), OpenBCI_GUI.this.smoothFac_ind);
            this.addDropdown("UnfiltFilt", "Filters?", Arrays.asList("Filtered", "Unfilt."), 0);
            this.fft_points = new GPointsArray[OpenBCI_GUI.this.nchan];
            this.initializeFFTPlot(_parent);
        }

        public void initializeFFTPlot(PApplet _parent) {
            this.fft_plot = new GPlot(_parent, (float)this.x, (float)(this.y - OpenBCI_GUI.this.navHeight), (float)this.w, (float)(this.h + OpenBCI_GUI.this.navHeight));
            this.fft_plot.getXAxis().setAxisLabelText("Frequency (Hz)");
            this.fft_plot.getYAxis().setAxisLabelText("Amplitude (uV)");
            this.fft_plot.setMar(60.0f, 70.0f, 40.0f, 30.0f);
            this.fft_plot.setLogScale("y");
            this.fft_plot.setYLim(0.1f, (float)this.yLim);
            int _nTicks = PApplet.parseInt((float)(this.yLim / 10 - 1));
            this.fft_plot.getYAxis().setNTicks(_nTicks);
            this.fft_plot.setXLim(0.1f, (float)this.xLim);
            this.fft_plot.getYAxis().setDrawTickLabels(true);
            this.fft_plot.setPointSize(2.0f);
            this.fft_plot.setPointColor(0);
            int i = 0;
            while (i < this.fft_points.length) {
                this.fft_points[i] = new GPointsArray(this.FFT_indexLim);
                ++i;
            }
            i = 0;
            while (i < this.fft_points.length) {
                int j = 0;
                while (j < this.FFT_indexLim) {
                    GPoint temp = new GPoint((float)j, 0.0f);
                    this.fft_points[i].set(j, temp);
                    ++j;
                }
                ++i;
            }
            this.fft_plot.setPoints(this.fft_points[0]);
        }

        @Override
        public void update() {
            super.update();
            float sr = OpenBCI_GUI.this.getSampleRateSafe();
            int nfft = OpenBCI_GUI.this.getNfftSafe();
            int i = 0;
            while (i < this.fft_points.length) {
                int j = 0;
                while (j < this.FFT_indexLim + 2) {
                    GPoint powerAtBin = new GPoint(1.0f * sr / (float)nfft * (float)j, OpenBCI_GUI.this.fftBuff[i].getBand(j));
                    this.fft_points[i].set(j, powerAtBin);
                    ++j;
                }
                ++i;
            }
            this.fft_plot.setPoints(this.fft_points[0]);
        }

        @Override
        public void draw() {
            super.draw();
            OpenBCI_GUI.this.pushStyle();
            OpenBCI_GUI.this.noStroke();
            this.fft_plot.beginDraw();
            this.fft_plot.drawBackground();
            this.fft_plot.drawBox();
            this.fft_plot.drawXAxis();
            this.fft_plot.drawYAxis();
            this.fft_plot.drawGridLines(2);
            int i = 0;
            while (i < this.fft_points.length) {
                this.fft_plot.setLineColor(this.lineColor[i]);
                this.fft_plot.setPoints(this.fft_points[i]);
                this.fft_plot.drawLines();
                ++i;
            }
            this.fft_plot.endDraw();
            OpenBCI_GUI.this.fill(200.0f, 200.0f, 200.0f);
            OpenBCI_GUI.this.rect(this.x, this.y - OpenBCI_GUI.this.navHeight, this.w, OpenBCI_GUI.this.navHeight);
            OpenBCI_GUI.this.popStyle();
        }

        @Override
        public void screenResized() {
            super.screenResized();
            this.fft_plot.setPos((float)this.x, (float)(this.y - OpenBCI_GUI.this.navHeight));
            this.fft_plot.setOuterDim((float)this.w, (float)(this.h + OpenBCI_GUI.this.navHeight));
        }

        @Override
        public void mousePressed() {
            super.mousePressed();
        }

        @Override
        public void mouseReleased() {
            super.mouseReleased();
        }
    }

    class W_ganglionImpedance
    extends Widget {
        Button startStopCheck;
        int padding;

        W_ganglionImpedance(PApplet _parent) {
            super(_parent);
            this.padding = 24;
            this.startStopCheck = new Button(this.x + this.padding, this.y + this.padding, 200, OpenBCI_GUI.this.navHeight, "Start Impedance Check", 12);
            this.startStopCheck.setFont(OpenBCI_GUI.this.p4, 14);
        }

        @Override
        public void update() {
            super.update();
        }

        @Override
        public void draw() {
            super.draw();
            OpenBCI_GUI.this.pushStyle();
            this.startStopCheck.draw();
            OpenBCI_GUI.this.fill(OpenBCI_GUI.this.bgColor);
            OpenBCI_GUI.this.textFont(OpenBCI_GUI.this.p4, 14.0f);
            int i = 0;
            while (i < OpenBCI_GUI.this.ganglion.impedanceArray.length) {
                float adjustedImpedance = (float)OpenBCI_GUI.this.ganglion.impedanceArray[i] / 2.0f;
                String toPrint = i == 0 ? "Reference Impedance \u2248 " + adjustedImpedance + " k\u2126" : "Channel[" + i + "] Impedance \u2248 " + adjustedImpedance + " k\u2126";
                OpenBCI_GUI.this.text(toPrint, this.x + this.padding + 40, this.y + this.padding * 2 + 12 + this.startStopCheck.but_dy + this.padding * i);
                OpenBCI_GUI.this.pushStyle();
                OpenBCI_GUI.this.stroke(OpenBCI_GUI.this.bgColor);
                if (adjustedImpedance <= 0.0f) {
                    OpenBCI_GUI.this.fill(255);
                } else if (adjustedImpedance > 0.0f && adjustedImpedance <= 10.0f) {
                    OpenBCI_GUI.this.fill(49.0f, 113.0f, 89.0f);
                } else if (adjustedImpedance > 10.0f && adjustedImpedance <= 50.0f) {
                    OpenBCI_GUI.this.fill(184.0f, 220.0f, 105.0f);
                } else if (adjustedImpedance > 50.0f && adjustedImpedance <= 100.0f) {
                    OpenBCI_GUI.this.fill(221.0f, 178.0f, 13.0f);
                } else if (adjustedImpedance > 100.0f && adjustedImpedance <= 150.0f) {
                    OpenBCI_GUI.this.fill(253.0f, 94.0f, 52.0f);
                } else if (adjustedImpedance > 150.0f) {
                    OpenBCI_GUI.this.fill(224.0f, 56.0f, 45.0f);
                }
                OpenBCI_GUI.this.ellipse(this.x + this.padding + 10, this.y + this.padding * 2 + 7 + this.startStopCheck.but_dy + this.padding * i, this.padding / 2, this.padding / 2);
                OpenBCI_GUI.this.popStyle();
                ++i;
            }
            if (OpenBCI_GUI.this.isHubInitialized && OpenBCI_GUI.this.isHubObjectInitialized && OpenBCI_GUI.this.eegDataSource == 1 && OpenBCI_GUI.this.ganglion.isCheckingImpedance()) {
                OpenBCI_GUI.this.image((PImage)OpenBCI_GUI.this.loadingGIF_blue, this.x + this.padding + this.startStopCheck.but_dx + 15, this.y + this.padding - 8, 40.0f, 40.0f);
            }
            OpenBCI_GUI.this.popStyle();
        }

        @Override
        public void screenResized() {
            super.screenResized();
            this.startStopCheck.setPos(this.x + this.padding, this.y + this.padding);
        }

        @Override
        public void mousePressed() {
            super.mousePressed();
            if (this.startStopCheck.isMouseHere()) {
                this.startStopCheck.setIsActive(true);
            }
        }

        @Override
        public void mouseReleased() {
            super.mouseReleased();
            if (this.startStopCheck.isActive && this.startStopCheck.isMouseHere() && OpenBCI_GUI.this.isHubInitialized && OpenBCI_GUI.this.isHubObjectInitialized && OpenBCI_GUI.this.eegDataSource == 1) {
                if (OpenBCI_GUI.this.ganglion.isCheckingImpedance()) {
                    OpenBCI_GUI.this.ganglion.impedanceStop();
                    this.startStopCheck.but_txt = "Start Impedance Check";
                } else {
                    OpenBCI_GUI.this.ganglion.impedanceStart();
                    this.startStopCheck.but_txt = "Stop Impedance Check";
                    OpenBCI_GUI.this.stopRunning();
                    OpenBCI_GUI.this.topNav.stopButton.setString("Start Data Stream");
                    OpenBCI_GUI.this.topNav.stopButton.setColorNotPressed(OpenBCI_GUI.this.color(184, 220, 105));
                }
            }
            this.startStopCheck.setIsActive(false);
        }

        public void customFunction() {
        }
    }

    class W_headPlot
    extends Widget {
        HeadPlot headPlot;

        W_headPlot(PApplet _parent) {
            super(_parent);
            this.addDropdown("Intensity", "Intensity", Arrays.asList("4x", "2x", "1x", "0.5x", "0.2x", "0.02x"), OpenBCI_GUI.this.vertScaleFactor_ind);
            this.addDropdown("Polarity", "Polarity", Arrays.asList("+/-", " + "), 0);
            this.addDropdown("ShowContours", "Contours", Arrays.asList("ON", "OFF"), 0);
            this.addDropdown("SmoothingHeadPlot", "Smooth", Arrays.asList("0.0", "0.5", "0.75", "0.9", "0.95", "0.98"), OpenBCI_GUI.this.smoothFac_ind);
            this.headPlot = new HeadPlot(this.x, this.y, this.w, this.h, OpenBCI_GUI.this.win_x, OpenBCI_GUI.this.win_y);
            this.headPlot.setIntensityData_byRef(OpenBCI_GUI.this.dataProcessing.data_std_uV, OpenBCI_GUI.this.is_railed);
            this.headPlot.setPolarityData_byRef(OpenBCI_GUI.this.dataProcessing.polarity);
            this.setSmoothFac(OpenBCI_GUI.this.smoothFac[OpenBCI_GUI.this.smoothFac_ind]);
        }

        @Override
        public void update() {
            super.update();
            this.headPlot.update();
        }

        @Override
        public void draw() {
            super.draw();
            this.headPlot.draw();
        }

        @Override
        public void screenResized() {
            super.screenResized();
            this.headPlot.hp_x = this.x;
            this.headPlot.hp_y = this.y;
            this.headPlot.hp_w = this.w;
            this.headPlot.hp_h = this.h;
            this.headPlot.hp_win_x = this.x;
            this.headPlot.hp_win_y = this.y;
            OpenBCI_GUI.this.thread("doHardCalcs");
        }

        @Override
        public void mousePressed() {
            super.mousePressed();
            this.headPlot.mousePressed();
        }

        @Override
        public void mouseReleased() {
            super.mouseReleased();
            this.headPlot.mouseReleased();
        }

        @Override
        public void mouseDragged() {
            super.mouseDragged();
            this.headPlot.mouseDragged();
        }

        public void setSmoothFac(float fac) {
            this.headPlot.smooth_fac = fac;
        }
    }

    class W_networking
    extends Widget {
        int protocolIndex;
        String protocolMode;
        ControlP5 cp5_networking;
        ControlP5 cp5_networking_dropdowns;
        ControlP5 cp5_networking_baudRate;
        ControlP5 cp5_networking_portName;
        boolean dataDropdownsShouldBeClosed;
        int column0;
        int column1;
        int column2;
        int column3;
        int fullColumnWidth;
        int twoThirdsWidth;
        int row0;
        int row1;
        int row2;
        int row3;
        int row4;
        int row5;
        Boolean osc_visible;
        Boolean udp_visible;
        Boolean lsl_visible;
        Boolean serial_visible;
        List<String> dataTypes;
        Button startButton;
        Boolean networkActive;
        Stream stream1;
        Stream stream2;
        Stream stream3;
        List<String> baudRates;
        List<String> comPorts;
        String defaultBaud;

        W_networking(PApplet _parent) {
            super(_parent);
            this.dataDropdownsShouldBeClosed = false;
            this.networkActive = false;
            this.stream1 = null;
            this.stream2 = null;
            this.stream3 = null;
            this.dataTypes = Arrays.asList("None", "TimeSeries", "FFT", "EMG", "BandPower", "Focus", "Widget");
            this.defaultBaud = "115200";
            this.baudRates = Arrays.asList("57600", "115200", "250000", "500000");
            this.protocolMode = "OSC";
            this.addDropdown("Protocol", "Protocol", Arrays.asList("OSC", "UDP", "LSL", "Serial"), this.protocolIndex);
            this.comPorts = new ArrayList<String>(Arrays.asList(Serial.list()));
            OpenBCI_GUI.println((String)("comPorts = " + this.comPorts));
            this.initialize_UI();
            this.cp5_networking.setAutoDraw(false);
            this.cp5_networking_dropdowns.setAutoDraw(false);
            this.cp5_networking_portName.setAutoDraw(false);
            this.cp5_networking_baudRate.setAutoDraw(false);
        }

        @Override
        public void update() {
            super.update();
            if (this.protocolMode.equals("LSL")) {
                if (this.stream1 != null) {
                    this.stream1.run();
                }
                if (this.stream2 != null) {
                    this.stream2.run();
                }
                if (this.stream2 != null) {
                    this.stream2.run();
                }
            }
            if (this.dataDropdownsShouldBeClosed) {
                this.dataDropdownsShouldBeClosed = false;
            } else {
                if (((ScrollableList)this.cp5_networking_dropdowns.get(ScrollableList.class, "dataType1")).isOpen() && !this.cp5_networking_dropdowns.getController("dataType1").isMouseOver()) {
                    ((ScrollableList)this.cp5_networking_dropdowns.get(ScrollableList.class, "dataType1")).close();
                }
                if (!((ScrollableList)this.cp5_networking_dropdowns.get(ScrollableList.class, "dataType1")).isOpen() && this.cp5_networking_dropdowns.getController("dataType1").isMouseOver()) {
                    ((ScrollableList)this.cp5_networking_dropdowns.get(ScrollableList.class, "dataType1")).open();
                }
                if (((ScrollableList)this.cp5_networking_dropdowns.get(ScrollableList.class, "dataType2")).isOpen() && !this.cp5_networking_dropdowns.getController("dataType2").isMouseOver()) {
                    ((ScrollableList)this.cp5_networking_dropdowns.get(ScrollableList.class, "dataType2")).close();
                }
                if (!((ScrollableList)this.cp5_networking_dropdowns.get(ScrollableList.class, "dataType2")).isOpen() && this.cp5_networking_dropdowns.getController("dataType2").isMouseOver()) {
                    ((ScrollableList)this.cp5_networking_dropdowns.get(ScrollableList.class, "dataType2")).open();
                }
                if (((ScrollableList)this.cp5_networking_dropdowns.get(ScrollableList.class, "dataType3")).isOpen() && !this.cp5_networking_dropdowns.getController("dataType3").isMouseOver()) {
                    ((ScrollableList)this.cp5_networking_dropdowns.get(ScrollableList.class, "dataType3")).close();
                }
                if (!((ScrollableList)this.cp5_networking_dropdowns.get(ScrollableList.class, "dataType3")).isOpen() && this.cp5_networking_dropdowns.getController("dataType3").isMouseOver()) {
                    ((ScrollableList)this.cp5_networking_dropdowns.get(ScrollableList.class, "dataType3")).open();
                }
                if (((ScrollableList)this.cp5_networking_baudRate.get(ScrollableList.class, "baud_rate")).isOpen() && !this.cp5_networking_baudRate.getController("baud_rate").isMouseOver()) {
                    ((ScrollableList)this.cp5_networking_baudRate.get(ScrollableList.class, "baud_rate")).close();
                }
                if (!((ScrollableList)this.cp5_networking_baudRate.get(ScrollableList.class, "baud_rate")).isOpen() && !this.cp5_networking_dropdowns.getController("dataType1").isMouseOver() && this.cp5_networking_baudRate.getController("baud_rate").isMouseOver()) {
                    ((ScrollableList)this.cp5_networking_baudRate.get(ScrollableList.class, "baud_rate")).open();
                }
                if (((ScrollableList)this.cp5_networking_portName.get(ScrollableList.class, "port_name")).isOpen() && !this.cp5_networking_portName.getController("port_name").isMouseOver()) {
                    ((ScrollableList)this.cp5_networking_portName.get(ScrollableList.class, "port_name")).close();
                }
                if (!((ScrollableList)this.cp5_networking_portName.get(ScrollableList.class, "port_name")).isOpen() && !this.cp5_networking_dropdowns.getController("dataType1").isMouseOver() && !this.cp5_networking_baudRate.getController("baud_rate").isMouseOver() && this.cp5_networking_portName.getController("port_name").isMouseOver()) {
                    ((ScrollableList)this.cp5_networking_portName.get(ScrollableList.class, "port_name")).open();
                }
            }
        }

        @Override
        public void draw() {
            super.draw();
            OpenBCI_GUI.this.pushStyle();
            this.showCP5();
            this.cp5_networking.draw();
            OpenBCI_GUI.this.pushStyle();
            OpenBCI_GUI.this.fill(255);
            if (!this.protocolMode.equals("Serial")) {
                OpenBCI_GUI.this.rect(this.cp5_networking_dropdowns.getController("dataType1").getPosition()[0] - 1.0f, this.cp5_networking_dropdowns.getController("dataType1").getPosition()[1] - 1.0f, 102.0f, this.cp5_networking_dropdowns.getController("dataType1").getHeight() + 2);
                OpenBCI_GUI.this.rect(this.cp5_networking_dropdowns.getController("dataType2").getPosition()[0] - 1.0f, this.cp5_networking_dropdowns.getController("dataType2").getPosition()[1] - 1.0f, 102.0f, this.cp5_networking_dropdowns.getController("dataType2").getHeight() + 2);
                OpenBCI_GUI.this.rect(this.cp5_networking_dropdowns.getController("dataType3").getPosition()[0] - 1.0f, this.cp5_networking_dropdowns.getController("dataType3").getPosition()[1] - 1.0f, 102.0f, this.cp5_networking_dropdowns.getController("dataType3").getHeight() + 2);
                this.cp5_networking_dropdowns.draw();
            }
            if (this.protocolMode.equals("Serial")) {
                OpenBCI_GUI.this.rect(this.cp5_networking_portName.getController("port_name").getPosition()[0] - 1.0f, this.cp5_networking_portName.getController("port_name").getPosition()[1] - 1.0f, this.cp5_networking_portName.getController("port_name").getWidth() + 2, this.cp5_networking_portName.getController("port_name").getHeight() + 2);
                this.cp5_networking_portName.draw();
                OpenBCI_GUI.this.rect(this.cp5_networking_baudRate.getController("baud_rate").getPosition()[0] - 1.0f, this.cp5_networking_baudRate.getController("baud_rate").getPosition()[1] - 1.0f, this.cp5_networking_baudRate.getController("baud_rate").getWidth() + 2, this.cp5_networking_baudRate.getController("baud_rate").getHeight() + 2);
                this.cp5_networking_baudRate.draw();
                OpenBCI_GUI.this.rect(this.cp5_networking_dropdowns.getController("dataType1").getPosition()[0] - 1.0f, this.cp5_networking_dropdowns.getController("dataType1").getPosition()[1] - 1.0f, this.cp5_networking_dropdowns.getController("dataType1").getWidth() + 2, this.cp5_networking_dropdowns.getController("dataType1").getHeight() + 2);
                this.cp5_networking_dropdowns.draw();
            }
            OpenBCI_GUI.this.popStyle();
            OpenBCI_GUI.this.fill(0.0f, 0.0f, 0.0f);
            OpenBCI_GUI.this.textFont(OpenBCI_GUI.this.h1, 20.0f);
            if (!this.protocolMode.equals("Serial")) {
                OpenBCI_GUI.this.text(" Stream 1", this.column1, this.row0);
                OpenBCI_GUI.this.text(" Stream 2", this.column2, this.row0);
                OpenBCI_GUI.this.text(" Stream 3", this.column3, this.row0);
            }
            OpenBCI_GUI.this.text("Data Type", this.column0, this.row1);
            this.startButton.draw();
            if (this.protocolMode.equals("OSC")) {
                OpenBCI_GUI.this.textFont(OpenBCI_GUI.this.f4, 40.0f);
                OpenBCI_GUI.this.text("OSC", this.x + 20, this.y + this.h / 8 + 15);
                OpenBCI_GUI.this.textFont(OpenBCI_GUI.this.h1, 20.0f);
                OpenBCI_GUI.this.text("IP", this.column0, this.row2);
                OpenBCI_GUI.this.text("Port", this.column0, this.row3);
                OpenBCI_GUI.this.text("Address", this.column0, this.row4);
                OpenBCI_GUI.this.text("Filters", this.column0, this.row5);
            } else if (this.protocolMode.equals("UDP")) {
                OpenBCI_GUI.this.textFont(OpenBCI_GUI.this.f4, 40.0f);
                OpenBCI_GUI.this.text("UDP", this.x + 20, this.y + this.h / 8 + 15);
                OpenBCI_GUI.this.textFont(OpenBCI_GUI.this.h1, 20.0f);
                OpenBCI_GUI.this.text("IP", this.column0, this.row2);
                OpenBCI_GUI.this.text("Port", this.column0, this.row3);
                OpenBCI_GUI.this.text("Filters", this.column0, this.row4);
            } else if (this.protocolMode.equals("LSL")) {
                OpenBCI_GUI.this.textFont(OpenBCI_GUI.this.f4, 40.0f);
                OpenBCI_GUI.this.text("LSL", this.x + 20, this.y + this.h / 8 + 15);
                OpenBCI_GUI.this.textFont(OpenBCI_GUI.this.h1, 20.0f);
                OpenBCI_GUI.this.text("Name", this.column0, this.row2);
                OpenBCI_GUI.this.text("Type", this.column0, this.row3);
                OpenBCI_GUI.this.text("# Chan", this.column0, this.row4);
            } else if (this.protocolMode.equals("Serial")) {
                OpenBCI_GUI.this.textFont(OpenBCI_GUI.this.f4, 40.0f);
                OpenBCI_GUI.this.text("Serial", this.x + 20, this.y + this.h / 8 + 15);
                OpenBCI_GUI.this.textFont(OpenBCI_GUI.this.h1, 20.0f);
                OpenBCI_GUI.this.text("Baud/Port", this.column0, this.row2);
                OpenBCI_GUI.this.text("Filters", this.column0, this.row3);
            }
            OpenBCI_GUI.this.popStyle();
        }

        public void initialize_UI() {
            this.cp5_networking = new ControlP5(this.pApplet);
            this.cp5_networking_dropdowns = new ControlP5(this.pApplet);
            this.cp5_networking_baudRate = new ControlP5(this.pApplet);
            this.cp5_networking_portName = new ControlP5(this.pApplet);
            this.createTextFields("osc_ip1", "127.0.0.1");
            this.createTextFields("osc_port1", "12345");
            this.createTextFields("osc_address1", "/openbci");
            this.createTextFields("osc_ip2", "127.0.0.1");
            this.createTextFields("osc_port2", "12346");
            this.createTextFields("osc_address2", "/openbci");
            this.createTextFields("osc_ip3", "127.0.0.1");
            this.createTextFields("osc_port3", "12347");
            this.createTextFields("osc_address3", "/openbci");
            this.createTextFields("udp_ip1", "127.0.0.1");
            this.createTextFields("udp_port1", "12345");
            this.createTextFields("udp_ip2", "127.0.0.1");
            this.createTextFields("udp_port2", "12346");
            this.createTextFields("udp_ip3", "127.0.0.1");
            this.createTextFields("udp_port3", "12347");
            this.createTextFields("lsl_name1", "obci_eeg1");
            this.createTextFields("lsl_type1", "EEG");
            this.createTextFields("lsl_numchan1", Integer.toString(OpenBCI_GUI.this.nchan));
            this.createTextFields("lsl_name2", "obci_eeg2");
            this.createTextFields("lsl_type2", "EEG");
            this.createTextFields("lsl_numchan2", Integer.toString(OpenBCI_GUI.this.nchan));
            this.createTextFields("lsl_name3", "obci_eeg3");
            this.createTextFields("lsl_type3", "EEG");
            this.createTextFields("lsl_numchan3", Integer.toString(OpenBCI_GUI.this.nchan));
            this.createPortDropdown("port_name", this.comPorts);
            this.createBaudDropdown("baud_rate", this.baudRates);
            this.createRadioButtons("filter1");
            this.createRadioButtons("filter2");
            this.createRadioButtons("filter3");
            this.createDropdown("dataType1", this.dataTypes);
            this.createDropdown("dataType2", this.dataTypes);
            this.createDropdown("dataType3", this.dataTypes);
            this.startButton = new Button(this.x + this.w / 2 - 70, this.y + this.h - 40, 200, 20, "Start", 14);
            this.startButton.setFont(OpenBCI_GUI.this.p4, 14);
            this.startButton.setColorNotPressed(OpenBCI_GUI.this.color(184, 220, 105));
        }

        public void showCP5() {
            this.osc_visible = false;
            this.udp_visible = false;
            this.lsl_visible = false;
            this.serial_visible = false;
            if (this.protocolMode.equals("OSC")) {
                this.osc_visible = true;
            } else if (this.protocolMode.equals("UDP")) {
                this.udp_visible = true;
            } else if (this.protocolMode.equals("LSL")) {
                this.lsl_visible = true;
            } else if (this.protocolMode.equals("Serial")) {
                this.serial_visible = true;
            }
            ((Textfield)this.cp5_networking.get(Textfield.class, "osc_ip1")).setVisible(this.osc_visible.booleanValue());
            ((Textfield)this.cp5_networking.get(Textfield.class, "osc_port1")).setVisible(this.osc_visible.booleanValue());
            ((Textfield)this.cp5_networking.get(Textfield.class, "osc_address1")).setVisible(this.osc_visible.booleanValue());
            ((Textfield)this.cp5_networking.get(Textfield.class, "osc_ip2")).setVisible(this.osc_visible.booleanValue());
            ((Textfield)this.cp5_networking.get(Textfield.class, "osc_port2")).setVisible(this.osc_visible.booleanValue());
            ((Textfield)this.cp5_networking.get(Textfield.class, "osc_address2")).setVisible(this.osc_visible.booleanValue());
            ((Textfield)this.cp5_networking.get(Textfield.class, "osc_ip3")).setVisible(this.osc_visible.booleanValue());
            ((Textfield)this.cp5_networking.get(Textfield.class, "osc_port3")).setVisible(this.osc_visible.booleanValue());
            ((Textfield)this.cp5_networking.get(Textfield.class, "osc_address3")).setVisible(this.osc_visible.booleanValue());
            ((Textfield)this.cp5_networking.get(Textfield.class, "udp_ip1")).setVisible(this.udp_visible.booleanValue());
            ((Textfield)this.cp5_networking.get(Textfield.class, "udp_port1")).setVisible(this.udp_visible.booleanValue());
            ((Textfield)this.cp5_networking.get(Textfield.class, "udp_ip2")).setVisible(this.udp_visible.booleanValue());
            ((Textfield)this.cp5_networking.get(Textfield.class, "udp_port2")).setVisible(this.udp_visible.booleanValue());
            ((Textfield)this.cp5_networking.get(Textfield.class, "udp_ip3")).setVisible(this.udp_visible.booleanValue());
            ((Textfield)this.cp5_networking.get(Textfield.class, "udp_port3")).setVisible(this.udp_visible.booleanValue());
            ((Textfield)this.cp5_networking.get(Textfield.class, "lsl_name1")).setVisible(this.lsl_visible.booleanValue());
            ((Textfield)this.cp5_networking.get(Textfield.class, "lsl_type1")).setVisible(this.lsl_visible.booleanValue());
            ((Textfield)this.cp5_networking.get(Textfield.class, "lsl_numchan1")).setVisible(this.lsl_visible.booleanValue());
            ((Textfield)this.cp5_networking.get(Textfield.class, "lsl_name2")).setVisible(this.lsl_visible.booleanValue());
            ((Textfield)this.cp5_networking.get(Textfield.class, "lsl_type2")).setVisible(this.lsl_visible.booleanValue());
            ((Textfield)this.cp5_networking.get(Textfield.class, "lsl_numchan2")).setVisible(this.lsl_visible.booleanValue());
            ((Textfield)this.cp5_networking.get(Textfield.class, "lsl_name3")).setVisible(this.lsl_visible.booleanValue());
            ((Textfield)this.cp5_networking.get(Textfield.class, "lsl_type3")).setVisible(this.lsl_visible.booleanValue());
            ((Textfield)this.cp5_networking.get(Textfield.class, "lsl_numchan3")).setVisible(this.lsl_visible.booleanValue());
            ((ScrollableList)this.cp5_networking_portName.get(ScrollableList.class, "port_name")).setVisible(this.serial_visible.booleanValue());
            ((ScrollableList)this.cp5_networking_baudRate.get(ScrollableList.class, "baud_rate")).setVisible(this.serial_visible.booleanValue());
            ((ScrollableList)this.cp5_networking_dropdowns.get(ScrollableList.class, "dataType1")).setVisible(true);
            if (!this.serial_visible.booleanValue()) {
                ((ScrollableList)this.cp5_networking_dropdowns.get(ScrollableList.class, "dataType2")).setVisible(true);
                ((ScrollableList)this.cp5_networking_dropdowns.get(ScrollableList.class, "dataType3")).setVisible(true);
            } else {
                ((ScrollableList)this.cp5_networking_dropdowns.get(ScrollableList.class, "dataType2")).setVisible(false);
                ((ScrollableList)this.cp5_networking_dropdowns.get(ScrollableList.class, "dataType3")).setVisible(false);
            }
            ((RadioButton)this.cp5_networking.get(RadioButton.class, "filter1")).setVisible(true);
            if (!this.serial_visible.booleanValue()) {
                ((RadioButton)this.cp5_networking.get(RadioButton.class, "filter2")).setVisible(true);
                ((RadioButton)this.cp5_networking.get(RadioButton.class, "filter3")).setVisible(true);
            } else {
                ((RadioButton)this.cp5_networking.get(RadioButton.class, "filter2")).setVisible(false);
                ((RadioButton)this.cp5_networking.get(RadioButton.class, "filter3")).setVisible(false);
            }
        }

        public void createTextFields(String name, String default_text) {
            ((Textfield)((Textfield)((Textfield)((Textfield)((Textfield)((Textfield)((Textfield)((Textfield)this.cp5_networking.addTextfield(name).align(10, 100, 10, 100)).setSize(100, 20).setFont(OpenBCI_GUI.this.f2)).setFocus(false).setColor(OpenBCI_GUI.this.color(26, 26, 26)).setColorBackground(OpenBCI_GUI.this.color(255, 255, 255))).setColorValueLabel(OpenBCI_GUI.this.color(0, 0, 0))).setColorForeground(OpenBCI_GUI.this.color(26, 26, 26))).setColorActive(OpenBCI_GUI.this.isSelected_color)).setColorCursor(OpenBCI_GUI.this.color(26, 26, 26)).setText(default_text).setCaptionLabel("")).setVisible(false)).setAutoClear(true);
        }

        public void createRadioButtons(String name) {
            String id = name.substring(name.length() - 1);
            ((RadioButton)((RadioButton)((RadioButton)((RadioButton)this.cp5_networking.addRadioButton(name).setSize(10, 10).setColorForeground(OpenBCI_GUI.this.color(120))).setColorBackground(OpenBCI_GUI.this.color(200, 200, 200))).setColorActive(OpenBCI_GUI.this.color(184, 220, 105))).setColorLabel(OpenBCI_GUI.this.color(0))).setItemsPerRow(2).setSpacingColumn(40).addItem(String.valueOf(id) + "-Off", 0.0f).addItem(String.valueOf(id) + "-On", 1.0f).activate(0).setVisible(false);
        }

        public void createDropdown(String name, List<String> _items) {
            ((ScrollableList)((ScrollableList)((ScrollableList)((ScrollableList)((ScrollableList)((ScrollableList)this.cp5_networking_dropdowns.addScrollableList(name).setOpen(false).setColorBackground(OpenBCI_GUI.this.color(31, 69, 110))).setColorValueLabel(OpenBCI_GUI.this.color(255))).setColorCaptionLabel(OpenBCI_GUI.this.color(255))).setColorForeground(OpenBCI_GUI.this.color(125))).setColorActive(OpenBCI_GUI.this.color(150, 170, 200))).setSize(100, (_items.size() + 1) * (this.navH - 4))).setBarHeight(this.navH - 4).setItemHeight(this.navH - 4).addItems(_items).setVisible(false);
            this.cp5_networking_dropdowns.getController(name).getCaptionLabel().toUpperCase(false).setText("None").setFont(OpenBCI_GUI.this.h4).setSize(14).getStyle().setPaddingTop(4);
            this.cp5_networking_dropdowns.getController(name).getValueLabel().toUpperCase(false).setText("None").setFont(OpenBCI_GUI.this.h5).setSize(12).getStyle().setPaddingTop(3);
        }

        public void createBaudDropdown(String name, List<String> _items) {
            ((ScrollableList)((ScrollableList)((ScrollableList)((ScrollableList)((ScrollableList)((ScrollableList)this.cp5_networking_baudRate.addScrollableList(name).setOpen(false).setColorBackground(OpenBCI_GUI.this.color(31, 69, 110))).setColorValueLabel(OpenBCI_GUI.this.color(255))).setColorCaptionLabel(OpenBCI_GUI.this.color(255))).setColorForeground(OpenBCI_GUI.this.color(125))).setColorActive(OpenBCI_GUI.this.color(150, 170, 200))).setSize(100, (_items.size() + 1) * (this.navH - 4))).setBarHeight(this.navH - 4).setItemHeight(this.navH - 4).addItems(_items).setVisible(false);
            this.cp5_networking_baudRate.getController(name).getCaptionLabel().toUpperCase(false).setText(this.defaultBaud).setFont(OpenBCI_GUI.this.h4).setSize(14).getStyle().setPaddingTop(4);
            this.cp5_networking_baudRate.getController(name).getValueLabel().toUpperCase(false).setText("None").setFont(OpenBCI_GUI.this.h5).setSize(12).getStyle().setPaddingTop(3);
        }

        public void createPortDropdown(String name, List<String> _items) {
            ((ScrollableList)((ScrollableList)((ScrollableList)((ScrollableList)((ScrollableList)((ScrollableList)this.cp5_networking_portName.addScrollableList(name).setOpen(false).setColorBackground(OpenBCI_GUI.this.color(31, 69, 110))).setColorValueLabel(OpenBCI_GUI.this.color(255))).setColorCaptionLabel(OpenBCI_GUI.this.color(255))).setColorForeground(OpenBCI_GUI.this.color(125))).setColorActive(OpenBCI_GUI.this.color(150, 170, 200))).setSize(100, (_items.size() + 1) * (this.navH - 4))).setBarHeight(this.navH - 4).setItemHeight(this.navH - 4).addItems(_items).setVisible(false);
            this.cp5_networking_portName.getController(name).getCaptionLabel().toUpperCase(false).setText("None").setFont(OpenBCI_GUI.this.h4).setSize(14).getStyle().setPaddingTop(4);
            this.cp5_networking_portName.getController(name).getValueLabel().toUpperCase(false).setText("None").setFont(OpenBCI_GUI.this.h5).setSize(12).getStyle().setPaddingTop(3);
        }

        @Override
        public void screenResized() {
            super.screenResized();
            this.cp5_networking.setGraphics(this.pApplet, 0, 0);
            this.cp5_networking_dropdowns.setGraphics(this.pApplet, 0, 0);
            this.cp5_networking_baudRate.setGraphics(this.pApplet, 0, 0);
            this.cp5_networking_portName.setGraphics(this.pApplet, 0, 0);
            this.column0 = this.x + this.w / 20;
            this.column1 = this.x + 12 * this.w / 40;
            this.column2 = this.x + 21 * this.w / 40;
            this.column3 = this.x + 30 * this.w / 40;
            this.twoThirdsWidth = this.column2 + 100 - this.column1;
            this.fullColumnWidth = this.column3 + 100 - this.column1;
            this.row0 = this.y + this.h / 4 + 10;
            this.row1 = this.y + 4 * this.h / 10;
            this.row2 = this.y + 5 * this.h / 10;
            this.row3 = this.y + 6 * this.h / 10;
            this.row4 = this.y + 7 * this.h / 10;
            this.row5 = this.y + 8 * this.h / 10;
            int offset = 17;
            this.startButton.setPos(this.x + this.w / 2 - 70, this.y + this.h - 40);
            ((Textfield)this.cp5_networking.get(Textfield.class, "osc_ip1")).setPosition((float)this.column1, (float)(this.row2 - offset));
            ((Textfield)this.cp5_networking.get(Textfield.class, "osc_port1")).setPosition((float)this.column1, (float)(this.row3 - offset));
            ((Textfield)this.cp5_networking.get(Textfield.class, "osc_address1")).setPosition((float)this.column1, (float)(this.row4 - offset));
            ((Textfield)this.cp5_networking.get(Textfield.class, "osc_ip2")).setPosition((float)this.column2, (float)(this.row2 - offset));
            ((Textfield)this.cp5_networking.get(Textfield.class, "osc_port2")).setPosition((float)this.column2, (float)(this.row3 - offset));
            ((Textfield)this.cp5_networking.get(Textfield.class, "osc_address2")).setPosition((float)this.column2, (float)(this.row4 - offset));
            ((Textfield)this.cp5_networking.get(Textfield.class, "osc_ip3")).setPosition((float)this.column3, (float)(this.row2 - offset));
            ((Textfield)this.cp5_networking.get(Textfield.class, "osc_port3")).setPosition((float)this.column3, (float)(this.row3 - offset));
            ((Textfield)this.cp5_networking.get(Textfield.class, "osc_address3")).setPosition((float)this.column3, (float)(this.row4 - offset));
            ((Textfield)this.cp5_networking.get(Textfield.class, "udp_ip1")).setPosition((float)this.column1, (float)(this.row2 - offset));
            ((Textfield)this.cp5_networking.get(Textfield.class, "udp_port1")).setPosition((float)this.column1, (float)(this.row3 - offset));
            ((Textfield)this.cp5_networking.get(Textfield.class, "udp_ip2")).setPosition((float)this.column2, (float)(this.row2 - offset));
            ((Textfield)this.cp5_networking.get(Textfield.class, "udp_port2")).setPosition((float)this.column2, (float)(this.row3 - offset));
            ((Textfield)this.cp5_networking.get(Textfield.class, "udp_ip3")).setPosition((float)this.column3, (float)(this.row2 - offset));
            ((Textfield)this.cp5_networking.get(Textfield.class, "udp_port3")).setPosition((float)this.column3, (float)(this.row3 - offset));
            ((Textfield)this.cp5_networking.get(Textfield.class, "lsl_name1")).setPosition((float)this.column1, (float)(this.row2 - offset));
            ((Textfield)this.cp5_networking.get(Textfield.class, "lsl_type1")).setPosition((float)this.column1, (float)(this.row3 - offset));
            ((Textfield)this.cp5_networking.get(Textfield.class, "lsl_numchan1")).setPosition((float)this.column1, (float)(this.row4 - offset));
            ((Textfield)this.cp5_networking.get(Textfield.class, "lsl_name2")).setPosition((float)this.column2, (float)(this.row2 - offset));
            ((Textfield)this.cp5_networking.get(Textfield.class, "lsl_type2")).setPosition((float)this.column2, (float)(this.row3 - offset));
            ((Textfield)this.cp5_networking.get(Textfield.class, "lsl_numchan2")).setPosition((float)this.column2, (float)(this.row4 - offset));
            ((Textfield)this.cp5_networking.get(Textfield.class, "lsl_name3")).setPosition((float)this.column3, (float)(this.row2 - offset));
            ((Textfield)this.cp5_networking.get(Textfield.class, "lsl_type3")).setPosition((float)this.column3, (float)(this.row3 - offset));
            ((Textfield)this.cp5_networking.get(Textfield.class, "lsl_numchan3")).setPosition((float)this.column3, (float)(this.row4 - offset));
            if (this.protocolMode.equals("OSC") || this.protocolMode.equals("LSL")) {
                ((RadioButton)this.cp5_networking.get(RadioButton.class, "filter1")).setPosition((float)this.column1, (float)(this.row5 - 10));
                ((RadioButton)this.cp5_networking.get(RadioButton.class, "filter2")).setPosition((float)this.column2, (float)(this.row5 - 10));
                ((RadioButton)this.cp5_networking.get(RadioButton.class, "filter3")).setPosition((float)this.column3, (float)(this.row5 - 10));
            } else if (this.protocolMode.equals("UDP")) {
                ((RadioButton)this.cp5_networking.get(RadioButton.class, "filter1")).setPosition((float)this.column1, (float)(this.row4 - 10));
                ((RadioButton)this.cp5_networking.get(RadioButton.class, "filter2")).setPosition((float)this.column2, (float)(this.row4 - 10));
                ((RadioButton)this.cp5_networking.get(RadioButton.class, "filter3")).setPosition((float)this.column3, (float)(this.row4 - 10));
            } else if (this.protocolMode.equals("Serial")) {
                ((RadioButton)this.cp5_networking.get(RadioButton.class, "filter1")).setPosition((float)this.column1, (float)(this.row3 - 10));
                ((RadioButton)this.cp5_networking.get(RadioButton.class, "filter2")).setPosition((float)this.column2, (float)(this.row3 - 10));
                ((RadioButton)this.cp5_networking.get(RadioButton.class, "filter3")).setPosition((float)this.column3, (float)(this.row3 - 10));
            }
            ((ScrollableList)this.cp5_networking_baudRate.get(ScrollableList.class, "baud_rate")).setPosition((float)this.column1, (float)(this.row2 - offset));
            ((ScrollableList)this.cp5_networking_portName.get(ScrollableList.class, "port_name")).setPosition((float)this.column2, (float)(this.row2 - offset));
            ((ScrollableList)this.cp5_networking_baudRate.get(ScrollableList.class, "baud_rate")).setSize(100, (this.baudRates.size() + 1) * (this.navH - 4));
            ((ScrollableList)this.cp5_networking_portName.get(ScrollableList.class, "port_name")).setSize(this.twoThirdsWidth, 5 * (this.navH - 4));
            ((ScrollableList)this.cp5_networking_dropdowns.get(ScrollableList.class, "dataType1")).setPosition((float)this.column1, (float)(this.row1 - offset));
            ((ScrollableList)this.cp5_networking_dropdowns.get(ScrollableList.class, "dataType2")).setPosition((float)this.column2, (float)(this.row1 - offset));
            ((ScrollableList)this.cp5_networking_dropdowns.get(ScrollableList.class, "dataType3")).setPosition((float)this.column3, (float)(this.row1 - offset));
        }

        @Override
        public void mousePressed() {
            super.mousePressed();
            if (this.startButton.isMouseHere()) {
                this.startButton.setIsActive(true);
            }
        }

        @Override
        public void mouseReleased() {
            super.mouseReleased();
            if (this.startButton.isActive && this.startButton.isMouseHere()) {
                if (!this.networkActive.booleanValue()) {
                    this.turnOnButton();
                    this.initializeStreams();
                    this.startNetwork();
                } else {
                    this.turnOffButton();
                    this.stopNetwork();
                }
            }
            this.startButton.setIsActive(false);
        }

        public void hideElements() {
            ((Textfield)this.cp5_networking.get(Textfield.class, "osc_ip1")).setVisible(false);
            ((Textfield)this.cp5_networking.get(Textfield.class, "osc_port1")).setVisible(false);
            ((Textfield)this.cp5_networking.get(Textfield.class, "osc_address1")).setVisible(false);
            ((Textfield)this.cp5_networking.get(Textfield.class, "osc_ip2")).setVisible(false);
            ((Textfield)this.cp5_networking.get(Textfield.class, "osc_port2")).setVisible(false);
            ((Textfield)this.cp5_networking.get(Textfield.class, "osc_address2")).setVisible(false);
            ((Textfield)this.cp5_networking.get(Textfield.class, "osc_ip3")).setVisible(false);
            ((Textfield)this.cp5_networking.get(Textfield.class, "osc_port3")).setVisible(false);
            ((Textfield)this.cp5_networking.get(Textfield.class, "osc_address3")).setVisible(false);
            ((Textfield)this.cp5_networking.get(Textfield.class, "udp_ip1")).setVisible(false);
            ((Textfield)this.cp5_networking.get(Textfield.class, "udp_port1")).setVisible(false);
            ((Textfield)this.cp5_networking.get(Textfield.class, "udp_ip2")).setVisible(false);
            ((Textfield)this.cp5_networking.get(Textfield.class, "udp_port2")).setVisible(false);
            ((Textfield)this.cp5_networking.get(Textfield.class, "udp_ip3")).setVisible(false);
            ((Textfield)this.cp5_networking.get(Textfield.class, "udp_port3")).setVisible(false);
            ((Textfield)this.cp5_networking.get(Textfield.class, "lsl_name1")).setVisible(false);
            ((Textfield)this.cp5_networking.get(Textfield.class, "lsl_type1")).setVisible(false);
            ((Textfield)this.cp5_networking.get(Textfield.class, "lsl_numchan1")).setVisible(false);
            ((Textfield)this.cp5_networking.get(Textfield.class, "lsl_name2")).setVisible(false);
            ((Textfield)this.cp5_networking.get(Textfield.class, "lsl_type2")).setVisible(false);
            ((Textfield)this.cp5_networking.get(Textfield.class, "lsl_numchan2")).setVisible(false);
            ((Textfield)this.cp5_networking.get(Textfield.class, "lsl_name3")).setVisible(false);
            ((Textfield)this.cp5_networking.get(Textfield.class, "lsl_type3")).setVisible(false);
            ((Textfield)this.cp5_networking.get(Textfield.class, "lsl_numchan3")).setVisible(false);
            ((ScrollableList)this.cp5_networking_dropdowns.get(ScrollableList.class, "dataType1")).setVisible(false);
            ((ScrollableList)this.cp5_networking_dropdowns.get(ScrollableList.class, "dataType2")).setVisible(false);
            ((ScrollableList)this.cp5_networking_dropdowns.get(ScrollableList.class, "dataType3")).setVisible(false);
            ((ScrollableList)this.cp5_networking_portName.get(ScrollableList.class, "port_name")).setVisible(false);
            ((ScrollableList)this.cp5_networking_baudRate.get(ScrollableList.class, "baud_rate")).setVisible(false);
            ((RadioButton)this.cp5_networking.get(RadioButton.class, "filter1")).setVisible(false);
            ((RadioButton)this.cp5_networking.get(RadioButton.class, "filter2")).setVisible(false);
            ((RadioButton)this.cp5_networking.get(RadioButton.class, "filter3")).setVisible(false);
        }

        public void turnOffButton() {
            this.startButton.setColorNotPressed(OpenBCI_GUI.this.color(184, 220, 105));
            this.startButton.setString("Start");
        }

        public void turnOnButton() {
            this.startButton.setColorNotPressed(OpenBCI_GUI.this.color(224, 56, 45));
            this.startButton.setString("Stop");
        }

        public void shutDown() {
            this.hideElements();
            this.turnOffButton();
        }

        public void initializeStreams() {
            String dt1 = "None";
            String dt2 = "None";
            String dt3 = "None";
            this.networkActive = true;
            switch ((int)((ScrollableList)this.cp5_networking_dropdowns.get(ScrollableList.class, "dataType1")).getValue()) {
                case 0: {
                    dt1 = "None";
                    break;
                }
                case 1: {
                    dt1 = "TimeSeries";
                    break;
                }
                case 2: {
                    dt1 = "FFT";
                    break;
                }
                case 3: {
                    dt1 = "EMG";
                    break;
                }
                case 4: {
                    dt1 = "BandPower";
                    break;
                }
                case 5: {
                    dt1 = "Focus";
                    break;
                }
                case 6: {
                    dt1 = "Widget";
                }
            }
            switch ((int)((ScrollableList)this.cp5_networking_dropdowns.get(ScrollableList.class, "dataType2")).getValue()) {
                case 0: {
                    dt2 = "None";
                    break;
                }
                case 1: {
                    dt2 = "TimeSeries";
                    break;
                }
                case 2: {
                    dt2 = "FFT";
                    break;
                }
                case 3: {
                    dt2 = "EMG";
                    break;
                }
                case 4: {
                    dt2 = "BandPower";
                    break;
                }
                case 5: {
                    dt2 = "Focus";
                    break;
                }
                case 6: {
                    dt2 = "Widget";
                }
            }
            switch ((int)((ScrollableList)this.cp5_networking_dropdowns.get(ScrollableList.class, "dataType3")).getValue()) {
                case 0: {
                    dt3 = "None";
                    break;
                }
                case 1: {
                    dt3 = "TimeSeries";
                    break;
                }
                case 2: {
                    dt3 = "FFT";
                    break;
                }
                case 3: {
                    dt3 = "EMG";
                    break;
                }
                case 4: {
                    dt3 = "BandPower";
                    break;
                }
                case 5: {
                    dt3 = "Focus";
                    break;
                }
                case 6: {
                    dt3 = "Widget";
                }
            }
            if (this.protocolMode.equals("OSC")) {
                int filt_pos;
                String address;
                int port;
                String ip;
                if (!dt1.equals("None")) {
                    ip = ((Textfield)this.cp5_networking.get(Textfield.class, "osc_ip1")).getText();
                    port = Integer.parseInt(((Textfield)this.cp5_networking.get(Textfield.class, "osc_port1")).getText());
                    address = ((Textfield)this.cp5_networking.get(Textfield.class, "osc_address1")).getText();
                    filt_pos = (int)((RadioButton)this.cp5_networking.get(RadioButton.class, "filter1")).getValue();
                    this.stream1 = new Stream(dt1, ip, port, address, filt_pos, OpenBCI_GUI.this.nchan);
                } else {
                    this.stream1 = null;
                }
                if (!dt2.equals("None")) {
                    ip = ((Textfield)this.cp5_networking.get(Textfield.class, "osc_ip2")).getText();
                    port = Integer.parseInt(((Textfield)this.cp5_networking.get(Textfield.class, "osc_port2")).getText());
                    address = ((Textfield)this.cp5_networking.get(Textfield.class, "osc_address2")).getText();
                    filt_pos = (int)((RadioButton)this.cp5_networking.get(RadioButton.class, "filter2")).getValue();
                    this.stream2 = new Stream(dt2, ip, port, address, filt_pos, OpenBCI_GUI.this.nchan);
                } else {
                    this.stream2 = null;
                }
                if (!dt3.equals("None")) {
                    ip = ((Textfield)this.cp5_networking.get(Textfield.class, "osc_ip3")).getText();
                    port = Integer.parseInt(((Textfield)this.cp5_networking.get(Textfield.class, "osc_port3")).getText());
                    address = ((Textfield)this.cp5_networking.get(Textfield.class, "osc_address3")).getText();
                    filt_pos = (int)((RadioButton)this.cp5_networking.get(RadioButton.class, "filter3")).getValue();
                    this.stream3 = new Stream(dt3, ip, port, address, filt_pos, OpenBCI_GUI.this.nchan);
                } else {
                    this.stream3 = null;
                }
            } else if (this.protocolMode.equals("UDP")) {
                int filt_pos;
                int port;
                String ip;
                if (!dt1.equals("None")) {
                    ip = ((Textfield)this.cp5_networking.get(Textfield.class, "udp_ip1")).getText();
                    port = Integer.parseInt(((Textfield)this.cp5_networking.get(Textfield.class, "udp_port1")).getText());
                    filt_pos = (int)((RadioButton)this.cp5_networking.get(RadioButton.class, "filter1")).getValue();
                    this.stream1 = new Stream(dt1, ip, port, filt_pos, OpenBCI_GUI.this.nchan);
                } else {
                    this.stream1 = null;
                }
                if (!dt2.equals("None")) {
                    ip = ((Textfield)this.cp5_networking.get(Textfield.class, "udp_ip2")).getText();
                    port = Integer.parseInt(((Textfield)this.cp5_networking.get(Textfield.class, "udp_port2")).getText());
                    filt_pos = (int)((RadioButton)this.cp5_networking.get(RadioButton.class, "filter2")).getValue();
                    this.stream2 = new Stream(dt2, ip, port, filt_pos, OpenBCI_GUI.this.nchan);
                } else {
                    this.stream2 = null;
                }
                if (!dt3.equals("None")) {
                    ip = ((Textfield)this.cp5_networking.get(Textfield.class, "udp_ip3")).getText();
                    port = Integer.parseInt(((Textfield)this.cp5_networking.get(Textfield.class, "udp_port3")).getText());
                    filt_pos = (int)((RadioButton)this.cp5_networking.get(RadioButton.class, "filter3")).getValue();
                    this.stream3 = new Stream(dt3, ip, port, filt_pos, OpenBCI_GUI.this.nchan);
                } else {
                    this.stream3 = null;
                }
            } else if (this.protocolMode.equals("LSL")) {
                int filt_pos;
                int nChanLSL;
                String type;
                String name;
                if (!dt1.equals("None")) {
                    name = ((Textfield)this.cp5_networking.get(Textfield.class, "lsl_name1")).getText();
                    type = ((Textfield)this.cp5_networking.get(Textfield.class, "lsl_type1")).getText();
                    nChanLSL = Integer.parseInt(((Textfield)this.cp5_networking.get(Textfield.class, "lsl_numchan1")).getText());
                    filt_pos = (int)((RadioButton)this.cp5_networking.get(RadioButton.class, "filter1")).getValue();
                    this.stream1 = new Stream(dt1, name, type, nChanLSL, filt_pos, OpenBCI_GUI.this.nchan);
                } else {
                    this.stream1 = null;
                }
                if (!dt2.equals("None")) {
                    name = ((Textfield)this.cp5_networking.get(Textfield.class, "lsl_name2")).getText();
                    type = ((Textfield)this.cp5_networking.get(Textfield.class, "lsl_type2")).getText();
                    nChanLSL = Integer.parseInt(((Textfield)this.cp5_networking.get(Textfield.class, "lsl_numchan2")).getText());
                    filt_pos = (int)((RadioButton)this.cp5_networking.get(RadioButton.class, "filter2")).getValue();
                    this.stream2 = new Stream(dt2, name, type, nChanLSL, filt_pos, OpenBCI_GUI.this.nchan);
                } else {
                    this.stream2 = null;
                }
                if (!dt3.equals("None")) {
                    name = ((Textfield)this.cp5_networking.get(Textfield.class, "lsl_name3")).getText();
                    type = ((Textfield)this.cp5_networking.get(Textfield.class, "lsl_type3")).getText();
                    nChanLSL = Integer.parseInt(((Textfield)this.cp5_networking.get(Textfield.class, "lsl_numchan3")).getText());
                    filt_pos = (int)((RadioButton)this.cp5_networking.get(RadioButton.class, "filter3")).getValue();
                    this.stream3 = new Stream(dt3, name, type, nChanLSL, filt_pos, OpenBCI_GUI.this.nchan);
                } else {
                    this.stream3 = null;
                }
            } else if (this.protocolMode.equals("Serial")) {
                if (!dt1.equals("None")) {
                    OpenBCI_GUI.println((String)this.comPorts.get((int)((ScrollableList)this.cp5_networking_portName.get(ScrollableList.class, "port_name")).getValue()));
                    String name = this.comPorts.get((int)((ScrollableList)this.cp5_networking_portName.get(ScrollableList.class, "port_name")).getValue());
                    OpenBCI_GUI.println((int)Integer.parseInt(this.baudRates.get((int)((ScrollableList)this.cp5_networking_baudRate.get(ScrollableList.class, "baud_rate")).getValue())));
                    int baudRate = Integer.parseInt(this.baudRates.get((int)((ScrollableList)this.cp5_networking_baudRate.get(ScrollableList.class, "baud_rate")).getValue()));
                    int filt_pos = (int)((RadioButton)this.cp5_networking.get(RadioButton.class, "filter1")).getValue();
                    this.stream1 = new Stream(dt1, name, baudRate, filt_pos, this.pApplet, OpenBCI_GUI.this.nchan);
                } else {
                    this.stream1 = null;
                }
            }
        }

        public void startNetwork() {
            if (this.stream1 != null) {
                this.stream1.start();
            }
            if (this.stream2 != null) {
                this.stream2.start();
            }
            if (this.stream3 != null) {
                this.stream3.start();
            }
        }

        public void stopNetwork() {
            this.networkActive = false;
            if (this.stream1 != null) {
                this.stream1.quit();
                this.stream1 = null;
            }
            if (this.stream2 != null) {
                this.stream2.quit();
                this.stream2 = null;
            }
            if (this.stream3 != null) {
                this.stream3.quit();
                this.stream3 = null;
            }
        }

        public void clearCP5() {
            OpenBCI_GUI.this.w_networking.cp5_networking.dispose();
            OpenBCI_GUI.this.w_networking.cp5_networking_dropdowns.dispose();
            OpenBCI_GUI.println((String)"clearing cp5_networking...");
        }

        public void closeAllDropdowns() {
            this.dataDropdownsShouldBeClosed = true;
            ((ScrollableList)OpenBCI_GUI.this.w_networking.cp5_networking_dropdowns.get(ScrollableList.class, "dataType1")).close();
            ((ScrollableList)OpenBCI_GUI.this.w_networking.cp5_networking_dropdowns.get(ScrollableList.class, "dataType2")).close();
            ((ScrollableList)OpenBCI_GUI.this.w_networking.cp5_networking_dropdowns.get(ScrollableList.class, "dataType3")).close();
            ((ScrollableList)OpenBCI_GUI.this.w_networking.cp5_networking_baudRate.get(ScrollableList.class, "baud_rate")).close();
            ((ScrollableList)OpenBCI_GUI.this.w_networking.cp5_networking_portName.get(ScrollableList.class, "port_name")).close();
        }
    }

    class W_openBionics
    extends Widget {
        PApplet parent;
        Serial OpenBionicsHand;
        PFont f;
        PFont f2;
        int parentContainer;
        boolean thumbPressed;
        boolean indexPressed;
        boolean middlePressed;
        boolean ringPressed;
        boolean littlePressed;
        boolean palmPressed;
        boolean researchMode;
        PImage hand;
        PImage thumb;
        PImage index;
        PImage middle;
        PImage ring;
        PImage little;
        PImage palm;
        int last_command;
        Button configClose;
        Button configConfirm;
        Button connect;
        MenuList obChanList;
        ControlP5 configP5;
        String obName;
        String obBaud;
        List serialListOB;
        List baudListOB;
        int drawConfig;
        int[] fingerChans;
        boolean wasConnected;

        W_openBionics(PApplet _parent) {
            super(_parent);
            this.f = OpenBCI_GUI.this.createFont("Arial Bold", 24.0f);
            this.f2 = OpenBCI_GUI.this.createFont("Arial", 18.0f);
            this.parentContainer = 9;
            this.palmPressed = false;
            this.researchMode = false;
            this.configP5 = new ControlP5(_parent);
            this.wasConnected = false;
            this.parent = _parent;
            this.baudListOB = Arrays.asList("NONE", "230400", "115200", "57600", "38400", "28800", "19200", "14400", "9600", "7200", "4800", "3600", "2400", "1800", "1200", "600", "300");
            this.drawConfig = -1;
            this.fingerChans = new int[6];
            int i = 0;
            while (i < 6) {
                this.fingerChans[i] = -1;
                ++i;
            }
            this.hand = OpenBCI_GUI.this.loadImage("hand.png");
            this.thumb = OpenBCI_GUI.this.loadImage("thumb_over.png");
            this.index = OpenBCI_GUI.this.loadImage("index_over.png");
            this.middle = OpenBCI_GUI.this.loadImage("middle_over.png");
            this.ring = OpenBCI_GUI.this.loadImage("ring_over.png");
            this.little = OpenBCI_GUI.this.loadImage("little_over.png");
            this.palm = OpenBCI_GUI.this.loadImage("palm_over.png");
            String[] serialPortsLocal = Serial.list();
            this.serialListOB = new ArrayList();
            this.serialListOB.add("NONE");
            int i2 = 0;
            while (i2 < serialPortsLocal.length) {
                String tempPort = serialPortsLocal[serialPortsLocal.length - 1 - i2];
                if (!tempPort.equals(OpenBCI_GUI.this.openBCI_portName)) {
                    this.serialListOB.add(tempPort);
                }
                ++i2;
            }
            this.configClose = new Button(PApplet.parseInt((float)this.x) + this.w / 4, PApplet.parseInt((float)this.y) + 3 * OpenBCI_GUI.this.navHeight, PApplet.parseInt((float)((float)this.w / 25.3f)), PApplet.parseInt((float)((float)this.w / 25.3f)), "X", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
            this.configConfirm = new Button(PApplet.parseInt((float)this.x) + this.w / 2 + this.w / 7, PApplet.parseInt((float)this.y) + 12 * OpenBCI_GUI.this.navHeight, PApplet.parseInt((float)((float)this.w / 10.12f)), PApplet.parseInt((float)((float)this.w / 25.3f)), "OKAY", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
            this.connect = new Button(PApplet.parseInt((float)this.x) + this.w - this.w / 7, PApplet.parseInt((float)this.y) + 10 * OpenBCI_GUI.this.navHeight, PApplet.parseInt((float)(this.w / 8)), PApplet.parseInt((float)((float)this.w / 25.3f)), "CONNECT", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
            this.obChanList = new MenuList(this.configP5, "obChanList", 100, 120, this.f2);
            this.obChanList.setPosition(this.x + this.w / 3 + this.w / 12, this.y + this.h / 3 + this.h / 16);
            this.obChanList.addItem(OpenBCI_GUI.this.makeItem("NONE"));
            this.obChanList.activeItem = 0;
            i2 = 0;
            while (i2 < OpenBCI_GUI.this.nchan) {
                this.obChanList.addItem(OpenBCI_GUI.this.makeItem("" + (i2 + 1)));
                ++i2;
            }
            this.addDropdown("OpenBionicsSerialOut", "Serial Output", this.serialListOB, 0);
            this.addDropdown("BaudList", "Baud List", this.baudListOB, 0);
            ((MenuList)((Object)this.configP5.get(MenuList.class, "obChanList"))).setVisible(false);
        }

        public void process() {
            StringBuilder researchCommand = new StringBuilder();
            if (this.OpenBionicsHand != null) {
                if (!this.researchMode) {
                    this.OpenBionicsHand.write("A10\n");
                    this.researchMode = true;
                }
                byte inByte = PApplet.parseByte((int)this.OpenBionicsHand.read());
                OpenBCI_GUI.println((byte)inByte);
            }
            if (this.fingerChans[5] == -1) {
                if (this.OpenBionicsHand != null) {
                    int i = 0;
                    while (i < 5) {
                        int output_normalized = this.fingerChans[i] == -1 ? 0 : PApplet.parseInt((float)OpenBCI_GUI.map((float)OpenBCI_GUI.this.w_emg.motorWidgets[this.fingerChans[i]].output_normalized, (float)0.0f, (float)1.0f, (float)0.0f, (float)1023.0f));
                        if (i == 4) {
                            researchCommand.append(String.valueOf(output_normalized) + "\n");
                        } else {
                            researchCommand.append(String.valueOf(output_normalized) + ",");
                        }
                        ++i;
                    }
                    this.OpenBionicsHand.write(researchCommand.toString());
                }
            } else if (this.OpenBionicsHand != null) {
                int output_normalized = PApplet.parseInt((float)OpenBCI_GUI.map((float)OpenBCI_GUI.this.w_emg.motorWidgets[this.fingerChans[5]].output_normalized, (float)0.0f, (float)1.0f, (float)0.0f, (float)100.0f));
                this.OpenBionicsHand.write("G0P" + output_normalized + "\n");
            }
        }

        @Override
        public void update() {
            super.update();
            this.process();
        }

        @Override
        public void draw() {
            super.draw();
            OpenBCI_GUI.this.pushStyle();
            OpenBCI_GUI.this.noStroke();
            OpenBCI_GUI.this.fill(255);
            OpenBCI_GUI.this.rect(this.x, this.y, this.w, this.h);
            this.obChanList.setPosition(this.x + this.w / 3 + this.w / 12, this.y + this.h / 3 + this.h / 16);
            switch (this.drawConfig) {
                case -1: {
                    OpenBCI_GUI.this.image(this.hand, this.x + this.w / 4, this.y + 2 * OpenBCI_GUI.this.navHeight + 2, this.w / 2, this.h / 2 + this.h / 3);
                    if (this.overThumb()) {
                        OpenBCI_GUI.this.image(this.thumb, this.x + this.w / 4, this.y + 2 * OpenBCI_GUI.this.navHeight + 2, this.w / 2, this.h / 2 + this.h / 3);
                    } else if (this.overIndex()) {
                        OpenBCI_GUI.this.image(this.index, this.x + this.w / 4, this.y + 2 * OpenBCI_GUI.this.navHeight + 2, this.w / 2, this.h / 2 + this.h / 3);
                    } else if (this.overMiddle()) {
                        OpenBCI_GUI.this.image(this.middle, this.x + this.w / 4, this.y + 2 * OpenBCI_GUI.this.navHeight + 2, this.w / 2, this.h / 2 + this.h / 3);
                    } else if (this.overRing()) {
                        OpenBCI_GUI.this.image(this.ring, this.x + this.w / 4, this.y + 2 * OpenBCI_GUI.this.navHeight + 2, this.w / 2, this.h / 2 + this.h / 3);
                    } else if (this.overLittle()) {
                        OpenBCI_GUI.this.image(this.little, this.x + this.w / 4, this.y + 2 * OpenBCI_GUI.this.navHeight + 2, this.w / 2, this.h / 2 + this.h / 3);
                    } else if (this.overPalm()) {
                        OpenBCI_GUI.this.image(this.palm, this.x + this.w / 4, this.y + 2 * OpenBCI_GUI.this.navHeight + 2, this.w / 2, this.h / 2 + this.h / 3);
                    }
                    ((MenuList)((Object)this.configP5.get(MenuList.class, "obChanList"))).setVisible(false);
                    ((MenuList)((Object)this.configP5.get(MenuList.class, (String)"obChanList"))).activeItem = 0;
                    if (this.wasConnected) {
                        OpenBCI_GUI.this.fill(0.0f, 250.0f, 0.0f);
                        OpenBCI_GUI.this.ellipse(this.x + 5 * (this.w / 6), this.y + 7 * (this.h / 10), 20.0f, 20.0f);
                    } else {
                        OpenBCI_GUI.this.fill(250.0f, 0.0f, 0.0f);
                        OpenBCI_GUI.this.ellipse(this.x + 5 * (this.w / 6), this.y + 7 * (this.h / 10), 20.0f, 20.0f);
                    }
                    this.connect.draw();
                    break;
                }
                case 0: {
                    ((MenuList)((Object)this.configP5.get(MenuList.class, (String)"obChanList"))).activeItem = this.fingerChans[this.drawConfig] + 1;
                    ((MenuList)((Object)this.configP5.get(MenuList.class, "obChanList"))).setVisible(true);
                    OpenBCI_GUI.this.fill(180.0f, 180.0f, 180.0f);
                    OpenBCI_GUI.this.rect(PApplet.parseInt((float)this.x) + this.w / 4, PApplet.parseInt((float)this.y) + 3 * OpenBCI_GUI.this.navHeight, this.w / 2, this.h / 2 + 2 * OpenBCI_GUI.this.navHeight + OpenBCI_GUI.this.navHeight / 2);
                    this.configClose.draw();
                    this.configConfirm.draw();
                    OpenBCI_GUI.this.fill(10.0f, 10.0f, 10.0f);
                    OpenBCI_GUI.this.textFont(this.f);
                    OpenBCI_GUI.this.textSize(12.0f);
                    OpenBCI_GUI.this.text("Thumb Channel Selection", this.x + this.w / 3, this.y + 4 * OpenBCI_GUI.this.navHeight);
                    break;
                }
                case 1: {
                    ((MenuList)((Object)this.configP5.get(MenuList.class, (String)"obChanList"))).activeItem = this.fingerChans[this.drawConfig] + 1;
                    ((MenuList)((Object)this.configP5.get(MenuList.class, "obChanList"))).setVisible(true);
                    OpenBCI_GUI.this.fill(180.0f, 180.0f, 180.0f);
                    OpenBCI_GUI.this.rect(PApplet.parseInt((float)this.x) + this.w / 4, PApplet.parseInt((float)this.y) + 3 * OpenBCI_GUI.this.navHeight, this.w / 2, this.h / 2 + 2 * OpenBCI_GUI.this.navHeight + OpenBCI_GUI.this.navHeight / 2);
                    this.configClose.draw();
                    this.configConfirm.draw();
                    OpenBCI_GUI.this.fill(10.0f, 10.0f, 10.0f);
                    OpenBCI_GUI.this.textFont(this.f);
                    OpenBCI_GUI.this.textSize(12.0f);
                    OpenBCI_GUI.this.text("Index Finger Channel Selection", this.x + this.w / 3, this.y + 4 * OpenBCI_GUI.this.navHeight);
                    break;
                }
                case 2: {
                    ((MenuList)((Object)this.configP5.get(MenuList.class, (String)"obChanList"))).activeItem = this.fingerChans[this.drawConfig] + 1;
                    ((MenuList)((Object)this.configP5.get(MenuList.class, "obChanList"))).setVisible(true);
                    OpenBCI_GUI.this.fill(180.0f, 180.0f, 180.0f);
                    OpenBCI_GUI.this.rect(PApplet.parseInt((float)this.x) + this.w / 4, PApplet.parseInt((float)this.y) + 3 * OpenBCI_GUI.this.navHeight, this.w / 2, this.h / 2 + 2 * OpenBCI_GUI.this.navHeight + OpenBCI_GUI.this.navHeight / 2);
                    this.configClose.draw();
                    this.configConfirm.draw();
                    OpenBCI_GUI.this.fill(10.0f, 10.0f, 10.0f);
                    OpenBCI_GUI.this.textFont(this.f);
                    OpenBCI_GUI.this.textSize(12.0f);
                    OpenBCI_GUI.this.text("Middle Finger Channel Selection", this.x + this.w / 3, this.y + 4 * OpenBCI_GUI.this.navHeight);
                    break;
                }
                case 3: {
                    ((MenuList)((Object)this.configP5.get(MenuList.class, (String)"obChanList"))).activeItem = this.fingerChans[this.drawConfig] + 1;
                    ((MenuList)((Object)this.configP5.get(MenuList.class, "obChanList"))).setVisible(true);
                    OpenBCI_GUI.this.fill(180.0f, 180.0f, 180.0f);
                    OpenBCI_GUI.this.rect(PApplet.parseInt((float)this.x) + this.w / 4, PApplet.parseInt((float)this.y) + 3 * OpenBCI_GUI.this.navHeight, this.w / 2, this.h / 2 + 2 * OpenBCI_GUI.this.navHeight + OpenBCI_GUI.this.navHeight / 2);
                    this.configClose.draw();
                    this.configConfirm.draw();
                    OpenBCI_GUI.this.fill(10.0f, 10.0f, 10.0f);
                    OpenBCI_GUI.this.textFont(this.f);
                    OpenBCI_GUI.this.textSize(12.0f);
                    OpenBCI_GUI.this.text("Ring Finger Channel Selection", this.x + this.w / 3, this.y + 4 * OpenBCI_GUI.this.navHeight);
                    break;
                }
                case 4: {
                    ((MenuList)((Object)this.configP5.get(MenuList.class, (String)"obChanList"))).activeItem = this.fingerChans[this.drawConfig] + 1;
                    ((MenuList)((Object)this.configP5.get(MenuList.class, "obChanList"))).setVisible(true);
                    OpenBCI_GUI.this.fill(180.0f, 180.0f, 180.0f);
                    OpenBCI_GUI.this.rect(PApplet.parseInt((float)this.x) + this.w / 4, PApplet.parseInt((float)this.y) + 3 * OpenBCI_GUI.this.navHeight, this.w / 2, this.h / 2 + 2 * OpenBCI_GUI.this.navHeight + OpenBCI_GUI.this.navHeight / 2);
                    this.configClose.draw();
                    this.configConfirm.draw();
                    OpenBCI_GUI.this.fill(10.0f, 10.0f, 10.0f);
                    OpenBCI_GUI.this.textFont(this.f);
                    OpenBCI_GUI.this.textSize(12.0f);
                    OpenBCI_GUI.this.text("Little Finger Channel Selection", this.x + this.w / 3, this.y + 4 * OpenBCI_GUI.this.navHeight);
                    break;
                }
                case 5: {
                    ((MenuList)((Object)this.configP5.get(MenuList.class, (String)"obChanList"))).activeItem = this.fingerChans[this.drawConfig] + 1;
                    ((MenuList)((Object)this.configP5.get(MenuList.class, "obChanList"))).setVisible(true);
                    OpenBCI_GUI.this.fill(180.0f, 180.0f, 180.0f);
                    OpenBCI_GUI.this.rect(PApplet.parseInt((float)this.x) + this.w / 4, PApplet.parseInt((float)this.y) + 3 * OpenBCI_GUI.this.navHeight, this.w / 2, this.h / 2 + 2 * OpenBCI_GUI.this.navHeight + OpenBCI_GUI.this.navHeight / 2);
                    this.configClose.draw();
                    this.configConfirm.draw();
                    OpenBCI_GUI.this.fill(10.0f, 10.0f, 10.0f);
                    OpenBCI_GUI.this.textFont(this.f);
                    OpenBCI_GUI.this.textSize(12.0f);
                    OpenBCI_GUI.this.text("Hand Channel Selection", this.x + this.w / 3, this.y + 4 * OpenBCI_GUI.this.navHeight);
                }
            }
            this.configP5.draw();
            OpenBCI_GUI.this.popStyle();
        }

        @Override
        public void screenResized() {
            super.screenResized();
            this.configClose = new Button(PApplet.parseInt((float)this.x) + this.w / 4, PApplet.parseInt((float)this.y) + 3 * OpenBCI_GUI.this.navHeight, PApplet.parseInt((float)((float)this.w / 25.3f)), PApplet.parseInt((float)((float)this.w / 25.3f)), "X", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
            this.configConfirm = new Button(PApplet.parseInt((float)this.x) + this.w / 2 + this.w / 7, PApplet.parseInt((float)this.y) + 12 * OpenBCI_GUI.this.navHeight, PApplet.parseInt((float)((float)this.w / 10.12f)), PApplet.parseInt((float)((float)this.w / 25.3f)), "OKAY", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
            this.configP5.setGraphics(this.parent, 0, 0);
            int dropdownWidth = 60;
            int dropdownPos = 1;
            this.configP5.getController("OpenBionicsSerialOut").setPosition((float)(this.x + this.w - dropdownWidth * (dropdownPos + 1) - 2 * (dropdownPos + 1)), (float)(OpenBCI_GUI.this.navHeight + (this.y + 2)));
            dropdownPos = 0;
            try {
                this.configP5.getController("LogLin").setPosition((float)(this.x + this.w - dropdownWidth * (dropdownPos + 1) - 2 * (dropdownPos + 1)), (float)(OpenBCI_GUI.this.navHeight + (this.y + 2)));
            }
            catch (Exception exception) {
                OpenBCI_GUI.println((String)"error resizing...");
            }
        }

        @Override
        public void mousePressed() {
            super.mousePressed();
            if (this.drawConfig == -1) {
                if (this.overThumb()) {
                    this.thumbPressed = true;
                } else if (this.overIndex()) {
                    this.indexPressed = true;
                } else if (this.overMiddle()) {
                    this.middlePressed = true;
                } else if (this.overRing()) {
                    this.ringPressed = true;
                } else if (this.overLittle()) {
                    this.littlePressed = true;
                } else if (this.overPalm()) {
                    this.palmPressed = true;
                } else if (this.connect.isMouseHere()) {
                    this.connect.wasPressed = true;
                }
            } else if (this.configClose.isMouseHere()) {
                this.configClose.wasPressed = true;
            } else if (this.configConfirm.isMouseHere()) {
                this.configConfirm.wasPressed = true;
            }
        }

        @Override
        public void mouseReleased() {
            super.mouseReleased();
            if (this.drawConfig == -1) {
                if (this.overThumb() && this.thumbPressed) {
                    this.drawConfig = 0;
                } else if (this.overIndex() && this.indexPressed) {
                    this.drawConfig = 1;
                } else if (this.overMiddle() && this.middlePressed) {
                    this.drawConfig = 2;
                } else if (this.overRing() && this.ringPressed) {
                    this.drawConfig = 3;
                } else if (this.overLittle() && this.littlePressed) {
                    this.drawConfig = 4;
                } else if (this.overPalm() && this.palmPressed) {
                    this.drawConfig = 5;
                } else if (this.connect.isMouseHere() && this.connect.wasPressed) {
                    try {
                        this.OpenBionicsHand = new Serial(this.parent, this.obName, Integer.parseInt(this.obBaud));
                        OpenBCI_GUI.this.verbosePrint("Connected to OpenBionics Hand");
                        this.wasConnected = true;
                    }
                    catch (Exception e) {
                        this.wasConnected = false;
                        OpenBCI_GUI.println((Object)e);
                        OpenBCI_GUI.this.verbosePrint("Could not connect to OpenBionics Hand");
                    }
                }
                this.thumbPressed = false;
                this.indexPressed = false;
                this.middlePressed = false;
                this.ringPressed = false;
                this.littlePressed = false;
                this.palmPressed = false;
                OpenBCI_GUI.this.cursor(0);
            } else if (this.configClose.isMouseHere() && this.configClose.wasPressed) {
                this.configClose.wasPressed = false;
                this.drawConfig = -1;
            } else if (this.configConfirm.isMouseHere() && this.configConfirm.wasPressed) {
                this.configConfirm.wasPressed = false;
                this.drawConfig = -1;
            }
        }

        public boolean overThumb() {
            if ((float)OpenBCI_GUI.this.mouseX >= (float)this.x + (float)this.w / 3.9f && (float)OpenBCI_GUI.this.mouseX <= (float)this.x + (float)this.w / 2.5f && (float)OpenBCI_GUI.this.mouseY >= (float)this.y + (float)this.h / 1.8f && (float)OpenBCI_GUI.this.mouseY <= (float)this.y + (float)this.h / 1.32f) {
                OpenBCI_GUI.this.cursor(12);
                return true;
            }
            OpenBCI_GUI.this.cursor(0);
            return false;
        }

        public boolean overIndex() {
            if ((float)OpenBCI_GUI.this.mouseX >= (float)this.x + (float)this.w / 2.65f && (float)OpenBCI_GUI.this.mouseX <= (float)this.x + (float)this.w / 2.07f && (float)OpenBCI_GUI.this.mouseY >= (float)this.y + (float)this.h / 4.89f && (float)OpenBCI_GUI.this.mouseY <= (float)this.y + (float)this.h / 1.99f) {
                OpenBCI_GUI.this.cursor(12);
                return true;
            }
            OpenBCI_GUI.this.cursor(0);
            return false;
        }

        public boolean overMiddle() {
            if ((float)OpenBCI_GUI.this.mouseX >= (float)this.x + (float)this.w / 2.01f && (float)OpenBCI_GUI.this.mouseX <= (float)this.x + (float)this.w / 1.79f && (float)OpenBCI_GUI.this.mouseY >= (float)this.y + (float)this.h / 7.08f && (float)OpenBCI_GUI.this.mouseY <= (float)this.y + (float)this.h / 2.14f) {
                OpenBCI_GUI.this.cursor(12);
                return true;
            }
            OpenBCI_GUI.this.cursor(0);
            return false;
        }

        public boolean overRing() {
            if ((float)OpenBCI_GUI.this.mouseX >= (float)this.x + (float)this.w / 1.73f && (float)OpenBCI_GUI.this.mouseX <= (float)this.x + (float)this.w / 1.5f && (float)OpenBCI_GUI.this.mouseY >= (float)this.y + (float)this.h / 5.59f && (float)OpenBCI_GUI.this.mouseY <= (float)this.y + (float)this.h / 1.95f) {
                OpenBCI_GUI.this.cursor(12);
                return true;
            }
            OpenBCI_GUI.this.cursor(0);
            return false;
        }

        public boolean overLittle() {
            if ((float)OpenBCI_GUI.this.mouseX >= (float)this.x + (float)this.w / 1.54f && (float)OpenBCI_GUI.this.mouseX <= (float)this.x + (float)this.w / 1.34f && (float)OpenBCI_GUI.this.mouseY >= (float)this.y + (float)this.h / 3.13f && (float)OpenBCI_GUI.this.mouseY <= (float)this.y + (float)this.h / 1.78f) {
                OpenBCI_GUI.this.cursor(12);
                return true;
            }
            OpenBCI_GUI.this.cursor(0);
            return false;
        }

        public boolean overPalm() {
            if ((float)OpenBCI_GUI.this.mouseX >= (float)this.x + (float)this.w / 2.47f && (float)OpenBCI_GUI.this.mouseX <= (float)this.x + (float)this.w / 1.48f && (float)OpenBCI_GUI.this.mouseY >= (float)this.y + (float)this.h / 1.89f && (float)OpenBCI_GUI.this.mouseY <= (float)this.y + (float)this.h / 1.05f) {
                OpenBCI_GUI.this.cursor(12);
                return true;
            }
            OpenBCI_GUI.this.cursor(0);
            return false;
        }

        public void customFunction() {
        }
    }

    class W_template
    extends Widget {
        Button widgetTemplateButton;

        W_template(PApplet _parent) {
            super(_parent);
            this.addDropdown("Dropdown1", "Drop 1", Arrays.asList("A", "B"), 0);
            this.addDropdown("Dropdown2", "Drop 2", Arrays.asList("C", "D", "E"), 1);
            this.addDropdown("Dropdown3", "Drop 3", Arrays.asList("F", "G", "H", "I"), 3);
            this.widgetTemplateButton = new Button(this.x + this.w / 2, this.y + this.h / 2, 200, OpenBCI_GUI.this.navHeight, "Design Your Own Widget!", 12);
            this.widgetTemplateButton.setFont(OpenBCI_GUI.this.p4, 14);
            this.widgetTemplateButton.setURL("http://docs.openbci.com/Tutorials/15-Custom_Widgets");
        }

        @Override
        public void update() {
            super.update();
        }

        @Override
        public void draw() {
            super.draw();
            OpenBCI_GUI.this.pushStyle();
            this.widgetTemplateButton.draw();
            OpenBCI_GUI.this.popStyle();
        }

        @Override
        public void screenResized() {
            super.screenResized();
            this.widgetTemplateButton.setPos(this.x + this.w / 2 - this.widgetTemplateButton.but_dx / 2, this.y + this.h / 2 - this.widgetTemplateButton.but_dy / 2);
        }

        @Override
        public void mousePressed() {
            super.mousePressed();
            if (this.widgetTemplateButton.isMouseHere()) {
                this.widgetTemplateButton.setIsActive(true);
            }
        }

        @Override
        public void mouseReleased() {
            super.mouseReleased();
            if (this.widgetTemplateButton.isActive && this.widgetTemplateButton.isMouseHere()) {
                this.widgetTemplateButton.goToURL();
            }
            this.widgetTemplateButton.setIsActive(false);
        }

        public void customFunction() {
        }
    }

    class W_timeSeries
    extends Widget {
        int numChannelBars;
        float xF;
        float yF;
        float wF;
        float hF;
        float ts_padding;
        float ts_x;
        float ts_y;
        float ts_h;
        float ts_w;
        float plotBottomWell;
        float playbackWidgetHeight;
        int channelBarHeight;
        boolean showHardwareSettings;
        Button hardwareSettingsButton;
        ChannelBar[] channelBars;
        int[] xLimOptions;
        int[] yLimOptions;
        int xLim;
        int xMax;
        boolean allowSpillover;
        HardwareSettingsController hsc;
        TextBox[] chanValuesMontage;
        TextBox[] impValuesMontage;
        boolean showMontageValues;
        private boolean visible;
        private boolean updating;
        int startingVertScaleIndex;
        private boolean hasScrollbar;

        W_timeSeries(PApplet _parent) {
            super(_parent);
            this.showHardwareSettings = false;
            this.xLimOptions = new int[]{1, 3, 5, 7};
            int[] nArray = new int[7];
            nArray[1] = 50;
            nArray[2] = 100;
            nArray[3] = 200;
            nArray[4] = 400;
            nArray[5] = 1000;
            nArray[6] = 10000;
            this.yLimOptions = nArray;
            this.xLim = this.xLimOptions[1];
            this.xMax = this.xLimOptions[0];
            this.allowSpillover = false;
            this.visible = true;
            this.updating = true;
            this.startingVertScaleIndex = 3;
            this.hasScrollbar = false;
            this.addDropdown("VertScale_TS", "Vert Scale", Arrays.asList("Auto", "50 uV", "100 uV", "200 uV", "400 uV", "1000 uV", "10000 uV"), this.startingVertScaleIndex);
            this.addDropdown("Duration", "Window", Arrays.asList("1 sec", "3 sec", "5 sec", "7 sec"), 2);
            this.numChannelBars = OpenBCI_GUI.this.nchan;
            this.xF = PApplet.parseFloat((int)this.x);
            this.yF = PApplet.parseFloat((int)this.y);
            this.wF = PApplet.parseFloat((int)this.w);
            this.hF = PApplet.parseFloat((int)this.h);
            this.playbackWidgetHeight = OpenBCI_GUI.this.eegDataSource == 2 && this.hasScrollbar ? 50.0f : 0.0f;
            this.plotBottomWell = 45.0f;
            this.ts_padding = 10.0f;
            this.ts_x = this.xF + this.ts_padding;
            this.ts_y = this.yF + this.ts_padding;
            this.ts_w = this.wF - this.ts_padding * 2.0f;
            this.ts_h = this.hF - this.playbackWidgetHeight - this.plotBottomWell - this.ts_padding * 2.0f;
            this.channelBarHeight = PApplet.parseInt((float)(this.ts_h / (float)this.numChannelBars));
            this.channelBars = new ChannelBar[this.numChannelBars];
            int i = 0;
            while (i < this.numChannelBars) {
                ChannelBar tempBar;
                int channelBarY = PApplet.parseInt((float)this.ts_y) + i * this.channelBarHeight;
                this.channelBars[i] = tempBar = new ChannelBar(_parent, i + 1, PApplet.parseInt((float)this.ts_x), channelBarY, PApplet.parseInt((float)this.ts_w), this.channelBarHeight);
                ++i;
            }
            if (OpenBCI_GUI.this.eegDataSource == 0) {
                this.hardwareSettingsButton = new Button(this.x + 3, this.y + OpenBCI_GUI.this.navHeight + 3, 120, OpenBCI_GUI.this.navHeight - 6, "Hardware Settings", 12);
                this.hardwareSettingsButton.setCornerRoundess(OpenBCI_GUI.this.navHeight - 6);
                this.hardwareSettingsButton.setFont(OpenBCI_GUI.this.p6, 10);
                this.hardwareSettingsButton.setColorNotPressed(OpenBCI_GUI.this.color(57, 128, 204));
                this.hardwareSettingsButton.textColorNotActive = OpenBCI_GUI.this.color(255);
                this.hardwareSettingsButton.hasStroke(false);
                this.hardwareSettingsButton.setHelpText("The buttons in this panel allow you to adjust the hardware settings of the OpenBCI Board.");
            }
            PApplet.parseInt((float)this.ts_x);
            PApplet.parseInt((float)this.ts_y);
            PApplet.parseInt((float)this.ts_w);
            int h_hsc = PApplet.parseInt((float)this.ts_h);
            this.hsc = new HardwareSettingsController((int)this.channelBars[0].plot.getPos()[0] + 2, (int)this.channelBars[0].plot.getPos()[1], (int)this.channelBars[0].plot.getOuterDim()[0], h_hsc - 4, this.channelBarHeight);
        }

        public boolean isVisible() {
            return this.visible;
        }

        public boolean isUpdating() {
            return this.updating;
        }

        public void setVisible(boolean _visible) {
            this.visible = _visible;
        }

        public void setUpdating(boolean _updating) {
            this.updating = _updating;
        }

        @Override
        public void update() {
            if (this.visible && this.updating) {
                super.update();
                this.hsc.update();
                int i = 0;
                while (i < this.numChannelBars) {
                    this.channelBars[i].update();
                    ++i;
                }
            }
        }

        @Override
        public void draw() {
            if (this.visible) {
                super.draw();
                OpenBCI_GUI.this.pushStyle();
                int i = 0;
                while (i < this.numChannelBars) {
                    this.channelBars[i].draw();
                    ++i;
                }
                if (OpenBCI_GUI.this.eegDataSource == 0) {
                    this.hardwareSettingsButton.draw();
                }
                if (OpenBCI_GUI.this.eegDataSource == 2 && this.hasScrollbar) {
                    OpenBCI_GUI.this.pushStyle();
                    OpenBCI_GUI.this.fill(0.0f, 0.0f, 0.0f, 20.0f);
                    OpenBCI_GUI.this.stroke(31.0f, 69.0f, 110.0f);
                    OpenBCI_GUI.this.rect(this.xF, this.ts_y + this.ts_h + this.playbackWidgetHeight + 5.0f, this.wF, this.playbackWidgetHeight);
                    OpenBCI_GUI.this.popStyle();
                }
                this.hsc.draw();
                OpenBCI_GUI.this.popStyle();
            }
        }

        @Override
        public void screenResized() {
            super.screenResized();
            this.xF = PApplet.parseFloat((int)this.x);
            this.yF = PApplet.parseFloat((int)this.y);
            this.wF = PApplet.parseFloat((int)this.w);
            this.hF = PApplet.parseFloat((int)this.h);
            this.ts_x = this.xF + this.ts_padding;
            this.ts_y = this.yF + this.ts_padding;
            this.ts_w = this.wF - this.ts_padding * 2.0f;
            this.ts_h = this.hF - this.playbackWidgetHeight - this.plotBottomWell - this.ts_padding * 2.0f;
            this.channelBarHeight = PApplet.parseInt((float)(this.ts_h / (float)this.numChannelBars));
            int i = 0;
            while (i < this.numChannelBars) {
                int channelBarY = PApplet.parseInt((float)this.ts_y) + i * this.channelBarHeight;
                this.channelBars[i].screenResized(PApplet.parseInt((float)this.ts_x), channelBarY, PApplet.parseInt((float)this.ts_w), this.channelBarHeight);
                ++i;
            }
            this.hsc.screenResized((int)this.channelBars[0].plot.getPos()[0] + 2, (int)this.channelBars[0].plot.getPos()[1], (int)this.channelBars[0].plot.getOuterDim()[0], (int)this.ts_h - 4, this.channelBarHeight);
            if (OpenBCI_GUI.this.eegDataSource == 0) {
                this.hardwareSettingsButton.setPos(this.x0 + 3, this.y0 + OpenBCI_GUI.this.navHeight + 3);
            }
        }

        @Override
        public void mousePressed() {
            super.mousePressed();
            if (OpenBCI_GUI.this.eegDataSource == 0 && this.hardwareSettingsButton.isMouseHere()) {
                this.hardwareSettingsButton.setIsActive(true);
            }
            if (this.hsc.isVisible) {
                this.hsc.mousePressed();
            } else {
                int i = 0;
                while (i < this.channelBars.length) {
                    this.channelBars[i].mousePressed();
                    ++i;
                }
            }
        }

        @Override
        public void mouseReleased() {
            super.mouseReleased();
            if (OpenBCI_GUI.this.eegDataSource == 0) {
                if (this.hardwareSettingsButton.isActive && this.hardwareSettingsButton.isMouseHere()) {
                    OpenBCI_GUI.println((String)"toggle...");
                    if (this.showHardwareSettings) {
                        this.showHardwareSettings = false;
                        this.hsc.isVisible = false;
                        this.hardwareSettingsButton.setString("Hardware Settings");
                    } else {
                        this.showHardwareSettings = true;
                        this.hsc.isVisible = true;
                        this.hardwareSettingsButton.setString("Time Series");
                    }
                }
                this.hardwareSettingsButton.setIsActive(false);
            }
            if (this.hsc.isVisible) {
                this.hsc.mouseReleased();
            } else {
                int i = 0;
                while (i < this.channelBars.length) {
                    this.channelBars[i].mouseReleased();
                    ++i;
                }
            }
        }
    }

    class Widget {
        PApplet pApplet;
        int x0;
        int y0;
        int w0;
        int h0;
        int x;
        int y;
        int w;
        int h;
        int currentContainer;
        boolean isActive = false;
        boolean dropdownsShouldBeClosed = false;
        ArrayList<NavBarDropdown> dropdowns;
        ControlP5 cp5_widget;
        String widgetTitle = "No Title Set";
        Button widgetSelector;
        int navH = 22;
        int widgetSelectorWidth = 160;
        int dropdownWidth = 64;
        CColor dropdownColors = new CColor();

        Widget(PApplet _parent) {
            this.pApplet = _parent;
            this.cp5_widget = new ControlP5(this.pApplet);
            this.dropdowns = new ArrayList();
            this.currentContainer = 5;
            this.mapToCurrentContainer();
        }

        public void update() {
            this.updateDropdowns();
        }

        public void draw() {
            OpenBCI_GUI.this.pushStyle();
            OpenBCI_GUI.this.fill(255);
            OpenBCI_GUI.this.rect(this.x, this.y - 1, this.w, this.h + 1);
            OpenBCI_GUI.this.fill(150.0f, 150.0f, 150.0f);
            OpenBCI_GUI.this.rect(this.x0, this.y0, this.w0, this.navH);
            OpenBCI_GUI.this.fill(200.0f, 200.0f, 200.0f);
            OpenBCI_GUI.this.rect(this.x0, this.y0 + this.navH, this.w0, this.navH);
            OpenBCI_GUI.this.popStyle();
        }

        public void addDropdown(String _id, String _title, List _items, int _defaultItem) {
            NavBarDropdown dropdownToAdd = new NavBarDropdown(_id, _title, _items, _defaultItem);
            this.dropdowns.add(dropdownToAdd);
        }

        public void setupWidgetSelectorDropdown(ArrayList<String> _widgetOptions) {
            this.cp5_widget.setAutoDraw(false);
            this.dropdownColors.setActive(OpenBCI_GUI.this.color(150, 170, 200));
            this.dropdownColors.setForeground(OpenBCI_GUI.this.color(125));
            this.dropdownColors.setBackground(OpenBCI_GUI.this.color(255));
            this.dropdownColors.setCaptionLabel(OpenBCI_GUI.this.color(1, 18, 41));
            this.dropdownColors.setValueLabel(OpenBCI_GUI.this.color(100));
            OpenBCI_GUI.print((String)"wm.widgetOptions.size() = ");
            OpenBCI_GUI.println((int)_widgetOptions.size());
            this.cp5_widget.setColor(this.dropdownColors);
            ((ScrollableList)((ScrollableList)((ScrollableList)this.cp5_widget.addScrollableList("WidgetSelector").setPosition((float)(this.x0 + 2), (float)(this.y0 + 2))).setOpen(false).setColor(this.dropdownColors)).setSize(this.widgetSelectorWidth, (_widgetOptions.size() + 1) * (this.navH - 4))).setBarHeight(this.navH - 4).setItemHeight(this.navH - 4).addItems(_widgetOptions);
            this.cp5_widget.getController("WidgetSelector").getCaptionLabel().toUpperCase(false).setText(this.widgetTitle).setFont(OpenBCI_GUI.this.h4).setSize(14).getStyle().setPaddingTop(4);
            this.cp5_widget.getController("WidgetSelector").getValueLabel().toUpperCase(false).setText(this.widgetTitle).setFont(OpenBCI_GUI.this.h5).setSize(12).getStyle().setPaddingTop(3);
        }

        public void setupNavDropdowns() {
            this.cp5_widget.setAutoDraw(false);
            this.dropdownColors.setActive(OpenBCI_GUI.this.color(150, 170, 200));
            this.dropdownColors.setForeground(OpenBCI_GUI.this.color(177, 184, 193));
            this.dropdownColors.setBackground(OpenBCI_GUI.this.color(255));
            this.dropdownColors.setCaptionLabel(OpenBCI_GUI.this.color(1, 18, 41));
            this.dropdownColors.setValueLabel(OpenBCI_GUI.this.color(100));
            this.cp5_widget.setColor(this.dropdownColors);
            int i = 0;
            while (i < this.dropdowns.size()) {
                int dropdownPos = this.dropdowns.size() - i;
                ((ScrollableList)((ScrollableList)((ScrollableList)((ScrollableList)this.cp5_widget.addScrollableList(this.dropdowns.get((int)i).id).setPosition((float)(this.x0 + this.w0 - this.dropdownWidth * dropdownPos - 2 * dropdownPos), (float)(this.y0 + this.navH + 2))).setFont(OpenBCI_GUI.this.h5)).setOpen(false).setColor(this.dropdownColors)).setSize(this.dropdownWidth, (this.dropdowns.get((int)i).items.size() + 1) * (this.navH - 4))).setBarHeight(this.navH - 4).setItemHeight(this.navH - 4).addItems(this.dropdowns.get((int)i).items);
                this.cp5_widget.getController(this.dropdowns.get((int)i).id).getCaptionLabel().toUpperCase(false).setText(this.dropdowns.get(i).returnDefaultAsString()).setSize(12).getStyle().setPaddingTop(4);
                this.cp5_widget.getController(this.dropdowns.get((int)i).id).getValueLabel().toUpperCase(false).setText(this.widgetTitle).setSize(12).getStyle().setPaddingTop(3);
                ++i;
            }
        }

        public void updateDropdowns() {
            if (((ScrollableList)this.cp5_widget.get(ScrollableList.class, "WidgetSelector")).isOpen() && !this.cp5_widget.getController("WidgetSelector").isMouseOver()) {
                ((ScrollableList)this.cp5_widget.get(ScrollableList.class, "WidgetSelector")).close();
            }
            int i = 0;
            while (i < this.dropdowns.size()) {
                if (((ScrollableList)this.cp5_widget.get(ScrollableList.class, this.dropdowns.get((int)i).id)).isOpen() && !this.cp5_widget.getController(this.dropdowns.get((int)i).id).isMouseOver()) {
                    ((ScrollableList)this.cp5_widget.get(ScrollableList.class, this.dropdowns.get((int)i).id)).close();
                }
                ++i;
            }
            if (this.dropdownsShouldBeClosed) {
                this.dropdownsShouldBeClosed = false;
            } else {
                if (!((ScrollableList)this.cp5_widget.get(ScrollableList.class, "WidgetSelector")).isOpen() && this.cp5_widget.getController("WidgetSelector").isMouseOver()) {
                    ((ScrollableList)this.cp5_widget.get(ScrollableList.class, "WidgetSelector")).open();
                }
                i = 0;
                while (i < this.dropdowns.size()) {
                    if (!((ScrollableList)this.cp5_widget.get(ScrollableList.class, this.dropdowns.get((int)i).id)).isOpen() && this.cp5_widget.getController(this.dropdowns.get((int)i).id).isMouseOver()) {
                        ((ScrollableList)this.cp5_widget.get(ScrollableList.class, this.dropdowns.get((int)i).id)).open();
                    }
                    ++i;
                }
            }
            this.cp5_widget.getController("WidgetSelector").getCaptionLabel().setText(this.widgetTitle);
        }

        public void drawDropdowns() {
            OpenBCI_GUI.this.pushStyle();
            OpenBCI_GUI.this.noStroke();
            OpenBCI_GUI.this.textFont(OpenBCI_GUI.this.h5);
            OpenBCI_GUI.this.textSize(12.0f);
            OpenBCI_GUI.this.textAlign(3, 102);
            OpenBCI_GUI.this.fill(OpenBCI_GUI.this.bgColor);
            int i = 0;
            while (i < this.dropdowns.size()) {
                int dropdownPos = this.dropdowns.size() - i;
                OpenBCI_GUI.this.text(this.dropdowns.get((int)i).title, this.x0 + this.w0 - this.dropdownWidth * dropdownPos - 2 * (dropdownPos + 1) + this.dropdownWidth / 2, this.y0 + (this.navH - 2));
                ++i;
            }
            OpenBCI_GUI.this.fill(150);
            OpenBCI_GUI.this.rect(this.cp5_widget.getController("WidgetSelector").getPosition()[0] - 1.0f, this.cp5_widget.getController("WidgetSelector").getPosition()[1] - 1.0f, this.widgetSelectorWidth + 2, ((ScrollableList)this.cp5_widget.get(ScrollableList.class, "WidgetSelector")).getHeight() + 2);
            OpenBCI_GUI.this.fill(200);
            i = 0;
            while (i < this.dropdowns.size()) {
                OpenBCI_GUI.this.rect(this.cp5_widget.getController(this.dropdowns.get((int)i).id).getPosition()[0] - 1.0f, this.cp5_widget.getController(this.dropdowns.get((int)i).id).getPosition()[1] - 1.0f, this.dropdownWidth + 2, ((ScrollableList)this.cp5_widget.get(ScrollableList.class, this.dropdowns.get((int)i).id)).getHeight() + 2);
                ++i;
            }
            OpenBCI_GUI.this.textAlign(39, 101);
            this.cp5_widget.draw();
            OpenBCI_GUI.this.popStyle();
        }

        public void screenResized() {
            this.mapToCurrentContainer();
        }

        public void mousePressed() {
        }

        public void mouseReleased() {
        }

        public void mouseDragged() {
        }

        public void setTitle(String _widgetTitle) {
            this.widgetTitle = _widgetTitle;
        }

        public void setContainer(int _currentContainer) {
            this.currentContainer = _currentContainer;
            this.mapToCurrentContainer();
            this.screenResized();
        }

        public void mapToCurrentContainer() {
            this.x0 = (int)OpenBCI_GUI.this.container[this.currentContainer].x;
            this.y0 = (int)OpenBCI_GUI.this.container[this.currentContainer].y;
            this.w0 = (int)OpenBCI_GUI.this.container[this.currentContainer].w;
            this.h0 = (int)OpenBCI_GUI.this.container[this.currentContainer].h;
            this.x = this.x0;
            this.y = this.y0 + this.navH * 2;
            this.w = this.w0;
            this.h = this.h0 - this.navH * 2;
            this.cp5_widget.setGraphics(this.pApplet, 0, 0);
            try {
                this.cp5_widget.getController("WidgetSelector").setPosition((float)(this.x0 + 2), (float)(this.y0 + 2));
            }
            catch (Exception exception) {}
            int i = 0;
            while (i < this.dropdowns.size()) {
                int dropdownPos = this.dropdowns.size() - i;
                this.cp5_widget.getController(this.dropdowns.get((int)i).id).setPosition((float)(this.x0 + this.w0 - this.dropdownWidth * dropdownPos - 2 * dropdownPos), (float)(this.navH + (this.y0 + 2)));
                ++i;
            }
        }

        public boolean isMouseHere() {
            if (this.isActive) {
                if (OpenBCI_GUI.this.mouseX >= this.x0 && OpenBCI_GUI.this.mouseX <= this.x0 + this.w0 && OpenBCI_GUI.this.mouseY >= this.y0 && OpenBCI_GUI.this.mouseY <= this.y0 + this.h0) {
                    OpenBCI_GUI.println((String)("Your cursor is in " + this.widgetTitle));
                    return true;
                }
                return false;
            }
            return false;
        }
    }

    class WidgetManager {
        ArrayList<Widget> widgets;
        ArrayList<String> widgetOptions;
        int currentContainerLayout;
        ArrayList<Layout> layouts = new ArrayList();
        public boolean isWMInitialized = false;
        private boolean visible = true;
        private boolean updating = true;

        WidgetManager(PApplet _this) {
            this.widgets = new ArrayList();
            this.widgetOptions = new ArrayList();
            this.setupLayouts();
            OpenBCI_GUI.this.setupWidgets(_this, this.widgets);
            this.setupWidgetSelectorDropdowns();
            if (OpenBCI_GUI.this.nchan == 4 && OpenBCI_GUI.this.eegDataSource == 1) {
                this.currentContainerLayout = 1;
                this.setNewContainerLayout(this.currentContainerLayout);
            } else {
                this.currentContainerLayout = 4;
                this.setNewContainerLayout(this.currentContainerLayout);
            }
            OpenBCI_GUI.this.delay(1000);
            this.isWMInitialized = true;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public boolean isUpdating() {
            return this.updating;
        }

        public void setVisible(boolean _visible) {
            this.visible = _visible;
        }

        public void setUpdating(boolean _updating) {
            this.updating = _updating;
        }

        public void setupWidgetSelectorDropdowns() {
            OpenBCI_GUI.println((String)("widgets.size() = " + this.widgets.size()));
            int i = 0;
            while (i < this.widgets.size()) {
                this.widgetOptions.add(this.widgets.get((int)i).widgetTitle);
                ++i;
            }
            OpenBCI_GUI.println((String)("widgetOptions.size() = " + this.widgetOptions.size()));
            i = 0;
            while (i < this.widgetOptions.size()) {
                this.widgets.get(i).setupWidgetSelectorDropdown(this.widgetOptions);
                this.widgets.get(i).setupNavDropdowns();
                ++i;
            }
            OpenBCI_GUI.println((String)"widgetOptions:");
            OpenBCI_GUI.println(this.widgetOptions);
        }

        public void update() {
            if (this.visible) {
                int i = 0;
                while (i < this.widgets.size()) {
                    if (this.widgets.get((int)i).isActive) {
                        this.widgets.get(i).update();
                        if (this.widgets.get((int)i).x0 != (int)OpenBCI_GUI.this.container[this.widgets.get((int)i).currentContainer].x || this.widgets.get((int)i).y0 != (int)OpenBCI_GUI.this.container[this.widgets.get((int)i).currentContainer].y || this.widgets.get((int)i).w0 != (int)OpenBCI_GUI.this.container[this.widgets.get((int)i).currentContainer].w || this.widgets.get((int)i).h0 != (int)OpenBCI_GUI.this.container[this.widgets.get((int)i).currentContainer].h) {
                            this.screenResized();
                            OpenBCI_GUI.println((String)"WidgetManager.pde: Remapping widgets to container layout...");
                        }
                    }
                    ++i;
                }
            }
        }

        public void draw() {
            if (this.visible) {
                int i = 0;
                while (i < this.widgets.size()) {
                    if (this.widgets.get((int)i).isActive) {
                        OpenBCI_GUI.this.pushStyle();
                        this.widgets.get(i).draw();
                        this.widgets.get(i).drawDropdowns();
                        OpenBCI_GUI.this.popStyle();
                    } else if (this.widgets.get((int)i).widgetTitle.equals("Networking")) {
                        try {
                            OpenBCI_GUI.this.w_networking.shutDown();
                        }
                        catch (NullPointerException e) {
                            OpenBCI_GUI.println((Object)e);
                        }
                    }
                    ++i;
                }
            }
        }

        public void screenResized() {
            int i = 0;
            while (i < this.widgets.size()) {
                this.widgets.get(i).screenResized();
                ++i;
            }
        }

        public void mousePressed() {
            int i = 0;
            while (i < this.widgets.size()) {
                if (this.widgets.get((int)i).isActive) {
                    this.widgets.get(i).mousePressed();
                }
                ++i;
            }
        }

        public void mouseReleased() {
            int i = 0;
            while (i < this.widgets.size()) {
                if (this.widgets.get((int)i).isActive) {
                    this.widgets.get(i).mouseReleased();
                }
                ++i;
            }
        }

        public void mouseDragged() {
            int i = 0;
            while (i < this.widgets.size()) {
                if (this.widgets.get((int)i).isActive) {
                    this.widgets.get(i).mouseDragged();
                }
                ++i;
            }
        }

        public void setupLayouts() {
            this.layouts.add(new Layout(new int[]{5}));
            this.layouts.add(new Layout(new int[]{1, 3, 7, 9}));
            this.layouts.add(new Layout(new int[]{4, 6}));
            this.layouts.add(new Layout(new int[]{2, 8}));
            this.layouts.add(new Layout(new int[]{4, 3, 9}));
            this.layouts.add(new Layout(new int[]{1, 7, 6}));
            this.layouts.add(new Layout(new int[]{1, 3, 8}));
            this.layouts.add(new Layout(new int[]{2, 7, 9}));
            this.layouts.add(new Layout(new int[]{4, 11, 12, 13, 14}));
            this.layouts.add(new Layout(new int[]{4, 15, 16, 17, 18}));
            this.layouts.add(new Layout(new int[]{1, 7, 11, 12, 13, 14}));
            this.layouts.add(new Layout(new int[]{1, 7, 15, 16, 17, 18}));
        }

        public void printLayouts() {
            int i = 0;
            while (i < this.layouts.size()) {
                OpenBCI_GUI.println((Object)this.layouts.get(i));
                int j = 0;
                while (j < this.layouts.get((int)i).myContainers.length) {
                    OpenBCI_GUI.print((String)(String.valueOf(this.layouts.get((int)i).myContainers[j].x) + ", "));
                    OpenBCI_GUI.print((String)(String.valueOf(this.layouts.get((int)i).myContainers[j].y) + ", "));
                    OpenBCI_GUI.print((String)(String.valueOf(this.layouts.get((int)i).myContainers[j].w) + ", "));
                    OpenBCI_GUI.println((float)this.layouts.get((int)i).myContainers[j].h);
                    ++j;
                }
                OpenBCI_GUI.println();
                ++i;
            }
        }

        public void setNewContainerLayout(int _newLayout) {
            int numActiveWidgetsNeeded = this.layouts.get((int)_newLayout).myContainers.length;
            int numActiveWidgets = 0;
            int i = 0;
            while (i < this.widgets.size()) {
                if (this.widgets.get((int)i).isActive) {
                    ++numActiveWidgets;
                }
                ++i;
            }
            if (numActiveWidgets > numActiveWidgetsNeeded) {
                int numToShutDown = numActiveWidgets - numActiveWidgetsNeeded;
                int counter = 0;
                OpenBCI_GUI.println((String)("Powering " + numToShutDown + " widgets down, and remapping."));
                int i2 = this.widgets.size() - 1;
                while (i2 >= 0) {
                    if (this.widgets.get((int)i2).isActive && counter < numToShutDown) {
                        OpenBCI_GUI.println((String)("Deactivating widget [" + i2 + "]"));
                        this.widgets.get((int)i2).isActive = false;
                        ++counter;
                    }
                    --i2;
                }
                counter = 0;
                i2 = 0;
                while (i2 < this.widgets.size()) {
                    if (this.widgets.get((int)i2).isActive) {
                        this.widgets.get(i2).setContainer(this.layouts.get((int)_newLayout).containerInts[counter]);
                        ++counter;
                    }
                    ++i2;
                }
            } else if (numActiveWidgetsNeeded > numActiveWidgets) {
                int numToPowerUp = numActiveWidgetsNeeded - numActiveWidgets;
                int counter = 0;
                OpenBCI_GUI.println((String)("Powering " + numToPowerUp + " widgets up, and remapping."));
                int i3 = 0;
                while (i3 < this.widgets.size()) {
                    if (!this.widgets.get((int)i3).isActive && counter < numToPowerUp) {
                        OpenBCI_GUI.println((String)("Activating widget [" + i3 + "]"));
                        this.widgets.get((int)i3).isActive = true;
                        ++counter;
                    }
                    ++i3;
                }
                counter = 0;
                i3 = 0;
                while (i3 < this.widgets.size()) {
                    if (this.widgets.get((int)i3).isActive) {
                        this.widgets.get(i3).setContainer(this.layouts.get((int)_newLayout).containerInts[counter]);
                        ++counter;
                    }
                    ++i3;
                }
            } else {
                OpenBCI_GUI.println((String)"Remapping widgets.");
                int counter = 0;
                int i4 = 0;
                while (i4 < this.widgets.size()) {
                    if (this.widgets.get((int)i4).isActive) {
                        this.widgets.get(i4).setContainer(this.layouts.get((int)_newLayout).containerInts[counter]);
                        ++counter;
                    }
                    ++i4;
                }
            }
        }
    }

    class WifiBox {
        int x;
        int y;
        int w;
        int h;
        int padding;

        WifiBox(int _x, int _y, int _w, int _h, int _padding) {
            this.x = _x;
            this.y = _y;
            this.w = _w;
            this.h = 184 + _padding;
            this.padding = _padding;
            OpenBCI_GUI.this.wifiIPAddressDyanmic = new Button(this.x + this.padding, this.y + this.padding * 2 + 30, (this.w - this.padding * 3) / 2, 24, "DYNAMIC IP", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
            if (OpenBCI_GUI.this.hub.getWiFiStyle() == OpenBCI_GUI.WIFI_DYNAMIC) {
                OpenBCI_GUI.this.wifiIPAddressDyanmic.color_notPressed = OpenBCI_GUI.this.isSelected_color;
            }
            OpenBCI_GUI.this.wifiIPAddressStatic = new Button(this.x + this.padding * 2 + (this.w - this.padding * 3) / 2, this.y + this.padding * 2 + 30, (this.w - this.padding * 3) / 2, 24, "STATIC IP", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
            if (OpenBCI_GUI.this.hub.getWiFiStyle() == OpenBCI_GUI.WIFI_STATIC) {
                OpenBCI_GUI.this.wifiIPAddressStatic.color_notPressed = OpenBCI_GUI.this.isSelected_color;
            }
            OpenBCI_GUI.this.refreshWifi = new Button(this.x + this.padding, this.y + this.padding * 5 + 72 + 8 + 24, this.w - this.padding * 5, 24, "START SEARCH", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
            OpenBCI_GUI.this.wifiList = new MenuList(OpenBCI_GUI.this.cp5, "wifiList", this.w - this.padding * 2, 80, OpenBCI_GUI.this.p4);
            OpenBCI_GUI.this.popOutWifiConfigButton = new Button(this.x + this.padding + (this.w - this.padding * 4), this.y + this.padding, 20, 20, ">", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
            OpenBCI_GUI.this.wifiList.setPosition(this.x + this.padding, this.y + this.padding * 4 + 8 + 24);
            ((Textfield)((Textfield)((Textfield)((Textfield)((Textfield)((Textfield)((Textfield)((Textfield)((Textfield)OpenBCI_GUI.this.cp5.addTextfield("staticIPAddress").setPosition((float)(this.x + 90), (float)(this.y + 100))).setCaptionLabel("")).setSize(this.w - this.padding * 2, 26).setFont(OpenBCI_GUI.this.f2)).setFocus(false).setColor(OpenBCI_GUI.this.color(26, 26, 26)).setColorBackground(OpenBCI_GUI.this.color(255, 255, 255))).setColorValueLabel(OpenBCI_GUI.this.color(0, 0, 0))).setColorForeground(OpenBCI_GUI.this.isSelected_color)).setColorActive(OpenBCI_GUI.this.isSelected_color)).setColorCursor(OpenBCI_GUI.this.color(26, 26, 26)).setText(OpenBCI_GUI.this.wifi_ipAddress).align(5, 10, 20, 40)).onDoublePress(OpenBCI_GUI.this.cb)).setAutoClear(true);
        }

        public void update() {
        }

        public void updateListPosition() {
            OpenBCI_GUI.this.wifiList.setPosition(this.x + this.padding, this.y + this.padding * 3);
        }

        public void draw() {
            OpenBCI_GUI.this.pushStyle();
            OpenBCI_GUI.this.fill(OpenBCI_GUI.this.boxColor);
            OpenBCI_GUI.this.stroke(OpenBCI_GUI.this.boxStrokeColor);
            OpenBCI_GUI.this.strokeWeight(1.0f);
            OpenBCI_GUI.this.rect(this.x, this.y, this.w, this.h);
            OpenBCI_GUI.this.fill(OpenBCI_GUI.this.bgColor);
            OpenBCI_GUI.this.textFont(OpenBCI_GUI.this.h3, 16.0f);
            OpenBCI_GUI.this.textAlign(37, 101);
            OpenBCI_GUI.this.text("WIFI SHIELDS", this.x + this.padding, this.y + this.padding);
            OpenBCI_GUI.this.wifiIPAddressDyanmic.draw();
            OpenBCI_GUI.this.wifiIPAddressStatic.draw();
            OpenBCI_GUI.this.wifiIPAddressStatic.but_y = OpenBCI_GUI.this.wifiIPAddressDyanmic.but_y = this.y + this.padding * 2 + 16;
            OpenBCI_GUI.this.popStyle();
            OpenBCI_GUI.this.popOutWifiConfigButton.but_y = this.y + this.padding;
            OpenBCI_GUI.this.popOutWifiConfigButton.draw();
            if (OpenBCI_GUI.this.hub.getWiFiStyle() == OpenBCI_GUI.WIFI_STATIC) {
                OpenBCI_GUI.this.pushStyle();
                OpenBCI_GUI.this.fill(OpenBCI_GUI.this.bgColor);
                OpenBCI_GUI.this.textFont(OpenBCI_GUI.this.h3, 16.0f);
                OpenBCI_GUI.this.textAlign(37, 101);
                OpenBCI_GUI.this.text("ENTER IP ADDRESS", this.x + this.padding, this.y + this.h - 24 - 12 - this.padding * 2);
                OpenBCI_GUI.this.popStyle();
                ((Textfield)OpenBCI_GUI.this.cp5.get(Textfield.class, "staticIPAddress")).setPosition((float)(this.x + this.padding), (float)(this.y + this.h - 24 - this.padding));
            } else {
                OpenBCI_GUI.this.wifiList.setPosition(this.x + this.padding, OpenBCI_GUI.this.wifiIPAddressDyanmic.but_y + 24 + this.padding);
                OpenBCI_GUI.this.refreshWifi.draw();
                OpenBCI_GUI.this.refreshWifi.but_y = this.y + this.h - this.padding - 24;
                if (OpenBCI_GUI.this.isHubInitialized && OpenBCI_GUI.this.isHubObjectInitialized && (OpenBCI_GUI.this.ganglion.isWifi() || OpenBCI_GUI.this.cyton.isWifi()) && OpenBCI_GUI.this.hub.isSearching()) {
                    OpenBCI_GUI.this.image((PImage)OpenBCI_GUI.this.loadingGIF_blue, this.w + 225, OpenBCI_GUI.this.refreshWifi.but_y + 4, 20.0f, 20.0f);
                    OpenBCI_GUI.this.refreshWifi.setString("SEARCHING...");
                } else {
                    OpenBCI_GUI.this.refreshWifi.setString("START SEARCH");
                    OpenBCI_GUI.this.pushStyle();
                    OpenBCI_GUI.this.fill(-6710887);
                    OpenBCI_GUI.this.ellipseMode(3);
                    OpenBCI_GUI.this.ellipse(this.w + 225 + 10, OpenBCI_GUI.this.refreshWifi.but_y + 12, 12.0f, 12.0f);
                    OpenBCI_GUI.this.popStyle();
                }
            }
        }

        public void refreshWifiList() {
            OpenBCI_GUI.println((String)"refreshWifiList");
            OpenBCI_GUI.this.wifiList.items.clear();
            if (OpenBCI_GUI.this.hub.deviceList != null) {
                int i = 0;
                while (i < OpenBCI_GUI.this.hub.deviceList.length) {
                    String tempPort = OpenBCI_GUI.this.hub.deviceList[i];
                    OpenBCI_GUI.this.wifiList.addItem(OpenBCI_GUI.this.makeItem(tempPort));
                    ++i;
                }
            }
            OpenBCI_GUI.this.wifiList.updateMenu();
        }
    }

    class WifiConfigBox {
        int x;
        int y;
        int w;
        int h;
        int padding;
        String last_message = "";
        Serial board;
        boolean isShowing;

        WifiConfigBox(int _x, int _y, int _w, int _h, int _padding) {
            this.x = _x + _w;
            this.y = _y;
            this.w = _w;
            this.h = 255;
            this.padding = _padding;
            this.isShowing = false;
            OpenBCI_GUI.this.getTypeOfAttachedBoard = new Button(this.x + this.padding, this.y + this.padding * 2 + 18, (this.w - this.padding * 3) / 2, 24, "OPENBCI BOARD", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
            OpenBCI_GUI.this.getIpAddress = new Button(this.x + 2 * this.padding + (this.w - this.padding * 3) / 2, this.y + this.padding * 2 + 18, (this.w - this.padding * 3) / 2, 24, "IP ADDRESS", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
            OpenBCI_GUI.this.getMacAddress = new Button(this.x + this.padding, this.y + this.padding * 3 + 18 + 24, (this.w - this.padding * 3) / 2, 24, "MAC ADDRESS", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
            OpenBCI_GUI.this.getFirmwareVersion = new Button(this.x + 2 * this.padding + (this.w - this.padding * 3) / 2, this.y + this.padding * 3 + 18 + 24, (this.w - this.padding * 3) / 2, 24, "FIRMWARE VERS.", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
            OpenBCI_GUI.this.eraseCredentials = new Button(this.x + this.padding, this.y + this.padding * 4 + 18 + 48, this.w - this.padding * 2, 24, "ERASE NETWORK CREDENTIALS", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
            OpenBCI_GUI.this.getTypeOfAttachedBoard.setHelpText("Get the type of OpenBCI board attached to the WiFi Shield");
            OpenBCI_GUI.this.getIpAddress.setHelpText("Get the IP Address of the WiFi shield");
            OpenBCI_GUI.this.getMacAddress.setHelpText("Get the MAC Address of the WiFi shield");
            OpenBCI_GUI.this.getFirmwareVersion.setHelpText("Get the firmware version of the WiFi Shield");
            OpenBCI_GUI.this.eraseCredentials.setHelpText("Erase the store credentials on the WiFi Shield to join another wireless network. Always remove WiFi Shield from OpenBCI board prior to erase and WiFi Shield will become a hotspot again.");
        }

        public void update() {
        }

        public void draw() {
            OpenBCI_GUI.this.pushStyle();
            OpenBCI_GUI.this.fill(OpenBCI_GUI.this.boxColor);
            OpenBCI_GUI.this.stroke(OpenBCI_GUI.this.boxStrokeColor);
            OpenBCI_GUI.this.strokeWeight(1.0f);
            OpenBCI_GUI.this.rect(this.x, this.y, this.w, this.h);
            OpenBCI_GUI.this.fill(OpenBCI_GUI.this.bgColor);
            OpenBCI_GUI.this.textFont(OpenBCI_GUI.this.h3, 16.0f);
            OpenBCI_GUI.this.textAlign(37, 101);
            OpenBCI_GUI.this.text("WIFI CONFIGURATION", this.x + this.padding, this.y + this.padding);
            OpenBCI_GUI.this.popStyle();
            OpenBCI_GUI.this.getTypeOfAttachedBoard.draw();
            OpenBCI_GUI.this.getIpAddress.draw();
            OpenBCI_GUI.this.getMacAddress.draw();
            OpenBCI_GUI.this.getFirmwareVersion.draw();
            OpenBCI_GUI.this.eraseCredentials.draw();
            this.print_onscreen(this.last_message);
        }

        public void updateMessage(String str) {
            this.last_message = str;
        }

        public void print_onscreen(String localstring) {
            OpenBCI_GUI.this.textAlign(37);
            OpenBCI_GUI.this.fill(OpenBCI_GUI.this.bgColor);
            OpenBCI_GUI.this.rect(this.x + this.padding, this.y + this.padding * 8 + 13 + 48, this.w - this.padding * 2, 114 - this.padding);
            OpenBCI_GUI.this.fill(255);
            OpenBCI_GUI.this.text(localstring, this.x + this.padding + 10, this.y + this.padding * 8 + 5 + 48 + 15, this.w - this.padding * 3, 111 - this.padding - 15);
        }

        public void print_lastmessage() {
            OpenBCI_GUI.this.fill(OpenBCI_GUI.this.bgColor);
            OpenBCI_GUI.this.rect(this.x + this.padding, this.y + this.padding * 8 + 13 + 48, this.w - this.padding * 2, 114 - this.padding);
            OpenBCI_GUI.this.fill(255);
            OpenBCI_GUI.this.text(this.last_message, 180.0f, 340.0f, 240.0f, 60.0f);
        }
    }

    class WifiTransferProtcolCytonBox {
        int x;
        int y;
        int w;
        int h;
        int padding;

        WifiTransferProtcolCytonBox(int _x, int _y, int _w, int _h, int _padding) {
            this.x = _x;
            this.y = _y;
            this.w = _w;
            this.h = 73;
            this.padding = _padding;
            OpenBCI_GUI.this.wifiInternetProtocolCytonTCP = new Button(this.x + this.padding, this.y + this.padding * 2 + 18, (this.w - this.padding * 4) / 3, 24, "TCP", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
            if (OpenBCI_GUI.this.hub.getWifiInternetProtocol().equals(OpenBCI_GUI.TCP)) {
                OpenBCI_GUI.this.wifiInternetProtocolCytonTCP.color_notPressed = OpenBCI_GUI.this.isSelected_color;
            }
            OpenBCI_GUI.this.wifiInternetProtocolCytonUDP = new Button(this.x + this.padding * 2 + (this.w - this.padding * 4) / 3, this.y + this.padding * 2 + 18, (this.w - this.padding * 4) / 3, 24, "UDP", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
            if (OpenBCI_GUI.this.hub.getWifiInternetProtocol().equals(OpenBCI_GUI.UDP)) {
                OpenBCI_GUI.this.wifiInternetProtocolCytonUDP.color_notPressed = OpenBCI_GUI.this.isSelected_color;
            }
            OpenBCI_GUI.this.wifiInternetProtocolCytonUDPBurst = new Button(this.x + this.padding * 3 + (this.w - this.padding * 4) / 3 * 2, this.y + this.padding * 2 + 18, (this.w - this.padding * 4) / 3, 24, "UDPx3", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
            if (OpenBCI_GUI.this.hub.getWifiInternetProtocol().equals(OpenBCI_GUI.UDP_BURST)) {
                OpenBCI_GUI.this.wifiInternetProtocolCytonUDPBurst.color_notPressed = OpenBCI_GUI.this.isSelected_color;
            }
        }

        public void update() {
        }

        public void draw() {
            OpenBCI_GUI.this.pushStyle();
            OpenBCI_GUI.this.fill(OpenBCI_GUI.this.boxColor);
            OpenBCI_GUI.this.stroke(OpenBCI_GUI.this.boxStrokeColor);
            OpenBCI_GUI.this.strokeWeight(1.0f);
            OpenBCI_GUI.this.rect(this.x, this.y, this.w, this.h);
            OpenBCI_GUI.this.fill(OpenBCI_GUI.this.bgColor);
            OpenBCI_GUI.this.textFont(OpenBCI_GUI.this.h3, 16.0f);
            OpenBCI_GUI.this.textAlign(37, 101);
            OpenBCI_GUI.this.text("WiFi Transfer Protocol ", this.x + this.padding, this.y + this.padding);
            OpenBCI_GUI.this.fill(OpenBCI_GUI.this.bgColor);
            OpenBCI_GUI.this.textFont(OpenBCI_GUI.this.h3, 16.0f);
            OpenBCI_GUI.this.textAlign(37, 101);
            String dispText = OpenBCI_GUI.this.hub.getWifiInternetProtocol().equals(OpenBCI_GUI.TCP) ? "TCP" : (OpenBCI_GUI.this.hub.getWifiInternetProtocol().equals(OpenBCI_GUI.UDP) ? "UDP" : "UDPx3");
            OpenBCI_GUI.this.text(dispText, this.x + this.padding + 184, this.y + this.padding);
            OpenBCI_GUI.this.popStyle();
            OpenBCI_GUI.this.wifiInternetProtocolCytonTCP.draw();
            OpenBCI_GUI.this.wifiInternetProtocolCytonUDP.draw();
            OpenBCI_GUI.this.wifiInternetProtocolCytonUDPBurst.draw();
            OpenBCI_GUI.this.wifiInternetProtocolCytonUDP.but_y = OpenBCI_GUI.this.wifiInternetProtocolCytonTCP.but_y = this.y + this.padding * 2 + 18;
            OpenBCI_GUI.this.wifiInternetProtocolCytonUDPBurst.but_y = OpenBCI_GUI.this.wifiInternetProtocolCytonTCP.but_y;
        }
    }

    class WifiTransferProtcolGanglionBox {
        int x;
        int y;
        int w;
        int h;
        int padding;

        WifiTransferProtcolGanglionBox(int _x, int _y, int _w, int _h, int _padding) {
            this.x = _x;
            this.y = _y;
            this.w = _w;
            this.h = 73;
            this.padding = _padding;
            OpenBCI_GUI.this.wifiInternetProtocolGanglionTCP = new Button(this.x + this.padding, this.y + this.padding * 2 + 18, (this.w - this.padding * 4) / 3, 24, "TCP", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
            if (OpenBCI_GUI.this.hub.getWifiInternetProtocol().equals(OpenBCI_GUI.TCP)) {
                OpenBCI_GUI.this.wifiInternetProtocolGanglionTCP.color_notPressed = OpenBCI_GUI.this.isSelected_color;
            }
            OpenBCI_GUI.this.wifiInternetProtocolGanglionUDP = new Button(this.x + this.padding * 2 + (this.w - this.padding * 4) / 3, this.y + this.padding * 2 + 18, (this.w - this.padding * 4) / 3, 24, "UDP", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
            if (OpenBCI_GUI.this.hub.getWifiInternetProtocol().equals(OpenBCI_GUI.UDP)) {
                OpenBCI_GUI.this.wifiInternetProtocolGanglionUDP.color_notPressed = OpenBCI_GUI.this.isSelected_color;
            }
            OpenBCI_GUI.this.wifiInternetProtocolGanglionUDPBurst = new Button(this.x + this.padding * 3 + (this.w - this.padding * 4) / 3 * 2, this.y + this.padding * 2 + 18, (this.w - this.padding * 4) / 3, 24, "UDPx3", OpenBCI_GUI.this.fontInfo.buttonLabel_size);
            if (OpenBCI_GUI.this.hub.getWifiInternetProtocol().equals(OpenBCI_GUI.UDP_BURST)) {
                OpenBCI_GUI.this.wifiInternetProtocolGanglionUDPBurst.color_notPressed = OpenBCI_GUI.this.isSelected_color;
            }
        }

        public void update() {
        }

        public void draw() {
            OpenBCI_GUI.this.pushStyle();
            OpenBCI_GUI.this.fill(OpenBCI_GUI.this.boxColor);
            OpenBCI_GUI.this.stroke(OpenBCI_GUI.this.boxStrokeColor);
            OpenBCI_GUI.this.strokeWeight(1.0f);
            OpenBCI_GUI.this.rect(this.x, this.y, this.w, this.h);
            OpenBCI_GUI.this.fill(OpenBCI_GUI.this.bgColor);
            OpenBCI_GUI.this.textFont(OpenBCI_GUI.this.h3, 16.0f);
            OpenBCI_GUI.this.textAlign(37, 101);
            OpenBCI_GUI.this.text("WiFi Transfer Protocol ", this.x + this.padding, this.y + this.padding);
            OpenBCI_GUI.this.fill(OpenBCI_GUI.this.bgColor);
            OpenBCI_GUI.this.textFont(OpenBCI_GUI.this.h3, 16.0f);
            OpenBCI_GUI.this.textAlign(37, 101);
            String dispText = OpenBCI_GUI.this.hub.getWifiInternetProtocol().equals(OpenBCI_GUI.TCP) ? "TCP" : (OpenBCI_GUI.this.hub.getWifiInternetProtocol().equals(OpenBCI_GUI.UDP) ? "UDP" : "UDPx3");
            OpenBCI_GUI.this.text(dispText, this.x + this.padding + 184, this.y + this.padding);
            OpenBCI_GUI.this.popStyle();
            OpenBCI_GUI.this.wifiInternetProtocolGanglionTCP.draw();
            OpenBCI_GUI.this.wifiInternetProtocolGanglionUDP.draw();
            OpenBCI_GUI.this.wifiInternetProtocolGanglionUDPBurst.draw();
            OpenBCI_GUI.this.wifiInternetProtocolGanglionUDP.but_y = OpenBCI_GUI.this.wifiInternetProtocolGanglionTCP.but_y = this.y + this.padding * 2 + 18;
            OpenBCI_GUI.this.wifiInternetProtocolGanglionUDPBurst.but_y = OpenBCI_GUI.this.wifiInternetProtocolGanglionTCP.but_y;
        }
    }
}

