/*
 * Decompiled with CFR 0.152.
 */
package server;

import common.MessageQueue;
import common.SocketConnection;
import common.sd.SD_AdminAdd;
import common.sd.SD_Channel;
import common.sd.SD_Chat;
import common.sd.SD_Error;
import common.sd.SD_Kick;
import common.sd.SD_Log;
import common.sd.SD_Private;
import common.sd.SD_Rename;
import common.sd.SD_UserAdd;
import common.sd.SD_UserDel;
import common.sd.SD_Whisper;
import common.sd.SocketData;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.net.ssl.SSLSocket;
import server.EEGLABChatServer;

public class ClientConnection
implements Runnable,
SocketConnection {
    private EEGLABChatServer server;
    private SSLSocket socket;
    public String name;
    public String ip;
    public String channel;
    private ObjectInputStream in;
    private ObjectOutputStream out;
    private boolean finalized;
    private boolean admin;
    private MessageQueue queue;

    ClientConnection(EEGLABChatServer serv, SSLSocket sock) {
        try {
            this.name = null;
            this.finalized = false;
            this.admin = false;
            this.channel = EEGLABChatServer.channels.defaultChannel;
            this.server = serv;
            this.socket = sock;
            this.ip = sock.getInetAddress().getHostName();
            this.out = new ObjectOutputStream(sock.getOutputStream());
            this.in = new ObjectInputStream(sock.getInputStream());
            this.queue = new MessageQueue(this);
            new Thread(this).start();
        }
        catch (IOException e) {
            this.server.log(this, "failed connection");
            EEGLABChatServer.connectingUsers.remove(this);
        }
    }

    private SocketData readObject() {
        try {
            return (SocketData)this.in.readObject();
        }
        catch (IOException e) {
            return null;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public void writeObject(Object obj) {
        this.queue.enqueue(obj);
    }

    @Override
    public void _writeObject(Object obj) {
        try {
            this.out.writeObject(obj);
            this.out.flush();
        }
        catch (IOException e) {
            this.close();
        }
    }

    @Override
    public void close() {
        this.server.kill(this);
        try {
            this.socket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isAdmin() {
        return this.admin;
    }

    @Override
    public void serverCap(char type, Object obj) {
    }

    @Override
    public void userAdd(String username, boolean isParsed) {
        if (username == null) {
            this.writeObject(new SD_Error("no username recieved"));
            return;
        }
        if (this.name == null && !this.finalized) {
            this.name = !isParsed ? this.server.generateUsername(username) : username;
            this.finalized = this.server.finalizeUser(this.name, this);
            if (!this.finalized) {
                this.name = null;
                this.writeObject(new SD_Kick(null));
            }
            this.writeObject(new SD_Rename(username, this.name));
        } else {
            this.writeObject(new SD_Error("already recieved name: " + this.name));
        }
    }

    @Override
    public void adminAdd(String password) {
        if (!EEGLABChatServer.allowAdmin) {
            this.writeObject(new SD_Error("admins are not allow on this server"));
        } else if (password.equals(EEGLABChatServer.adminPass)) {
            this.admin = true;
            this.server.broadcast(new SD_AdminAdd(this.name), null, this.channel);
        } else {
            this.writeObject(new SD_Error("incorrect administrative password"));
        }
    }

    @Override
    public void userDel(String username) {
        this.close();
    }

    @Override
    public void updateUserNumber(int nUsers) {
    }

    @Override
    public void rename(String on, String nn) {
        if (EEGLABChatServer.connectedUsers.containsKey(nn)) {
            this.writeObject(new SD_Error("username already exists"));
            this.writeObject(new SD_Rename(nn, on));
        } else {
            EEGLABChatServer.connectedUsers.remove(this.name);
            EEGLABChatServer.connectedUsers.put(nn, this);
            this.server.broadcast(new SD_Rename(this.name, nn), nn, this.channel);
            EEGLABChatServer.updateUserExport();
            this.name = nn;
            this.writeObject(new SD_Rename(this.name, nn));
        }
    }

    @Override
    public void kick(String username) {
        if (this.admin) {
            ClientConnection cc = (ClientConnection)EEGLABChatServer.connectedUsers.get(username);
            if (cc == null) {
                this.writeObject(new SD_Error("user " + username + " does not exist"));
            } else {
                this.server.sendTo(new SD_Error("You have been kicked by " + this.name), username);
                cc.close();
            }
        } else {
            this.writeObject(new SD_Error("Couldn't verify administrative status"));
        }
    }

    @Override
    public void channel(boolean nc, String n, String p) {
        if (nc) {
            String reason = this.server.newChannel(n, p, this);
            if (reason == null) {
                this.server.log(this, "channel " + n + " created");
                this.channel(false, n, p);
            } else {
                this.writeObject(new SD_Error(reason));
            }
        } else if (EEGLABChatServer.channels.channelExists(n)) {
            if (this.channel.equals(n)) {
                this.writeObject(new SD_Error("Already a member of " + n));
                this.writeObject(new SD_Channel(false, null, null));
            } else if (!EEGLABChatServer.channels.userAdd(n, p)) {
                this.writeObject(new SD_Error("invalid passphrase or none provided, use \\join " + n + " &lt;password&gt;"));
                this.writeObject(new SD_Channel(false, null, null));
            } else {
                this.server.broadcast(new SD_UserDel(this.name), this.name, this.channel);
                if (EEGLABChatServer.channels.userDel(this.channel)) {
                    this.server.broadcast(new SD_Channel(true, this.channel, null), null);
                    this.server.chatLog(this, false);
                    this.server.log(this, "channel " + this.channel + " removed");
                }
                this.channel = n;
                this.server.broadcast(new SD_UserAdd(this.name, false), this.name, this.channel);
                if (this.admin) {
                    this.server.broadcast(new SD_AdminAdd(this.name), this.name, this.channel);
                }
                this.writeObject(new SD_Channel(false, this.channel, null));
                this.server.sendUserList(this);
                EEGLABChatServer.updateUserExport();
            }
        } else {
            this.writeObject(new SD_Error(String.valueOf(n) + " does not exist"));
            this.writeObject(new SD_Channel(false, null, null));
        }
    }

    @Override
    public void chat(String username, String message) {
        if (this.finalized) {
            this.server.chatLog(this, message);
            this.server.broadcast(new SD_Chat(this.name, message), this.name, this.channel);
        } else {
            this.writeObject(new SD_Error("connection not confirmed"));
        }
    }

    @Override
    public void private_msg(String username, String message) {
        if (this.finalized) {
            this.server.sendTo(new SD_Private(this.name, message), username);
        } else {
            this.writeObject(new SD_Error("connection not confirmed"));
        }
    }

    @Override
    public void whisper(String username, String message) {
        if (this.finalized) {
            this.server.sendTo(new SD_Whisper(this.name, message), username);
        } else {
            this.writeObject(new SD_Error("connection not confirmed"));
        }
    }

    @Override
    public void chatLog(boolean start) {
        if (this.admin) {
            if (this.server.chatLog(this, start)) {
                this.writeObject(new SD_Log(start));
            } else {
                this.writeObject(new SD_Error("unable to modify log for " + this.channel));
            }
        } else {
            this.writeObject(new SD_Error("Could not verify administrative status"));
        }
    }

    @Override
    public void error(String err) {
        this.server.log(this, err);
    }

    @Override
    public void run() {
        SocketData sd;
        while ((sd = this.readObject()) != null) {
            sd.performAction(this);
        }
        this.close();
    }
}

