/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.SocketConnection;
import java.io.IOException;
import java.util.LinkedList;

public class MessageQueue
implements Runnable {
    private static final int MAX_SIZE = 15;
    private LinkedList queue;
    private SocketConnection writer;
    private boolean running;
    private boolean empty;

    public MessageQueue(SocketConnection w) {
        this.writer = w;
        this.queue = new LinkedList();
        this.running = true;
        this.empty = true;
        new Thread(this).start();
    }

    public synchronized boolean enqueue(Object obj) {
        this.queue.addLast(obj);
        if (this.empty) {
            this.empty = false;
            this.notify();
        }
        if (this.queue.size() > 15) {
            try {
                this.writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.running) {
            try {
                if (this.queue.size() != 0) {
                    try {
                        this.writer._writeObject(this.queue.removeFirst());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                } else {
                    this.empty = true;
                    MessageQueue e = this;
                    synchronized (e) {
                        while (this.empty) {
                            this.wait();
                        }
                    }
                }
                Thread.sleep(10L);
            }
            catch (InterruptedException inte) {
                this.running = false;
            }
        }
    }
}

