--****************************************************************************************************************--
--! @ mux41
--! @ A 4:1 multiplexer. 8-bit. 
--
--! Authors: 
--! John William Croft 
--! Alfred Kulldorff
--****************************************************************************************************************--
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use work.alu_pkg.all;

entity mux41 is 
	port ( 
		w0, w1, w2, w3 	: in STD_LOGIC_VECTOR(7 downto 0);
		s 				: in STD_LOGIC_VECTOR(1 downto 0);
		f 				: out STD_LOGIC_VECTOR(7 downto 0)
);
end entity;

architecture struct of mux41 is
	signal m0, m1 : STD_LOGIC_VECTOR (7 downto 0);
begin
	Mux1 : mux21 
		PORT MAP(	w0 	=> w0,
					w1 	=> w1,
					s 	=> s(0),
					f 	=> m0); -- m is middle stage
					
	Mux2 : mux21 
		PORT MAP(	w0	=> w2, 
					w1 	=> w3,
					s 	=> s(0),
					f 	=> m1);
					
	Mux3 : mux21 
		PORT MAP(	w0 	=> m0, 
					w1 	=> m1,
					s 	=> s(1),
					f 	=> f);
end architecture;
