--****************************************************************************************************************--
--! @ mux21
--! @ A 2:1 multiplexer. 8-bit  
--
--! Authors: 
--! John William Croft 
--! Alfred Kulldorff
--****************************************************************************************************************--

LIBRARY ieee ;
USE ieee.std_logic_1164.all ;

ENTITY mux21 IS PORT (
	w0, w1 : in STD_LOGIC_VECTOR (7 downto 0);
	s : in STD_LOGIC;
	f : OUT STD_LOGIC_VECTOR (7 downto 0)
);
END mux21;

ARCHITECTURE dataflow OF mux21 IS
BEGIN

f <= w0 	WHEN s='0' ELSE 
	 w1 	WHEN s='1' ELSE 
	 (others => 'X'); -- X propagation issue. We want 'X' to propagate in case of metastability on the select signal.

END dataflow;

