--****************************************************************************************************************--
--! @ FA
--! @ Full adder implemented in dataflow VHDL
--
--! Authors: 
--! John William Croft 
--! Alfred Kulldorff
--****************************************************************************************************************--
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity FA is
	port(	Cin		:	in	std_logic;
			A, B	:	in	std_logic;
			S		:	out std_logic;
			Cout	:	out	std_logic
	);
end FA;

architecture struct of FA is
begin
	S <= Cin XOR (A XOR B);
	Cout <= (Cin AND (A XOR B)) OR (A AND B);
end struct;
 
			
