--****************************************************************************************************************--
--! @ CMP
--! @ Comparator with two outputs, Eq and NotEq, set depending on the comparison between two 8bit inputs.
--
--! Authors: 
--! John William Croft 
--! 
--****************************************************************************************************************--

----------------------------------------------------- Libraries ----------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;

----------------------------------------------------- Entity -------------------------------------------------------
entity CMP is
	port(
			A, B : in std_logic_vector(7 downto 0);
			Eq, NotEq : out std_logic
			);
	end CMP;
----------------------------------------------------- Architecture ------------------------------------------------- 
architecture dataflow of CMP is
begin
	Eq <= '1' when A = B else '0';
	NotEq <= '0' when A = B else '1';
end dataflow;