library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use work.alu_pkg.all;


entity procController is
    Port ( 	master_load_enable : in STD_LOGIC;
				opcode : in  STD_LOGIC_VECTOR (3 downto 0);
				neq : in STD_LOGIC;
				eq : in STD_LOGIC; 
				CLK : in STD_LOGIC;
				ARESETN : in STD_LOGIC;
				pcSel : out  STD_LOGIC;
				pcLd : out  STD_LOGIC;
				instrLd : out  STD_LOGIC;
				addrMd : out  STD_LOGIC;
				dmWr : out  STD_LOGIC;
				dataLd : out  STD_LOGIC;
				flagLd : out  STD_LOGIC;
				accSel : out  STD_LOGIC;
				accLd : out  STD_LOGIC;
				im2bus : out  STD_LOGIC;
				dmRd : out  STD_LOGIC;
				acc2bus : out  STD_LOGIC;
				ext2bus : out  STD_LOGIC;
				dispLd: out STD_LOGIC;
				aluMd : out STD_LOGIC_VECTOR(1 downto 0));
end procController;

architecture Behavioral of procController is
	type STATE_TYPE is (FE, DE, DE2, EX, ME);
	signal curr_state, next_state : STATE_TYPE;
	signal ctrl_out : std_logic_vector(15 downto 0);
begin
	-- For quick resetting etc..
	ctrl_out <= pcSel & pcLd & instrLd & addrMd & dmWr & dataLd & flagLd & accSel & accLd & im2bus & dmRd & acc2bus & ext2bus & dispLd & aluMd;


	reg_fsm: process(ARESETN, CLK)
	begin	
		if ARESETN = '0' then 
			curr_state <= FE;			-- Initialize state, clear control output signals.
			ctrl_out <= (others => '0');
		elsif master_load_enable='1' then
			if rising_edge(CLK) then     -- Rising edge implicitly defines FF, not latch!
				curr_state <= next_state;
		end if;
	end process;
				
				
	comb_next_state_process : process
	begin
		case(curr_state) is
			when FE =>
				next_state <= DE;  -- unconditional transition.
			when DE =>
				if (opcode = ("00--" | "010-" | "0110" | "1111")) then -- NOOP and ARITHMETIC
					next_state <= EX;
				elsif
					
		end case;
	end process;
			
	output_process : process (curr_state, neq, eq, opcode)
	begin
		case STATE is
			------------------------ FE ----------------------------------
			when FE =>
				ctrl_out <= '0010000000000000'; -- instrLd
			------------------------ DE ----------------------------------
			when DE =>
				if opcode = "0000" -- NOOP
					ctrl_out <= "00000010101000" -- dmRd, flagLd, accLd, pcLd, aluMd="00"
			
				case opcode is -- dela upp alla op koder för sig pga att alumd varierar
						 when "0000" =>
						when "0001" =>
						when "0010" =>
						when "0011" =>
			
				 if (opcode = ("110-" | "1110"));
					end if;
					
					if (opcode = ("1010" ); --store byte index, SBX 
						ctrl_out <= '010110000010000';
					end if;
				 	
				 
				 ctrl_out <= '0010000000000000';
				------------------------ DE2 ----------------------------------
				when DE2 =>
				------------------------ ME ----------------------------------
				when ME =>
					if (opcode = ("0111" ); 
					ctrl_out <= '010010000000000';
						end if;
						
					if (opcode = ("1010" ); --store byte index, SBX 
							ctrl_out <= '010110000010000';
						end if;	
				------------------------ EX ----------------------------------
				when EX =>
					if opcode = "00--" | "0100" then 
						ctrl_out <= "0100001010100000"
						
					
						
						
				when others =>

		end case;
	end process;
			
			
end Behavioral;


