library ieee;
use ieee.std_logic_1164.all;

PACKAGE alu_pkg IS
------------------------------------ D_register ----------------------------------------
	COMPONENT  D_register 
		GENERIC(N : INTEGER := 8);
		PORT( 	D						: IN STD_LOGIC_VECTOR(N-1 DOWNTO 0); 
				Aresetn, Clock, Enable 	: IN STD_LOGIC; 
				Q 						: OUT STD_LOGIC_VECTOR(N-1 DOWNTO 0)
		); 
	END COMPONENT;
	
	------------------------------------ mux21 ----------------------------------------
	COMPONENT mux21 IS 
		PORT (	w0, w1 : IN STD_LOGIC_VECTOR (7 downto 0);
				s : IN STD_LOGIC;
				f : OUT STD_LOGIC_VECTOR (7 downto 0)
		);
	END COMPONENT;
	
	------------------------------------ mux41 ----------------------------------------
	component mux41 
		port(	w0, w1, w2, w3 	: in STD_LOGIC_VECTOR (7 downto 0);
				s 				: in STD_LOGIC_VECTOR (1 downto 0);
				f 				: out STD_LOGIC_VECTOR (7 downto 0)
		);
	end component;
	
	------------------------------------ mem_array ----------------------------------------
	component mem_array 
		generic(DATA_WIDTH	: integer := 12;
				ADDR_WIDTH	: integer := 8;
				INIT_FILE	: string  := "inst_mem.mif"
		);
		Port(	ADDR 	: in  STD_LOGIC_VECTOR (ADDR_WIDTH-1 downto 0);
				DATAIN 	: in STD_LOGIC_VECTOR (DATA_WIDTH-1 downto 0);
				CLK 	: in STD_LOGIC;
				WE 		: in STD_LOGIC;
				OUTPUT 	: out  STD_LOGIC_VECTOR (DATA_WIDTH-1 downto 0)
		);
	end component;
	
	------------------------------------ FA ----------------------------------------
	component FA 
		port(	Cin		:	in	std_logic;
				A, B	:	in	std_logic;
				S		:	out std_logic;
				Cout	:	out	std_logic
		);
	end component;
	
	------------------------------------ alu_wRCA ----------------------------------------
	component alu_wRCA 
		port(ALU_inA, ALU_inB			:	in std_logic_vector(7 downto 0); 	--8 Bit input value.
			ALU_out						: 	out std_logic_vector(7 downto 0); 	--8 Bit output value.
			Carry, NotEq, Eq, isOutZero	: 	out std_logic;						--1 Bit on each of these signals. Eventually stored in FReg
			operation					: 	in std_logic_vector(1 downto 0) 	-- Mux select. OP: 00 ADD, 01 SUB, 10 AND, 11 NOT
		);
	end component;
	
	------------------------------------ alu_wCLA ----------------------------------------
	component alu_wCLA is
		port(
			ALU_inA, ALU_inB			:	in std_logic_vector(7 downto 0); 	
			ALU_out						: 	out std_logic_vector(7 downto 0); 	
			Carry, NotEq, Eq, isOutZero	: 	out std_logic;						
			operation					: 	in std_logic_vector(1 downto 0) 	
		);
	end component;
	
	------------------------------------ CMP ----------------------------------------
	component CMP 
		port(	A, B : in std_logic_vector(7 downto 0);
				Eq, NotEq : out std_logic
		);
	end component;
	
	------------------------------------ CLA ----------------------------------------
	component CLA is
		generic(N : integer := 8);
		port (	S : out std_logic_vector(N-1 downto 0);
				A : in std_logic_vector(N-1 downto 0);
				B : in std_logic_vector(N-1 downto 0);
				Cin : in std_logic;
				Cout : out std_logic
		);
	end component;
	
	------------------------------------ RCA ----------------------------------------
	component RCA is
		generic(N : integer := 8);
		port (	S : out std_logic_vector(N-1 downto 0);
				A : in std_logic_vector(N-1 downto 0);
				B : in std_logic_vector(N-1 downto 0);
				Cin : in std_logic;
				Cout : out std_logic
		);
	end component;
	
	------------------------------------ procBus ----------------------------------------
	component procBus is
		Port ( 	INSTRUCTION : 	in STD_LOGIC_VECTOR (7 downto 0);
				DATA : 			in STD_LOGIC_VECTOR (7 downto 0);
				ACC : 			in STD_LOGIC_VECTOR (7 downto 0);
				EXTDATA : 		in STD_LOGIC_VECTOR (7 downto 0);
				OUTPUT : 		out STD_LOGIC_VECTOR (7 downto 0);
				ERR : 			out STD_LOGIC;
				instrSEL : 		in STD_LOGIC;
				dataSEL : 		in STD_LOGIC;
				accSEL : 		in STD_LOGIC;
				extdataSEL : 	in STD_LOGIC
		);
	end component;
END alu_pkg;