--! Bus 
LIBRARY ieee; 
USE ieee.std_logic_1164.all; 
--USE ieee.numeric_std.all;
USE work.alu_pkg.mux41;

entity procBus is
	Port ( 	INSTRUCTION : 	in STD_LOGIC_VECTOR (7 downto 0);
			DATA : 			in STD_LOGIC_VECTOR (7 downto 0);
			ACC : 			in STD_LOGIC_VECTOR (7 downto 0);
			EXTDATA : 		in STD_LOGIC_VECTOR (7 downto 0);
			OUTPUT : 		out STD_LOGIC_VECTOR (7 downto 0);
			ERR : 			out STD_LOGIC;
			instrSEL : 		in STD_LOGIC;
			dataSEL : 		in STD_LOGIC;
			accSEL : 		in STD_LOGIC;
			extdataSEL : 	in STD_LOGIC
	);
end procBus;

architecture struct of procBus is
	signal ctrl : std_logic_vector(3 downto 0);	
	signal errSel : std_logic_vector(2 downto 0);
begin
	-- 4:2 encoder for mux select signals
	ctrl <= instrSEL & dataSEL & accSEL & extdataSEL;
	ERR <= errSel(2);
	
	-- Use concatenated Error and select signals in order to implement parallel mux!
	with ctrl select 
		errSel <= "000" when "1000", -- instrSEL
				"001" when "0100",-- dataSEL
				"010" when "0010",-- accSEL
				"011" when "0001",-- extdataSEL
				"011"		when "0000",
				"111" when others; -- error deafaults to extdataSEL!!!
		
------------------------- 4:1 MUX -------------------------------		
	mux : mux41 PORT MAP(	
		a	=> ACC, 
		b 	=> EXTDATA,
		c 	=> INSTRUCTION,
		d 	=> DATA,
		sel => errSel(1 downto 0),
		output => OUTPUT 
		);
end architecture;