LIBRARY ieee;
USE ieee.std_logic_1164.all;

PACKAGE alu_pkg IS

	COMPONENT  D_register 
		GENERIC ( N : INTEGER := 8);
		PORT ( 	D						: IN STD_LOGIC_VECTOR(N-1 DOWNTO 0); 
				Aresetn, Clock, Enable 	: IN STD_LOGIC; 
				Q 						: OUT STD_LOGIC_VECTOR(N-1 DOWNTO 0)
		); 
	END COMPONENT;

	component mux41 
		port(	a, b, c, d : in STD_LOGIC_VECTOR (7 downto 0);
				sel : in  STD_LOGIC_VECTOR (1 downto 0);
				output : out  STD_LOGIC_VECTOR (7 downto 0)
		);
	end component;

	component mem_array 
		generic ( 	DATA_WIDTH: integer := 12;
					ADDR_WIDTH: integer := 8;
					INIT_FILE: string 	:= "inst_mem.mif"
				);
		Port (	ADDR : in  STD_LOGIC_VECTOR (ADDR_WIDTH-1 downto 0);
				DATAIN : in STD_LOGIC_VECTOR (DATA_WIDTH-1 downto 0);
				CLK : in STD_LOGIC;
				WE : in STD_LOGIC;
				OUTPUT : out  STD_LOGIC_VECTOR (DATA_WIDTH-1 downto 0));
	end component;

	component FA 
		port(	Cin		:	in	std_logic;
				A, B	:	in	std_logic;
				S		:	out std_logic;
				Cout	:	out	std_logic
		);
	end component;
	
	component alu_wRCA 
		port(
			ALU_inA, ALU_inB			:	in std_logic_vector(7 downto 0); 	--8 Bit input value.
			ALU_out						: 	out std_logic_vector(7 downto 0); 	--8 Bit output value.
			Carry, NotEq, Eq, isOutZero	: 	out std_logic;						--1 Bit on each of these signals. Eventually stored in FReg
			operation					: 	in std_logic_vector(1 downto 0) 	-- Mux select. OP: 00 ADD, 01 SUB, 10 AND, 11 NOT
					);
	end component;
	
	component CMP 
	port(
			A, B : in std_logic_vector(7 downto 0);
			Eq, NotEq : out std_logic
			);
	end component;
	
END alu_pkg;