/*
 * File:   tilluft.c
 * Author: john3
 *
 * Created on den 24 april 2016, 12:17
 */

//Header Filer--------------------------------------------------------
#include <xc.h>
#include "tilluft.h"

//Globala Variabler---------------------------------------------------
extern unsigned char therm;
extern unsigned char halfsec;
extern unsigned char alarm;

//Funktioner----------------------------------------------------------
void init() {
    OSCCON = 0b01101000;  //Fosc = 4MHz == 1101
    LATA=0x00; //Nollstller alla bitar i PORTA
    LATB=0x00; //Nollstller alla bitar i PORTB 
    ANSELA = 0b00000010;    //0 = Digital, 1 = Analog
    ANSELB = 0b00000000;
    TRISA  = 0b00110010;    //Ingngar: MCLR(RA5), T0CKI(RA4), AN1(RA1), AN2(RA2)
    TRISB  = 0b00000000;    //Stter alla ben p PORTB till utgngar.
    
    //Pulsrknare-----------------------------------------------------------------------------
    TMR0 = 0x00;
    CPSCON0 = 0X00;     //select ext. clock source
    OPTION_REG = 0b00101000;     //ext. clock source, rising edge, prescaler disabled(1:1)
    
    //Timer1 & overflow interrupt---------------------------------------------------------------
    T1CON = 0b00110001;    //Clock Source=Fosc/4, Prescaler 1:8, Internal Clock, Timer1 ON
    T1GCON =0b00000000;     //Gate control register; all fucntions disabled.
    TMR1L = 0xDF;        
    TMR1H = 0x0B;
    PIE1 = 0x01;         //TMR1 overflow interrupt enable
    INTCON = 0b11000000; //Global and peripheral interrupt enable
    
    //ADC-------------------------------------------------------------------------------------
    ADCON1 = 0b01000000;     //Vnsterjusterat, A/D Conversion Clock Fosc/4
    ADCON0 = 0b00000001;     //AN1, ADON     
    
    //Pulse Width Modulation----------------------------------------------------------------
    //OBS! CCP3(RA3) anvnds till PWM!
    CCP3CON = 0b00001100;   //2 LSB frkastade, CCP3 i PWM mode
    CCPTMRS = 0x00;          //Vlj s att CCP3 anvnder Timer 2.
    PR2 = 254;              //D CCPR3L := 255 nskar vi tp := Tpwm, drfr 1020 := (PR2+1)*4
    T2CON = 0b00000110;      //Timer 2 ON, Prescaler=16. Ger Fpwm = 245 Hz.
}

char AD_omv(char ADkanal){
    ADCON0 = (ADCON0 & 0b10000011) | (ADkanal << 2);  //Aktiverar rtt AD kanal.
    __delay_us(5);              //delay 5us fr Tacq.
    ADCON0bits.GO = 1;       //AD omvandling startar.
    while(ADCON0bits.GO);    //Vntar p registertillstndet att frndras.
    
    return ADRESH;          //Returnerar 8 MSB.
}

void BIN_out(unsigned char arvarde){    
    //b3
    LATBbits.LATB3 = arvarde / 8;
    arvarde %= 8;
    //b2
    LATBbits.LATB2 = arvarde / 4;
    arvarde %= 4;
    //b1
    LATBbits.LATB1 = arvarde / 2;
    arvarde %= 2;
    //b0
    LATBbits.LATB0 = arvarde;
}

void BCD_out(unsigned char arvarde){
    
    unsigned char tior, ettor;
    
    tior = arvarde / 10;
    if (tior)
    {
        BL1 = 1;    //Om tior r 0 (t.ex. 00 -09) s slcks den hga displayen.
    }else{
        BL1 = 0;
    }
    
    ettor = arvarde % 10;
    
    D3 = ettor / 8;
    ettor %= 8;
    D2 = ettor / 4;
    ettor %= 4;
    D1 = ettor / 2;
    ettor %= 2;
    D0 = ettor;
}

void interrupt isr(void){
    if (PIR1bits.TMR1IF && PIE1bits.TMR1IE)     //Vilken interrupt r aktuell
  {
        halfsec++;              //Vi kan bara rkna upp till ~0,5s ty hrdvarubegrnsningar vid 4MHz. 
        
        if(alarm)
            BL0 = !BL0;           //Display 0 (ettor) blinkar varje halvsekund. Anvnder Blank Enable toggle.
        
        TMR1L = 0xDF;               //terstller TMR1 s att
        TMR1H = 0x0B;               //delay == 0,5 s
        
        PIR1bits.TMR1IF = 0;        //Nollstller interruptflaggan
    }
}

unsigned char measure_rp5s(void){
    unsigned char arvarde;
       
    arvarde = TMR0 / 15;    //15 pulser i ett varv. Antal varv under 5 sekunder.
    //TMR0 = TMR0 % 15;       //TMR0 fr vrdet av resten, vilket ger en noggrannare mtning n om vi slopar resten. ALT. TMR0 = 0;

    return arvarde;
}

void therm_check(void){
    
    therm = AD_omv(2);          //Ls av NTC motstnd. Mste kalibreras!!!
    
    if (therm >= THERM_MAX)
    {
        BL1 = 0;    //Gr att display 1 (tior) stnger av
        LT = 0;  //Initiera LAMP TEST p display 0 (ettor), dvs visa en '8'
        alarm = 1;
    }else{
        BL0 = 1; //Ifall vi har togglat display 0 av , mste vi tvinga p den.
        BL1 = 1;
        LT = 1;
        alarm = 0;
    }
}
