#include <stdio.h>
#include <stdint.h>

void testEndianness(void) {
    //uint32_t är en integer som är garanterat 32 bitar. Finns i stdint.h 
    //(som inte alltid finns tillgänglig.)
    uint32_t testInt = 0x01020304;
    char *ptr = (char *) &testInt;
    int i;
    printf("Examining the int testInt, with value %#x at address %#x\n", 
        testInt, &testInt);
    printf("Showing one byte of testInt at a time\n");
    for (i = 0; i < sizeof(int); i++) {
        printf("ptr points at value : %#4x, at address: %#x\n", *ptr, ptr);
        ptr++;
    }
    printf("If 0x1 showed up at the lowest address, the system is big-endian,\notherwise little-endian.\n");
    printf("\n");
}

void lookAtStack(int a, int b, int c) {
    int local = 0xFAFAFAFA;
    int *ptr = &local;
    int i;
    printf("Showing part of the stack, one int at a time\n");
    for(i = 0; i < 16; i++) {
        printf("ptr points at value: %#12x, at address: %#x\n", *ptr, ptr);
        ptr++;
    }
    printf("\n");
    printf("\n");
}



int main(int argc, char **argv)
{
    testEndianness();
    printf("Start address of main : %#x\n", main);
    lookAtStack(0xDEAD, 0xBEEF, 0xFEEDBEEF);
    printf("Can you find the return address and the arguments in the stack printout?");    

    return 0;
}
